unit FrmStore;

{

   COPYRIGHT 2013 .. 2019 Blue Hell / Jan Punter

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2 as
  published by the Free Software Foundation;

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  For all listed email addresses :

    _dot. to be substituted by a dot      '.'
    2@t2  to be substituted by an at sign '@'


  Blue Hell is a trade mark owned by

    Jan Punter
    https://www.bluehell.nl/
    jan2@t2mail_dot_bluehell_dot_nl
}

interface

uses

  WinApi.Windows, WinApi.Messages,

  System.SysUtils, System.Classes, System.Generics.Collections, System.IOUtils, System.Types,

  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,   Vcl.ExtCtrls, Vcl.StdCtrls, Vcl.ComCtrls, Vcl.Buttons,
  Vcl.Imaging.jpeg, Vcl.ImgList, Vcl.Samples.Spin, Vcl.Imaging.pngimage, Vcl.Menus,


  Globals, KnobsUtils, knobs2013, Led, MarkdownProcessor,

  FrmSplash, System.ImageList;


type

  EStore = class( EXception);

  TFormStore = class(TForm)
    ImageListEnvOutputType: TImageList;
    ImageListGateTypes: TImageList;
    ImageListLfoOutputType: TImageList;
    ImageListLogLinExpSTypeAttack: TImageList;
    ImageListLogLinExpSTypeRelease: TImageList;
    ImageListMuteTypes: TImageList;
    ImageListSoloTypes: TImageList;
    ImageListStandardLFOWaveShapes: TImageList;
    ImageListStandardWaveShapes: TImageList;
    ImageListPulseModes: TImageList;
    adc: TKnobsModule;
    adc_editlabel: TKnobsEditLabel;
    adc_in: TKnobsInput;
    adc_indicator_out0: TKnobsIndicator;
    adc_indicator_out10: TKnobsIndicator;
    adc_indicator_out11: TKnobsIndicator;
    adc_indicator_out12: TKnobsIndicator;
    adc_indicator_out13: TKnobsIndicator;
    adc_indicator_out14: TKnobsIndicator;
    adc_indicator_out15: TKnobsIndicator;
    adc_indicator_out1: TKnobsIndicator;
    adc_indicator_out2: TKnobsIndicator;
    adc_indicator_out3: TKnobsIndicator;
    adc_indicator_out4: TKnobsIndicator;
    adc_indicator_out5: TKnobsIndicator;
    adc_indicator_out6: TKnobsIndicator;
    adc_indicator_out7: TKnobsIndicator;
    adc_indicator_out8: TKnobsIndicator;
    adc_indicator_out9: TKnobsIndicator;
    adc_out0: TKnobsOutput;
    adc_out10: TKnobsOutput;
    adc_out11: TKnobsOutput;
    adc_out12: TKnobsOutput;
    adc_out13: TKnobsOutput;
    adc_out14: TKnobsOutput;
    adc_out15: TKnobsOutput;
    adc_out1: TKnobsOutput;
    adc_out2: TKnobsOutput;
    adc_out3: TKnobsOutput;
    adc_out4: TKnobsOutput;
    adc_out5: TKnobsOutput;
    adc_out6: TKnobsOutput;
    adc_out7: TKnobsOutput;
    adc_out8: TKnobsOutput;
    adc_out9: TKnobsOutput;
    adc_textlabel_0: TKnobsTextLabel;
    adc_textlabel_10: TKnobsTextLabel;
    adc_textlabel_11: TKnobsTextLabel;
    adc_textlabel_12: TKnobsTextLabel;
    adc_textlabel_13: TKnobsTextLabel;
    adc_textlabel_14: TKnobsTextLabel;
    adc_textlabel_15: TKnobsTextLabel;
    adc_textlabel_1: TKnobsTextLabel;
    adc_textlabel_2: TKnobsTextLabel;
    adc_textlabel_3: TKnobsTextLabel;
    adc_textlabel_4: TKnobsTextLabel;
    adc_textlabel_5: TKnobsTextLabel;
    adc_textlabel_6: TKnobsTextLabel;
    adc_textlabel_7: TKnobsTextLabel;
    adc_textlabel_8: TKnobsTextLabel;
    adc_textlabel_9: TKnobsTextLabel;
    adc_textlabel_in: TKnobsTextLabel;
    adder: TKnobsModule;
    adder_editlabel: TKnobsEditLabel;
    adder_in1: TKnobsInput;
    adder_in2: TKnobsInput;
    adder_in3: TKnobsInput;
    adder_in4: TKnobsInput;
    adder_mute: TKnobsSelector;
    adder_out: TKnobsOutput;
    allpass: TKnobsModule;
    allpass_display_length: TKnobsDisplay;
    allpass_editlabel: TKnobsEditLabel;
    allpass_in: TKnobsInput;
    allpass_indicator_clip: TKnobsIndicator;
    allpass_k: TKnobsSmallKnob;
    allpass_kmod: TKnobsInput;
    allpass_kmodamt: TKnobsSmallKnob;
    allpass_length: TKnobsSmallKnob;
    allpass_out: TKnobsOutput;
    allpass_textlabel_k: TKnobsTextLabel;
    allpass_textlabel_kclip: TKnobsTextLabel;
    allpass_textlabel_kmod: TKnobsTextLabel;
    allpass_textlabel_length: TKnobsTextLabel;
    amplifier: TKnobsModule;
    amplifier_display_gain: TKnobsDisplay;
    amplifier_editlabel: TKnobsEditLabel;
    amplifier_gain: TKnobsSmallKnob;
    amplifier_in1: TKnobsInput;
    amplifier_in2: TKnobsInput;
    amplifier_in3: TKnobsInput;
    amplifier_in4: TKnobsInput;
    amplifier_mode: TKnobsSelector;
    amplifier_mute: TKnobsSelector;
    amplifier_out1: TKnobsOutput;
    amplifier_out2: TKnobsOutput;
    amplifier_out3: TKnobsOutput;
    amplifier_out4: TKnobsOutput;
    attractor: TKnobsModule;
    attractor_display_frequency: TKnobsDisplay;
    attractor_editlabel: TKnobsEditLabel;
    attractor_fm: TKnobsInput;
    attractor_fmlevel: TKnobsSmallKnob;
    attractor_freq: TKnobsInput;
    attractor_frequency: TKnobsSmallKnob;
    attractor_mode: TKnobsSelector;
    attractor_mute: TKnobsSelector;
    attractor_outx: TKnobsOutput;
    attractor_outy: TKnobsOutput;
    attractor_outz: TKnobsOutput;
    attractor_textlabel_fm: TKnobsTextLabel;
    attractor_textlabel_freq: TKnobsTextLabel;
    attractor_textlabel_x: TKnobsTextLabel;
    attractor_textlabel_y: TKnobsTextLabel;
    attractor_textlabel_z: TKnobsTextLabel;
    attractorlfo: TKnobsModule;
    attractorlfo_display_frequency: TKnobsDisplay;
    attractorlfo_editlabel: TKnobsEditLabel;
    attractorlfo_fm: TKnobsInput;
    attractorlfo_fmlevel: TKnobsSmallKnob;
    attractorlfo_frequency: TKnobsSmallKnob;
    attractorlfo_indicator_outx: TKnobsIndicator;
    attractorlfo_indicator_outy: TKnobsIndicator;
    attractorlfo_indicator_outz: TKnobsIndicator;
    attractorlfo_mode: TKnobsSelector;
    attractorlfo_mute: TKnobsSelector;
    attractorlfo_outputtype: TKnobsSelector;
    attractorlfo_outx: TKnobsOutput;
    attractorlfo_outy: TKnobsOutput;
    attractorlfo_outz: TKnobsOutput;
    attractorlfo_range: TKnobsSelector;
    attractorlfo_textlabel_fm: TKnobsTextLabel;
    attractorlfo_textlabel_outx: TKnobsTextLabel;
    attractorlfo_textlabel_outy: TKnobsTextLabel;
    attractorlfo_textlabel_outz: TKnobsTextLabel;
    audioin: TKnobsModule;
    audioin_editlabel: TKnobsEditLabel;
    audioin_out1: TKnobsOutput;
    audioin_out2: TKnobsOutput;
    audioin_out3: TKnobsOutput;
    audioin_out4: TKnobsOutput;
    audioin_out5: TKnobsOutput;
    audioin_out6: TKnobsOutput;
    audioin_out7: TKnobsOutput;
    audioin_out8: TKnobsOutput;
    audioin_textlabel: TKnobsTextLabel;
    audiomix: TKnobsModule;
    audiomix_mute1: TKnobsSelector;
    audiomix_mute2: TKnobsSelector;
    audiomix_mute3: TKnobsSelector;
    audiomix_mute4: TKnobsSelector;
    audiomix_mute5: TKnobsSelector;
    audiomix_mute6: TKnobsSelector;
    audiomix_mute7: TKnobsSelector;
    audiomix_mute8: TKnobsSelector;
    audiomix_solo1: TKnobsSelector;
    audiomix_solo2: TKnobsSelector;
    audiomix_solo3: TKnobsSelector;
    audiomix_solo4: TKnobsSelector;
    audiomix_solo5: TKnobsSelector;
    audiomix_solo6: TKnobsSelector;
    audiomix_solo7: TKnobsSelector;
    audiomix_solo8: TKnobsSelector;
    audioout: TKnobsModule;
    audioout_editlabel: TKnobsEditLabel;
    audioout_in1: TKnobsInput;
    audioout_in2: TKnobsInput;
    audioout_in3: TKnobsInput;
    audioout_in4: TKnobsInput;
    audioout_in5: TKnobsInput;
    audioout_in6: TKnobsInput;
    audioout_in7: TKnobsInput;
    audioout_in8: TKnobsInput;
    audioout_textlabel: TKnobsTextLabel;
    avg: TKnobsModule;
    avg_alpha: TKnobsSmallKnob;
    avg_alphamod: TKnobsInput;
    avg_alphamodamt: TKnobsSmallKnob;
    avg_editlabel: TKnobsEditLabel;
    avg_hp: TKnobsOutput;
    avg_in: TKnobsInput;
    avg_lp: TKnobsOutput;
    avg_textlabel_in: TKnobsTextLabel;
    avg_textlabel_invout: TKnobsTextLabel;
    avg_textlabel_out: TKnobsTextLabel;
    buttons4: TKnobsModule;
    buttons4_display1: TKnobsDisplay;
    buttons4_display2: TKnobsDisplay;
    buttons4_display3: TKnobsDisplay;
    buttons4_display4: TKnobsDisplay;
    buttons4_editlabel: TKnobsEditLabel;
    buttons4_indicator_1: TKnobsIndicator;
    buttons4_indicator_2: TKnobsIndicator;
    buttons4_indicator_3: TKnobsIndicator;
    buttons4_indicator_4: TKnobsIndicator;
    buttons4_out1: TKnobsOutput;
    buttons4_out2: TKnobsOutput;
    buttons4_out3: TKnobsOutput;
    buttons4_out4: TKnobsOutput;
    buttons4_sw1: TKnobsSelector;
    buttons4_sw2: TKnobsSelector;
    buttons4_sw3: TKnobsSelector;
    buttons4_sw4: TKnobsSelector;
    clockeddelay16: TKnobsModule;
    clockeddelay16_clock: TKnobsInput;
    clockeddelay16_editlabel: TKnobsEditLabel;
    clockeddelay16_in: TKnobsInput;
    clockeddelay16_indicator_clock: TKnobsIndicator;
    clockeddelay16_out0: TKnobsOutput;
    clockeddelay16_out10: TKnobsOutput;
    clockeddelay16_out11: TKnobsOutput;
    clockeddelay16_out12: TKnobsOutput;
    clockeddelay16_out13: TKnobsOutput;
    clockeddelay16_out14: TKnobsOutput;
    clockeddelay16_out15: TKnobsOutput;
    clockeddelay16_out1: TKnobsOutput;
    clockeddelay16_out2: TKnobsOutput;
    clockeddelay16_out3: TKnobsOutput;
    clockeddelay16_out4: TKnobsOutput;
    clockeddelay16_out5: TKnobsOutput;
    clockeddelay16_out6: TKnobsOutput;
    clockeddelay16_out7: TKnobsOutput;
    clockeddelay16_out8: TKnobsOutput;
    clockeddelay16_out9: TKnobsOutput;
    clockeddelay16_rate: TKnobsSelector;
    clockeddelay16_symbol_trig: TImage;
    clockeddelay16_textlabel_0: TKnobsTextLabel;
    clockeddelay16_textlabel_10: TKnobsTextLabel;
    clockeddelay16_textlabel_11: TKnobsTextLabel;
    clockeddelay16_textlabel_12: TKnobsTextLabel;
    clockeddelay16_textlabel_13: TKnobsTextLabel;
    clockeddelay16_textlabel_14: TKnobsTextLabel;
    clockeddelay16_textlabel_15: TKnobsTextLabel;
    clockeddelay16_textlabel_1: TKnobsTextLabel;
    clockeddelay16_textlabel_2: TKnobsTextLabel;
    clockeddelay16_textlabel_3: TKnobsTextLabel;
    clockeddelay16_textlabel_4: TKnobsTextLabel;
    clockeddelay16_textlabel_5: TKnobsTextLabel;
    clockeddelay16_textlabel_6: TKnobsTextLabel;
    clockeddelay16_textlabel_7: TKnobsTextLabel;
    clockeddelay16_textlabel_8: TKnobsTextLabel;
    clockeddelay16_textlabel_9: TKnobsTextLabel;
    clockeddelay16_textlabel_clock: TKnobsTextLabel;
    clockeddelay16_textlabel_in: TKnobsTextLabel;
    clockeddelay: TKnobsModule;
    clockeddelay_clock: TKnobsInput;
    clockeddelay_display_length: TKnobsDisplay;
    clockeddelay_editlabel: TKnobsEditLabel;
    clockeddelay_in: TKnobsInput;
    clockeddelay_indicator_clock: TKnobsIndicator;
    clockeddelay_length: TKnobsSmallKnob;
    clockeddelay_out: TKnobsOutput;
    clockeddelay_symbol_clock: TImage;
    clockeddelay_textlabel_clock: TKnobsTextLabel;
    clockeddelay_textlabel_in: TKnobsTextLabel;
    clockeddelay_textlabel_length: TKnobsTextLabel;
    clockgen: TKnobsModule;
    clockgen_16: TKnobsOutput;
    clockgen_96: TKnobsOutput;
    clockgen_display_div: TKnobsDisplay;
    clockgen_display_tempo: TKnobsDisplay;
    clockgen_div: TKnobsSmallKnob;
    clockgen_editlabel: TKnobsEditLabel;
    clockgen_indicator_res: TKnobsIndicator;
    clockgen_indicator_sync: TKnobsIndicator;
    clockgen_mute: TKnobsSelector;
    clockgen_phase16: TKnobsOutput;
    clockgen_phase96: TKnobsOutput;
    clockgen_res: TKnobsInput;
    clockgen_swing: TKnobsSmallKnob;
    clockgen_symbol_trig: TImage;
    clockgen_sync: TKnobsOutput;
    clockgen_tempo: TKnobsSmallKnob;
    clockgen_tempoex: TKnobsInput;
    clockgen_textlabel_16: TKnobsTextLabel;
    clockgen_textlabel_96: TKnobsTextLabel;
    clockgen_textlabel_act: TKnobsTextLabel;
    clockgen_textlabel_res: TKnobsTextLabel;
    clockgen_textlabel_swing: TKnobsTextLabel;
    clockgen_textlabel_sync: TKnobsTextLabel;
    clockgen_textlabel_syncdiv: TKnobsTextLabel;
    clockgen_textlabel_tempo: TKnobsTextLabel;
    compare: TKnobsModule;
    compare_display_range: TKnobsDisplay;
    compare_editlabel: TKnobsEditLabel;
    compare_in1: TKnobsInput;
    compare_in2: TKnobsInput;
    compare_indicator_equal: TKnobsIndicator;
    compare_indicator_less: TKnobsIndicator;
    compare_indicator_more: TKnobsIndicator;
    compare_outequal: TKnobsOutput;
    compare_outless: TKnobsOutput;
    compare_outmore: TKnobsOutput;
    compare_range: TKnobsSmallKnob;
    compare_textlabel_equal: TKnobsTextLabel;
    compare_textlabel_ins: TKnobsTextLabel;
    compare_textlabel_less: TKnobsTextLabel;
    compare_textlabel_more: TKnobsTextLabel;
    compare_textlabel_range: TKnobsTextLabel;
    compressor: TKnobsModule;
    compressor_attack: TKnobsSmallKnob;
    compressor_bypass: TKnobsSelector;
    compressor_display_attack: TKnobsDisplay;
    compressor_display_decay: TKnobsDisplay;
    compressor_display_gain: TKnobsDisplay;
    compressor_display_preamp: TKnobsDisplay;
    compressor_display_reflevel: TKnobsDisplay;
    compressor_editlabel: TKnobsEditLabel;
    compressor_env: TKnobsOutput;
    compressor_gain: TKnobsSmallKnob;
    compressor_inl: TKnobsInput;
    compressor_inr: TKnobsInput;
    compressor_mode: TKnobsSelector;
    compressor_outl: TKnobsOutput;
    compressor_outr: TKnobsOutput;
    compressor_preamp: TKnobsSmallKnob;
    compressor_reflevel: TKnobsSmallKnob;
    compressor_release: TKnobsSmallKnob;
    compressor_textlabel_attack: TKnobsTextLabel;
    compressor_textlabel_decay: TKnobsTextLabel;
    compressor_textlabel_env: TKnobsTextLabel;
    compressor_textlabel_gain: TKnobsTextLabel;
    compressor_textlabel_preamp: TKnobsTextLabel;
    compressor_textlabel_reflevel: TKnobsTextLabel;
    compressor_indicator_gain: TKnobsIndicatorText;
    compressor_side: TKnobsInput;
    compressor_sidesel: TKnobsSelector;
    compressor_acdc: TKnobsSelector;
    compressor_outs: TKnobsOutput;
    constant: TKnobsModule;
    constant_display_value: TKnobsDisplay;
    constant_editlabel: TKnobsEditLabel;
    constant_mode: TKnobsSelector;
    constant_mute: TKnobsSelector;
    constant_out: TKnobsOutput;
    constant_value: TKnobsSmallKnob;
    control1_tabsheet: TTabSheet;
    convoder: TKnobsModule;
    convoder_carrier: TKnobsInput;
    convoder_carrierlev: TKnobsSmallKnob;
    convoder_editlabel: TKnobsEditLabel;
    convoder_modulator: TKnobsInput;
    convoder_modulatorlev: TKnobsSmallKnob;
    convoder_mute: TKnobsSelector;
    convoder_out: TKnobsOutput;
    convoder_size: TKnobsSelector;
    convoder_textlabel_carrier: TKnobsTextLabel;
    convoder_textlabel_fftsize: TKnobsTextLabel;
    convoder_textlabel_modulator: TKnobsTextLabel;
    count: TKnobsModule;
    count_count: TKnobsInput;
    count_display_value: TKnobsDisplay;
    count_editlabel: TKnobsEditLabel;
    count_res: TKnobsInput;
    count_reset: TKnobsSelector;
    count_symbol_count: TImage;
    count_symbol_res: TImage;
    count_textlabel_count: TKnobsTextLabel;
    count_textlabel_res: TKnobsTextLabel;
    counter: TKnobsModule;
    counter_dir: TKnobsInput;
    counter_editlabel: TKnobsEditLabel;
    counter_indicator_dir: TKnobsIndicator;
    counter_indicator_out0: TKnobsIndicator;
    counter_indicator_out10: TKnobsIndicator;
    counter_indicator_out11: TKnobsIndicator;
    counter_indicator_out12: TKnobsIndicator;
    counter_indicator_out13: TKnobsIndicator;
    counter_indicator_out14: TKnobsIndicator;
    counter_indicator_out15: TKnobsIndicator;
    counter_indicator_out1: TKnobsIndicator;
    counter_indicator_out2: TKnobsIndicator;
    counter_indicator_out3: TKnobsIndicator;
    counter_indicator_out4: TKnobsIndicator;
    counter_indicator_out5: TKnobsIndicator;
    counter_indicator_out6: TKnobsIndicator;
    counter_indicator_out7: TKnobsIndicator;
    counter_indicator_out8: TKnobsIndicator;
    counter_indicator_out9: TKnobsIndicator;
    counter_indicator_reset: TKnobsIndicator;
    counter_indicator_trig: TKnobsIndicator;
    counter_mode: TKnobsSelector;
    counter_out0: TKnobsOutput;
    counter_out10: TKnobsOutput;
    counter_out11: TKnobsOutput;
    counter_out12: TKnobsOutput;
    counter_out13: TKnobsOutput;
    counter_out14: TKnobsOutput;
    counter_out15: TKnobsOutput;
    counter_out1: TKnobsOutput;
    counter_out2: TKnobsOutput;
    counter_out3: TKnobsOutput;
    counter_out4: TKnobsOutput;
    counter_out5: TKnobsOutput;
    counter_out6: TKnobsOutput;
    counter_out7: TKnobsOutput;
    counter_out8: TKnobsOutput;
    counter_out9: TKnobsOutput;
    counter_reset: TKnobsInput;
    counter_symbol_reset: TImage;
    counter_symbol_trig: TImage;
    counter_textlabel_10: TKnobsTextLabel;
    counter_textlabel_11: TKnobsTextLabel;
    counter_textlabel_12: TKnobsTextLabel;
    counter_textlabel_13: TKnobsTextLabel;
    counter_textlabel_14: TKnobsTextLabel;
    counter_textlabel_15: TKnobsTextLabel;
    counter_textlabel_16: TKnobsTextLabel;
    counter_textlabel_1: TKnobsTextLabel;
    counter_textlabel_2: TKnobsTextLabel;
    counter_textlabel_3: TKnobsTextLabel;
    counter_textlabel_4: TKnobsTextLabel;
    counter_textlabel_5: TKnobsTextLabel;
    counter_textlabel_6: TKnobsTextLabel;
    counter_textlabel_7: TKnobsTextLabel;
    counter_textlabel_8: TKnobsTextLabel;
    counter_textlabel_9: TKnobsTextLabel;
    counter_textlabel_dir: TKnobsTextLabel;
    counter_textlabel_reset: TKnobsTextLabel;
    counter_textlabel_trig: TKnobsTextLabel;
    counter_trig: TKnobsInput;
    cubicclip: TKnobsModule;
    cubicclip_alpha: TKnobsSmallKnob;
    cubicclip_display_alpha: TKnobsDisplay;
    cubicclip_display_hysteresis: TKnobsDisplay;
    cubicclip_editlabel: TKnobsEditLabel;
    cubicclip_hysteresis: TKnobsSmallKnob;
    cubicclip_in: TKnobsInput;
    cubicclip_mute: TKnobsSelector;
    cubicclip_out: TKnobsOutput;
    cubicclip_textlabel_alpha: TKnobsTextLabel;
    cubicclip_textlabel_hysteresis: TKnobsTextLabel;
    dac: TKnobsModule;
    dac_editlabel: TKnobsEditLabel;
    dac_in0: TKnobsInput;
    dac_in10: TKnobsInput;
    dac_in11: TKnobsInput;
    dac_in12: TKnobsInput;
    dac_in13: TKnobsInput;
    dac_in14: TKnobsInput;
    dac_in15: TKnobsInput;
    dac_in1: TKnobsInput;
    dac_in2: TKnobsInput;
    dac_in3: TKnobsInput;
    dac_in4: TKnobsInput;
    dac_in5: TKnobsInput;
    dac_in6: TKnobsInput;
    dac_in7: TKnobsInput;
    dac_in8: TKnobsInput;
    dac_in9: TKnobsInput;
    dac_indicator_in0: TKnobsIndicator;
    dac_indicator_in10: TKnobsIndicator;
    dac_indicator_in11: TKnobsIndicator;
    dac_indicator_in12: TKnobsIndicator;
    dac_indicator_in13: TKnobsIndicator;
    dac_indicator_in14: TKnobsIndicator;
    dac_indicator_in15: TKnobsIndicator;
    dac_indicator_in1: TKnobsIndicator;
    dac_indicator_in2: TKnobsIndicator;
    dac_indicator_in3: TKnobsIndicator;
    dac_indicator_in4: TKnobsIndicator;
    dac_indicator_in5: TKnobsIndicator;
    dac_indicator_in6: TKnobsIndicator;
    dac_indicator_in7: TKnobsIndicator;
    dac_indicator_in8: TKnobsIndicator;
    dac_indicator_in9: TKnobsIndicator;
    dac_out: TKnobsOutput;
    dac_textlabel_0: TKnobsTextLabel;
    dac_textlabel_10: TKnobsTextLabel;
    dac_textlabel_11: TKnobsTextLabel;
    dac_textlabel_12: TKnobsTextLabel;
    dac_textlabel_13: TKnobsTextLabel;
    dac_textlabel_14: TKnobsTextLabel;
    dac_textlabel_15: TKnobsTextLabel;
    dac_textlabel_1: TKnobsTextLabel;
    dac_textlabel_2: TKnobsTextLabel;
    dac_textlabel_3: TKnobsTextLabel;
    dac_textlabel_4: TKnobsTextLabel;
    dac_textlabel_5: TKnobsTextLabel;
    dac_textlabel_6: TKnobsTextLabel;
    dac_textlabel_7: TKnobsTextLabel;
    dac_textlabel_8: TKnobsTextLabel;
    dac_textlabel_9: TKnobsTextLabel;
    dac_textlabel_out: TKnobsTextLabel;
    delay8: TKnobsModule;
    delay8_delay1: TKnobsInput;
    delay8_delay2: TKnobsInput;
    delay8_delay3: TKnobsInput;
    delay8_delay4: TKnobsInput;
    delay8_delay5: TKnobsInput;
    delay8_delay6: TKnobsInput;
    delay8_delay7: TKnobsInput;
    delay8_delay8: TKnobsInput;
    delay8_display_length: TKnobsDisplay;
    delay8_editlabel: TKnobsEditLabel;
    delay8_in: TKnobsInput;
    delay8_length: TKnobsSmallKnob;
    delay8_out1: TKnobsOutput;
    delay8_out2: TKnobsOutput;
    delay8_out3: TKnobsOutput;
    delay8_out4: TKnobsOutput;
    delay8_out5: TKnobsOutput;
    delay8_out6: TKnobsOutput;
    delay8_out7: TKnobsOutput;
    delay8_out8: TKnobsOutput;
    delay8_outfixed: TKnobsOutput;
    delay8_range: TKnobsSelector;
    delay8_textlabel_dly: TKnobsTextLabel;
    delay8_textlabel_fixed: TKnobsTextLabel;
    delay8_textlabel_in: TKnobsTextLabel;
    delay8_textlabel_maxdelay: TKnobsTextLabel;
    delay8_textlabel_out: TKnobsTextLabel;
    delay: TKnobsModule;
    delay_delay: TKnobsInput;
    delay_display_length: TKnobsDisplay;
    delay_editlabel: TKnobsEditLabel;
    delay_in: TKnobsInput;
    delay_length: TKnobsSmallKnob;
    delay_out: TKnobsOutput;
    delay_outfixed: TKnobsOutput;
    delay_range: TKnobsSelector;
    delay_tabseet: TTabSheet;
    delay_textlabel_delay: TKnobsTextLabel;
    delay_textlabel_fixed: TKnobsTextLabel;
    delay_textlabel_in: TKnobsTextLabel;
    delay_textlabel_maxdelay: TKnobsTextLabel;
    demux: TKnobsModule;
    demux_control: TKnobsInput;
    demux_editlabel: TKnobsEditLabel;
    demux_in: TKnobsInput;
    demux_indicator_0: TKnobsIndicator;
    demux_indicator_10: TKnobsIndicator;
    demux_indicator_11: TKnobsIndicator;
    demux_indicator_1: TKnobsIndicator;
    demux_indicator_2: TKnobsIndicator;
    demux_indicator_3: TKnobsIndicator;
    demux_indicator_4: TKnobsIndicator;
    demux_indicator_5: TKnobsIndicator;
    demux_indicator_6: TKnobsIndicator;
    demux_indicator_7: TKnobsIndicator;
    demux_indicator_8: TKnobsIndicator;
    demux_indicator_9: TKnobsIndicator;
    demux_out0: TKnobsOutput;
    demux_out10: TKnobsOutput;
    demux_out11: TKnobsOutput;
    demux_out1: TKnobsOutput;
    demux_out2: TKnobsOutput;
    demux_out3: TKnobsOutput;
    demux_out4: TKnobsOutput;
    demux_out5: TKnobsOutput;
    demux_out6: TKnobsOutput;
    demux_out7: TKnobsOutput;
    demux_out8: TKnobsOutput;
    demux_out9: TKnobsOutput;
    demux_textlabel_control: TKnobsTextLabel;
    demux_textlabel_xfade: TKnobsTextLabel;
    demux_xfade: TKnobsSmallKnob;
    dflipflop: TKnobsModule;
    dflipflop_clk: TKnobsInput;
    dflipflop_d: TKnobsInput;
    dflipflop_editlabel: TKnobsEditLabel;
    dflipflop_image: TImage;
    dflipflop_indicator_notq: TKnobsIndicator;
    dflipflop_indicator_q: TKnobsIndicator;
    dflipflop_notq: TKnobsOutput;
    dflipflop_outputtype: TKnobsSelector;
    dflipflop_q: TKnobsOutput;
    dflipflop_symbol_clk: TImage;
    digidemux: TKnobsModule;
    digidemux_editlabel: TKnobsEditLabel;
    digidemux_hold: TKnobsSelector;
    digidemux_in: TKnobsInput;
    digidemux_indicator_0: TKnobsIndicator;
    digidemux_indicator_1: TKnobsIndicator;
    digidemux_indicator_2: TKnobsIndicator;
    digidemux_indicator_3: TKnobsIndicator;
    digidemux_indicator_4: TKnobsIndicator;
    digidemux_indicator_5: TKnobsIndicator;
    digidemux_indicator_6: TKnobsIndicator;
    digidemux_indicator_7: TKnobsIndicator;
    digidemux_out0: TKnobsOutput;
    digidemux_out1: TKnobsOutput;
    digidemux_out2: TKnobsOutput;
    digidemux_out3: TKnobsOutput;
    digidemux_out4: TKnobsOutput;
    digidemux_out5: TKnobsOutput;
    digidemux_out6: TKnobsOutput;
    digidemux_out7: TKnobsOutput;
    digidemux_sel0: TKnobsInput;
    digidemux_sel1: TKnobsInput;
    digidemux_sel2: TKnobsInput;
    digimux: TKnobsModule;
    digimux_editlabel: TKnobsEditLabel;
    digimux_in0: TKnobsInput;
    digimux_in1: TKnobsInput;
    digimux_in2: TKnobsInput;
    digimux_in3: TKnobsInput;
    digimux_in4: TKnobsInput;
    digimux_in5: TKnobsInput;
    digimux_in6: TKnobsInput;
    digimux_in7: TKnobsInput;
    digimux_indicator_0: TKnobsIndicator;
    digimux_indicator_1: TKnobsIndicator;
    digimux_indicator_2: TKnobsIndicator;
    digimux_indicator_3: TKnobsIndicator;
    digimux_indicator_4: TKnobsIndicator;
    digimux_indicator_5: TKnobsIndicator;
    digimux_indicator_6: TKnobsIndicator;
    digimux_indicator_7: TKnobsIndicator;
    digimux_out: TKnobsOutput;
    digimux_sel0: TKnobsInput;
    digimux_sel1: TKnobsInput;
    digimux_sel2: TKnobsInput;
    display: TKnobsModule;
    display_blackground: TKnobsLed;
    display_editlabel: TKnobsEditLabel;
    display_in1: TKnobsInput;
    display_in2: TKnobsInput;
    display_level1: TKnobsIndicatorBar;
    display_level2: TKnobsIndicatorBar;
    display_mode: TKnobsSelector;
    display_speed: TKnobsSelector;
    display_textlabel_db: TKnobsTextLabel;
    display_whiteground: TKnobsLed;
    divide: TKnobsModule;
    divide_editlabel: TKnobsEditLabel;
    divide_out: TKnobsOutput;
    divide_textlabel_f: TKnobsTextLabel;
    divide_textlabel_x: TKnobsTextLabel;
    divide_textlabel_y: TKnobsTextLabel;
    divide_x: TKnobsInput;
    divide_y: TKnobsInput;
    divider: TKnobsModule;
    divider_count: TKnobsSmallKnob;
    divider_display_count: TKnobsDisplay;
    divider_editlabel: TKnobsEditLabel;
    divider_indicator_out: TKnobsIndicator;
    divider_mode: TKnobsSelector;
    divider_out: TKnobsOutput;
    divider_outputtype: TKnobsSelector;
    divider_reset: TKnobsInput;
    divider_symbol_reset: TImage;
    divider_symbol_trig: TImage;
    divider_textable_reset: TKnobsTextLabel;
    divider_textlabel_trig: TKnobsTextLabel;
    divider_trig: TKnobsInput;
    dyadic: TKnobsModule;
    dyadic_editlabel: TKnobsEditLabel;
    dyadic_function: TKnobsSelector;
    dyadic_out: TKnobsOutput;
    dyadic_textlabel_f: TKnobsTextLabel;
    dyadic_textlabel_x: TKnobsTextLabel;
    dyadic_textlabel_y: TKnobsTextLabel;
    dyadic_x: TKnobsInput;
    dyadic_y: TKnobsInput;
    envadsr: TKnobsModule;
    envadsr_amod: TKnobsInput;
    envadsr_amodlevel: TKnobsSmallKnob;
    envadsr_amodneg: TKnobsInput;
    envadsr_arange: TKnobsSelector;
    envadsr_ashape: TKnobsSelector;
    envadsr_attack: TKnobsSmallKnob;
    envadsr_decay: TKnobsSmallKnob;
    envadsr_display_attack: TKnobsDisplay;
    envadsr_display_decay: TKnobsDisplay;
    envadsr_display_release: TKnobsDisplay;
    envadsr_display_sustain: TKnobsDisplay;
    envadsr_dmod: TKnobsInput;
    envadsr_dmodlevel: TKnobsSmallKnob;
    envadsr_dmodneg: TKnobsInput;
    envadsr_drange: TKnobsSelector;
    envadsr_dshape: TKnobsSelector;
    envadsr_editlabel: TKnobsEditLabel;
    envadsr_eoc: TKnobsOutput;
    envadsr_gain: TKnobsInput;
    envadsr_indicator_eoc: TKnobsIndicator;
    envadsr_indicator_trig: TKnobsIndicator;
    envadsr_indicator_trigin: TKnobsIndicator;
    envadsr_mode: TKnobsSelector;
    envadsr_mute: TKnobsSelector;
    envadsr_out: TKnobsOutput;
    envadsr_outputtype: TKnobsSelector;
    envadsr_release: TKnobsSmallKnob;
    envadsr_rmod: TKnobsInput;
    envadsr_rmodlevel: TKnobsSmallKnob;
    envadsr_rmodneg: TKnobsInput;
    envadsr_rrange: TKnobsSelector;
    envadsr_rshape: TKnobsSelector;
    envadsr_sigin: TKnobsInput;
    envadsr_sigout: TKnobsOutput;
    envadsr_smod: TKnobsInput;
    envadsr_smodlevel: TKnobsSmallKnob;
    envadsr_smodneg: TKnobsInput;
    envadsr_sustain: TKnobsSmallKnob;
    envadsr_symbol_connect: TImage;
    envadsr_symbol_trig: TImage;
    envadsr_textkabel_minus: TKnobsTextLabel;
    envadsr_textkabel_plus: TKnobsTextLabel;
    envadsr_textlabel_attack: TKnobsTextLabel;
    envadsr_textlabel_decay: TKnobsTextLabel;
    envadsr_textlabel_env: TKnobsTextLabel;
    envadsr_textlabel_eoc: TKnobsTextLabel;
    envadsr_textlabel_gain: TKnobsTextLabel;
    envadsr_textlabel_release: TKnobsTextLabel;
    envadsr_textlabel_sustain: TKnobsTextLabel;
    envadsr_trig: TKnobsInput;
    envadsr_viewer: TKnobsDataViewer;
    envahd: TKnobsModule;
    envahd_amod: TKnobsInput;
    envahd_amodlevel: TKnobsSmallKnob;
    envahd_amodneg: TKnobsInput;
    envahd_arange: TKnobsSelector;
    envahd_ashape: TKnobsSelector;
    envahd_attack: TKnobsSmallKnob;
    envahd_decay: TKnobsSmallKnob;
    envahd_display_attack: TKnobsDisplay;
    envahd_display_decay: TKnobsDisplay;
    envahd_display_hold: TKnobsDisplay;
    envahd_dmod: TKnobsInput;
    envahd_dmodlevel: TKnobsSmallKnob;
    envahd_dmodneg: TKnobsInput;
    envahd_drange: TKnobsSelector;
    envahd_dshape: TKnobsSelector;
    envahd_editlabel: TKnobsEditLabel;
    envahd_eoc: TKnobsOutput;
    envahd_gain: TKnobsInput;
    envahd_hmod: TKnobsInput;
    envahd_hmodlevel: TKnobsSmallKnob;
    envahd_hmodneg: TKnobsInput;
    envahd_hold: TKnobsSmallKnob;
    envahd_hrange: TKnobsSelector;
    envahd_indicator_eoc: TKnobsIndicator;
    envahd_indicator_trig: TKnobsIndicator;
    envahd_indicator_trigin: TKnobsIndicator;
    envahd_mode: TKnobsSelector;
    envahd_mute: TKnobsSelector;
    envahd_out: TKnobsOutput;
    envahd_outputtype: TKnobsSelector;
    envahd_sigin: TKnobsInput;
    envahd_sigout: TKnobsOutput;
    envahd_symbol_connect: TImage;
    envahd_symbol_trig: TImage;
    envahd_textlabel_attack: TKnobsTextLabel;
    envahd_textlabel_decay: TKnobsTextLabel;
    envahd_textlabel_env: TKnobsTextLabel;
    envahd_textlabel_eoc: TKnobsTextLabel;
    envahd_textlabel_gain: TKnobsTextLabel;
    envahd_textlabel_hold: TKnobsTextLabel;
    envahd_textlabel_minus: TKnobsTextLabel;
    envahd_textlabel_plus: TKnobsTextLabel;
    envahd_trig: TKnobsInput;
    envahd_viewer: TKnobsDataViewer;
    envar: TKnobsModule;
    envar_attack: TKnobsSmallKnob;
    envar_display_attack: TKnobsDisplay;
    envar_display_release: TKnobsDisplay;
    envar_editlabel: TKnobsEditLabel;
    envar_gain: TKnobsInput;
    envar_indicator_trig: TKnobsIndicator;
    envar_mute: TKnobsSelector;
    envar_out: TKnobsOutput;
    envar_release: TKnobsSmallKnob;
    envar_sigin: TKnobsInput;
    envar_sigout: TKnobsOutput;
    envar_textlabel_attack: TKnobsTextLabel;
    envar_textlabel_env: TKnobsTextLabel;
    envar_textlabel_gain: TKnobsTextLabel;
    envar_textlabel_release: TKnobsTextLabel;
    envar_textlabel_trig: TKnobsTextLabel;
    envar_trig: TKnobsInput;
    envarretrig: TKnobsModule;
    envarretrig_attack: TKnobsSmallKnob;
    envarretrig_display_attack: TKnobsDisplay;
    envarretrig_display_release: TKnobsDisplay;
    envarretrig_editlabel: TKnobsEditLabel;
    envarretrig_gain: TKnobsInput;
    envarretrig_indicator_trig: TKnobsIndicator;
    envarretrig_mute: TKnobsSelector;
    envarretrig_out: TKnobsOutput;
    envarretrig_release: TKnobsSmallKnob;
    envarretrig_sigin: TKnobsInput;
    envarretrig_sigout: TKnobsOutput;
    envarretrig_symbol_connect: TImage;
    envarretrig_symbol_trig: TImage;
    envarretrig_textlabel_attack: TKnobsTextLabel;
    envarretrig_textlabel_env: TKnobsTextLabel;
    envarretrig_textlabel_gain: TKnobsTextLabel;
    envarretrig_textlabel_release: TKnobsTextLabel;
    envarretrig_textlabel_trig: TKnobsTextLabel;
    envarretrig_trig: TKnobsInput;
    envelope: TKnobsModule;
    envelope_attack: TKnobsSmallKnob;
    envelope_display_attack: TKnobsDisplay;
    envelope_display_release: TKnobsDisplay;
    envelope_editlabel: TKnobsEditLabel;
    envelope_in: TKnobsInput;
    envelope_invout: TKnobsOutput;
    envelope_mode: TKnobsSelector;
    envelope_out: TKnobsOutput;
    envelope_peakdecay: TKnobsSmallKnob;
    envelope_peakdecayon: TKnobsSelector;
    envelope_release: TKnobsSmallKnob;
    envelope_tabsheet: TTabSheet;
    envelope_textlabel_a: TKnobsTextLabel;
    envelope_textlabel_env: TKnobsTextLabel;
    envelope_textlabel_inv: TKnobsTextLabel;
    envelope_textlabel_peakdecay: TKnobsTextLabel;
    envelope_textlabel_r: TKnobsTextLabel;
    euclids: TKnobsModule;
    euclids_display_steps: TKnobsDisplay;
    euclids_editlabel: TKnobsEditLabel;
    euclids_indicator_out: TKnobsIndicator;
    euclids_indicator_trig: TKnobsIndicator;
    euclids_out: TKnobsOutput;
    euclids_pattern: TKnobsInput;
    euclids_patternmod: TKnobsSmallKnob;
    euclids_pulses: TKnobsSmallKnob;
    euclids_steps: TKnobsSmallKnob;
    euclids_symbol_trig: TImage;
    euclids_textlabel_mod: TKnobsTextLabel;
    euclids_textlabel_out: TKnobsTextLabel;
    euclids_textlabel_pattern: TKnobsTextLabel;
    euclids_textlabel_steps: TKnobsTextLabel;
    euclids_textlabel_trig: TKnobsTextLabel;
    euclids_trig: TKnobsInput;
    euscale: TKnobsModule;
    euscale_display_steps: TKnobsDisplay;
    euscale_editlabel: TKnobsEditLabel;
    euscale_in: TKnobsInput;
    euscale_out: TKnobsOutput;
    euscale_pattern: TKnobsSmallKnob;
    euscale_patternmod: TKnobsInput;
    euscale_patternmodamt: TKnobsSmallKnob;
    euscale_steps: TKnobsSmallKnob;
    euscale_textlabel_: TKnobsTextLabel;
    euscale_textlabel_in: TKnobsTextLabel;
    euscale_textlabel_out: TKnobsTextLabel;
    euscale_textlabel_pattern: TKnobsTextLabel;
    euscale_textlabel_steps: TKnobsTextLabel;
    filter_tabsheet: TTabSheet;
    flangechorus: TKnobsModule;
    flangechorus_delay: TKnobsSmallKnob;
    flangechorus_dry: TKnobsSmallKnob;
    flangechorus_editlabel: TKnobsEditLabel;
    flangechorus_feedback: TKnobsSmallKnob;
    flangechorus_freeze: TKnobsSelector;
    flangechorus_freezein: TKnobsInput;
    flangechorus_in: TKnobsInput;
    flangechorus_mute: TKnobsSelector;
    flangechorus_out: TKnobsOutput;
    flangechorus_rate: TKnobsSmallKnob;
    flangechorus_sweep: TKnobsSmallKnob;
    flangechorus_textlabel_delay: TKnobsTextLabel;
    flangechorus_textlabel_dry: TKnobsTextLabel;
    flangechorus_textlabel_feedback: TKnobsTextLabel;
    flangechorus_textlabel_rate: TKnobsTextLabel;
    flangechorus_textlabel_sweep: TKnobsTextLabel;
    flangechorus_textlabel_wet: TKnobsTextLabel;
    flangechorus_wet: TKnobsSmallKnob;
    freqcount: TKnobsModule;
    freqcount_count: TKnobsInput;
    freqcount_display_timebase: TKnobsDisplay;
    freqcount_display_value: TKnobsDisplay;
    freqcount_editlabel: TKnobsEditLabel;
    freqcount_res: TKnobsInput;
    freqcount_reset: TKnobsSelector;
    freqcount_symbol_count: TImage;
    freqcount_symbol_res: TImage;
    freqcount_textlabel_count: TKnobsTextLabel;
    freqcount_textlabel_res: TKnobsTextLabel;
    freqcount_timebase: TKnobsSmallKnob;
    freqshifter: TKnobsModule;
    freqshifter_display_shift: TKnobsDisplay;
    freqshifter_down: TKnobsOutput;
    freqshifter_editlabel: TKnobsEditLabel;
    freqshifter_in: TKnobsInput;
    freqshifter_shift: TKnobsSmallKnob;
    freqshifter_shiftdepth: TKnobsSmallKnob;
    freqshifter_shiftmod: TKnobsInput;
    freqshifter_textlabel_dn: TKnobsTextLabel;
    freqshifter_textlabel_mod: TKnobsTextLabel;
    freqshifter_textlabel_shift: TKnobsTextLabel;
    freqshifter_textlabel_up: TKnobsTextLabel;
    freqshifter_up: TKnobsOutput;
    fx_tabsheet: TTabSheet;
    gate: TKnobsModule;
    gate_editlabel: TKnobsEditLabel;
    gate_function: TKnobsSelector;
    gate_in1: TKnobsInput;
    gate_in2: TKnobsInput;
    gate_in3: TKnobsInput;
    gate_in4: TKnobsInput;
    gate_indicator_out: TKnobsIndicator;
    gate_out: TKnobsOutput;
    gate_outputtype: TKnobsSelector;
    gate_width: TKnobsSelector;
    gateseq: TKnobsModule;
    gateseq_active: TKnobsInput;
    gateseq_chain: TKnobsInput;
    gateseq_clr: TKnobsSelector;
    gateseq_dir: TKnobsInput;
    gateseq_display_steps: TKnobsDisplay;
    gateseq_editlabel: TKnobsEditLabel;
    gateseq_indicator_active: TKnobsIndicator;
    gateseq_indicator_dir: TKnobsIndicator;
    gateseq_indicator_out: TKnobsIndicator;
    gateseq_indicator_reset: TKnobsIndicator;
    gateseq_indicator_step10: TKnobsIndicator;
    gateseq_indicator_step11: TKnobsIndicator;
    gateseq_indicator_step12: TKnobsIndicator;
    gateseq_indicator_step13: TKnobsIndicator;
    gateseq_indicator_step14: TKnobsIndicator;
    gateseq_indicator_step15: TKnobsIndicator;
    gateseq_indicator_step16: TKnobsIndicator;
    gateseq_indicator_step1: TKnobsIndicator;
    gateseq_indicator_step2: TKnobsIndicator;
    gateseq_indicator_step3: TKnobsIndicator;
    gateseq_indicator_step4: TKnobsIndicator;
    gateseq_indicator_step5: TKnobsIndicator;
    gateseq_indicator_step6: TKnobsIndicator;
    gateseq_indicator_step7: TKnobsIndicator;
    gateseq_indicator_step8: TKnobsIndicator;
    gateseq_indicator_step9: TKnobsIndicator;
    gateseq_indicator_trig: TKnobsIndicator;
    gateseq_out: TKnobsOutput;
    gateseq_outdir: TKnobsOutput;
    gateseq_outres: TKnobsOutput;
    gateseq_outtrig: TKnobsOutput;
    gateseq_res: TKnobsInput;
    gateseq_rnd: TKnobsSelector;
    gateseq_step10: TKnobsSelector;
    gateseq_step11: TKnobsSelector;
    gateseq_step12: TKnobsSelector;
    gateseq_step13: TKnobsSelector;
    gateseq_step14: TKnobsSelector;
    gateseq_step15: TKnobsSelector;
    gateseq_step16: TKnobsSelector;
    gateseq_step1: TKnobsSelector;
    gateseq_step2: TKnobsSelector;
    gateseq_step3: TKnobsSelector;
    gateseq_step4: TKnobsSelector;
    gateseq_step5: TKnobsSelector;
    gateseq_step6: TKnobsSelector;
    gateseq_step7: TKnobsSelector;
    gateseq_step8: TKnobsSelector;
    gateseq_step9: TKnobsSelector;
    gateseq_steps: TKnobsNoKnob;
    gateseq_symbol_reset: TImage;
    gateseq_symbol_trig: TImage;
    gateseq_textlabel_active: TKnobsTextLabel;
    gateseq_textlabel_chain: TKnobsTextLabel;
    gateseq_textlabel_dir: TKnobsTextLabel;
    gateseq_textlabel_out: TKnobsTextLabel;
    gateseq_textlabel_reset: TKnobsTextLabel;
    gateseq_textlabel_steps: TKnobsTextLabel;
    gateseq_textlabel_trig: TKnobsTextLabel;
    gateseq_trig: TKnobsInput;
    granulator: TKnobsModule;
    granulator_delay: TKnobsInput;
    granulator_delaytime: TKnobsSmallKnob;
    granulator_display_delaytime: TKnobsDisplay;
    granulator_display_grainduration: TKnobsDisplay;
    granulator_display_grains: TKnobsDisplay;
    granulator_display_interonset: TKnobsDisplay;
    granulator_editlabel: TKnobsEditLabel;
    granulator_envtype: TKnobsSelector;
    granulator_graincount: TKnobsSmallKnob;
    granulator_grainduration: TKnobsSmallKnob;
    granulator_graindurationmod: TKnobsInput;
    granulator_graindurationmodamt: TKnobsSmallKnob;
    granulator_grainoffset: TKnobsInput;
    granulator_in: TKnobsInput;
    granulator_interonset: TKnobsSmallKnob;
    granulator_interonsetmod: TKnobsInput;
    granulator_interonsetmodamt: TKnobsSmallKnob;
    granulator_mute: TKnobsSelector;
    granulator_outl: TKnobsOutput;
    granulator_outr: TKnobsOutput;
    granulator_pan: TKnobsSmallKnob;
    granulator_panmod: TKnobsInput;
    granulator_panmodamt: TKnobsSmallKnob;
    granulator_range: TKnobsSelector;
    granulator_rec: TKnobsInput;
    granulator_record: TKnobsSelector;
    granulator_textlabel_dlymod: TKnobsTextLabel;
    granulator_textlabel_duration: TKnobsTextLabel;
    granulator_textlabel_envtype: TKnobsTextLabel;
    granulator_textlabel_grainoffset: TKnobsTextLabel;
    granulator_textlabel_grains: TKnobsTextLabel;
    granulator_textlabel_in: TKnobsTextLabel;
    granulator_textlabel_interonset: TKnobsTextLabel;
    granulator_textlabel_maxdelay: TKnobsTextLabel;
    granulator_textlabel_out: TKnobsTextLabel;
    granulator_textlabel_pan: TKnobsTextLabel;
    granulator_textlabel_vol: TKnobsTextLabel;
    granulator_volume: TKnobsSmallKnob;
    granulator_volumemod: TKnobsInput;
    granulator_volumemodamt: TKnobsSmallKnob;
    gverb: TKnobsModule;
    gverb_damping: TKnobsSmallKnob;
    gverb_dampingmod: TKnobsInput;
    gverb_display_maxroomsize: TKnobsDisplay;
    gverb_display_roomsize: TKnobsDisplay;
    gverb_drylevel: TKnobsSmallKnob;
    gverb_drylevelmod: TKnobsInput;
    gverb_earlylevel: TKnobsSmallKnob;
    gverb_earlylevelmod: TKnobsInput;
    gverb_editlabel: TKnobsEditLabel;
    gverb_inl: TKnobsInput;
    gverb_inputbw: TKnobsSmallKnob;
    gverb_inputbwmod: TKnobsInput;
    gverb_inputlevel: TKnobsSmallKnob;
    gverb_inr: TKnobsInput;
    gverb_knobbox: TKnobsBox;
    gverb_maxroomsize: TKnobsSmallKnob;
    gverb_mode: TKnobsSelector;
    gverb_mute: TKnobsSelector;
    gverb_outl: TKnobsOutput;
    gverb_outr: TKnobsOutput;
    gverb_revtime: TKnobsSmallKnob;
    gverb_revtimemod: TKnobsInput;
    gverb_roomsize: TKnobsSmallKnob;
    gverb_roomsizemod: TKnobsInput;
    gverb_roomsizemodlev: TKnobsSmallKnob;
    gverb_spread: TKnobsSmallKnob;
    gverb_taillevel: TKnobsSmallKnob;
    gverb_taillevelmod: TKnobsInput;
    gverb_textlabel_damping: TKnobsTextLabel;
    gverb_textlabel_drylevel: TKnobsTextLabel;
    gverb_textlabel_earlylevel: TKnobsTextLabel;
    gverb_textlabel_inlevel: TKnobsTextLabel;
    gverb_textlabel_inputbw: TKnobsTextLabel;
    gverb_textlabel_maxroomsize: TKnobsTextLabel;
    gverb_textlabel_mod: TKnobsTextLabel;
    gverb_textlabel_mode: TKnobsTextLabel;
    gverb_textlabel_revtime: TKnobsTextLabel;
    gverb_textlabel_roomsize: TKnobsTextLabel;
    gverb_textlabel_spread: TKnobsTextLabel;
    gverb_textlabel_taillevel: TKnobsTextLabel;
    hrastosc: TKnobsModule;
    hrastosc_bandlimit: TKnobsSmallKnob;
    hrastosc_cents: TKnobsSmallKnob;
    hrastosc_display_cents: TKnobsDisplay;
    hrastosc_display_freq: TKnobsDisplay;
    hrastosc_editlabel: TKnobsEditLabel;
    hrastosc_fm: TKnobsInput;
    hrastosc_fmlevel: TKnobsSmallKnob;
    hrastosc_frequency: TKnobsSmallKnob;
    hrastosc_level: TKnobsSmallKnob;
    hrastosc_morph: TKnobsSmallKnob;
    hrastosc_out: TKnobsOutput;
    hrastosc_phase: TKnobsInput;
    hrastosc_pmlevel: TKnobsSmallKnob;
    hrastosc_pw: TKnobsSmallKnob;
    hrastosc_pwm: TKnobsInput;
    hrastosc_pwmlevel: TKnobsSmallKnob;
    hrastosc_shape: TKnobsSmallKnob;
    hrastosc_symbol_sync: TImage;
    hrastosc_sync: TKnobsInput;
    hrastosc_textlabel_bandlimit: TKnobsTextLabel;
    hrastosc_textlabel_fm: TKnobsTextLabel;
    hrastosc_textlabel_level: TKnobsTextLabel;
    hrastosc_textlabel_morph: TKnobsTextLabel;
    hrastosc_textlabel_pm: TKnobsTextLabel;
    hrastosc_textlabel_pwm: TKnobsTextLabel;
    hrastosc_textlabel_shape: TKnobsTextLabel;
    hrastosc_textlabel_sync: TKnobsTextLabel;
    hrastosc_vintage: TKnobsSelector;
    hrastsvf: TKnobsModule;
    hrastsvf_12: TKnobsOutput;
    hrastsvf_24: TKnobsOutput;
    hrastsvf_bandpass: TKnobsSmallKnob;
    hrastsvf_bp: TKnobsOutput;
    hrastsvf_br: TKnobsOutput;
    hrastsvf_display_cutoff: TKnobsDisplay;
    hrastsvf_distortion: TKnobsSmallKnob;
    hrastsvf_editlabel: TKnobsEditLabel;
    hrastsvf_fm: TKnobsInput;
    hrastsvf_fmlevel: TKnobsSmallKnob;
    hrastsvf_freq: TKnobsInput;
    hrastsvf_frequency: TKnobsSmallKnob;
    hrastsvf_highpass: TKnobsSmallKnob;
    hrastsvf_hp: TKnobsOutput;
    hrastsvf_in: TKnobsInput;
    hrastsvf_inlevel: TKnobsSmallKnob;
    hrastsvf_level12: TKnobsSmallKnob;
    hrastsvf_level24: TKnobsSmallKnob;
    hrastsvf_lowpass: TKnobsSmallKnob;
    hrastsvf_lp: TKnobsOutput;
    hrastsvf_q: TKnobsSmallKnob;
    hrastsvf_qm: TKnobsInput;
    hrastsvf_qmlevel: TKnobsSmallKnob;
    hrastsvf_textlabel_12db: TKnobsTextLabel;
    hrastsvf_textlabel_24db: TKnobsTextLabel;
    hrastsvf_textlabel_bp: TKnobsTextLabel;
    hrastsvf_textlabel_drive: TKnobsTextLabel;
    hrastsvf_textlabel_fm: TKnobsTextLabel;
    hrastsvf_textlabel_freq: TKnobsTextLabel;
    hrastsvf_textlabel_hp: TKnobsTextLabel;
    hrastsvf_textlabel_in: TKnobsTextLabel;
    hrastsvf_textlabel_lp: TKnobsTextLabel;
    hrastsvf_textlabel_out12db: TKnobsTextLabel;
    hrastsvf_textlabel_out24db: TKnobsTextLabel;
    hrastsvf_textlabel_outbp: TKnobsTextLabel;
    hrastsvf_textlabel_outbr: TKnobsTextLabel;
    hrastsvf_textlabel_outhp: TKnobsTextLabel;
    hrastsvf_textlabel_outlp: TKnobsTextLabel;
    hrastsvf_textlabel_q: TKnobsTextLabel;
    hrastsvf_textlabel_qm: TKnobsTextLabel;
    inout_tabsheet: TTabSheet;
    intdif: TKnobsModule;
    intdif_dif: TKnobsOutput;
    intdif_editlabel: TKnobsEditLabel;
    intdif_gain: TKnobsHSlider;
    intdif_in: TKnobsInput;
    intdif_int: TKnobsOutput;
    intdif_mode: TKnobsSelector;
    intdif_textlabel_dif: TKnobsTextLabel;
    intdif_textlabel_gain: TKnobsTextLabel;
    intdif_textlabel_in: TKnobsTextLabel;
    intdif_textlabel_int: TKnobsTextLabel;
    inverter: TKnobsModule;
    inverter_editlabel: TKnobsEditLabel;
    inverter_in1: TKnobsInput;
    inverter_in2: TKnobsInput;
    inverter_in3: TKnobsInput;
    inverter_in4: TKnobsInput;
    inverter_out1: TKnobsOutput;
    inverter_out2: TKnobsOutput;
    inverter_out3: TKnobsOutput;
    inverter_out4: TKnobsOutput;
    knobs4: TKnobsModule;
    knobs4_display1: TKnobsDisplay;
    knobs4_display2: TKnobsDisplay;
    knobs4_display3: TKnobsDisplay;
    knobs4_display4: TKnobsDisplay;
    knobs4_display_value1: TKnobsDisplay;
    knobs4_display_value2: TKnobsDisplay;
    knobs4_display_value3: TKnobsDisplay;
    knobs4_display_value4: TKnobsDisplay;
    knobs4_editlabel: TKnobsEditLabel;
    knobs4_mode1: TKnobsSelector;
    knobs4_mode2: TKnobsSelector;
    knobs4_mode3: TKnobsSelector;
    knobs4_mode4: TKnobsSelector;
    knobs4_out1: TKnobsOutput;
    knobs4_out2: TKnobsOutput;
    knobs4_out3: TKnobsOutput;
    knobs4_out4: TKnobsOutput;
    knobs4_value1: TKnobsKnob;
    knobs4_value2: TKnobsKnob;
    knobs4_value3: TKnobsKnob;
    knobs4_value4: TKnobsKnob;
    ks: TKnobsModule;
    ks_brightness: TKnobsSmallKnob;
    ks_cents: TKnobsSmallKnob;
    ks_display_cents: TKnobsDisplay;
    ks_display_frequency: TKnobsDisplay;
    ks_editlabel: TKnobsEditLabel;
    ks_feedback: TKnobsSmallKnob;
    ks_fm: TKnobsInput;
    ks_fmlevel: TKnobsSmallKnob;
    ks_freq: TKnobsInput;
    ks_frequency: TKnobsSmallKnob;
    ks_mode: TKnobsSelector;
    ks_mute: TKnobsSelector;
    ks_out: TKnobsOutput;
    ks_pluck: TKnobsInput;
    ks_plucklevel: TKnobsSmallKnob;
    ks_textlabel_brightness: TKnobsTextLabel;
    ks_textlabel_feedb: TKnobsTextLabel;
    ks_textlabel_fm: TKnobsTextLabel;
    ks_textlabel_freq: TKnobsTextLabel;
    ks_textlabel_interpolation: TKnobsTextLabel;
    ks_textlabel_pluck: TKnobsTextLabel;
    levelconverter: TKnobsModule;
    levelconverter_editlabel: TKnobsEditLabel;
    levelconverter_in1: TKnobsInput;
    levelconverter_in2: TKnobsInput;
    levelconverter_in3: TKnobsInput;
    levelconverter_in4: TKnobsInput;
    levelconverter_inmode: TKnobsSelector;
    levelconverter_out1: TKnobsOutput;
    levelconverter_out2: TKnobsOutput;
    levelconverter_out3: TKnobsOutput;
    levelconverter_out4: TKnobsOutput;
    levelconverter_outmode: TKnobsSelector;
    levelconverter_textlabel_in: TKnobsTextLabel;
    levelconverter_textlabel_out: TKnobsTextLabel;
    lfo: TKnobsModule;
    lfo_display_frequency: TKnobsDisplay;
    lfo_editlabel: TKnobsEditLabel;
    lfo_fm: TKnobsInput;
    lfo_fmlevel: TKnobsSmallKnob;
    lfo_freq: TKnobsInput;
    lfo_frequency: TKnobsSmallKnob;
    lfo_indicator_out: TKnobsIndicator;
    lfo_indicator_res: TKnobsIndicator;
    lfo_mute: TKnobsSelector;
    lfo_out: TKnobsOutput;
    lfo_outputtype: TKnobsSelector;
    lfo_phase: TKnobsInput;
    lfo_pmlevel: TKnobsSmallKnob;
    lfo_range: TKnobsSelector;
    lfo_res: TKnobsInput;
    lfo_shape: TKnobsSelector;
    lfo_symbol_res: TImage;
    lfo_sync: TKnobsOutput;
    lfo_tabsheet: TTabSheet;
    lfo_textlabel_fm: TKnobsTextLabel;
    lfo_textlabel_phase: TKnobsTextLabel;
    lfo_textlabel_res: TKnobsTextLabel;
    lfo_textlabel_sync: TKnobsTextLabel;
    lfotrig: TKnobsModule;
    lfotrig_count: TKnobsNoKnob;
    lfotrig_display_count: TKnobsDisplay;
    lfotrig_display_frequency: TKnobsDisplay;
    lfotrig_editlabel: TKnobsEditLabel;
    lfotrig_fm: TKnobsInput;
    lfotrig_fmlevel: TKnobsSmallKnob;
    lfotrig_frequency: TKnobsSmallKnob;
    lfotrig_indicator_out: TKnobsIndicator;
    lfotrig_indicator_ready: TKnobsIndicator;
    lfotrig_indicator_trig: TKnobsIndicator;
    lfotrig_mode: TKnobsSelector;
    lfotrig_mute: TKnobsSelector;
    lfotrig_out: TKnobsOutput;
    lfotrig_outputtype: TKnobsSelector;
    lfotrig_range: TKnobsSelector;
    lfotrig_ready: TKnobsOutput;
    lfotrig_shape: TKnobsSelector;
    lfotrig_symbol_trig: TImage;
    lfotrig_textlabel_count: TKnobsTextLabel;
    lfotrig_textlabel_fm: TKnobsTextLabel;
    lfotrig_textlabel_mode: TKnobsTextLabel;
    lfotrig_textlabel_out: TKnobsTextLabel;
    lfotrig_textlabel_ready: TKnobsTextLabel;
    lfotrig_textlabel_trig: TKnobsTextLabel;
    lfotrig_trig: TKnobsInput;
    logic_tabsheet: TTabSheet;
    logicnot: TKnobsModule;
    logicnot_editlabel: TKnobsEditLabel;
    logicnot_in1: TKnobsInput;
    logicnot_in2: TKnobsInput;
    logicnot_in3: TKnobsInput;
    logicnot_in4: TKnobsInput;
    logicnot_indicator_out1: TKnobsIndicator;
    logicnot_indicator_out2: TKnobsIndicator;
    logicnot_indicator_out3: TKnobsIndicator;
    logicnot_indicator_out4: TKnobsIndicator;
    logicnot_out1: TKnobsOutput;
    logicnot_out2: TKnobsOutput;
    logicnot_out3: TKnobsOutput;
    logicnot_out4: TKnobsOutput;
    logicselector: TKnobsModule;
    logicselector_editlabel: TKnobsEditLabel;
    logicselector_ina: TKnobsInput;
    logicselector_inb: TKnobsInput;
    logicselector_indicator_outa: TKnobsIndicator;
    logicselector_indicator_outb: TKnobsIndicator;
    logicselector_outa: TKnobsOutput;
    logicselector_outb: TKnobsOutput;
    logicselector_sel: TKnobsInput;
    logicselector_textlabel_ina: TKnobsTextLabel;
    logicselector_textlabel_inb: TKnobsTextLabel;
    logicselector_textlabel_outa: TKnobsTextLabel;
    logicselector_textlabel_outb: TKnobsTextLabel;
    logicselector_textlabel_sel: TKnobsTextLabel;
    looper: TKnobsModule;
    looper_collission: TKnobsOutput;
    looper_display_maxtime: TKnobsDisplay;
    looper_duration: TKnobsSmallKnob;
    looper_durationmod: TKnobsInput;
    looper_durationmodamt: TKnobsSmallKnob;
    looper_editlabel: TKnobsEditLabel;
    looper_fm: TKnobsInput;
    looper_fmamt: TKnobsSmallKnob;
    looper_in: TKnobsInput;
    looper_indicator_test: TKnobsIndicator;
    looper_length: TKnobsSmallKnob;
    looper_mode: TKnobsSelector;
    looper_out: TKnobsOutput;
    looper_overlap: TKnobsSmallKnob;
    looper_range: TKnobsSelector;
    looper_rec: TKnobsInput;
    looper_record: TKnobsSelector;
    looper_speed: TKnobsSmallKnob;
    looper_speedmod: TKnobsInput;
    looper_speedmodamt: TKnobsSmallKnob;
    looper_start: TKnobsSmallKnob;
    looper_startmod: TKnobsInput;
    looper_startmodamt: TKnobsSmallKnob;
    looper_textlabel_duration: TKnobsTextLabel;
    looper_textlabel_fm: TKnobsTextLabel;
    looper_textlabel_in: TKnobsTextLabel;
    looper_textlabel_maxlength: TKnobsTextLabel;
    looper_textlabel_out: TKnobsTextLabel;
    looper_textlabel_overlap: TKnobsTextLabel;
    looper_textlabel_speed: TKnobsTextLabel;
    looper_textlabel_start: TKnobsTextLabel;
    lut: TKnobsModule;
    lut_chain: TKnobsInput;
    lut_clr: TKnobsSelector;
    lut_editlabel: TKnobsEditLabel;
    lut_indicator_step10: TKnobsIndicator;
    lut_indicator_step11: TKnobsIndicator;
    lut_indicator_step12: TKnobsIndicator;
    lut_indicator_step13: TKnobsIndicator;
    lut_indicator_step14: TKnobsIndicator;
    lut_indicator_step15: TKnobsIndicator;
    lut_indicator_step16: TKnobsIndicator;
    lut_indicator_step1: TKnobsIndicator;
    lut_indicator_step2: TKnobsIndicator;
    lut_indicator_step3: TKnobsIndicator;
    lut_indicator_step4: TKnobsIndicator;
    lut_indicator_step5: TKnobsIndicator;
    lut_indicator_step6: TKnobsIndicator;
    lut_indicator_step7: TKnobsIndicator;
    lut_indicator_step8: TKnobsIndicator;
    lut_indicator_step9: TKnobsIndicator;
    lut_mode: TKnobsSelector;
    lut_out: TKnobsOutput;
    lut_rnd: TKnobsSelector;
    lut_select: TKnobsInput;
    lut_step10: TKnobsSlider;
    lut_step11: TKnobsSlider;
    lut_step12: TKnobsSlider;
    lut_step13: TKnobsSlider;
    lut_step14: TKnobsSlider;
    lut_step15: TKnobsSlider;
    lut_step16: TKnobsSlider;
    lut_step1: TKnobsSlider;
    lut_step2: TKnobsSlider;
    lut_step3: TKnobsSlider;
    lut_step4: TKnobsSlider;
    lut_step5: TKnobsSlider;
    lut_step6: TKnobsSlider;
    lut_step7: TKnobsSlider;
    lut_step8: TKnobsSlider;
    lut_step9: TKnobsSlider;
    lut_textlabel_chain: TKnobsTextLabel;
    lut_textlabel_mode: TKnobsTextLabel;
    lut_textlabel_out: TKnobsTextLabel;
    lut_textlabel_select: TKnobsTextLabel;
    lut_textlabel_xfade: TKnobsTextLabel;
    lut_xfade: TKnobsSmallKnob;
    math_tabsheet: TTabSheet;
    mconst: TKnobsModule;
    mconst_editlabel: TKnobsEditLabel;
    mconst_out: TKnobsOutput;
    mconst_textlabel_x: TKnobsTextLabel;
    mconst_value: TKnobsSelector;
    median: TKnobsModule;
    median_avg: TKnobsOutput;
    median_binsize: TKnobsSmallKnob;
    median_display_binsize: TKnobsDisplay;
    median_editlabel: TKnobsEditLabel;
    median_high: TKnobsOutput;
    median_in: TKnobsInput;
    median_indicator_trig: TKnobsIndicator;
    median_low: TKnobsOutput;
    median_out: TKnobsOutput;
    median_symbol_trig: TImage;
    median_textlabel_avg: TKnobsTextLabel;
    median_textlabel_binsize: TKnobsTextLabel;
    median_textlabel_hi: TKnobsTextLabel;
    median_textlabel_in: TKnobsTextLabel;
    median_textlabel_lo: TKnobsTextLabel;
    median_textlabel_median: TKnobsTextLabel;
    median_textlabel_trig: TKnobsTextLabel;
    median_trig: TKnobsInput;
    midiccin: TKnobsModule;
    midiccin_cc: TKnobsNoKnob;
    midiccin_ch: TKnobsNoKnob;
    midiccin_display_cc: TKnobsDisplay;
    midiccin_display_ch: TKnobsDisplay;
    midiccin_editlabel: TKnobsEditLabel;
    midiccin_gate: TKnobsOutput;
    midiccin_indicator_gate: TKnobsIndicator;
    midiccin_textlabel_cc: TKnobsTextLabel;
    midiccin_textlabel_gate: TKnobsTextLabel;
    midiccin_textlabel_value: TKnobsTextLabel;
    midiccin_value: TKnobsOutput;
    midiccout: TKnobsModule;
    midiccout_cc: TKnobsNoKnob;
    midiccout_ch: TKnobsNoKnob;
    midiccout_display_cc: TKnobsDisplay;
    midiccout_display_ch: TKnobsDisplay;
    midiccout_editlabel: TKnobsEditLabel;
    midiccout_gate: TKnobsInput;
    midiccout_indicator_gate: TKnobsIndicator;
    midiccout_textlabel_cc: TKnobsTextLabel;
    midiccout_textlabel_gate: TKnobsTextLabel;
    midiccout_textlabel_value: TKnobsTextLabel;
    midiccout_value: TKnobsInput;
    midimultinotein: TKnobsModule;
    midimultinotein_after2: TKnobsOutput;
    midimultinotein_after3: TKnobsOutput;
    midimultinotein_after4: TKnobsOutput;
    midimultinotein_after: TKnobsOutput;
    midimultinotein_bend: TKnobsOutput;
    midimultinotein_ch: TKnobsNoKnob;
    midimultinotein_display_ch: TKnobsDisplay;
    midimultinotein_editlabel: TKnobsEditLabel;
    midimultinotein_gate2: TKnobsOutput;
    midimultinotein_gate3: TKnobsOutput;
    midimultinotein_gate4: TKnobsOutput;
    midimultinotein_gate: TKnobsOutput;
    midimultinotein_indicator_gate2: TKnobsIndicator;
    midimultinotein_indicator_gate3: TKnobsIndicator;
    midimultinotein_indicator_gate4: TKnobsIndicator;
    midimultinotein_indicator_gate: TKnobsIndicator;
    midimultinotein_level2: TKnobsInput;
    midimultinotein_level3: TKnobsInput;
    midimultinotein_level4: TKnobsInput;
    midimultinotein_level: TKnobsInput;
    midimultinotein_mode: TKnobsSelector;
    midimultinotein_note2: TKnobsOutput;
    midimultinotein_note3: TKnobsOutput;
    midimultinotein_note4: TKnobsOutput;
    midimultinotein_note: TKnobsOutput;
    midimultinotein_textlabel_aft: TKnobsTextLabel;
    midimultinotein_textlabel_bend: TKnobsTextLabel;
    midimultinotein_textlabel_gate: TKnobsTextLabel;
    midimultinotein_textlabel_level: TKnobsTextLabel;
    midimultinotein_textlabel_note: TKnobsTextLabel;
    midimultinotein_textlabel_off: TKnobsTextLabel;
    midimultinotein_textlabel_on: TKnobsTextLabel;
    midimultinotein_textlabel_stealing: TKnobsTextLabel;
    midimultinotein_veloff2: TKnobsOutput;
    midimultinotein_veloff3: TKnobsOutput;
    midimultinotein_veloff4: TKnobsOutput;
    midimultinotein_veloff: TKnobsOutput;
    midimultinotein_velon2: TKnobsOutput;
    midimultinotein_velon3: TKnobsOutput;
    midimultinotein_velon4: TKnobsOutput;
    midimultinotein_velon: TKnobsOutput;
    midinotein: TKnobsModule;
    midinotein_ch: TKnobsNoKnob;
    midinotein_display_ch: TKnobsDisplay;
    midinotein_editlabel: TKnobsEditLabel;
    midinotein_gate: TKnobsOutput;
    midinotein_indicator_gate: TKnobsIndicator;
    midinotein_note: TKnobsOutput;
    midinotein_textlabel_gate: TKnobsTextLabel;
    midinotein_textlabel_note: TKnobsTextLabel;
    midinotein_textlabel_velocity: TKnobsTextLabel;
    midinotein_textlabel_veloff: TKnobsTextLabel;
    midinotein_textlabel_velon: TKnobsTextLabel;
    midinotein_veloff: TKnobsOutput;
    midinotein_velon: TKnobsOutput;
    midinoteout: TKnobsModule;
    midinoteout_ch: TKnobsNoKnob;
    midinoteout_display_ch: TKnobsDisplay;
    midinoteout_editlabel: TKnobsEditLabel;
    midinoteout_gate: TKnobsInput;
    midinoteout_indicator_gate: TKnobsIndicator;
    midinoteout_note: TKnobsInput;
    midinoteout_textlabel_gate: TKnobsTextLabel;
    midinoteout_textlabel_note: TKnobsTextLabel;
    midinoteout_textlabel_velocity: TKnobsTextLabel;
    midinoteout_textlabel_veloff: TKnobsTextLabel;
    midinoteout_textlabel_velon: TKnobsTextLabel;
    midinoteout_veloff: TKnobsInput;
    midinoteout_velon: TKnobsInput;
    minmax: TKnobsModule;
    minmax_editlabel: TKnobsEditLabel;
    minmax_in1: TKnobsInput;
    minmax_in2: TKnobsInput;
    minmax_max: TKnobsOutput;
    minmax_min: TKnobsOutput;
    minmax_textlabel_1in2: TKnobsTextLabel;
    minmax_textlabel_minmax: TKnobsTextLabel;
    mixaudio_editlabel: TKnobsEditLabel;
    mixaudio_in1: TKnobsInput;
    mixaudio_in2: TKnobsInput;
    mixaudio_in3: TKnobsInput;
    mixaudio_in4: TKnobsInput;
    mixaudio_in5: TKnobsInput;
    mixaudio_in6: TKnobsInput;
    mixaudio_in7: TKnobsInput;
    mixaudio_in8: TKnobsInput;
    mixaudio_inchain1l: TKnobsInput;
    mixaudio_inchain1r: TKnobsInput;
    mixaudio_inchain2l: TKnobsInput;
    mixaudio_inchain2r: TKnobsInput;
    mixaudio_indicator_solo: TKnobsIndicator;
    mixaudio_insolo: TKnobsInput;
    mixaudio_out1l: TKnobsOutput;
    mixaudio_out1r: TKnobsOutput;
    mixaudio_out2l: TKnobsOutput;
    mixaudio_out2r: TKnobsOutput;
    mixaudio_outsolo: TKnobsOutput;
    mixaudio_pan1: TKnobsSmallKnob;
    mixaudio_pan2: TKnobsSmallKnob;
    mixaudio_pan3: TKnobsSmallKnob;
    mixaudio_pan4: TKnobsSmallKnob;
    mixaudio_pan5: TKnobsSmallKnob;
    mixaudio_pan6: TKnobsSmallKnob;
    mixaudio_pan7: TKnobsSmallKnob;
    mixaudio_pan8: TKnobsSmallKnob;
    mixaudio_textlabel_chain1: TKnobsTextLabel;
    mixaudio_textlabel_chain2: TKnobsTextLabel;
    mixaudio_textlabel_in1: TKnobsTextLabel;
    mixaudio_textlabel_in2: TKnobsTextLabel;
    mixaudio_textlabel_in3: TKnobsTextLabel;
    mixaudio_textlabel_in4: TKnobsTextLabel;
    mixaudio_textlabel_in5: TKnobsTextLabel;
    mixaudio_textlabel_in6: TKnobsTextLabel;
    mixaudio_textlabel_in7: TKnobsTextLabel;
    mixaudio_textlabel_in8: TKnobsTextLabel;
    mixaudio_textlabel_out1: TKnobsTextLabel;
    mixaudio_textlabel_out2: TKnobsTextLabel;
    mixaudio_textlabel_pan: TKnobsTextLabel;
    mixaudio_textlabel_soloin: TKnobsTextLabel;
    mixaudio_textlabel_soloout: TKnobsTextLabel;
    mixaudio_textlabel_vol1: TKnobsTextLabel;
    mixaudio_textlabel_vol2: TKnobsTextLabel;
    mixaudio_vol11: TKnobsSmallKnob;
    mixaudio_vol12: TKnobsSmallKnob;
    mixaudio_vol13: TKnobsSmallKnob;
    mixaudio_vol14: TKnobsSmallKnob;
    mixaudio_vol15: TKnobsSmallKnob;
    mixaudio_vol16: TKnobsSmallKnob;
    mixaudio_vol17: TKnobsSmallKnob;
    mixaudio_vol18: TKnobsSmallKnob;
    mixaudio_vol21: TKnobsSmallKnob;
    mixaudio_vol22: TKnobsSmallKnob;
    mixaudio_vol23: TKnobsSmallKnob;
    mixaudio_vol24: TKnobsSmallKnob;
    mixaudio_vol25: TKnobsSmallKnob;
    mixaudio_vol26: TKnobsSmallKnob;
    mixaudio_vol27: TKnobsSmallKnob;
    mixaudio_vol28: TKnobsSmallKnob;
    mixer_tabsheet: TTabSheet;
    mixingscaler: TKnobsModule;
    mixingscaler_chain: TKnobsInput;
    mixingscaler_display_gain2: TKnobsDisplay;
    mixingscaler_display_gain3: TKnobsDisplay;
    mixingscaler_display_gain4: TKnobsDisplay;
    mixingscaler_display_gain: TKnobsDisplay;
    mixingscaler_display_offset2: TKnobsDisplay;
    mixingscaler_display_offset3: TKnobsDisplay;
    mixingscaler_display_offset4: TKnobsDisplay;
    mixingscaler_display_offset: TKnobsDisplay;
    mixingscaler_editlabel: TKnobsEditLabel;
    mixingscaler_gain2: TKnobsSmallKnob;
    mixingscaler_gain3: TKnobsSmallKnob;
    mixingscaler_gain4: TKnobsSmallKnob;
    mixingscaler_gain: TKnobsSmallKnob;
    mixingscaler_in1: TKnobsInput;
    mixingscaler_in2: TKnobsInput;
    mixingscaler_in3: TKnobsInput;
    mixingscaler_in4: TKnobsInput;
    mixingscaler_mode2: TKnobsSelector;
    mixingscaler_mode3: TKnobsSelector;
    mixingscaler_mode4: TKnobsSelector;
    mixingscaler_mode: TKnobsSelector;
    mixingscaler_mute2: TKnobsSelector;
    mixingscaler_mute3: TKnobsSelector;
    mixingscaler_mute4: TKnobsSelector;
    mixingscaler_mute: TKnobsSelector;
    mixingscaler_offset2: TKnobsSmallKnob;
    mixingscaler_offset3: TKnobsSmallKnob;
    mixingscaler_offset4: TKnobsSmallKnob;
    mixingscaler_offset: TKnobsSmallKnob;
    mixingscaler_out1: TKnobsOutput;
    mixingscaler_out2: TKnobsOutput;
    mixingscaler_out3: TKnobsOutput;
    mixingscaler_out4: TKnobsOutput;
    mixingscaler_outlevel: TKnobsSmallKnob;
    mixingscaler_outmute: TKnobsSelector;
    mixingscaler_sum: TKnobsOutput;
    mixingscaler_textlabel_chain: TKnobsTextLabel;
    mixingscaler_textlabel_gain: TKnobsTextLabel;
    mixingscaler_textlabel_in: TKnobsTextLabel;
    mixingscaler_textlabel_lock: TKnobsTextLabel;
    mixingscaler_textlabel_mute: TKnobsTextLabel;
    mixingscaler_textlabel_offset: TKnobsTextLabel;
    mixingscaler_textlabel_out: TKnobsTextLabel;
    mixingscaler_textlabel_sum: TKnobsTextLabel;
    mixm16to1: TKnobsModule;
    mixm16to1_editlabel: TKnobsEditLabel;
    mixm16to1_in10: TKnobsInput;
    mixm16to1_in11: TKnobsInput;
    mixm16to1_in12: TKnobsInput;
    mixm16to1_in13: TKnobsInput;
    mixm16to1_in14: TKnobsInput;
    mixm16to1_in15: TKnobsInput;
    mixm16to1_in16: TKnobsInput;
    mixm16to1_in1: TKnobsInput;
    mixm16to1_in2: TKnobsInput;
    mixm16to1_in3: TKnobsInput;
    mixm16to1_in4: TKnobsInput;
    mixm16to1_in5: TKnobsInput;
    mixm16to1_in6: TKnobsInput;
    mixm16to1_in7: TKnobsInput;
    mixm16to1_in8: TKnobsInput;
    mixm16to1_in9: TKnobsInput;
    mixm16to1_in: TKnobsInput;
    mixm16to1_lev10: TKnobsSlider;
    mixm16to1_lev11: TKnobsSlider;
    mixm16to1_lev12: TKnobsSlider;
    mixm16to1_lev13: TKnobsSlider;
    mixm16to1_lev14: TKnobsSlider;
    mixm16to1_lev15: TKnobsSlider;
    mixm16to1_lev16: TKnobsSlider;
    mixm16to1_lev1: TKnobsSlider;
    mixm16to1_lev2: TKnobsSlider;
    mixm16to1_lev3: TKnobsSlider;
    mixm16to1_lev4: TKnobsSlider;
    mixm16to1_lev5: TKnobsSlider;
    mixm16to1_lev6: TKnobsSlider;
    mixm16to1_lev7: TKnobsSlider;
    mixm16to1_lev8: TKnobsSlider;
    mixm16to1_lev9: TKnobsSlider;
    mixm16to1_mode: TKnobsSelector;
    mixm16to1_mute: TKnobsSelector;
    mixm16to1_out: TKnobsOutput;
    mixm16to1_textlabel_out: TKnobsTextLabel;
    mixm3to1: TKnobsModule;
    mixm3to1_editlabel: TKnobsEditLabel;
    mixm3to1_in1: TKnobsInput;
    mixm3to1_in2: TKnobsInput;
    mixm3to1_in3: TKnobsInput;
    mixm3to1_in: TKnobsInput;
    mixm3to1_level1: TKnobsSmallKnob;
    mixm3to1_level2: TKnobsSmallKnob;
    mixm3to1_level3: TKnobsSmallKnob;
    mixm3to1_levmod1: TKnobsInput;
    mixm3to1_levmod2: TKnobsInput;
    mixm3to1_levmod3: TKnobsInput;
    mixm3to1_mode: TKnobsSelector;
    mixm3to1_mute1: TKnobsSelector;
    mixm3to1_mute2: TKnobsSelector;
    mixm3to1_mute3: TKnobsSelector;
    mixm3to1_out: TKnobsOutput;
    mixm3to1_textlabel_ins: TKnobsTextLabel;
    mixm3to1_textlabel_mods: TKnobsTextLabel;
    mixm4to1: TKnobsModule;
    mixm4to1_editlabel: TKnobsEditLabel;
    mixm4to1_in1: TKnobsInput;
    mixm4to1_in2: TKnobsInput;
    mixm4to1_in3: TKnobsInput;
    mixm4to1_in4: TKnobsInput;
    mixm4to1_in: TKnobsInput;
    mixm4to1_level1: TKnobsSmallKnob;
    mixm4to1_level2: TKnobsSmallKnob;
    mixm4to1_level3: TKnobsSmallKnob;
    mixm4to1_level4: TKnobsSmallKnob;
    mixm4to1_levmod1: TKnobsInput;
    mixm4to1_levmod2: TKnobsInput;
    mixm4to1_levmod3: TKnobsInput;
    mixm4to1_levmod4: TKnobsInput;
    mixm4to1_mode: TKnobsSelector;
    mixm4to1_mute1: TKnobsSelector;
    mixm4to1_mute2: TKnobsSelector;
    mixm4to1_mute3: TKnobsSelector;
    mixm4to1_mute4: TKnobsSelector;
    mixm4to1_out: TKnobsOutput;
    mixm6to6: TKnobsModule;
    mixm6to6_box_inchains: TKnobsBox;
    mixm6to6_box_ins: TKnobsBox;
    mixm6to6_box_outchains: TKnobsBox;
    mixm6to6_box_outs: TKnobsBox;
    mixm6to6_editlabel: TKnobsEditLabel;
    mixm6to6_in1: TKnobsInput;
    mixm6to6_in2: TKnobsInput;
    mixm6to6_in3: TKnobsInput;
    mixm6to6_in4: TKnobsInput;
    mixm6to6_in5: TKnobsInput;
    mixm6to6_in6: TKnobsInput;
    mixm6to6_inchcol1: TKnobsInput;
    mixm6to6_inchcol2: TKnobsInput;
    mixm6to6_inchcol3: TKnobsInput;
    mixm6to6_inchcol4: TKnobsInput;
    mixm6to6_inchcol5: TKnobsInput;
    mixm6to6_inchcol6: TKnobsInput;
    mixm6to6_inr1c1: TKnobsInput;
    mixm6to6_inr1c2: TKnobsInput;
    mixm6to6_inr1c3: TKnobsInput;
    mixm6to6_inr1c4: TKnobsInput;
    mixm6to6_inr1c5: TKnobsInput;
    mixm6to6_inr1c6: TKnobsInput;
    mixm6to6_inr2c1: TKnobsInput;
    mixm6to6_inr2c2: TKnobsInput;
    mixm6to6_inr2c3: TKnobsInput;
    mixm6to6_inr2c4: TKnobsInput;
    mixm6to6_inr2c5: TKnobsInput;
    mixm6to6_inr2c6: TKnobsInput;
    mixm6to6_inr3c1: TKnobsInput;
    mixm6to6_inr3c2: TKnobsInput;
    mixm6to6_inr3c3: TKnobsInput;
    mixm6to6_inr3c4: TKnobsInput;
    mixm6to6_inr3c5: TKnobsInput;
    mixm6to6_inr3c6: TKnobsInput;
    mixm6to6_inr4c1: TKnobsInput;
    mixm6to6_inr4c2: TKnobsInput;
    mixm6to6_inr4c3: TKnobsInput;
    mixm6to6_inr4c4: TKnobsInput;
    mixm6to6_inr4c5: TKnobsInput;
    mixm6to6_inr4c6: TKnobsInput;
    mixm6to6_inr5c1: TKnobsInput;
    mixm6to6_inr5c2: TKnobsInput;
    mixm6to6_inr5c3: TKnobsInput;
    mixm6to6_inr5c4: TKnobsInput;
    mixm6to6_inr5c5: TKnobsInput;
    mixm6to6_inr5c6: TKnobsInput;
    mixm6to6_inr6c1: TKnobsInput;
    mixm6to6_inr6c2: TKnobsInput;
    mixm6to6_inr6c3: TKnobsInput;
    mixm6to6_inr6c4: TKnobsInput;
    mixm6to6_inr6c5: TKnobsInput;
    mixm6to6_inr6c6: TKnobsInput;
    mixm6to6_levelr1c1: TKnobsSmallKnob;
    mixm6to6_levelr1c2: TKnobsSmallKnob;
    mixm6to6_levelr1c3: TKnobsSmallKnob;
    mixm6to6_levelr1c4: TKnobsSmallKnob;
    mixm6to6_levelr1c5: TKnobsSmallKnob;
    mixm6to6_levelr1c6: TKnobsSmallKnob;
    mixm6to6_levelr2c1: TKnobsSmallKnob;
    mixm6to6_levelr2c2: TKnobsSmallKnob;
    mixm6to6_levelr2c3: TKnobsSmallKnob;
    mixm6to6_levelr2c4: TKnobsSmallKnob;
    mixm6to6_levelr2c5: TKnobsSmallKnob;
    mixm6to6_levelr2c6: TKnobsSmallKnob;
    mixm6to6_levelr3c1: TKnobsSmallKnob;
    mixm6to6_levelr3c2: TKnobsSmallKnob;
    mixm6to6_levelr3c3: TKnobsSmallKnob;
    mixm6to6_levelr3c4: TKnobsSmallKnob;
    mixm6to6_levelr3c5: TKnobsSmallKnob;
    mixm6to6_levelr3c6: TKnobsSmallKnob;
    mixm6to6_levelr4c1: TKnobsSmallKnob;
    mixm6to6_levelr4c2: TKnobsSmallKnob;
    mixm6to6_levelr4c3: TKnobsSmallKnob;
    mixm6to6_levelr4c4: TKnobsSmallKnob;
    mixm6to6_levelr4c5: TKnobsSmallKnob;
    mixm6to6_levelr4c6: TKnobsSmallKnob;
    mixm6to6_levelr5c1: TKnobsSmallKnob;
    mixm6to6_levelr5c2: TKnobsSmallKnob;
    mixm6to6_levelr5c3: TKnobsSmallKnob;
    mixm6to6_levelr5c4: TKnobsSmallKnob;
    mixm6to6_levelr5c5: TKnobsSmallKnob;
    mixm6to6_levelr5c6: TKnobsSmallKnob;
    mixm6to6_levelr6c1: TKnobsSmallKnob;
    mixm6to6_levelr6c2: TKnobsSmallKnob;
    mixm6to6_levelr6c3: TKnobsSmallKnob;
    mixm6to6_levelr6c4: TKnobsSmallKnob;
    mixm6to6_levelr6c5: TKnobsSmallKnob;
    mixm6to6_levelr6c6: TKnobsSmallKnob;
    mixm6to6_mode: TKnobsSelector;
    mixm6to6_mute1: TKnobsSelector;
    mixm6to6_mute2: TKnobsSelector;
    mixm6to6_mute3: TKnobsSelector;
    mixm6to6_mute4: TKnobsSelector;
    mixm6to6_mute5: TKnobsSelector;
    mixm6to6_mute6: TKnobsSelector;
    mixm6to6_out1: TKnobsOutput;
    mixm6to6_out2: TKnobsOutput;
    mixm6to6_out3: TKnobsOutput;
    mixm6to6_out4: TKnobsOutput;
    mixm6to6_out5: TKnobsOutput;
    mixm6to6_out6: TKnobsOutput;
    mixm6to6_outchrow1: TKnobsOutput;
    mixm6to6_outchrow2: TKnobsOutput;
    mixm6to6_outchrow3: TKnobsOutput;
    mixm6to6_outchrow4: TKnobsOutput;
    mixm6to6_outchrow5: TKnobsOutput;
    mixm6to6_outchrow6: TKnobsOutput;
    mixm6to6_textlabel_chains: TKnobsTextLabel;
    mixm6to6_textlabel_in: TKnobsTextLabel;
    mixm6to6_textlabel_out: TKnobsTextLabel;
    mixmm16to1: TKnobsModule;
    mixmm16to1_editlabel: TKnobsEditLabel;
    mixmm16to1_in10: TKnobsInput;
    mixmm16to1_in11: TKnobsInput;
    mixmm16to1_in12: TKnobsInput;
    mixmm16to1_in13: TKnobsInput;
    mixmm16to1_in14: TKnobsInput;
    mixmm16to1_in15: TKnobsInput;
    mixmm16to1_in16: TKnobsInput;
    mixmm16to1_in1: TKnobsInput;
    mixmm16to1_in2: TKnobsInput;
    mixmm16to1_in3: TKnobsInput;
    mixmm16to1_in4: TKnobsInput;
    mixmm16to1_in5: TKnobsInput;
    mixmm16to1_in6: TKnobsInput;
    mixmm16to1_in7: TKnobsInput;
    mixmm16to1_in8: TKnobsInput;
    mixmm16to1_in9: TKnobsInput;
    mixmm16to1_in: TKnobsInput;
    mixmm16to1_lev10: TKnobsSlider;
    mixmm16to1_lev11: TKnobsSlider;
    mixmm16to1_lev12: TKnobsSlider;
    mixmm16to1_lev13: TKnobsSlider;
    mixmm16to1_lev14: TKnobsSlider;
    mixmm16to1_lev15: TKnobsSlider;
    mixmm16to1_lev16: TKnobsSlider;
    mixmm16to1_lev1: TKnobsSlider;
    mixmm16to1_lev2: TKnobsSlider;
    mixmm16to1_lev3: TKnobsSlider;
    mixmm16to1_lev4: TKnobsSlider;
    mixmm16to1_lev5: TKnobsSlider;
    mixmm16to1_lev6: TKnobsSlider;
    mixmm16to1_lev7: TKnobsSlider;
    mixmm16to1_lev8: TKnobsSlider;
    mixmm16to1_lev9: TKnobsSlider;
    mixmm16to1_levmod10: TKnobsInput;
    mixmm16to1_levmod11: TKnobsInput;
    mixmm16to1_levmod12: TKnobsInput;
    mixmm16to1_levmod13: TKnobsInput;
    mixmm16to1_levmod14: TKnobsInput;
    mixmm16to1_levmod15: TKnobsInput;
    mixmm16to1_levmod16: TKnobsInput;
    mixmm16to1_levmod1: TKnobsInput;
    mixmm16to1_levmod2: TKnobsInput;
    mixmm16to1_levmod3: TKnobsInput;
    mixmm16to1_levmod4: TKnobsInput;
    mixmm16to1_levmod5: TKnobsInput;
    mixmm16to1_levmod6: TKnobsInput;
    mixmm16to1_levmod7: TKnobsInput;
    mixmm16to1_levmod8: TKnobsInput;
    mixmm16to1_levmod9: TKnobsInput;
    mixmm16to1_mode: TKnobsSelector;
    mixmm16to1_mute: TKnobsSelector;
    mixmm16to1_out: TKnobsOutput;
    mixmm16to1_textlabel_inputs: TKnobsTextLabel;
    mixmm16to1_textlabel_out: TKnobsTextLabel;
    mixms8to1: TKnobsModule;
    mixms8to1_editlabel: TKnobsEditLabel;
    mixms8to1_inl1: TKnobsInput;
    mixms8to1_inl2: TKnobsInput;
    mixms8to1_inl3: TKnobsInput;
    mixms8to1_inl4: TKnobsInput;
    mixms8to1_inl5: TKnobsInput;
    mixms8to1_inl6: TKnobsInput;
    mixms8to1_inl7: TKnobsInput;
    mixms8to1_inl8: TKnobsInput;
    mixms8to1_inl: TKnobsInput;
    mixms8to1_inr1: TKnobsInput;
    mixms8to1_inr2: TKnobsInput;
    mixms8to1_inr3: TKnobsInput;
    mixms8to1_inr4: TKnobsInput;
    mixms8to1_inr5: TKnobsInput;
    mixms8to1_inr6: TKnobsInput;
    mixms8to1_inr7: TKnobsInput;
    mixms8to1_inr8: TKnobsInput;
    mixms8to1_inr: TKnobsInput;
    mixms8to1_lev1: TKnobsSlider;
    mixms8to1_lev2: TKnobsSlider;
    mixms8to1_lev3: TKnobsSlider;
    mixms8to1_lev4: TKnobsSlider;
    mixms8to1_lev5: TKnobsSlider;
    mixms8to1_lev6: TKnobsSlider;
    mixms8to1_lev7: TKnobsSlider;
    mixms8to1_lev8: TKnobsSlider;
    mixms8to1_levmod1: TKnobsInput;
    mixms8to1_levmod2: TKnobsInput;
    mixms8to1_levmod3: TKnobsInput;
    mixms8to1_levmod4: TKnobsInput;
    mixms8to1_levmod5: TKnobsInput;
    mixms8to1_levmod6: TKnobsInput;
    mixms8to1_levmod7: TKnobsInput;
    mixms8to1_levmod8: TKnobsInput;
    mixms8to1_mode: TKnobsSelector;
    mixms8to1_mute1: TKnobsSelector;
    mixms8to1_mute2: TKnobsSelector;
    mixms8to1_mute3: TKnobsSelector;
    mixms8to1_mute4: TKnobsSelector;
    mixms8to1_mute5: TKnobsSelector;
    mixms8to1_mute6: TKnobsSelector;
    mixms8to1_mute7: TKnobsSelector;
    mixms8to1_mute8: TKnobsSelector;
    mixms8to1_outl: TKnobsOutput;
    mixms8to1_outr: TKnobsOutput;
    mixms8to1_textlabel_inputs: TKnobsTextLabel;
    mixms8to1_textlabel_out: TKnobsTextLabel;
    mixq1to1: TKnobsModule;
    mixq1to1_editlabel: TKnobsEditLabel;
    mixq1to1_inll1: TKnobsInput;
    mixq1to1_inll: TKnobsInput;
    mixq1to1_inlr1: TKnobsInput;
    mixq1to1_inlr: TKnobsInput;
    mixq1to1_inrl1: TKnobsInput;
    mixq1to1_inrl: TKnobsInput;
    mixq1to1_inrr1: TKnobsInput;
    mixq1to1_inrr: TKnobsInput;
    mixq1to1_level1: TKnobsSmallKnob;
    mixq1to1_levmod1: TKnobsInput;
    mixq1to1_mode: TKnobsSelector;
    mixq1to1_mute1: TKnobsSelector;
    mixq1to1_outll: TKnobsOutput;
    mixq1to1_outlr: TKnobsOutput;
    mixq1to1_outrl: TKnobsOutput;
    mixq1to1_outrr: TKnobsOutput;
    mixqs1to1: TKnobsModule;
    mixqs1to1_editlabel: TKnobsEditLabel;
    mixqs1to1_in1l1: TKnobsInput;
    mixqs1to1_in1l2: TKnobsInput;
    mixqs1to1_in1l3: TKnobsInput;
    mixqs1to1_in1l4: TKnobsInput;
    mixqs1to1_in1r1: TKnobsInput;
    mixqs1to1_in1r2: TKnobsInput;
    mixqs1to1_in1r3: TKnobsInput;
    mixqs1to1_in1r4: TKnobsInput;
    mixqs1to1_inl1: TKnobsInput;
    mixqs1to1_inl2: TKnobsInput;
    mixqs1to1_inl3: TKnobsInput;
    mixqs1to1_inl4: TKnobsInput;
    mixqs1to1_inr1: TKnobsInput;
    mixqs1to1_inr2: TKnobsInput;
    mixqs1to1_inr3: TKnobsInput;
    mixqs1to1_inr4: TKnobsInput;
    mixqs1to1_level1: TKnobsSmallKnob;
    mixqs1to1_level2: TKnobsSmallKnob;
    mixqs1to1_level3: TKnobsSmallKnob;
    mixqs1to1_level4: TKnobsSmallKnob;
    mixqs1to1_mutein1: TKnobsSelector;
    mixqs1to1_mutein2: TKnobsSelector;
    mixqs1to1_mutein3: TKnobsSelector;
    mixqs1to1_mutein4: TKnobsSelector;
    mixqs1to1_muteout1: TKnobsSelector;
    mixqs1to1_muteout2: TKnobsSelector;
    mixqs1to1_muteout3: TKnobsSelector;
    mixqs1to1_muteout4: TKnobsSelector;
    mixqs1to1_outl1: TKnobsOutput;
    mixqs1to1_outl2: TKnobsOutput;
    mixqs1to1_outl3: TKnobsOutput;
    mixqs1to1_outl4: TKnobsOutput;
    mixqs1to1_outr1: TKnobsOutput;
    mixqs1to1_outr2: TKnobsOutput;
    mixqs1to1_outr3: TKnobsOutput;
    mixqs1to1_outr4: TKnobsOutput;
    mixqs1to1_textlabel_outputs: TKnobsTextLabel;
    mixqs2to1: TKnobsModule;
    mixqs2to1_editlabel: TKnobsEditLabel;
    mixqs2to1_in1l1: TKnobsInput;
    mixqs2to1_in1l2: TKnobsInput;
    mixqs2to1_in1l3: TKnobsInput;
    mixqs2to1_in1l4: TKnobsInput;
    mixqs2to1_in1r1: TKnobsInput;
    mixqs2to1_in1r2: TKnobsInput;
    mixqs2to1_in1r3: TKnobsInput;
    mixqs2to1_in1r4: TKnobsInput;
    mixqs2to1_in2l1: TKnobsInput;
    mixqs2to1_in2l2: TKnobsInput;
    mixqs2to1_in2l3: TKnobsInput;
    mixqs2to1_in2l4: TKnobsInput;
    mixqs2to1_in2r1: TKnobsInput;
    mixqs2to1_in2r2: TKnobsInput;
    mixqs2to1_in2r3: TKnobsInput;
    mixqs2to1_in2r4: TKnobsInput;
    mixqs2to1_level11: TKnobsSmallKnob;
    mixqs2to1_level12: TKnobsSmallKnob;
    mixqs2to1_level13: TKnobsSmallKnob;
    mixqs2to1_level14: TKnobsSmallKnob;
    mixqs2to1_level21: TKnobsSmallKnob;
    mixqs2to1_level22: TKnobsSmallKnob;
    mixqs2to1_level23: TKnobsSmallKnob;
    mixqs2to1_level24: TKnobsSmallKnob;
    mixqs2to1_mute1in1: TKnobsSelector;
    mixqs2to1_mute1in2: TKnobsSelector;
    mixqs2to1_mute1in3: TKnobsSelector;
    mixqs2to1_mute1in4: TKnobsSelector;
    mixqs2to1_mute2in1: TKnobsSelector;
    mixqs2to1_mute2in2: TKnobsSelector;
    mixqs2to1_mute2in3: TKnobsSelector;
    mixqs2to1_mute2in4: TKnobsSelector;
    mixqs2to1_muteout1: TKnobsSelector;
    mixqs2to1_muteout2: TKnobsSelector;
    mixqs2to1_muteout3: TKnobsSelector;
    mixqs2to1_muteout4: TKnobsSelector;
    mixqs2to1_outl1: TKnobsOutput;
    mixqs2to1_outl2: TKnobsOutput;
    mixqs2to1_outl3: TKnobsOutput;
    mixqs2to1_outl4: TKnobsOutput;
    mixqs2to1_outr1: TKnobsOutput;
    mixqs2to1_outr2: TKnobsOutput;
    mixqs2to1_outr3: TKnobsOutput;
    mixqs2to1_outr4: TKnobsOutput;
    mixqs2to1_textlabel_channels: TKnobsTextLabel;
    mixs2to1: TKnobsModule;
    mixs2to1_editlabel: TKnobsEditLabel;
    mixs2to1_inl1: TKnobsInput;
    mixs2to1_inl2: TKnobsInput;
    mixs2to1_inl: TKnobsInput;
    mixs2to1_inr1: TKnobsInput;
    mixs2to1_inr2: TKnobsInput;
    mixs2to1_inr: TKnobsInput;
    mixs2to1_level1: TKnobsSmallKnob;
    mixs2to1_level2: TKnobsSmallKnob;
    mixs2to1_levmod1: TKnobsInput;
    mixs2to1_levmod2: TKnobsInput;
    mixs2to1_mode: TKnobsSelector;
    mixs2to1_mute1: TKnobsSelector;
    mixs2to1_mute2: TKnobsSelector;
    mixs2to1_outl: TKnobsOutput;
    mixs2to1_outr: TKnobsOutput;
    mixs5to1: TKnobsModule;
    mixs5to1_editlabel: TKnobsEditLabel;
    mixs5to1_inl1: TKnobsInput;
    mixs5to1_inl2: TKnobsInput;
    mixs5to1_inl3: TKnobsInput;
    mixs5to1_inl4: TKnobsInput;
    mixs5to1_inl5: TKnobsInput;
    mixs5to1_inl: TKnobsInput;
    mixs5to1_inr1: TKnobsInput;
    mixs5to1_inr2: TKnobsInput;
    mixs5to1_inr3: TKnobsInput;
    mixs5to1_inr4: TKnobsInput;
    mixs5to1_inr5: TKnobsInput;
    mixs5to1_inr: TKnobsInput;
    mixs5to1_level1: TKnobsSmallKnob;
    mixs5to1_level2: TKnobsSmallKnob;
    mixs5to1_level3: TKnobsSmallKnob;
    mixs5to1_level4: TKnobsSmallKnob;
    mixs5to1_level5: TKnobsSmallKnob;
    mixs5to1_levmod1: TKnobsInput;
    mixs5to1_levmod2: TKnobsInput;
    mixs5to1_levmod3: TKnobsInput;
    mixs5to1_levmod4: TKnobsInput;
    mixs5to1_levmod5: TKnobsInput;
    mixs5to1_mode: TKnobsSelector;
    mixs5to1_mute1: TKnobsSelector;
    mixs5to1_mute2: TKnobsSelector;
    mixs5to1_mute3: TKnobsSelector;
    mixs5to1_mute4: TKnobsSelector;
    mixs5to1_mute5: TKnobsSelector;
    mixs5to1_outl: TKnobsOutput;
    mixs5to1_outr: TKnobsOutput;
    mixt1to1: TKnobsModule;
    mixt1to1_editlabel: TKnobsEditLabel;
    mixt1to1_inl1: TKnobsInput;
    mixt1to1_inl: TKnobsInput;
    mixt1to1_inm1: TKnobsInput;
    mixt1to1_inm: TKnobsInput;
    mixt1to1_inr1: TKnobsInput;
    mixt1to1_inr: TKnobsInput;
    mixt1to1_level1: TKnobsSmallKnob;
    mixt1to1_levmod1: TKnobsInput;
    mixt1to1_mode: TKnobsSelector;
    mixt1to1_mute1: TKnobsSelector;
    mixt1to1_outl: TKnobsOutput;
    mixt1to1_outm: TKnobsOutput;
    mixt1to1_outr: TKnobsOutput;
    modal: TKnobsModule;
    modal_editlabel: TKnobsEditLabel;
    modal_fi: TKnobsSelector;
    modal_fm: TKnobsInput;
    modal_fmamt: TKnobsSmallKnob;
    modal_freq10: TKnobsSmallKnob;
    modal_freq11: TKnobsSmallKnob;
    modal_freq1: TKnobsSmallKnob;
    modal_freq2: TKnobsSmallKnob;
    modal_freq3: TKnobsSmallKnob;
    modal_freq4: TKnobsSmallKnob;
    modal_freq5: TKnobsSmallKnob;
    modal_freq6: TKnobsSmallKnob;
    modal_freq7: TKnobsSmallKnob;
    modal_freq8: TKnobsSmallKnob;
    modal_freq9: TKnobsSmallKnob;
    modal_freq: TKnobsSmallKnob;
    modal_in: TKnobsInput;
    modal_level10: TKnobsSmallKnob;
    modal_level11: TKnobsSmallKnob;
    modal_level1: TKnobsSmallKnob;
    modal_level2: TKnobsSmallKnob;
    modal_level3: TKnobsSmallKnob;
    modal_level4: TKnobsSmallKnob;
    modal_level5: TKnobsSmallKnob;
    modal_level6: TKnobsSmallKnob;
    modal_level7: TKnobsSmallKnob;
    modal_level8: TKnobsSmallKnob;
    modal_level9: TKnobsSmallKnob;
    modal_level: TKnobsSmallKnob;
    modal_out: TKnobsOutput;
    modal_q10: TKnobsSmallKnob;
    modal_q11: TKnobsSmallKnob;
    modal_q1: TKnobsSmallKnob;
    modal_q2: TKnobsSmallKnob;
    modal_q3: TKnobsSmallKnob;
    modal_q4: TKnobsSmallKnob;
    modal_q5: TKnobsSmallKnob;
    modal_q6: TKnobsSmallKnob;
    modal_q7: TKnobsSmallKnob;
    modal_q8: TKnobsSmallKnob;
    modal_q9: TKnobsSmallKnob;
    modal_rnda: TKnobsSelector;
    modal_rndf: TKnobsSelector;
    modal_rndq: TKnobsSelector;
    modal_textlable_fm: TKnobsTextLabel;
    modal_textlable_fma: TKnobsTextLabel;
    modal_textlable_fmf: TKnobsTextLabel;
    modal_textlable_fmq: TKnobsTextLabel;
    modal_textlable_freq: TKnobsTextLabel;
    modal_textlable_in: TKnobsTextLabel;
    modal_textlable_lev: TKnobsTextLabel;
    modal_textlable_out: TKnobsTextLabel;
    modal_textlable_rnd: TKnobsTextLabel;
    modquantizer: TKnobsModule;
    modquantizer_basenote: TKnobsSmallKnob;
    modquantizer_chain: TKnobsInput;
    modquantizer_ctrl0: TKnobsInput;
    modquantizer_ctrl10: TKnobsInput;
    modquantizer_ctrl11: TKnobsInput;
    modquantizer_ctrl1: TKnobsInput;
    modquantizer_ctrl2: TKnobsInput;
    modquantizer_ctrl3: TKnobsInput;
    modquantizer_ctrl4: TKnobsInput;
    modquantizer_ctrl5: TKnobsInput;
    modquantizer_ctrl6: TKnobsInput;
    modquantizer_ctrl7: TKnobsInput;
    modquantizer_ctrl8: TKnobsInput;
    modquantizer_ctrl9: TKnobsInput;
    modquantizer_display_basenote: TKnobsDisplay;
    modquantizer_editlabel: TKnobsEditLabel;
    modquantizer_in: TKnobsInput;
    modquantizer_indicator_note0: TKnobsIndicator;
    modquantizer_indicator_note10: TKnobsIndicator;
    modquantizer_indicator_note11: TKnobsIndicator;
    modquantizer_indicator_note1: TKnobsIndicator;
    modquantizer_indicator_note2: TKnobsIndicator;
    modquantizer_indicator_note3: TKnobsIndicator;
    modquantizer_indicator_note4: TKnobsIndicator;
    modquantizer_indicator_note5: TKnobsIndicator;
    modquantizer_indicator_note6: TKnobsIndicator;
    modquantizer_indicator_note7: TKnobsIndicator;
    modquantizer_indicator_note8: TKnobsIndicator;
    modquantizer_indicator_note9: TKnobsIndicator;
    modquantizer_level: TKnobsSmallKnob;
    modquantizer_note0: TKnobsSelector;
    modquantizer_note10: TKnobsSelector;
    modquantizer_note11: TKnobsSelector;
    modquantizer_note1: TKnobsSelector;
    modquantizer_note2: TKnobsSelector;
    modquantizer_note3: TKnobsSelector;
    modquantizer_note4: TKnobsSelector;
    modquantizer_note5: TKnobsSelector;
    modquantizer_note6: TKnobsSelector;
    modquantizer_note7: TKnobsSelector;
    modquantizer_note8: TKnobsSelector;
    modquantizer_note9: TKnobsSelector;
    modquantizer_out: TKnobsOutput;
    modquantizer_textlabel_chain: TKnobsTextLabel;
    modquantizer_textlabel_level: TKnobsTextLabel;
    modquantizer_textlabel_transpose: TKnobsTextLabel;
    monadic: TKnobsModule;
    monadic_editlabel: TKnobsEditLabel;
    monadic_function: TKnobsSelector;
    monadic_out: TKnobsOutput;
    monadic_textlabel_f: TKnobsTextLabel;
    monadic_textlabel_x: TKnobsTextLabel;
    monadic_x: TKnobsInput;
    morse: TKnobsModule;
    morse_clock: TKnobsInput;
    morse_display_text: TKnobsDisplay;
    morse_editlabel: TKnobsEditLabel;
    morse_indicator_clock: TKnobsIndicator;
    morse_indicator_out: TKnobsIndicator;
    morse_indicator_reset: TKnobsIndicator;
    morse_out: TKnobsOutput;
    morse_reset: TKnobsInput;
    morse_textlabel_clock: TKnobsTextLabel;
    morse_textlabel_res: TKnobsTextLabel;
    multicompare: TKnobsModule;
    multicompare_bussel1: TKnobsSelector;
    multicompare_bussel2: TKnobsSelector;
    multicompare_bussel3: TKnobsSelector;
    multicompare_bussel4: TKnobsSelector;
    multicompare_bussel5: TKnobsSelector;
    multicompare_bussel6: TKnobsSelector;
    multicompare_bussel7: TKnobsSelector;
    multicompare_bussel8: TKnobsSelector;
    multicompare_clr: TKnobsSelector;
    multicompare_editlabel: TKnobsEditLabel;
    multicompare_in: TKnobsInput;
    multicompare_inamt: TKnobsSmallKnob;
    multicompare_inamtmod: TKnobsInput;
    multicompare_indicator_out1: TKnobsIndicator;
    multicompare_indicator_out2: TKnobsIndicator;
    multicompare_indicator_out3: TKnobsIndicator;
    multicompare_indicator_pos1: TKnobsIndicator;
    multicompare_indicator_pos2: TKnobsIndicator;
    multicompare_indicator_pos3: TKnobsIndicator;
    multicompare_indicator_pos4: TKnobsIndicator;
    multicompare_indicator_pos5: TKnobsIndicator;
    multicompare_indicator_pos6: TKnobsIndicator;
    multicompare_indicator_pos7: TKnobsIndicator;
    multicompare_indicator_pos8: TKnobsIndicator;
    multicompare_level1: TKnobsSmallKnob;
    multicompare_level2: TKnobsSmallKnob;
    multicompare_level3: TKnobsSmallKnob;
    multicompare_level4: TKnobsSmallKnob;
    multicompare_level5: TKnobsSmallKnob;
    multicompare_level6: TKnobsSmallKnob;
    multicompare_level7: TKnobsSmallKnob;
    multicompare_level8: TKnobsSmallKnob;
    multicompare_out1: TKnobsOutput;
    multicompare_out2: TKnobsOutput;
    multicompare_out3: TKnobsOutput;
    multicompare_pos1: TKnobsOutput;
    multicompare_pos2: TKnobsOutput;
    multicompare_pos3: TKnobsOutput;
    multicompare_pos4: TKnobsOutput;
    multicompare_pos5: TKnobsOutput;
    multicompare_pos6: TKnobsOutput;
    multicompare_pos7: TKnobsOutput;
    multicompare_pos8: TKnobsOutput;
    multicompare_rnd: TKnobsSelector;
    multicompare_textlabel_in: TKnobsTextLabel;
    multicompare_textlabel_inlevel: TKnobsTextLabel;
    multicompare_textlabel_out1: TKnobsTextLabel;
    multicompare_textlabel_out2: TKnobsTextLabel;
    multicompare_textlabel_out3: TKnobsTextLabel;
    multicompare_textlabel_pos1: TKnobsTextLabel;
    multicompare_textlabel_pos2: TKnobsTextLabel;
    multicompare_textlabel_pos3: TKnobsTextLabel;
    multicompare_textlabel_pos4: TKnobsTextLabel;
    multicompare_textlabel_pos5: TKnobsTextLabel;
    multicompare_textlabel_pos6: TKnobsTextLabel;
    multicompare_textlabel_pos7: TKnobsTextLabel;
    multicompare_textlabel_pos8: TKnobsTextLabel;
    multimult: TKnobsModule;
    multimult_editlabel: TKnobsEditLabel;
    multimult_in1: TKnobsInput;
    multimult_in2: TKnobsInput;
    multimult_in3: TKnobsInput;
    multimult_in4: TKnobsInput;
    multimult_in5: TKnobsInput;
    multimult_in6: TKnobsInput;
    multimult_in7: TKnobsInput;
    multimult_in8: TKnobsInput;
    multimult_mult: TKnobsInput;
    multimult_out1: TKnobsOutput;
    multimult_out2: TKnobsOutput;
    multimult_out3: TKnobsOutput;
    multimult_out4: TKnobsOutput;
    multimult_out5: TKnobsOutput;
    multimult_out6: TKnobsOutput;
    multimult_out7: TKnobsOutput;
    multimult_out8: TKnobsOutput;
    multimult_textlabel_mult: TKnobsTextLabel;
    multiplemult: TKnobsModule;
    multiplemult_editlabel: TKnobsEditLabel;
    multiplemult_in11: TKnobsInput;
    multiplemult_in12: TKnobsInput;
    multiplemult_in21: TKnobsInput;
    multiplemult_in22: TKnobsInput;
    multiplemult_in31: TKnobsInput;
    multiplemult_in32: TKnobsInput;
    multiplemult_in41: TKnobsInput;
    multiplemult_in42: TKnobsInput;
    multiplemult_out1: TKnobsOutput;
    multiplemult_out2: TKnobsOutput;
    multiplemult_out3: TKnobsOutput;
    multiplemult_out4: TKnobsOutput;
    multiplier: TKnobsModule;
    multiplier_editlabel: TKnobsEditLabel;
    multiplier_in1: TKnobsInput;
    multiplier_in2: TKnobsInput;
    multiplier_in3: TKnobsInput;
    multiplier_in4: TKnobsInput;
    multiplier_mute: TKnobsSelector;
    multiplier_out: TKnobsOutput;
    multisandh: TKnobsModule;
    multisandh_editlabel: TKnobsEditLabel;
    multisandh_in10: TKnobsInput;
    multisandh_in11: TKnobsInput;
    multisandh_in12: TKnobsInput;
    multisandh_in1: TKnobsInput;
    multisandh_in2: TKnobsInput;
    multisandh_in3: TKnobsInput;
    multisandh_in4: TKnobsInput;
    multisandh_in5: TKnobsInput;
    multisandh_in6: TKnobsInput;
    multisandh_in7: TKnobsInput;
    multisandh_in8: TKnobsInput;
    multisandh_in9: TKnobsInput;
    multisandh_indicator_trig: TKnobsIndicator;
    multisandh_out10: TKnobsOutput;
    multisandh_out11: TKnobsOutput;
    multisandh_out12: TKnobsOutput;
    multisandh_out1: TKnobsOutput;
    multisandh_out2: TKnobsOutput;
    multisandh_out3: TKnobsOutput;
    multisandh_out4: TKnobsOutput;
    multisandh_out5: TKnobsOutput;
    multisandh_out6: TKnobsOutput;
    multisandh_out7: TKnobsOutput;
    multisandh_out8: TKnobsOutput;
    multisandh_out9: TKnobsOutput;
    multisandh_symbol_trig: TImage;
    multisandh_textlabel_trig: TKnobsTextLabel;
    multisandh_trig: TKnobsInput;
    mux: TKnobsModule;
    mux_control: TKnobsInput;
    mux_editlabel: TKnobsEditLabel;
    mux_in0: TKnobsInput;
    mux_in10: TKnobsInput;
    mux_in11: TKnobsInput;
    mux_in1: TKnobsInput;
    mux_in2: TKnobsInput;
    mux_in3: TKnobsInput;
    mux_in4: TKnobsInput;
    mux_in5: TKnobsInput;
    mux_in6: TKnobsInput;
    mux_in7: TKnobsInput;
    mux_in8: TKnobsInput;
    mux_in9: TKnobsInput;
    mux_indicator_0: TKnobsIndicator;
    mux_indicator_10: TKnobsIndicator;
    mux_indicator_11: TKnobsIndicator;
    mux_indicator_1: TKnobsIndicator;
    mux_indicator_2: TKnobsIndicator;
    mux_indicator_3: TKnobsIndicator;
    mux_indicator_4: TKnobsIndicator;
    mux_indicator_5: TKnobsIndicator;
    mux_indicator_6: TKnobsIndicator;
    mux_indicator_7: TKnobsIndicator;
    mux_indicator_8: TKnobsIndicator;
    mux_indicator_9: TKnobsIndicator;
    mux_out: TKnobsOutput;
    mux_texxtlabel_control: TKnobsTextLabel;
    mux_texxtlabel_crossfade: TKnobsTextLabel;
    mux_xfade: TKnobsSmallKnob;
    noise: TKnobsModule;
    noise_color: TKnobsSmallKnob;
    noise_colormod: TKnobsInput;
    noise_colormodamt: TKnobsSmallKnob;
    noise_display_color: TKnobsDisplay;
    noise_editlabel: TKnobsEditLabel;
    noise_mute: TKnobsSelector;
    noise_out: TKnobsOutput;
    noise_textlabel_color: TKnobsTextLabel;
    noise_textlabel_colormod2: TKnobsTextLabel;
    noiselfo: TKnobsModule;
    noiselfo_color: TKnobsSmallKnob;
    noiselfo_colormod: TKnobsInput;
    noiselfo_colormodamt: TKnobsSmallKnob;
    noiselfo_display_color: TKnobsDisplay;
    noiselfo_editlabel: TKnobsEditLabel;
    noiselfo_indicator_out: TKnobsIndicator;
    noiselfo_mute: TKnobsSelector;
    noiselfo_out: TKnobsOutput;
    noiselfo_outputtype: TKnobsSelector;
    noiselfo_textlabel_color: TKnobsTextLabel;
    noiselfo_textlabel_colormod: TKnobsTextLabel;
    noiselfo_textlabel_out: TKnobsTextLabel;
    noiselfotrig: TKnobsModule;
    noiselfotrig_color: TKnobsSmallKnob;
    noiselfotrig_colormod: TKnobsInput;
    noiselfotrig_colormodamt: TKnobsSmallKnob;
    noiselfotrig_display_color: TKnobsDisplay;
    noiselfotrig_editlabel: TKnobsEditLabel;
    noiselfotrig_indicator_out: TKnobsIndicator;
    noiselfotrig_indicator_trig: TKnobsIndicator;
    noiselfotrig_mute: TKnobsSelector;
    noiselfotrig_out: TKnobsOutput;
    noiselfotrig_outputtype: TKnobsSelector;
    noiselfotrig_symbol_trig: TImage;
    noiselfotrig_textlabel_out: TKnobsTextLabel;
    noiselfotrig_textlabel_trig: TKnobsTextLabel;
    noiselfotrig_trig: TKnobsInput;
    noiselfotrix_textlabel_color: TKnobsTextLabel;
    noisetrig: TKnobsModule;
    noisetrig_color: TKnobsSmallKnob;
    noisetrig_colormod: TKnobsInput;
    noisetrig_colormodamt: TKnobsSmallKnob;
    noisetrig_display_color: TKnobsDisplay;
    noisetrig_editlabel: TKnobsEditLabel;
    noisetrig_mute: TKnobsSelector;
    noisetrig_out: TKnobsOutput;
    noisetrig_symbol_trig: TImage;
    noisetrig_textlabel_color: TKnobsTextLabel;
    noisetrig_textlabel_colormod2: TKnobsTextLabel;
    noisetrig_textlabel_trig: TKnobsTextLabel;
    noisetrig_trig: TKnobsInput;
    note_tabsheet: TTabSheet;
    notequantizer: TKnobsModule;
    notequantizer_editlabel: TKnobsEditLabel;
    notequantizer_in: TKnobsInput;
    notequantizer_level: TKnobsSmallKnob;
    notequantizer_note0: TKnobsSelector;
    notequantizer_note10: TKnobsSelector;
    notequantizer_note11: TKnobsSelector;
    notequantizer_note1: TKnobsSelector;
    notequantizer_note2: TKnobsSelector;
    notequantizer_note3: TKnobsSelector;
    notequantizer_note4: TKnobsSelector;
    notequantizer_note5: TKnobsSelector;
    notequantizer_note6: TKnobsSelector;
    notequantizer_note7: TKnobsSelector;
    notequantizer_note8: TKnobsSelector;
    notequantizer_note9: TKnobsSelector;
    notequantizer_out: TKnobsOutput;
    notequantizer_textlabel_level: TKnobsTextLabel;
    notes: TKnobsModule;
    notes_display: TKnobsDisplay;
    notes_editlabel: TKnobsEditLabel;
    notetodelay: TKnobsModule;
    notetodelay_editlabel: TKnobsEditLabel;
    notetodelay_in: TKnobsInput;
    notetodelay_out: TKnobsOutput;
    notetodelay_textlabel_in: TKnobsTextLabel;
    notetodelay_textlabel_out: TKnobsTextLabel;
    osc: TKnobsModule;
    osc_bandlimit: TKnobsSmallKnob;
    osc_cents: TKnobsSmallKnob;
    osc_display_cents: TKnobsDisplay;
    osc_display_frequency: TKnobsDisplay;
    osc_editlabel: TKnobsEditLabel;
    osc_fm: TKnobsInput;
    osc_fmlevel: TKnobsSmallKnob;
    osc_freq: TKnobsInput;
    osc_frequency: TKnobsSmallKnob;
    osc_mute: TKnobsSelector;
    osc_out: TKnobsOutput;
    osc_phase: TKnobsInput;
    osc_pmlevel: TKnobsSmallKnob;
    osc_shape: TKnobsSelector;
    osc_symbol_sync: TImage;
    osc_sync: TKnobsInput;
    osc_tabsheet: TTabSheet;
    osc_textlabel_blimit: TKnobsTextLabel;
    osc_textlabel_fm: TKnobsTextLabel;
    osc_textlabel_freq: TKnobsTextLabel;
    osc_textlabel_phase: TKnobsTextLabel;
    osc_textlabel_sync: TKnobsTextLabel;
    oscmessage: TKnobsModule;
    oscmessage_display_address: TKnobsDisplay;
    oscmessage_editlabel: TKnobsEditLabel;
    oscmessage_indicator_syncout: TKnobsIndicator;
    oscmessage_indicator_trigger: TKnobsIndicator;
    oscmessage_input: TKnobsInput;
    oscmessage_out: TKnobsOutput;
    oscmessage_symbol_trigger: TImage;
    oscmessage_textlabel_address: TKnobsTextLabel;
    oscmessage_textlabel_out: TKnobsTextLabel;
    oscmessage_textlabel_send: TKnobsTextLabel;
    oscmessage_trigger: TKnobsInput;
    osctrig: TKnobsModule;
    osctrig_bandlimit: TKnobsSmallKnob;
    osctrig_cents: TKnobsSmallKnob;
    osctrig_count: TKnobsNoKnob;
    osctrig_display_cents: TKnobsDisplay;
    osctrig_display_count: TKnobsDisplay;
    osctrig_display_frequency: TKnobsDisplay;
    osctrig_editlabel: TKnobsEditLabel;
    osctrig_fm: TKnobsInput;
    osctrig_fmlevel: TKnobsSmallKnob;
    osctrig_freq: TKnobsInput;
    osctrig_frequency: TKnobsSmallKnob;
    osctrig_mute: TKnobsSelector;
    osctrig_out: TKnobsOutput;
    osctrig_shape: TKnobsSelector;
    osctrig_symbol_trig: TImage;
    osctrig_textlabel_bandlimit: TKnobsTextLabel;
    osctrig_textlabel_count: TKnobsTextLabel;
    osctrig_textlabel_fm: TKnobsTextLabel;
    osctrig_textlabel_freq: TKnobsTextLabel;
    osctrig_textlabel_shape: TKnobsTextLabel;
    osctrig_textlabel_trig: TKnobsTextLabel;
    osctrig_trig: TKnobsInput;
    pad: TKnobsModule;
    pad_editlabel: TKnobsEditLabel;
    pad_outputtype: TKnobsSelector;
    pad_pad: TKnobsPad;
    pad_textlabel_x: TKnobsTextLabel;
    pad_textlabel_y: TKnobsTextLabel;
    pad_x: TKnobsOutput;
    pad_y: TKnobsOutput;
    pan: TKnobsModule;
    pan_control: TKnobsInput;
    pan_editlabel: TKnobsEditLabel;
    pan_fadertype: TKnobsSelector;
    pan_in: TKnobsInput;
    pan_intype: TKnobsSelector;
    pan_out1: TKnobsOutput;
    pan_out2: TKnobsOutput;
    pan_position: TKnobsSmallKnob;
    pan_posmod: TKnobsSmallKnob;
    pan_textlabel_control: TKnobsTextLabel;
    pan_textlabel_in: TKnobsTextLabel;
    pan_textlabel_out1: TKnobsTextLabel;
    pan_textlabel_out2: TKnobsTextLabel;
    panel1: TKnobsModule;
    panel1_editlabel: TKnobsEditLabel;
    panel2: TKnobsModule;
    panel2_editlabel: TKnobsEditLabel;
    panel3: TKnobsModule;
    panel3_editlabel: TKnobsEditLabel;
    panel4: TKnobsModule;
    panel4_editlabel: TKnobsEditLabel;
    panel5: TKnobsModule;
    panel5_editlabel: TKnobsEditLabel;
    pattern: TKnobsModule;
    pattern_display_step1: TKnobsDisplay;
    pattern_display_step2: TKnobsDisplay;
    pattern_display_step3: TKnobsDisplay;
    pattern_display_step4: TKnobsDisplay;
    pattern_display_step5: TKnobsDisplay;
    pattern_display_step6: TKnobsDisplay;
    pattern_display_step7: TKnobsDisplay;
    pattern_display_step8: TKnobsDisplay;
    pattern_editlabel: TKnobsEditLabel;
    pattern_indicator_out: TKnobsIndicator;
    pattern_indicator_res: TKnobsIndicator;
    pattern_indicator_trig: TKnobsIndicator;
    pattern_out: TKnobsOutput;
    pattern_res: TKnobsInput;
    pattern_step1: TKnobsSmallKnob;
    pattern_step2: TKnobsSmallKnob;
    pattern_step3: TKnobsSmallKnob;
    pattern_step4: TKnobsSmallKnob;
    pattern_step5: TKnobsSmallKnob;
    pattern_step6: TKnobsSmallKnob;
    pattern_step7: TKnobsSmallKnob;
    pattern_step8: TKnobsSmallKnob;
    pattern_symbol_res: TImage;
    pattern_symbol_trig: TImage;
    pattern_textlabel_durations: TKnobsTextLabel;
    pattern_textlabel_res: TKnobsTextLabel;
    pattern_textlabel_trig: TKnobsTextLabel;
    pattern_trig: TKnobsInput;
    phasedetect: TKnobsModule;
    phasedetect_alpha: TKnobsSmallKnob;
    phasedetect_alphamod: TKnobsInput;
    phasedetect_alphamodamt: TKnobsSmallKnob;
    phasedetect_editlabel: TKnobsEditLabel;
    phasedetect_in1: TKnobsInput;
    phasedetect_in2: TKnobsInput;
    phasedetect_indicator_down: TKnobsIndicator;
    phasedetect_indicator_lock: TKnobsIndicator;
    phasedetect_indicator_up: TKnobsIndicator;
    phasedetect_lock: TKnobsOutput;
    phasedetect_out: TKnobsOutput;
    phasedetect_textlabel_cmpin: TKnobsTextLabel;
    phasedetect_textlabel_filter: TKnobsTextLabel;
    phasedetect_textlabel_filterout: TKnobsTextLabel;
    phasedetect_textlabel_lock: TKnobsTextLabel;
    phasedetect_textlabel_sigin: TKnobsTextLabel;
    phasedetect_type: TKnobsSelector;
    phasedetect_typesel: TKnobsInput;
    phasedistort: TKnobsModule;
    phasedistort_delay: TKnobsInput;
    phasedistort_display_freq: TKnobsDisplay;
    phasedistort_display_length: TKnobsDisplay;
    phasedistort_drywet: TKnobsSmallKnob;
    phasedistort_editlabel: TKnobsEditLabel;
    phasedistort_fm: TKnobsInput;
    phasedistort_fmlevel: TKnobsSmallKnob;
    phasedistort_freq: TKnobsInput;
    phasedistort_frequency: TKnobsSmallKnob;
    phasedistort_inl: TKnobsInput;
    phasedistort_inr: TKnobsInput;
    phasedistort_intensity: TKnobsSmallKnob;
    phasedistort_intensitymod: TKnobsInput;
    phasedistort_intensitymodlev: TKnobsSmallKnob;
    phasedistort_length: TKnobsSmallKnob;
    phasedistort_mode: TKnobsSelector;
    phasedistort_mute: TKnobsSelector;
    phasedistort_outl: TKnobsOutput;
    phasedistort_outr: TKnobsOutput;
    phasedistort_q: TKnobsSmallKnob;
    phasedistort_textlabel_delay: TKnobsTextLabel;
    phasedistort_textlabel_drywet: TKnobsTextLabel;
    phasedistort_textlabel_filter: TKnobsTextLabel;
    phasedistort_textlabel_fm: TKnobsTextLabel;
    phasedistort_textlabel_frq: TKnobsTextLabel;
    phasedistort_textlabel_im: TKnobsTextLabel;
    phasedistort_textlabel_intensity: TKnobsTextLabel;
    phasedistort_textlabel_l: TKnobsTextLabel;
    phasedistort_textlabel_q: TKnobsTextLabel;
    phasedistort_textlabel_r: TKnobsTextLabel;
    pichchange_freezein: TKnobsInput;
    pinkfilter: TKnobsModule;
    pinkfilter_editlabel: TKnobsEditLabel;
    pinkfilter_gain: TKnobsSmallKnob;
    pinkfilter_in: TKnobsInput;
    pinkfilter_mode: TKnobsSelector;
    pinkfilter_out: TKnobsOutput;
    pinkfilter_textlabel_gain: TKnobsTextLabel;
    pinkfilter_texxtlabel_in: TKnobsTextLabel;
    pitchchange: TKnobsModule;
    pitchchange_delay: TKnobsSmallKnob;
    pitchchange_depth: TKnobsSmallKnob;
    pitchchange_dry: TKnobsSmallKnob;
    pitchchange_editlabel: TKnobsEditLabel;
    pitchchange_feedback: TKnobsSmallKnob;
    pitchchange_freeze: TKnobsSelector;
    pitchchange_in: TKnobsInput;
    pitchchange_mute: TKnobsSelector;
    pitchchange_out: TKnobsOutput;
    pitchchange_rate: TKnobsSmallKnob;
    pitchchange_textlabel_delay: TKnobsTextLabel;
    pitchchange_textlabel_depth: TKnobsTextLabel;
    pitchchange_textlabel_dry: TKnobsTextLabel;
    pitchchange_textlabel_feedback: TKnobsTextLabel;
    pitchchange_textlabel_rate: TKnobsTextLabel;
    pitchchange_textlabel_wet: TKnobsTextLabel;
    pitchchange_wet: TKnobsSmallKnob;
    pitchshift: TKnobsModule;
    pitchshift_delay: TKnobsSmallKnob;
    pitchshift_display_delay: TKnobsDisplay;
    pitchshift_display_shift: TKnobsDisplay;
    pitchshift_display_shiftfine: TKnobsDisplay;
    pitchshift_editlabel: TKnobsEditLabel;
    pitchshift_in: TKnobsInput;
    pitchshift_mute: TKnobsSelector;
    pitchshift_out: TKnobsOutput;
    pitchshift_shift: TKnobsSmallKnob;
    pitchshift_shiftfine: TKnobsSmallKnob;
    pitchshift_shiftmod: TKnobsInput;
    pitchshift_shiftmodamt: TKnobsSmallKnob;
    pitchshift_textlabel_delay: TKnobsTextLabel;
    pitchshift_textlabel_shift: TKnobsTextLabel;
    pluck: TKnobsModule;
    pluck_bclevel: TKnobsSmallKnob;
    pluck_brighctrl: TKnobsInput;
    pluck_brightness: TKnobsSmallKnob;
    pluck_cents: TKnobsSmallKnob;
    pluck_display_cents: TKnobsDisplay;
    pluck_display_frequency: TKnobsDisplay;
    pluck_editlabel: TKnobsEditLabel;
    pluck_feedback: TKnobsSmallKnob;
    pluck_fm: TKnobsInput;
    pluck_fmlevel: TKnobsSmallKnob;
    pluck_freq: TKnobsInput;
    pluck_frequency: TKnobsSmallKnob;
    pluck_mute: TKnobsSelector;
    pluck_noise: TKnobsSmallKnob;
    pluck_noisedepth: TKnobsSmallKnob;
    pluck_noisemod: TKnobsInput;
    pluck_out: TKnobsOutput;
    pluck_pluck: TKnobsInput;
    pluck_plucklevel: TKnobsSmallKnob;
    pluck_textlabel_brightnesss: TKnobsTextLabel;
    pluck_textlabel_feedback: TKnobsTextLabel;
    pluck_textlabel_fm: TKnobsTextLabel;
    pluck_textlabel_freq: TKnobsTextLabel;
    pluck_textlabel_noise: TKnobsTextLabel;
    pluck_textlabel_pluck: TKnobsTextLabel;
    polar: TKnobsModule;
    polar_editlabel: TKnobsEditLabel;
    polar_inx: TKnobsInput;
    polar_iny: TKnobsInput;
    polar_outa: TKnobsOutput;
    polar_outd: TKnobsOutput;
    polar_textlabel_ad: TKnobsTextLabel;
    polar_textlabel_xy: TKnobsTextLabel;
    progdivider: TKnobsModule;
    progdivider_display_highcount: TKnobsDisplay;
    progdivider_display_lowcount: TKnobsDisplay;
    progdivider_display_steps: TKnobsDisplay;
    progdivider_editlabel: TKnobsEditLabel;
    progdivider_highcount: TKnobsSmallKnob;
    progdivider_indicator_out: TKnobsIndicator;
    progdivider_lowcount: TKnobsSmallKnob;
    progdivider_mode: TKnobsSelector;
    progdivider_out: TKnobsOutput;
    progdivider_outputtype: TKnobsSelector;
    progdivider_reset: TKnobsInput;
    progdivider_select: TKnobsInput;
    progdivider_selectlev: TKnobsSmallKnob;
    progdivider_steps: TKnobsSmallKnob;
    progdivider_symbol_reset: TImage;
    progdivider_symbol_trig: TImage;
    progdivider_textlabel_highcount: TKnobsTextLabel;
    progdivider_textlabel_lowcount: TKnobsTextLabel;
    progdivider_textlabel_reset: TKnobsTextLabel;
    progdivider_textlabel_select: TKnobsTextLabel;
    progdivider_textlabel_steps: TKnobsTextLabel;
    progdivider_textlabel_trig: TKnobsTextLabel;
    progdivider_trig: TKnobsInput;
    pulsedelay: TKnobsModule;
    pulsedelay_delay: TKnobsSmallKnob;
    pulsedelay_delaymod: TKnobsInput;
    pulsedelay_delaymodamt: TKnobsSmallKnob;
    pulsedelay_delaymode: TKnobsSelector;
    pulsedelay_display_delay: TKnobsDisplay;
    pulsedelay_editlabel: TKnobsEditLabel;
    pulsedelay_indicator_active: TKnobsIndicator;
    pulsedelay_indicator_out: TKnobsIndicator;
    pulsedelay_out: TKnobsOutput;
    pulsedelay_outputtype: TKnobsSelector;
    pulsedelay_range: TKnobsSelector;
    pulsedelay_reset: TKnobsInput;
    pulsedelay_symbol_reset: TImage;
    pulsedelay_symbol_trig: TImage;
    pulsedelay_textlabel_delay: TKnobsTextLabel;
    pulsedelay_textlabel_mode: TKnobsTextLabel;
    pulsedelay_textlabel_reset: TKnobsTextLabel;
    pulsedelay_textlabel_trig: TKnobsTextLabel;
    pulsedelay_trig: TKnobsInput;
    pulses: TKnobsModule;
    pulses_display_frequency: TKnobsDisplay;
    pulses_dist: TKnobsSmallKnob;
    pulses_distmod: TKnobsInput;
    pulses_distmodamt: TKnobsSmallKnob;
    pulses_editlabel: TKnobsEditLabel;
    pulses_frequency: TKnobsSmallKnob;
    pulses_indicator_out: TKnobsIndicator;
    pulses_lambda: TKnobsSmallKnob;
    pulses_out: TKnobsOutput;
    pulses_outputtype: TKnobsSelector;
    pulses_range: TKnobsSelector;
    pulses_rndmode: TKnobsSelector;
    pulses_syncmode: TKnobsSelector;
    pulses_textlabel_distribution: TKnobsTextLabel;
    pulses_textlabel_lambda: TKnobsTextLabel;
    pulses_textlabel_out: TKnobsTextLabel;
    quadpan: TKnobsModule;
    quadpan_editlabel: TKnobsEditLabel;
    quadpan_in1: TKnobsInput;
    quadpan_in2: TKnobsInput;
    quadpan_in3: TKnobsInput;
    quadpan_in4: TKnobsInput;
    quadpan_level1: TKnobsSmallKnob;
    quadpan_level2: TKnobsSmallKnob;
    quadpan_level3: TKnobsSmallKnob;
    quadpan_level4: TKnobsSmallKnob;
    quadpan_outl1: TKnobsOutput;
    quadpan_outl2: TKnobsOutput;
    quadpan_outl3: TKnobsOutput;
    quadpan_outl4: TKnobsOutput;
    quadpan_outr1: TKnobsOutput;
    quadpan_outr2: TKnobsOutput;
    quadpan_outr3: TKnobsOutput;
    quadpan_outr4: TKnobsOutput;
    quantizer: TKnobsModule;
    quantizer_display_qsteps: TKnobsDisplay;
    quantizer_editlabel: TKnobsEditLabel;
    quantizer_in: TKnobsInput;
    quantizer_level: TKnobsSmallKnob;
    quantizer_mute: TKnobsSelector;
    quantizer_out: TKnobsOutput;
    quantizer_qsteps: TKnobsSmallKnob;
    quantizer_textlabel_in: TKnobsTextLabel;
    randomwalklfo: TKnobsModule;
    randomwalklfo_color: TKnobsSmallKnob;
    randomwalklfo_colormod: TKnobsInput;
    randomwalklfo_colormodamt: TKnobsSmallKnob;
    randomwalklfo_display_distance: TKnobsDisplay;
    randomwalklfo_display_frequency: TKnobsDisplay;
    randomwalklfo_distance: TKnobsSmallKnob;
    randomwalklfo_editlabel: TKnobsEditLabel;
    randomwalklfo_fm: TKnobsInput;
    randomwalklfo_fmlevel: TKnobsSmallKnob;
    randomwalklfo_frequency: TKnobsSmallKnob;
    randomwalklfo_indicator_outx: TKnobsIndicator;
    randomwalklfo_indicator_outy: TKnobsIndicator;
    randomwalklfo_indicator_outz: TKnobsIndicator;
    randomwalklfo_lambda: TKnobsSmallKnob;
    randomwalklfo_mode: TKnobsSelector;
    randomwalklfo_mute: TKnobsSelector;
    randomwalklfo_outputtype: TKnobsSelector;
    randomwalklfo_outx: TKnobsOutput;
    randomwalklfo_outy: TKnobsOutput;
    randomwalklfo_outz: TKnobsOutput;
    randomwalklfo_range: TKnobsSelector;
    randomwalklfo_textlabel_color: TKnobsTextLabel;
    randomwalklfo_textlabel_distance: TKnobsTextLabel;
    randomwalklfo_textlabel_fm: TKnobsTextLabel;
    randomwalklfo_textlabel_frequency: TKnobsTextLabel;
    randomwalklfo_textlabel_lambda: TKnobsTextLabel;
    randomwalklfo_textlabel_x: TKnobsTextLabel;
    randomwalklfo_textlabel_y: TKnobsTextLabel;
    randomwalklfo_textlabel_z: TKnobsTextLabel;
    randsig: TKnobsModule;
    randsig_display_frequency: TKnobsDisplay;
    randsig_dist: TKnobsSmallKnob;
    randsig_distmod: TKnobsInput;
    randsig_distmodamt: TKnobsSmallKnob;
    randsig_editlabel: TKnobsEditLabel;
    randsig_fm: TKnobsInput;
    randsig_fmlevel: TKnobsSmallKnob;
    randsig_freq: TKnobsInput;
    randsig_frequency: TKnobsSmallKnob;
    randsig_indicator_active: TKnobsIndicator;
    randsig_lambda: TKnobsSmallKnob;
    randsig_mode: TKnobsSelector;
    randsig_mute: TKnobsSelector;
    randsig_out: TKnobsOutput;
    randsig_outputtype: TKnobsSelector;
    randsig_range: TKnobsSelector;
    randsig_textlabel_distribution: TKnobsTextLabel;
    randsig_textlabel_fm: TKnobsTextLabel;
    randsig_textlabel_lambda: TKnobsTextLabel;
    randsig_textlabel_out: TKnobsTextLabel;
    rangeconverter: TKnobsModule;
    rangeconverter_display_highvalue: TKnobsDisplay;
    rangeconverter_display_lowvalue: TKnobsDisplay;
    rangeconverter_editlabel: TKnobsEditLabel;
    rangeconverter_highvalue: TKnobsSmallKnob;
    rangeconverter_in1: TKnobsInput;
    rangeconverter_in2: TKnobsInput;
    rangeconverter_in3: TKnobsInput;
    rangeconverter_in4: TKnobsInput;
    rangeconverter_lowvalue: TKnobsSmallKnob;
    rangeconverter_mode: TKnobsSelector;
    rangeconverter_out1: TKnobsOutput;
    rangeconverter_out2: TKnobsOutput;
    rangeconverter_out3: TKnobsOutput;
    rangeconverter_out4: TKnobsOutput;
    rangeconverter_textlabel_highvalue: TKnobsTextLabel;
    rangeconverter_textlabel_lowvalue: TKnobsTextLabel;
    rangeconverter_textlabel_sigtype: TKnobsTextLabel;
    ratio: TKnobsModule;
    ratio_display_divider: TKnobsDisplay;
    ratio_display_multiplier: TKnobsDisplay;
    ratio_divider: TKnobsSmallKnob;
    ratio_editlabel: TKnobsEditLabel;
    ratio_in1: TKnobsInput;
    ratio_in2: TKnobsInput;
    ratio_in3: TKnobsInput;
    ratio_in4: TKnobsInput;
    ratio_multiplier: TKnobsSmallKnob;
    ratio_mute: TKnobsSelector;
    ratio_out1: TKnobsOutput;
    ratio_out2: TKnobsOutput;
    ratio_out3: TKnobsOutput;
    ratio_out4: TKnobsOutput;
    ratio_textlabel_divider: TKnobsTextLabel;
    ratio_textlabel_multiplier: TKnobsTextLabel;
    reciprocal: TKnobsModule;
    reciprocal_editlabel: TKnobsEditLabel;
    reciprocal_out: TKnobsOutput;
    reciprocal_textlabel_f: TKnobsTextLabel;
    reciprocal_textlabel_x: TKnobsTextLabel;
    reciprocal_x: TKnobsInput;
    rectangular: TKnobsModule;
    rectangular_editlabel: TKnobsEditLabel;
    rectangular_ina: TKnobsInput;
    rectangular_ind: TKnobsInput;
    rectangular_outx: TKnobsOutput;
    rectangular_outy: TKnobsOutput;
    rectangular_textlabel_ad: TKnobsTextLabel;
    rectangular_textlabel_xy: TKnobsTextLabel;
    resonator: TKnobsModule;
    resonator_cents: TKnobsSmallKnob;
    resonator_click: TKnobsSmallKnob;
    resonator_decay: TKnobsSmallKnob;
    resonator_display_cents: TKnobsDisplay;
    resonator_display_damp: TKnobsDisplay;
    resonator_display_frequency: TKnobsDisplay;
    resonator_display_inlevel: TKnobsDisplay;
    resonator_dm: TKnobsInput;
    resonator_dmlevel: TKnobsSmallKnob;
    resonator_editlabel: TKnobsEditLabel;
    resonator_fm: TKnobsInput;
    resonator_fmlevel: TKnobsSmallKnob;
    resonator_freq: TKnobsInput;
    resonator_frequency: TKnobsSmallKnob;
    resonator_in: TKnobsInput;
    resonator_inlevel: TKnobsNoKnob;
    resonator_out: TKnobsOutput;
    resonator_pm: TKnobsInput;
    resonator_pmlevel: TKnobsSmallKnob;
    resonator_textlabel_click: TKnobsTextLabel;
    resonator_textlabel_decay: TKnobsTextLabel;
    resonator_textlabel_dm: TKnobsTextLabel;
    resonator_textlabel_fm: TKnobsTextLabel;
    resonator_textlabel_freq: TKnobsTextLabel;
    resonator_textlabel_in: TKnobsTextLabel;
    resonator_textlabel_out: TKnobsTextLabel;
    resonator_textlabel_pm: TKnobsTextLabel;
    reverb: TKnobsModule;
    reverb_damp: TKnobsSmallKnob;
    reverb_dry: TKnobsSmallKnob;
    reverb_editlabel: TKnobsEditLabel;
    reverb_freezein: TKnobsInput;
    reverb_inl: TKnobsInput;
    reverb_inr: TKnobsInput;
    reverb_knobbox: TKnobsBox;
    reverb_mode: TKnobsSelector;
    reverb_mute: TKnobsSelector;
    reverb_outl: TKnobsOutput;
    reverb_outr: TKnobsOutput;
    reverb_roomsize: TKnobsSmallKnob;
    reverb_scale: TKnobsSmallKnob;
    reverb_textlabel_damp: TKnobsTextLabel;
    reverb_textlabel_dry: TKnobsTextLabel;
    reverb_textlabel_l: TKnobsTextLabel;
    reverb_textlabel_r: TKnobsTextLabel;
    reverb_textlabel_scale: TKnobsTextLabel;
    reverb_textlabel_size: TKnobsTextLabel;
    reverb_textlabel_wet: TKnobsTextLabel;
    reverb_textlabel_width: TKnobsTextLabel;
    reverb_wet: TKnobsSmallKnob;
    reverb_width: TKnobsSmallKnob;
    rms: TKnobsModule;
    rms_display_time: TKnobsDisplay;
    rms_editlabel: TKnobsEditLabel;
    rms_in: TKnobsInput;
    rms_out: TKnobsOutput;
    rms_textlabel_in: TKnobsTextLabel;
    rms_textlabel_out: TKnobsTextLabel;
    rms_textlabel_time: TKnobsTextLabel;
    rms_time: TKnobsSmallKnob;
    rndgranulator: TKnobsModule;
    rndgranulator_delay: TKnobsInput;
    rndgranulator_delaytime: TKnobsSmallKnob;
    rndgranulator_display_delaytime: TKnobsDisplay;
    rndgranulator_display_duration: TKnobsDisplay;
    rndgranulator_display_grains: TKnobsDisplay;
    rndgranulator_display_interonset: TKnobsDisplay;
    rndgranulator_editlabel: TKnobsEditLabel;
    rndgranulator_envtype: TKnobsSelector;
    rndgranulator_graincount: TKnobsSmallKnob;
    rndgranulator_grainduration: TKnobsSmallKnob;
    rndgranulator_graindurationmod: TKnobsInput;
    rndgranulator_graindurationmodamt: TKnobsSmallKnob;
    rndgranulator_grainoffset: TKnobsInput;
    rndgranulator_in: TKnobsInput;
    rndgranulator_interonset: TKnobsSmallKnob;
    rndgranulator_interonsetmod: TKnobsInput;
    rndgranulator_interonsetmodamt: TKnobsSmallKnob;
    rndgranulator_mute: TKnobsSelector;
    rndgranulator_outl: TKnobsOutput;
    rndgranulator_outr: TKnobsOutput;
    rndgranulator_pan: TKnobsSmallKnob;
    rndgranulator_panmod: TKnobsInput;
    rndgranulator_panmodamt: TKnobsSmallKnob;
    rndgranulator_range: TKnobsSelector;
    rndgranulator_rec: TKnobsInput;
    rndgranulator_record: TKnobsSelector;
    rndgranulator_textlabel_dlymod: TKnobsTextLabel;
    rndgranulator_textlabel_duration: TKnobsTextLabel;
    rndgranulator_textlabel_envtype: TKnobsTextLabel;
    rndgranulator_textlabel_grainoffset: TKnobsTextLabel;
    rndgranulator_textlabel_grains: TKnobsTextLabel;
    rndgranulator_textlabel_in: TKnobsTextLabel;
    rndgranulator_textlabel_interonset: TKnobsTextLabel;
    rndgranulator_textlabel_maxdelay: TKnobsTextLabel;
    rndgranulator_textlabel_out: TKnobsTextLabel;
    rndgranulator_textlabel_vol: TKnobsTextLabel;
    rndgranulator_texxtlabel_pan: TKnobsTextLabel;
    rndgranulator_volume: TKnobsSmallKnob;
    rndgranulator_volumemod: TKnobsInput;
    rndgranulator_volumemodamt: TKnobsSmallKnob;
    rsflipflop: TKnobsModule;
    rsflipflop_editlabel: TKnobsEditLabel;
    rsflipflop_image: TImage;
    rsflipflop_indicator_notq: TKnobsIndicator;
    rsflipflop_indicator_q: TKnobsIndicator;
    rsflipflop_notq: TKnobsOutput;
    rsflipflop_outputtype: TKnobsSelector;
    rsflipflop_q: TKnobsOutput;
    rsflipflop_r: TKnobsInput;
    rsflipflop_s: TKnobsInput;
    rsflipflop_textlabel_trigmode: TKnobsTextLabel;
    rsflipflop_trigmode: TKnobsSelector;
    rungler: TKnobsModule;
    rungler_bit: TKnobsOutput;
    rungler_clock: TKnobsInput;
    rungler_data: TKnobsInput;
    rungler_display_length: TKnobsDisplay;
    rungler_display_taps: TKnobsDisplay;
    rungler_editlabel: TKnobsEditLabel;
    rungler_indicator_led: TKnobsIndicator;
    rungler_length: TKnobsSmallKnob;
    rungler_level: TKnobsSmallKnob;
    rungler_out: TKnobsOutput;
    rungler_taps: TKnobsSmallKnob;
    rungler_textlabel_bit: TKnobsTextLabel;
    rungler_textlabel_clock: TKnobsTextLabel;
    rungler_textlabel_data: TKnobsTextLabel;
    rungler_textlabel_length: TKnobsTextLabel;
    rungler_textlabel_level: TKnobsTextLabel;
    rungler_textlabel_out: TKnobsTextLabel;
    rungler_textlabel_taps: TKnobsTextLabel;
    sampleandhold: TKnobsModule;
    sampleandhold_editlabel: TKnobsEditLabel;
    sampleandhold_in: TKnobsInput;
    sampleandhold_indicator_trig: TKnobsIndicator;
    sampleandhold_label_in: TKnobsTextLabel;
    sampleandhold_label_trig: TKnobsTextLabel;
    sampleandhold_out: TKnobsOutput;
    sampleandhold_symbol_trig: TImage;
    sampleandhold_trig: TKnobsInput;
    savedstuff_pagecontrol: TPageControl;
    scala: TKnobsModule;
    scala_editlabel: TKnobsEditLabel;
    scala_fileselector_mapping: TKnobsFileSelector;
    scala_fileselector_scale: TKnobsFileSelector;
    scala_in: TKnobsInput;
    scala_out: TKnobsOutput;
    scala_textlabel_in: TKnobsTextLabel;
    scalequantizer: TKnobsModule;
    scalequantizer_basenote: TKnobsSmallKnob;
    scalequantizer_chain: TKnobsInput;
    scalequantizer_display_basenote: TKnobsDisplay;
    scalequantizer_editlabel: TKnobsEditLabel;
    scalequantizer_in: TKnobsInput;
    scalequantizer_level: TKnobsSmallKnob;
    scalequantizer_note0: TKnobsSelector;
    scalequantizer_note10: TKnobsSelector;
    scalequantizer_note11: TKnobsSelector;
    scalequantizer_note1: TKnobsSelector;
    scalequantizer_note2: TKnobsSelector;
    scalequantizer_note3: TKnobsSelector;
    scalequantizer_note4: TKnobsSelector;
    scalequantizer_note5: TKnobsSelector;
    scalequantizer_note6: TKnobsSelector;
    scalequantizer_note7: TKnobsSelector;
    scalequantizer_note8: TKnobsSelector;
    scalequantizer_note9: TKnobsSelector;
    scalequantizer_out: TKnobsOutput;
    scalequantizer_scale: TKnobsSelector;
    scalequantizer_textlabel_chain: TKnobsTextLabel;
    scalequantizer_textlabel_level: TKnobsTextLabel;
    scalequantizer_textlabel_preset: TKnobsTextLabel;
    scalequantizer_textlabel_transpose: TKnobsTextLabel;
    scaler: TKnobsModule;
    scaler_display_gain: TKnobsDisplay;
    scaler_display_offset: TKnobsDisplay;
    scaler_editlabel: TKnobsEditLabel;
    scaler_gain: TKnobsSmallKnob;
    scaler_in1: TKnobsInput;
    scaler_in2: TKnobsInput;
    scaler_in3: TKnobsInput;
    scaler_in4: TKnobsInput;
    scaler_mode: TKnobsSelector;
    scaler_mute: TKnobsSelector;
    scaler_offset: TKnobsSmallKnob;
    scaler_out1: TKnobsOutput;
    scaler_out2: TKnobsOutput;
    scaler_out3: TKnobsOutput;
    scaler_out4: TKnobsOutput;
    scaler_sum: TKnobsOutput;
    scaler_textlabel_gain: TKnobsTextLabel;
    scaler_textlabel_lock: TKnobsTextLabel;
    scaler_textlabel_offset: TKnobsTextLabel;
    scaler_textlabel_sum: TKnobsTextLabel;
    separator_filter1: TKnobsModule;
    separator_io1: TKnobsModule;
    separator_io2: TKnobsModule;
    separator_lfo1: TKnobsModule;
    separator_osc1: TKnobsModule;
    separator_osc2: TKnobsModule;
    seq16: TKnobsModule;
    seq16_active: TKnobsInput;
    seq16_chain: TKnobsInput;
    seq16_clr: TKnobsSelector;
    seq16_curvedown: TKnobsSelector;
    seq16_curveup: TKnobsSelector;
    seq16_dir: TKnobsInput;
    seq16_display_steps: TKnobsDisplay;
    seq16_editlabel: TKnobsEditLabel;
    seq16_indicator_active: TKnobsIndicator;
    seq16_indicator_dir: TKnobsIndicator;
    seq16_indicator_reset: TKnobsIndicator;
    seq16_indicator_step10: TKnobsIndicator;
    seq16_indicator_step11: TKnobsIndicator;
    seq16_indicator_step12: TKnobsIndicator;
    seq16_indicator_step13: TKnobsIndicator;
    seq16_indicator_step14: TKnobsIndicator;
    seq16_indicator_step15: TKnobsIndicator;
    seq16_indicator_step16: TKnobsIndicator;
    seq16_indicator_step1: TKnobsIndicator;
    seq16_indicator_step2: TKnobsIndicator;
    seq16_indicator_step3: TKnobsIndicator;
    seq16_indicator_step4: TKnobsIndicator;
    seq16_indicator_step5: TKnobsIndicator;
    seq16_indicator_step6: TKnobsIndicator;
    seq16_indicator_step7: TKnobsIndicator;
    seq16_indicator_step8: TKnobsIndicator;
    seq16_indicator_step9: TKnobsIndicator;
    seq16_indicator_trig: TKnobsIndicator;
    seq16_mode: TKnobsSelector;
    seq16_out: TKnobsOutput;
    seq16_outdir: TKnobsOutput;
    seq16_outres: TKnobsOutput;
    seq16_outtrig: TKnobsOutput;
    seq16_res: TKnobsInput;
    seq16_rnd: TKnobsSelector;
    seq16_step10: TKnobsSlider;
    seq16_step11: TKnobsSlider;
    seq16_step12: TKnobsSlider;
    seq16_step13: TKnobsSlider;
    seq16_step14: TKnobsSlider;
    seq16_step15: TKnobsSlider;
    seq16_step16: TKnobsSlider;
    seq16_step1: TKnobsSlider;
    seq16_step2: TKnobsSlider;
    seq16_step3: TKnobsSlider;
    seq16_step4: TKnobsSlider;
    seq16_step5: TKnobsSlider;
    seq16_step6: TKnobsSlider;
    seq16_step7: TKnobsSlider;
    seq16_step8: TKnobsSlider;
    seq16_step9: TKnobsSlider;
    seq16_steps: TKnobsNoKnob;
    seq16_symbol_reset: TImage;
    seq16_symbol_trig: TImage;
    seq16_textlabel_active: TKnobsTextLabel;
    seq16_textlabel_chain: TKnobsTextLabel;
    seq16_textlabel_dir: TKnobsTextLabel;
    seq16_textlabel_reset: TKnobsTextLabel;
    seq16_textlabel_steps1: TKnobsTextLabel;
    seq16_textlabel_trig: TKnobsTextLabel;
    seq16_textlabel_xfade: TKnobsTextLabel;
    seq16_trig: TKnobsInput;
    seq16_xfade: TKnobsSmallKnob;
    seqchord: TKnobsModule;
    seqchord_active0: TKnobsInput;
    seqchord_active1: TKnobsInput;
    seqchord_active2: TKnobsInput;
    seqchord_active3: TKnobsInput;
    seqchord_degree0: TKnobsSelector;
    seqchord_degree1: TKnobsSelector;
    seqchord_degree2: TKnobsSelector;
    seqchord_degree3: TKnobsSelector;
    seqchord_display_transpose: TKnobsDisplay;
    seqchord_editlabel: TKnobsEditLabel;
    seqchord_gate: TKnobsInput;
    seqchord_gatein0: TKnobsInput;
    seqchord_gatein1: TKnobsInput;
    seqchord_gatein2: TKnobsInput;
    seqchord_gatein3: TKnobsInput;
    seqchord_gateout0: TKnobsOutput;
    seqchord_gateout1: TKnobsOutput;
    seqchord_gateout2: TKnobsOutput;
    seqchord_gateout3: TKnobsOutput;
    seqchord_indicator_active0: TKnobsIndicator;
    seqchord_indicator_active1: TKnobsIndicator;
    seqchord_indicator_active2: TKnobsIndicator;
    seqchord_indicator_active3: TKnobsIndicator;
    seqchord_indicator_gate: TKnobsIndicator;
    seqchord_indicator_gatein0: TKnobsIndicator;
    seqchord_indicator_gatein1: TKnobsIndicator;
    seqchord_indicator_gatein2: TKnobsIndicator;
    seqchord_indicator_gatein3: TKnobsIndicator;
    seqchord_indicator_gateout0: TKnobsIndicator;
    seqchord_indicator_gateout1: TKnobsIndicator;
    seqchord_indicator_gateout2: TKnobsIndicator;
    seqchord_indicator_gateout3: TKnobsIndicator;
    seqchord_inver0: TKnobsSelector;
    seqchord_inver1: TKnobsSelector;
    seqchord_inver2: TKnobsSelector;
    seqchord_inver3: TKnobsSelector;
    seqchord_notein0: TKnobsInput;
    seqchord_notein1: TKnobsInput;
    seqchord_notein2: TKnobsInput;
    seqchord_notein3: TKnobsInput;
    seqchord_noteout0: TKnobsOutput;
    seqchord_noteout1: TKnobsOutput;
    seqchord_noteout2: TKnobsOutput;
    seqchord_noteout3: TKnobsOutput;
    seqchord_octave0: TKnobsSelector;
    seqchord_octave1: TKnobsSelector;
    seqchord_octave2: TKnobsSelector;
    seqchord_octave3: TKnobsSelector;
    seqchord_reduce: TKnobsSelector;
    seqchord_slew: TKnobsSmallKnob;
    seqchord_textlabel_active: TKnobsTextLabel;
    seqchord_textlabel_degree: TKnobsTextLabel;
    seqchord_textlabel_inver: TKnobsTextLabel;
    seqchord_textlabel_mode: TKnobsTextLabel;
    seqchord_textlabel_octave: TKnobsTextLabel;
    seqchord_textlabel_slew: TKnobsTextLabel;
    seqchord_textlabel_transpose: TKnobsTextLabel;
    seqchord_textlabel_type: TKnobsTextLabel;
    seqchord_textlable_gate: TKnobsTextLabel;
    seqchord_transpose: TKnobsSmallKnob;
    seqchord_type0: TKnobsSelector;
    seqchord_type1: TKnobsSelector;
    seqchord_type2: TKnobsSelector;
    seqchord_type3: TKnobsSelector;
    seqrandom: TKnobsModule;
    seqrandom_basenote: TKnobsSmallKnob;
    seqrandom_chain: TKnobsInput;
    seqrandom_changeone: TKnobsInput;
    seqrandom_count: TKnobsSmallKnob;
    seqrandom_display_basenote: TKnobsDisplay;
    seqrandom_display_count: TKnobsDisplay;
    seqrandom_display_highnote: TKnobsDisplay;
    seqrandom_display_lownote: TKnobsDisplay;
    seqrandom_dist: TKnobsSmallKnob;
    seqrandom_distmod: TKnobsInput;
    seqrandom_distmodamt: TKnobsSmallKnob;
    seqrandom_editlabel: TKnobsEditLabel;
    seqrandom_highnote: TKnobsSmallKnob;
    seqrandom_indicator_changeone: TKnobsIndicator;
    seqrandom_indicator_trig: TKnobsIndicator;
    seqrandom_lownote: TKnobsSmallKnob;
    seqrandom_out: TKnobsOutput;
    seqrandom_scale: TKnobsSelector;
    seqrandom_symbol_changeone: TImage;
    seqrandom_symbol_trig: TImage;
    seqrandom_textlabel_basenote: TKnobsTextLabel;
    seqrandom_textlabel_chain: TKnobsTextLabel;
    seqrandom_textlabel_change: TKnobsTextLabel;
    seqrandom_textlabel_count: TKnobsTextLabel;
    seqrandom_textlabel_highnote: TKnobsTextLabel;
    seqrandom_textlabel_lownote: TKnobsTextLabel;
    seqrandom_textlabel_out: TKnobsTextLabel;
    seqrandom_textlabel_rnddistribution: TKnobsTextLabel;
    seqrandom_textlabel_scalesel: TKnobsTextLabel;
    seqrandom_textlabel_step: TKnobsTextLabel;
    seqrandom_trig: TKnobsInput;
    seqrandval: TKnobsModule;
    seqrandval_basevalue: TKnobsSmallKnob;
    seqrandval_chain: TKnobsInput;
    seqrandval_changeone: TKnobsInput;
    seqrandval_count: TKnobsSmallKnob;
    seqrandval_display_basevalye: TKnobsDisplay;
    seqrandval_display_count: TKnobsDisplay;
    seqrandval_display_highvalue: TKnobsDisplay;
    seqrandval_display_lowvalue: TKnobsDisplay;
    seqrandval_display_qsteps: TKnobsDisplay;
    seqrandval_dist: TKnobsSmallKnob;
    seqrandval_distmod: TKnobsInput;
    seqrandval_distmodamt: TKnobsSmallKnob;
    seqrandval_editlabel: TKnobsEditLabel;
    seqrandval_highvalue: TKnobsSmallKnob;
    seqrandval_indicator_trig: TKnobsIndicator;
    seqrandval_indicatorr_changeone: TKnobsIndicator;
    seqrandval_lowvalue: TKnobsSmallKnob;
    seqrandval_out: TKnobsOutput;
    seqrandval_qsteps: TKnobsSmallKnob;
    seqrandval_quantize: TKnobsSelector;
    seqrandval_slew: TKnobsSmallKnob;
    seqrandval_slewmode: TKnobsSelector;
    seqrandval_symbol_changeone: TImage;
    seqrandval_symbol_trig: TImage;
    seqrandval_textlabel_basevalue: TKnobsTextLabel;
    seqrandval_textlabel_chain: TKnobsTextLabel;
    seqrandval_textlabel_change: TKnobsTextLabel;
    seqrandval_textlabel_count: TKnobsTextLabel;
    seqrandval_textlabel_dist: TKnobsTextLabel;
    seqrandval_textlabel_highvalue: TKnobsTextLabel;
    seqrandval_textlabel_lowvalue: TKnobsTextLabel;
    seqrandval_textlabel_out: TKnobsTextLabel;
    seqrandval_textlabel_qyantize: TKnobsTextLabel;
    seqrandval_textlabel_slew: TKnobsTextLabel;
    seqrandval_textlabel_step: TKnobsTextLabel;
    seqrandval_trig: TKnobsInput;
    seqseq: TKnobsModule;
    seqseq_dir: TKnobsInput;
    seqseq_display_steps: TKnobsDisplay;
    seqseq_editlabel: TKnobsEditLabel;
    seqseq_indicator_dir: TKnobsIndicator;
    seqseq_indicator_res: TKnobsIndicator;
    seqseq_indicator_step10: TKnobsIndicator;
    seqseq_indicator_step11: TKnobsIndicator;
    seqseq_indicator_step12: TKnobsIndicator;
    seqseq_indicator_step13: TKnobsIndicator;
    seqseq_indicator_step14: TKnobsIndicator;
    seqseq_indicator_step15: TKnobsIndicator;
    seqseq_indicator_step16: TKnobsIndicator;
    seqseq_indicator_step1: TKnobsIndicator;
    seqseq_indicator_step2: TKnobsIndicator;
    seqseq_indicator_step3: TKnobsIndicator;
    seqseq_indicator_step4: TKnobsIndicator;
    seqseq_indicator_step5: TKnobsIndicator;
    seqseq_indicator_step6: TKnobsIndicator;
    seqseq_indicator_step7: TKnobsIndicator;
    seqseq_indicator_step8: TKnobsIndicator;
    seqseq_indicator_step9: TKnobsIndicator;
    seqseq_indicator_trig: TKnobsIndicator;
    seqseq_out10: TKnobsOutput;
    seqseq_out11: TKnobsOutput;
    seqseq_out12: TKnobsOutput;
    seqseq_out13: TKnobsOutput;
    seqseq_out14: TKnobsOutput;
    seqseq_out15: TKnobsOutput;
    seqseq_out16: TKnobsOutput;
    seqseq_out1: TKnobsOutput;
    seqseq_out2: TKnobsOutput;
    seqseq_out3: TKnobsOutput;
    seqseq_out4: TKnobsOutput;
    seqseq_out5: TKnobsOutput;
    seqseq_out6: TKnobsOutput;
    seqseq_out7: TKnobsOutput;
    seqseq_out8: TKnobsOutput;
    seqseq_out9: TKnobsOutput;
    seqseq_outdir: TKnobsOutput;
    seqseq_outres: TKnobsOutput;
    seqseq_outtrig: TKnobsOutput;
    seqseq_res: TKnobsInput;
    seqseq_resmod: TKnobsSelector;
    seqseq_steps: TKnobsNoKnob;
    seqseq_symbol_res: TImage;
    seqseq_symbol_trig: TImage;
    seqseq_textlabel_dir: TKnobsTextLabel;
    seqseq_textlabel_res: TKnobsTextLabel;
    seqseq_textlabel_steps: TKnobsTextLabel;
    seqseq_textlabel_trig: TKnobsTextLabel;
    seqseq_trig: TKnobsInput;
    sequencer1_tabsheet: TTabSheet;
    simplegranulator: TKnobsModule;
    simplegranulator_delay: TKnobsInput;
    simplegranulator_delaytime: TKnobsSmallKnob;
    simplegranulator_display_delaytime: TKnobsDisplay;
    simplegranulator_display_grainduration: TKnobsDisplay;
    simplegranulator_display_grains: TKnobsDisplay;
    simplegranulator_editlabel: TKnobsEditLabel;
    simplegranulator_envtype: TKnobsSelector;
    simplegranulator_graincount: TKnobsSmallKnob;
    simplegranulator_grainduration: TKnobsSmallKnob;
    simplegranulator_graindurationmod: TKnobsInput;
    simplegranulator_graindurationmodamt: TKnobsSmallKnob;
    simplegranulator_grainoffset: TKnobsInput;
    simplegranulator_in: TKnobsInput;
    simplegranulator_mute: TKnobsSelector;
    simplegranulator_out: TKnobsOutput;
    simplegranulator_range: TKnobsSelector;
    simplegranulator_rec: TKnobsInput;
    simplegranulator_record: TKnobsSelector;
    simplegranulator_symbol_trig: TImage;
    simplegranulator_textlabel_duration: TKnobsTextLabel;
    simplegranulator_textlabel_envtype: TKnobsTextLabel;
    simplegranulator_textlabel_grainoffset: TKnobsTextLabel;
    simplegranulator_textlabel_grains: TKnobsTextLabel;
    simplegranulator_textlabel_grainspeed: TKnobsTextLabel;
    simplegranulator_textlabel_in: TKnobsTextLabel;
    simplegranulator_textlabel_maxdelay: TKnobsTextLabel;
    simplegranulator_textlabel_out: TKnobsTextLabel;
    simplegranulator_textlabel_trig: TKnobsTextLabel;
    simplegranulator_trig: TKnobsInput;
    spiral: TKnobsModule;
    spiral_display_steps: TKnobsDisplay;
    spiral_editlabel: TKnobsEditLabel;
    spiral_outlen: TKnobsOutput;
    spiral_outnorm: TKnobsOutput;
    spiral_outnote: TKnobsOutput;
    spiral_outphi: TKnobsOutput;
    spiral_pad: TKnobsPad;
    spiral_steps: TKnobsSmallKnob;
    spiral_textlabel_len: TKnobsTextLabel;
    spiral_textlabel_norm: TKnobsTextLabel;
    spiral_textlabel_out: TKnobsTextLabel;
    spiral_textlabel_phi: TKnobsTextLabel;
    spiral_textlabel_steps: TKnobsTextLabel;
    square: TKnobsModule;
    square_bandlimit: TKnobsSmallKnob;
    square_cents: TKnobsSmallKnob;
    square_display_cents: TKnobsDisplay;
    square_display_frequency: TKnobsDisplay;
    square_editlabel: TKnobsEditLabel;
    square_fm: TKnobsInput;
    square_fmlevel: TKnobsSmallKnob;
    square_freq: TKnobsInput;
    square_frequency: TKnobsSmallKnob;
    square_mute: TKnobsSelector;
    square_out: TKnobsOutput;
    square_phase: TKnobsInput;
    square_pmlevel: TKnobsSmallKnob;
    square_pwm: TKnobsInput;
    square_pwmlevel: TKnobsSmallKnob;
    square_symbol_sync: TImage;
    square_sync: TKnobsInput;
    square_textlabel_blimit: TKnobsTextLabel;
    square_textlabel_fm: TKnobsTextLabel;
    square_textlabel_freq: TKnobsTextLabel;
    square_textlabel_phase: TKnobsTextLabel;
    square_textlabel_pwm: TKnobsTextLabel;
    square_textlabel_sync: TKnobsTextLabel;
    squarelfo: TKnobsModule;
    squarelfo_display_frequency: TKnobsDisplay;
    squarelfo_editlabel: TKnobsEditLabel;
    squarelfo_fm: TKnobsInput;
    squarelfo_fmlevel: TKnobsSmallKnob;
    squarelfo_freq: TKnobsInput;
    squarelfo_frequency: TKnobsSmallKnob;
    squarelfo_indicator_out: TKnobsIndicator;
    squarelfo_indicator_res: TKnobsIndicator;
    squarelfo_mute: TKnobsSelector;
    squarelfo_out: TKnobsOutput;
    squarelfo_outputtype: TKnobsSelector;
    squarelfo_phase: TKnobsInput;
    squarelfo_pmlevel: TKnobsSmallKnob;
    squarelfo_pwm: TKnobsInput;
    squarelfo_pwmlevel: TKnobsSmallKnob;
    squarelfo_range: TKnobsSelector;
    squarelfo_res: TKnobsInput;
    squarelfo_symbol_res: TImage;
    squarelfo_sync: TKnobsOutput;
    squarelfo_textlabel_fm: TKnobsTextLabel;
    squarelfo_textlabel_phase: TKnobsTextLabel;
    squarelfo_textlabel_pwm: TKnobsTextLabel;
    squarelfo_textlabel_res: TKnobsTextLabel;
    squarelfo_textlabel_sync: TKnobsTextLabel;
    squarelfotrig_textlabel_out: TKnobsTextLabel;
    squarelfotrig: TKnobsModule;
    squarelfotrig_count: TKnobsNoKnob;
    squarelfotrig_display_count: TKnobsDisplay;
    squarelfotrig_display_frequency: TKnobsDisplay;
    squarelfotrig_editlabel: TKnobsEditLabel;
    squarelfotrig_fm: TKnobsInput;
    squarelfotrig_fmlevel: TKnobsSmallKnob;
    squarelfotrig_frequency: TKnobsSmallKnob;
    squarelfotrig_indicator_out: TKnobsIndicator;
    squarelfotrig_indicator_ready: TKnobsIndicator;
    squarelfotrig_indicator_trig: TKnobsIndicator;
    squarelfotrig_mute: TKnobsSelector;
    squarelfotrig_out: TKnobsOutput;
    squarelfotrig_outputtype: TKnobsSelector;
    squarelfotrig_pwm: TKnobsInput;
    squarelfotrig_pwmlevel: TKnobsSmallKnob;
    squarelfotrig_range: TKnobsSelector;
    squarelfotrig_ready: TKnobsOutput;
    squarelfotrig_symbol_trig: TImage;
    squarelfotrig_textlabel_count: TKnobsTextLabel;
    squarelfotrig_textlabel_fm: TKnobsTextLabel;
    squarelfotrig_textlabel_pwm: TKnobsTextLabel;
    squarelfotrig_textlabel_ready: TKnobsTextLabel;
    squarelfotrig_textlabel_trig: TKnobsTextLabel;
    squarelfotrig_trig: TKnobsInput;
    squaretrig: TKnobsModule;
    squaretrig_bandlimit: TKnobsSmallKnob;
    squaretrig_cents: TKnobsSmallKnob;
    squaretrig_count: TKnobsNoKnob;
    squaretrig_display_cents: TKnobsDisplay;
    squaretrig_display_count: TKnobsDisplay;
    squaretrig_display_frequency: TKnobsDisplay;
    squaretrig_editlabel: TKnobsEditLabel;
    squaretrig_fm: TKnobsInput;
    squaretrig_fmlevel: TKnobsSmallKnob;
    squaretrig_freq: TKnobsInput;
    squaretrig_frequency: TKnobsSmallKnob;
    squaretrig_mute: TKnobsSelector;
    squaretrig_out: TKnobsOutput;
    squaretrig_pwm: TKnobsInput;
    squaretrig_pwmlevel: TKnobsSmallKnob;
    squaretrig_symbol_trig: TImage;
    squaretrig_textlabel_blimit: TKnobsTextLabel;
    squaretrig_textlabel_count: TKnobsTextLabel;
    squaretrig_textlabel_fm: TKnobsTextLabel;
    squaretrig_textlabel_freq: TKnobsTextLabel;
    squaretrig_textlabel_pwm: TKnobsTextLabel;
    squaretrig_textlabel_trig: TKnobsTextLabel;
    squaretrig_trig: TKnobsInput;
    stereolooper: TKnobsModule;
    stereolooper_collission: TKnobsOutput;
    stereolooper_display_maxtime: TKnobsDisplay;
    stereolooper_duration: TKnobsSmallKnob;
    stereolooper_durationmod: TKnobsInput;
    stereolooper_durationmodamt: TKnobsSmallKnob;
    stereolooper_editlabel: TKnobsEditLabel;
    stereolooper_fm: TKnobsInput;
    stereolooper_fmamt: TKnobsSmallKnob;
    stereolooper_indicator_test: TKnobsIndicator;
    stereolooper_inl: TKnobsInput;
    stereolooper_inr: TKnobsInput;
    stereolooper_length: TKnobsSmallKnob;
    stereolooper_mode: TKnobsSelector;
    stereolooper_outl: TKnobsOutput;
    stereolooper_outr: TKnobsOutput;
    stereolooper_overlap: TKnobsSmallKnob;
    stereolooper_range: TKnobsSelector;
    stereolooper_rec: TKnobsInput;
    stereolooper_record: TKnobsSelector;
    stereolooper_speed: TKnobsSmallKnob;
    stereolooper_speedmod: TKnobsInput;
    stereolooper_speedmodamt: TKnobsSmallKnob;
    stereolooper_start: TKnobsSmallKnob;
    stereolooper_startmod: TKnobsInput;
    stereolooper_startmodamt: TKnobsSmallKnob;
    stereolooper_textlabel_duration: TKnobsTextLabel;
    stereolooper_textlabel_fm: TKnobsTextLabel;
    stereolooper_textlabel_in: TKnobsTextLabel;
    stereolooper_textlabel_maxlength: TKnobsTextLabel;
    stereolooper_textlabel_out: TKnobsTextLabel;
    stereolooper_textlabel_overlap: TKnobsTextLabel;
    stereolooper_textlabel_speed: TKnobsTextLabel;
    stereolooper_textlabel_start: TKnobsTextLabel;
    stereowiden: TKnobsModule;
    stereowiden_delay: TKnobsInput;
    stereowiden_delayamt: TKnobsSmallKnob;
    stereowiden_delayamtmod: TKnobsInput;
    stereowiden_display_length: TKnobsDisplay;
    stereowiden_editlabel: TKnobsEditLabel;
    stereowiden_inl: TKnobsInput;
    stereowiden_inr: TKnobsInput;
    stereowiden_length: TKnobsSmallKnob;
    stereowiden_mute: TKnobsSelector;
    stereowiden_outl: TKnobsOutput;
    stereowiden_outr: TKnobsOutput;
    stereowiden_textlabel_delay: TKnobsTextLabel;
    stereowiden_textlabel_delayamt: TKnobsTextLabel;
    stereowiden_textlabel_inversionamt: TKnobsTextLabel;
    stereowiden_textlabel_l: TKnobsTextLabel;
    stereowiden_textlabel_r: TKnobsTextLabel;
    stereowiden_widenamt: TKnobsSmallKnob;
    stereowiden_widenamtmod: TKnobsInput;
    svf: TKnobsModule;
    svf_bp: TKnobsOutput;
    svf_br: TKnobsOutput;
    svf_display_frequency: TKnobsDisplay;
    svf_distortion: TKnobsSmallKnob;
    svf_editlabel: TKnobsEditLabel;
    svf_fm: TKnobsInput;
    svf_fmlevel: TKnobsSmallKnob;
    svf_freq: TKnobsInput;
    svf_frequency: TKnobsSmallKnob;
    svf_hp: TKnobsOutput;
    svf_in: TKnobsInput;
    svf_inlevel: TKnobsSmallKnob;
    svf_lp: TKnobsOutput;
    svf_q: TKnobsSmallKnob;
    svf_qm: TKnobsSmallKnob;
    svf_qmamtn: TKnobsInput;
    svf_qmamtp: TKnobsInput;
    svf_textlabel_bp: TKnobsTextLabel;
    svf_textlabel_br: TKnobsTextLabel;
    svf_textlabel_distortion: TKnobsTextLabel;
    svf_textlabel_freq: TKnobsTextLabel;
    svf_textlabel_frequency_in: TKnobsTextLabel;
    svf_textlabel_hp: TKnobsTextLabel;
    svf_textlabel_in: TKnobsTextLabel;
    svf_textlabel_lp: TKnobsTextLabel;
    svf_textlabel_minus: TKnobsTextLabel;
    svf_textlabel_plus: TKnobsTextLabel;
    svf_textlabel_q: TKnobsTextLabel;
    svf_textlabel_qm: TKnobsTextLabel;
    switch2to1: TKnobsModule;
    switch2to1_control: TKnobsInput;
    switch2to1_editlabel: TKnobsEditLabel;
    switch2to1_in1: TKnobsInput;
    switch2to1_in2: TKnobsInput;
    switch2to1_indicator_control: TKnobsIndicator;
    switch2to1_out2: TKnobsOutput;
    switch2to1_out: TKnobsOutput;
    switch2to1_textlabel_control: TKnobsTextLabel;
    switch2to1_textlabel_in1: TKnobsTextLabel;
    switch2to1_textlabel_out: TKnobsTextLabel;
    switch_tabsheet: TTabSheet;
    switches4: TKnobsModule;
    switches4_display1: TKnobsDisplay;
    switches4_display2: TKnobsDisplay;
    switches4_display3: TKnobsDisplay;
    switches4_display4: TKnobsDisplay;
    switches4_editlabel: TKnobsEditLabel;
    switches4_out1: TKnobsOutput;
    switches4_out2: TKnobsOutput;
    switches4_out3: TKnobsOutput;
    switches4_out4: TKnobsOutput;
    switches4_sw1: TKnobsSelector;
    switches4_sw2: TKnobsSelector;
    switches4_sw3: TKnobsSelector;
    switches4_sw4: TKnobsSelector;
    sync: TKnobsModule;
    sync_editlabel: TKnobsEditLabel;
    sync_indicator_syncin: TKnobsIndicator;
    sync_indicator_syncout: TKnobsIndicator;
    sync_symbol_sync: TImage;
    sync_syncin: TKnobsInput;
    sync_syncout: TKnobsOutput;
    sync_textlabel_syncin: TKnobsTextLabel;
    sync_textlabel_syncout: TKnobsTextLabel;
    tapper: TKnobsModule;
    tapper_bpm: TKnobsSmallKnob;
    tapper_display_bpm: TKnobsDisplay;
    tapper_display_rate: TKnobsDisplay;
    tapper_editlabel: TKnobsEditLabel;
    tapper_indicator_busy: TKnobsIndicator;
    tapper_indicator_pulse: TKnobsIndicator;
    tapper_inslave: TKnobsInput;
    tapper_mode: TKnobsSelector;
    tapper_outpulse: TKnobsOutput;
    tapper_outslave: TKnobsOutput;
    tapper_outspeed: TKnobsOutput;
    tapper_rate: TKnobsSmallKnob;
    tapper_sw: TKnobsSelector;
    tapper_sync: TKnobsSelector;
    tapper_textlabel_mode: TKnobsTextLabel;
    tapper_textlabel_rate: TKnobsTextLabel;
    tapper_textlabel_slave: TKnobsTextLabel;
    tapper_textlabel_speedout: TKnobsTextLabel;
    tapper_textlabel_tap: TKnobsTextLabel;
    tapper_textlabel_taprate: TKnobsTextLabel;
    terragen: TKnobsModule;
    terragen_algo: TKnobsSelector;
    terragen_editlabel: TKnobsEditLabel;
    terragen_mute: TKnobsSelector;
    terragen_out: TKnobsOutput;
    terragen_textlabel_height: TKnobsTextLabel;
    terragen_textlabel_x: TKnobsTextLabel;
    terragen_textlabel_y: TKnobsTextLabel;
    terragen_x: TKnobsInput;
    terragen_y: TKnobsInput;
    thirdbank: TKnobsModule;
    thirdbank_display_steepness: TKnobsDisplay;
    thirdbank_editlabel: TKnobsEditLabel;
    thirdbank_fader10: TKnobsSlider;
    thirdbank_fader11: TKnobsSlider;
    thirdbank_fader12: TKnobsSlider;
    thirdbank_fader13: TKnobsSlider;
    thirdbank_fader14: TKnobsSlider;
    thirdbank_fader15: TKnobsSlider;
    thirdbank_fader16: TKnobsSlider;
    thirdbank_fader17: TKnobsSlider;
    thirdbank_fader1: TKnobsSlider;
    thirdbank_fader2: TKnobsSlider;
    thirdbank_fader3: TKnobsSlider;
    thirdbank_fader4: TKnobsSlider;
    thirdbank_fader5: TKnobsSlider;
    thirdbank_fader6: TKnobsSlider;
    thirdbank_fader7: TKnobsSlider;
    thirdbank_fader8: TKnobsSlider;
    thirdbank_fader9: TKnobsSlider;
    thirdbank_fdmod10: TKnobsInput;
    thirdbank_fdmod11: TKnobsInput;
    thirdbank_fdmod12: TKnobsInput;
    thirdbank_fdmod13: TKnobsInput;
    thirdbank_fdmod14: TKnobsInput;
    thirdbank_fdmod15: TKnobsInput;
    thirdbank_fdmod16: TKnobsInput;
    thirdbank_fdmod17: TKnobsInput;
    thirdbank_fdmod1: TKnobsInput;
    thirdbank_fdmod2: TKnobsInput;
    thirdbank_fdmod3: TKnobsInput;
    thirdbank_fdmod4: TKnobsInput;
    thirdbank_fdmod5: TKnobsInput;
    thirdbank_fdmod6: TKnobsInput;
    thirdbank_fdmod7: TKnobsInput;
    thirdbank_fdmod8: TKnobsInput;
    thirdbank_fdmod9: TKnobsInput;
    thirdbank_fi: TKnobsSelector;
    thirdbank_fm: TKnobsInput;
    thirdbank_fmamt: TKnobsSmallKnob;
    thirdbank_in: TKnobsInput;
    thirdbank_level: TKnobsSmallKnob;
    thirdbank_modehigh: TKnobsSelector;
    thirdbank_modelow: TKnobsSelector;
    thirdbank_out: TKnobsOutput;
    thirdbank_q: TKnobsSmallKnob;
    thirdbank_steepness: TKnobsNoKnob;
    thirdbank_textlabel_fm: TKnobsTextLabel;
    thirdbank_textlabel_frequencies1: TKnobsTextLabel;
    thirdbank_textlabel_frequencies2: TKnobsTextLabel;
    thirdbank_textlabel_in: TKnobsTextLabel;
    thirdbank_textlabel_lev: TKnobsTextLabel;
    thirdbank_textlabel_out: TKnobsTextLabel;
    thirdbank_textlabel_q: TKnobsTextLabel;
    thirdbank_textlabel_steepness: TKnobsTextLabel;
    thirdsplitter: TKnobsModule;
    thirdsplitter_display_steepness: TKnobsDisplay;
    thirdsplitter_editlabel: TKnobsEditLabel;
    thirdsplitter_fi: TKnobsSelector;
    thirdsplitter_fm: TKnobsInput;
    thirdsplitter_fmamt: TKnobsSmallKnob;
    thirdsplitter_in: TKnobsInput;
    thirdsplitter_indicator_clip10: TKnobsIndicator;
    thirdsplitter_indicator_clip11: TKnobsIndicator;
    thirdsplitter_indicator_clip12: TKnobsIndicator;
    thirdsplitter_indicator_clip13: TKnobsIndicator;
    thirdsplitter_indicator_clip14: TKnobsIndicator;
    thirdsplitter_indicator_clip15: TKnobsIndicator;
    thirdsplitter_indicator_clip16: TKnobsIndicator;
    thirdsplitter_indicator_clip17: TKnobsIndicator;
    thirdsplitter_indicator_clip1: TKnobsIndicator;
    thirdsplitter_indicator_clip2: TKnobsIndicator;
    thirdsplitter_indicator_clip3: TKnobsIndicator;
    thirdsplitter_indicator_clip4: TKnobsIndicator;
    thirdsplitter_indicator_clip5: TKnobsIndicator;
    thirdsplitter_indicator_clip6: TKnobsIndicator;
    thirdsplitter_indicator_clip7: TKnobsIndicator;
    thirdsplitter_indicator_clip8: TKnobsIndicator;
    thirdsplitter_indicator_clip9: TKnobsIndicator;
    thirdsplitter_level: TKnobsSmallKnob;
    thirdsplitter_modehigh: TKnobsSelector;
    thirdsplitter_modelow: TKnobsSelector;
    thirdsplitter_out10: TKnobsOutput;
    thirdsplitter_out11: TKnobsOutput;
    thirdsplitter_out12: TKnobsOutput;
    thirdsplitter_out13: TKnobsOutput;
    thirdsplitter_out14: TKnobsOutput;
    thirdsplitter_out15: TKnobsOutput;
    thirdsplitter_out16: TKnobsOutput;
    thirdsplitter_out17: TKnobsOutput;
    thirdsplitter_out1: TKnobsOutput;
    thirdsplitter_out2: TKnobsOutput;
    thirdsplitter_out3: TKnobsOutput;
    thirdsplitter_out4: TKnobsOutput;
    thirdsplitter_out5: TKnobsOutput;
    thirdsplitter_out6: TKnobsOutput;
    thirdsplitter_out7: TKnobsOutput;
    thirdsplitter_out8: TKnobsOutput;
    thirdsplitter_out9: TKnobsOutput;
    thirdsplitter_q: TKnobsSmallKnob;
    thirdsplitter_steepness: TKnobsNoKnob;
    thirdsplitter_textlabel_fm: TKnobsTextLabel;
    thirdsplitter_textlabel_frequencies1: TKnobsTextLabel;
    thirdsplitter_textlabel_frequencies2: TKnobsTextLabel;
    thirdsplitter_textlabel_in: TKnobsTextLabel;
    thirdsplitter_textlabel_lev: TKnobsTextLabel;
    thirdsplitter_textlabel_q: TKnobsTextLabel;
    thirdsplitter_textlabel_steepness: TKnobsTextLabel;
    trackandhold: TKnobsModule;
    trackandhold_editlabel: TKnobsEditLabel;
    trackandhold_in: TKnobsInput;
    trackandhold_indicator_trig: TKnobsIndicator;
    trackandhold_label_in: TKnobsTextLabel;
    trackandhold_label_trig: TKnobsTextLabel;
    trackandhold_out: TKnobsOutput;
    trackandhold_symbol_trig: TImage;
    trackandhold_trig: TKnobsInput;
    transinv: TKnobsModule;
    transinv_amtpivot: TKnobsSmallKnob;
    transinv_display_amtpivot: TKnobsDisplay;
    transinv_display_modulo: TKnobsDisplay;
    transinv_editlabel: TKnobsEditLabel;
    transinv_in1: TKnobsInput;
    transinv_in2: TKnobsInput;
    transinv_in3: TKnobsInput;
    transinv_in4: TKnobsInput;
    transinv_mode: TKnobsSelector;
    transinv_modulo: TKnobsSmallKnob;
    transinv_out1: TKnobsOutput;
    transinv_out2: TKnobsOutput;
    transinv_out3: TKnobsOutput;
    transinv_out4: TKnobsOutput;
    transinv_textlabel_amtpivot: TKnobsTextLabel;
    transinv_textlabel_modulo: TKnobsTextLabel;
    tritonebank: TKnobsModule;
    tritonebank_display_steepness: TKnobsDisplay;
    tritonebank_editlabel: TKnobsEditLabel;
    tritonebank_fader10: TKnobsSlider;
    tritonebank_fader11: TKnobsSlider;
    tritonebank_fader12: TKnobsSlider;
    tritonebank_fader13: TKnobsSlider;
    tritonebank_fader14: TKnobsSlider;
    tritonebank_fader15: TKnobsSlider;
    tritonebank_fader16: TKnobsSlider;
    tritonebank_fader17: TKnobsSlider;
    tritonebank_fader1: TKnobsSlider;
    tritonebank_fader2: TKnobsSlider;
    tritonebank_fader3: TKnobsSlider;
    tritonebank_fader4: TKnobsSlider;
    tritonebank_fader5: TKnobsSlider;
    tritonebank_fader6: TKnobsSlider;
    tritonebank_fader7: TKnobsSlider;
    tritonebank_fader8: TKnobsSlider;
    tritonebank_fader9: TKnobsSlider;
    tritonebank_fdmod10: TKnobsInput;
    tritonebank_fdmod11: TKnobsInput;
    tritonebank_fdmod12: TKnobsInput;
    tritonebank_fdmod13: TKnobsInput;
    tritonebank_fdmod14: TKnobsInput;
    tritonebank_fdmod15: TKnobsInput;
    tritonebank_fdmod16: TKnobsInput;
    tritonebank_fdmod17: TKnobsInput;
    tritonebank_fdmod1: TKnobsInput;
    tritonebank_fdmod2: TKnobsInput;
    tritonebank_fdmod3: TKnobsInput;
    tritonebank_fdmod4: TKnobsInput;
    tritonebank_fdmod5: TKnobsInput;
    tritonebank_fdmod6: TKnobsInput;
    tritonebank_fdmod7: TKnobsInput;
    tritonebank_fdmod8: TKnobsInput;
    tritonebank_fdmod9: TKnobsInput;
    tritonebank_fi: TKnobsSelector;
    tritonebank_fm: TKnobsInput;
    tritonebank_fmamt: TKnobsSmallKnob;
    tritonebank_in: TKnobsInput;
    tritonebank_level: TKnobsSmallKnob;
    tritonebank_modehigh: TKnobsSelector;
    tritonebank_modelow: TKnobsSelector;
    tritonebank_out: TKnobsOutput;
    tritonebank_q: TKnobsSmallKnob;
    tritonebank_steepness: TKnobsNoKnob;
    tritonebank_textlabel_fm: TKnobsTextLabel;
    tritonebank_textlabel_frequencies1: TKnobsTextLabel;
    tritonebank_textlabel_frequencies2: TKnobsTextLabel;
    tritonebank_textlabel_in: TKnobsTextLabel;
    tritonebank_textlabel_lev: TKnobsTextLabel;
    tritonebank_textlabel_out: TKnobsTextLabel;
    tritonebank_textlabel_q: TKnobsTextLabel;
    tritonebank_textlabel_steepness: TKnobsTextLabel;
    tritonesplitter: TKnobsModule;
    tritonesplitter_display_steepness: TKnobsDisplay;
    tritonesplitter_editlabel: TKnobsEditLabel;
    tritonesplitter_fi: TKnobsSelector;
    tritonesplitter_fm: TKnobsInput;
    tritonesplitter_fmamt: TKnobsSmallKnob;
    tritonesplitter_in: TKnobsInput;
    tritonesplitter_indicator_clip10: TKnobsIndicator;
    tritonesplitter_indicator_clip11: TKnobsIndicator;
    tritonesplitter_indicator_clip12: TKnobsIndicator;
    tritonesplitter_indicator_clip13: TKnobsIndicator;
    tritonesplitter_indicator_clip14: TKnobsIndicator;
    tritonesplitter_indicator_clip15: TKnobsIndicator;
    tritonesplitter_indicator_clip16: TKnobsIndicator;
    tritonesplitter_indicator_clip17: TKnobsIndicator;
    tritonesplitter_indicator_clip1: TKnobsIndicator;
    tritonesplitter_indicator_clip2: TKnobsIndicator;
    tritonesplitter_indicator_clip3: TKnobsIndicator;
    tritonesplitter_indicator_clip4: TKnobsIndicator;
    tritonesplitter_indicator_clip5: TKnobsIndicator;
    tritonesplitter_indicator_clip6: TKnobsIndicator;
    tritonesplitter_indicator_clip7: TKnobsIndicator;
    tritonesplitter_indicator_clip8: TKnobsIndicator;
    tritonesplitter_indicator_clip9: TKnobsIndicator;
    tritonesplitter_level: TKnobsSmallKnob;
    tritonesplitter_modehigh: TKnobsSelector;
    tritonesplitter_modelow: TKnobsSelector;
    tritonesplitter_out10: TKnobsOutput;
    tritonesplitter_out11: TKnobsOutput;
    tritonesplitter_out12: TKnobsOutput;
    tritonesplitter_out13: TKnobsOutput;
    tritonesplitter_out14: TKnobsOutput;
    tritonesplitter_out15: TKnobsOutput;
    tritonesplitter_out16: TKnobsOutput;
    tritonesplitter_out17: TKnobsOutput;
    tritonesplitter_out1: TKnobsOutput;
    tritonesplitter_out2: TKnobsOutput;
    tritonesplitter_out3: TKnobsOutput;
    tritonesplitter_out4: TKnobsOutput;
    tritonesplitter_out5: TKnobsOutput;
    tritonesplitter_out6: TKnobsOutput;
    tritonesplitter_out7: TKnobsOutput;
    tritonesplitter_out8: TKnobsOutput;
    tritonesplitter_out9: TKnobsOutput;
    tritonesplitter_q: TKnobsSmallKnob;
    tritonesplitter_steepness: TKnobsNoKnob;
    tritonesplitter_textlabel_fm: TKnobsTextLabel;
    tritonesplitter_textlabel_frequencies1: TKnobsTextLabel;
    tritonesplitter_textlabel_frequencies2: TKnobsTextLabel;
    tritonesplitter_textlabel_in: TKnobsTextLabel;
    tritonesplitter_textlabel_lev: TKnobsTextLabel;
    tritonesplitter_textlabel_q: TKnobsTextLabel;
    tritonesplitter_textlabel_steepness: TKnobsTextLabel;
    typeflip: TKnobsModule;
    typeflip_editlabel: TKnobsEditLabel;
    typeflip_in: TKnobsInput;
    typeflip_indicator_select: TKnobsIndicator;
    typeflip_inmode: TKnobsSelector;
    typeflip_outl: TKnobsOutput;
    typeflip_outmodel: TKnobsSelector;
    typeflip_outmoder: TKnobsSelector;
    typeflip_outr: TKnobsOutput;
    typeflip_select: TKnobsInput;
    typeflip_slew: TKnobsSmallKnob;
    typeflip_textlabel_intypes: TKnobsTextLabel;
    typeflip_textlabel_outsel: TKnobsTextLabel;
    typeflip_textlabel_outtypes: TKnobsTextLabel;
    typeflip_textlabel_slew: TKnobsTextLabel;
    util_tabsheet: TTabSheet;
    v0coder_carrier: TKnobsInput;
    value: TKnobsModule;
    value_display_value: TKnobsDisplay;
    value_editlabel: TKnobsEditLabel;
    value_in: TKnobsInput;
    value_mode: TKnobsSelector;
    vocoder: TKnobsModule;
    vocoder_editlabel: TKnobsEditLabel;
    vocoder_modulator: TKnobsInput;
    vocoder_mute: TKnobsSelector;
    vocoder_out: TKnobsOutput;
    vocoder_textlabel_carrier: TKnobsTextLabel;
    vocoder_textlabel_modulator: TKnobsTextLabel;
    volume: TKnobsModule;
    volume_editlabel: TKnobsEditLabel;
    volume_inl: TKnobsInput;
    volume_inr: TKnobsInput;
    volume_level1: TKnobsSmallKnob;
    volume_level2: TKnobsSmallKnob;
    volume_levelmod: TKnobsInput;
    volume_mute: TKnobsSelector;
    volume_outl: TKnobsOutput;
    volume_outr: TKnobsOutput;
    volume_textlabel_level: TKnobsTextLabel;
    volume_textlabel_mod: TKnobsTextLabel;
    waveplayer: TKnobsModule;
    waveplayer_display_duration: TKnobsDisplay;
    waveplayer_display_mono: TKnobsDisplay;
    waveplayer_editlabel: TKnobsEditLabel;
    waveplayer_fileselector_filename: TKnobsFileSelector;
    waveplayer_fm: TKnobsInput;
    waveplayer_indicator_res: TKnobsIndicator;
    waveplayer_mode: TKnobsSelector;
    waveplayer_out: TKnobsOutput;
    waveplayer_outr: TKnobsOutput;
    waveplayer_position: TKnobsInput;
    waveplayer_res: TKnobsInput;
    waveplayer_speed: TKnobsInput;
    waveplayer_symbol_res: TImage;
    waveplayer_textlabel_duration: TKnobsTextLabel;
    waveplayer_textlabel_fm: TKnobsTextLabel;
    waveplayer_textlabel_l: TKnobsTextLabel;
    waveplayer_textlabel_position: TKnobsTextLabel;
    waveplayer_textlabel_r: TKnobsTextLabel;
    waveplayer_textlabel_res: TKnobsTextLabel;
    waveplayer_textlabel_speed: TKnobsTextLabel;
    xfade: TKnobsModule;
    xfade_control: TKnobsInput;
    xfade_editlabel: TKnobsEditLabel;
    xfade_fadertype: TKnobsSelector;
    xfade_in1: TKnobsInput;
    xfade_in2: TKnobsInput;
    xfade_intype: TKnobsSelector;
    xfade_out: TKnobsOutput;
    xfade_position: TKnobsSmallKnob;
    xfade_posmod: TKnobsSmallKnob;
    xfade_textlabel_control: TKnobsTextLabel;
    xfade_textlabel_in1: TKnobsTextLabel;
    xfade_textlabel_in2: TKnobsTextLabel;
    xfade_textlabel_out: TKnobsTextLabel;
    xyscope: TKnobsModule;
    xyscope_display_history: TKnobsDisplay;
    xyscope_editlabel: TKnobsEditLabel;
    xyscope_history: TKnobsSmallKnob;
    xyscope_inx: TKnobsInput;
    xyscope_iny: TKnobsInput;
    xyscope_levx: TKnobsSmallKnob;
    xyscope_levy: TKnobsSmallKnob;
    xyscope_lockxy: TKnobsSelector;
    xyscope_textlabel_history: TKnobsTextLabel;
    xyscope_textlabel_lockxy: TKnobsTextLabel;
    xyscope_textlabel_x: TKnobsTextLabel;
    xyscope_textlabel_y: TKnobsTextLabel;
    xyscope_viewer: TKnobsDataViewer;
    zerocounter: TKnobsModule;
    zerocounter_display_threshold: TKnobsDisplay;
    zerocounter_editlabel: TKnobsEditLabel;
    zerocounter_gate: TKnobsOutput;
    zerocounter_in: TKnobsInput;
    zerocounter_indicator_gate: TKnobsIndicator;
    zerocounter_note: TKnobsOutput;
    zerocounter_period: TKnobsOutput;
    zerocounter_textlabel_gate: TKnobsTextLabel;
    zerocounter_textlabel_in: TKnobsTextLabel;
    zerocounter_textlabel_note: TKnobsTextLabel;
    zerocounter_textlabel_period: TKnobsTextLabel;
    zerocounter_textlabel_threshold: TKnobsTextLabel;
    zerocounter_threshold: TKnobsSmallKnob;
    livemorph: TKnobsModule;
    livemorph_in: TKnobsInput;
    livemorph_editlabel: TKnobsEditLabel;
    livemorph_inputtype: TKnobsSelector;
    tod: TKnobsModule;
    tod_editlabel: TKnobsEditLabel;
    tod_out: TKnobsOutput;
    tod_textlabel_d: TKnobsTextLabel;
    tod_textlabel_h: TKnobsTextLabel;
    tod_outh: TKnobsOutput;
    tod_outm: TKnobsOutput;
    tod_textlabel_m: TKnobsTextLabel;
    tod_textlabel_s: TKnobsTextLabel;
    tod_outs: TKnobsOutput;
    livemorph_active: TKnobsSelector;
    auto: TKnobsModule;
    auto_clock: TKnobsInput;
    auto_editlabel: TKnobsEditLabel;
    auto_active: TKnobsSelector;
    auto_type: TKnobsSelector;
    auto_indicator_trig: TKnobsIndicator;
    perlinnoise: TKnobsModule;
    perlinnoise_editlabel: TKnobsEditLabel;
    perlinnoise_out: TKnobsOutput;
    perlinnoise_textlabel_length: TKnobsTextLabel;
    perlinnoise_roughmod: TKnobsInput;
    perlinnoise_textlabel_roughness: TKnobsTextLabel;
    perlinnoise_length: TKnobsSmallKnob;
    perlinnoise_display_length: TKnobsDisplay;
    perlinnoise_mute: TKnobsSelector;
    perlinnoise_roughness: TKnobsSmallKnob;
    perlinnoise_textlabel_layers: TKnobsTextLabel;
    perlinnoise_layers: TKnobsSmallKnob;
    perlinnoise_display_layers: TKnobsDisplay;
    perlinnoisetrig: TKnobsModule;
    perlinnoisetrig_editlabel: TKnobsEditLabel;
    perlinnoisetrig_out: TKnobsOutput;
    perlinnoisetrig_textlabel_length: TKnobsTextLabel;
    perlinnoisetrig_roughmod: TKnobsInput;
    perlinnoisetrig_textlabel_roughness: TKnobsTextLabel;
    perlinnoisetrig_textlabel_layers: TKnobsTextLabel;
    perlinnoisetrig_length: TKnobsSmallKnob;
    perlinnoisetrig_display_length: TKnobsDisplay;
    perlinnoisetrig_mute: TKnobsSelector;
    perlinnoisetrig_roughness: TKnobsSmallKnob;
    perlinnoisetrig_layers: TKnobsSmallKnob;
    perlinnoisetrig_display_layers: TKnobsDisplay;
    perlinnoisetrig_symbol_trig: TImage;
    perlinnoisetrig_trig: TKnobsInput;
    perlinnoisetrig_new: TKnobsInput;
    perlinnoise_new: TKnobsInput;
    perlinnoise_textlabel_new: TKnobsTextLabel;
    perlinnoisetrig_textlabel_new: TKnobsTextLabel;
    perlinnoise_lengthmodamt: TKnobsSmallKnob;
    perlinnoise_lengthmod: TKnobsInput;
    perlinnoisetrig_lengthmod: TKnobsInput;
    perlinnoisetrig_lengthmodamt: TKnobsSmallKnob;
    perlintone: TKnobsModule;
    perlintone_editlabel: TKnobsEditLabel;
    perlintone_out: TKnobsOutput;
    perlintone_textlabel_fm: TKnobsTextLabel;
    perlintone_roughmod: TKnobsInput;
    perlintone_textlabel_roughness: TKnobsTextLabel;
    perlintone_textlabel_layers: TKnobsTextLabel;
    perlintone_new: TKnobsInput;
    perlintone_textlabel_new: TKnobsTextLabel;
    perlintone_fm: TKnobsInput;
    perlintone_frequency: TKnobsSmallKnob;
    perlintone_display_frequency: TKnobsDisplay;
    perlintone_mute: TKnobsSelector;
    perlintone_roughness: TKnobsSmallKnob;
    perlintone_layers: TKnobsSmallKnob;
    perlintone_display_layers: TKnobsDisplay;
    perlintone_fmlevel: TKnobsSmallKnob;
    perlintone_freq: TKnobsInput;
    perlintone_textlabel_length: TKnobsTextLabel;
    perlintone_lengthmod: TKnobsInput;
    perlintone_length: TKnobsSmallKnob;
    perlintone_display_length: TKnobsDisplay;
    perlintone_lengthmodamt: TKnobsSmallKnob;
    perlintone_cents: TKnobsSmallKnob;
    perlintone_display_cents: TKnobsDisplay;
    randomscale: TKnobsModule;
    randomscale_editlabel: TKnobsEditLabel;
    randomscale_out: TKnobsOutput;
    randomscale_textlabel_out: TKnobsTextLabel;
    randomscale_in: TKnobsInput;
    randomscale_textlabel_in: TKnobsTextLabel;
    randomscale_perm: TKnobsSelector;
    randomscale_symbol_rnd: TImage;
    randomscale_permute: TKnobsInput;
    randomscale_textlabel_rnd: TKnobsTextLabel;
    randomscale_indicator_trig: TKnobsIndicator;
    perlinnoise_newinv: TKnobsSelector;
    perlinnoisetrig_newinv: TKnobsSelector;
    perlintone_newinv: TKnobsSelector;
    probsequencer: TKnobsModule;
    probsequencer_editlabel: TKnobsEditLabel;
    probsequencer_out: TKnobsOutput;
    probsequencer_chain: TKnobsInput;
    probsequencer_textlabel_chain: TKnobsTextLabel;
    probsequencer_note0: TKnobsSelector;
    probsequencer_note1: TKnobsSelector;
    probsequencer_note2: TKnobsSelector;
    probsequencer_note3: TKnobsSelector;
    probsequencer_note4: TKnobsSelector;
    probsequencer_note5: TKnobsSelector;
    probsequencer_note6: TKnobsSelector;
    probsequencer_note7: TKnobsSelector;
    probsequencer_note8: TKnobsSelector;
    probsequencer_note9: TKnobsSelector;
    probsequencer_note10: TKnobsSelector;
    probsequencer_note11: TKnobsSelector;
    probsequencer_scale: TKnobsSelector;
    probsequencer_prob0: TKnobsSlider;
    probsequencer_prob1: TKnobsSlider;
    probsequencer_prob2: TKnobsSlider;
    probsequencer_prob3: TKnobsSlider;
    probsequencer_prob4: TKnobsSlider;
    probsequencer_prob5: TKnobsSlider;
    probsequencer_prob6: TKnobsSlider;
    probsequencer_prob7: TKnobsSlider;
    probsequencer_prob8: TKnobsSlider;
    probsequencer_prob9: TKnobsSlider;
    probsequencer_prob10: TKnobsSlider;
    probsequencer_prob11: TKnobsSlider;
    probsequencer_textlabel_relprob: TKnobsTextLabel;
    probsequencer_textlabel_basenote: TKnobsTextLabel;
    probsequencer_textlabel_tilt: TKnobsTextLabel;
    probsequencer_lownote: TKnobsSmallKnob;
    probsequencer_display_lownote: TKnobsDisplay;
    probsequencer_display_highnote: TKnobsDisplay;
    probsequencer_highnote: TKnobsSmallKnob;
    probsequencer_basenote: TKnobsSmallKnob;
    probsequencer_display_basenote: TKnobsDisplay;
    probsequencer_tilt: TKnobsSmallKnob;
    probsequencer_display_tilt: TKnobsDisplay;
    probsequencer_symbol_clock: TImage;
    probsequencer_trig: TKnobsInput;
    probsequencer_indicator_trig: TKnobsIndicator;
    probsequencer_textlabel_step: TKnobsTextLabel;
    probsequencer_ctrl1: TKnobsInput;
    probsequencer_ctrl3: TKnobsInput;
    probsequencer_ctrl6: TKnobsInput;
    probsequencer_ctrl8: TKnobsInput;
    probsequencer_ctrl10: TKnobsInput;
    probsequencer_ctrl0: TKnobsInput;
    probsequencer_ctrl2: TKnobsInput;
    probsequencer_ctrl4: TKnobsInput;
    probsequencer_ctrl5: TKnobsInput;
    probsequencer_ctrl7: TKnobsInput;
    probsequencer_ctrl9: TKnobsInput;
    probsequencer_ctrl11: TKnobsInput;
    probsequencer_indicator_curr0: TKnobsIndicator;
    probsequencer_indicator_curr1: TKnobsIndicator;
    probsequencer_indicator_curr2: TKnobsIndicator;
    probsequencer_indicator_curr3: TKnobsIndicator;
    probsequencer_indicator_curr4: TKnobsIndicator;
    probsequencer_indicator_curr5: TKnobsIndicator;
    probsequencer_indicator_curr6: TKnobsIndicator;
    probsequencer_indicator_curr7: TKnobsIndicator;
    probsequencer_indicator_curr8: TKnobsIndicator;
    probsequencer_indicator_curr9: TKnobsIndicator;
    probsequencer_indicator_curr10: TKnobsIndicator;
    probsequencer_indicator_curr11: TKnobsIndicator;
    probsequencer_rnd: TKnobsSelector;
    probsequencer_clr: TKnobsSelector;
    noise_textlabel_colormod1: TKnobsTextLabel;
    noise_type: TKnobsSelector;
    noise_textlabel_type: TKnobsTextLabel;
    noisetrig_textlabel_colormod1: TKnobsTextLabel;
    noisetrig_type: TKnobsSelector;
    noiselfo_type: TKnobsSelector;
    noiselfotrig_type: TKnobsSelector;
    probsequencer_tiltmodamt: TKnobsSmallKnob;
    probsequencer_tiltmod: TKnobsInput;
    probsequencer_smooth: TKnobsSmallKnob;
    probsequencer_display_smooth: TKnobsDisplay;
    probsequencer_smoothmod: TKnobsInput;
    probsequencer_smoothmodamt: TKnobsSmallKnob;
    probsequencer_textlabel_smooth: TKnobsTextLabel;
    probsequencer_textlabel_lohi: TKnobsTextLabel;
    pattern_mode1: TKnobsSelector;
    pattern_mode2: TKnobsSelector;
    pattern_mode3: TKnobsSelector;
    pattern_mode4: TKnobsSelector;
    pattern_mode5: TKnobsSelector;
    pattern_mode6: TKnobsSelector;
    pattern_mode7: TKnobsSelector;
    pattern_mode8: TKnobsSelector;
    pattern_out1: TKnobsOutput;
    pattern_out2: TKnobsOutput;
    pattern_out3: TKnobsOutput;
    pattern_out4: TKnobsOutput;
    pattern_out5: TKnobsOutput;
    pattern_out6: TKnobsOutput;
    pattern_out7: TKnobsOutput;
    pattern_out8: TKnobsOutput;
    pattern_indicator_step1: TKnobsIndicator;
    pattern_indicator_step2: TKnobsIndicator;
    pattern_indicator_step3: TKnobsIndicator;
    pattern_indicator_step4: TKnobsIndicator;
    pattern_indicator_step5: TKnobsIndicator;
    pattern_indicator_step6: TKnobsIndicator;
    pattern_indicator_step7: TKnobsIndicator;
    pattern_indicator_step8: TKnobsIndicator;
    pattern_textlabel_stepsout: TKnobsTextLabel;
    filter6db: TKnobsModule;
    filter6db_hp: TKnobsOutput;
    filter6db_in: TKnobsInput;
    filter6db_editlabel: TKnobsEditLabel;
    filter6db_textlabel_in: TKnobsTextLabel;
    filter6db_textlabel_hp: TKnobsTextLabel;
    filter6db_freqmod: TKnobsInput;
    filter6db_freq: TKnobsSmallKnob;
    filter6db_freqmodamt: TKnobsSmallKnob;
    filter6db_display_frequency: TKnobsDisplay;
    generator_tabsheet: TTabSheet;
    rewriter: TKnobsModule;
    rewriter_editlabel: TKnobsEditLabel;
    rewriter_symbol_step: TImage;
    rewriter_step: TKnobsInput;
    rewriter_indicator_step: TKnobsIndicator;
    rewriter_textlabel_step: TKnobsTextLabel;
    rewriter_a: TKnobsOutput;
    rewriter_textlabel_ar: TKnobsTextLabel;
    rewriter_indicator_a: TKnobsIndicator;
    rewriter_b: TKnobsOutput;
    rewriter_textlabel_br: TKnobsTextLabel;
    rewriter_indicator_b: TKnobsIndicator;
    rewriter_c: TKnobsOutput;
    rewriter_textlabel_cr: TKnobsTextLabel;
    rewriter_indicator_c: TKnobsIndicator;
    rewriter_d: TKnobsOutput;
    rewriter_textlabel_dr: TKnobsTextLabel;
    rewriter_indicator_d: TKnobsIndicator;
    rewriter_e: TKnobsOutput;
    rewriter_textlabel_er: TKnobsTextLabel;
    rewriter_indicator_e: TKnobsIndicator;
    rewriter_textlabel_al: TKnobsTextLabel;
    rewriter_textlabel_bl: TKnobsTextLabel;
    rewriter_textlabel_cl: TKnobsTextLabel;
    rewriter_textlabel_dl: TKnobsTextLabel;
    rewriter_textlabel_el: TKnobsTextLabel;
    rewriter_textlabel_steps: TKnobsTextLabel;
    rewriter_stepsmod: TKnobsInput;
    rewriter_display_a: TKnobsDisplay;
    rewriter_display_b: TKnobsDisplay;
    rewriter_display_c: TKnobsDisplay;
    rewriter_display_d: TKnobsDisplay;
    rewriter_display_e: TKnobsDisplay;
    rewriter_display_steps: TKnobsDisplay;
    rewriter_steps: TKnobsNoKnob;
    rewriter_mode: TKnobsSelector;
    rewriternote: TKnobsModule;
    rewriternote_editlabel: TKnobsEditLabel;
    rewriternote_symbol_step: TImage;
    rewriternote_step: TKnobsInput;
    rewriternote_indicator_step: TKnobsIndicator;
    rewriternote_textlabel_step: TKnobsTextLabel;
    rewriternote_out: TKnobsOutput;
    rewriternote_indicator_a: TKnobsIndicator;
    rewriternote_indicator_b: TKnobsIndicator;
    rewriternote_indicator_c: TKnobsIndicator;
    rewriternote_indicator_d: TKnobsIndicator;
    rewriternote_indicator_e: TKnobsIndicator;
    rewriternote_textlabel_al: TKnobsTextLabel;
    rewriternote_textlabel_bl: TKnobsTextLabel;
    rewriternote_textlabel_cl: TKnobsTextLabel;
    rewriternote_textlabel_dl: TKnobsTextLabel;
    rewriternote_textlabel_el: TKnobsTextLabel;
    rewriternote_textlabel_steps: TKnobsTextLabel;
    rewriternote_stepsmod: TKnobsInput;
    rewriternote_indicator_f: TKnobsIndicator;
    rewriternote_indicator_g: TKnobsIndicator;
    rewriternote_indicator_h: TKnobsIndicator;
    rewriternote_textlabel_fl: TKnobsTextLabel;
    rewriternote_textlabel_gl: TKnobsTextLabel;
    rewriternote_textlabel_hl: TKnobsTextLabel;
    rewriternote_textlabel_chain: TKnobsTextLabel;
    rewriternote_chain: TKnobsInput;
    rewriternote_textlabel_out: TKnobsTextLabel;
    rewriternote_chaina: TKnobsInput;
    rewriternote_chainb: TKnobsInput;
    rewriternote_chainc: TKnobsInput;
    rewriternote_chaind: TKnobsInput;
    rewriternote_chaine: TKnobsInput;
    rewriternote_chainf: TKnobsInput;
    rewriternote_chaing: TKnobsInput;
    rewriternote_chainh: TKnobsInput;
    rewriternote_display_a: TKnobsDisplay;
    rewriternote_display_b: TKnobsDisplay;
    rewriternote_display_c: TKnobsDisplay;
    rewriternote_display_d: TKnobsDisplay;
    rewriternote_display_e: TKnobsDisplay;
    rewriternote_display_steps: TKnobsDisplay;
    rewriternote_steps: TKnobsNoKnob;
    rewriternote_display_f: TKnobsDisplay;
    rewriternote_display_g: TKnobsDisplay;
    rewriternote_display_h: TKnobsDisplay;
    rewriternote_notea: TKnobsSmallKnob;
    rewriternote_display_notea: TKnobsDisplay;
    rewriternote_noteb: TKnobsSmallKnob;
    rewriternote_display_noteb: TKnobsDisplay;
    rewriternote_notec: TKnobsSmallKnob;
    rewriternote_display_notec: TKnobsDisplay;
    rewriternote_noted: TKnobsSmallKnob;
    rewriternote_display_noted: TKnobsDisplay;
    rewriternote_notee: TKnobsSmallKnob;
    rewriternote_display_notee: TKnobsDisplay;
    rewriternote_notef: TKnobsSmallKnob;
    rewriternote_display_notef: TKnobsDisplay;
    rewriternote_noteg: TKnobsSmallKnob;
    rewriternote_display_noteg: TKnobsDisplay;
    rewriternote_noteh: TKnobsSmallKnob;
    rewriternote_display_noteh: TKnobsDisplay;
    rewriternote_mode: TKnobsSelector;
    tunesmithy: TKnobsModule;
    tunesmithy_editlabel: TKnobsEditLabel;
    tunesmithy_symbol_step: TImage;
    tunesmithy_step: TKnobsInput;
    tunesmithy_indicator_step: TKnobsIndicator;
    tunesmithy_textlabel_step: TKnobsTextLabel;
    tunesmithy_textlabel_steps: TKnobsTextLabel;
    tunesmithy_out: TKnobsOutput;
    tunesmithy_textlabel_out: TKnobsTextLabel;
    tunesmithy_textlabel_seed: TKnobsTextLabel;
    tunesmithy_textlabel_chain: TKnobsTextLabel;
    tunesmithy_chain: TKnobsInput;
    tunesmithy_display_steps: TKnobsDisplay;
    tunesmithy_steps: TKnobsNoKnob;
    tunesmithy_display_seed: TKnobsDisplay;
    logisticmap: TKnobsModule;
    logisticmap_out: TKnobsOutput;
    logisticmap_start: TKnobsInput;
    logisticmap_rmod: TKnobsInput;
    logisticmap_editlabel: TKnobsEditLabel;
    logisticmap_textlabel_lowr: TKnobsTextLabel;
    logisticmap_textlabel_highr: TKnobsTextLabel;
    logisticmap_symbol_start: TImage;
    logisticmap_textlabel_start: TKnobsTextLabel;
    logisticmap_textlabel_rmod: TKnobsTextLabel;
    logisticmap_textlabel_svalue: TKnobsTextLabel;
    logisticmap_clock: TKnobsInput;
    logisticmap_symbol_clock: TImage;
    logisticmap_textlabel_clock: TKnobsTextLabel;
    logisticmap_smod: TKnobsInput;
    logisticmap_textlabel_smod: TKnobsTextLabel;
    logisticmap_textlabel_xfade: TKnobsTextLabel;
    logisticmap_highr: TKnobsSmallKnob;
    logisticmap_lowr: TKnobsSmallKnob;
    logisticmap_display_lowr: TKnobsDisplay;
    logisticmap_display_highr: TKnobsDisplay;
    logisticmap_rmodamt: TKnobsSmallKnob;
    logisticmap_svalue: TKnobsSmallKnob;
    logisticmap_smodamt: TKnobsSmallKnob;
    logisticmap_outtype: TKnobsSelector;
    logisticmap_mute: TKnobsSelector;
    logisticmap_xfade: TKnobsSmallKnob;
    poetry: TKnobsModule;
    poetry_editlabel: TKnobsEditLabel;
    poety_symbol_newoutput: TImage;
    poetry_in: TKnobsInput;
    poetry_newoutput: TKnobsInput;
    poetry_indicator_newoutput: TKnobsIndicator;
    poetry_textlabel_in: TKnobsTextLabel;
    poetry_textlabel_newoutput: TKnobsTextLabel;
    poetry_textlabel_history: TKnobsTextLabel;
    poetry_out: TKnobsOutput;
    poetry_textlabel_seedlen: TKnobsTextLabel;
    poetry_symbol_newinput: TImage;
    poetry_newinput: TKnobsInput;
    poetry_indicator_newinput: TKnobsIndicator;
    poetry_textlabel_newinput: TKnobsTextLabel;
    poetry_symbol_clr: TImage;
    poetry_clr: TKnobsInput;
    poetry_indicator_clr: TKnobsIndicator;
    poetry_textlabel_clr: TKnobsTextLabel;
    poetry_history: TKnobsSmallKnob;
    poetry_display_history: TKnobsDisplay;
    poetry_seedlen: TKnobsSmallKnob;
    poetry_display_seedlen: TKnobsDisplay;
    arpeggiator: TKnobsModule;
    arpeggiatoreditlabel: TKnobsEditLabel;
    arpeggiator_symbol_newout: TImage;
    arpeggiator_in: TKnobsInput;
    arpeggiator_newoutput: TKnobsInput;
    arpeggiator_indicator_newoutput: TKnobsIndicator;
    arpeggiator_textlabel_in: TKnobsTextLabel;
    arpeggiator_textlabel_newoutput: TKnobsTextLabel;
    arpeggiator_out: TKnobsOutput;
    arpeggiator_textlabel_length: TKnobsTextLabel;
    arpeggiator_symbol_newin: TImage;
    arpeggiator_newinput: TKnobsInput;
    arpeggiator_indicator_newinput: TKnobsIndicator;
    arpeggiator_textlabel_newin: TKnobsTextLabel;
    arpeggiator_toggle: TKnobsInput;
    arpeggiator_textlabel_toggle: TKnobsTextLabel;
    arpeggiator_indicator_toggle: TKnobsIndicator;
    arpeggiator_symbol_res: TImage;
    arpeggiator_reset: TKnobsInput;
    arpeggiator_indicator_reset: TKnobsIndicator;
    arpeggiator_textlabel_reset: TKnobsTextLabel;
    arpeggiator_symbol_clr: TImage;
    arpeggiator_clr: TKnobsInput;
    arpeggiator_indicator_clr: TKnobsIndicator;
    arpeggiator_textlabel_clr: TKnobsTextLabel;
    arpeggiator_length: TKnobsSmallKnob;
    arpeggiator_display_length: TKnobsDisplay;
    arpeggiator_sorting: TKnobsSelector;
    arpeggiator_inmode: TKnobsSelector;
    markov: TKnobsModule;
    markov_editlabel: TKnobsEditLabel;
    markov_symbol_newoutput: TImage;
    markov_in: TKnobsInput;
    markov_newoutput: TKnobsInput;
    markov_indicator_newoutput: TKnobsIndicator;
    markov_textlabel_in: TKnobsTextLabel;
    markov_textlabel_newout: TKnobsTextLabel;
    markov_textlabel_maxsize: TKnobsTextLabel;
    markov_out: TKnobsOutput;
    markov_symbol_learn: TImage;
    markov_learn: TKnobsInput;
    markov_indicator_learn: TKnobsIndicator;
    markov_textlabel_learn: TKnobsTextLabel;
    markov_indicator_full: TKnobsIndicator;
    markov_textlabel_full: TKnobsTextLabel;
    markov_textlabel_mode: TKnobsTextLabel;
    markov_strengthmod: TKnobsInput;
    markov_textlabel_strength: TKnobsTextLabel;
    markov_textlabel_out: TKnobsTextLabel;
    markov_symbol_clear: TImage;
    markov_clear: TKnobsInput;
    markov_indicator_clear: TKnobsIndicator;
    markov_textlabel_clear: TKnobsTextLabel;
    markov_full: TKnobsOutput;
    markov_textlabel_order: TKnobsTextLabel;
    markov_maxsize: TKnobsSmallKnob;
    markov_display_maxsize: TKnobsDisplay;
    markov_mode: TKnobsSelector;
    markov_strengthmodamt: TKnobsSmallKnob;
    markov_strength: TKnobsSmallKnob;
    markov_order: TKnobsNoKnob;
    markov_display_order: TKnobsDisplay;
    cellaut: TKnobsModule;
    cellaut_editlabel: TKnobsEditLabel;
    cellaut_symbol_step: TImage;
    cellaut_step: TKnobsInput;
    cellaut_indicator_step: TKnobsIndicator;
    cellaut_textlabel_step: TKnobsTextLabel;
    cellaut_out: TKnobsOutput;
    cellaut_indicator_out: TKnobsIndicator;
    cellaut_textlabel_rulenr: TKnobsTextLabel;
    cellaut_textlabel_steps: TKnobsTextLabel;
    cellaut_display_steps: TKnobsDisplay;
    cellaut_steps: TKnobsNoKnob;
    cellaut_display_rule: TKnobsDisplay;
    cellaut_rule: TKnobsNoKnob;
    cellaut_symbol_back: TImage;
    cellaut_indicator_cstep: TKnobsIndicatorText;
    cellaut_label_slash: TLabel;
    cellaut_indicator_steps: TKnobsIndicatorText;
    cellaut_symbol_reset: TImage;
    cellaut_reset: TKnobsInput;
    cellaut_indicator_reset: TKnobsIndicator;
    cellaut_textlabel_reset: TKnobsTextLabel;
    cellaut_textlabel_out: TKnobsTextLabel;
    cellaut_textlabel_faults: TKnobsTextLabel;
    cellaut_display_faults: TKnobsDisplay;
    cellaut_faults: TKnobsNoKnob;
    cellaut_outsum: TKnobsOutput;
    cellaut_dir: TKnobsInput;
    cellaut_indicator_dir: TKnobsIndicator;
    cellaut_textlabel_dir: TKnobsTextLabel;
    filter6dbbp: TKnobsModule;
    filter6dbbp_display_out: TKnobsOutput;
    filter6dbbp_in: TKnobsInput;
    filter6dbbp_editlabel: TKnobsEditLabel;
    filter6dbbp_textlabel_in: TKnobsTextLabel;
    filter6dbbp_textlabel_out: TKnobsTextLabel;
    filter6dbbp_freqlp: TKnobsSmallKnob;
    filter6dbbp_display_freqlp: TKnobsDisplay;
    filter6dbbp_freqhp: TKnobsSmallKnob;
    filter6dbbp_display_freqhp: TKnobsDisplay;
    filter6dbbp_textlabel_lp: TKnobsTextLabel;
    filter6dbbp_textlabel_hp: TKnobsTextLabel;
    filter6dbpbs: TKnobsModule;
    filter6dbpbs_outr: TKnobsOutput;
    filter6dbpbs_inr: TKnobsInput;
    filter6dbpbs_editlabel: TKnobsEditLabel;
    filter6dbpbs_textlbel_in: TKnobsTextLabel;
    filter6dbpbs_textlbel_out: TKnobsTextLabel;
    filter6dbpbs_textlbel_lp: TKnobsTextLabel;
    filter6dbpbs_textlbel_hp: TKnobsTextLabel;
    filter6dbpbs_freqlp: TKnobsSmallKnob;
    filter6dbpbs_display_freqlp: TKnobsDisplay;
    filter6dbpbs_freqhp: TKnobsSmallKnob;
    filter6dbpbs_display_freqhp: TKnobsDisplay;
    filter6dbpbs_inl: TKnobsInput;
    filter6dbpbs_outl: TKnobsOutput;
    lifeseq: TKnobsModule;
    lifeseq_editlabel: TKnobsEditLabel;
    lifeseq_step: TKnobsInput;
    lifeseq_indicator_step: TKnobsIndicator;
    lifeseq_out1: TKnobsOutput;
    lifeseq_out3: TKnobsOutput;
    lifeseq_out5: TKnobsOutput;
    lifeseq_out7: TKnobsOutput;
    lifeseq_out9: TKnobsOutput;
    lifeseq_grid: TKnobsGridControl;
    lifeseq_out11: TKnobsOutput;
    lifeseq_out13: TKnobsOutput;
    lifeseq_out15: TKnobsOutput;
    lifeseq_out17: TKnobsOutput;
    lifeseq_out19: TKnobsOutput;
    lifeseq_out21: TKnobsOutput;
    lifeseq_out23: TKnobsOutput;
    lifeseq_out25: TKnobsOutput;
    lifeseq_out27: TKnobsOutput;
    lifeseq_out29: TKnobsOutput;
    lifeseq_out31: TKnobsOutput;
    lifeseq_out2: TKnobsOutput;
    lifeseq_out4: TKnobsOutput;
    lifeseq_out6: TKnobsOutput;
    lifeseq_out8: TKnobsOutput;
    lifeseq_out10: TKnobsOutput;
    lifeseq_out12: TKnobsOutput;
    lifeseq_out14: TKnobsOutput;
    lifeseq_out16: TKnobsOutput;
    lifeseq_out18: TKnobsOutput;
    lifeseq_out20: TKnobsOutput;
    lifeseq_out22: TKnobsOutput;
    lifeseq_out24: TKnobsOutput;
    lifeseq_out26: TKnobsOutput;
    lifeseq_out28: TKnobsOutput;
    lifeseq_out30: TKnobsOutput;
    lifeseq_out32: TKnobsOutput;
    lifeseq_mode: TKnobsSelector;
    lifeseq_textlabel_mode: TKnobsTextLabel;
    lifeseq_textlabel_faultrate: TKnobsTextLabel;
    lifeseq_faultrate: TKnobsSmallKnob;
    lifeseq_display_faultrate: TKnobsDisplay;
    lifeseq_textlabel_lowcount: TKnobsTextLabel;
    lifeseq_lowcount: TKnobsSmallKnob;
    lifeseq_display_lowcount: TKnobsDisplay;
    lifeseq_textlabel_rnd_amt: TKnobsTextLabel;
    lifeseq_randomamount: TKnobsSmallKnob;
    lifeseq_display_randomamount: TKnobsDisplay;
    lifeseq_sum: TKnobsOutput;
    lifeseq_textlabel_step: TKnobsTextLabel;
    lifeseq_textlabel_sum: TKnobsTextLabel;
    lifeseq_rnd: TKnobsSelector;
    lifeseq_change: TKnobsInput;
    lifeseq_textlabel_change: TKnobsTextLabel;
    lifeseq_wrapmode: TKnobsSelector;
    lifeseq_summode: TKnobsSelector;
    lifeseq_clr: TKnobsSelector;
    lifeseq_res: TKnobsInput;
    lifeseq_indicator_res: TKnobsIndicator;
    lifeseq_textlabel_res: TKnobsTextLabel;
    lifeseq_indicator_change: TKnobsIndicator;
    lifeseq_changemute: TKnobsSelector;
    lifeseq_textlabel_chain: TKnobsTextLabel;
    lifeseq_chain: TKnobsInput;
    lifeseq_rev: TKnobsInput;
    lifeseq_indicator_rev: TKnobsIndicator;
    lifeseq_textlabel_rev: TKnobsTextLabel;
    lifeseq_stops: TKnobsGridControl;
    lifeseq_textlabel_stops: TKnobsTextLabel;
    adder_in7: TKnobsInput;
    adder_in6: TKnobsInput;
    adder_in5: TKnobsInput;
    multiplier_in7: TKnobsInput;
    multiplier_in6: TKnobsInput;
    multiplier_in5: TKnobsInput;
    levelconverter_out5: TKnobsOutput;
    levelconverter_out6: TKnobsOutput;
    levelconverter_out7: TKnobsOutput;
    levelconverter_in5: TKnobsInput;
    levelconverter_in6: TKnobsInput;
    levelconverter_in7: TKnobsInput;
    separator_osc4: TKnobsModule;
    phasor: TKnobsModule;
    phasor_editlabel: TKnobsEditLabel;
    phasor_symbol_sync: TImage;
    phasor_out: TKnobsOutput;
    phasor_fm: TKnobsInput;
    phasor_phase: TKnobsInput;
    phasor_sync: TKnobsInput;
    phasor_textlabel_fm: TKnobsTextLabel;
    phasor_textlabel_pm: TKnobsTextLabel;
    phasor_textlabel_sync: TKnobsTextLabel;
    phasor_textlabel_freq: TKnobsTextLabel;
    phasor_freq: TKnobsInput;
    phasor_frequency: TKnobsSmallKnob;
    phasor_display_frequency: TKnobsDisplay;
    phasor_fmlevel: TKnobsSmallKnob;
    phasor_pmlevel: TKnobsSmallKnob;
    phasor_cents: TKnobsSmallKnob;
    phasor_display_cents: TKnobsDisplay;
    phasor_symbol_shape: TImage;
    audiograph: TKnobsModule;
    audiograph_editlabel: TKnobsEditLabel;
    audiograph_data: TKnobsDataMaker;
    audiograph_out: TKnobsOutput;
    audiograph_in: TKnobsInput;
    audiograph_textlabel_in: TKnobsTextLabel;
    audiograph_textlabel_out: TKnobsTextLabel;
    tiltfilter: TKnobsModule;
    tiltfilter_out: TKnobsOutput;
    tiltfilter_in: TKnobsInput;
    tiltfilter_fmmod: TKnobsInput;
    tiltfilter_editlabel: TKnobsEditLabel;
    tiltfilter_textlabel_in: TKnobsTextLabel;
    tiltfilter_textlabel_fm: TKnobsTextLabel;
    tiltfilter_textlabel_tilt: TKnobsTextLabel;
    tiltfilter_textlabel_out: TKnobsTextLabel;
    tiltfilter_display_freq: TKnobsDisplay;
    tiltfilter_freq: TKnobsSmallKnob;
    tiltfilter_tilt: TKnobsSmallKnob;
    tiltfilter_fmmodamt: TKnobsSmallKnob;
    tiltfilter_inlevel: TKnobsSmallKnob;
    tiltfilter_tiltmod: TKnobsInput;
    tiltfilter_tiltmodamt: TKnobsSmallKnob;
    audiograph_rnd: TKnobsInput;
    audiograph_textlabel_rnd: TKnobsTextLabel;
    audiograph_autoscale: TKnobsSelector;
    audiograph_textlabel_autoscale: TKnobsTextLabel;
    demux_hold: TKnobsSelector;
    randomwalklfo_sync: TKnobsOutput;
    randomwalklfo_textlabel_sync: TKnobsTextLabel;
    randomwalklfo_smode: TKnobsSelector;
    randomwalklfo_distancemod: TKnobsInput;
    value_reset: TKnobsSelector;
    value_display_maxvalue: TKnobsDisplay;
    modcontrol: TKnobsModule;
    modcontrol_out: TKnobsOutput;
    modcontrol_in: TKnobsInput;
    modcontrol_editlabel: TKnobsEditLabel;
    modcontrol_textlabel_in: TKnobsTextLabel;
    modcontrol_mod: TKnobsInput;
    modcontrol_textlabel_mod: TKnobsTextLabel;
    modcontrol_outtype: TKnobsSelector;
    modcontrol_intype: TKnobsSelector;
    modcontrol_modtype: TKnobsSelector;
    envar_inv: TKnobsOutput;
    envar_textlabel_inv: TKnobsTextLabel;
    envarretrig_inv: TKnobsOutput;
    envarretrig_textlabel_inv: TKnobsTextLabel;
    moogfilter: TKnobsModule;
    moogfilter_out: TKnobsOutput;
    moogfilter_in: TKnobsInput;
    moogfilter_fm: TKnobsInput;
    moogfilter_editlabel: TKnobsEditLabel;
    moogfilter_textlabel_in: TKnobsTextLabel;
    moogfilter_textlabel_fm: TKnobsTextLabel;
    moogfilter_textlabel_q: TKnobsTextLabel;
    moogfilter_textlabel_out: TKnobsTextLabel;
    moogfilter_freq: TKnobsInput;
    moogfilter_textlabel_freq: TKnobsTextLabel;
    moogfilter_textlabel_qm: TKnobsTextLabel;
    moogfilter_qmamtp: TKnobsInput;
    moogfilter_qmamtn: TKnobsInput;
    moogfilter_textlabel_plus: TKnobsTextLabel;
    moogfilter_textlabel_minus: TKnobsTextLabel;
    moogfilter_display_frequency: TKnobsDisplay;
    moogfilter_frequency: TKnobsSmallKnob;
    moogfilter_q: TKnobsSmallKnob;
    moogfilter_fmlevel: TKnobsSmallKnob;
    moogfilter_inlevel: TKnobsSmallKnob;
    moogfilter_qm: TKnobsSmallKnob;
    fixeddiv: TKnobsModule;
    fixeddiv_editlabel: TKnobsEditLabel;
    fixeddiv_symbol_trig: TImage;
    fixeddiv_out2: TKnobsOutput;
    fixeddiv_trig: TKnobsInput;
    fixeddiv_indicator_out2: TKnobsIndicator;
    fixeddiv_textlabel_trig: TKnobsTextLabel;
    fixeddiv_symbol_res: TImage;
    fixeddiv_res: TKnobsInput;
    fixeddiv_textlabel_res: TKnobsTextLabel;
    fixeddiv_out3: TKnobsOutput;
    fixeddiv_indicator_out3: TKnobsIndicator;
    fixeddiv_out4: TKnobsOutput;
    fixeddiv_indicator_out4: TKnobsIndicator;
    fixeddiv_out5: TKnobsOutput;
    fixeddiv_indicator_out5: TKnobsIndicator;
    fixeddiv_out6: TKnobsOutput;
    fixeddiv_indicator_out6: TKnobsIndicator;
    fixeddiv_out7: TKnobsOutput;
    fixeddiv_indicator_out7: TKnobsIndicator;
    fixeddiv_out8: TKnobsOutput;
    fixeddiv_indicator_out8: TKnobsIndicator;
    fixeddiv_out9: TKnobsOutput;
    fixeddiv_indicator_out9: TKnobsIndicator;
    fixeddiv_out10: TKnobsOutput;
    fixeddiv_indicator_out10: TKnobsIndicator;
    fixeddiv_out11: TKnobsOutput;
    fixeddiv_indicator_out11: TKnobsIndicator;
    fixeddiv_out12: TKnobsOutput;
    fixeddiv_indicator_out12: TKnobsIndicator;
    fixeddiv_out13: TKnobsOutput;
    fixeddiv_indicator_out13: TKnobsIndicator;
    fixeddiv_out14: TKnobsOutput;
    fixeddiv_indicator_out14: TKnobsIndicator;
    fixeddiv_out16: TKnobsOutput;
    fixeddiv_indicator_out16: TKnobsIndicator;
    fixeddiv_out32: TKnobsOutput;
    fixeddiv_indicator_out32: TKnobsIndicator;
    fixeddiv_out64: TKnobsOutput;
    fixeddiv_indicator_out64: TKnobsIndicator;
    fixeddiv_textlabel_2: TKnobsTextLabel;
    fixeddiv_textlabel_3: TKnobsTextLabel;
    fixeddiv_textlabel_4: TKnobsTextLabel;
    fixeddiv_textlabel_5: TKnobsTextLabel;
    fixeddiv_textlabel_6: TKnobsTextLabel;
    fixeddiv_textlabel_7: TKnobsTextLabel;
    fixeddiv_textlabel_8: TKnobsTextLabel;
    fixeddiv_textlabel_9: TKnobsTextLabel;
    fixeddiv_textlabel_10: TKnobsTextLabel;
    fixeddiv_textlabel_11: TKnobsTextLabel;
    fixeddiv_textlabel_12: TKnobsTextLabel;
    fixeddiv_textlabel_13: TKnobsTextLabel;
    fixeddiv_textlabel_14: TKnobsTextLabel;
    fixeddiv_textlabel_16: TKnobsTextLabel;
    fixeddiv_textlabel_32: TKnobsTextLabel;
    fixeddiv_textlabel_64: TKnobsTextLabel;
    fixeddiv_indicator_trig: TKnobsIndicator;
    fixeddiv_indicator_res: TKnobsIndicator;
    multiosc: TKnobsModule;
    multiosc_editlabel: TKnobsEditLabel;
    multiosc_symbol_trig: TImage;
    multiosc_outsine: TKnobsOutput;
    multiosc_fm: TKnobsInput;
    multiosc_phase: TKnobsInput;
    multiosc_pwm: TKnobsInput;
    multiosc_sync: TKnobsInput;
    multiosc_textlabel_fm: TKnobsTextLabel;
    multiosc_textlabel_pm: TKnobsTextLabel;
    multiosc_textlabel_pwm: TKnobsTextLabel;
    multiosc_textlabel_sync: TKnobsTextLabel;
    multiosc_textlabel_blimit: TKnobsTextLabel;
    multiosc_textlabel_freq: TKnobsTextLabel;
    multiosc_freq: TKnobsInput;
    multiosc_frequency: TKnobsSmallKnob;
    multiosc_display_frequenc: TKnobsDisplay;
    multiosc_cents: TKnobsSmallKnob;
    multiosc_display_cents: TKnobsDisplay;
    multiosc_pmlevel: TKnobsSmallKnob;
    multiosc_fmlevel: TKnobsSmallKnob;
    multiosc_pwmlevel: TKnobsSmallKnob;
    multiosc_bandlimit: TKnobsSmallKnob;
    multiosc_outtri: TKnobsOutput;
    multiosc_outsaw: TKnobsOutput;
    multiosc_outsquare: TKnobsOutput;
    multiosc_symbol_shapes: TImage;
    multiosc_mute: TKnobsSelector;
    euclids_active: TKnobsInput;
    euclids_indicator_active: TKnobsIndicator;
    euclids_textlabel_active: TKnobsTextLabel;
    seqrandom_active: TKnobsInput;
    seqrandom_textlabel_active: TKnobsTextLabel;
    seqrandom_indicator_active: TKnobsIndicator;
    seqrandval_active: TKnobsInput;
    seqrandval_indicator_active: TKnobsIndicator;
    seqrandval_textlabel_active: TKnobsTextLabel;
    pattern_active: TKnobsInput;
    pattern_indicator_active: TKnobsIndicator;
    pattern_textlabel_active: TKnobsTextLabel;
    probsequencer_active: TKnobsInput;
    probsequencer_indicator_active: TKnobsIndicator;
    probsequencer_textlabel_active: TKnobsTextLabel;
    envahd_inv: TKnobsOutput;
    envahd_textlabel_inv: TKnobsTextLabel;
    envadsr_inv: TKnobsOutput;
    envadsr_textlabel_inv: TKnobsTextLabel;
    envcontrol: TKnobsModule;
    envcontrol_out: TKnobsOutput;
    envcontrol_trig: TKnobsInput;
    envcontrol_editlabel: TKnobsEditLabel;
    envcontrol_indicator_trig: TKnobsIndicator;
    envcontrol_textlabel_a: TKnobsTextLabel;
    envcontrol_textlabel_r: TKnobsTextLabel;
    envcontrol_textlabel_out: TKnobsTextLabel;
    envcontrol_attack: TKnobsSmallKnob;
    envcontrol_release: TKnobsSmallKnob;
    envcontrol_display_attack: TKnobsDisplay;
    envcontrol_display_release: TKnobsDisplay;
    envcontrol_symbol_trig: TImage;
    envcontrol_level: TKnobsSmallKnob;
    envcontrol_display_level: TKnobsDisplay;
    envcontrol_textlabel_hpos: TKnobsTextLabel;
    envcontrol_mute: TKnobsSelector;
    envcontrol_eoc: TKnobsOutput;
    envcontrol_textlabel_eoc: TKnobsTextLabel;
    envcontrol_indicator_eoc: TKnobsIndicator;
    ImageListDotsGreen: TImageList;
    euclids_outoff: TKnobsOutput;
    euclids_indicator_outoff: TKnobsIndicator;
    euclids_textlabel_outoff: TKnobsTextLabel;
    seq16_xfademod: TKnobsInput;
    seq16_inv: TKnobsInput;
    seq16_textlabel_inv: TKnobsTextLabel;
    switches4_in1: TKnobsInput;
    switches4_in2: TKnobsInput;
    switches4_in3: TKnobsInput;
    switches4_in4: TKnobsInput;
    modquantizer_levmod: TKnobsInput;
    scalequantizer_levmod: TKnobsInput;
    notequantizer_levmod: TKnobsInput;
    seq16_indicator_inv: TKnobsIndicator;
    seq16_rnd2: TKnobsInput;
    compressor_textlabel_side: TKnobsTextLabel;
    dcblock: TKnobsModule;
    dcblock_out: TKnobsOutput;
    dcblock_in: TKnobsInput;
    dcblock_editlabel: TKnobsEditLabel;
    dcblock_alpha: TKnobsSmallKnob;
    midiccout_sent: TKnobsOutput;
    midiccout_textlabel_sent: TKnobsTextLabel;
    midipcout: TKnobsModule;
    midipcout_editlabel: TKnobsEditLabel;
    midipcout_indicator_gate: TKnobsIndicator;
    midipcout_textlable_gate: TKnobsTextLabel;
    midipcout_textlable_program: TKnobsTextLabel;
    midipcout_textlable_prg: TKnobsTextLabel;
    midipcout_prg: TKnobsInput;
    midipcout_gate: TKnobsInput;
    midipcout_sent: TKnobsOutput;
    midipcout_textlable_sent: TKnobsTextLabel;
    midipcout_ch: TKnobsNoKnob;
    midipcout_display_ch: TKnobsDisplay;
    midipcout_display_prg: TKnobsDisplay;
    midipcout_program: TKnobsNoKnob;
    transinv_chain4: TKnobsInput;
    transinv_chain3: TKnobsInput;
    transinv_chain2: TKnobsInput;
    transinv_chain1: TKnobsInput;
    transinv_textlabel_input: TKnobsTextLabel;
    transinv_textlabel_chain: TKnobsTextLabel;
    midipnout: TKnobsModule;
    midipnout_editlabel: TKnobsEditLabel;
    midipnout_indicator_gate: TKnobsIndicator;
    midipnout_textlabel_gate: TKnobsTextLabel;
    midipnout_textlabel_value: TKnobsTextLabel;
    midipnout_textlabel_paraml: TKnobsTextLabel;
    midipnout_value: TKnobsInput;
    midipnout_gate: TKnobsInput;
    midipnout_sent: TKnobsOutput;
    midipnout_textlabel_sent: TKnobsTextLabel;
    midipnout_ch: TKnobsNoKnob;
    midipnout_display_ch: TKnobsDisplay;
    midipnout_display_pl: TKnobsDisplay;
    midipnout_pl: TKnobsNoKnob;
    midipnout_textlabel_paramh: TKnobsTextLabel;
    midipnout_display_ph: TKnobsDisplay;
    midipnout_ph: TKnobsNoKnob;
    midipnout_textlabel_ch: TKnobsTextLabel;
    midipnout_reg: TKnobsSelector;
    midipnout_usel: TKnobsSelector;
    osc_speed: TKnobsInput;
    osc_textlabel_speed: TKnobsTextLabel;
    square_speed: TKnobsInput;
    square_textlabel_speed: TKnobsTextLabel;
    multiosc_speed: TKnobsInput;
    multiosc_textlabel_speed: TKnobsTextLabel;
    osctrig_textlabel_speed: TKnobsTextLabel;
    osctrig_speed: TKnobsInput;
    squaretrig_textlabel_speed: TKnobsTextLabel;
    squaretrig_speed: TKnobsInput;
    lfo_speed: TKnobsInput;
    lfo_textlabel_speed: TKnobsTextLabel;
    squarelfotrig_speed: TKnobsInput;
    squarelfotrig_textlabel_speed: TKnobsTextLabel;
    lfotrig_speed: TKnobsInput;
    lfotrig_textlabel_speed: TKnobsTextLabel;
    squarelfo_speed: TKnobsInput;
    squarelfo_textlabel_speed: TKnobsTextLabel;
    pulsesync: TKnobsModule;
    pulsesync_editlabel: TKnobsEditLabel;
    pulsesync_q: TKnobsOutput;
    pulsesync_sync: TKnobsInput;
    pulsesync_pulse: TKnobsInput;
    pulsesync_indicator_q: TKnobsIndicator;
    pulsesync_indicator_state: TKnobsIndicator;
    pulsesync_symbol_pulse: TImage;
    pulsesync_outputtype: TKnobsSelector;
    pulsesync_symbol_sync: TImage;
    pulsesync_textlabel_pulse: TKnobsTextLabel;
    pulsesync_textlabel_sync: TKnobsTextLabel;
    seq16_textlabel_1: TKnobsTextLabel;
    seq16_out2: TKnobsOutput;
    seq16_textlabel_2: TKnobsTextLabel;
    seq16_out3: TKnobsOutput;
    seq16_textlabel_3: TKnobsTextLabel;
    seq16_out4: TKnobsOutput;
    seq16_textlabel_4: TKnobsTextLabel;
    lut_textlabel_1: TKnobsTextLabel;
    lut_out2: TKnobsOutput;
    lut_textlabel_2: TKnobsTextLabel;
    lut_out4: TKnobsOutput;
    lut_textlabel_3: TKnobsTextLabel;
    lut_out3: TKnobsOutput;
    lut_textlabel_4: TKnobsTextLabel;
    lut_textlabel_steps1: TKnobsTextLabel;
    lut_steps: TKnobsSmallKnob;
    lut_rnd3: TKnobsInput;
    primediv: TKnobsModule;
    primediv_editlabel: TKnobsEditLabel;
    primediv_symbol_trig: TImage;
    primediv_out2: TKnobsOutput;
    primediv_trig: TKnobsInput;
    primediv_indicator_out2: TKnobsIndicator;
    primediv_textlabel_trig: TKnobsTextLabel;
    primediv_symbol_res: TImage;
    primediv_out_res: TKnobsInput;
    primediv_textlabel_res: TKnobsTextLabel;
    primediv_out3: TKnobsOutput;
    primediv_indicator_out3: TKnobsIndicator;
    primediv_out5: TKnobsOutput;
    primediv_indicator_out5: TKnobsIndicator;
    primediv_out7: TKnobsOutput;
    primediv_indicator_out7: TKnobsIndicator;
    primediv_out11: TKnobsOutput;
    primediv_indicator_out11: TKnobsIndicator;
    primediv_out13: TKnobsOutput;
    primediv_indicator_out13: TKnobsIndicator;
    primediv_out17: TKnobsOutput;
    primediv_indicator_out17: TKnobsIndicator;
    primediv_out19: TKnobsOutput;
    primediv_indicator_out19: TKnobsIndicator;
    primediv_out23: TKnobsOutput;
    primediv_indicator_out23: TKnobsIndicator;
    primediv_out29: TKnobsOutput;
    primediv_indicator_out29: TKnobsIndicator;
    primediv_out31: TKnobsOutput;
    primediv_indicator_out31: TKnobsIndicator;
    primediv_out37: TKnobsOutput;
    primediv_indicator_out37: TKnobsIndicator;
    primediv_out41: TKnobsOutput;
    primediv_indicator_out41: TKnobsIndicator;
    primediv_out43: TKnobsOutput;
    primediv_indicator_out43: TKnobsIndicator;
    primediv_out47: TKnobsOutput;
    primediv_indicator_out47: TKnobsIndicator;
    primediv_out53: TKnobsOutput;
    primediv_indicator_out53: TKnobsIndicator;
    primediv_textlabel_2: TKnobsTextLabel;
    primediv_textlabel_3: TKnobsTextLabel;
    primediv_textlabel_5: TKnobsTextLabel;
    primediv_textlabel_7: TKnobsTextLabel;
    primediv_textlabel_11: TKnobsTextLabel;
    primediv_textlabel_13: TKnobsTextLabel;
    primediv_textlabel_17: TKnobsTextLabel;
    primediv_textlabel_19: TKnobsTextLabel;
    primediv_textlabel_23: TKnobsTextLabel;
    primediv_textlabel_29: TKnobsTextLabel;
    primediv_textlabel_31: TKnobsTextLabel;
    primediv_textlabel_37: TKnobsTextLabel;
    primediv_textlabel_41: TKnobsTextLabel;
    primediv_textlabel_43: TKnobsTextLabel;
    primediv_textlabel_47: TKnobsTextLabel;
    primediv_textlabel_53: TKnobsTextLabel;
    primediv_indicator_trig: TKnobsIndicator;
    primediv_indicator_res: TKnobsIndicator;
    lut_stepsmod: TKnobsInput;
    lut_xfademod: TKnobsInput;
    envar_hold: TKnobsSelector;
    envarretrig_hold: TKnobsSelector;
    envcontrol_hold: TKnobsSelector;
    arpeggiator_reverse: TKnobsInput;
    arpeggiator_textlabel_rev: TKnobsTextLabel;
    arpeggiator_indicator_reverse: TKnobsIndicator;
    seq16_hold: TKnobsInput;
    seq16_textlabel_hold: TKnobsTextLabel;
    fixeddiv_square: TKnobsSelector;
    primediv_square: TKnobsSelector;
    seq16_indicator_hold: TKnobsIndicator;
    seq16_skip1: TKnobsInput;
    seq16_skip2: TKnobsInput;
    seq16_skip3: TKnobsInput;
    seq16_skip4: TKnobsInput;
    seq16_skip5: TKnobsInput;
    seq16_skip6: TKnobsInput;
    seq16_skip7: TKnobsInput;
    seq16_skip8: TKnobsInput;
    seq16_skip9: TKnobsInput;
    seq16_skip10: TKnobsInput;
    seq16_skip11: TKnobsInput;
    seq16_skip12: TKnobsInput;
    seq16_skip13: TKnobsInput;
    seq16_skip14: TKnobsInput;
    seq16_skip15: TKnobsInput;
    seq16_skip16: TKnobsInput;
    seq16_textlabel_skips: TKnobsTextLabel;
    seq16_textlabel_rnd: TKnobsTextLabel;
    seq16_clockskip: TKnobsInput;
    seq16_textlabel_clockskip: TKnobsTextLabel;
    seq16_indicator_clockskip: TKnobsIndicator;
    arpeggiator_textlabel_trans: TKnobsTextLabel;
    arpeggiator_trans: TKnobsInput;
    arpeggiator_indicator_trans: TKnobsIndicator;
    poetry_textlabel_trans: TKnobsTextLabel;
    poetry_trans: TKnobsInput;
    poetry_indicator_trans: TKnobsIndicator;
    transpose: TKnobsModule;
    transpose_out: TKnobsOutput;
    transpose_in: TKnobsInput;
    transpose_editlabel: TKnobsEditLabel;
    transpose_textlabel_amount1: TKnobsTextLabel;
    transpose_amount1: TKnobsSmallKnob;
    transpose_display_amount1: TKnobsDisplay;
    transpose_active1: TKnobsInput;
    transpose_textlabel_amount2: TKnobsTextLabel;
    transpose_amount2: TKnobsSmallKnob;
    transpose_display_amount2: TKnobsDisplay;
    transpose_active2: TKnobsInput;
    transpose_textlabel_amount3: TKnobsTextLabel;
    transpose_amount3: TKnobsSmallKnob;
    transpose_display_amount3: TKnobsDisplay;
    transpose_active3: TKnobsInput;
    transpose_indicator_active1: TKnobsIndicator;
    transpose_indicator_active2: TKnobsIndicator;
    transpose_indicator_active3: TKnobsIndicator;
    transpose_textlabel_amount4: TKnobsTextLabel;
    transpose_active4: TKnobsInput;
    transpose_indicator_active4: TKnobsIndicator;
    transpose_amount4: TKnobsSmallKnob;
    transpose_display_amount4: TKnobsDisplay;
    seq16_stepout1: TKnobsOutput;
    seq16_stepout2: TKnobsOutput;
    seq16_stepout3: TKnobsOutput;
    seq16_stepout4: TKnobsOutput;
    seq16_stepout5: TKnobsOutput;
    seq16_stepout6: TKnobsOutput;
    seq16_stepout7: TKnobsOutput;
    seq16_stepout8: TKnobsOutput;
    seq16_stepout9: TKnobsOutput;
    seq16_stepout10: TKnobsOutput;
    seq16_stepout11: TKnobsOutput;
    seq16_stepout12: TKnobsOutput;
    seq16_stepout13: TKnobsOutput;
    seq16_stepout14: TKnobsOutput;
    seq16_stepout15: TKnobsOutput;
    seq16_stepout16: TKnobsOutput;
    seq16_textlabel_steps2: TKnobsTextLabel;
    lut_stepout1: TKnobsOutput;
    lut_stepout2: TKnobsOutput;
    lut_stepout3: TKnobsOutput;
    lut_stepout4: TKnobsOutput;
    lut_stepout5: TKnobsOutput;
    lut_stepout6: TKnobsOutput;
    lut_stepout7: TKnobsOutput;
    lut_stepout8: TKnobsOutput;
    lut_stepout9: TKnobsOutput;
    lut_stepout10: TKnobsOutput;
    lut_stepout11: TKnobsOutput;
    lut_stepout12: TKnobsOutput;
    lut_stepout13: TKnobsOutput;
    lut_stepout14: TKnobsOutput;
    lut_stepout15: TKnobsOutput;
    lut_stepout16: TKnobsOutput;
    lut_textlabel_steps2: TKnobsTextLabel;
    lfotrig_countmod: TKnobsInput;
    squarelfotrig_countmod: TKnobsInput;
    squaresinelfo: TKnobsModule;
    squaresinelfo_editlabel: TKnobsEditLabel;
    squaresinelfo_symbol_res: TImage;
    squaresinelfo_out: TKnobsOutput;
    squaresinelfo_fm: TKnobsInput;
    squaresinelfo_phase: TKnobsInput;
    squaresinelfo_pwm: TKnobsInput;
    squaresinelfo_res: TKnobsInput;
    squaresinelfo_indicator_out: TKnobsIndicator;
    squaresinelfo_indicator_res: TKnobsIndicator;
    squaresinelfo_textlabel_fm: TKnobsTextLabel;
    squaresinelfo_textlabel_pm: TKnobsTextLabel;
    squaresinelfo_textlabel_pwm: TKnobsTextLabel;
    squaresinelfo_textlabel_res: TKnobsTextLabel;
    squaresinelfo_sync: TKnobsOutput;
    squaresinelfo_textlabel_syn: TKnobsTextLabel;
    squaresinelfo_freq: TKnobsInput;
    squaresinelfo_speed: TKnobsInput;
    squaresinelfo_textlabel_spd: TKnobsTextLabel;
    squaresinelfo_frequency: TKnobsSmallKnob;
    squaresinelfo_display_frequency: TKnobsDisplay;
    squaresinelfo_mute: TKnobsSelector;
    squaresinelfo_fmlevel: TKnobsSmallKnob;
    squaresinelfo_pmlevel: TKnobsSmallKnob;
    squaresinelfo_range: TKnobsSelector;
    squaresinelfo_pwmlevel: TKnobsSmallKnob;
    squaresinelfo_outputtype: TKnobsSelector;
    squaresinelfo_textlabel_sq: TKnobsTextLabel;
    squaresinelfo_sine: TKnobsOutput;
    squaresinelfo_textlabel_sin: TKnobsTextLabel;
    seq16_gatemode: TKnobsSelector;
    pulseskip: TKnobsModule;
    pulseskip_editlabel: TKnobsEditLabel;
    pulseskip_symbol_trig: TImage;
    pulseskip_out: TKnobsOutput;
    pulseskip_trig: TKnobsInput;
    pulseskip_indicator_out: TKnobsIndicator;
    pulseskip_textlabel_trig: TKnobsTextLabel;
    pulseskip_symbol_reset: TImage;
    pulseskip_reset: TKnobsInput;
    pulseskip_textlabel_reset: TKnobsTextLabel;
    pulseskip_textlabel_cplevel: TKnobsTextLabel;
    pulseskip_cp: TKnobsSmallKnob;
    pulseskip_display_cp: TKnobsDisplay;
    pulseskip_outputtype: TKnobsSelector;
    pulseskip_cpmodamt: TKnobsSmallKnob;
    pulseskip_cpmod: TKnobsInput;
    pulseskip_indicator_trig: TKnobsIndicator;
    pulseskip_indicator_reset: TKnobsIndicator;
    pulseskip_textlabel_inlevel: TKnobsTextLabel;
    pulseskip_in: TKnobsSmallKnob;
    pulseskip_display_in: TKnobsDisplay;
    pulseskip_inmodamt: TKnobsSmallKnob;
    pulseskip_inmod: TKnobsInput;
    quantizer_levelmod: TKnobsInput;
    seq16_timewarp: TKnobsOutput;
    seq16_textlabel_tw: TKnobsTextLabel;
    envahd_holdmode: TKnobsSelector;
    lfotrig_indicator_active: TKnobsIndicator;
    lfotrig_textlabel_active: TKnobsTextLabel;
    lfotrig_active: TKnobsOutput;
    squarelfotrig_indicator_active: TKnobsIndicator;
    squarelfotrig_textlabel_active: TKnobsTextLabel;
    squarelfotrig_active: TKnobsOutput;
    envahd_textlabel_swell: TKnobsTextLabel;
    envahd_swellmod: TKnobsInput;
    envahd_swellmodneg: TKnobsInput;
    envahd_swell: TKnobsSmallKnob;
    envahd_swellmodlevel: TKnobsSmallKnob;
    envahd_display_swell: TKnobsDisplay;
    envahd_swellshape: TKnobsSelector;
    envadsr_textlabel_swell: TKnobsTextLabel;
    envadsr_swellmod: TKnobsInput;
    envadsr_swellmodneg: TKnobsInput;
    envadsr_swell: TKnobsSmallKnob;
    envadsr_swellmodlevel: TKnobsSmallKnob;
    envadsr_swellshape: TKnobsSelector;
    envadsr_textkabel_plus2: TKnobsTextLabel;
    envadsr_textkabel_minus2: TKnobsTextLabel;
    hrastosc_shapemod: TKnobsInput;
    hrastosc_morphmod: TKnobsInput;
    hrastosc_morphmodamt: TKnobsSmallKnob;
    hrastosc_shapemodamt: TKnobsSmallKnob;
    hrastosc_textlabel_freq: TKnobsTextLabel;
    hrastosc_freq: TKnobsInput;
    quantizer_mode: TKnobsSelector;
    quantizer_rtype: TKnobsSelector;
    quantizer_textlabel_rounding: TKnobsTextLabel;
    quantizer_textlabel_range: TKnobsTextLabel;
    propscaler: TKnobsModule;
    propscaler_editlabel: TKnobsEditLabel;
    propscaler_out1: TKnobsOutput;
    propscaler_in1: TKnobsInput;
    propscaler_in2: TKnobsInput;
    propscaler_out2: TKnobsOutput;
    propscaler_in3: TKnobsInput;
    propscaler_out3: TKnobsOutput;
    propscaler_in4: TKnobsInput;
    propscaler_out4: TKnobsOutput;
    propscaler_p: TKnobsSmallKnob;
    propscaler_display_p: TKnobsDisplay;
    propscaler_pmodamt: TKnobsSmallKnob;
    propscaler_pmod: TKnobsInput;
    clockgen_textlabel_speed: TKnobsTextLabel;
    clockgen_speed: TKnobsInput;
    seqrandval_mode: TKnobsSelector;
    gate_func: TKnobsInput;
    gate_indicator_func: TKnobsTextLabel;
    modosc: TKnobsModule;
    modosc_editlabel: TKnobsEditLabel;
    modosc_symbol_sync: TImage;
    modosc_out: TKnobsOutput;
    modosc_fmmod: TKnobsInput;
    modosc_pmmod: TKnobsInput;
    modosc_sync: TKnobsInput;
    modosc_textlabel_fm: TKnobsTextLabel;
    modosc_textlabel_phase: TKnobsTextLabel;
    modosc_textlabel_sync: TKnobsTextLabel;
    modosc_textlabel_freq: TKnobsTextLabel;
    modosc_freq: TKnobsInput;
    modosc_lfmmod: TKnobsInput;
    modosc_textlabel_lfm: TKnobsTextLabel;
    modosc_frequency: TKnobsSmallKnob;
    modosc_display_frequency: TKnobsDisplay;
    modosc_mute: TKnobsSelector;
    modosc_fmmodlev: TKnobsSmallKnob;
    modosc_pmmodlev: TKnobsSmallKnob;
    modosc_cents: TKnobsSmallKnob;
    modosc_display_cents: TKnobsDisplay;
    modosc_lfmmodlev: TKnobsSmallKnob;
    modosc_lfm: TKnobsSmallKnob;
    modosc_display_lfm: TKnobsDisplay;
    modosc_centsmod: TKnobsInput;
    modosc_textlabel_ct: TKnobsTextLabel;
    modosc_centsmodlev: TKnobsSmallKnob;
    modosc_phase: TKnobsSmallKnob;
    modosc_display_phase: TKnobsDisplay;
    modosc_textlabel_pm: TKnobsTextLabel;
    modosc_ammod: TKnobsInput;
    modosc_textlabel_amplitude: TKnobsTextLabel;
    modosc_ammodlev: TKnobsSmallKnob;
    modosc_amplitude: TKnobsSmallKnob;
    modosc_display_amplitude: TKnobsDisplay;
    modosc_textlabel_am: TKnobsTextLabel;
    modosc_symbol_sine: TImage;
    modosc_textlabel_speed: TKnobsTextLabel;
    modosc_speed: TKnobsInput;
    osctrig_countmod: TKnobsInput;
    squaretrig_countmod: TKnobsInput;
    multisine: TKnobsModule;
    multisine_editlabel: TKnobsEditLabel;
    multisine_out: TKnobsOutput;
    multisine_chain: TKnobsInput;
    multisine_textlabel_chain: TKnobsTextLabel;
    multisine_textlabel_out: TKnobsTextLabel;
    multisine_fmmod: TKnobsInput;
    multisine_textlabel_fm: TKnobsTextLabel;
    multisine_frequency: TKnobsSmallKnob;
    multisine_display_frequency: TKnobsDisplay;
    multisine_fmmodlev: TKnobsSmallKnob;
    multisine_cents: TKnobsSmallKnob;
    multisine_textlabel_freq: TKnobsTextLabel;
    multisine_freq: TKnobsInput;
    multisine_fmult1: TKnobsSmallKnob;
    multisine_displaymult1: TKnobsDisplay;
    multisine_cents1: TKnobsSmallKnob;
    multisine_displaycents1: TKnobsDisplay;
    multisine_mute1: TKnobsSelector;
    multisine_textlabel_level1: TKnobsTextLabel;
    multisine_textlabel_am1: TKnobsTextLabel;
    multisine_ammodlev1: TKnobsSmallKnob;
    multisine_amplitude1: TKnobsSmallKnob;
    multisine_displayamplitude1: TKnobsDisplay;
    multisine_ammod1: TKnobsInput;
    multisine_fmult2: TKnobsSmallKnob;
    multisine_displaymult2: TKnobsDisplay;
    multisine_cents2: TKnobsSmallKnob;
    multisine_displaycents2: TKnobsDisplay;
    multisine_mute2: TKnobsSelector;
    multisine_textlabel_level2: TKnobsTextLabel;
    multisine_textlabel_am2: TKnobsTextLabel;
    multisine_ammodlev2: TKnobsSmallKnob;
    multisine_amplitude2: TKnobsSmallKnob;
    multisine_displayamplitude2: TKnobsDisplay;
    multisine_ammod2: TKnobsInput;
    multisine_fmult3: TKnobsSmallKnob;
    multisine_displaymult3: TKnobsDisplay;
    multisine_cents3: TKnobsSmallKnob;
    multisine_displaycents3: TKnobsDisplay;
    multisine_mute3: TKnobsSelector;
    multisine_textlabel_level3: TKnobsTextLabel;
    multisine_textlabel_am3: TKnobsTextLabel;
    multisine_ammodlev3: TKnobsSmallKnob;
    multisine_amplitude3: TKnobsSmallKnob;
    multisine_displayamplitude3: TKnobsDisplay;
    multisine_ammod3: TKnobsInput;
    multisine_fmult4: TKnobsSmallKnob;
    multisine_displaymult4: TKnobsDisplay;
    multisine_cents4: TKnobsSmallKnob;
    multisine_displaycents4: TKnobsDisplay;
    multisine_mute4: TKnobsSelector;
    multisine_textlabel_level4: TKnobsTextLabel;
    multisine_textlabel_am4: TKnobsTextLabel;
    multisine_ammodlev4: TKnobsSmallKnob;
    multisine_amplitude4: TKnobsSmallKnob;
    multisine_displayamplitude4: TKnobsDisplay;
    multisine_ammod4: TKnobsInput;
    multisine_fmult5: TKnobsSmallKnob;
    multisine_displaymult5: TKnobsDisplay;
    multisine_cents5: TKnobsSmallKnob;
    multisine_displaycents5: TKnobsDisplay;
    multisine_mute5: TKnobsSelector;
    multisine_textlabel_level5: TKnobsTextLabel;
    multisine_textlabel_am5: TKnobsTextLabel;
    multisine_ammodlev5: TKnobsSmallKnob;
    multisine_amplitude5: TKnobsSmallKnob;
    multisine_displayamplitude5: TKnobsDisplay;
    multisine_ammod5: TKnobsInput;
    multisine_fmult6: TKnobsSmallKnob;
    multisine_displaymult6: TKnobsDisplay;
    multisine_cents6: TKnobsSmallKnob;
    multisine_displaycents6: TKnobsDisplay;
    multisine_mute6: TKnobsSelector;
    multisine_textlabel_level6: TKnobsTextLabel;
    multisine_textlabel_am6: TKnobsTextLabel;
    multisine_ammodlev6: TKnobsSmallKnob;
    multisine_amplitude6: TKnobsSmallKnob;
    multisine_displayamplitude6: TKnobsDisplay;
    multisine_ammod6: TKnobsInput;
    multisine_symbol_sync: TImage;
    multisine_sync: TKnobsInput;
    multisine_mute: TKnobsSelector;
    multisine_textlabel_sync: TKnobsTextLabel;
    randsig_speed: TKnobsInput;
    randsig_textlabel_speed: TKnobsTextLabel;
    textwriter: TKnobsModule;
    textwriter_editlabel: TKnobsEditLabel;
    textwriter_display_text: TKnobsDisplay;
    textwriter_fileselector_filename: TKnobsFileSelector;
    textwriter_symbol_trig: TImage;
    textwriter_trig: TKnobsInput;
    textwriter_textlabel_trig: TKnobsTextLabel;
    textwriter_indicator_trig: TKnobsIndicator;
    textwriter_symbol_reset: TImage;
    textwriter_reset: TKnobsInput;
    textwriter_textlabel_reset: TKnobsTextLabel;
    textwriter_indicator_reset: TKnobsIndicator;
    filter6dbpbsm: TKnobsModule;
    filter6dbpbsm_outr: TKnobsOutput;
    filter6dbpbsm_inr: TKnobsInput;
    filter6dbpbsm_editlabel: TKnobsEditLabel;
    filter6dbpbsm_textlabel_in: TKnobsTextLabel;
    filter6dbpbsm_textlabel_out: TKnobsTextLabel;
    filter6dbpbsm_textlabel_lp: TKnobsTextLabel;
    filter6dbpbsm_textlabel_hp: TKnobsTextLabel;
    filter6dbpbsm_inl: TKnobsInput;
    filter6dbpbsm_outl: TKnobsOutput;
    filter6dbpbsm_freqlp: TKnobsSmallKnob;
    filter6dbpbsm_display_freqlp: TKnobsDisplay;
    filter6dbpbsm_freqhp: TKnobsSmallKnob;
    filter6dbpbsm_display_freqhp: TKnobsDisplay;
    filter6dbpbsm_freqmod: TKnobsInput;
    filter6dbpbsm_freqmodamt: TKnobsSmallKnob;
    livemorph_fractions: TKnobsSmallKnob;
    livemorph_display_fractions: TKnobsDisplay;
    livemorph_textlabel_quant: TKnobsTextLabel;
    cuclipstereo: TKnobsModule;
    cuclipstereo_outl: TKnobsOutput;
    cuclipstereo_inl: TKnobsInput;
    cuclipstereo_editlabel: TKnobsEditLabel;
    cuclipstereo_textlabel_plpha: TKnobsTextLabel;
    cuclipstereo_textlabel_hysteresis: TKnobsTextLabel;
    cuclipstereo_alpha: TKnobsSmallKnob;
    cuclipstereo_display_alpha: TKnobsDisplay;
    cuclipstereo_mute: TKnobsSelector;
    cuclipstereo_hysteresis: TKnobsSmallKnob;
    cuclipstereo_display_hysteresis: TKnobsDisplay;
    cuclipstereo_inr: TKnobsInput;
    cuclipstereo_outr: TKnobsOutput;
    morphcontrol: TKnobsModule;
    morphcontrol_in1: TKnobsInput;
    morphcontrol_editlabel: TKnobsEditLabel;
    morphcontrol_intype1: TKnobsSelector;
    morphcontrol_active1: TKnobsSelector;
    morphcontrol_mod1: TKnobsInput;
    morphcontrol_textlabel_mod1: TKnobsTextLabel;
    morphcontrol_level1: TKnobsSmallKnob;
    morphcontrol_display_level1: TKnobsDisplay;
    morphcontrol_modamt1: TKnobsSmallKnob;
    morphcontrol_textlabel_level1: TKnobsTextLabel;
    morphcontrol_textlabel_in1: TKnobsTextLabel;
    morphcontrol_in2: TKnobsInput;
    morphcontrol_intype2: TKnobsSelector;
    morphcontrol_active2: TKnobsSelector;
    morphcontrol_mod2: TKnobsInput;
    morphcontrol_textlabel_mod2: TKnobsTextLabel;
    morphcontrol_level2: TKnobsSmallKnob;
    morphcontrol_display_level2: TKnobsDisplay;
    morphcontrol_modamt2: TKnobsSmallKnob;
    morphcontrol_textlabel_level2: TKnobsTextLabel;
    morphcontrol_textlabel_in2: TKnobsTextLabel;
    morphcontrol_in3: TKnobsInput;
    morphcontrol_intype3: TKnobsSelector;
    morphcontrol_active3: TKnobsSelector;
    morphcontrol_mod3: TKnobsInput;
    morphcontrol_textlabel_mod3: TKnobsTextLabel;
    morphcontrol_level3: TKnobsSmallKnob;
    morphcontrol_display_level3: TKnobsDisplay;
    morphcontrol_modamt3: TKnobsSmallKnob;
    morphcontrol_textlabel_level3: TKnobsTextLabel;
    morphcontrol_textlabel_in3: TKnobsTextLabel;
    morphcontrol_in4: TKnobsInput;
    morphcontrol_intype4: TKnobsSelector;
    morphcontrol_active4: TKnobsSelector;
    morphcontrol_mod4: TKnobsInput;
    morphcontrol_textlabel_mod4: TKnobsTextLabel;
    morphcontrol_level4: TKnobsSmallKnob;
    morphcontrol_display_level4: TKnobsDisplay;
    morphcontrol_modamt4: TKnobsSmallKnob;
    morphcontrol_textlabel_level4: TKnobsTextLabel;
    morphcontrol_textlabel_in4: TKnobsTextLabel;
    arpeggiator_lengthmod: TKnobsInput;
    osc_warpmod: TKnobsInput;
    osc_textlabel_warp: TKnobsTextLabel;
    osc_warpmodamt: TKnobsSmallKnob;
    osc_warp: TKnobsSmallKnob;
    osc_textlabel_wm: TKnobsTextLabel;
    pdosc: TKnobsModule;
    pdosc_editlabel: TKnobsEditLabel;
    pdosc_symbol_sync: TImage;
    pdosc_out: TKnobsOutput;
    pdosc_fmmod: TKnobsInput;
    pdosc_centsmod: TKnobsInput;
    pdosc_sync: TKnobsInput;
    pdosc_textlabel_fm: TKnobsTextLabel;
    pdosc_textlabel_cents: TKnobsTextLabel;
    pdosc_textlabel_sync: TKnobsTextLabel;
    pdosc_textlabel_freq: TKnobsTextLabel;
    pdosc_freq: TKnobsInput;
    pdosc_speed: TKnobsInput;
    pdosc_textlabel_speed: TKnobsTextLabel;
    pdosc_frequency: TKnobsSmallKnob;
    pdosc_display_frequency: TKnobsDisplay;
    pdosc_mute: TKnobsSelector;
    pdosc_fmmodlev: TKnobsSmallKnob;
    pdosc_centsmodlev: TKnobsSmallKnob;
    pdosc_cents: TKnobsSmallKnob;
    pdosc_display_cents: TKnobsDisplay;
    pdosc_ratiomod: TKnobsInput;
    pdosc_textlabel_ratio: TKnobsTextLabel;
    pdosc_ratiomodlev: TKnobsSmallKnob;
    pdosc_ratio: TKnobsSmallKnob;
    pdosc_lfmmod: TKnobsInput;
    pdosc_textlabel_pm: TKnobsTextLabel;
    pdosc_lfmmodlev: TKnobsSmallKnob;
    pdosc_symbol_line: TImage;
    masterosc: TKnobsModule;
    masterosc_editlabel: TKnobsEditLabel;
    masterosc_out: TKnobsOutput;
    masterosc_fmmod: TKnobsInput;
    masterosc_textlabel_fm: TKnobsTextLabel;
    masterosc_textlabel_freq: TKnobsTextLabel;
    masterosc_freq: TKnobsInput;
    masterosc_lfmmod: TKnobsInput;
    masterosc_textlabel_lfm: TKnobsTextLabel;
    masterosc_centsmod: TKnobsInput;
    masterosc_textlabel_ct: TKnobsTextLabel;
    masterosc_textlabel_speed: TKnobsTextLabel;
    masterosc_speed: TKnobsInput;
    masterosc_frequency: TKnobsSmallKnob;
    masterosc_display_frequency: TKnobsDisplay;
    masterosc_fmmodlev: TKnobsSmallKnob;
    masterosc_cents: TKnobsSmallKnob;
    masterosc_display_cents: TKnobsDisplay;
    masterosc_lfmmodlev: TKnobsSmallKnob;
    masterosc_lfm: TKnobsSmallKnob;
    masterosc_display_speed: TKnobsDisplay;
    masterosc_centsmodamt: TKnobsSmallKnob;
    masterosc_textlabel_speedout: TKnobsTextLabel;
    voice_tabsheet: TTabSheet;
    vosim: TKnobsModule;
    vosim_editlabel: TKnobsEditLabel;
    vosim_symbol_trig: TImage;
    vosim_out: TKnobsOutput;
    vosim_fm: TKnobsInput;
    vosim_trig: TKnobsInput;
    vosim_textlabel_fm: TKnobsTextLabel;
    vosim_textlabel_trig: TKnobsTextLabel;
    vosim_textlabel_count: TKnobsTextLabel;
    vosim_freq: TKnobsInput;
    vosim_textlabel_decay: TKnobsTextLabel;
    vosim_textlabel_freq: TKnobsTextLabel;
    vosim_dm: TKnobsInput;
    vosim_textlabel_dm: TKnobsTextLabel;
    vosim_am: TKnobsInput;
    vosim_textlabel_am: TKnobsTextLabel;
    vosim_textlabel_amplitude: TKnobsTextLabel;
    vosim_cm: TKnobsInput;
    vosim_wm: TKnobsInput;
    vosim_textlabel_wm: TKnobsTextLabel;
    vosim_textlabel_whisper: TKnobsTextLabel;
    vosim_textlabel_out: TKnobsTextLabel;
    vosim_frequency: TKnobsSmallKnob;
    vosim_display_freq: TKnobsDisplay;
    vosim_display_count: TKnobsDisplay;
    vosim_count: TKnobsNoKnob;
    vosim_mute: TKnobsSelector;
    vosim_fmamt: TKnobsSmallKnob;
    vosim_decay: TKnobsSmallKnob;
    vosim_display_decay: TKnobsDisplay;
    vosim_dmamt: TKnobsSmallKnob;
    vosim_amplitude: TKnobsSmallKnob;
    vosim_amamt: TKnobsSmallKnob;
    vosim_whisper: TKnobsSmallKnob;
    vosim_wmamt: TKnobsSmallKnob;
    song: TKnobsModule;
    song_editlabel: TKnobsEditLabel;
    song_symbol_res: TImage;
    song_res: TKnobsInput;
    song_indicator_res: TKnobsIndicator;
    song_textlabel_res: TKnobsTextLabel;
    song_out: TKnobsOutput;
    song_txtstart: TKnobsOutput;
    song_phstart: TKnobsOutput;
    song_textlabel_phstart: TKnobsTextLabel;
    song_textlabel_txtstart: TKnobsTextLabel;
    song_textlabel_loop: TKnobsTextLabel;
    song_textlabel_whisper: TKnobsTextLabel;
    song_whispermod: TKnobsInput;
    song_textlabel_out: TKnobsTextLabel;
    song_textlabel_speed: TKnobsTextLabel;
    song_speedmod: TKnobsInput;
    song_textlabel_fm: TKnobsTextLabel;
    song_fmmod: TKnobsInput;
    song_silence: TKnobsOutput;
    song_vowel: TKnobsOutput;
    song_textlabel_vowel: TKnobsTextLabel;
    song_textlabel_silence: TKnobsTextLabel;
    song_pm: TKnobsInput;
    song_textlabel_pm: TKnobsTextLabel;
    song_frequency: TKnobsInput;
    song_txtend: TKnobsOutput;
    song_textlabel_txtend: TKnobsTextLabel;
    song_display_text: TKnobsDisplay;
    song_mute: TKnobsSelector;
    song_loop: TKnobsSelector;
    song_whisper: TKnobsSmallKnob;
    song_whispermodamt: TKnobsSmallKnob;
    song_speed: TKnobsSmallKnob;
    song_speedmodamt: TKnobsSmallKnob;
    song_freq: TKnobsSmallKnob;
    song_fmmodamt: TKnobsSmallKnob;
    song_display_frequency: TKnobsDisplay;
    song_filtinv: TKnobsSelector;
    song_shape: TKnobsSelector;
    song_pmamt: TKnobsSmallKnob;
    tss: TKnobsModule;
    tss_editlabel: TKnobsEditLabel;
    tss_speed: TKnobsInput;
    tss_textlabel_speed: TKnobsTextLabel;
    tss_textlabel_duration: TKnobsTextLabel;
    tss_textlabel_pos: TKnobsTextLabel;
    tss_pos: TKnobsInput;
    tss_symbol_res: TImage;
    tss_res: TKnobsInput;
    tss_indicator_res: TKnobsIndicator;
    tss_textlabel_res: TKnobsTextLabel;
    tss_out: TKnobsOutput;
    tss_fm: TKnobsInput;
    tss_textlabel_fm: TKnobsTextLabel;
    tss_display_duration: TKnobsDisplay;
    tss_display_text: TKnobsDisplay;
    tss_mute: TKnobsSelector;
    talkie: TKnobsModule;
    talkie_editlabel: TKnobsEditLabel;
    talkie_out: TKnobsOutput;
    talkie_symbol_start: TImage;
    talkie_start: TKnobsInput;
    talkie_textlabel_start: TKnobsTextLabel;
    talkie_rdy: TKnobsOutput;
    talkie_indicator_runs: TKnobsIndicator;
    talkie_textlabel_rdy: TKnobsTextLabel;
    talkie_phrase: TKnobsInput;
    talkie_textlabel_phrase: TKnobsTextLabel;
    talkie_indicator_rdy: TKnobsIndicator;
    talkie_textlabel_speaking: TKnobsTextLabel;
    talkie_frmod: TKnobsInput;
    talkie_textlabel_framerate: TKnobsTextLabel;
    talkie_srmod: TKnobsInput;
    talkie_textlabel_samplerate: TKnobsTextLabel;
    talkie_textlabel_bank: TKnobsTextLabel;
    talkie_fm: TKnobsInput;
    talkie_textlabel_fm: TKnobsTextLabel;
    talkie_banksel: TKnobsInput;
    talkie_textlabel_banksel: TKnobsTextLabel;
    talkie_bank: TKnobsSelector;
    talkie_mute: TKnobsSelector;
    talkie_fr: TKnobsSmallKnob;
    talkie_frmodamt: TKnobsSmallKnob;
    talkie_sr: TKnobsSmallKnob;
    talkie_srmodamt: TKnobsSmallKnob;
    separator_voice1: TKnobsModule;
    formant2: TKnobsModule;
    formant2_out: TKnobsOutput;
    formant2_in: TKnobsInput;
    formant2_editlabel: TKnobsEditLabel;
    formant2_textlabel_in: TKnobsTextLabel;
    formant2_textlabel_control: TKnobsTextLabel;
    formant2_vowelin: TKnobsInput;
    formant2_textlabel_vowel: TKnobsTextLabel;
    formant2_textlabel_level: TKnobsTextLabel;
    formant2_vowel: TKnobsSmallKnob;
    formant2_controlmod: TKnobsSmallKnob;
    formant2_vowelset: TKnobsSelector;
    formant2_level: TKnobsSmallKnob;
    formant: TKnobsModule;
    formant_out: TKnobsOutput;
    formant_in: TKnobsInput;
    formant_editlabel: TKnobsEditLabel;
    formant_textlabel_in: TKnobsTextLabel;
    formant_textlabel_control: TKnobsTextLabel;
    formant_vowelin: TKnobsInput;
    formant_textlabel_vowel: TKnobsTextLabel;
    formant_textlabel_level: TKnobsTextLabel;
    formant_vowel: TKnobsSmallKnob;
    formant_controlmod: TKnobsSmallKnob;
    formant_level: TKnobsSmallKnob;
    multiphaseosc: TKnobsModule;
    multiphaseosc_editlabel: TKnobsEditLabel;
    multiphaseosc_symbol_sync: TImage;
    multiphaseosc_out: TKnobsOutput;
    multiphaseosc_fm: TKnobsInput;
    multiphaseosc_phase: TKnobsInput;
    multiphaseosc_sync: TKnobsInput;
    multiphaseosc_textlabel_fm: TKnobsTextLabel;
    multiphaseosc_textlabel_pm: TKnobsTextLabel;
    multiphaseosc_textlabel_sync: TKnobsTextLabel;
    multiphaseosc_textlabel_blimit: TKnobsTextLabel;
    multiphaseosc_textlabel_freq: TKnobsTextLabel;
    multiphaseosc_freq: TKnobsInput;
    multiphaseosc_speed: TKnobsInput;
    multiphaseosc_textlabel_speed: TKnobsTextLabel;
    multiphaseosc_warpmod: TKnobsInput;
    multiphaseosc_textlabel_warp: TKnobsTextLabel;
    multiphaseosc_textlabel_wm: TKnobsTextLabel;
    multiphaseosc_frequency: TKnobsSmallKnob;
    multiphaseosc_display_frequency: TKnobsDisplay;
    multiphaseosc_mute: TKnobsSelector;
    multiphaseosc_shape: TKnobsSelector;
    multiphaseosc_fmlevel: TKnobsSmallKnob;
    multiphaseosc_pmlevel: TKnobsSmallKnob;
    multiphaseosc_cents: TKnobsSmallKnob;
    multiphaseosc_display_cents: TKnobsDisplay;
    multiphaseosc_bandlimit: TKnobsSmallKnob;
    multiphaseosc_warpmodamt: TKnobsSmallKnob;
    multiphaseosc_warp: TKnobsSmallKnob;
    multiphaseosc_out2: TKnobsOutput;
    multiphaseosc_out3: TKnobsOutput;
    multiphaseosc_out4: TKnobsOutput;
    lfomultiphase: TKnobsModule;
    lfomultiphase_editlabel: TKnobsEditLabel;
    lfomultiphase_symbol_sync: TImage;
    lfomultiphase_out: TKnobsOutput;
    lfomultiphase_fm: TKnobsInput;
    lfomultiphase_phase: TKnobsInput;
    lfomultiphase_res: TKnobsInput;
    lfomultiphase_indicator_out: TKnobsIndicator;
    lfomultiphase_indicator_res: TKnobsIndicator;
    lfomultiphase_textlabel_fm: TKnobsTextLabel;
    lfomultiphase_textlabel_pm: TKnobsTextLabel;
    lfomultiphase_textlabel_res: TKnobsTextLabel;
    lfomultiphase_sync: TKnobsOutput;
    lfomultiphase_textlabel_syn: TKnobsTextLabel;
    lfomultiphase_freq: TKnobsInput;
    lfomultiphase_speed: TKnobsInput;
    lfomultiphase_textlabel_spd: TKnobsTextLabel;
    lfomultiphase_frequency: TKnobsSmallKnob;
    lfomultiphase_dissplay_frequency: TKnobsDisplay;
    lfomultiphase_mute: TKnobsSelector;
    lfomultiphase_range: TKnobsSelector;
    lfomultiphase_shape: TKnobsSelector;
    lfomultiphase_fmlevel: TKnobsSmallKnob;
    lfomultiphase_pmlevel: TKnobsSmallKnob;
    lfomultiphase_outputtype: TKnobsSelector;
    separator_lfo2: TKnobsModule;
    lfomultiphase_out2: TKnobsOutput;
    lfomultiphase_out3: TKnobsOutput;
    lfomultiphase_out4: TKnobsOutput;
    lfomultiphase_phaseshift: TKnobsSelector;
    multiphaseosc_phaseshift: TKnobsSelector;
    square_pwmoff: TKnobsSmallKnob;
    square_pwmplm: TKnobsSelector;
    thirdcombiner: TKnobsModule;
    thirdcombiner_editlabel: TKnobsEditLabel;
    thirdcombiner_textlabel_lev: TKnobsTextLabel;
    thirdcombiner_textlabel_steepness: TKnobsTextLabel;
    thirdcombiner_textlabel_q: TKnobsTextLabel;
    thirdcombiner_fm: TKnobsInput;
    thirdcombiner_textlabel_fm: TKnobsTextLabel;
    thirdcombiner_indicator_clip1: TKnobsIndicator;
    thirdcombiner_indicator_clip2: TKnobsIndicator;
    thirdcombiner_indicator_clip3: TKnobsIndicator;
    thirdcombiner_indicator_clip4: TKnobsIndicator;
    thirdcombiner_indicator_clip5: TKnobsIndicator;
    thirdcombiner_indicator_clip6: TKnobsIndicator;
    thirdcombiner_indicator_clip7: TKnobsIndicator;
    thirdcombiner_indicator_clip8: TKnobsIndicator;
    thirdcombiner_indicator_clip9: TKnobsIndicator;
    thirdcombiner_indicator_clip10: TKnobsIndicator;
    thirdcombiner_indicator_clip11: TKnobsIndicator;
    thirdcombiner_indicator_clip12: TKnobsIndicator;
    thirdcombiner_indicator_clip13: TKnobsIndicator;
    thirdcombiner_indicator_clip14: TKnobsIndicator;
    thirdcombiner_indicator_clip15: TKnobsIndicator;
    thirdcombiner_indicator_clip16: TKnobsIndicator;
    thirdcombiner_indicator_clip17: TKnobsIndicator;
    thirdcombiner_textlabel_frequencies2: TKnobsTextLabel;
    thirdcombiner_textlabel_frequencies1: TKnobsTextLabel;
    thirdcombiner_level: TKnobsSmallKnob;
    thirdcombiner_modehigh: TKnobsSelector;
    thirdcombiner_display_steepness: TKnobsDisplay;
    thirdcombiner_steepness: TKnobsNoKnob;
    thirdcombiner_modelow: TKnobsSelector;
    thirdcombiner_q: TKnobsSmallKnob;
    thirdcombiner_fmamt: TKnobsSmallKnob;
    thirdcombiner_fi: TKnobsSelector;
    tritonecombiner: TKnobsModule;
    tritonecombiner_editlabel: TKnobsEditLabel;
    tritonecombiner_textlabel_out: TKnobsTextLabel;
    tritonecombiner_textlabel_lev: TKnobsTextLabel;
    tritonecombiner_textlabel_steepness: TKnobsTextLabel;
    tritonecombiner_textlabel_q: TKnobsTextLabel;
    tritonecombiner_fm: TKnobsInput;
    tritonecombiner_textlabel_fm: TKnobsTextLabel;
    tritonecombiner_indicator_clip1: TKnobsIndicator;
    tritonecombiner_indicator_clip2: TKnobsIndicator;
    tritonecombiner_indicator_clip3: TKnobsIndicator;
    tritonecombiner_indicator_clip4: TKnobsIndicator;
    tritonecombiner_indicator_clip5: TKnobsIndicator;
    tritonecombiner_indicator_clip6: TKnobsIndicator;
    tritonecombiner_indicator_clip7: TKnobsIndicator;
    tritonecombiner_indicator_clip8: TKnobsIndicator;
    tritonecombiner_indicator_clip9: TKnobsIndicator;
    tritonecombiner_indicator_clip10: TKnobsIndicator;
    tritonecombiner_indicator_clip11: TKnobsIndicator;
    tritonecombiner_indicator_clip12: TKnobsIndicator;
    tritonecombiner_indicator_clip13: TKnobsIndicator;
    tritonecombiner_indicator_clip14: TKnobsIndicator;
    tritonecombiner_indicator_clip15: TKnobsIndicator;
    tritonecombiner_indicator_clip16: TKnobsIndicator;
    tritonecombiner_indicator_clip17: TKnobsIndicator;
    tritonecombiner_textlabel_frequencies1: TKnobsTextLabel;
    tritonecombiner_textlabel_frequencies2: TKnobsTextLabel;
    tritonecombiner_level: TKnobsSmallKnob;
    tritonecombiner_modehigh: TKnobsSelector;
    tritonecombiner_display_steepness: TKnobsDisplay;
    tritonecombiner_steepness: TKnobsNoKnob;
    tritonecombiner_modelow: TKnobsSelector;
    tritonecombiner_q: TKnobsSmallKnob;
    tritonecombiner_fmamt: TKnobsSmallKnob;
    tritonecombiner_fi: TKnobsSelector;
    tritonecombiner_in1: TKnobsInput;
    tritonecombiner_in2: TKnobsInput;
    tritonecombiner_in3: TKnobsInput;
    tritonecombiner_in4: TKnobsInput;
    tritonecombiner_in5: TKnobsInput;
    tritonecombiner_in6: TKnobsInput;
    tritonecombiner_in7: TKnobsInput;
    tritonecombiner_in8: TKnobsInput;
    tritonecombiner_in9: TKnobsInput;
    tritonecombiner_in10: TKnobsInput;
    tritonecombiner_in11: TKnobsInput;
    tritonecombiner_in12: TKnobsInput;
    tritonecombiner_in13: TKnobsInput;
    tritonecombiner_in14: TKnobsInput;
    tritonecombiner_in15: TKnobsInput;
    tritonecombiner_in16: TKnobsInput;
    tritonecombiner_in17: TKnobsInput;
    thirdcombiner_in1: TKnobsInput;
    thirdcombiner_in2: TKnobsInput;
    thirdcombiner_in3: TKnobsInput;
    thirdcombiner_in4: TKnobsInput;
    thirdcombiner_in5: TKnobsInput;
    thirdcombiner_in6: TKnobsInput;
    thirdcombiner_in7: TKnobsInput;
    thirdcombiner_in8: TKnobsInput;
    thirdcombiner_in9: TKnobsInput;
    thirdcombiner_in10: TKnobsInput;
    thirdcombiner_in11: TKnobsInput;
    thirdcombiner_in12: TKnobsInput;
    thirdcombiner_in13: TKnobsInput;
    thirdcombiner_in14: TKnobsInput;
    thirdcombiner_in15: TKnobsInput;
    thirdcombiner_in16: TKnobsInput;
    thirdcombiner_in17: TKnobsInput;
    tritonecombiner_inout: TKnobsOutput;
    thirdcombiner_textlabel_out: TKnobsTextLabel;
    thirdcombiner_out: TKnobsOutput;
    multienvelope: TKnobsModule;
    multienvelope_editlabel: TKnobsEditLabel;
    multienvelope_textlabel_a: TKnobsTextLabel;
    multienvelope_textlabel_r: TKnobsTextLabel;
    multienvelope_attack: TKnobsSmallKnob;
    multienvelope_release: TKnobsSmallKnob;
    multienvelope_display_attack: TKnobsDisplay;
    multienvelope_display_release: TKnobsDisplay;
    multienvelope_in1: TKnobsInput;
    multienvelope_in2: TKnobsInput;
    multienvelope_in3: TKnobsInput;
    multienvelope_in4: TKnobsInput;
    multienvelope_in5: TKnobsInput;
    multienvelope_in6: TKnobsInput;
    multienvelope_in7: TKnobsInput;
    multienvelope_in8: TKnobsInput;
    multienvelope_in9: TKnobsInput;
    multienvelope_in10: TKnobsInput;
    multienvelope_in11: TKnobsInput;
    multienvelope_in12: TKnobsInput;
    multienvelope_in13: TKnobsInput;
    multienvelope_in14: TKnobsInput;
    multienvelope_in15: TKnobsInput;
    multienvelope_in16: TKnobsInput;
    multienvelope_in17: TKnobsInput;
    multienvelope_out1: TKnobsOutput;
    multienvelope_out2: TKnobsOutput;
    multienvelope_out3: TKnobsOutput;
    multienvelope_out4: TKnobsOutput;
    multienvelope_out5: TKnobsOutput;
    multienvelope_out6: TKnobsOutput;
    multienvelope_out7: TKnobsOutput;
    multienvelope_out8: TKnobsOutput;
    multienvelope_out9: TKnobsOutput;
    multienvelope_out10: TKnobsOutput;
    multienvelope_out11: TKnobsOutput;
    multienvelope_out12: TKnobsOutput;
    multienvelope_out13: TKnobsOutput;
    multienvelope_out14: TKnobsOutput;
    multienvelope_out15: TKnobsOutput;
    multienvelope_out16: TKnobsOutput;
    multienvelope_out17: TKnobsOutput;
    multienvelope_mult1: TKnobsInput;
    multienvelope_mult2: TKnobsInput;
    multienvelope_mult3: TKnobsInput;
    multienvelope_mult4: TKnobsInput;
    multienvelope_mult5: TKnobsInput;
    multienvelope_mult6: TKnobsInput;
    multienvelope_mult7: TKnobsInput;
    multienvelope_mult8: TKnobsInput;
    multienvelope_mult9: TKnobsInput;
    multienvelope_mult10: TKnobsInput;
    multienvelope_mult11: TKnobsInput;
    multienvelope_mult12: TKnobsInput;
    multienvelope_mult13: TKnobsInput;
    multienvelope_mult14: TKnobsInput;
    multienvelope_mult15: TKnobsInput;
    multienvelope_mult16: TKnobsInput;
    multienvelope_mult17: TKnobsInput;
    quantizer_nozero: TKnobsSelector;
    tiltfilterstereo: TKnobsModule;
    tiltfilterstereo_out: TKnobsOutput;
    tiltfilterstereo_in: TKnobsInput;
    tiltfilterstereo_fmmod: TKnobsInput;
    tiltfilterstereo_editlabel: TKnobsEditLabel;
    tiltfilterstereo_textlabel_in: TKnobsTextLabel;
    tiltfilterstereo_textlabel_fm: TKnobsTextLabel;
    tiltfilterstereo_textlabel_tilt: TKnobsTextLabel;
    tiltfilterstereo_textlabel_out: TKnobsTextLabel;
    tiltfilterstereo_tiltmod: TKnobsInput;
    tiltfilterstereo_display_freq: TKnobsDisplay;
    tiltfilterstereo_freq: TKnobsSmallKnob;
    tiltfilterstereo_tilt: TKnobsSmallKnob;
    tiltfilterstereo_fmmodamt: TKnobsSmallKnob;
    tiltfilterstereo_inlevel: TKnobsSmallKnob;
    tiltfilterstereo_tiltmodamt: TKnobsSmallKnob;
    tiltfilterstereo_out2: TKnobsOutput;
    tiltfilterstereo_in2: TKnobsInput;
    demux_steps: TKnobsNoKnob;
    demux_display_steps: TKnobsDisplay;
    mux_steps: TKnobsNoKnob;
    mux_display_steps: TKnobsDisplay;
    freqshifter_shiftdepthamt: TKnobsSmallKnob;
    textwriter_textlabel_pointer: TKnobsTextLabel;
    pitchshift_delaymod: TKnobsInput;
    pitchshift_textlabel_delaymod: TKnobsTextLabel;
    pitchshift_delaymodamt: TKnobsSmallKnob;
    amuse: TKnobsModule;
    amuse_editlabel: TKnobsEditLabel;
    amuse_symbol_trig: TImage;
    amuse_trig: TKnobsInput;
    amuse_textlabel_trig: TKnobsTextLabel;
    amuse_out: TKnobsOutput;
    amuse_textlabel_out: TKnobsTextLabel;
    amuse_sela: TKnobsSmallKnob;
    amuse_display_swa: TKnobsDisplay;
    amuse_selb: TKnobsSmallKnob;
    amuse_display_swb: TKnobsDisplay;
    amuse_selc: TKnobsSmallKnob;
    amuse_display_swc: TKnobsDisplay;
    amuse_seld: TKnobsSmallKnob;
    amuse_display_swd: TKnobsDisplay;
    amuse_selw: TKnobsSmallKnob;
    amuse_display_sww: TKnobsDisplay;
    amuse_selx: TKnobsSmallKnob;
    amuse_display_swx: TKnobsDisplay;
    amuse_sely: TKnobsSmallKnob;
    amuse_display_swy: TKnobsDisplay;
    amuse_selz: TKnobsSmallKnob;
    amuse_display_swz: TKnobsDisplay;
    amuse_symbol_reset: TImage;
    amuse_reset: TKnobsInput;
    amuse_textlabel_reset: TKnobsTextLabel;
    amuse_textlabel_interval: TKnobsTextLabel;
    amuse_textlabel_theme: TKnobsTextLabel;
    amuse_textlabel_a: TKnobsTextLabel;
    amuse_textlabel_b: TKnobsTextLabel;
    amuse_textlabel_c: TKnobsTextLabel;
    amuse_textlabel_d: TKnobsTextLabel;
    amuse_textlabel_w: TKnobsTextLabel;
    amuse_textlabel_x: TKnobsTextLabel;
    amuse_textlabel_y: TKnobsTextLabel;
    amuse_textlabel_z: TKnobsTextLabel;
    amuse_selmoda: TKnobsInput;
    amuse_selmodb: TKnobsInput;
    amuse_selmodc: TKnobsInput;
    amuse_selmodd: TKnobsInput;
    amuse_selmodw: TKnobsInput;
    amuse_selmodx: TKnobsInput;
    amuse_selmody: TKnobsInput;
    amuse_selmodz: TKnobsInput;
    amuse_selmodamtw: TKnobsSmallKnob;
    amuse_selmodamtx: TKnobsSmallKnob;
    amuse_selmodamty: TKnobsSmallKnob;
    amuse_selmodamtz: TKnobsSmallKnob;
    amuse_selmodamta: TKnobsSmallKnob;
    amuse_selmodamtb: TKnobsSmallKnob;
    amuse_selmodamtc: TKnobsSmallKnob;
    amuse_selmodamtd: TKnobsSmallKnob;
    amuse_clocked: TKnobsSelector;
    amuse_ext1: TKnobsInput;
    amuse_textlabel_ext: TKnobsTextLabel;
    amuse_ext2: TKnobsInput;
    amuse_sele: TKnobsSmallKnob;
    amuse_display_swe: TKnobsDisplay;
    amuse_textlabel_e: TKnobsTextLabel;
    amuse_selmodde: TKnobsInput;
    amuse_selmodamte: TKnobsSmallKnob;
    amuse_inv: TKnobsOutput;
    amuse_textlabel_inv: TKnobsTextLabel;
    amuse_bit: TKnobsOutput;
    amuse_reverse: TKnobsInput;
    amuse_textlabel_rev: TKnobsTextLabel;
    amuse_evenodd: TKnobsSelector;
    amuse_textlabel_parity: TKnobsTextLabel;
    amuse_paritymod: TKnobsInput;
    amuse_lights: TKnobsGridControl;
    amuse_data: TKnobsOutput;
    amuse_textlabel_bits: TKnobsTextLabel;
    shifter: TKnobsModule;
    shifter_editlabel: TKnobsEditLabel;
    shifter_symbol_trig: TImage;
    shifter_out0: TKnobsOutput;
    shifter_trig: TKnobsInput;
    shifter_textlabel_trig: TKnobsTextLabel;
    shifter_symbol_reset: TImage;
    shifter_reset: TKnobsInput;
    shifter_textlabel_reset: TKnobsTextLabel;
    shifter_out1: TKnobsOutput;
    shifter_out2: TKnobsOutput;
    shifter_out3: TKnobsOutput;
    shifter_out4: TKnobsOutput;
    shifter_out5: TKnobsOutput;
    shifter_out6: TKnobsOutput;
    shifter_out7: TKnobsOutput;
    shifter_out8: TKnobsOutput;
    shifter_out9: TKnobsOutput;
    shifter_out10: TKnobsOutput;
    shifter_out11: TKnobsOutput;
    shifter_out12: TKnobsOutput;
    shifter_out13: TKnobsOutput;
    shifter_out14: TKnobsOutput;
    shifter_out15: TKnobsOutput;
    shifter_textlabel_0: TKnobsTextLabel;
    shifter_textlabel_1: TKnobsTextLabel;
    shifter_textlabel_2: TKnobsTextLabel;
    shifter_textlabel_3: TKnobsTextLabel;
    shifter_textlabel_4: TKnobsTextLabel;
    shifter_textlabel_5: TKnobsTextLabel;
    shifter_textlabel_6: TKnobsTextLabel;
    shifter_textlabel_7: TKnobsTextLabel;
    shifter_textlabel_8: TKnobsTextLabel;
    shifter_textlabel_9: TKnobsTextLabel;
    shifter_textlabel_10: TKnobsTextLabel;
    shifter_textlabel_11: TKnobsTextLabel;
    shifter_textlabel_12: TKnobsTextLabel;
    shifter_textlabel_13: TKnobsTextLabel;
    shifter_textlabel_14: TKnobsTextLabel;
    shifter_textlabel_15: TKnobsTextLabel;
    shifter_textlabel_reverse: TKnobsTextLabel;
    shifter_reverse: TKnobsInput;
    shifter_indicator_trig: TKnobsIndicator;
    shifter_indicator_reset: TKnobsIndicator;
    shifter_indicator_reverse: TKnobsIndicator;
    shifter_clocked: TKnobsSelector;
    shifter_out16: TKnobsOutput;
    shifter_out17: TKnobsOutput;
    shifter_out18: TKnobsOutput;
    shifter_out19: TKnobsOutput;
    shifter_out20: TKnobsOutput;
    shifter_out21: TKnobsOutput;
    shifter_out22: TKnobsOutput;
    shifter_out23: TKnobsOutput;
    shifter_out24: TKnobsOutput;
    shifter_out25: TKnobsOutput;
    shifter_out26: TKnobsOutput;
    shifter_out27: TKnobsOutput;
    shifter_out28: TKnobsOutput;
    shifter_out29: TKnobsOutput;
    shifter_out30: TKnobsOutput;
    shifter_out31: TKnobsOutput;
    shifter_textlabel_16: TKnobsTextLabel;
    shifter_textlabel_17: TKnobsTextLabel;
    shifter_textlabel_18: TKnobsTextLabel;
    shifter_textlabel_19: TKnobsTextLabel;
    shifter_textlabel_20: TKnobsTextLabel;
    shifter_textlabel_21: TKnobsTextLabel;
    shifter_textlabel_22: TKnobsTextLabel;
    shifter_textlabel_23: TKnobsTextLabel;
    shifter_textlabel_24: TKnobsTextLabel;
    shifter_textlabel_25: TKnobsTextLabel;
    shifter_textlabel_26: TKnobsTextLabel;
    shifter_textlabel_27: TKnobsTextLabel;
    shifter_textlabel_28: TKnobsTextLabel;
    shifter_textlabel_29: TKnobsTextLabel;
    shifter_textlabel_30: TKnobsTextLabel;
    shifter_textlabel_231: TKnobsTextLabel;
    shifter_carrylow: TKnobsOutput;
    shifter_indicator_carrylow: TKnobsIndicator;
    shifter_textlabel_carrylow: TKnobsTextLabel;
    shifter_carryhigh: TKnobsOutput;
    shifter_indicator_carryhigh: TKnobsIndicator;
    shifter_textlabel_carryhigh: TKnobsTextLabel;
    shifter_textlabel_extlow: TKnobsTextLabel;
    shifter_extlow: TKnobsInput;
    shifter_indicator_extlow: TKnobsIndicator;
    shifter_textlabel_exthigh: TKnobsTextLabel;
    shifter_exthigh: TKnobsInput;
    shifter_indicator_exthigh: TKnobsIndicator;
    shifter_lights: TKnobsGridControl;
    shifter_textlabel_in: TKnobsTextLabel;
    shifter_in: TKnobsInput;
    shifter_indicator_in: TKnobsIndicator;
    shifter_gatemode: TKnobsSelector;
    amuse_gatemode: TKnobsSelector;
    lfsr: TKnobsModule;
    lfsr_editlabel: TKnobsEditLabel;
    lfsr_symbol_trig: TImage;
    lfsr_trig: TKnobsInput;
    lfsr_textlabel_trig: TKnobsTextLabel;
    lfsr_symbol_reset: TImage;
    lfsr_reset: TKnobsInput;
    lfsr_textlabel_reset: TKnobsTextLabel;
    lfsr_textlabel_0: TKnobsTextLabel;
    lfsr_textlabel_1: TKnobsTextLabel;
    lfsr_textlabel_2: TKnobsTextLabel;
    lfsr_textlabel_3: TKnobsTextLabel;
    lfsr_textlabel_4: TKnobsTextLabel;
    lfsr_textlabel_5: TKnobsTextLabel;
    lfsr_textlabel_6: TKnobsTextLabel;
    lfsr_textlabel_7: TKnobsTextLabel;
    lfsr_textlabel_8: TKnobsTextLabel;
    lfsr_textlabel_9: TKnobsTextLabel;
    lfsr_textlabel_10: TKnobsTextLabel;
    lfsr_textlabel_11: TKnobsTextLabel;
    lfsr_textlabel_12: TKnobsTextLabel;
    lfsr_textlabel_13: TKnobsTextLabel;
    lfsr_textlabel_14: TKnobsTextLabel;
    lfsr_textlabel_15: TKnobsTextLabel;
    lfsr_textlabel_reverse: TKnobsTextLabel;
    lfsr_reverse: TKnobsInput;
    lfsr_indicator_trig: TKnobsIndicator;
    lfsr_indicator_reset: TKnobsIndicator;
    lfsr_indicator_reverse: TKnobsIndicator;
    lfsr_textlabel_16: TKnobsTextLabel;
    lfsr_textlabel_17: TKnobsTextLabel;
    lfsr_textlabel_18: TKnobsTextLabel;
    lfsr_textlabel_19: TKnobsTextLabel;
    lfsr_textlabel_20: TKnobsTextLabel;
    lfsr_textlabel_21: TKnobsTextLabel;
    lfsr_textlabel_22: TKnobsTextLabel;
    lfsr_textlabel_23: TKnobsTextLabel;
    lfsr_textlabel_24: TKnobsTextLabel;
    lfsr_textlabel_25: TKnobsTextLabel;
    lfsr_textlabel_26: TKnobsTextLabel;
    lfsr_textlabel_27: TKnobsTextLabel;
    lfsr_textlabel_28: TKnobsTextLabel;
    lfsr_textlabel_29: TKnobsTextLabel;
    lfsr_textlabel_30: TKnobsTextLabel;
    lfsr_textlabel_31: TKnobsTextLabel;
    lfsr_lights: TKnobsGridControl;
    lfsr_textlabel_in: TKnobsTextLabel;
    lfsr_in: TKnobsInput;
    lfsr_indicator_in: TKnobsIndicator;
    lfsr_clocked: TKnobsSelector;
    lfsr_gatemode: TKnobsSelector;
    lfsr_out: TKnobsOutput;
    lfsr_indicator_out: TKnobsIndicator;
    lfsr_textlabel_out: TKnobsTextLabel;
    lfsr_tap0: TKnobsSelector;
    lfsr_tap1: TKnobsSelector;
    lfsr_tap2: TKnobsSelector;
    lfsr_tap3: TKnobsSelector;
    lfsr_tap4: TKnobsSelector;
    lfsr_tap5: TKnobsSelector;
    lfsr_tap6: TKnobsSelector;
    lfsr_tap7: TKnobsSelector;
    lfsr_tap8: TKnobsSelector;
    lfsr_tap9: TKnobsSelector;
    lfsr_tap10: TKnobsSelector;
    lfsr_tap11: TKnobsSelector;
    lfsr_tap12: TKnobsSelector;
    lfsr_tap13: TKnobsSelector;
    lfsr_tap14: TKnobsSelector;
    lfsr_tap15: TKnobsSelector;
    lfsr_tap16: TKnobsSelector;
    lfsr_tap17: TKnobsSelector;
    lfsr_tap18: TKnobsSelector;
    lfsr_tap19: TKnobsSelector;
    lfsr_tap20: TKnobsSelector;
    lfsr_tap21: TKnobsSelector;
    lfsr_tap22: TKnobsSelector;
    lfsr_tap23: TKnobsSelector;
    lfsr_tap24: TKnobsSelector;
    lfsr_tap25: TKnobsSelector;
    lfsr_tap26: TKnobsSelector;
    lfsr_tap27: TKnobsSelector;
    lfsr_tap28: TKnobsSelector;
    lfsr_tap29: TKnobsSelector;
    lfsr_tap30: TKnobsSelector;
    lfsr_tap31: TKnobsSelector;
    lfsr_textlabel_parity: TKnobsTextLabel;
    lfsr_paritymod: TKnobsInput;
    lfsr_evenodd: TKnobsSelector;
    lfsr_tapmod0: TKnobsInput;
    lfsr_tapmod1: TKnobsInput;
    lfsr_tapmod2: TKnobsInput;
    lfsr_tapmod3: TKnobsInput;
    lfsr_tapmod4: TKnobsInput;
    lfsr_tapmod5: TKnobsInput;
    lfsr_tapmod6: TKnobsInput;
    lfsr_tapmod7: TKnobsInput;
    lfsr_tapmod8: TKnobsInput;
    lfsr_tapmod9: TKnobsInput;
    lfsr_tapmod10: TKnobsInput;
    lfsr_tapmod11: TKnobsInput;
    lfsr_tapmod12: TKnobsInput;
    lfsr_tapmod13: TKnobsInput;
    lfsr_tapmod14: TKnobsInput;
    lfsr_tapmod15: TKnobsInput;
    lfsr_tapmod16: TKnobsInput;
    lfsr_tapmod17: TKnobsInput;
    lfsr_tapmod18: TKnobsInput;
    lfsr_tapmod19: TKnobsInput;
    lfsr_tapmod20: TKnobsInput;
    lfsr_tapmod21: TKnobsInput;
    lfsr_tapmod22: TKnobsInput;
    lfsr_tapmod23: TKnobsInput;
    lfsr_tapmod24: TKnobsInput;
    lfsr_tapmod25: TKnobsInput;
    lfsr_tapmod26: TKnobsInput;
    lfsr_tapmod27: TKnobsInput;
    lfsr_tapmod28: TKnobsInput;
    lfsr_tapmod29: TKnobsInput;
    lfsr_tapmod30: TKnobsInput;
    lfsr_tapmod31: TKnobsInput;
    stack: TKnobsModule;
    stack_editlabel: TKnobsEditLabel;
    stack_textlabel_empty: TKnobsTextLabel;
    stack_empty: TKnobsOutput;
    stack_in0: TKnobsInput;
    stack_in1: TKnobsInput;
    stack_in2: TKnobsInput;
    stack_in3: TKnobsInput;
    stack_in4: TKnobsInput;
    stack_in5: TKnobsInput;
    stack_in6: TKnobsInput;
    stack_in7: TKnobsInput;
    stack_in8: TKnobsInput;
    stack_in9: TKnobsInput;
    stack_in10: TKnobsInput;
    stack_in11: TKnobsInput;
    stack_in12: TKnobsInput;
    stack_in13: TKnobsInput;
    stack_in14: TKnobsInput;
    stack_in15: TKnobsInput;
    stack_out0: TKnobsOutput;
    stack_out1: TKnobsOutput;
    stack_out2: TKnobsOutput;
    stack_out3: TKnobsOutput;
    stack_out4: TKnobsOutput;
    stack_out5: TKnobsOutput;
    stack_out6: TKnobsOutput;
    stack_out7: TKnobsOutput;
    stack_out8: TKnobsOutput;
    stack_out9: TKnobsOutput;
    stack_out10: TKnobsOutput;
    stack_out11: TKnobsOutput;
    stack_out12: TKnobsOutput;
    stack_out13: TKnobsOutput;
    stack_out14: TKnobsOutput;
    stack_out15: TKnobsOutput;
    stack_textlabel_0: TKnobsTextLabel;
    stack_textlabel_1: TKnobsTextLabel;
    stack_textlabel_2: TKnobsTextLabel;
    stack_textlabel_3: TKnobsTextLabel;
    stack_textlabel_4: TKnobsTextLabel;
    stack_textlabel_5: TKnobsTextLabel;
    stack_textlabel_6: TKnobsTextLabel;
    stack_textlabel_7: TKnobsTextLabel;
    stack_textlabel_8: TKnobsTextLabel;
    stack_textlabel_9: TKnobsTextLabel;
    stack_textlabel_10: TKnobsTextLabel;
    stack_textlabel_11: TKnobsTextLabel;
    stack_textlabel_12: TKnobsTextLabel;
    stack_textlabel_13: TKnobsTextLabel;
    stack_textlabel_14: TKnobsTextLabel;
    stack_textlabel_15: TKnobsTextLabel;
    stack_textlabel_full: TKnobsTextLabel;
    stack_full: TKnobsOutput;
    stack_push: TKnobsInput;
    stack_pop: TKnobsInput;
    stack_textlabel_push: TKnobsTextLabel;
    stack_textlabel_pop: TKnobsTextLabel;
    stack_indicator_push: TKnobsIndicator;
    stack_indicator_pop: TKnobsIndicator;
    stack_indicator_empty: TKnobsIndicator;
    stack_indicator_full: TKnobsIndicator;
    stack_textlabel_maxdepth: TKnobsTextLabel;
    stack_display_maxdepth: TKnobsDisplay;
    stack_size: TKnobsNoKnob;
    stack_indicator_depth: TKnobsIndicatorText;
    stack_lights: TKnobsGridControl;
    analogstack: TKnobsModule;
    analogstack_editlabel: TKnobsEditLabel;
    analogstack_textlabel_empty: TKnobsTextLabel;
    analogstack_empty: TKnobsOutput;
    analogstack_in: TKnobsInput;
    analogstack_out: TKnobsOutput;
    analogstack_textlabel_full: TKnobsTextLabel;
    analogstack_full: TKnobsOutput;
    analogstack_push: TKnobsInput;
    analogstack_pop: TKnobsInput;
    analogstack_textlabel_push: TKnobsTextLabel;
    analogstack_textlabel_pop: TKnobsTextLabel;
    analogstack_indicator_push: TKnobsIndicator;
    analogstack_indicator_pop: TKnobsIndicator;
    analogstack_indicator_empty: TKnobsIndicator;
    analogstack_indicator_ful: TKnobsIndicator;
    analogstack_textlabel_maxdepth: TKnobsTextLabel;
    analogstack_indicator_depth: TKnobsIndicatorText;
    analogstack_display_size: TKnobsDisplay;
    analogstack_size: TKnobsNoKnob;
    swansong: TKnobsModule;
    swansong_editlabel: TKnobsEditLabel;
    swansong_hunter1clock: TKnobsInput;
    swansong_symbol_hunterclock1: TImage;
    swansong_textlabel_hunter1: TKnobsTextLabel;
    swansong_hunter1angle: TKnobsOutput;
    swansong_textlabel_angle: TKnobsTextLabel;
    swansong_hunter1stride: TKnobsOutput;
    swansong_textlabel_stride: TKnobsTextLabel;
    swansong_textlabel_clock: TKnobsTextLabel;
    swansong_swanx: TKnobsInput;
    swansong_textlabel_swan: TKnobsTextLabel;
    swansong_swany: TKnobsInput;
    swansong_textlabel_x: TKnobsTextLabel;
    swansong_textlabel_y: TKnobsTextLabel;
    swansong_hunter2clock: TKnobsInput;
    swansong_symbol_hunterclock2: TImage;
    swansong_textlabel_2: TKnobsTextLabel;
    swansong_hunter2angle: TKnobsOutput;
    swansong_hunter2stride: TKnobsOutput;
    swansong_hunter3clock: TKnobsInput;
    swansong_symbol_hunterclock3: TImage;
    swansong_textlabel_3: TKnobsTextLabel;
    swansong_hunter3angle: TKnobsOutput;
    swansong_hunter3stride: TKnobsOutput;
    swansong_hunter4clock: TKnobsInput;
    swansong_symbol_hunterclock4: TImage;
    swansong_textlabel_4: TKnobsTextLabel;
    swansong_hunter4angle: TKnobsOutput;
    swansong_hunter4stride: TKnobsOutput;
    swansong_hunterrule: TKnobsSelector;
    swansong_textlabel_hunterrule: TKnobsTextLabel;
    swansong_mazetype: TKnobsSelector;
    swansong_textlabel_mazetype: TKnobsTextLabel;
    swansong_hunter5clock: TKnobsInput;
    swansong_symbol_hunterclock5: TImage;
    swansong_textlabel_5: TKnobsTextLabel;
    swansong_hunter5angle: TKnobsOutput;
    swansong_hunter5stride: TKnobsOutput;
    swansong_hunter6clock: TKnobsInput;
    swansong_symbol_hunterclock6: TImage;
    swansong_textlabel_6: TKnobsTextLabel;
    swansong_hunter6angle: TKnobsOutput;
    swansong_hunter6stride: TKnobsOutput;
    swansong_intype: TKnobsSelector;
    swansong_outtype: TKnobsSelector;
    swan_mazegraph: TKnobsMazeGraphViewer;
    swansong_indicator_hunter1: TKnobsIndicator;
    swansong_indicator_hunter2: TKnobsIndicator;
    swansong_indicator_hunter3: TKnobsIndicator;
    swansong_indicator_hunter4: TKnobsIndicator;
    swansong_indicator_hunter5: TKnobsIndicator;
    swansong_indicator_hunter6: TKnobsIndicator;
    swansong_hunter1x: TKnobsOutput;
    swansong_textlabel_x2: TKnobsTextLabel;
    swansong_hunter1y: TKnobsOutput;
    swansong_textlabel_y2: TKnobsTextLabel;
    swansong_hunter2x: TKnobsOutput;
    swansong_hunter2y: TKnobsOutput;
    swansong_hunter3x: TKnobsOutput;
    swansong_hunter3y: TKnobsOutput;
    swansong_hunter4x: TKnobsOutput;
    swansong_hunter4y: TKnobsOutput;
    swansong_hunter5x: TKnobsOutput;
    swansong_hunter5y: TKnobsOutput;
    swansong_hunter6x: TKnobsOutput;
    swansong_hunter6y: TKnobsOutput;
    swansong_mazemod: TKnobsInput;
    swansong_textlabel_mazemod: TKnobsTextLabel;
    randomwalklfo_speed: TKnobsInput;
    randomwalklfo_textlabel_speed: TKnobsTextLabel;
    mixaudio_levmod11: TKnobsInput;
    mixaudio_levmod21: TKnobsInput;
    mixaudio_levmod12: TKnobsInput;
    mixaudio_levmod22: TKnobsInput;
    mixaudio_levmod13: TKnobsInput;
    mixaudio_levmod23: TKnobsInput;
    mixaudio_levmod14: TKnobsInput;
    mixaudio_levmod24: TKnobsInput;
    mixaudio_levmod15: TKnobsInput;
    mixaudio_levmod16: TKnobsInput;
    mixaudio_levmod17: TKnobsInput;
    mixaudio_levmod18: TKnobsInput;
    mixaudio_levmod28: TKnobsInput;
    mixaudio_levmod27: TKnobsInput;
    mixaudio_levmod26: TKnobsInput;
    mixaudio_levmod25: TKnobsInput;
    multisine_lmmod1: TKnobsInput;
    multisine_lmmod2: TKnobsInput;
    multisine_lmmod3: TKnobsInput;
    multisine_lmmod4: TKnobsInput;
    multisine_lmmod5: TKnobsInput;
    multisine_lmmod6: TKnobsInput;
    multisine_textlabel_lm6: TKnobsTextLabel;
    multisine_textlabel_lm5: TKnobsTextLabel;
    multisine_textlabel_lm4: TKnobsTextLabel;
    multisine_textlabel_lm3: TKnobsTextLabel;
    multisine_textlabel_lm2: TKnobsTextLabel;
    multisine_textlabel_lm1: TKnobsTextLabel;
    multisine_fmmod1: TKnobsInput;
    multisine_fmmod2: TKnobsInput;
    multisine_fmmod3: TKnobsInput;
    multisine_fmmod4: TKnobsInput;
    multisine_fmmod5: TKnobsInput;
    multisine_fmmod6: TKnobsInput;
    multisine_textlabel_fm6: TKnobsTextLabel;
    multisine_textlabel_fm5: TKnobsTextLabel;
    multisine_textlabel_fm4: TKnobsTextLabel;
    multisine_textlabel_fm3: TKnobsTextLabel;
    multisine_textlabel_fm2: TKnobsTextLabel;
    multisine_textlabel_fm1: TKnobsTextLabel;
    swansong_scaling: TKnobsSelector;
    textwriter_select: TKnobsInput;
    textwriter_textlabel_select: TKnobsTextLabel;
    textwriter_display_selected: TKnobsDisplay;
    seqrandom_scalemod: TKnobsInput;
    seqrandom_indicator_scale: TKnobsTextLabel;
    probsequencer_textlabel_scalesel: TKnobsTextLabel;
    probsequencer_scalemod: TKnobsInput;
    probsequencer_indicator_scale: TKnobsTextLabel;
    scalequantizer_textlabel_scalesel: TKnobsTextLabel;
    scalequantizer_scalemod: TKnobsInput;
    scalequantizer_indicator_scale: TKnobsTextLabel;
    delaymod: TKnobsModule;
    delaymod_editlabel: TKnobsEditLabel;
    delaymod_out: TKnobsOutput;
    delaymod_outfixed: TKnobsOutput;
    delaymod_in: TKnobsInput;
    delaymod_delaymod: TKnobsInput;
    delaymod_textlabel_in: TKnobsTextLabel;
    delaymod_textlabel_maxdelay: TKnobsTextLabel;
    delaymod_textlabel_fixed: TKnobsTextLabel;
    delaymod_length: TKnobsSmallKnob;
    delaymod_display_length: TKnobsDisplay;
    delaymod_range: TKnobsSelector;
    delaymod_delaymodamt: TKnobsSmallKnob;
    delaymod_delayoff: TKnobsSmallKnob;
    delaymod_textlabel_moddepth: TKnobsTextLabel;
    delaymod_textlabel_offset: TKnobsTextLabel;
    delaymod_textlabel_var: TKnobsTextLabel;
    pluck_delaymod: TKnobsInput;
    pluck_textlabel_delay: TKnobsTextLabel;
    pluck_delaymodamt: TKnobsSmallKnob;
    lfotrig_autoready: TKnobsSelector;
    squarelfotrig_autoready: TKnobsSelector;
    seqrandom_symbol_changeall: TImage;
    seqrandom_changeall: TKnobsInput;
    seqrandom_indicator_changeall: TKnobsIndicator;
    seqrandom_textlabel_changeall: TKnobsTextLabel;
    moogfilter_linfm: TKnobsInput;
    moogfilter_textlabel_lfm: TKnobsTextLabel;
    moogfilter_linfmamt: TKnobsSmallKnob;
    delaystereo: TKnobsModule;
    delaystereo_editlabel: TKnobsEditLabel;
    delaystereo_out2: TKnobsOutput;
    delaystereo_outfixed: TKnobsOutput;
    delaystereo_in: TKnobsInput;
    delaystereo_delay: TKnobsInput;
    delaystereo_textlabel_in: TKnobsTextLabel;
    delaystereo_textlabel_delay: TKnobsTextLabel;
    delaystereo_textlabel_maxdelay: TKnobsTextLabel;
    delaystereo_textlabel_fix: TKnobsTextLabel;
    delaystereo_length: TKnobsSmallKnob;
    delaystereo_display_length: TKnobsDisplay;
    delaystereo_range: TKnobsSelector;
    delaystereo_in2: TKnobsInput;
    delaystereo_out: TKnobsOutput;
    delaystereo_outfixed2: TKnobsOutput;
    delaystereo_textlabel_var: TKnobsTextLabel;
    quantizer_indicator_value: TKnobsTextLabel;
    modal2: TKnobsModule;
    modal2_editlabel: TKnobsEditLabel;
    modal2_in: TKnobsInput;
    modal2_out: TKnobsOutput;
    modal2_textlabel_in: TKnobsTextLabel;
    modal2_textlabel_out: TKnobsTextLabel;
    modal2_textlabel_lev: TKnobsTextLabel;
    modal2_fm: TKnobsInput;
    modal2_textlabel_fm: TKnobsTextLabel;
    modal2_textlabel_q: TKnobsTextLabel;
    modal2_textlabel_a: TKnobsTextLabel;
    modal2_textlabel_freq: TKnobsTextLabel;
    modal2_q1: TKnobsSmallKnob;
    modal2_q2: TKnobsSmallKnob;
    modal2_q3: TKnobsSmallKnob;
    modal2_q4: TKnobsSmallKnob;
    modal2_q5: TKnobsSmallKnob;
    modal2_q6: TKnobsSmallKnob;
    modal2_q7: TKnobsSmallKnob;
    modal2_q8: TKnobsSmallKnob;
    modal2_level1: TKnobsSmallKnob;
    modal2_level2: TKnobsSmallKnob;
    modal2_level3: TKnobsSmallKnob;
    modal2_level4: TKnobsSmallKnob;
    modal2_level5: TKnobsSmallKnob;
    modal2_level6: TKnobsSmallKnob;
    modal2_level7: TKnobsSmallKnob;
    modal2_level8: TKnobsSmallKnob;
    modal2_q9: TKnobsSmallKnob;
    modal2_q10: TKnobsSmallKnob;
    modal2_q11: TKnobsSmallKnob;
    modal2_level9: TKnobsSmallKnob;
    modal2_level10: TKnobsSmallKnob;
    modal2_level11: TKnobsSmallKnob;
    modal2_level: TKnobsSmallKnob;
    modal2_fmamt: TKnobsSmallKnob;
    modal2_freq: TKnobsSmallKnob;
    modal2_fi: TKnobsSelector;
    modal2_preset: TKnobsSelector;
    modal2_qm: TKnobsInput;
    modal2_textlabel_qm: TKnobsTextLabel;
    modal2_qmamt: TKnobsSmallKnob;
    modal2_q: TKnobsSmallKnob;
    modal2_textlabel_qmain: TKnobsTextLabel;
    modal2_textlabel_sel: TKnobsTextLabel;
    modal2_presetmod: TKnobsInput;
    modal2_indicator_preset: TKnobsTextLabel;
    modal2_lfm: TKnobsInput;
    modal2_textlabel_lfm: TKnobsTextLabel;
    modal2_lfmamt: TKnobsSmallKnob;
    modal2_indicator_count: TKnobsTextLabel;
    modal2_am: TKnobsInput;
    cubicclip_alphamod: TKnobsInput;
    cubicclip_hysteresismod: TKnobsInput;
    pad_r: TKnobsOutput;
    pad_textlabel_r: TKnobsTextLabel;
    pad_g: TKnobsOutput;
    pad_textlabel_g: TKnobsTextLabel;
    pad_b: TKnobsOutput;
    pad_textlabel_b: TKnobsTextLabel;
    pad_fileselector_filename: TKnobsFileSelector;
    swansong_textlabel_intype: TKnobsTextLabel;
    multigate: TKnobsModule;
    multigate_editlabel: TKnobsEditLabel;
    multigate_out1: TKnobsOutput;
    multigate_in11: TKnobsInput;
    multigate_in12: TKnobsInput;
    multigate_in31: TKnobsInput;
    multigate_in32: TKnobsInput;
    multigate_indicator_out1: TKnobsIndicator;
    multigate_func: TKnobsSelector;
    multigate_intype: TKnobsSelector;
    multigate_in21: TKnobsInput;
    multigate_in22: TKnobsInput;
    multigate_in41: TKnobsInput;
    multigate_in42: TKnobsInput;
    multigate_out2: TKnobsOutput;
    multigate_indicator_out2: TKnobsIndicator;
    multigate_out3: TKnobsOutput;
    multigate_indicator_out3: TKnobsIndicator;
    multigate_out4: TKnobsOutput;
    multigate_indicator_out4: TKnobsIndicator;
    multigate_outtype: TKnobsSelector;
    multiplemult_in71: TKnobsInput;
    multiplemult_in72: TKnobsInput;
    multiplemult_in81: TKnobsInput;
    multiplemult_in82: TKnobsInput;
    multiplemult_out8: TKnobsOutput;
    multiplemult_in51: TKnobsInput;
    multiplemult_in52: TKnobsInput;
    multiplemult_in61: TKnobsInput;
    multiplemult_in62: TKnobsInput;
    multiplemult_out5: TKnobsOutput;
    multiplemult_out6: TKnobsOutput;
    multiplemult_out7: TKnobsOutput;
    knobs4_in1: TKnobsInput;
    knobs4_in2: TKnobsInput;
    knobs4_in3: TKnobsInput;
    knobs4_in4: TKnobsInput;
    knobs4_mute1: TKnobsSelector;
    knobs4_mute2: TKnobsSelector;
    knobs4_mute3: TKnobsSelector;
    knobs4_mute4: TKnobsSelector;
    formant_levelmod: TKnobsInput;
    formant2_levelmod: TKnobsInput;
    cellaut_textlabel_sumcnt: TKnobsTextLabel;
    cellaut_display_sumcnt: TKnobsDisplay;
    cellaut_sumcnt: TKnobsNoKnob;
    cellaut2: TKnobsModule;
    cellaut2_editlabel: TKnobsEditLabel;
    cellaut2_symbol_step: TImage;
    cellaut2_step: TKnobsInput;
    cellaut2_indicator_step: TKnobsIndicator;
    cellaut2_textlabel_step: TKnobsTextLabel;
    cellaut2_textlabel_rulenr: TKnobsTextLabel;
    cellaut2_symbol_back: TImage;
    cellaut2_indicator_cstep: TKnobsIndicatorText;
    cellaut2_symbol_reset: TImage;
    cellaut2_reset: TKnobsInput;
    cellaut2_indicator_reset: TKnobsIndicator;
    cellaut2_textlabel_reset: TKnobsTextLabel;
    cellaut2_textlabel_faults: TKnobsTextLabel;
    cellaut2_display_rule: TKnobsDisplay;
    cellaut2_rule: TKnobsNoKnob;
    cellaut2_display_faults: TKnobsDisplay;
    cellaut2_faults: TKnobsNoKnob;
    cellaut2_out1: TKnobsOutput;
    cellaut2_indicator_out1: TKnobsIndicator;
    cellaut2_out2: TKnobsOutput;
    cellaut2_indicator_out2: TKnobsIndicator;
    cellaut2_out3: TKnobsOutput;
    cellaut2_indicator_out3: TKnobsIndicator;
    cellaut2_out4: TKnobsOutput;
    cellaut2_indicator_out4: TKnobsIndicator;
    cellaut2_out5: TKnobsOutput;
    cellaut2_indicator_out5: TKnobsIndicator;
    cellaut2_out6: TKnobsOutput;
    cellaut2_indicator_out6: TKnobsIndicator;
    cellaut2_out7: TKnobsOutput;
    cellaut2_indicator_out7: TKnobsIndicator;
    cellaut2_out8: TKnobsOutput;
    cellaut2_indicator_out8: TKnobsIndicator;
    cellaut2_out9: TKnobsOutput;
    cellaut2_indicator_out9: TKnobsIndicator;
    cellaut2_out10: TKnobsOutput;
    cellaut2_indicator_out10: TKnobsIndicator;
    cellaut2_out11: TKnobsOutput;
    cellaut2_indicator_out11: TKnobsIndicator;
    cellaut2_out12: TKnobsOutput;
    cellaut2_indicator_out12: TKnobsIndicator;
    cellaut2_out13: TKnobsOutput;
    cellaut2_indicator_out13: TKnobsIndicator;
    cellaut2_out14: TKnobsOutput;
    cellaut2_indicator_out14: TKnobsIndicator;
    cellaut2_out15: TKnobsOutput;
    cellaut2_indicator_out15: TKnobsIndicator;
    cellaut2_label_slash: TLabel;
    cellaut2_indicator_steps: TKnobsIndicatorText;
    cellaut2_textlabel_steps: TKnobsTextLabel;
    cellaut2_display_steps: TKnobsDisplay;
    cellaut2_steps: TKnobsNoKnob;
    cellaut2_rulemod: TKnobsInput;
    cellaut2_faultsmod: TKnobsInput;
    cellaut2_mode: TKnobsSelector;
    randsigs: TKnobsModule;
    randsigs_editlabel: TKnobsEditLabel;
    randsigs_out1: TKnobsOutput;
    randsigs_fm: TKnobsInput;
    randsigs_indicator_active1: TKnobsIndicator;
    randsigs_textlabel_fm: TKnobsTextLabel;
    randsigs_distmod: TKnobsInput;
    randsigs_textlabel_dist: TKnobsTextLabel;
    randsigs_textlabel_lambda: TKnobsTextLabel;
    randsigs_freq: TKnobsInput;
    randsigs_speed: TKnobsInput;
    randsigs_textlabel_spd: TKnobsTextLabel;
    randsigs_frequency: TKnobsSmallKnob;
    randsigs_display_frequency: TKnobsDisplay;
    randsigs_mute: TKnobsSelector;
    randsigs_range: TKnobsSelector;
    randsigs_fmlevel: TKnobsSmallKnob;
    randsigs_outputtype: TKnobsSelector;
    randsigs_dist: TKnobsSmallKnob;
    randsigs_distmodamt: TKnobsSmallKnob;
    randsigs_lambda: TKnobsSmallKnob;
    randsigs_mode: TKnobsSelector;
    randsigs_distfbmod: TKnobsInput;
    randsigs_textlabel_distfb: TKnobsTextLabel;
    randsigs_distfb: TKnobsSmallKnob;
    randsigs_distfbmodamt: TKnobsSmallKnob;
    randsigs_fmfbmod: TKnobsInput;
    randsigs_textlabel_fmfb: TKnobsTextLabel;
    randsigs_fmfb: TKnobsSmallKnob;
    randsigs_fmfbmodamt: TKnobsSmallKnob;
    randsigs_out2: TKnobsOutput;
    randsigs_out3: TKnobsOutput;
    randsigs_out4: TKnobsOutput;
    randsigs_out5: TKnobsOutput;
    randsigs_out6: TKnobsOutput;
    randsigs_out7: TKnobsOutput;
    randsigs_out8: TKnobsOutput;
    randsigs_indicator_active2: TKnobsIndicator;
    randsigs_indicator_active3: TKnobsIndicator;
    randsigs_indicator_active4: TKnobsIndicator;
    randsigs_indicator_active5: TKnobsIndicator;
    randsigs_indicator_active6: TKnobsIndicator;
    randsigs_indicator_active7: TKnobsIndicator;
    randsigs_indicator_active8: TKnobsIndicator;
    seq32: TKnobsModule;
    seq32_editlabel: TKnobsEditLabel;
    seq32_trigout1: TKnobsOutput;
    seq32_res: TKnobsInput;
    seq32_indicator_res: TKnobsIndicator;
    seq32_textlabel_res: TKnobsTextLabel;
    seq32_active: TKnobsInput;
    seq32_indicator_act: TKnobsIndicator;
    seq32_textlabel_act: TKnobsTextLabel;
    seq32_clk1: TKnobsInput;
    seq32_indicator_clk1: TKnobsIndicator;
    seq32_textlabel_clk: TKnobsTextLabel;
    seq32_symbol_clk1: TImage;
    seq32_symbol_res: TImage;
    seq32_octave11: TKnobsSelector;
    seq32_note11: TKnobsSelector;
    seq32_octave12: TKnobsSelector;
    seq32_note12: TKnobsSelector;
    seq32_octave13: TKnobsSelector;
    seq32_note13: TKnobsSelector;
    seq32_octave14: TKnobsSelector;
    seq32_note14: TKnobsSelector;
    seq32_octave15: TKnobsSelector;
    seq32_note15: TKnobsSelector;
    seq32_octave16: TKnobsSelector;
    seq32_note16: TKnobsSelector;
    seq32_octave17: TKnobsSelector;
    seq32_note17: TKnobsSelector;
    seq32_octave18: TKnobsSelector;
    seq32_note18: TKnobsSelector;
    seq32_textlabel_nod1: TKnobsTextLabel;
    seq32_octave19: TKnobsSelector;
    seq32_note19: TKnobsSelector;
    seq32_octave110: TKnobsSelector;
    seq32_note110: TKnobsSelector;
    seq32_octave111: TKnobsSelector;
    seq32_note111: TKnobsSelector;
    seq32_octave112: TKnobsSelector;
    seq32_note112: TKnobsSelector;
    seq32_octave113: TKnobsSelector;
    seq32_note113: TKnobsSelector;
    seq32_octave114: TKnobsSelector;
    seq32_note114: TKnobsSelector;
    seq32_octave115: TKnobsSelector;
    seq32_note115: TKnobsSelector;
    seq32_octave116: TKnobsSelector;
    seq32_note116: TKnobsSelector;
    seq32_octave117: TKnobsSelector;
    seq32_note117: TKnobsSelector;
    seq32_octave118: TKnobsSelector;
    seq32_note118: TKnobsSelector;
    seq32_octave119: TKnobsSelector;
    seq32_note119: TKnobsSelector;
    seq32_octave120: TKnobsSelector;
    seq32_note120: TKnobsSelector;
    seq32_octave121: TKnobsSelector;
    seq32_note121: TKnobsSelector;
    seq32_octave122: TKnobsSelector;
    seq32_note122: TKnobsSelector;
    seq32_octave123: TKnobsSelector;
    seq32_note123: TKnobsSelector;
    seq32_octave124: TKnobsSelector;
    seq32_note124: TKnobsSelector;
    seq32_octave125: TKnobsSelector;
    seq32_note125: TKnobsSelector;
    seq32_octave126: TKnobsSelector;
    seq32_note126: TKnobsSelector;
    seq32_octave127: TKnobsSelector;
    seq32_note127: TKnobsSelector;
    seq32_octave128: TKnobsSelector;
    seq32_note128: TKnobsSelector;
    seq32_octave129: TKnobsSelector;
    seq32_note129: TKnobsSelector;
    seq32_octave130: TKnobsSelector;
    seq32_note130: TKnobsSelector;
    seq32_octave131: TKnobsSelector;
    seq32_note131: TKnobsSelector;
    seq32_octave132: TKnobsSelector;
    seq32_note132: TKnobsSelector;
    seq32_duration11: TKnobsSelector;
    seq32_duration12: TKnobsSelector;
    seq32_duration13: TKnobsSelector;
    seq32_duration14: TKnobsSelector;
    seq32_duration15: TKnobsSelector;
    seq32_duration16: TKnobsSelector;
    seq32_duration17: TKnobsSelector;
    seq32_duration18: TKnobsSelector;
    seq32_duration19: TKnobsSelector;
    seq32_duration110: TKnobsSelector;
    seq32_duration111: TKnobsSelector;
    seq32_duration112: TKnobsSelector;
    seq32_duration113: TKnobsSelector;
    seq32_duration114: TKnobsSelector;
    seq32_duration115: TKnobsSelector;
    seq32_duration116: TKnobsSelector;
    seq32_duration117: TKnobsSelector;
    seq32_duration118: TKnobsSelector;
    seq32_duration119: TKnobsSelector;
    seq32_duration120: TKnobsSelector;
    seq32_duration121: TKnobsSelector;
    seq32_duration122: TKnobsSelector;
    seq32_duration123: TKnobsSelector;
    seq32_duration124: TKnobsSelector;
    seq32_duration125: TKnobsSelector;
    seq32_duration126: TKnobsSelector;
    seq32_duration127: TKnobsSelector;
    seq32_duration128: TKnobsSelector;
    seq32_duration129: TKnobsSelector;
    seq32_duration130: TKnobsSelector;
    seq32_duration131: TKnobsSelector;
    seq32_duration132: TKnobsSelector;
    seq32_octave21: TKnobsSelector;
    seq32_note21: TKnobsSelector;
    seq32_octave22: TKnobsSelector;
    seq32_note22: TKnobsSelector;
    seq32_octave23: TKnobsSelector;
    seq32_note23: TKnobsSelector;
    seq32_octave24: TKnobsSelector;
    seq32_note24: TKnobsSelector;
    seq32_octave25: TKnobsSelector;
    seq32_note25: TKnobsSelector;
    seq32_octave26: TKnobsSelector;
    seq32_note26: TKnobsSelector;
    seq32_octave27: TKnobsSelector;
    seq32_note27: TKnobsSelector;
    seq32_octave28: TKnobsSelector;
    seq32_note28: TKnobsSelector;
    seq32_octave29: TKnobsSelector;
    seq32_note29: TKnobsSelector;
    seq32_octave210: TKnobsSelector;
    seq32_note210: TKnobsSelector;
    seq32_octave211: TKnobsSelector;
    seq32_note211: TKnobsSelector;
    seq32_octave212: TKnobsSelector;
    seq32_note212: TKnobsSelector;
    seq32_octave213: TKnobsSelector;
    seq32_note213: TKnobsSelector;
    seq32_octave214: TKnobsSelector;
    seq32_note214: TKnobsSelector;
    seq32_octave215: TKnobsSelector;
    seq32_note215: TKnobsSelector;
    seq32_octave216: TKnobsSelector;
    seq32_note216: TKnobsSelector;
    seq32_octave217: TKnobsSelector;
    seq32_note217: TKnobsSelector;
    seq32_octave218: TKnobsSelector;
    seq32_note218: TKnobsSelector;
    seq32_octave219: TKnobsSelector;
    seq32_note219: TKnobsSelector;
    seq32_octave220: TKnobsSelector;
    seq32_note220: TKnobsSelector;
    seq32_octave221: TKnobsSelector;
    seq32_note221: TKnobsSelector;
    seq32_octave222: TKnobsSelector;
    seq32_note222: TKnobsSelector;
    seq32_octave223: TKnobsSelector;
    seq32_note223: TKnobsSelector;
    seq32_octave224: TKnobsSelector;
    seq32_note224: TKnobsSelector;
    seq32_octave225: TKnobsSelector;
    seq32_note225: TKnobsSelector;
    seq32_octave226: TKnobsSelector;
    seq32_note226: TKnobsSelector;
    seq32_octave227: TKnobsSelector;
    seq32_note227: TKnobsSelector;
    seq32_octave228: TKnobsSelector;
    seq32_note228: TKnobsSelector;
    seq32_octave229: TKnobsSelector;
    seq32_note229: TKnobsSelector;
    seq32_octave230: TKnobsSelector;
    seq32_note230: TKnobsSelector;
    seq32_octave231: TKnobsSelector;
    seq32_note231: TKnobsSelector;
    seq32_octave232: TKnobsSelector;
    seq32_note232: TKnobsSelector;
    seq32_duration21: TKnobsSelector;
    seq32_duration22: TKnobsSelector;
    seq32_duration23: TKnobsSelector;
    seq32_duration24: TKnobsSelector;
    seq32_duration25: TKnobsSelector;
    seq32_duration26: TKnobsSelector;
    seq32_duration27: TKnobsSelector;
    seq32_duration28: TKnobsSelector;
    seq32_duration29: TKnobsSelector;
    seq32_duration210: TKnobsSelector;
    seq32_duration211: TKnobsSelector;
    seq32_duration212: TKnobsSelector;
    seq32_duration213: TKnobsSelector;
    seq32_duration214: TKnobsSelector;
    seq32_duration215: TKnobsSelector;
    seq32_duration216: TKnobsSelector;
    seq32_duration217: TKnobsSelector;
    seq32_duration218: TKnobsSelector;
    seq32_duration219: TKnobsSelector;
    seq32_duration220: TKnobsSelector;
    seq32_duration221: TKnobsSelector;
    seq32_duration222: TKnobsSelector;
    seq32_duration223: TKnobsSelector;
    seq32_duration224: TKnobsSelector;
    seq32_duration225: TKnobsSelector;
    seq32_duration226: TKnobsSelector;
    seq32_duration227: TKnobsSelector;
    seq32_duration228: TKnobsSelector;
    seq32_duration229: TKnobsSelector;
    seq32_duration230: TKnobsSelector;
    seq32_duration231: TKnobsSelector;
    seq32_duration232: TKnobsSelector;
    seq32_octave31: TKnobsSelector;
    seq32_note31: TKnobsSelector;
    seq32_octave32: TKnobsSelector;
    seq32_note32: TKnobsSelector;
    seq32_octave33: TKnobsSelector;
    seq32_note33: TKnobsSelector;
    seq32_octave34: TKnobsSelector;
    seq32_note34: TKnobsSelector;
    seq32_octave35: TKnobsSelector;
    seq32_note35: TKnobsSelector;
    seq32_octave36: TKnobsSelector;
    seq32_note36: TKnobsSelector;
    seq32_octave37: TKnobsSelector;
    seq32_note37: TKnobsSelector;
    seq32_octave38: TKnobsSelector;
    seq32_note38: TKnobsSelector;
    seq32_octave39: TKnobsSelector;
    seq32_note39: TKnobsSelector;
    seq32_octave310: TKnobsSelector;
    seq32_note310: TKnobsSelector;
    seq32_octave311: TKnobsSelector;
    seq32_note311: TKnobsSelector;
    seq32_octave312: TKnobsSelector;
    seq32_note312: TKnobsSelector;
    seq32_octave313: TKnobsSelector;
    seq32_note313: TKnobsSelector;
    seq32_octave314: TKnobsSelector;
    seq32_note314: TKnobsSelector;
    seq32_octave315: TKnobsSelector;
    seq32_note315: TKnobsSelector;
    seq32_octave316: TKnobsSelector;
    seq32_note316: TKnobsSelector;
    seq32_octave317: TKnobsSelector;
    seq32_note317: TKnobsSelector;
    seq32_octave318: TKnobsSelector;
    seq32_note318: TKnobsSelector;
    seq32_octave319: TKnobsSelector;
    seq32_note319: TKnobsSelector;
    seq32_octave320: TKnobsSelector;
    seq32_note320: TKnobsSelector;
    seq32_octave321: TKnobsSelector;
    seq32_note321: TKnobsSelector;
    seq32_octave322: TKnobsSelector;
    seq32_note322: TKnobsSelector;
    seq32_octave323: TKnobsSelector;
    seq32_note323: TKnobsSelector;
    seq32_octave324: TKnobsSelector;
    seq32_note324: TKnobsSelector;
    seq32_octave325: TKnobsSelector;
    seq32_note325: TKnobsSelector;
    seq32_octave326: TKnobsSelector;
    seq32_note326: TKnobsSelector;
    seq32_octave327: TKnobsSelector;
    seq32_note327: TKnobsSelector;
    seq32_octave328: TKnobsSelector;
    seq32_note328: TKnobsSelector;
    seq32_octave329: TKnobsSelector;
    seq32_note329: TKnobsSelector;
    seq32_octave330: TKnobsSelector;
    seq32_note330: TKnobsSelector;
    seq32_octave331: TKnobsSelector;
    seq32_note331: TKnobsSelector;
    seq32_octave332: TKnobsSelector;
    seq32_note332: TKnobsSelector;
    seq32_duration31: TKnobsSelector;
    seq32_duration32: TKnobsSelector;
    seq32_duration33: TKnobsSelector;
    seq32_duration34: TKnobsSelector;
    seq32_duration35: TKnobsSelector;
    seq32_duration36: TKnobsSelector;
    seq32_duration37: TKnobsSelector;
    seq32_duration38: TKnobsSelector;
    seq32_duration39: TKnobsSelector;
    seq32_duration310: TKnobsSelector;
    seq32_duration311: TKnobsSelector;
    seq32_duration312: TKnobsSelector;
    seq32_duration313: TKnobsSelector;
    seq32_duration314: TKnobsSelector;
    seq32_duration315: TKnobsSelector;
    seq32_duration316: TKnobsSelector;
    seq32_duration317: TKnobsSelector;
    seq32_duration318: TKnobsSelector;
    seq32_duration319: TKnobsSelector;
    seq32_duration320: TKnobsSelector;
    seq32_duration321: TKnobsSelector;
    seq32_duration322: TKnobsSelector;
    seq32_duration323: TKnobsSelector;
    seq32_duration324: TKnobsSelector;
    seq32_duration325: TKnobsSelector;
    seq32_duration326: TKnobsSelector;
    seq32_duration327: TKnobsSelector;
    seq32_duration328: TKnobsSelector;
    seq32_duration329: TKnobsSelector;
    seq32_duration330: TKnobsSelector;
    seq32_duration331: TKnobsSelector;
    seq32_duration332: TKnobsSelector;
    seq32_textlabel_nod2: TKnobsTextLabel;
    seq32_textlabel_nod3: TKnobsTextLabel;
    seq32_trigout2: TKnobsOutput;
    seq32_trigout3: TKnobsOutput;
    seq32_out1: TKnobsOutput;
    seq32_out2: TKnobsOutput;
    seq32_out3: TKnobsOutput;
    seq32_playmode: TKnobsSelector;
    ImageListDotsYellow: TImageList;
    seq32_lights1: TKnobsGridControl;
    seq32_lights2: TKnobsGridControl;
    seq32_lights3: TKnobsGridControl;
    seq32_lights4: TKnobsGridControl;
    seq32_div161: TKnobsOutput;
    seq32_textlabel_div16: TKnobsTextLabel;
    seq32_indicator_div161: TKnobsIndicator;
    seq32_indicator_trig1: TKnobsIndicator;
    seq32_indicator_trig2: TKnobsIndicator;
    seq32_indicator_trig3: TKnobsIndicator;
    seq32_linkmode: TKnobsSelector;
    seq32_gatemode: TKnobsSelector;
    seq32_playmodemod: TKnobsInput;
    seq32_linkmodemod: TKnobsInput;
    seq32_gatemodemod: TKnobsInput;
    seq32_reverse: TKnobsInput;
    seq32_indicator_reverse: TKnobsIndicator;
    seq32_textlabel_dir: TKnobsTextLabel;
    seq32_inverse: TKnobsInput;
    seq32_indicator_inverse: TKnobsIndicator;
    seq32_textlabel_inv: TKnobsTextLabel;
    seq32_clk2: TKnobsInput;
    seq32_indicator_clk2: TKnobsIndicator;
    seq32_div162: TKnobsOutput;
    seq32_indicator_div162: TKnobsIndicator;
    seq32_clk3: TKnobsInput;
    seq32_indicator_clk3: TKnobsIndicator;
    seq32_div163: TKnobsOutput;
    seq32_indicator_div163: TKnobsIndicator;
    seq32_textlabel_clko: TKnobsTextLabel;
    seq32_textlabel_out: TKnobsTextLabel;
    seq32_symbol_clk2: TImage;
    seq32_symbol_clk3: TImage;
    vanderpollfo: TKnobsModule;
    vanderpollfo_editlabel: TKnobsEditLabel;
    vanderpollfo_fm: TKnobsInput;
    vanderpollfo_textlabel_fm: TKnobsTextLabel;
    vanderpollfo_outx: TKnobsOutput;
    vanderpollfo_indicator_outx: TKnobsIndicator;
    vanderpollfo_outy: TKnobsOutput;
    vanderpollfo_indicator_outy: TKnobsIndicator;
    vanderpollfo_textlabel_x: TKnobsTextLabel;
    vanderpollfo_textlabel_y: TKnobsTextLabel;
    vanderpollfo_frequency: TKnobsSmallKnob;
    vanderpollfo_display_frequency: TKnobsDisplay;
    vanderpollfo_mute: TKnobsSelector;
    vanderpollfo_range: TKnobsSelector;
    vanderpollfo_fmlevel: TKnobsSmallKnob;
    vanderpollfo_outputtype: TKnobsSelector;
    vanderpollfo_mumod: TKnobsInput;
    vanderpollfo_textlabel_mu: TKnobsTextLabel;
    vanderpollfo_mu: TKnobsSmallKnob;
    vanderpollfo_mumodamt: TKnobsSmallKnob;
    vanderpollfo_in: TKnobsInput;
    vanderpollfo_textlabel_in: TKnobsTextLabel;
    vanderpollfo_inamt: TKnobsSmallKnob;
    vanderpol: TKnobsModule;
    vanderpol_editlabel: TKnobsEditLabel;
    vanderpol_fm: TKnobsInput;
    vanderpol_textlabel_fm: TKnobsTextLabel;
    vanderpol_textlabel_freq: TKnobsTextLabel;
    vanderpol_freq: TKnobsInput;
    vanderpol_outx: TKnobsOutput;
    vanderpol_outy: TKnobsOutput;
    vanderpol_textlabel_x: TKnobsTextLabel;
    vanderpol_textlabel_y: TKnobsTextLabel;
    vanderpol_frequency: TKnobsSmallKnob;
    vanderpol_display_frequency: TKnobsDisplay;
    vanderpol_mute: TKnobsSelector;
    vanderpol_fmlevel: TKnobsSmallKnob;
    vanderpol_mumod: TKnobsInput;
    vanderpol_textlabel_mu: TKnobsTextLabel;
    vanderpol_mu: TKnobsSmallKnob;
    vanderpol_mumodamt: TKnobsSmallKnob;
    vanderpol_in: TKnobsInput;
    vanderpol_textlabel_in: TKnobsTextLabel;
    vanderpol_inamt: TKnobsSmallKnob;
    attractorlfo_drive: TKnobsInput;
    attractorlfo_textlabel_in: TKnobsTextLabel;
    attractorlfo_driveamt: TKnobsSmallKnob;
    attractor_drive: TKnobsInput;
    attractor_textlabel_in: TKnobsTextLabel;
    attractor_driveamt: TKnobsSmallKnob;
    midisysexout: TKnobsModule;
    midisysexout_editlabel: TKnobsEditLabel;
    midisysexout_1: TKnobsInput;
    midisysexout_display_message: TKnobsDisplay;
    midisysexout_indicator_gate: TKnobsIndicator;
    midisysexout_textlabel_gate: TKnobsTextLabel;
    midisysexout_gate: TKnobsInput;
    midisysexout_2: TKnobsInput;
    midisysexout_3: TKnobsInput;
    midisysexout_4: TKnobsInput;
    midisysexout_5: TKnobsInput;
    midisysexout_6: TKnobsInput;
    midisysexout_7: TKnobsInput;
    midisysexout_8: TKnobsInput;
    midisysexout_textlabel_notworkingyet: TKnobsTextLabel;
    leakygateseq: TKnobsModule;
    leakygateseq_editlabel: TKnobsEditLabel;
    leakygateseq_out: TKnobsOutput;
    leakygateseq_indicator_out: TKnobsIndicator;
    leakygateseq_textlabel_out: TKnobsTextLabel;
    leakygateseq_symbol_trig: TImage;
    leakygateseq_trig: TKnobsInput;
    leakygateseq_indicator_trig: TKnobsIndicator;
    leakygateseq_textlabel_trig: TKnobsTextLabel;
    leakygateseq_textlabel_steps: TKnobsTextLabel;
    leakygateseq_chain: TKnobsInput;
    leakygateseq_textlabel_chain: TKnobsTextLabel;
    leakygateseq_symbol_reset: TImage;
    leakygateseq_res: TKnobsInput;
    leakygateseq_indicator_reset: TKnobsIndicator;
    leakygateseq_textlabel_res: TKnobsTextLabel;
    leakygateseq_active: TKnobsInput;
    leakygateseq_indicator_active: TKnobsIndicator;
    leakygateseq_textlabel_act: TKnobsTextLabel;
    leakygateseq_indicator_step1: TKnobsIndicator;
    leakygateseq_indicator_step2: TKnobsIndicator;
    leakygateseq_indicator_step3: TKnobsIndicator;
    leakygateseq_indicator_step4: TKnobsIndicator;
    leakygateseq_indicator_step5: TKnobsIndicator;
    leakygateseq_indicator_step6: TKnobsIndicator;
    leakygateseq_indicator_step7: TKnobsIndicator;
    leakygateseq_indicator_step8: TKnobsIndicator;
    leakygateseq_indicator_step9: TKnobsIndicator;
    leakygateseq_indicator_step10: TKnobsIndicator;
    leakygateseq_indicator_step11: TKnobsIndicator;
    leakygateseq_indicator_step12: TKnobsIndicator;
    leakygateseq_indicator_step13: TKnobsIndicator;
    leakygateseq_indicator_step14: TKnobsIndicator;
    leakygateseq_indicator_step15: TKnobsIndicator;
    leakygateseq_indicator_step16: TKnobsIndicator;
    leakygateseq_dir: TKnobsInput;
    leakygateseq_indicator_dir: TKnobsIndicator;
    leakygateseq_textlabel_dir: TKnobsTextLabel;
    leakygateseq_outdir: TKnobsOutput;
    leakygateseq_outres: TKnobsOutput;
    leakygateseq_outtrig: TKnobsOutput;
    leakygateseq_step1: TKnobsSelector;
    leakygateseq_step2: TKnobsSelector;
    leakygateseq_step3: TKnobsSelector;
    leakygateseq_step4: TKnobsSelector;
    leakygateseq_step5: TKnobsSelector;
    leakygateseq_step6: TKnobsSelector;
    leakygateseq_step7: TKnobsSelector;
    leakygateseq_step8: TKnobsSelector;
    leakygateseq_step9: TKnobsSelector;
    leakygateseq_step10: TKnobsSelector;
    leakygateseq_step11: TKnobsSelector;
    leakygateseq_step12: TKnobsSelector;
    leakygateseq_step13: TKnobsSelector;
    leakygateseq_step14: TKnobsSelector;
    leakygateseq_step15: TKnobsSelector;
    leakygateseq_step16: TKnobsSelector;
    leakygateseq_steps: TKnobsNoKnob;
    leakygateseq_display_steps: TKnobsDisplay;
    leakygateseq_rnd: TKnobsSelector;
    leakygateseq_clr: TKnobsSelector;
    leakygateseq_leak: TKnobsSmallKnob;
    leakygateseq_textlabel_leak: TKnobsTextLabel;
    leakygateseq_leakmod: TKnobsInput;
    leakygateseq_rnd2: TKnobsInput;
    leakygateseq_textlabel_distribution: TKnobsTextLabel;
    leakygateseq_distmod: TKnobsInput;
    leakygateseq_dist: TKnobsSmallKnob;
    leakygateseq_symbol_rnd: TImage;
    leakygateseq_symbol_set: TImage;
    leakygateseq_set: TKnobsInput;
    leakygateseq_indicator_set: TKnobsIndicator;
    leakygateseq_textlabel_resres: TKnobsTextLabel;
    leakygateseq_outset: TKnobsOutput;
    sequencer2_tabsheet: TTabSheet;
    sequencer: TKnobsModule;
    sequencer_symbol_trig: TImage;
    sequencer_out: TKnobsOutput;
    sequencer_dir: TKnobsInput;
    sequencer_trig: TKnobsInput;
    sequencer_reset: TKnobsInput;
    sequencer_editlabel: TKnobsEditLabel;
    sequencer_indicator_step1: TKnobsIndicator;
    sequencer_indicator_step2: TKnobsIndicator;
    sequencer_indicator_step3: TKnobsIndicator;
    sequencer_indicator_step4: TKnobsIndicator;
    sequencer_indicator_step5: TKnobsIndicator;
    sequencer_indicator_step6: TKnobsIndicator;
    sequencer_indicator_step7: TKnobsIndicator;
    sequencer_indicator_step8: TKnobsIndicator;
    sequencer_indicator_step9: TKnobsIndicator;
    sequencer_indicator_step10: TKnobsIndicator;
    sequencer_indicator_step11: TKnobsIndicator;
    sequencer_indicator_trig: TKnobsIndicator;
    sequencer_indicator_dir: TKnobsIndicator;
    sequencer_indicator_reset: TKnobsIndicator;
    sequencer_textlabel_steps: TKnobsTextLabel;
    sequencer_textlabel_trig: TKnobsTextLabel;
    sequencer_textlabel_dir: TKnobsTextLabel;
    sequencer_textlabel_step1: TKnobsTextLabel;
    sequencer_textlabel_step2: TKnobsTextLabel;
    sequencer_textlabel_step3: TKnobsTextLabel;
    sequencer_textlabel_step4: TKnobsTextLabel;
    sequencer_textlabel_step5: TKnobsTextLabel;
    sequencer_textlabel_step6: TKnobsTextLabel;
    sequencer_textlabel_step7: TKnobsTextLabel;
    sequencer_textlabel_step8: TKnobsTextLabel;
    sequencer_textlabel_step9: TKnobsTextLabel;
    sequencer_textlabel_step10: TKnobsTextLabel;
    sequencer_textlabel_step11: TKnobsTextLabel;
    sequencer_textlabel_reset: TKnobsTextLabel;
    sequencer_trig1: TKnobsOutput;
    sequencer_trig2: TKnobsOutput;
    sequencer_trig3: TKnobsOutput;
    sequencer_trig4: TKnobsOutput;
    sequencer_trig5: TKnobsOutput;
    sequencer_trig6: TKnobsOutput;
    sequencer_trig7: TKnobsOutput;
    sequencer_trig8: TKnobsOutput;
    sequencer_trig9: TKnobsOutput;
    sequencer_trig10: TKnobsOutput;
    sequencer_trig11: TKnobsOutput;
    sequencer_chain: TKnobsInput;
    sequencer_active: TKnobsInput;
    sequencer_indicator_active: TKnobsIndicator;
    sequencer_textlabel_reset_active: TKnobsTextLabel;
    sequencer_textlabel_out: TKnobsTextLabel;
    sequencer_textlabel_chain: TKnobsTextLabel;
    sequencer_symbol_reset: TImage;
    sequencer_inv: TKnobsInput;
    sequencer_indicator_inv: TKnobsIndicator;
    sequencer_textlabel_inv: TKnobsTextLabel;
    sequencer_display_steps: TKnobsDisplay;
    sequencer_display_step1: TKnobsDisplay;
    sequencer_display_step2: TKnobsDisplay;
    sequencer_display_step3: TKnobsDisplay;
    sequencer_display_step4: TKnobsDisplay;
    sequencer_display_step5: TKnobsDisplay;
    sequencer_display_step6: TKnobsDisplay;
    sequencer_display_step7: TKnobsDisplay;
    sequencer_display_step8: TKnobsDisplay;
    sequencer_display_step9: TKnobsDisplay;
    sequencer_display_step10: TKnobsDisplay;
    sequencer_display_step11: TKnobsDisplay;
    sequencer_steps: TKnobsNoKnob;
    sequencer_step1: TKnobsNoKnob;
    sequencer_step2: TKnobsNoKnob;
    sequencer_step3: TKnobsNoKnob;
    sequencer_step4: TKnobsNoKnob;
    sequencer_step5: TKnobsNoKnob;
    sequencer_step6: TKnobsNoKnob;
    sequencer_step7: TKnobsNoKnob;
    sequencer_step8: TKnobsNoKnob;
    sequencer_step9: TKnobsNoKnob;
    sequencer_step10: TKnobsNoKnob;
    sequencer_step11: TKnobsNoKnob;
    sequencer_rnd: TKnobsSelector;
    sequencer_clr: TKnobsSelector;
    textsequencer: TKnobsModule;
    textsequencer_symbol_back: TImage;
    textsequencer_editlabel: TKnobsEditLabel;
    textsequencer_symbol_trig: TImage;
    textsequencer_label_slash: TLabel;
    textsequencer_out: TKnobsOutput;
    textsequencer_dir: TKnobsInput;
    textsequencer_trig: TKnobsInput;
    textsequencer_reset: TKnobsInput;
    textsequencer_indicator_trig: TKnobsIndicator;
    textsequencer_indicator_dir: TKnobsIndicator;
    textsequencer_indicator_reset: TKnobsIndicator;
    textsequencer_textlabel_trig: TKnobsTextLabel;
    textsequencer_textlabel_dir: TKnobsTextLabel;
    textsequencer_textlabel_reset: TKnobsTextLabel;
    textsequencer_indicator_step: TKnobsIndicatorText;
    textsequencer_indicator_steps: TKnobsIndicatorText;
    textsequencer_chain: TKnobsInput;
    textsequencer_gateout: TKnobsOutput;
    textsequencer_textlabel_gate: TKnobsTextLabel;
    textsequencer_indicator_gate: TKnobsIndicator;
    textsequencer_values: TKnobsDisplay;
    textsequencer_mode: TKnobsSelector;
    seqstep: TKnobsModule;
    seqstep_editlabel: TKnobsEditLabel;
    seqstep_symbol_trigfwd: TImage;
    seqstep_symbol_sigflow: TImage;
    seqstep_symbol_trigbwd: TImage;
    seqstep_out: TKnobsOutput;
    seqstep_trigoutfwd: TKnobsOutput;
    seqstep_trigoutbwd: TKnobsOutput;
    seqstep_dir: TKnobsInput;
    seqstep_triginfwd: TKnobsInput;
    seqstep_reset: TKnobsInput;
    seqstep_chain: TKnobsInput;
    seqstep_triginbwd: TKnobsInput;
    seqstep_indicator_trigbwd: TKnobsIndicator;
    seqstep_indicator_dir: TKnobsIndicator;
    seqstep_indicator_reset: TKnobsIndicator;
    seqstep_indicator_active: TKnobsIndicator;
    seqstep_indicator_trigfwd: TKnobsIndicator;
    seqstep_textlabel_trig: TKnobsTextLabel;
    seqstep_textlabel_dir: TKnobsTextLabel;
    seqstep_textlabel_res: TKnobsTextLabel;
    seqstep_textlabel_note: TKnobsTextLabel;
    seqstep_textlabel_duration: TKnobsTextLabel;
    seqstep_note: TKnobsSmallKnob;
    seqstep_time: TKnobsSmallKnob;
    seqstep_display_note: TKnobsDisplay;
    seqstep_display_time: TKnobsDisplay;
    seqclockstep: TKnobsModule;
    seqclockstep_editlabel: TKnobsEditLabel;
    seqclockstep_symbol_clockedge: TImage;
    seqclockstep_symbol_trigfwd: TImage;
    seqclockstep_symbol_sigflow: TImage;
    seqclockstep_symbol_trigbwd: TImage;
    seqclockstep_out: TKnobsOutput;
    seqclockstep_trigoutfwd: TKnobsOutput;
    seqclockstep_trigoutbwd: TKnobsOutput;
    seqclockstep_dir: TKnobsInput;
    seqclockstep_triginfwd: TKnobsInput;
    seqclockstep_reset: TKnobsInput;
    seqclockstep_chain: TKnobsInput;
    seqclockstep_triginbwd: TKnobsInput;
    seqclockstep_clock: TKnobsInput;
    seqclockstep_indicator_trigbwd: TKnobsIndicator;
    seqclockstep_indicator_dir: TKnobsIndicator;
    seqclockstep_indicator_reset: TKnobsIndicator;
    seqclockstep_indicator_active: TKnobsIndicator;
    seqclockstep_indicator_trigfwd: TKnobsIndicator;
    seqclockstep_indicator_clock: TKnobsIndicator;
    seqclockstep_textlabel_trig: TKnobsTextLabel;
    seqclockstep_textlabel_dir: TKnobsTextLabel;
    seqclockstep_textlabel_reset: TKnobsTextLabel;
    seqclockstep_textlabel_note: TKnobsTextLabel;
    seqclockstep_textlabel_count: TKnobsTextLabel;
    seqclockstep_textlabel_clock: TKnobsTextLabel;
    seqclockstep_indicator_count: TKnobsIndicatorText;
    seqclockstep_note: TKnobsSmallKnob;
    seqclockstep_counts: TKnobsSmallKnob;
    seqclockstep_display_note: TKnobsDisplay;
    seqclockstep_display_counts: TKnobsDisplay;
    csvdata: TKnobsModule;
    csvdata_symbol_back2: TImage;
    csvdata_symbol_back1: TImage;
    csvdata_symbol_trig: TImage;
    csvdata_dir: TKnobsInput;
    csvdata_trig: TKnobsInput;
    csvdata_reset: TKnobsInput;
    csvdata_editlabel: TKnobsEditLabel;
    csvdata_indicator_trig: TKnobsIndicator;
    csvdata_indicator_dir: TKnobsIndicator;
    csvdata_indicator_reset: TKnobsIndicator;
    csvdata_textlabel_trig: TKnobsTextLabel;
    csvdata_textlabel_dir: TKnobsTextLabel;
    csvdata_textlabel_res: TKnobsTextLabel;
    csvdata_out1: TKnobsOutput;
    csvdata_out2: TKnobsOutput;
    csvdata_out3: TKnobsOutput;
    csvdata_out4: TKnobsOutput;
    csvdata_out5: TKnobsOutput;
    csvdata_out6: TKnobsOutput;
    csvdata_out7: TKnobsOutput;
    csvdata_out8: TKnobsOutput;
    csvdata_out9: TKnobsOutput;
    csvdata_out10: TKnobsOutput;
    csvdata_out11: TKnobsOutput;
    csvdata_textlabel_1: TKnobsTextLabel;
    csvdata_textlabel_2: TKnobsTextLabel;
    csvdata_textlabel_3: TKnobsTextLabel;
    csvdata_textlabel_4: TKnobsTextLabel;
    csvdata_textlabel_5: TKnobsTextLabel;
    csvdata_textlabel_6: TKnobsTextLabel;
    csvdata_textlabel_7: TKnobsTextLabel;
    csvdata_textlabel_8: TKnobsTextLabel;
    csvdata_textlabel_9: TKnobsTextLabel;
    csvdata_textlabel_10: TKnobsTextLabel;
    csvdata_textlabel_11: TKnobsTextLabel;
    csvdata_indicator_step: TKnobsIndicatorText;
    csvdata_label_slash: TLabel;
    csvdata_indicator_steps: TKnobsIndicatorText;
    csvdata_indicator_channels: TKnobsIndicatorText;
    csvdata_textlabel_mode: TKnobsTextLabel;
    csvdata_textlabel_channels: TKnobsTextLabel;
    csvdata_out12: TKnobsOutput;
    csvdata_out13: TKnobsOutput;
    csvdata_out14: TKnobsOutput;
    csvdata_out15: TKnobsOutput;
    csvdata_out16: TKnobsOutput;
    csvdata_textlabel_12: TKnobsTextLabel;
    csvdata_textlabel_13: TKnobsTextLabel;
    csvdata_textlabel_14: TKnobsTextLabel;
    csvdata_textlabel_15: TKnobsTextLabel;
    csvdata_textlabel_16: TKnobsTextLabel;
    csvdata_fileselector_filename: TKnobsFileSelector;
    csvdata_display_comment: TKnobsDisplay;
    csvdata_mode: TKnobsSelector;
    kleebit: TKnobsModule;
    kleebit_box_bus3: TKnobsBox;
    kleebit_box_bus2: TKnobsBox;
    kleebit_box_bus1: TKnobsBox;
    kleebit_box_analog: TKnobsBox;
    kleebit_box_pre: TKnobsBox;
    kleebit_editlabel: TKnobsEditLabel;
    kleebit_indicator_step1: TKnobsIndicator;
    kleebit_indicator_step2: TKnobsIndicator;
    kleebit_indicator_step3: TKnobsIndicator;
    kleebit_indicator_step4: TKnobsIndicator;
    kleebit_indicator_step5: TKnobsIndicator;
    kleebit_indicator_step6: TKnobsIndicator;
    kleebit_indicator_step7: TKnobsIndicator;
    kleebit_indicator_step8: TKnobsIndicator;
    kleebit_textlabel_1: TKnobsTextLabel;
    kleebit_textlabel_2: TKnobsTextLabel;
    kleebit_textlabel_3: TKnobsTextLabel;
    kleebit_textlabel_4: TKnobsTextLabel;
    kleebit_textlabel_5: TKnobsTextLabel;
    kleebit_textlabel_6: TKnobsTextLabel;
    kleebit_textlabel_7: TKnobsTextLabel;
    kleebit_textlabel_8: TKnobsTextLabel;
    kleebit_outanalog: TKnobsOutput;
    kleebit_outbus1: TKnobsOutput;
    kleebit_inload: TKnobsInput;
    kleebit_indicator_load: TKnobsIndicator;
    kleebit_textlabel_load: TKnobsTextLabel;
    kleebit_inanalog: TKnobsInput;
    kleebit_inbus1: TKnobsInput;
    kleebit_instep: TKnobsInput;
    kleebit_indicator_step: TKnobsIndicator;
    kleebit_textlabel_step: TKnobsTextLabel;
    kleebit_inbus2: TKnobsInput;
    kleebit_inbus3: TKnobsInput;
    kleebit_outbus2: TKnobsOutput;
    kleebit_outbus3: TKnobsOutput;
    kleebit_indicator_bus1: TKnobsIndicator;
    kleebit_indicator_bus2: TKnobsIndicator;
    kleebit_indicator_bus3: TKnobsIndicator;
    kleebit_textlabel_a: TKnobsTextLabel;
    kleebit_textlabel_bus1: TKnobsTextLabel;
    kleebit_textlabel_pre: TKnobsTextLabel;
    kleebit_textlabel_bus2: TKnobsTextLabel;
    kleebit_textlabel_bus3: TKnobsTextLabel;
    kleebit_inbit: TKnobsInput;
    kleebit_textlabel_inbit: TKnobsTextLabel;
    kleebit_outbit: TKnobsOutput;
    kleebit_textlabel_outbit: TKnobsTextLabel;
    kleebit_indicator_inbit: TKnobsIndicator;
    kleebit_indicator_outbit: TKnobsIndicator;
    kleebit_textlabel_outinvert: TKnobsTextLabel;
    kleebit_loopinvert: TKnobsInput;
    kleebit_invertinvert: TKnobsInput;
    kleebit_textlabel_mainlev: TKnobsTextLabel;
    kleebit_indicator_invert: TKnobsIndicator;
    kleebit_indicator_loop: TKnobsIndicator;
    kleebit_mainlevelmod: TKnobsInput;
    kleebit_outinvert: TKnobsOutput;
    kleebit_outloop: TKnobsOutput;
    kleebit_level1: TKnobsSmallKnob;
    kleebit_level2: TKnobsSmallKnob;
    kleebit_level3: TKnobsSmallKnob;
    kleebit_level4: TKnobsSmallKnob;
    kleebit_level5: TKnobsSmallKnob;
    kleebit_level6: TKnobsSmallKnob;
    kleebit_level7: TKnobsSmallKnob;
    kleebit_level8: TKnobsSmallKnob;
    kleebit_bussel1: TKnobsSelector;
    kleebit_bussel2: TKnobsSelector;
    kleebit_bussel3: TKnobsSelector;
    kleebit_bussel4: TKnobsSelector;
    kleebit_bussel5: TKnobsSelector;
    kleebit_bussel6: TKnobsSelector;
    kleebit_bussel7: TKnobsSelector;
    kleebit_bussel8: TKnobsSelector;
    kleebit_loopmode: TKnobsSelector;
    kleebit_pre1: TKnobsSelector;
    kleebit_pre2: TKnobsSelector;
    kleebit_pre3: TKnobsSelector;
    kleebit_pre4: TKnobsSelector;
    kleebit_pre5: TKnobsSelector;
    kleebit_pre6: TKnobsSelector;
    kleebit_pre7: TKnobsSelector;
    kleebit_pre8: TKnobsSelector;
    kleebit_invertmode: TKnobsSelector;
    kleebit_mainlevel: TKnobsSmallKnob;
    midiplayer: TKnobsModule;
    midiplayer_symbol_reset: TImage;
    midiplayer_editlabel: TKnobsEditLabel;
    midiplayer_indicator_gate: TKnobsIndicator;
    midiplayer_gate: TKnobsOutput;
    midiplayer_note: TKnobsOutput;
    midiplayer_velon: TKnobsOutput;
    midiplayer_veloff: TKnobsOutput;
    midiplayer_textlabel_gate: TKnobsTextLabel;
    midiplayer_textlabel_velocity: TKnobsTextLabel;
    midiplayer_textlabel_off: TKnobsTextLabel;
    midiplayer_textlabel_on: TKnobsTextLabel;
    midiplayer_textlabel_note: TKnobsTextLabel;
    midiplayer_symbol_trig: TImage;
    midiplayer_trig: TKnobsInput;
    midiplayer_textlabel_indicator_trig: TKnobsIndicator;
    midiplayer_textlabel_trig: TKnobsTextLabel;
    midiplayer_done: TKnobsOutput;
    midiplayer_textlabel_done: TKnobsTextLabel;
    midiplayer_reset: TKnobsInput;
    midiplayer_textlabel_reset: TKnobsTextLabel;
    midiplayer_indicator_done: TKnobsIndicator;
    midiplayer_indicator_reset: TKnobsIndicator;
    midiplayer_ch: TKnobsNoKnob;
    midiplayer_display_ch: TKnobsDisplay;
    midiplayer_fileselector_filename: TKnobsFileSelector;
    midiplayer_mode: TKnobsSelector;
    seqpattern: TKnobsModule;
    seqpattern_editlabel: TKnobsEditLabel;
    seqpattern_out1: TKnobsOutput;
    seqpattern_indicator_bit1: TKnobsIndicator;
    seqpattern_textlabel_bits: TKnobsTextLabel;
    seqpattern_textlabel_p: TKnobsTextLabel;
    seqpattern_out9: TKnobsOutput;
    seqpattern_indicator_bit9: TKnobsIndicator;
    seqpattern_out2: TKnobsOutput;
    seqpattern_indicator_bit2: TKnobsIndicator;
    seqpattern_out10: TKnobsOutput;
    seqpattern_indicator_bit10: TKnobsIndicator;
    seqpattern_out3: TKnobsOutput;
    seqpattern_indicator_bit3: TKnobsIndicator;
    seqpattern_out11: TKnobsOutput;
    seqpattern_indicator_bit11: TKnobsIndicator;
    seqpattern_out4: TKnobsOutput;
    seqpattern_indicator_bit4: TKnobsIndicator;
    seqpattern_out12: TKnobsOutput;
    seqpattern_indicator_bit12: TKnobsIndicator;
    seqpattern_out5: TKnobsOutput;
    seqpattern_indicator_bit5: TKnobsIndicator;
    seqpattern_out13: TKnobsOutput;
    seqpattern_indicator_bit13: TKnobsIndicator;
    seqpattern_out6: TKnobsOutput;
    seqpattern_indicator_bit6: TKnobsIndicator;
    seqpattern_out14: TKnobsOutput;
    seqpattern_indicator_bit14: TKnobsIndicator;
    seqpattern_out7: TKnobsOutput;
    seqpattern_indicator_bit7: TKnobsIndicator;
    seqpattern_out15: TKnobsOutput;
    seqpattern_indicator_bit15: TKnobsIndicator;
    seqpattern_out8: TKnobsOutput;
    seqpattern_indicator_bit8: TKnobsIndicator;
    seqpattern_out16: TKnobsOutput;
    seqpattern_indicator_bit16: TKnobsIndicator;
    seqpattern_out17: TKnobsOutput;
    seqpattern_indicator_bit17: TKnobsIndicator;
    seqpattern_out18: TKnobsOutput;
    seqpattern_indicator_bit18: TKnobsIndicator;
    seqpattern_out19: TKnobsOutput;
    seqpattern_indicator_bit19: TKnobsIndicator;
    seqpattern_out20: TKnobsOutput;
    seqpattern_indicator_bit20: TKnobsIndicator;
    seqpattern_out21: TKnobsOutput;
    seqpattern_indicator_bit21: TKnobsIndicator;
    seqpattern_out22: TKnobsOutput;
    seqpattern_indicator_bit22: TKnobsIndicator;
    seqpattern_out23: TKnobsOutput;
    seqpattern_indicator_bit23: TKnobsIndicator;
    seqpattern_out24: TKnobsOutput;
    seqpattern_indicator_bit24: TKnobsIndicator;
    seqpattern_textlabel_bitoutputs: TKnobsTextLabel;
    seqpattern_res: TKnobsInput;
    seqpattern_indicator_res: TKnobsIndicator;
    seqpattern_textlabel_res: TKnobsTextLabel;
    seqpattern_act: TKnobsInput;
    seqpattern_indicator_act: TKnobsIndicator;
    seqpattern_textlabel_act: TKnobsTextLabel;
    seqpattern_clk: TKnobsInput;
    seqpattern_indicator_clk: TKnobsIndicator;
    seqpattern_textlabel_clk: TKnobsTextLabel;
    seqpattern_symbol_clk: TImage;
    seqpattern_symbol_res: TImage;
    seqpattern_textlabel_s: TKnobsTextLabel;
    seqpattern_textlabel_e: TKnobsTextLabel;
    seqpattern_textlabel_1: TKnobsTextLabel;
    seqpattern_textlabel_2: TKnobsTextLabel;
    seqpattern_textlabel_3: TKnobsTextLabel;
    seqpattern_textlabel_4: TKnobsTextLabel;
    seqpattern_textlabel_5: TKnobsTextLabel;
    seqpattern_textlabel_6: TKnobsTextLabel;
    seqpattern_textlabel_7: TKnobsTextLabel;
    seqpattern_textlabel_8: TKnobsTextLabel;
    seqpattern_bitdata: TKnobsData;
    seqpattern_espdata: TKnobsData;
    seqpattern_done: TKnobsOutput;
    seqpattern_indicator_done: TKnobsIndicator;
    seqpattern_textlabel_done: TKnobsTextLabel;
    seqpattern_bits9: TKnobsSelector;
    seqpattern_bits1: TKnobsSelector;
    seqpattern_bits10: TKnobsSelector;
    seqpattern_bits2: TKnobsSelector;
    seqpattern_bits11: TKnobsSelector;
    seqpattern_bits3: TKnobsSelector;
    seqpattern_bits12: TKnobsSelector;
    seqpattern_bits4: TKnobsSelector;
    seqpattern_bits13: TKnobsSelector;
    seqpattern_bits5: TKnobsSelector;
    seqpattern_bits14: TKnobsSelector;
    seqpattern_bits6: TKnobsSelector;
    seqpattern_bits15: TKnobsSelector;
    seqpattern_bits7: TKnobsSelector;
    seqpattern_bits16: TKnobsSelector;
    seqpattern_bits8: TKnobsSelector;
    seqpattern_bits17: TKnobsSelector;
    seqpattern_bits18: TKnobsSelector;
    seqpattern_bits19: TKnobsSelector;
    seqpattern_bits20: TKnobsSelector;
    seqpattern_bits21: TKnobsSelector;
    seqpattern_bits22: TKnobsSelector;
    seqpattern_bits23: TKnobsSelector;
    seqpattern_bits24: TKnobsSelector;
    seqpattern_s1: TKnobsSelector;
    seqpattern_p1: TKnobsSelector;
    seqpattern_s2: TKnobsSelector;
    seqpattern_p2: TKnobsSelector;
    seqpattern_s3: TKnobsSelector;
    seqpattern_p3: TKnobsSelector;
    seqpattern_s4: TKnobsSelector;
    seqpattern_p4: TKnobsSelector;
    seqpattern_s5: TKnobsSelector;
    seqpattern_p5: TKnobsSelector;
    seqpattern_s6: TKnobsSelector;
    seqpattern_p6: TKnobsSelector;
    seqpattern_s7: TKnobsSelector;
    seqpattern_p7: TKnobsSelector;
    seqpattern_s8: TKnobsSelector;
    seqpattern_p8: TKnobsSelector;
    seqpattern_e1: TKnobsSelector;
    seqpattern_e2: TKnobsSelector;
    seqpattern_e3: TKnobsSelector;
    seqpattern_e4: TKnobsSelector;
    seqpattern_e5: TKnobsSelector;
    seqpattern_e6: TKnobsSelector;
    seqpattern_e7: TKnobsSelector;
    seqpattern_e8: TKnobsSelector;
    seqpattern_loop: TKnobsSelector;
    seqpattern_copye: TKnobsSelector;
    seqpattern_copys: TKnobsSelector;
    seqpattern_clre: TKnobsSelector;
    seqpattern_copyp: TKnobsSelector;
    seqpattern_clrs: TKnobsSelector;
    seqpattern_clrp: TKnobsSelector;
    seqpattern_mode: TKnobsSelector;
    seqpattern_reset: TKnobsSelector;
    seqvalues: TKnobsModule;
    seqvalues_editlabel: TKnobsEditLabel;
    seqvalues_textlabel_values: TKnobsTextLabel;
    seqvalues_textlabel_p: TKnobsTextLabel;
    seqvalues_out1: TKnobsOutput;
    seqvalues_out2: TKnobsOutput;
    seqvalues_out3: TKnobsOutput;
    seqvalues_out4: TKnobsOutput;
    seqvalues_out5: TKnobsOutput;
    seqvalues_out6: TKnobsOutput;
    seqvalues_out7: TKnobsOutput;
    seqvalues_out8: TKnobsOutput;
    seqvalues_res: TKnobsInput;
    seqvalues_indicator_res: TKnobsIndicator;
    seqvalues_textlabel_res: TKnobsTextLabel;
    seqvalues_act: TKnobsInput;
    seqvalues_indicator_act: TKnobsIndicator;
    seqvalues_textlabel_act: TKnobsTextLabel;
    seqvalues_clk: TKnobsInput;
    seqvalues_indicator_clk: TKnobsIndicator;
    seqvalues_textlabel_clk: TKnobsTextLabel;
    seqvalues_symbol_clk: TImage;
    seqvalues_symbol_res: TImage;
    seqvalues_textlabel_s: TKnobsTextLabel;
    seqvalues_textlabel_e: TKnobsTextLabel;
    seqvalues_textlabel_1: TKnobsTextLabel;
    seqvalues_textlabel_2: TKnobsTextLabel;
    seqvalues_textlabel_3: TKnobsTextLabel;
    seqvalues_textlabel_4: TKnobsTextLabel;
    seqvalues_textlabel_5: TKnobsTextLabel;
    seqvalues_textlabel_6: TKnobsTextLabel;
    seqvalues_textlabel_7: TKnobsTextLabel;
    seqvalues_textlabel_8: TKnobsTextLabel;
    seqvalues_valuedata: TKnobsData;
    seqvalues_espdata: TKnobsData;
    seqvalues_done: TKnobsOutput;
    seqvalues_indicator_done: TKnobsIndicator;
    seqvalues_textlabel_done: TKnobsTextLabel;
    seqvalues_s1: TKnobsSelector;
    seqvalues_p1: TKnobsSelector;
    seqvalues_s2: TKnobsSelector;
    seqvalues_p2: TKnobsSelector;
    seqvalues_s3: TKnobsSelector;
    seqvalues_p3: TKnobsSelector;
    seqvalues_s4: TKnobsSelector;
    seqvalues_p4: TKnobsSelector;
    seqvalues_s5: TKnobsSelector;
    seqvalues_p5: TKnobsSelector;
    seqvalues_s6: TKnobsSelector;
    seqvalues_p6: TKnobsSelector;
    seqvalues_s7: TKnobsSelector;
    seqvalues_p7: TKnobsSelector;
    seqvalues_s8: TKnobsSelector;
    seqvalues_p8: TKnobsSelector;
    seqvalues_e1: TKnobsSelector;
    seqvalues_e2: TKnobsSelector;
    seqvalues_e3: TKnobsSelector;
    seqvalues_e4: TKnobsSelector;
    seqvalues_e5: TKnobsSelector;
    seqvalues_e6: TKnobsSelector;
    seqvalues_e7: TKnobsSelector;
    seqvalues_e8: TKnobsSelector;
    seqvalues_loop: TKnobsSelector;
    seqvalues_copye: TKnobsSelector;
    seqvalues_copys: TKnobsSelector;
    seqvalues_clre: TKnobsSelector;
    seqvalues_copyp: TKnobsSelector;
    seqvalues_clrs: TKnobsSelector;
    seqvalues_clrp: TKnobsSelector;
    seqvalues_mode: TKnobsSelector;
    seqvalues_reset: TKnobsSelector;
    seqvalues_value1: TKnobsHSlider;
    seqvalues_value2: TKnobsHSlider;
    seqvalues_value3: TKnobsHSlider;
    seqvalues_value4: TKnobsHSlider;
    seqvalues_value5: TKnobsHSlider;
    seqvalues_value6: TKnobsHSlider;
    seqvalues_value7: TKnobsHSlider;
    seqvalues_value8: TKnobsHSlider;
    seqvalues_valmode: TKnobsSelector;
    neuralpulser: TKnobsModule;
    neuralpulser_out1: TKnobsOutput;
    neuralpulser_exc1b: TKnobsInput;
    neuralpulser_editlabel: TKnobsEditLabel;
    neuralpulser_textlabel_plus1: TKnobsTextLabel;
    neuralpulser_exc1a: TKnobsInput;
    neuralpulser_symbol_clock: TImage;
    neuralpulser_textlabel_clock: TKnobsTextLabel;
    neuralpulser_inh1: TKnobsInput;
    neuralpulser_textlabel_outmode: TKnobsSelector;
    neuralpulser_mode1: TKnobsSelector;
    neuralpulser_textlabel_out1: TKnobsTextLabel;
    neuralpulser_textlabel_plus2: TKnobsTextLabel;
    neuralpulser_textlabel_minus1: TKnobsTextLabel;
    neuralpulser_clock: TKnobsInput;
    neuralpulser_out5: TKnobsOutput;
    neuralpulser_exc5b: TKnobsInput;
    neuralpulser_textlabel_plus3: TKnobsTextLabel;
    neuralpulser_exc5a: TKnobsInput;
    neuralpulser_inh5: TKnobsInput;
    neuralpulser_mode5: TKnobsSelector;
    neuralpulser_textlabel_out2: TKnobsTextLabel;
    neuralpulser_textlabel_plus4: TKnobsTextLabel;
    neuralpulser_textlabel_minus2: TKnobsTextLabel;
    neuralpulser_out2: TKnobsOutput;
    neuralpulser_exc2b: TKnobsInput;
    neuralpulser_exc2a: TKnobsInput;
    neuralpulser_inh2: TKnobsInput;
    neuralpulser_mode2: TKnobsSelector;
    neuralpulser_out6: TKnobsOutput;
    neuralpulser_exc6b: TKnobsInput;
    neuralpulser_exc6a: TKnobsInput;
    neuralpulser_inh6: TKnobsInput;
    neuralpulser_mode6: TKnobsSelector;
    neuralpulser_out3: TKnobsOutput;
    neuralpulser_exc3b: TKnobsInput;
    neuralpulser_exc3a: TKnobsInput;
    neuralpulser_inh3: TKnobsInput;
    neuralpulser_mode3: TKnobsSelector;
    neuralpulser_out7: TKnobsOutput;
    neuralpulser_exc7b: TKnobsInput;
    neuralpulser_exc7a: TKnobsInput;
    neuralpulser_inh7: TKnobsInput;
    neuralpulser_mode7: TKnobsSelector;
    neuralpulser_out4: TKnobsOutput;
    neuralpulser_exc4b: TKnobsInput;
    neuralpulser_exc4a: TKnobsInput;
    neuralpulser_inh4: TKnobsInput;
    neuralpulser_mode4: TKnobsSelector;
    neuralpulser_out8: TKnobsOutput;
    neuralpulser_exc8b: TKnobsInput;
    neuralpulser_exc8a: TKnobsInput;
    neuralpulser_inh8: TKnobsInput;
    neuralpulser_mode8: TKnobsSelector;
    neuralpulser_symbol_reset: TImage;
    neuralpulser_textlabel_reset: TKnobsTextLabel;
    neuralpulser_reset: TKnobsInput;
    neuralpulser_indicator_out1: TKnobsIndicator;
    neuralpulser_indicator_out2: TKnobsIndicator;
    neuralpulser_indicator_out3: TKnobsIndicator;
    neuralpulser_indicator_out4: TKnobsIndicator;
    neuralpulser_indicator_out5: TKnobsIndicator;
    neuralpulser_indicator_out6: TKnobsIndicator;
    neuralpulser_indicator_out7: TKnobsIndicator;
    neuralpulser_indicator_out8: TKnobsIndicator;
    masterosc_outexp: TKnobsOutput;
    masterosc_textlabel_freqout: TKnobsTextLabel;
    seq16_rnd3: TKnobsInput;
    seq16_textlabel_rnd1: TKnobsTextLabel;
    chladni: TKnobsModule;
    chladni_editlabel: TKnobsEditLabel;
    chladni_in: TKnobsInput;
    chladni_out: TKnobsOutput;
    chladni_textlabel_in: TKnobsTextLabel;
    chladni_textlabel_out: TKnobsTextLabel;
    chladni_textlabel_lev: TKnobsTextLabel;
    chladni_fmamt: TKnobsInput;
    chladni_textlabel_fm: TKnobsTextLabel;
    chladni_textlabel_q: TKnobsTextLabel;
    chladni_textlabel_a: TKnobsTextLabel;
    chladni_textlabel_freq: TKnobsTextLabel;
    chladni_qm: TKnobsInput;
    chladni_textlabel_qm: TKnobsTextLabel;
    chladni_textlabel_qmain: TKnobsTextLabel;
    chladni_lfm: TKnobsInput;
    chladni_textlabel_lfm: TKnobsTextLabel;
    chladni_am: TKnobsInput;
    chladni_q1: TKnobsSmallKnob;
    chladni_q2: TKnobsSmallKnob;
    chladni_q3: TKnobsSmallKnob;
    chladni_q4: TKnobsSmallKnob;
    chladni_q5: TKnobsSmallKnob;
    chladni_q6: TKnobsSmallKnob;
    chladni_q7: TKnobsSmallKnob;
    chladni_q8: TKnobsSmallKnob;
    chladni_level1: TKnobsSmallKnob;
    chladni_level2: TKnobsSmallKnob;
    chladni_level3: TKnobsSmallKnob;
    chladni_level4: TKnobsSmallKnob;
    chladni_level5: TKnobsSmallKnob;
    chladni_level6: TKnobsSmallKnob;
    chladni_level7: TKnobsSmallKnob;
    chladni_level8: TKnobsSmallKnob;
    chladni_q9: TKnobsSmallKnob;
    chladni_q10: TKnobsSmallKnob;
    chladni_q11: TKnobsSmallKnob;
    chladni_level9: TKnobsSmallKnob;
    chladni_level10: TKnobsSmallKnob;
    chladni_level11: TKnobsSmallKnob;
    chladni_level: TKnobsSmallKnob;
    chladni_fm: TKnobsSmallKnob;
    chladni_freq: TKnobsSmallKnob;
    chladni_fi: TKnobsSelector;
    chladni_qmamt: TKnobsSmallKnob;
    chladni_q: TKnobsSmallKnob;
    chladni_lfmamt: TKnobsSmallKnob;
    chladni_frequency: TKnobsInput;
    chladni_pmod: TKnobsInput;
    chladni_textlabel_p: TKnobsTextLabel;
    chladni_pmodamt: TKnobsSmallKnob;
    chladni_p: TKnobsSmallKnob;
    chladni_display_p: TKnobsDisplay;
    chladni_display_freq: TKnobsDisplay;
    chladnicosc: TKnobsModule;
    chladnicosc_editlabel: TKnobsEditLabel;
    chladnicosc_out: TKnobsOutput;
    chladnicosc_leveltextlabel_out: TKnobsTextLabel;
    chladnicosc_fm: TKnobsInput;
    chladnicosc_leveltextlabel_fm: TKnobsTextLabel;
    chladnicosc_leveltextlabel_a: TKnobsTextLabel;
    chladnicosc_leveltextlabel_freq: TKnobsTextLabel;
    chladnicosc_pm: TKnobsInput;
    chladnicosc_leveltextlabel_pm: TKnobsTextLabel;
    chladnicosc_speed: TKnobsInput;
    chladnicosc_leveltextlabel_speed: TKnobsTextLabel;
    chladnicosc_pmod: TKnobsInput;
    chladnicosc_textlabel_p: TKnobsTextLabel;
    chladnicosc_level1: TKnobsSmallKnob;
    chladnicosc_level2: TKnobsSmallKnob;
    chladnicosc_level3: TKnobsSmallKnob;
    chladnicosc_level4: TKnobsSmallKnob;
    chladnicosc_level5: TKnobsSmallKnob;
    chladnicosc_level6: TKnobsSmallKnob;
    chladnicosc_level7: TKnobsSmallKnob;
    chladnicosc_level8: TKnobsSmallKnob;
    chladnicosc_level9: TKnobsSmallKnob;
    chladnicosc_level10: TKnobsSmallKnob;
    chladnicosc_level11: TKnobsSmallKnob;
    chladnicosc_fmlevel: TKnobsSmallKnob;
    chladnicosc_frequency: TKnobsSmallKnob;
    chladnicosc_pmlevel: TKnobsSmallKnob;
    chladnicosc_pmodamt: TKnobsSmallKnob;
    chladnicosc_p: TKnobsSmallKnob;
    chladnicosc_display_p: TKnobsDisplay;
    chladnicosc_display_frequency: TKnobsDisplay;
    chladnicosc_freq: TKnobsInput;
    chladnicosc_mute: TKnobsSelector;
    chladnicosc_cents: TKnobsSmallKnob;
    chladnicosc_display_cents: TKnobsDisplay;
    lut_rnd2: TKnobsInput;
    lut_textlabel_single: TKnobsTextLabel;
    lut_textlabel_all: TKnobsTextLabel;
    progdivider_indicator_count: TKnobsIndicatorText;
    reverb_indicator_freeze: TKnobsIndicator;
    serpar: TKnobsModule;
    serpar_editlabel: TKnobsEditLabel;
    serpar_out1: TKnobsOutput;
    serpar_clkout: TKnobsInput;
    serpar_indicator_clkin: TKnobsIndicator;
    serpar_out2: TKnobsOutput;
    serpar_out3: TKnobsOutput;
    serpar_out4: TKnobsOutput;
    serpar_out5: TKnobsOutput;
    serpar_out6: TKnobsOutput;
    serpar_out7: TKnobsOutput;
    serpar_out8: TKnobsOutput;
    serpar_out9: TKnobsOutput;
    serpar_out10: TKnobsOutput;
    serpar_out11: TKnobsOutput;
    serpar_in: TKnobsInput;
    serpar_cout: TKnobsOutput;
    serpar_textlabel_clkout: TKnobsTextLabel;
    serpar_indicator_clkout: TKnobsIndicator;
    serpar_clkin: TKnobsInput;
    serpar_textlabel_clkin: TKnobsTextLabel;
    serpar_textlabel_cout: TKnobsTextLabel;
    serpar_textlabel_in: TKnobsTextLabel;
    serpar_symbol_clkin: TImage;
    serpar_symbol_clkout: TImage;
    envarretrig_amod: TKnobsInput;
    envarretrig_rmod: TKnobsInput;
    intdif_modemod: TKnobsInput;
    intdif_indicator_mode: TKnobsTextLabel;
    delaymix: TKnobsModule;
    delaymix_editlabel: TKnobsEditLabel;
    delaymix_out: TKnobsOutput;
    delaymix_in: TKnobsInput;
    delaymix_delay: TKnobsInput;
    delaymix_textlabel_in: TKnobsTextLabel;
    delaymix_textlabel_dly: TKnobsTextLabel;
    delaymix_textlabel_maxdelay: TKnobsTextLabel;
    delaymix_length: TKnobsSmallKnob;
    delaymix_display_length: TKnobsDisplay;
    delaymix_range: TKnobsSelector;
    delaymix_mix: TKnobsSmallKnob;
    delaymix_textlabel_mix: TKnobsTextLabel;
    delaymix_mixmod: TKnobsInput;
    movingaverage: TKnobsModule;
    movingaverage_out: TKnobsOutput;
    movingaverage_in: TKnobsInput;
    movingaverage_editlabel: TKnobsEditLabel;
    movingaverage_textlabel_in: TKnobsTextLabel;
    movingaverage_textlabel_out: TKnobsTextLabel;
    movingaverage_size: TKnobsSmallKnob;
    filter6db_lp: TKnobsOutput;
    filter6db_textlabel_lp: TKnobsTextLabel;
    movingaverage_display_size: TKnobsDisplay;
    movingaverage_textlabel_size: TKnobsTextLabel;
    control2_tabsheet: TTabSheet;
    wavewiper: TKnobsModule;
    wavewiper_editlabel: TKnobsEditLabel;
    wavewiper_out2: TKnobsOutput;
    wavewiper_break: TKnobsInput;
    wavewiper_in1: TKnobsInput;
    wavewiper_in2: TKnobsInput;
    wavewiper_out1: TKnobsOutput;
    wavewiper_textlabel_break: TKnobsTextLabel;
    wavewiper_textlabel_ins: TKnobsTextLabel;
    wavewiper_textlabel_out: TKnobsTextLabel;
    wavewiper_mute: TKnobsSelector;
    wavewrapper: TKnobsModule;
    wavewrapper_editlabel: TKnobsEditLabel;
    wavewrapper_out: TKnobsOutput;
    wavewrapper_in: TKnobsInput;
    wavewrapper_textlabel_in: TKnobsTextLabel;
    wavewrapper_textlabel_high: TKnobsTextLabel;
    wavewrapper_textlabel_low: TKnobsTextLabel;
    wavewrapper_mod: TKnobsInput;
    wavewrapper_textlabel_mod: TKnobsTextLabel;
    wavewrapper_highlevel: TKnobsSmallKnob;
    wavewrapper_display_high: TKnobsDisplay;
    wavewrapper_mute: TKnobsSelector;
    wavewrapper_lowlevel: TKnobsSmallKnob;
    wavewrapper_display_low: TKnobsDisplay;
    wavewrapper_modamt: TKnobsSmallKnob;
    wavewrapper_type: TKnobsSelector;
    wavolver: TKnobsModule;
    wavolver_editlabel: TKnobsEditLabel;
    wavolver_out: TKnobsOutput;
    wavolver_shape: TKnobsInput;
    wavolver_signal: TKnobsInput;
    wavolver_textlabel_out: TKnobsTextLabel;
    wavolver_inactive: TKnobsOutput;
    wavolver_textlabel_inactive: TKnobsTextLabel;
    wavolver_textlabel_shapeleveloffset: TKnobsTextLabel;
    wavolver_textlabel_signalleveloffset: TKnobsTextLabel;
    wavolver_in: TKnobsInput;
    wavolver_textlabel_in: TKnobsTextLabel;
    wavolver_pulseampmod: TKnobsInput;
    wavolver_textlabel_pulseamp: TKnobsTextLabel;
    wavolver_shapelevel: TKnobsSmallKnob;
    wavolver_shapeoffset: TKnobsSmallKnob;
    wavolver_signallevel: TKnobsSmallKnob;
    wavolver_signaloffset: TKnobsSmallKnob;
    wavolver_mute: TKnobsSelector;
    wavolver_inlevel: TKnobsSmallKnob;
    wavolver_pulseampmodlev: TKnobsSmallKnob;
    wavolver_pulseamp: TKnobsSmallKnob;
    ammod: TKnobsModule;
    ammod_out: TKnobsOutput;
    ammod_in: TKnobsInput;
    ammod_editlabel: TKnobsEditLabel;
    ammod_textlabel_in: TKnobsTextLabel;
    ammod_textlabel_out: TKnobsTextLabel;
    ammod_textlabel_offset: TKnobsTextLabel;
    ammod_mod: TKnobsInput;
    ammod_textlabel_mod: TKnobsTextLabel;
    ammod_textlabel_am: TKnobsTextLabel;
    ammod_textlabel_rm: TKnobsTextLabel;
    ammod_offset: TKnobsSmallKnob;
    ammod_display_offset: TKnobsDisplay;
    ammod_modamt: TKnobsSmallKnob;
    ammod_modtype: TKnobsSelector;
    ammod_display_modamt: TKnobsDisplay;
    ammod_amrm: TKnobsSmallKnob;
    shaper: TKnobsModule;
    shper_out: TKnobsOutput;
    shper_in: TKnobsInput;
    shper_editlabel: TKnobsEditLabel;
    shper_shape: TKnobsSelector;
    shper_intype: TKnobsSelector;
    shper_outtype: TKnobsSelector;
    analogxor: TKnobsModule;
    analogxor_out: TKnobsOutput;
    analogxor_ina: TKnobsInput;
    analogxor_editlabel: TKnobsEditLabel;
    analogxor_textlabel_a: TKnobsTextLabel;
    analogxor_textlabel_out: TKnobsTextLabel;
    analogxor_textlabel_threshold: TKnobsTextLabel;
    analogxor_tmod: TKnobsInput;
    analogxor_textlabel_tmod: TKnobsTextLabel;
    analogxor_inb: TKnobsInput;
    analogxor_textlabel_b: TKnobsTextLabel;
    analogxor_threshold: TKnobsSmallKnob;
    analogxor_display_threshold: TKnobsDisplay;
    analogxor_tmodamt: TKnobsSmallKnob;
    analogxor_intypea: TKnobsSelector;
    analogxor_outtype: TKnobsSelector;
    analogxor_intypeb: TKnobsSelector;
    datagraph: TKnobsModule;
    datagraph_editlabel: TKnobsEditLabel;
    datagraph_data: TKnobsDataMaker;
    datagraph_out: TKnobsOutput;
    datagraph_in: TKnobsInput;
    datagraph_textlabel_in: TKnobsTextLabel;
    datagraph_textlabel_out: TKnobsTextLabel;
    datagraph_inmode: TKnobsSelector;
    datagraph_outmode: TKnobsSelector;
    datagraph_splines: TKnobsSelector;
    datagraph_mode: TKnobsSelector;
    values: TKnobsModule;
    values_editlabel: TKnobsEditLabel;
    values_out: TKnobsOutput;
    values_in: TKnobsInput;
    values_indicator_value: TKnobsIndicatorText;
    values_changed: TKnobsOutput;
    values_textlabel_changed: TKnobsTextLabel;
    values_indicator_changed: TKnobsIndicator;
    values_display_values: TKnobsDisplay;
    values_intype: TKnobsSelector;
    values_outtype: TKnobsSelector;
    chladnicontrol: TKnobsModule;
    chladnicontrol_editlabel: TKnobsEditLabel;
    chladnicontrol_out: TKnobsOutput;
    chladnicontrol_nmod: TKnobsInput;
    chladnicontrol_textlabel_n: TKnobsTextLabel;
    chladnicontrol_mmod: TKnobsInput;
    chladnicontrol_textlabel_m: TKnobsTextLabel;
    chladnicontrol_pmod: TKnobsInput;
    chladnicontrol_textlabel_p: TKnobsTextLabel;
    chladnicontrol_cmod: TKnobsInput;
    chladnicontrol_textlabel_c: TKnobsTextLabel;
    chladnicontrol_nmodamt: TKnobsSmallKnob;
    chladnicontrol_n: TKnobsSmallKnob;
    chladnicontrol_mmodamt: TKnobsSmallKnob;
    chladnicontrol_m: TKnobsSmallKnob;
    chladnicontrol_pmodamt: TKnobsSmallKnob;
    chladnicontrol_p: TKnobsSmallKnob;
    chladnicontrol_cmodamt: TKnobsSmallKnob;
    chladnicontrol_c: TKnobsSmallKnob;
    chladnicontrol_display_c: TKnobsDisplay;
    rotator: TKnobsModule;
    rotator_editlabel: TKnobsEditLabel;
    rotator_out1: TKnobsOutput;
    rotator_out2: TKnobsOutput;
    rotator_angle: TKnobsInput;
    rotator_in1: TKnobsInput;
    rotator_in2: TKnobsInput;
    rotator_textlabel_angle: TKnobsTextLabel;
    rotator_textlabel_ins: TKnobsTextLabel;
    rotator_textlabel_outs: TKnobsTextLabel;
    rotator_sin: TKnobsOutput;
    rotator_cos: TKnobsOutput;
    rotator_textlabel_sincos: TKnobsTextLabel;
    rotator_sctype: TKnobsSelector;
    rotator_mode: TKnobsSelector;
    rectifier: TKnobsModule;
    rectifier_editlabel: TKnobsEditLabel;
    rectifier_outinv: TKnobsOutput;
    rectifier_out: TKnobsOutput;
    rectifier_in: TKnobsInput;
    rectifier_textlabel_inv: TKnobsTextLabel;
    rectifier_mode: TKnobsSelector;
    hardclip: TKnobsModule;
    hardclip_editlabel: TKnobsEditLabel;
    hardclip_out: TKnobsOutput;
    hardclip_in: TKnobsInput;
    hardclip_textlabel_in: TKnobsTextLabel;
    hardclip_textlabel_highlevel: TKnobsTextLabel;
    hardclip_textlabel_lowlevel: TKnobsTextLabel;
    hardclip_textlabel_outamp: TKnobsTextLabel;
    hardclip_textlabel_lock: TKnobsTextLabel;
    hardclip_highlevel: TKnobsSmallKnob;
    hardclip_display_highlevel: TKnobsDisplay;
    hardclip_mute: TKnobsSelector;
    hardclip_lowlevel: TKnobsSmallKnob;
    hardclip_display_lowlevel: TKnobsDisplay;
    hardclip_outamp: TKnobsSmallKnob;
    hardclip_display_outamp: TKnobsDisplay;
    hardclip_lock: TKnobsSelector;
    chebgen: TKnobsModule;
    chebgen_editlabel: TKnobsEditLabel;
    chebgen_in: TKnobsInput;
    chebgen_textlabel_in: TKnobsTextLabel;
    chebgen_out2: TKnobsOutput;
    chebgen_out3: TKnobsOutput;
    chebgen_out4: TKnobsOutput;
    chebgen_out5: TKnobsOutput;
    chebgen_out6: TKnobsOutput;
    chebgen_out7: TKnobsOutput;
    chebgen_out8: TKnobsOutput;
    chebgen_out9: TKnobsOutput;
    chebgen_out10: TKnobsOutput;
    chebgen_out11: TKnobsOutput;
    chebgen_out12: TKnobsOutput;
    chebgen_out13: TKnobsOutput;
    chebgen_textlabel_3: TKnobsTextLabel;
    chebgen_textlabel_4: TKnobsTextLabel;
    chebgen_textlabel_5: TKnobsTextLabel;
    chebgen_textlabel_6: TKnobsTextLabel;
    chebgen_textlabel_7: TKnobsTextLabel;
    chebgen_textlabel_8: TKnobsTextLabel;
    chebgen_textlabel_9: TKnobsTextLabel;
    chebgen_textlabel_10: TKnobsTextLabel;
    chebgen_textlabel_11: TKnobsTextLabel;
    chebgen_textlabel_12: TKnobsTextLabel;
    chebgen_textlabel_13: TKnobsTextLabel;
    chebgen_textlabel_2: TKnobsTextLabel;
    chebgen_shapemod: TKnobsInput;
    chebgen_wmode: TKnobsSelector;
    slew: TKnobsModule;
    slew_out: TKnobsOutput;
    slew_in: TKnobsInput;
    slew_editlabel: TKnobsEditLabel;
    slew_textlabel_in: TKnobsTextLabel;
    slew_texrlabel_out: TKnobsTextLabel;
    slew_slew: TKnobsSmallKnob;
    sawmill: TKnobsModule;
    sawmill_out: TKnobsOutput;
    sawmill_in: TKnobsInput;
    sawmill_editlabel: TKnobsEditLabel;
    sawmill_textlabel_in: TKnobsTextLabel;
    sawmill_textlabel_out: TKnobsTextLabel;
    sawmill_textlabel_mult: TKnobsTextLabel;
    sawmill_multmod: TKnobsInput;
    sawmill_textlabel_mmod: TKnobsTextLabel;
    sawmill_mult: TKnobsSmallKnob;
    sawmill_display_mult: TKnobsDisplay;
    sawmill_multmodamt: TKnobsSmallKnob;
    sawmill_inputtype: TKnobsSelector;
    sawmill_outputtype: TKnobsSelector;
    fasttoslow: TKnobsModule;
    fasttoslow_out: TKnobsOutput;
    fasttoslow_in: TKnobsInput;
    fasttoslow_editlabel: TKnobsEditLabel;
    fasttoslow_textlabel_in: TKnobsTextLabel;
    fasttoslow_textlabel_out: TKnobsTextLabel;
    matrixmult: TKnobsModule;
    matrixmult_editlabel: TKnobsEditLabel;
    matrixmult_out1: TKnobsOutput;
    matrixmult_ina: TKnobsInput;
    matrixmult_inb: TKnobsInput;
    matrixmult_in1: TKnobsInput;
    matrixmult_textlabel_ab: TKnobsTextLabel;
    matrixmult_textlabel_in: TKnobsTextLabel;
    matrixmult_textlabel_out: TKnobsTextLabel;
    matrixmult_inc: TKnobsInput;
    matrixmult_ind: TKnobsInput;
    matrixmult_textlabel_cd: TKnobsTextLabel;
    matrixmult_out2: TKnobsOutput;
    matrixmult_in2: TKnobsInput;
    slowtofast: TKnobsModule;
    slowtofast_out: TKnobsOutput;
    slowtofast_in: TKnobsInput;
    slowtofast_editlabel: TKnobsEditLabel;
    slowtofast_textlabel_in: TKnobsTextLabel;
    slowtofast_textlabel_out: TKnobsTextLabel;
    rotator2: TKnobsModule;
    rotator2_editlabel: TKnobsEditLabel;
    rotator2_out1: TKnobsOutput;
    rotator2_out2: TKnobsOutput;
    rotator2_angle: TKnobsInput;
    rotator2_in1: TKnobsInput;
    rotator2_in2: TKnobsInput;
    rotator2_textlabel_angle: TKnobsTextLabel;
    rotator2_textlabel_in: TKnobsTextLabel;
    rotator2_textlabel_out: TKnobsTextLabel;
    unclick: TKnobsModule;
    unclick_out: TKnobsOutput;
    unclick_in: TKnobsInput;
    unclick_editlabel: TKnobsEditLabel;
    unclick_textlabel_in: TKnobsTextLabel;
    unclick_textlabel_out: TKnobsTextLabel;
    dif: TKnobsModule;
    dif_editlabel: TKnobsEditLabel;
    dif_out: TKnobsOutput;
    dif_in: TKnobsInput;
    dif_textlabel_out: TKnobsTextLabel;
    dif_textlabel_in: TKnobsTextLabel;
    dif_mode: TKnobsSelector;
    modal2_frequency: TKnobsInput;
    scalequantizer_textlabel_in: TKnobsTextLabel;
    modquantizer_textlabel_in: TKnobsTextLabel;
    lifeseq_sum1: TKnobsOutput;
    lifeseq_sum3: TKnobsOutput;
    lifeseq_sum5: TKnobsOutput;
    lifeseq_sum7: TKnobsOutput;
    lifeseq_sum9: TKnobsOutput;
    lifeseq_sum11: TKnobsOutput;
    lifeseq_sum13: TKnobsOutput;
    lifeseq_sum15: TKnobsOutput;
    lifeseq_sum17: TKnobsOutput;
    lifeseq_sum19: TKnobsOutput;
    lifeseq_sum21: TKnobsOutput;
    lifeseq_sum23: TKnobsOutput;
    lifeseq_sum25: TKnobsOutput;
    lifeseq_sum27: TKnobsOutput;
    lifeseq_sum29: TKnobsOutput;
    lifeseq_sum31: TKnobsOutput;
    lifeseq_sum2: TKnobsOutput;
    lifeseq_sum4: TKnobsOutput;
    lifeseq_sum6: TKnobsOutput;
    lifeseq_sum8: TKnobsOutput;
    lifeseq_sum10: TKnobsOutput;
    lifeseq_sum12: TKnobsOutput;
    lifeseq_sum14: TKnobsOutput;
    lifeseq_sum16: TKnobsOutput;
    lifeseq_sum18: TKnobsOutput;
    lifeseq_sum20: TKnobsOutput;
    lifeseq_sum22: TKnobsOutput;
    lifeseq_sum24: TKnobsOutput;
    lifeseq_sum26: TKnobsOutput;
    lifeseq_sum28: TKnobsOutput;
    lifeseq_sum30: TKnobsOutput;
    lifeseq_sum32: TKnobsOutput;
    smalllifeseq: TKnobsModule;
    smalllifeseq_editlabel: TKnobsEditLabel;
    smalllifeseq_xstep: TKnobsInput;
    smalllifeseq_indicator_xstep: TKnobsIndicator;
    smalllifeseq_rowout1: TKnobsOutput;
    smalllifeseq_rowout2: TKnobsOutput;
    smalllifeseq_rowout3: TKnobsOutput;
    smalllifeseq_rowout4: TKnobsOutput;
    smalllifeseq_rowout5: TKnobsOutput;
    smalllifeseq_grid: TKnobsGridControl;
    smalllifeseq_rowout6: TKnobsOutput;
    smalllifeseq_rowout7: TKnobsOutput;
    smalllifeseq_rowout8: TKnobsOutput;
    smalllifeseq_rowout9: TKnobsOutput;
    smalllifeseq_rowout10: TKnobsOutput;
    smalllifeseq_rowout11: TKnobsOutput;
    smalllifeseq_rowout12: TKnobsOutput;
    smalllifeseq_textlabel_faultrate: TKnobsTextLabel;
    smalllifeseq_textlabel_lowcount: TKnobsTextLabel;
    smalllifeseq_textlabel_randomamount: TKnobsTextLabel;
    smalllifeseq_textlabel_xstep: TKnobsTextLabel;
    smalllifeseq_change: TKnobsInput;
    smalllifeseq_textlabel_change: TKnobsTextLabel;
    smalllifeseq_res: TKnobsInput;
    smalllifeseq_indicator_res: TKnobsIndicator;
    smalllifeseq_textlabel_res: TKnobsTextLabel;
    smalllifeseq_indicator_change: TKnobsIndicator;
    smalllifeseq_rev: TKnobsInput;
    smalllifeseq_indicator_rev: TKnobsIndicator;
    smalllifeseq_textlabel_rev: TKnobsTextLabel;
    smalllifeseq_rowsum1: TKnobsOutput;
    smalllifeseq_rowsum2: TKnobsOutput;
    smalllifeseq_rowsum3: TKnobsOutput;
    smalllifeseq_rowsum4: TKnobsOutput;
    smalllifeseq_rowsum5: TKnobsOutput;
    smalllifeseq_rowsum6: TKnobsOutput;
    smalllifeseq_rowsum7: TKnobsOutput;
    smalllifeseq_rowsum8: TKnobsOutput;
    smalllifeseq_rowsum9: TKnobsOutput;
    smalllifeseq_rowsum10: TKnobsOutput;
    smalllifeseq_rowsum11: TKnobsOutput;
    smalllifeseq_rowsum12: TKnobsOutput;
    smalllifeseq_mode: TKnobsSelector;
    smalllifeseq_faultrate: TKnobsSmallKnob;
    smalllifeseq_display_faultrate: TKnobsDisplay;
    smalllifeseq_lowcount: TKnobsSmallKnob;
    smalllifeseq_display_lowcount: TKnobsDisplay;
    smalllifeseq_randomamount: TKnobsSmallKnob;
    smalllifeseq_display_randomamount: TKnobsDisplay;
    smalllifeseq_rnd: TKnobsSelector;
    smalllifeseq_wrapmode: TKnobsSelector;
    smalllifeseq_clr: TKnobsSelector;
    smalllifeseq_colout1: TKnobsOutput;
    smalllifeseq_colsum1: TKnobsOutput;
    smalllifeseq_colout2: TKnobsOutput;
    smalllifeseq_colsum2: TKnobsOutput;
    smalllifeseq_colout3: TKnobsOutput;
    smalllifeseq_colsum3: TKnobsOutput;
    smalllifeseq_colout4: TKnobsOutput;
    smalllifeseq_colsum4: TKnobsOutput;
    smalllifeseq_colout5: TKnobsOutput;
    smalllifeseq_colsum5: TKnobsOutput;
    smalllifeseq_colout6: TKnobsOutput;
    smalllifeseq_colsum6: TKnobsOutput;
    smalllifeseq_colout7: TKnobsOutput;
    smalllifeseq_colsum7: TKnobsOutput;
    smalllifeseq_colout8: TKnobsOutput;
    smalllifeseq_colsum8: TKnobsOutput;
    smalllifeseq_colout9: TKnobsOutput;
    smalllifeseq_colsum9: TKnobsOutput;
    smalllifeseq_colout10: TKnobsOutput;
    smalllifeseq_colsum10: TKnobsOutput;
    smalllifeseq_colout11: TKnobsOutput;
    smalllifeseq_colsum11: TKnobsOutput;
    smalllifeseq_colout12: TKnobsOutput;
    smalllifeseq_colsum12: TKnobsOutput;
    smalllifeseq_out: TKnobsOutput;
    smalllifeseq_sum: TKnobsOutput;
    smalllifeseq_ystep: TKnobsInput;
    smalllifeseq_indicator_ystep: TKnobsIndicator;
    smalllifeseq_textlabel_ystep: TKnobsTextLabel;
    quantizer_outinv: TKnobsOutput;
    quantizer_textlabel_out: TKnobsTextLabel;
    quantizer_textlabel_outinv: TKnobsTextLabel;
    vcps: TKnobsModule;
    vcps_editlabel: TKnobsEditLabel;
    vcps_textlabel_steps: TKnobsTextLabel;
    vcps_indicator_step1: TKnobsIndicator;
    vcps_indicator_step2: TKnobsIndicator;
    vcps_indicator_step3: TKnobsIndicator;
    vcps_indicator_step4: TKnobsIndicator;
    vcps_indicator_step5: TKnobsIndicator;
    vcps_indicator_step6: TKnobsIndicator;
    vcps_indicator_step7: TKnobsIndicator;
    vcps_indicator_step8: TKnobsIndicator;
    vcps_indicator_step9: TKnobsIndicator;
    vcps_indicator_step10: TKnobsIndicator;
    vcps_indicator_step11: TKnobsIndicator;
    vcps_indicator_step12: TKnobsIndicator;
    vcps_indicator_step13: TKnobsIndicator;
    vcps_indicator_step14: TKnobsIndicator;
    vcps_indicator_step15: TKnobsIndicator;
    vcps_indicator_step16: TKnobsIndicator;
    vcps_symbol_trig: TImage;
    vcps_trig: TKnobsInput;
    vcps_res: TKnobsInput;
    vcps_indicator_trig: TKnobsIndicator;
    vcps_indicator_reset: TKnobsIndicator;
    vcps_textlabel_trig: TKnobsTextLabel;
    vcps_textlabel_res: TKnobsTextLabel;
    vcps_dir: TKnobsInput;
    vcps_indicator_dir: TKnobsIndicator;
    vcps_textlabel_dir: TKnobsTextLabel;
    vcps_symbol_reset: TImage;
    vcps_inv: TKnobsInput;
    vcps_textlabel_inv: TKnobsTextLabel;
    vcps_indicator_inv: TKnobsIndicator;
    vcps_rnd2: TKnobsInput;
    vcps_textlabel_all: TKnobsTextLabel;
    vcps_outgate: TKnobsOutput;
    vcps_out: TKnobsOutput;
    vcps_rnd3: TKnobsInput;
    vcps_textlabel_1: TKnobsTextLabel;
    vcps_steps: TKnobsNoKnob;
    vcps_display_steps: TKnobsDisplay;
    vcps_step1: TKnobsSlider;
    vcps_step2: TKnobsSlider;
    vcps_step3: TKnobsSlider;
    vcps_step4: TKnobsSlider;
    vcps_step5: TKnobsSlider;
    vcps_step6: TKnobsSlider;
    vcps_step7: TKnobsSlider;
    vcps_step8: TKnobsSlider;
    vcps_step9: TKnobsSlider;
    vcps_step10: TKnobsSlider;
    vcps_step11: TKnobsSlider;
    vcps_step12: TKnobsSlider;
    vcps_step13: TKnobsSlider;
    vcps_step14: TKnobsSlider;
    vcps_step15: TKnobsSlider;
    vcps_step16: TKnobsSlider;
    vcps_mode: TKnobsSelector;
    vcps_rnd: TKnobsSelector;
    vcps_clr: TKnobsSelector;
    vcps_outtrig: TKnobsOutput;
    vcps_stepmode1: TKnobsSelector;
    vcps_stepmode2: TKnobsSelector;
    vcps_stepmode3: TKnobsSelector;
    vcps_stepmode4: TKnobsSelector;
    vcps_stepmode5: TKnobsSelector;
    vcps_stepmode6: TKnobsSelector;
    vcps_stepmode7: TKnobsSelector;
    vcps_stepmode8: TKnobsSelector;
    vcps_stepmode9: TKnobsSelector;
    vcps_stepmode10: TKnobsSelector;
    vcps_stepmode11: TKnobsSelector;
    vcps_stepmode12: TKnobsSelector;
    vcps_stepmode13: TKnobsSelector;
    vcps_stepmode14: TKnobsSelector;
    vcps_stepmode15: TKnobsSelector;
    vcps_stepmode16: TKnobsSelector;
    vcps_pattern: TKnobsInput;
    vcps_textlabel_pattern: TKnobsTextLabel;
    vcps_start: TKnobsSmallKnob;
    vcps_length: TKnobsSmallKnob;
    vcps_textlabel_att: TKnobsTextLabel;
    vcps_textlabel_offs: TKnobsTextLabel;
    vcps_indicator_gateout: TKnobsIndicator;
    vcps_indicator_trigout: TKnobsIndicator;
    vcps_textlabel_out: TKnobsTextLabel;
    vcps_textlabel_gateout: TKnobsTextLabel;
    vcps_textlabel_trigout: TKnobsTextLabel;
    vcps_stepsmod: TKnobsInput;
    vcps_clr2: TKnobsInput;
    autoquantizer: TKnobsModule;
    autoquantizer_editlabel: TKnobsEditLabel;
    autoquantizer_out: TKnobsOutput;
    autoquantizer_textlabel_out: TKnobsTextLabel;
    autoquantizer_learn: TKnobsInput;
    autoquantizer_textlabel_learn: TKnobsTextLabel;
    autoquantizer_symbol_clock: TImage;
    autoquantizer_clock: TKnobsInput;
    autoquantizer_indicator_clock: TKnobsIndicator;
    autoquantizer_history: TKnobsSmallKnob;
    autoquantizer_display_history: TKnobsDisplay;
    autoquantizer_textlabel_history: TKnobsTextLabel;
    autoquantizer_historymod: TKnobsInput;
    autoquantizer_in: TKnobsInput;
    autoquantizer_textlabel_in: TKnobsTextLabel;
    autoquantizer_textlabel_range: TKnobsTextLabel;
    autoquantizer_rangemod: TKnobsInput;
    autoquantizer_range: TKnobsSmallKnob;
    autoquantizer_changed: TKnobsOutput;
    autoquantizer_textlabel_change: TKnobsTextLabel;
    autoquantizer_indicator_pulse: TKnobsIndicator;
    notesplit: TKnobsModule;
    notesplit_editlabel: TKnobsEditLabel;
    notesplit_note: TKnobsOutput;
    notesplit_in: TKnobsInput;
    notesplit_textlabel_note: TKnobsTextLabel;
    notesplit_textlabel_in: TKnobsTextLabel;
    notesplit_octave: TKnobsOutput;
    notesplit_textlabel_octave: TKnobsTextLabel;
    notemerge: TKnobsModule;
    notemerge_editlabel: TKnobsEditLabel;
    notemerge_out: TKnobsOutput;
    notemerge_octave: TKnobsInput;
    notemerge_textlabel_out: TKnobsTextLabel;
    notemerge_textlabel_octave: TKnobsTextLabel;
    notemerge_textlabel_note: TKnobsTextLabel;
    notemerge_note: TKnobsInput;
    queue: TKnobsModule;
    queue_editlabel: TKnobsEditLabel;
    queue_in: TKnobsInput;
    queue_out: TKnobsOutput;
    queue_clock: TKnobsInput;
    queue_textlabel_clock: TKnobsTextLabel;
    queue_textlabel_indicator_clock: TKnobsIndicator;
    queue_textlabel_maxsize: TKnobsTextLabel;
    queue_display_history: TKnobsDisplay;
    queue_history: TKnobsNoKnob;
    queue_textlabel_in: TKnobsTextLabel;
    queue_historymod: TKnobsInput;
    queue_selectmod: TKnobsInput;
    queue_textlabel_select: TKnobsTextLabel;
    queue_select: TKnobsSmallKnob;
    queue_selectmodamt: TKnobsSmallKnob;
    queue_xfademod: TKnobsInput;
    queue_xfade: TKnobsSmallKnob;
    queue_textlabel_xfade: TKnobsTextLabel;
    queue_textlabel_out: TKnobsTextLabel;
    findnearest: TKnobsModule;
    findnearest_editlabel: TKnobsEditLabel;
    findnearest_out: TKnobsOutput;
    findnearest_textlabel_out: TKnobsTextLabel;
    findnearest_learn: TKnobsInput;
    findnearest_textlabel_learn: TKnobsTextLabel;
    findnearest_symbol_clock: TImage;
    findnearest_clock: TKnobsInput;
    findnearest_indicator_clock: TKnobsIndicator;
    findnearest_textlabel_history: TKnobsTextLabel;
    findnearest_historymod: TKnobsInput;
    findnearest_in: TKnobsInput;
    findnearest_textlabel_in: TKnobsTextLabel;
    findnearest_textlabel_range: TKnobsTextLabel;
    findnearest_rangemod: TKnobsInput;
    findnearest_changed: TKnobsOutput;
    findnearest_textlabel_change: TKnobsTextLabel;
    findnearest_indicatorpulse_: TKnobsIndicator;
    findnearest_history: TKnobsSmallKnob;
    findnearest_display_history: TKnobsDisplay;
    findnearest_range: TKnobsSmallKnob;
    logicselector_indicator_select: TKnobsIndicator;
    vitaphobium: TKnobsModule;
    vitaphobium_editlabel: TKnobsEditLabel;
    vitaphobium_step: TKnobsInput;
    vitaphobium_indicator_step: TKnobsIndicator;
    vitaphobium_grid: TKnobsGridControl;
    vitaphobium_textlabel_faultrate: TKnobsTextLabel;
    vitaphobium_textlabel_randomamount: TKnobsTextLabel;
    vitaphobium_textlabel_step: TKnobsTextLabel;
    vitaphobium_change: TKnobsInput;
    vitaphobium_textlabel_change: TKnobsTextLabel;
    vitaphobium_res: TKnobsInput;
    vitaphobium_indicator_res: TKnobsIndicator;
    vitaphobium_textlabel_reset: TKnobsTextLabel;
    vitaphobium_indicator_change: TKnobsIndicator;
    vitaphobium_rev: TKnobsInput;
    vitaphobium_indicator_rev: TKnobsIndicator;
    vitaphobium_textlabel_reverse: TKnobsTextLabel;
    vitaphobium_gate: TKnobsOutput;
    vitaphobium_out: TKnobsOutput;
    vitaphobium_mode: TKnobsSelector;
    vitaphobium_faultrate: TKnobsSmallKnob;
    vitaphobium_display_faultrate: TKnobsDisplay;
    vitaphobium_randomamount: TKnobsSmallKnob;
    vitaphobium_display_randomamount: TKnobsDisplay;
    vitaphobium_rnd: TKnobsSelector;
    vitaphobium_wrapmode: TKnobsSelector;
    vitaphobium_clr: TKnobsSelector;
    vitaphobium_in: TKnobsInput;
    vitaphobium_clock: TKnobsInput;
    vitaphobium_textlabel_clock: TKnobsTextLabel;
    vitaphobium_indicator_clock: TKnobsIndicator;
    vitaphobium_textlabel_in: TKnobsTextLabel;
    vitaphobium_textlabel_gate: TKnobsTextLabel;
    vitaphobium_trig: TKnobsOutput;
    vitaphobium_textlabel_trig: TKnobsTextLabel;
    vitaphobium_textlabel_out: TKnobsTextLabel;
    vitaphobium_symbol_step: TImage;
    vitaphobium_symbol_reset: TImage;
    vitaphobium_symbol_clock: TImage;
    vitaphobium_indicator_gate: TKnobsIndicator;
    vitaphobium_indicator_trig: TKnobsIndicator;
    vitaphobium_x: TKnobsInput;
    vitaphobium_textlabel_xy: TKnobsTextLabel;
    vitaphobium_y: TKnobsInput;
    changedetector: TKnobsModule;
    changedetector_editlabel: TKnobsEditLabel;
    changedetector_out: TKnobsOutput;
    changedetector_in: TKnobsInput;
    changedetector_textlabel_out: TKnobsTextLabel;
    changedetector_textlabel_in: TKnobsTextLabel;
    changedetector_trig: TKnobsOutput;
    changedetector_textlabel_trig: TKnobsTextLabel;
    changedetector_indicator_trig: TKnobsIndicator;
    changedetector_mode: TKnobsSelector;
    envar_amod: TKnobsInput;
    envar_rmod: TKnobsInput;
    vitaphobium_skipmode: TKnobsSelector;
    vitaphobium_skipctrl: TKnobsInput;
    vitaphobium_indicator_skipctrl: TKnobsIndicator;
    vitaphobium_textlabel_skiptoggle: TKnobsTextLabel;
    vitaphobium_xout: TKnobsOutput;
    vitaphobium_yout: TKnobsOutput;
    vitaphobium_textlabel_outx: TKnobsTextLabel;
    vitaphobium_textlabel_outy: TKnobsTextLabel;
    seq16_outraw: TKnobsOutput;
    seq16_outraw2: TKnobsOutput;
    seq16_outraw3: TKnobsOutput;
    seq16_outraw4: TKnobsOutput;
    seq16_textlabel_r: TKnobsTextLabel;
    seq16_textlabel_x: TKnobsTextLabel;
    lut_outraw: TKnobsOutput;
    lut_outraw2: TKnobsOutput;
    lut_outraw4: TKnobsOutput;
    lut_outraw3: TKnobsOutput;
    lut_textlabel_r: TKnobsTextLabel;
    lut_textlabel_x: TKnobsTextLabel;
    scalequantizer_changed: TKnobsOutput;
    scalequantizer_textlabel_changed: TKnobsTextLabel;
    scalequantizer_textlabel_out: TKnobsTextLabel;
    scalequantizer_indicator_changed: TKnobsIndicator;
    poetry_changed: TKnobsOutput;
    poetry_textlabel_chgnout: TKnobsTextLabel;
    poetry_indicator_changed: TKnobsIndicator;
    ammod_fxmod: TKnobsInput;
    ammod_textlabel_fxmod: TKnobsTextLabel;
    ammod_fxmodamt: TKnobsSmallKnob;
    randsigs_outinv1: TKnobsOutput;
    randsigs_outinv2: TKnobsOutput;
    randsigs_outinv3: TKnobsOutput;
    randsigs_outinv4: TKnobsOutput;
    randsigs_outinv5: TKnobsOutput;
    randsigs_outinv6: TKnobsOutput;
    randsigs_outinv7: TKnobsOutput;
    randsigs_outinv8: TKnobsOutput;
    randsigs_textlabel_inv: TKnobsTextLabel;
    randsigs_textlabel_out: TKnobsTextLabel;
    sapivoice: TKnobsModule;
    sapivoice_editlabel: TKnobsEditLabel;
    sapivoice_speed: TKnobsInput;
    sapivoice_textlabel_speed: TKnobsTextLabel;
    sapivoice_textlabel_duration: TKnobsTextLabel;
    sapivoice_textlabel_pos: TKnobsTextLabel;
    sapivoice_pos: TKnobsInput;
    sapivoice_symbol_res: TImage;
    sapivoice_res: TKnobsInput;
    sapivoice_indicator_res: TKnobsIndicator;
    sapivoice_textlabel_res: TKnobsTextLabel;
    sapivoice_out: TKnobsOutput;
    sapivoice_fm: TKnobsInput;
    sapivoice_textlabel_fm: TKnobsTextLabel;
    sapivoice_display_text: TKnobsDisplay;
    sapivoice_mute: TKnobsSelector;
    sapivoice_voice: TKnobsSelector;
    sapivoice_textlabel_voicename: TKnobsTextLabel;
    sapivoice_textlabel_loading: TKnobsTextLabel;
    sapivoice_indicator_loading: TKnobsIndicator;
    sapivoice_rate: TKnobsSelector;
    sapivoice_textlabel_rate: TKnobsTextLabel;
    espeakvoice: TKnobsModule;
    espeakvoice_editlabel: TKnobsEditLabel;
    espeakvoice_speedmod: TKnobsInput;
    espeakvoice_textlabel_speed: TKnobsTextLabel;
    espeakvoice_textlabel_duration: TKnobsTextLabel;
    espeakvoice_textlabel_pos: TKnobsTextLabel;
    espeakvoice_pos: TKnobsInput;
    espeakvoice_symbol_res: TImage;
    espeakvoice_res: TKnobsInput;
    espeakvoice_indicator_res: TKnobsIndicator;
    espeakvoice_textlabel_res: TKnobsTextLabel;
    espeakvoice_out: TKnobsOutput;
    espeakvoice_fmmod: TKnobsInput;
    espeakvoice_textlabel_fm: TKnobsTextLabel;
    espeakvoice_textlabel_voicename: TKnobsTextLabel;
    espeakvoice_textlabel_loading: TKnobsTextLabel;
    espeakvoice_indicator_loading: TKnobsIndicator;
    espeakvoice_display_text: TKnobsDisplay;
    espeakvoice_mute: TKnobsSelector;
    espeakvoice_voice: TKnobsSelector;
    espeakvoice_language: TKnobsSelector;
    espeakvoice_textlabel_languagedetails: TKnobsTextLabel;
    espeakvoice_variation: TKnobsSelector;
    espeakvoice_textlabel_variation: TKnobsTextLabel;
    espeakvoice_textstart: TKnobsOutput;
    espeakvoice_phoneme: TKnobsOutput;
    espeakvoice_textlabel_phonemelabel: TKnobsTextLabel;
    espeakvoice_textlabel_textstart: TKnobsTextLabel;
    espeakvoice_vowel: TKnobsOutput;
    espeakvoice_silence: TKnobsOutput;
    espeakvoice_textlabel_vowel: TKnobsTextLabel;
    espeakvoice_textlabel_silence: TKnobsTextLabel;
    espeakvoice_textdone: TKnobsOutput;
    espeakvoice_textlabel_textdone: TKnobsTextLabel;
    espeakvoice_indicator_textstart: TKnobsIndicator;
    espeakvoice_textlabel_out: TKnobsTextLabel;
    espeakvoice_indicator_textdone: TKnobsIndicator;
    espeakvoice_indicator_phoneme: TKnobsIndicator;
    espeakvoice_indicator_vowel: TKnobsIndicator;
    espeakvoice_indicator_silence: TKnobsIndicator;
    espeakvoice_sentence: TKnobsOutput;
    espeakvoice_textlabel_sentence: TKnobsTextLabel;
    espeakvoice_word: TKnobsOutput;
    espeakvoice_textlabel_word: TKnobsTextLabel;
    espeakvoice_indicator_sentence: TKnobsIndicator;
    espeakvoice_indicator_word: TKnobsIndicator;
    espeakvoice_mark: TKnobsOutput;
    espeakvoice_usermark: TKnobsOutput;
    espeakvoice_textlabel_marklabel: TKnobsTextLabel;
    espeakvoice_textlabel_usermark: TKnobsTextLabel;
    espeakvoice_indicator_mark: TKnobsIndicator;
    espeakvoice_indicator_usermark: TKnobsIndicator;
    espeakvoice_punctuation: TKnobsSelector;
    espeakvoice_textlabel_punctuation: TKnobsTextLabel;
    espeakvoice_rate: TKnobsSmallKnob;
    espeakvoice_display_rate: TKnobsDisplay;
    espeakvoice_textlabel_rate: TKnobsTextLabel;
    espeakvoice_pitch: TKnobsSmallKnob;
    espeakvoice_display_pitch: TKnobsDisplay;
    espeakvoice_textlabel_pitch: TKnobsTextLabel;
    espeakvoice_range: TKnobsSmallKnob;
    espeakvoice_display_range: TKnobsDisplay;
    espeakvoice_textlabel_range: TKnobsTextLabel;
    espeakvoice_wordgap: TKnobsSmallKnob;
    espeakvoice_display_wordgap: TKnobsDisplay;
    espeakvoice_textlabel_wordgap: TKnobsTextLabel;
    espeakvoice_knobbox_nonrealtime: TKnobsBox;
    espeakvoice_freq: TKnobsSmallKnob;
    espeakvoice_display_freq: TKnobsDisplay;
    espeakvoice_fmmodamt: TKnobsSmallKnob;
    espeakvoice_textlabel_freq: TKnobsTextLabel;
    espeakvoice_frequency: TKnobsInput;
    espeakvoice_posmod: TKnobsInput;
    espeakvoice_posmodamt: TKnobsSmallKnob;
    espeakvoice_speed: TKnobsSmallKnob;
    espeakvoice_speedmodamt: TKnobsSmallKnob;
    espeakvoice_textlabel_sm: TKnobsTextLabel;
    espeakvoice_cents: TKnobsSmallKnob;
    espeakvoice_display_cents: TKnobsDisplay;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
 // FLastPseudoId          : TKnobsModuleType;
    FModules               : TKnobsModuleList;
    FMarkDownProcessor     : TMarkDownProcessor;
    FOnDesignerLog         : TKnobsOnLog;
    FTitleFont             : TFont;
    FModuleFont            : TFont;
    FConnectorBorders      : Boolean;
    FConnectorTypedBorders : Boolean;
    FGroupIOColor          : TColor;
    FGroupOSCColor         : TColor;
    FGroupLFOColor         : TColor;
    FGroupEnvColor         : TColor;
    FGroupFilterColor      : TColor;
    FGroupSwitchColor      : TColor;
    FGroupMixColor         : TColor;
    FGroupControlColor     : TColor;
    FGroupNoteColor        : TColor;
    FGroupMathColor        : TColor;
    FGroupLogicColor       : TColor;
    FGroupSeqColor         : TColor;
    FGroupGeneratorColor   : TColor;
    FGroupFXColor          : TColor;
    FGroupDelayColor       : TColor;
    FGroupVoiceColor       : TColor;
    FGroupUtilityColor     : TColor;
    FConnectorBorderColor  : TColor;
    FSelectorColor         : TColor;
    FSelectorBorderColor   : TColor;
    FSelectorBorderColorS  : TColor;
    FDisplayColor          : TColor;
    FDisplayBorderColor    : TColor;
    FKnobMIDIColor         : TColor;
    FKnobFocusColor        : TColor;
    FKnobMIDIFocusColor    : TColor;
    FViewerColor           : TColor;
    FViewerBorderColor     : TColor;
    FViewerLineColor       : TColor;
    FViewerFillColor       : TColor;
    FIndBarPeakColor       : TColor;
    FIndBarValeyColor      : TColor;
    FModuleOpacity         : Byte;
  private
    procedure   ChangeTabColor( const aTabSheet: TTabSheet; aColor: TColor);
    procedure   SetTitleFont            ( const aValue: TFont);
    procedure   SetModuleFont           ( const aValue: TFont);
    procedure   SetConnectorBorders     ( aValue: Boolean);
    procedure   SetConnectorTypedBorders( aValue: Boolean);
    procedure   SetGroupIOColor         ( aValue: TColor);
    procedure   SetGroupOSCColor        ( aValue: TColor);
    procedure   SetGroupLFOColor        ( aValue: TColor);
    procedure   SetGroupEnvColor        ( aValue: TColor);
    procedure   SetGroupFilterColor     ( aValue: TColor);
    procedure   SetGroupSwitchColor     ( aValue: TColor);
    procedure   SetGroupMixColor        ( aValue: TColor);
    procedure   SetGroupControlColor    ( aValue: TColor);
    procedure   SetGroupNoteColor       ( aValue: TColor);
    procedure   SetGroupMathColor       ( aValue: TColor);
    procedure   SetGroupLogicColor      ( aValue: TColor);
    procedure   SetGroupSeqColor        ( aValue: TColor);
    procedure   SetGroupGeneratorColor  ( aValue: TColor);
    procedure   SetGroupFXColor         ( aValue: TColor);
    procedure   SetGroupDelayColor      ( aValue: TColor);
    procedure   SetGroupVoiceColor      ( aValue: TColor);
    procedure   SetGroupUtilityColor    ( aValue: TColor);
    procedure   SetConnectorBorderColor ( aValue: TColor);
    procedure   SetSelectorColor        ( aValue: TColor);
    procedure   SetSelectorBorderColor  ( aValue: TColor);
    procedure   SetSelectorBorderColorS ( aValue: TColor);
    procedure   SetDisplayColor         ( aValue: TColor);
    procedure   SetDisplayBorderColor   ( aValue: TColor);
    procedure   SetKnobMIDIColor        ( aValue: TColor);
    procedure   SetKnobFocusColor       ( aValue: TColor);
    procedure   SetKnobMIDIFocusColor   ( aValue: TColor);
    procedure   SetViewerColor          ( aValue: TColor);
    procedure   SetViewerBorderColor    ( aValue: TColor);
    procedure   SetViewerLineColor      ( aValue: TColor);
    procedure   SetViewerFillColor      ( aValue: TColor);
    procedure   SetIndBarPeakColor      ( aValue: TColor);
    procedure   SetIndBarValeyColor     ( aValue: TColor);
    procedure   SetModuleOpacity        ( aValue: Byte);
  private
    procedure   DoModuleListLog( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    procedure   DoModuleLog    ( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    procedure   Log( aLogClass: TLogClass; anIndent: Integer; const aMsg: string);
    procedure   LogFmt( aLogClass: TLogClass; anIndent: Integer; const aFmt: string; const anArgs: array of const);
  public
    function    CreateModule(
      const aWirePanel  : TKnobsWirePanel;
      const aModuleType : TKnobsModuleType;
      MustDrag          : Boolean;
      StandardColor     : Boolean
    ): TKnobsCustomModule;

    function    ChangeModule(
      const aWirePanel  : TKnobsWirePanel;
      var   aTarget     : TKnobsCustomModule;
      const aWantedType : TKnobsModuleType;
      aCallBack         : TKnobsOnValuedCtrlRemoved
    ): TKnobsCustomModule;

    procedure   PopulateSelector  ( const aModuleSelector: TKnobsModuleSelector; const aBitmapsFolder: string);
    procedure   UnpopulateSelector( const aModuleSelector: TKnobsModuleSelector);
    procedure   PopulateMenu      ( const aRootMenu: TMenuItem; const aHandler: TNotifyEvent);
    procedure   ShowModule        ( const aModule: TKnobsCustomModule);
    function    BitmapName        ( const aModuleType: TKnobsModuleType): string;
    function    CreateModuleBitmap( const aModuleType: TKnobsModuleType): TBitmap;
    function    ReadModuleComment ( const aModuleType: TKnobsModuleType): string;
    procedure   MakeImage         ( const aFolder: string; const aModule: TKnobsCustomModule);
    procedure   MakeImages        ( const aFolder: string);
    function    FindBitmap        ( const aModuleTitle: string): TBitmap;
    function    DocumentModule    ( const aModule: TKnobsCustomModule; const anImagesFolder: string; anIndex: Integer; OddColor: Boolean): string;
    function    MakeDocIndex      : string;
    function    MakeDocHeader     ( const aVersion: string): string;
    function    MakeDocFooter     : string;
    function    DoDocument        ( const aFolder, anImagesFolder, aVersion: string): string;
    procedure   Document          ( const aFolder, anImagesFolder, aVersion: string);
    function    GetTabColor       ( const aSender: TObject; const aTabName: string; aMixColor: TColor; aMix: Byte): TColor;
    function    DefaultModuleColor( const aModuleType: TKnobsModuleType; const aDefaultColor: TColor): TColor;
    procedure   LoadControlGlyph  ( const aFolder, aFile: string; aList: TImageList; anIndex: Integer);
    procedure   LoadControlGlyphs ( const aFolder: string);
    function    CreatePageNames: TStringList;
    function    CreateBlankControlTypeList: TStringList;
    function    CreateMazeTypes: TStringList;
    procedure   RegisterModule( aModule: TKnobsCustomModule);
  public
    procedure   RegisterModules;
  public
    property    Modules               : TKnobsModuleList read FModules;
    property    OnDesignerLog         : TKnobsOnLog      read FOnDesignerLog         write FOnDesignerLog;
    property    TitleFont             : TFont            read FTitleFont             write SetTitleFont;
    property    ModuleFont            : TFont            read FModuleFont            write SetModuleFont;
    property    ConnectorBorders      : Boolean          read FConnectorBorders      write SetConnectorBorders;
    property    ConnectorTypedBorders : Boolean          read FConnectorTypedBorders write SetConnectorTypedBorders;
    property    GroupIOColor          : TColor           read FGroupIOColor          write SetGroupIOColor;
    property    GroupOSCColor         : TColor           read FGroupOSCColor         write SetGroupOSCColor;
    property    GroupLFOColor         : TColor           read FGroupLFOColor         write SetGroupLFOColor;
    property    GroupEnvColor         : TColor           read FGroupEnvColor         write SetGroupEnvColor;
    property    GroupFilterColor      : TColor           read FGroupFilterColor      write SetGroupFilterColor;
    property    GroupSwitchColor      : TColor           read FGroupSwitchColor      write SetGroupSwitchColor;
    property    GroupMixColor         : TColor           read FGroupMixColor         write SetGroupMixColor;
    property    GroupControlColor     : TColor           read FGroupControlColor     write SetGroupControlColor;
    property    GroupNoteColor        : TColor           read FGroupNoteColor        write SetGroupNoteColor;
    property    GroupMathColor        : TColor           read FGroupMathColor        write SetGroupMathColor;
    property    GroupLogicColor       : TColor           read FGroupLogicColor       write SetGroupLogicColor;
    property    GroupSeqColor         : TColor           read FGroupSeqColor         write SetGroupSeqColor;
    property    GroupGeneratorColor   : TColor           read FGroupGeneratorColor   write SetGroupGeneratorColor;
    property    GroupFXColor          : TColor           read FGroupFXColor          write SetGroupFXColor;
    property    GroupDelayColor       : TColor           read FGroupDelayColor       write SetGroupDelayColor;
    property    GroupVoiceColor       : TColor           read FGroupVoiceColor       write SetGroupVoiceColor;
    property    GroupUtilityColor     : TColor           read FGroupUtilityColor     write SetGroupUtilityColor;
    property    ConnectorBorderColor  : TColor           read FConnectorBorderColor  write SetConnectorBorderColor;
    property    SelectorColor         : TColor           read FSelectorColor         write SetSelectorColor;
    property    SelectorBorderColor   : TColor           read FSelectorBorderColor   write SetSelectorBorderColor;
    property    SelectorBorderColorS  : TColor           read FSelectorBorderColorS  write SetSelectorBorderColorS;
    property    DisplayColor          : TColor           read FDisplayColor          write SetDisplayColor;
    property    DisplayBorderColor    : TColor           read FDisplayBorderColor    write SetDisplayBorderColor;
    property    KnobMIDIColor         : TColor           read FKnobMIDIColor         write SetKnobMIDIColor;
    property    KnobFocusColor        : TColor           read FKnobFocusColor        write SetKnobFocusColor;
    property    KnobMIDIFocusColor    : TColor           read FKnobMIDIFocusColor    write SetKnobMIDIFocusColor;
    property    ViewerColor           : TColor           read FViewerColor           write SetViewerColor;
    property    ViewerBorderColor     : TColor           read FViewerBorderColor     write SetViewerBorderColor;
    property    ViewerLineColor       : TColor           read FViewerLineColor       write SetViewerLineColor;
    property    ViewerFillColor       : TColor           read FViewerFillColor       write SetViewerFillColor;
    property    IndBarPeakColor       : TColor           read FIndBarPeakColor       write SetIndBarPeakColor;
    property    IndBarValeyColor      : TColor           read FIndBarValeyColor      write SetIndBarValeyColor;
    property    ModuleOpacity         : Byte             read FModuleOpacity         write SetModuleOpacity;
  end;


var

  FormStore: TFormStore;


implementation


{$R *.DFM}


// User area


//  private


    // -------------------------------------------------------------------------


    procedure   TFormStore.SetTitleFont( const aValue: TFont);
    var
      i : Integer;
    begin
      if Assigned( FTitleFont) and Assigned( aValue)
      then begin
        FTitleFont.Assign( aValue);

        for i := 0 to FModules.Count - 1
        do FModules[ i].SetTitleFont( FTitleFont);
      end;
    end;


    procedure   TFormStore.SetModuleFont( const aValue: TFont);
    var
      i : Integer;
    begin
      if Assigned( FModuleFont) and Assigned( aValue)
      then begin
        FModuleFont.Assign( aValue);

        for i := 0 to FModules.Count - 1
        do FModules[ i].SetModuleFont( FModuleFont);
      end;
    end;


    procedure   TFormStore.ChangeTabColor( const aTabSheet: TTabSheet; aColor: TColor);
    var
      i : Integer;
    begin
      if Assigned( aTabSheet)
      then begin
        for i := 0 to aTabSheet.ControlCount - 1
        do begin
          if aTabSheet.Controls[ i] is TKnobsCustomModule
          then TKnobsCustomModule( aTabSheet.Controls[ i]).Color := aColor;
        end;
      end;
    end;


    procedure   TFormStore.SetConnectorBorders( aValue: Boolean);
    var
      i : Integer;
    begin
      if aValue <> FConnectorBorders
      then begin
        FConnectorBorders := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].UseConnectorBorders := aValue;
      end;
    end;


    procedure   TFormStore.SetConnectorTypedBorders( aValue: Boolean);
    var
      i : Integer;
    begin
      if aValue <> FConnectorTypedBorders
      then begin
        FConnectorTypedBorders := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].UseTypedConnectorBorders := aValue;
      end;
    end;


    procedure   TFormStore.SetGroupIOColor( aValue: TColor);
    begin
      if aValue <> FGroupIOColor
      then begin
        FGroupIOColor := aValue;
        ChangeTabColor( inout_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupOSCColor( aValue: TColor);
    begin
      if aValue <> FGroupOSCColor
      then begin
        FGroupOSCColor := aValue;
        ChangeTabColor( osc_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupLFOColor( aValue: TColor);
    begin
      if aValue <> FGroupLFOColor
      then begin
        FGroupLFOColor := aValue;
        ChangeTabColor( lfo_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupEnvColor( aValue: TColor);
    begin
      if aValue <> FGroupEnvColor
      then begin
        FGroupEnvColor := aValue;
        ChangeTabColor( envelope_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupFilterColor( aValue: TColor);
    begin
      if aValue <> FGroupFilterColor
      then begin
        FGroupFilterColor := aValue;
        ChangeTabColor( filter_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupSwitchColor( aValue: TColor);
    begin
      if aValue <> FGroupSwitchColor
      then begin
        FGroupSwitchColor := aValue;
        ChangeTabColor( switch_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupMixColor( aValue: TColor);
    begin
      if aValue <> FGroupMixColor
      then begin
        FGroupMixColor := aValue;
        ChangeTabColor( mixer_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupControlColor( aValue: TColor);
    begin
      if aValue <> FGroupControlColor
      then begin
        FGroupControlColor := aValue;
        ChangeTabColor( control1_tabsheet, aValue);
        ChangeTabColor( control2_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupNoteColor( aValue: TColor);
    begin
      if aValue <> FGroupNoteColor
      then begin
        FGroupNoteColor := aValue;
        ChangeTabColor( note_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupMathColor( aValue: TColor);
    begin
      if aValue <> FGroupMathColor
      then begin
        FGroupMathColor := aValue;
        ChangeTabColor( math_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupLogicColor( aValue: TColor);
    begin
      if aValue <> FGroupLogicColor
      then begin
        FGroupLogicColor := aValue;
        ChangeTabColor( logic_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupSeqColor( aValue: TColor);
    begin
      if aValue <> FGroupSeqColor
      then begin
        FGroupSeqColor := aValue;
        ChangeTabColor( sequencer1_tabsheet, aValue);
        ChangeTabColor( sequencer2_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupGeneratorColor( aValue: TColor);
    begin
      if aValue <> FGroupGeneratorColor
      then begin
        FGroupGeneratorColor := aValue;
        ChangeTabColor( generator_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupFXColor( aValue: TColor);
    begin
      if aValue <> FGroupFXColor
      then begin
        FGroupFXColor := aValue;
        ChangeTabColor( fx_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupDelayColor( aValue: TColor);
    begin
      if aValue <> FGroupDelayColor
      then begin
        FGroupDelayColor := aValue;
        ChangeTabColor( delay_tabseet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupVoiceColor( aValue: TColor);
    begin
      if aValue <> FGroupVoiceColor
      then begin
        FGroupVoiceColor := aValue;
        ChangeTabColor( voice_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetGroupUtilityColor( aValue: TColor);
    begin
      if aValue <> FGroupUtilityColor
      then begin
        FGroupUtilityColor := aValue;
        ChangeTabColor( util_tabsheet, aValue);
      end;
    end;


    procedure   TFormStore.SetConnectorBorderColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FConnectorBorderColor
      then begin
        FConnectorBorderColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].ConnectorBorderColor := aValue;
      end;
    end;


    procedure   TFormStore.SetSelectorColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FSelectorColor
      then begin
        FSelectorColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].SelectorColor := aValue;
      end;
    end;


    procedure   TFormStore.SetSelectorBorderColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FSelectorBorderColor
      then begin
        FSelectorBorderColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].SelectorBorderColor := aValue;
      end;
    end;


    procedure   TFormStore.SetSelectorBorderColorS( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FSelectorBorderColorS
      then begin
        FSelectorBorderColorS := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].SelectorBorderColorSingle := aValue;
      end;
    end;


    procedure   TFormStore.SetDisplayColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FDisplayColor
      then begin
        FDisplayColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].DisplayColor := aValue;
      end;
    end;


    procedure   TFormStore.SetDisplayBorderColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FDisplayBorderColor
      then begin
        FDisplayBorderColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].DisplayBorderColor := aValue;
      end;
    end;


    procedure   TFormStore.SetKnobMIDIColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FKnobMIDIColor
      then begin
        FKnobMIDIColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].KnobMIDIColor := aValue;
      end;
    end;


    procedure   TFormStore.SetKnobFocusColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FKnobFocusColor
      then begin
        FKnobFocusColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].KnobFocusColor := aValue;
      end;
    end;


    procedure   TFormStore.SetKnobMIDIFocusColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FKnobMIDIFocusColor
      then begin
        FKnobMIDIFocusColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].KnobMIDIFocusColor := aValue;
      end;
    end;


    procedure   TFormStore.SetViewerColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FViewerColor
      then begin
        FViewerColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].ViewerColor := aValue;
      end;
    end;


    procedure   TFormStore.SetViewerBorderColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FViewerBorderColor
      then begin
        FViewerBorderColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].ViewerBorderColor := aValue;
      end;
    end;


    procedure   TFormStore.SetViewerLineColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FViewerLineColor
      then begin
        FViewerLineColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].ViewerLineColor := aValue;
      end;
    end;


    procedure   TFormStore.SetViewerFillColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FViewerFillColor
      then begin
        FViewerFillColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].ViewerFillColor := aValue;
      end;
    end;


    procedure   TFormStore.SetIndBarPeakColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FIndBarPeakColor
      then begin
        FIndBarPeakColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].IndBarPeakColor := aValue;
      end;
    end;


    procedure   TFormStore.SetIndBarValeyColor( aValue: TColor);
    var
      i : Integer;
    begin
      if aValue <> FIndBarValeyColor
      then begin
        FIndBarValeyColor := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].IndBarValeyColor := aValue;
      end;
    end;


    procedure   TFormStore.SetModuleOpacity( aValue: Byte);
    var
      i : Integer;
    begin
      if aValue <> FModuleOpacity
      then begin
        FModuleOpacity := aValue;

        for i := 0 to FModules.Count - 1
        do FModules[ i].Opacity := aValue;
      end;
    end;


//  private

    procedure   TFormStore.DoModuleListLog( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    begin
      LogFmt( aLogClass, 0, 'ModuleList (%s)', [ aMsg]);
    end;


    procedure   TFormStore.DoModuleLog( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    begin
      LogFmt( aLogClass, 0, 'Module (%s)', [ aMsg]);
    end;


    procedure   TFormStore.Log( aLogClass: TLogClass; anIndent: Integer; const aMsg: string);
    begin
      if Assigned( FOnDesignerLog)
      then FOnDesignerLog( Self, aLogClass, Format( '%sdesigner : %s', [ Indent( anIndent), aMsg], AppLocale));
    end;


    procedure   TFormStore.LogFmt( aLogClass: TLogClass; anIndent: Integer; const aFmt: string; const anArgs: array of const);
    begin
      Log( aLogClass, anIndent, Format( aFmt, anArgs, AppLocale));
    end;


//  public

    function    TFormStore.CreateModule(
      const aWirePanel  : TKnobsWirePanel;
      const aModuleType : TKnobsModuleType;
      MustDrag          : Boolean;
      StandardColor     : Boolean
    ): TKnobsCustomModule;
    begin
      Result := Modules.CreateModule( aWirePanel, aModuleType, MustDrag, StandardColor);
    end;


    function    TFormStore.ChangeModule(
      const aWirePanel  : TKnobsWirePanel;
      var   aTarget     : TKnobsCustomModule;
      const aWantedType : TKnobsModuleType;
      aCallBack         : TKnobsOnValuedCtrlRemoved
    ): TKnobsCustomModule;
    begin
      Result := Modules.ChangeModule( aWirePanel, aTarget, aWantedType, aCallBack);
    end;


    procedure   TFormStore.PopulateSelector( const aModuleSelector: TKnobsModuleSelector; const aBitmapsFolder: string);
    begin
      Modules.PopulateSelector( aModuleSelector, aBitmapsFolder);
    end;


    procedure   TFormStore.UnpopulateSelector( const aModuleSelector: TKnobsModuleSelector);
    begin
      Modules.UnPopulateSelector( aModuleSelector);
    end;


    procedure   TFormStore.PopulateMenu( const aRootMenu: TMenuItem; const aHandler: TNotifyEvent);
    type
      TModList = TList< TKnobsCustomModule>;
      TMap     = TDictionary< string, TModList>;
      TKV      = TPair< string, TModList>;
    var
      i         : Integer;
      aMap      : TMap;
      aKey      : string;
      aList     : TModList;
      aKV       : TKV;
      aSorter   : TStringList;
      bSorter   : TStringList;
      aModule   : TKnobsCustomModule;
      aMenuItem : TMenuItem;
      bMenuItem : TMenuItem;
      anIndex   : Integer;
      bIndex    : Integer;
      aHotKey   : Char;
    begin
      if Assigned( aRootMenu) and Assigned( Modules)
      then begin
        aMap := TMap.Create;

        try
          // Collect enabled modules into aMap
          for i := 0 to Modules.Count - 1
          do begin
            if Modules[ i].Enabled
            then begin
              aKey := Modules[ i].PageName;

              if not aMap.ContainsKey( aKey)
              then begin
                aList := TModList.Create;
                aMap.Add( aKey, aList);
              end
              else aList := aMap[ aKey];

              aList.Add( Modules[ i]);
            end;
          end;

          // Create menu items from aMap, sorted
          aSorter := TStringList.Create;

          try
            aSorter.CaseSensitive := False;
            aSorter.Sorted        := True;

            // Add keys to sorter
            for aKV in aMap
            do aSorter.Add( aKV.Key);

            // Iterate over the sorted keys
            anIndex := 0;
            for aKey in aSorter
            do begin
              if anIndex >= 10
              then aHotKey := Char( anIndex + Ord( 'A') - 10)
              else aHotKey := Char( anIndex + Ord( '0'));

              aMenuItem          := TMenuItem.Create( aRootMenu);
              aMenuItem.Caption  := Format( '&%s   %s', [ aHotKey, aKey], AppLocale);
              aList              := aMap[ aKey];
              bSorter            := TStringList.Create;

              try
                // Sort the sub menu items
                bSorter.CaseSensitive := False;
                bSorter.Sorted        := True;
                bSorter.OwnsObjects   := False;

                for aModule in aList
                do bSorter.AddObject( aModule.Title, aModule);

                // Create the sub menus
                bIndex := 0;
                for i := 0 to bSorter.Count - 1
                do begin
                  aModule := TKnobsCustomModule( bSorter.Objects[ i]);

                  if aModule.ModuleType >= 0
                  then begin
                    if bIndex >= 10
                    then aHotKey := Char( bIndex + Ord( 'A') - 10)
                    else aHotKey := Char( bIndex + Ord( '0'));

                    bMenuItem         := TMenuItem.Create( aMenuItem);
                    bMenuItem.Caption := Format( '&%s   %s', [ aHotKey, aModule.Title], AppLocale);
                    bMenuItem.Tag     := aModule.ModuleType;
                    bMenuItem.OnClick := aHandler;
                    aMenuItem.Add( bMenuItem);
                    Inc( bIndex);
                  end
                end;
              finally
                bSorter.DisposeOf;
              end;

              Inc( anIndex);
              aRootMenu.Add( aMenuItem);
            end;

            for aKV in aMap
            do aKV.Value.DisposeOf;
          finally
            aSorter.DisposeOf;
          end;
        finally
          aMap.DisposeOf;
        end;
      end;
    end;


    procedure   TFormStore.ShowModule( const aModule: TKnobsCustomModule);
    var
      aTabSheet: TTabSheet;
    begin
      aTabSheet := aModule.Parent as TTabSheet;
      savedstuff_pagecontrol.ActivePage := aTabSheet;
    end;


    function    TFormStore.BitmapName( const aModuleType: TKnobsModuleType): string;
    var
      i : Integer;
    begin
      Result := '';
      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if Modules[ i].ModuleType = aModuleType
          then begin
            Result := 'TMod' + Modules[ i].Title + '.jpg';

            Break;
          end;
        end;
      end;
    end;


    function    TFormStore.CreateModuleBitmap( const aModuleType: TKnobsModuleType): TBitmap;
    var
      i : Integer;
    begin
      Result := nil;

      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if Modules[ i].ModuleType = aModuleType
          then begin
            Result := Modules[ i].AsBitmap;
            Break;
          end;
        end;
      end;
    end;


    function    TFormStore.ReadModuleComment( const aModuleType: TKnobsModuleType): string;
    var
      i : Integer;
    begin
      Result := '';

      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if Modules[ i].ModuleType = aModuleType
          then begin
            Result := Modules[ i].Comment;

            if Result = ''
            then Result := Modules[ i].Title;

            if Modules[ i].AllowSignalConversion
            then Result := Result + ' [RS]';

            Break;
          end;
        end;
      end;
    end;


    procedure   TFormStore.MakeImage( const aFolder: string; const aModule: TKnobsCustomModule);
    var
      aBitmap   : TBitmap;
      aFileName : string;
      aJPeg     : TJPEGImage;
    begin
      if Assigned( aModule)
      then begin
        aFileName := aFolder + '\TMod' + aModule.Title + '.jpg';

        aBitmap := aModule.AsBitmap;

        try
          aJpeg := TJPEGImage.Create;

          try
            aJpeg.CompressionQuality  := 90;
            aJpeg.ProgressiveEncoding := True;
            aJpeg.Assign( aBitmap);
            aJpeg.Compress;
            aJpeg.SaveToFile( aFileName);
          finally
            FreeAndNil( aJpeg);
          end;
        finally
          aBitmap.DisposeOf;
        end;
      end;
    end;


    procedure   TFormStore.MakeImages( const aFolder: string);
    var
      i : Integer;
    begin
      for i := 0 to Modules.Count - 1
      do begin
        ShowModule( Modules[ i]);
        MakeImage( aFolder, Modules[ i]);
      end;
    end;


    function    TFormStore.FindBitmap( const aModuleTitle: string): TBitmap;
    var
      i : Integer;
    begin
      Result := nil;

      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if SameText( Modules[ i].Title, aModuleTitle)
          then begin
            Result := Modules[ i].Picture.Bitmap;
            Break;
          end;
        end;
      end;
    end;



    function    TFormStore.DocumentModule( const aModule: TKnobsCustomModule; const anImagesFolder: string; anIndex: Integer; OddColor: Boolean): string;
    const
      Odds      : array[ Boolean] of string = (
        'even',
        'odd'
      );
    var
      aDocu     : TStrings;
      aType     : Integer;
      aModuleId : string;
    begin
      Result := '';

      if Assigned( aModule) and Assigned( FMarkDownProcessor)
      then begin
        aDocu := aModule.Docs;

        if Assigned( aDocu)
        then begin
          aModuleId := aModule.Title;

          Result := Result + Format( '<div class="shadowed %s">'^M, [ Odds[ OddColor]], AppLocale);

          aType  := aModule.ModuleType;
          Result := Result + '<a href=''#index''>to module index</a>'^M;
          Result := Result + Format( '<a id=''%d''></a><h2>%d %s</h2>'^M                                       , [ aType, anIndex, aModule.Title], AppLocale);
          Result := Result + Format( '<h3>Page: %s [type %d]</h3>'^M                                           , [ aModule.PageName, aType      ], AppLocale);
          Result := Result + '<table width=''100%''><tbody><tr><td width=''275''>'^M;
          Result := Result + Format( '<img class="shadowed imgright" alt=''%s'' src=''./images/TMod%s.jpg''>'^M, [ aModule.Title , aModuleId    ], AppLocale);

          if aModule.AllowSignalConversion
          then Result := Result + '<p>[this module is RateSmart <sup><a href=''#ratesmart''>[1]</a></sup>]</p>'^M;

          Result := Result + '</td><td>'^M;
          Result := Result + FMarkDownProcessor.Process( aDocu.Text);
          Result := Result + '</td></tr></tbody></table>'^M;
          Result := Result + '</div>'^M;
          Result := Result + ^M;
        end;
      end;
    end;


    function    TFormStore.MakeDocIndex: string;
    const
      Separator = '<tr %s><th>%s</th></tr>'^M;
      Odds      : array[ Boolean] of string = (
        'class = "even"',
        'class = "odd"'
      );

      function MakeSeparator( const aPage: string; OddColor: Boolean): string;
      begin
        Result := Format( Separator, [ Odds[ OddColor], aPage], AppLocale);
      end;

    var
      i         : Integer;
      aPage     : string;
      anOldPage : string;
      aModule   : string;
      aType     : Integer;
      OddColor  : Boolean;
    begin
      anOldPage := '';
      Result    := '';
      Result    := Result + '<ul class="columns4">'^M;
      Result    := Result + '<li><table>'^M'<tbody>'^M;
      OddColor  := True;

      for i := 0 to Modules.Count - 1
      do begin
        with Modules[ i]
        do begin
          aType := ModuleType;

          if ( aType >= 0) and ( Enabled)
          then begin
            aPage   := PageName;
            aModule := Title;

            if not SameText( anOldPage, aPage)
            then begin
              OddColor := not OddColor;

              if i > 0
              then begin
                Result := Result + '</tbody>'^M'</table></li>'^M;
                Result := Result + '<li><table>'^M'<tbody>'^M;
              end;

              Result := Result + MakeSeparator( aPage, OddColor);
            end;

            Result :=
              Result +
              Format(
                '<tr %s><td width="255"><a href=''#%d''><img class="shadowed" alt=''%s'' src=''./images/TMod%s.jpg''></a></td></tr>'^M,
                [ Odds[ OddColor], aType, aModule, aModule],
                AppLocale
              );
            anOldPage := aPage;
          end;
        end;
      end;

      Result := Result + '</tbody>'^M'</table></li>'^M;
      Result := Result + '</ul>'^M;
    end;


    function    TFormStore.MakeDocHeader( const aVersion: string): string;
    begin
      Result := '';
      Result := Result + '<!doctype html>'^M'<html>'^M;
      Result := Result + '<head>'^M;
      Result := Result + '<title>WREN module documentation</title>'^M;

      Result := Result + '<style type="text/css"><!--'^M;
      Result := Result + '  body'^M;
      Result := Result + '  {'^M;
      Result := Result + '    background-color  : #ddddee;'^M;
      Result := Result + '    font-family       : Verdana, arial, helvetica, sans-serif;'^M;
      Result := Result + '    font-size         : 9pt;'^M;
      Result := Result + '    text-align        : left;'^M;
      Result := Result + '  }'^M;
      Result := Result + '  em'^M;
      Result := Result + '  {'^M;
      Result := Result + '    font-weight       : bold;'^M;
      Result := Result + '    font-style        : normal;'^M;
      Result := Result + '  }'^M;
      Result := Result + '  .odd      { background-color: #c0c0c0;}'^M;
      Result := Result + '  .even     { background-color: #d0d0d0;}'^M;
      Result := Result + '  a         { text-decoration: none;}'^M;
      Result := Result + '  a:link    { color: rgb(127,0,255);}'^M;
      Result := Result + '  a:visited { color: maroon;}'^M;
      Result := Result + '  a:hover   { color: rgb( 255, 0, 127);}'^M;
      Result := Result + '  a:active  { color: maroon;}'^M;
      Result := Result + '  table'^M;
      Result := Result + '  {'^M;
      Result := Result + '    background        : none;'^M;
      Result := Result + '    padding           : 1px;'^M;
      Result := Result + '    margin            : 0px;'^M;
      Result := Result + '    margin-bottom     : 25px;'^M;
      Result := Result + '    border-style      : solid;'^M;
      Result := Result + '    border-color      : blue;'^M;
      Result := Result + '    border-width      : 1px;'^M;
      Result := Result + '  }'^M;
      Result := Result + '  td, th'^M;
      Result := Result + '  {'^M;
      Result := Result + '    padding           : 3px;'^M;
      Result := Result + '    vertical-align    : top;'^M;
      Result := Result + '    text-align        : left;'^M;
      Result := Result + '    border            : solid;'^M;
      Result := Result + '    border-color      : transparent;'^M;
      Result := Result + '    border-width      : 1px;'^M;
      Result := Result + '  }'^M;
      Result := Result + '  ul.columns4{'^M;
      Result := Result + '    padding             : 0;'^M;
      Result := Result + '    margin              : 0;'^M;
      Result := Result + '    list-style-type     : none;'^M;
      Result := Result + '    columns             : 4;'^M;
      Result := Result + '    -webkit-columns     : 4;'^M;
      Result := Result + '    -moz-columns        : 4;'^M;
      Result := Result + '    list-style-position : inside;'^M;
      Result := Result + '    text-align          : justify;'^M;
      Result := Result + '    text-justify        : inter-word;'^M;
      Result := Result + '  }'^M;
      Result := Result + '  .shadowed { box-shadow : 2px 2px 3px 1px #aaa;}'^M;
      Result := Result + '  .imgleft{'^M;
      Result := Result + '    float               : left;                }'^M;
      Result := Result + '    margin              : 5px;                 }'^M;
      Result := Result + '  }'^M;
      Result := Result + '  .imgright{'^M;
      Result := Result + '    float               : right;               }'^M;
      Result := Result + '    margin              : 5px;                 }'^M;
      Result := Result + '  }'^M;
      Result := Result + '--></style>'^M;

      Result := Result + '</head>'^M'<body>'^M;
      Result := Result + '<a id=''index''></a><h1>WREN module documentation</h1>'^M;
      Result := Result + Format( '<h3>Version : %s</h3>'^M, [ aVersion], AppLocale);
      Result := Result + '<p> COPYRIGHT 1999 - 2019 Blue Hell</p>';
      Result := Result + '<p>Look <a href=''https://www.bluehell.nl/wren/''>here</a> for more information.</p>'^M;
      Result := Result + MakeDocIndex;
    end;


    function    TFormStore.MakeDocFooter: string;
    begin
      Result := '';
      Result := Result + '<a id=''ratesmart''></a>';
      Result := Result + '<br><br>';
      Result := Result + '<sup>[1]</sup> A RateSmart module will change it''s calculation rate from control rate to audio rate when it gets connected to an audio rate output. ';
      Result := Result + 'This will be indicated on the module by the connector colors changing from the control rate colors to the audio rate colors.';
      Result := Result + '<br><br>';
      Result := Result + '<p> COPYRIGHT 1999 - 2019 Blue Hell</p>';
      Result := Result + '<p>See the <a href=''https://www.bluehell.nl/wren/''>web site</a> for more information.</p>'^M;
      Result := Result + '<p>~ fin ~</p>';
      Result := Result + '</body>'^M'</html>';
    end;


    function    TFormStore.DoDocument( const aFolder, anImagesFolder, aVersion: string): string; // overload;
    var
      i       : Integer;
      anIndex : Integer;
    begin
      Result  := MakeDocHeader( aVersion);
      anIndex := 1;

      for i := 0 to Modules.Count - 1
      do begin
        if ( Modules[ i].ModuleType >= 0) and ( Modules[ i].Enabled)
        then begin
          ShowModule( Modules[ i]);
          MakeImage( aFolder + anImagesFolder, Modules[ i]);
          Result := Result + DocumentModule( Modules[ i], anImagesFolder, anIndex, Odd( anIndex));
          Inc( anIndex);
        end;
      end;

      Result := Result + MakeDocFooter;
    end;


    procedure   TFormStore.Document( const aFolder, anImagesFolder, aVersion: string); // overload;
    var
      aFileName : string;
      aFile     : TextFile;
      Data      : string;
    begin
      Data := '';
      aFileName := aFolder + '\modules.html';
      AssignFile( aFile, aFileName);

      try
        Rewrite( aFile);
        Write( aFile, DoDocument( aFolder, anImagesFolder, aVersion));
      finally
        CloseFile( aFile);
      end;
    end;


    function    TFormStore.GetTabColor( const aSender: TObject; const aTabName: string; aMixColor: TColor; aMix: Byte): TColor;
    var
      i : Integer;
    begin
      Result := aMixColor;

      for i := 0 to Modules.Count - 1
      do begin
        if SameText( Modules[ i].PageName, aTabName)
        then begin
          Result := InterpolateColors( Modules[ i].Color, aMixColor, aMix);
          Break;
        end;
      end;
    end;


    function    TFormStore.DefaultModuleColor( const aModuleType: TKnobsModuleType; const aDefaultColor: TColor): TColor;
    var
      i : Integer;
    begin
      Result := aDefaultColor;

      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if Modules[ i].ModuleType = aModuleType
          then begin
            Result := Modules[ i].Color;
            Break;
          end;
        end;
      end;
    end;


    procedure   TFormStore.LoadControlGlyph( const aFolder, aFile: string; aList: TImageList; anIndex: Integer);
    var
      aFileName : string;
      aBitmap   : TBitmap;
    begin
      if Assigned( aList)
      then begin
        try
          aFileName := Format( '%s\%s.bmp', [ aFolder, aFile]);

          if FileExists( aFileName)
          then begin
            aBitmap := TBitmap.Create;

            try
              aBitmap.LoadFromFile( aFileName);
              aList.Replace( anIndex, aBitmap, nil);
            finally
              aBitmap.DisposeOf;
            end;
          end;
        except
          on E: Exception
          do KilledException( E);
        end;
      end;
    end;


    procedure   TFormStore.LoadControlGlyphs( const aFolder: string);
    begin
      LoadControlGlyph( aFolder , 'skin_signaltype_normal'            , ImageListLfoOutputType         , 0);
      LoadControlGlyph( aFolder , 'skin_signaltype_inverted'          , ImageListLfoOutputType         , 1);
      LoadControlGlyph( aFolder , 'skin_signaltype_positive'          , ImageListLfoOutputType         , 2);
      LoadControlGlyph( aFolder , 'skin_signaltype_positive_inverted' , ImageListLfoOutputType         , 3);
      LoadControlGlyph( aFolder , 'skin_signaltype_negative'          , ImageListLfoOutputType         , 4);
      LoadControlGlyph( aFolder , 'skin_signaltype_negative_inverted' , ImageListLfoOutputType         , 5);

      LoadControlGlyph( aFolder , 'skin_signaltype_positive'          , ImageListEnvOutputType         , 0);
      LoadControlGlyph( aFolder , 'skin_signaltype_positive_inverted' , ImageListEnvOutputType         , 1);
      LoadControlGlyph( aFolder , 'skin_signaltype_negative'          , ImageListEnvOutputType         , 2);
      LoadControlGlyph( aFolder , 'skin_signaltype_negative_inverted' , ImageListEnvOutputType         , 3);

      LoadControlGlyph( aFolder , 'skin_shape_sine'                   , ImageListStandardWaveShapes    , 0);
      LoadControlGlyph( aFolder , 'skin_shape_tri'                    , ImageListStandardWaveShapes    , 1);
      LoadControlGlyph( aFolder , 'skin_shape_saw'                    , ImageListStandardWaveShapes    , 2);
      LoadControlGlyph( aFolder , 'skin_shape_square'                 , ImageListStandardWaveShapes    , 3);

      LoadControlGlyph( aFolder , 'skin_mute_active'                  , ImageListMuteTypes             , 0);
      LoadControlGlyph( aFolder , 'skin_mute_muted'                   , ImageListMuteTypes             , 1);
      LoadControlGlyph( aFolder , 'skin_mute_passtrough'              , ImageListMuteTypes             , 2);

      LoadControlGlyph( aFolder , 'skin_solo_off'                     , ImageListSoloTypes             , 0);
      LoadControlGlyph( aFolder , 'skin_solo_on'                      , ImageListSoloTypes             , 1);

      LoadControlGlyph( aFolder , 'skin_gate_off'                     , ImageListGateTypes             , 0);
      LoadControlGlyph( aFolder , 'skin_gate_trig'                    , ImageListGateTypes             , 1);
      LoadControlGlyph( aFolder , 'skin_gate_gate'                    , ImageListGateTypes             , 2);

      LoadControlGlyph( aFolder , 'skin_env_attack_log'               , ImageListLogLinExpSTypeAttack  , 0);
      LoadControlGlyph( aFolder , 'skin_env_attack_lin'               , ImageListLogLinExpSTypeAttack  , 1);
      LoadControlGlyph( aFolder , 'skin_env_attack_exp'               , ImageListLogLinExpSTypeAttack  , 2);
      LoadControlGlyph( aFolder , 'skin_env_attack_s'                 , ImageListLogLinExpSTypeAttack  , 3);

      LoadControlGlyph( aFolder , 'skin_env_release_log'              , ImageListLogLinExpSTypeRelease , 0);
      LoadControlGlyph( aFolder , 'skin_env_release_lin'              , ImageListLogLinExpSTypeRelease , 1);
      LoadControlGlyph( aFolder , 'skin_env_release_exp'              , ImageListLogLinExpSTypeRelease , 2);
      LoadControlGlyph( aFolder , 'skin_env_release_s'                , ImageListLogLinExpSTypeRelease , 3);

      LoadControlGlyph( aFolder , 'skin_shape_sine'                   , ImageListStandardLFOWaveShapes , 0);
      LoadControlGlyph( aFolder , 'skin_shape_tri'                    , ImageListStandardLFOWaveShapes , 1);
      LoadControlGlyph( aFolder , 'skin_shape_saw'                    , ImageListStandardLFOWaveShapes , 2);
      LoadControlGlyph( aFolder , 'skin_shape_square'                 , ImageListStandardLFOWaveShapes , 3);
      LoadControlGlyph( aFolder , 'skin_shape_random_square'          , ImageListStandardLFOWaveShapes , 4);
      LoadControlGlyph( aFolder , 'skin_shape_random'                 , ImageListStandardLFOWaveShapes , 5);
    end;


    function    TFormStore.CreatePageNames: TStringList;
    var
      i : Integer;
      S : string;
      p : Integer;
    begin
      Result := TStringList.Create;
      Result.Duplicates := dupIgnore;
      Result.Sorted     := False;

      for i := 0 to Modules.Count - 1
      do begin
        S := Modules.Module[ i].PageName;
        p := Result.IndexOf( S);

        if p < 0
        then Result.Add( S);
      end;
    end;


    function    TFormStore.CreateBlankControlTypeList: TStringList;
    const
      Dynamics : array[ Boolean] of string = (
        '',
        ' [dynamic]'
      );
    var
      i : Integer;
      j : Integer;
      k : Integer;
      M : TKnobsCustomModule;
      C : TControl;
      V : TKnobsValuedControl;
      S : TKnobsSelector;
    begin
      Result := TStringList.Create;

      for i := 0 to Modules.Count - 1
      do begin
        M := Modules.Module[ i];

        if Assigned( M)
        then begin
          for j := 0 to M.ControlCount - 1
          do begin
            C := M.Controls[ j];

            if Assigned( C) and ( C is TKnobsValuedControl)
            then begin
              V := TKnobsValuedControl( C);

              if V.ControlType = ''
              then begin

                if V is TKnobsSelector
                then begin
                  S := TKnobsSelector( V);

                  if Assigned( S.Captions) and ( S.Captions.Count > 1)
                  then begin
                    Result.Add( Format( '%s %s %s', [ M.Title, V.Name, Dynamics[ V.DynamicStepCount]], AppLocale));

                    for k := 0 to S.Captions.Count - 1
                    do Result.Add( Format( '  %s', [ S.Captions[ k]], AppLocale));
                  end;
                end
                else begin
                  Result.Add( Format( '%s %s', [ M.Title, V.Name], AppLocale));
                end;
              end;
            end;
          end;
        end;
      end;
    end;


//  public

    function    TFormStore.CreateMazeTypes: TStringList;
    var
      i : Integer;
      j : Integer;
    begin
      Result := TStringList.Create;

      if Assigned( Modules)
      then begin
        for i := 0 to Modules.Count - 1
        do begin
          if Modules[ i].ModuleType = 1227
          then begin
            for j := 0 to Modules[ i].ControlCount - 1
            do begin
              if Modules[ i].Controls[ j] is TKnobsMazeGraphViewer
              then begin
                if TKnobsMazeGraphViewer( Modules[ i].Controls[ j]).ImportList = nil
                then TKnobsMazeGraphViewer( Modules[ i].Controls[ j]).ForthFileName := ApplicationPath + 'mazes.4th';

                if TKnobsMazeGraphViewer( Modules[ i].Controls[ j]).ImportList <> nil
                then Result.Assign( TKnobsMazeGraphViewer( Modules[ i].Controls[ j]).ImportList)
                else Nop;

                Break;
              end
            end;

            Break;
          end;
        end;
      end;
    end;


    procedure   TFormStore.RegisterModule( aModule: TKnobsCustomModule);
    begin
      if Assigned( aModule)
      then begin
        if aModule.ModuleType = 1
        then Nop;

        aModule.FixDisplays;
        aModule.OnLog := DoModuleLog;
        aModule.SetTitleFont ( FTitleFont );
        aModule.SetModuleFont( FModuleFont);
        aModule.UseConnectorBorders      := ConnectorBorders;
        aModule.UseTypedConnectorBorders := ConnectorTypedBorders;
        FModules.Add( aModule);
      end;
    end;


    procedure   TFormStore.RegisterModules;
    var
      i : Integer;
    begin
      Assert( Assigned( FModules));

      for i := 0 to ComponentCount - 1
      do begin
        if ( Components[ i] is TKnobsCustomModule) and ( TKnobsCustomModule( Components[ i]).ModuleType >= 0)
        then RegisterModule( TKnobsCustomModule( Components[ i]));
      end;

      FModules.RegisterComponents( True);
    end;


// Delphi area



procedure TFormStore.FormCreate(Sender: TObject);
begin
  FModules           := TKnobsModuleList.Create( False);
  FModules.OnLog     := DoModuleListLog;
  FMarkDownProcessor := TMarkdownProcessor.CreateDialect( mdDaringFireball);
  FTitleFont         := TFont.Create;
  FModuleFont        := TFont.Create;
  FTitleFont.Charset := DEFAULT_CHARSET;
  FTitleFont.Color   := clWindowText;
  FTitleFont.Style   := [ fsBold];

  if Screen.Fonts.IndexOf( 'Corbel') >= 0
  then begin
    FTitleFont.Name := 'Corbel';
    FTitleFont.Size := 8;
  end
  else begin
    FTitleFont.Name := 'Small Fonts';
    FTitleFont.Size := 7;
  end;

  FModuleFont.Charset := DEFAULT_CHARSET;
  FModuleFont.Color   := clWindowText;
  FModuleFont.Style   := [];
  FModuleFont.Name    := 'Small Fonts';
  FModuleFont.Size    := 7;

  GroupIOColor        := clSilver;
  GroupOSCColor       := clRed;
  GroupLFOColor       := clLime;
  GroupEnvColor       := clYellow;
  GroupFilterColor    := clBlue;
  GroupSwitchColor    := clFuchsia;
  GroupMixColor       := clAqua;
  GroupControlColor   := clTeal;
  GroupNoteColor      := $000080FF;    // Orange
  GroupMathColor      := clWhite;
  GroupLogicColor     := clGreen;
  GroupSeqColor       := clPurple;
  GroupGeneratorColor := $009882FF;    // Pink
  GroupFXColor        := clMaroon;
  GroupDelayColor     := clTeal;
  GroupVoiceColor     := $00404080;    // Brown
  GroupUtilityColor   := clBlack;

  RegisterModules;
  savedstuff_pagecontrol.ActivePage := inout_tabsheet;
end;


procedure TFormStore.FormDestroy(Sender: TObject);
begin
  if Assigned( FModules)
  then begin
    FModules.RegisterComponents( False);
    FreeAndNil( FModules);
  end;

  FreeAndNil( FTitleFont        );
  FreeAndNil( FModuleFont       );
  FreeAndNil( FMarkDownProcessor);
end;


end.
