unit dsp;

interface

uses

  KnobsUtils;


type

  TFir = class
  private
    FHistoryMask     : Cardinal;
    FCoefficientSize : Cardinal;
    FHistory         : TSignalArray;
    FCoefficients    : TSignalArray;
    FInp             : Cardinal;
  public
    constructor Create( aSize: Cardinal);
    procedure   Reset;
    function    Execute ( aSample: TSignal): TSignal;
    function    Upsample( aSample: TSignal; aFactor: Cardinal): TSignal;
    procedure   StoreSample( aSample: TSignal);
  end;


implementation

{ ========
  TFir = class
  private
    FHistoryMask     : Cardinal;
    FCoefficientSize : Cardinal;
    FHistory         : TSignalArray;
    FCoefficients    : TSignalArray;
    FInp             : Cardinal;
  public
}

    constructor TFir.Create( aSize: Cardinal);
    begin
      SetLength( FHistory     , NextPowerOfTwo( aSize));
      SetLength( FCoefficients, aSize                 );
      FHistoryMask     := Length( FHistory     ) - 1;
      FCoefficientSize := Length( FCoefficients);
      Reset;
    end;


    procedure   TFir.Reset;
    begin
      FInp := 0;
      FillChar( FHistory[ 0], Length( FHistory) * SizeOf( FHistory[ 0]), 0);
    end;


    function    TFir.Execute ( aSample: TSignal): TSignal;
    var
      i : Cardinal;
      j : Cardinal;
    begin
      FHistory[ FInp] := aSample;
      Result          := aSample * FCoefficients[ 0];
      j               := {$Q-R-}FInp - 1{$Q+R+};

      for i := 1 to FCoefficientSize - 1
      do begin
        Result := Result + FCoefficients[ i] * FHistory[ j and FHistoryMask];

        {$Q-R-}Dec( j);{$Q+R+}
      end;

      FInp := ( FInp + 1) and FHistoryMask;
    end;


    function    TFir.Upsample( aSample: TSignal; aFactor: Cardinal): TSignal;
    // This assumes the stuffed in zero samples are not stored, and they are
    // not being computed.
    var
      i : Cardinal;
      j : Cardinal;
      k : Cardinal;
    begin
      FHistory[ FInp] := aSample;
      Result          := 0;
      j               := {$Q-R-}FInp - aFactor{$Q+R+};
      k               := 1;

      for i := 1 to FCoefficientSize - 1
      do begin
        Result := Result + FCoefficients[ k] * FHistory[ j and FHistoryMask];

        {$Q-R-}Dec( j);{$Q+R+}
        Inc( k, aFactor);
      end;

      FInp := ( FInp + 1) and FHistoryMask;
    end;


    procedure   TFir.StoreSample( aSample: TSignal);
    begin
      FHistory[ FInp] := aSample;
      FInp := ( FInp + 1) and FHistoryMask;
    end;




end.

