unit lightning;

interface

uses

  System.Generics.Collections,

  KnobsUtils;

type

  TCellMatrix<T> = class
  private
    FData   : array of T;
    FWidth  : Integer;
    FHeight : Integer;
    FCount  : Integer;
  private
    procedure   SetWidth ( aValue: Integer);
    procedure   SetHeight( aValue: Integer);
    function    GetCell( anX, anY: Integer): T;
    procedure   SetCell( anX, anY: Integer; aValue: T);
  public
    constructor Create( aWidth, aHeight: Integer);
  public
    property    Count                    : Integer read FCount;
    property    Width                    : Integer read FWidth  write SetWidth;
    property    Height                   : Integer read FHeight write SetHeight;
    property    Cell[ anX, anY: Integer] : T       read GetCell write SetCell;
  end;


  TCellLocation = record
    X : Integer;
    Y : Integer;
  end;


  TLightningEngine = class
  private
    FWidth       : Integer;
    FHeight      : Integer;
    FPotential   : TCellMatrix<TSignal>;
    FIsCandidate : TCellMatrix<Boolean>;
    FIsForm      : TCellMAtrix<Boolean>;
    FCandidates  : TList<TCellLocation>
  private
    procedure   DataSetup;
  public
    constructor Create( aWidth, aHeight: Ingeger);
  public
    property    Width  : Integer read FWidth;
    property    Height : Integer read FHeight;
  end;


implementation


{ ========
  TCellMatrix<T> = class
  private
    FData   : array of T;
    FWidth  : Integer;
    FHeight : Integer;
    FCount  : Integer;
  public
    property    Count                    : Integer read FCount;
    property    Width                    : Integer read FWidth  write SetWidth;
    property    Height                   : Integer read FHeight write SetHeight;
    property    Cell[ anX, anY: Integer] : T       read GetCell write SetCell;
  private
}

    procedure   TCellMatrix<T>.SetWidth( aValue: Integer);
    begin
      SetLength( FData, aValue* FHeight);
      FCount  := aValue * FHeight;
      FWidth  := aValue;
    end;


    procedure   TCellMatrix<T>.SetHeight( aValue: Integer);
    begin
      SetLength( FData, FWidth * aValue);
      FCount  := FWidth * aValue;
      FHeight := aValue;
    end;


    function    TCellMatrix<T>.GetCell( anX, anY: Integer): T;
    begin
      Result := FData[ anx + Width * anY];
    end;


    procedure   TCellMatrix<T>.SetCell( anX, anY: Integer; aValue: T);
    begin
      FData[ anx + Width * anY] := aValue;
    end;


//  public

    constructor TCellMatrix<T>.Create( aWidth, aHeight: Integer);
    begin
      SetLength( FData, aWidth * aHeight);
      FCount  := aWidth * aHeight;
      FWidth  := aWidth;
      FHeight := aHeight;
    end;




end.
