program wren;

{
   COPYRIGHT 2013 .. 2019 Blue Hell / Jan Punter

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2 as
  published by the Free Software Foundation;

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  For all listed email addresses :

    _dot. to be substituted by a dot      '.'
    2@t2  to be substituted by an at sign '@'


  Blue Hell is a trade mark owned by

    Jan Punter
    https://www.bluehell.nl/
    jan2@t2mail_dot_bluehell_dot_nl
}

{$IFNDEF DEGUG}
  {$WEAKLINKRTTI ON}
  {$RTTI EXPLICIT METHODS([]) PROPERTIES([]) FIELDS([])}
{$ENDIF}

{$R *.res}


uses
  Winapi.Windows,
  Vcl.Themes,
  Vcl.Styles,
  Vcl.Forms,
  System.SysUtils,
  Globals in 'Globals.pas',
  FrmMain in 'FrmMain.pas' {FormWren},
  FrmStore in 'FrmStore.pas' {FormStore},
  wave_dlg in 'wave_dlg.pas' {FormWaveDeviceSelect},
  FrmMidiCC in 'FrmMidiCC.pas' {FormSelectMidiCC},
  FrmRandomizer in 'FrmRandomizer.pas' {FormRandomizer},
  FrmLastEdits in 'FrmLastEdits.pas' {FormLastEdits},
  FrmSplash in 'FrmSplash.pas' {FormSplash},
  midi_defs in 'midi_defs.pas',
  midi_reader in 'midi_reader.pas',
  freereverb in 'freereverb.pas',
  wave_tools in 'wave_tools.pas',
  ctypes in 'ctypes.pas',
  scala in 'scala.pas',
  fftw_ in 'fftw_.pas',
  fftwgen in 'fftwgen.pas',
  windowing in 'windowing.pas',
  Talkie in 'Talkie.pas',
  gverb in 'gverb.pas',
  module_defs in 'module_defs.pas',
  module_implementations in 'module_implementations.pas',
  HrastUnit in 'HrastUnit.pas',
  KnobParser in 'KnobParser.pas',
  CpuUsage in 'CpuUsage.pas',
  portaudio in 'portaudio.pas',
  module_scales in 'module_scales.pas',
  synth_info in 'synth_info.pas',
  loro_sc in 'loro_sc.pas',
  poetry_generator in 'poetry_generator.pas',
  OSCif in 'OSCif.pas',
  grains in 'grains.pas',
  SVFUnit in 'SVFUnit.pas',
  Convolution in 'Convolution.pas',
  FormantControl in 'FormantControl.pas',
  tss in 'tss.pas',
  Speech in 'Speech.pas',
  MarkdownDaringFireball in 'MarkdownDaringFireball.pas',
  MarkdownProcessor in 'MarkdownProcessor.pas',
  noise in 'noise.pas',
  Markov in 'Markov.pas',
  IntSequences in 'IntSequences.pas',
  Moog in 'Moog.pas',
  mod_external in 'mod_external.pas',
  SpeechLib_TLB in 'SpeechLib_TLB.pas',
  ESpeak in 'ESpeak.pas',
  ESpeakInterface in 'ESpeakInterface.pas',
  TaggedAudio in 'TaggedAudio.pas';

const

  MaxDataLength = 1024;


var

  CommandLine : Atom;
  aData       : array[ 0 .. MaxDataLength] of Char;
  aMutex      : THandle;


begin

  // Check to see if a previous instance is running and if so post it this instance's commandline
  // so that the previous instance can :
  //
  // - pop itself up.
  // - (possibly) open the file.

  WrenMessage := RegisterWindowMessage(   PChar( SafeWindowsName( 'WrenCommandLine')));
  aMutex      := CreateMutex( nil, False, PChar( SafeWindowsName( 'WrenAppEntry'   )));

  if GetLastError = ERROR_ALREADY_EXISTS
  then begin
    if   ParamCount >= 1
    then begin
      StrPCopy( @ aData, Copy( ParamStr( 1), 1, MaxDataLength));
      CommandLine := GlobalAddAtom( aData);
    end
    else CommandLine := 0;

    try
      SendMessage(
        HWND_BROADCAST,
        WrenMessage,
        LongInt( CommandLine),
        0
      );
    finally
      Halt( 0);
    end;
  end;

  // Back to the normal Delphi startup stuff .. except for the splash screen being woven in .. and some theming

  ReportMemoryLeaksOnShutdown := DebugHook <> 0;
  FixTheme;

  Application.Initialize;
  Application.MainFormOnTaskbar := True;

  if   UseThemes and ( UserTheme <> '')
  and  not SameText( UserTheme, 'Windows')
  then TStyleManager.TrySetStyle( UserTheme);

  FormSplash := TFormSplash.Create( Application); // Application owns FormSplash .. otherwise shutdown issues and memory leaks
  FormSplash.Show;
  FormSplash.Update;

  Application.CreateForm( TFormWren, FormWren);   // main form will create and destroy other forms (except FormSplash) as needed
  Application.Run;

  if   aMutex <> 0
  then CloseHandle( aMutex);
end.

