unit ClipboardListener;

// Obtained from : http://forum.lazarus.freepascal.org/index.php?topic=15488.0
// posted by ASerge as a quote from Remy Lebeau - 2016-10-18/19
//
//   THANK YOU THANK YOU THANK YOU VERY VERY MUCH!
//
// 2017-06-05 : modified it a bit for turbo turbo pascal by Blue Hell

interface

uses

  Winapi.Windows, WinApi.Messages, System.Classes;

type


  TClipboardListener = class(TObject)
  strict private
    FOnClipboardChange : TNotifyEvent;
    FWnd               : HWND;
  strict private
    class function GetSupported: Boolean;                                                                        static;
    procedure      WindowProc( var aMsg: TMessage);
  protected
    procedure      ClipboardChanged;                                                                            virtual;
  public
    constructor    Create;
    destructor     Destroy;                                                                                    override;
  public
    property       OnClipboardChange: TNotifyEvent read FOnClipboardChange write FOnClipboardChange;
    class property Supported: Boolean              read GetSupported;
  end;


implementation

uses

  System.SysUtils, Vcl.Forms;

var

  AddClipboardFormatListener    : function( Wnd: HWND): BOOL; stdcall;
  RemoveClipboardFormatListener : function( Wnd: HWND): BOOL; stdcall;


  procedure InitClipboardFormatListener;
  var
    HUser32: HMODULE;
  begin
    HUser32                       := GetModuleHandle( user32);
    AddClipboardFormatListener    := GetProcAddress( HUser32, 'AddClipboardFormatListener'   );
    RemoveClipboardFormatListener := GetProcAddress( HUser32, 'RemoveClipboardFormatListener');
  end;


{ ========
  TClipboardListener = class(TObject)
  strict private
    FOnClipboardChange : TNotifyEvent;
    FWnd               : HWND;
  public
    property       OnClipboardChange: TNotifyEvent read FOnClipboardChange write FOnClipboardChange;
    class property Supported: Boolean              read GetSupported;
}


    procedure   TClipboardListener.ClipboardChanged; // virtual;
    begin
    end;


    constructor TClipboardListener.Create;
    begin
      inherited;

      if Supported
      then begin
        FWnd := AllocateHWnd( WindowProc);

        if not AddClipboardFormatListener( FWnd)
        then RaiseLastOSError;
      end;
    end;


    destructor  TClipboardListener.Destroy;
    begin
      if FWnd <> 0
      then begin
        RemoveClipboardFormatListener( FWnd);
        DeallocateHWnd( FWnd);
      end;

      inherited;
    end;


    class function TClipboardListener.GetSupported: Boolean;
    begin
      Result :=
        Assigned( AddClipboardFormatListener   ) and
        Assigned( RemoveClipboardFormatListener);
    end;


    procedure   TClipboardListener.WindowProc( var aMsg: TMessage);
    begin
      if aMsg.msg = WM_CLIPBOARDUPDATE
      then begin
        aMsg.Result := 0;
        ClipboardChanged;

        if Assigned( FOnClipboardChange)
        then FOnClipboardChange( Self);
      end;
    end;


initialization

  if not ( csDesigning in Application.ComponentState)
  then InitClipboardFormatListener;

end.
