unit ESpeak;

  // A Pascal binding for eSpeak's espeak-sapi.dll.

  // // ///////////////////////////////////////////////////////////////// // //
  // //                                                                   // //
  // // Several parameter and type names were changed to my preferences.  // //
  // //                                                                   // //
  // // ///////////////////////////////////////////////////////////////// // //

  // The following comment is from speak_lib.h

  {
    ***************************************************************************
    *   Copyright (C) 2005 to 2012 by Jonathan Duddington                     *
    *   email: jonsd@users.sourceforge.net                                    *
    *                                                                         *
    *   This program is free software; you can redistribute it and/or modify  *
    *   it under the terms of the GNU General Public License as published by  *
    *   the Free Software Foundation; either version 3 of the License, or     *
    *   (at your option) any later version.                                   *
    *                                                                         *
    *   This program is distributed in the hope that it will be useful,       *
    *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
    *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
    *   GNU General Public License for more details.                          *
    *                                                                         *
    *   You should have received a copy of the GNU General Public License     *
    *   along with this program; if not, see:                                 *
    *               <http://www.gnu.org/licenses/>.                           *
    ***************************************************************************

    ***********************************************************
    This is the header file for the library version of espeak
    ***********************************************************
  }

  {
    Furter notes by Blue HEll


    >> Automatically converted by H2Pas 1.0.0 from <some file> <<

    Which basically was a bit of a fuckup, all done manually now.

    For the Blue Hell modifications:

       COPYRIGHT 2019 Blue Hell / Jan Punter

      This program is free software; you can redistribute it and/or modify
      it under the terms of the GNU General Public License version 2 as
      published by the Free Software Foundation;

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program; if not, write to the Free Software
      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

      For all listed email addresses :

        _dot. to be substituted by a dot      '.'
        2@t2  to be substituted by an at sign '@'


    Blue Hell is a trade mark owned by

      Jan Punter
      https://www.bluehell.nl/
      jan2@t2mail_dot_bluehell_dot_nl

  }

interface

  {$Z4}       // Set enum size to 4 bytes to match what C does
  {$ALIGN 8}  // To match C record alignment

const

  espeak_dllpath = 'espeak_sapi.dll'; // Must be in the path .. somewhere .. can be local too


const

  ESPEAK_API_REVISION = 9;

  {
    Revision 2

      Added parameter "options" to eSpeakInitialize()

    Revision 3

      Added ES_WORDGAP to espeak_PARAMETER

    Revision 4

      Added flags parameter to espeak_CompileDictionary()

    Revision 5

      Added EF_CHARS_16BIT

    Revision 6

      Added macros: ES_RATE_MINIMUM, ES_RATE_MAXIMUM, ES_RATE_NORMAL

    Revision 7  24.Dec.2011

      Changed espeak_EVENT structure to add id.string[] for phoneme mnemonics.
      Added ES_INITIALIZE_PHONEME_IPA option for espeak_Initialize() to report phonemes as IPA names.

    Revision 8  26.Apr.2013

      Added function espeak_TextToPhonemes().

    Revision 9  30.May.2013

      Changed function espeak_TextToPhonemes().
  }

type

  // Some type mappings to Delphi types for types used in espeak, the espeak types get an E prefix

  ECHAR   =  AnsiChar;
  ESHORT  =  Int16;
  EDWORD  =  UInt32;
  ESIZE   =  UInt32;
  PEDWORD = ^EDWORD;
  PESHORT = ^ESHORT;
  PECHAR  = ^ECHAR;
  PPECHAR = ^PECHAR;


  // ******************
  // Initialization
  // ******************

  // values for 'value' in espeak_SetParameter( ES_RATE, value, 0), nominally in words-per-minute

const

  ES_RATE_MINIMUM =  80;
  ES_RATE_NORMAL  = 175;
  ES_RATE_MAXIMUM = 450;


type

  TESpeakEventType =
  (
    EV_LIST_TERMINATED = 0,  // Retrieval mode: terminates the event list.
    EV_WORD            = 1,  // Start of word
    EV_SENTENCE        = 2,  // Start of sentence
    EV_MARK            = 3,  // Mark
    EV_PLAY            = 4,  // Audio element
    EV_END             = 5,  // End of sentence or clause
    EV_MSG_TERMINATED  = 6,  // End of message
    EV_PHONEME         = 7,  // Phoneme, if enabled in espeak_Initialize()
    EV_SAMPLERATE      = 8   // internal use, set sample rate
  );


  TESpeakEvent = record
    EventType     : TESpeakEventType;            // See above
    UniqueID      : EDWORD;                      // message identifier (or 0 for key or character)
    TextPosition  : LongInt;                     // the number of characters from the start of the text
    Length        : LongInt;                     // word length, in characters (for EV_WORD)
    AudioPosition : LongInt;                     // the time in ms within the generated speech output data
    Sample        : LongInt;                     // sample id (internal use)
    UserData      : Pointer;                     // pointer supplied by the calling program
    ID            : record
      case LongInt of
        0 : ( Number  : LongInt);                // used for WORD and SENTENCE events.
        1 : ( Name    : PECHAR);                 // used for MARK and PLAY events.  UTF8 string
        2 : ( _string : array[ 0 .. 7] of Byte); // used for phoneme names (UTF8). Terminated by a zero byte unless the
                                                 // name needs the full 8 bytes.
    end;
  end;

  PESPeakEvent = ^TESpeakEvent;

  {
    When a message is supplied to espeak_synth, the request is buffered and espeak_synth returns. When the message is
    really processed, the callback function will be repetedly called.

    In RETRIEVAL mode, the callback function supplies to the calling program the audio data and an event list terminated
    by 0 (ES_LIST_TERMINATED).

    In PLAYBACK mode, the callback function is called as soon as an event happens.

    For example suppose that the following message is supplied to espeak_Synth:

      "hello, hello."


    * Once processed in RETRIEVAL mode, it could lead to 3 calls of the callback function :

      ** Block 1:
        <audio data> +
        List of events: SENTENCE + WORD + LIST_TERMINATED

      ** Block 2:
        <audio data> +
        List of events: WORD + END + LIST_TERMINATED

      ** Block 3:
        no audio data
        List of events: MSG_TERMINATED + LIST_TERMINATED


    * Once processed in PLAYBACK mode, it could lead to 5 calls of the callback function:

      ** SENTENCE
      ** WORD (call when the sounds are actually played)
      ** WORD
      ** END (call when the end of sentence is actually played.)
      ** MSG_TERMINATED


    The MSG_TERMINATED event is the last event. It can inform the calling program to clear the user data related to the
    message. So if the synthesis must be stopped, the callback function is called for each pending message with the
    MSG_TERMINATED event.

    A MARK event indicates a <mark> element in the text.

    A PLAY event indicates an <audio> element in the text, for which the calling program should play the named sound
    file.
  }

  TESpeakPositionType =
  (
    POS_CHARACTER = 1,
    POS_WORD,
    POS_SENTENCE
  );

  TESpeakOutputType =
  (
    AUDIO_OUTPUT_PLAYBACK      , // PLAYBACK    mode: plays the audio data, supplies events to the calling program
    AUDIO_OUTPUT_RETRIEVAL     , // RETRIEVAL   mode: supplies audio data and events to the calling program
    AUDIO_OUTPUT_SYNCHRONOUS   , // SYNCHRONOUS mode: as RETRIEVAL but doesn't return until synthesis is completed
    AUDIO_OUTPUT_SYNCH_PLAYBACK  // Synchronous playback
  );

  TESpeakError =
  (
    EE_OK             =  0,
    EE_INTERNAL_ERROR = -1,
    EE_BUFFER_FULL    =  1,
    EE_NOT_FOUND      =  2
  );

const

  ES_INITIALIZE_PHONEME_EVENTS = $0001;
  ES_INITIALIZE_PHONEME_IPA    = $0002;
  ES_INITIALIZE_DONT_EXIT      = $8000;


  function espeak_Initialize( OutputType: TESpeakOutputType; BufLength: LongInt; Path: PAnsiChar; Options: LongInt): LongInt; cdecl;
  {
    Must be called before any synthesis functions are called.
    output: the audio data can either be played by eSpeak or passed back by the SynthCallback function.

    buflength:  The length in mS of sound buffers passed to the SynthCallback function.
    Value=0 gives a default of 200mS.
    This paramater is only used for AUDIO_OUTPUT_RETRIEVAL and AUDIO_OUTPUT_SYNCHRONOUS modes.

    path: The directory which contains the espeak-data directory, or NULL for the default location.

    options:

      bit 0:  1 = allow EV_PHONEME events.
      bit 1:  1 = EV_PHONEME events give IPA phoneme names, not eSpeak phoneme names
      bit 15: 1 = don't exit if espeak_data is not found (used for --help)

    Returns: sample rate in Hz, or -1 (EE_INTERNAL_ERROR).
  }

type

  // typedef int (t_espeak_callback)(ESHORT*, int, ESpeakEvent*);

  TESpeakCallback = function( WaveData: PESHORT; NumSamples: Integer; Events: PESpeakEvent): Integer; cdecl;


  procedure espeak_SetSynthCallback( SynthCallback: TESpeakCallback); cdecl;

{
  Must be called before any synthesis functions are called.
  This specifies a function in the calling program which is called when a buffer of
  speech sound data has been produced.


  The callback function is of the form:

  int SynthCallback(ESHORT *wav, int numsamples, ESpeakEvent *events);

  WaveData :

    is the speech sound data which has been produced. NULL indicates that the synthesis has been completed.

  NumSamples :

    is the number of entries in wav.  This number may vary, may be less than the value implied by the buflength
    parameter given in espeak_Initialize, and may sometimes be zero (which does NOT indicate end of synthesis).

  Events:

    an array of TESpeakEvent items which indicate word and sentence events, and also the occurance if <mark> and <audio>
    elements within the text. The list of events is terminated by an event of type = 0.


  Callback returns:

    0 = continue synthesis,
    1 = abort    synthesis.
}

type

  TUriCallback = function( EventType: LongInt; Uri: PECHAR; Base: PECHAR): LongInt; cdecl;

  procedure espeak_SetUriCallback( UriCallback: TUriCallback); cdecl;
  {
    This function may be called before synthesis functions are used, in order to deal with <audio> tags.  It specifies
    a callback function which is called when an <audio> element is encountered and allows the calling program to
    indicate whether the sound file which is specified in the <audio> element is available and is to be played.

    The callback function is of the form:

      int UriCallback( int type, const char *uri, const char *base);

      EventType :

        type of callback event.  Currently only 1= <audio> element

      Uri :

        the "src" attribute from the <audio> element

      Dase:

        the "xml:base" attribute (if any) from the <speak> element

    Return:
      1 = don't play the sound, but speak the text alternative.
      0 = place a PLAY event in the event list at the point where the <audio> element
          occurs.  The calling program can then play the sound at that point.
  }


  // ******************
  // Synthesis
  // ******************

const

  EF_CHARS_AUTO     =     0;
  EF_CHARS_UTF8     =     1;
  EF_CHARS_8BIT     =     2;
  EF_CHARS_WCHAR    =     3;
  EF_CHARS_16BIT    =     4;
  EF_SSML           =   $10;
  EF_PHONEMES       =  $100;
  EF_ENDPAUSE       = $1000;
  EF_KEEP_NAME_DATA = $2000;


  function espeak_Synth
  (
    Text         : Pointer;
    Size         : ESIZE;
    Position     : EDWORD;
    PositionType : TESpeakPositionType;
    EndPosition  : EDWORD;
    Flags        : EDWORD;
    UniqueID     : PEDWORD;
    UserData     : Pointer
  ): TESpeakError; cdecl;
  {
    Synthesize speech for the specified text.  The speech sound data is passed to the calling program in buffers by
    means of the callback function specified by espeak_SetSynthCallback(). The command is asynchronous: it is internally
    buffered and returns as soon as possible. If espeak_Initialize was previously called with AUDIO_OUTPUT_PLAYBACK as
    argument, the sound data are played by eSpeak.

    Text:

      The text to be spoken, terminated by a zero character. It may be either 8-bit characters, wide characters
      (Char), or UTF8 encoding. Which of these is determined by the Flags parameter.

    Size:

      Equal to (or greatrer than) the size of the text data, in bytes.  This is used in order to allocate internal
      storage space for the text.  This value is not used for AUDIO_OUTPUT_SYNCHRONOUS mode.

    Position:

      The position in the text where speaking starts. Zero indicates speak from the start of the text.

    PositionType:

      Determines whether "Position" is a number of characters, words, or sentences. Values:

    EndPosition:

       If set, this gives a character position at which speaking will stop. A value of zero indicates no end position.

    Flags:

      These may be OR'd together: Type of character codes, one of:

        EF_CHARS_UTF8   UTF8 encoding
        EF_CHARS_8BIT   The 8 bit ISO-8859 character set for the particular language.
        EF_CHARS_AUTO   8 bit or UTF8  (this is the default)
        EF_CHARS_WCHAR  Wide characters (wchar_t)
        EF_CHARS_16BIT  16 bit characters.

        EF_SSML

          Elements within < > are treated as SSML elements, or if not recognised are ignored.

        EF_PHONEMES

          Text within [[ ]] is treated as phonemes codes (in espeak's Hirshenbaum encoding).

        EF_ENDPAUSE

          If set then a sentence pause is added at the end of the text. If not set then this pause is suppressed.

    UniqueID :

      This must be either NULL, or point to an integer variable to which eSpeak writes a message identifier number.
      eSpeak includes this number in ESpeakEvent messages which are the result of this call of espeak_Synth().

    UserData :

      a Pointer (or NULL) which will be passed to the callback function in ESpeakEvent messages.

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  function espeak_Synth_Mark
  (
    Text        : Pointer;
    Size        : ESIZE;
    IndexMark   : PECHAR;
    EndPosition : EDWORD;
    Flags       : EDWORD;
    UniqueID    : PEDWORD;
    UserData    : Pointer
  ): TESpeakError; cdecl;

  {
    Synthesize speech for the specified text. Similar to espeak_Synth() but the start position is specified by the name
    of a <mark> element in the text.

    IndexMark:

      The "name" attribute of a <mark> element within the text which specified the point at which synthesis starts.
      UTF8 string.

    For the other parameters, see espeak_Synth()

    Return:
      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  function espeak_Key( KeyName: PChar): TESpeakError; cdecl;
  {
    Speak the name of a keyboard key. If key_name is a single character, it speaks the name of the character, otherwise,
    it speaks key_name as a text string.

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  function espeak_Char( Character: Char): TESpeakError; cdecl;
  {
    Speak the name of the given character

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }


  { ********************* }
  { Speech Parameters }
  { ********************* }

type

  TESpeakParameter =
  (
    ES_SILENCE     =  0,    // internal use
    ES_RATE        =  1,
    ES_VOLUME      =  2,
    ES_PITCH       =  3,
    ES_RANGE       =  4,
    ES_PUNCTUATION =  5,
    ES_CAPITALS    =  6,
    ES_WORDGAP     =  7,
    ES_OPTIONS     =  8,    // reserved for misc. options. not yet used
    ES_INTONATION  =  9,
    ES_RESERVED1   = 10,
    ES_RESERVED2   = 11,
    ES_EMPHASIS        ,    // internal use
    ES_LINELENGTH      ,    // internal use
    ES_VOICETYPE       ,    // internal use, 1 = mbrola
    ES_N_SPEECH_PARAM       // last enum
  );

const

  ES_PUNCT_NONE = 0;
  ES_PUNCT_ALL  = 1;
  ES_PUNCT_SOME = 2;

  function espeak_SetParameter( Parameter: TESpeakParameter; Value: LongInt; Relative: LongInt): TESpeakError; cdecl;
  {
    Sets the value of the specified parameter.

    Relative = 0   Sets the absolute value of the parameter.
    Relative = 1   Sets a relative value of the parameter.

    Parameter:

      ES_RATE:        speaking speed in word per minute.  Values 80 to 450.

      ES_VOLUME:      volume in range 0-200 or more.
                      0 = silence,
                      100 = normal full volume, greater values may produce amplitude compression or distortion

      ES_PITCH:       base pitch, range 0-100.  50=normal

      ES_RANGE:       pitch range, range 0-100. 0-monotone, 50=normal

      ES_PUNCTUATION: which punctuation characters to announce:
                      value (none, all, some),
                      see espeak_GetParameter() to specify which characters are announced.

      ES_CAPITALS:    announce capital letters by:
                        0 = none,
                        1 = sound icon,
                        2 = spelling,
                        3 or higher, by raising pitch.  This values gives the amount in Hz by which the pitch of a word
                                     raised to indicate it has a capital letter.

      ES_WORDGAP:     pause between words, units of 10mS (at the default speed)

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  function espeak_GetParameter( Parameter: TESpeakParameter; Current: LongInt): LongInt; cdecl;
  {
    Current = 0  Returns the default value of the specified parameter.
    Current = 1  Returns the current value of the specified parameter, as set by SetParameter()
  }

  function espeak_SetPunctuationList( PunctList: PECHAR): TESpeakError; cdecl;
  {
    was: function espeak_SetPunctuationList( punctlist: Pwchar_t): TESpeakError; cdecl;

    Specifies a list of punctuation characters whose names are to be spoken when the value of the Punctuation parameter
    is set to "some".

    PunctList:  A list of character codes, terminated by a zero character.

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  procedure espeak_SetPhonemeTraceSafe; // Only viable option for Delphi it seems ...
  {
    See :

      procedure espeak_SetPhonemeTrace( Value: LongInt; Stream: PFILE); cdecl; deprecated;

    for the issues arising ... espeak_SetPhonemeTraceSafe calls espeak_SetPhonemeTrace( 0, nil)
  }

  function espeak_TextToPhonemes( TextPtr: PPointer; TextMode: LongInt; PhonemeMode: LongInt): PECHAR; cdecl;
  {
    Translates text into phonemes. Call espeak_SetVoiceByName() first, to select a language.

    It returns a Pointer to a character string which contains the phonemes for the text up to end of a sentence, or
    comma, semicolon, colon, or similar punctuation.

    TextPtr:

      The address of a Pointer to the input text which is terminated by a zero character. On return, the Pointer has
      been advanced past the text which has been translated, or else set to NULL to indicate that the end of the text
      has been reached.

    TextMode:

      Type of character codes, one of:

        EF_CHARS_UTF8   UTF8 encoding
        EF_CHARS_8BIT   The 8 bit ISO-8859 character set for the particular language.
        EF_CHARS_AUTO   8 bit or UTF8  (this is the default)
        EF_CHARS_WCHAR  Wide characters (wchar_t)
        EF_CHARS_16BIT  16 bit characters.

    PhonemeMode:

    bits0-3:

      0 = just phonemes.
      1 = include ties (U+361) for phoneme names of more than one letter.
      2 = include zero-width-joiner for phoneme names of more than one letter.
      3 = separate phonemes with underscore characters.

    bits 4-7:

      0 = eSpeak's ASCII phoneme names.
      1 = International Phonetic Alphabet (as UTF-8 characters).
  }


  procedure espeak_SafeCompileDictionary( Path: PECHAR; Flags: LongInt);
  {
    Compile pronunciation dictionary for a language which corresponds to the currently selected voice.  The required
    voice should be selected before calling this function.

    Path:

      The directory which contains the language's '_rules' and '_list' files. 'path' should end with a path separator
      character ('/').

    Flags:

      Bit 0 : include source line information for debug purposes (This is displayed with the -X command line option).

    Log is set to nil
  }
  // *********************
  // Voice Selection
  // *********************

type

  // Voice table

  TESpeakVoice = record
    Name       : PECHAR;  // a given name for this voice. UTF8 string.
    Languages  : PECHAR;  // list of pairs of (byte) priority + (string) language (and dialect qualifier)
    Identifier : PECHAR;  // the filename for this voice within espeak-data/voices
    Gender     : Byte;    // 0 = none 1 = male, 2 = female
    Age        : Byte;    // 0 = not specified, or age in years
    Variant    : Byte;    // only used when passed as a parameter to espeak_SetVoiceByProperties
    xx1        : Byte;    // for internal use
    score      : LongInt; // for internal use
    spare      : Pointer; // for internal use
  end;

  PESpeakVoice  = ^TESpeakVoice;
  PPESpeakVoice = ^PESpeakVoice;

  {
    Note: The ESpeakVoice structure is used for two purposes:

      1.  To return the details of the available voices.
      2.  As a parameter to espeak_SetVoiceByProperties() in order to specify selection criteria.

    In (1)

      the "languages" field consists of a list of (UTF8) language names for which this voice may be used, each language
      name in the list is terminated by a zero byte and is also preceded by a single byte which gives a "priority"
      number.  The list of languages is terminated by an additional zero byte.

      A language name consists of a language code, optionally followed by one or more qualifier (dialect) names
      separated by hyphens (eg. "en-uk").  A voice might, for example, have languages "en-uk" and "en". Even without
      "en" listed, voice would still be selected for the "en" language (because "en-uk" is related) but at a lower
      priority.

      The priority byte indicates how the voice is preferred for the language. A low number indicates a more preferred
      voice, a higher number indicates a less preferred voice.

    In (2)

      the "languages" field consists simply of a single (UTF8) language name, with no preceding priority byte.
  }

  function espeak_ListVoices( VoiceSpec: PESpeakVoice): PPESpeakVoice; cdecl;
  {
    Reads the voice files from espeak-data/voices and creates an array of ESpeakVoice Pointers.
    The list is terminated by a NULL Pointer

    If voice_spec is NULL then all voices are listed.
    If voice spec is given, then only the voices which are compatible with the voice_spec
    are listed, and they are listed in preference order.
  }

  function espeak_SetVoiceByName( Name: PECHAR): TESpeakError; cdecl;
  {
    Searches for a voice with a matching "name" field.  Language is not considered. "name" is a UTF8 string.

    Return:

      EE_OK             : operation achieved
      EE_BUFFER_FULL    : the command can not be buffered; you may try after a while to call the function again.
      EE_INTERNAL_ERROR
  }

  function espeak_SetVoiceByProperties( VoiceSpec: PESpeakVoice): TESpeakError; cdecl;
  {
    An ESpeakVoice structure is used to pass criteria to select a voice. Any of the following
    fields may be set:

    Name       NULL, or a voice name

    Languages  NULL, or a single language string (with optional dialect), eg. "en-uk", or "en"

    Gender     0 = not specified, 1 = male, 2 = female

    Age        0 = not specified, or an age in years

    Variant    After a list of candidates is produced, scored and sorted, "variant" is used to index that list and
               choose a voice. variant=0 takes the top voice (i.e. best match). variant=1 takes the next voice, etc.
  }

  function espeak_GetCurrentVoice: PESpeakVoice; cdecl;
  {
    Returns the ESpeakVoice data for the currently selected voice. This is not affected by temporary voice changes
    caused by SSML elements such as <voice> and <s>
  }

  function espeak_Cancel: TESpeakError; cdecl;
  {
    Stop immediately synthesis and audio output of the current text. When this function returns, the audio output is
    fully stopped and the synthesizer is ready to synthesize a new message.

    Return:

      EE_OK             : operation achieved
      EE_INTERNAL_ERROR
  }

  function espeak_IsPlaying: LongInt; cdecl;
  {
    Returns 1 if audio is played, 0 otherwise.
  }

  function espeak_Synchronize: TESpeakError; cdecl;
  {
    This function returns when all data has been spoken.

    Return:

      EE_OK             : operation achieved
      EE_INTERNAL_ERROR
  }

  function espeak_Terminate: TESpeakError; cdecl;
  {
    last function to be called.

    Return:

      EE_OK             : operation achieved
      EE_INTERNAL_ERROR
  }

  function espeak_Info( PathData: PPECHAR): PECHAR; cdecl;
  {
    Returns the version number string.
    PathData  returns the path to espeak_data // Note: this is UNSAFE - no length specified ... prolly MAX_PATH or
                                              //       something

    Note: the PathData paramaeter should be nil, apparently it is for futuere use, it did not do what I had expected it
    to do .. return a data path. Also freeing memory allocated for it would crash
  }



  // ===================================================================================================================
  //
  // Functions marked as deprecated, but actually they are not usable at all due to the PFILE typed argument
  //
  type
  //
    PFILE = Pointer;    // was: ^ FILE; : not usable in Delphi, set to Pointer here ...
  //
  procedure espeak_SetPhonemeTrace( Value: LongInt; Stream: PFILE); cdecl; deprecated;
  {
    Controls the output of phoneme symbols for the text

      Value = 0  No phoneme output (default)
      Value = 1  Output the translated phoneme symbols for the text
      Value = 2  as (1), but also output a trace of how the translation was done (matching rules and list entries)
      Value = 3  as (1), but produces IPA rather than ascii phoneme names

      Stream     output stream for the phoneme symbols (and trace).  If stream = NULL then it uses stdout.
  }
  //
  procedure espeak_CompileDictionary( Path: PECHAR; Log: PFILE; Flags: LongInt); cdecl; deprecated;
  {
    Compile pronunciation dictionary for a language which corresponds to the currently selected voice.  The required
    voice should be selected before calling this function.

    Path:

      The directory which contains the language's '_rules' and '_list' files. 'path' should end with a path separator
      character ('/').

    Log:

      Stream for error reports and statistics information. If log=NULL then stderr will be used.

    Flags:

      Bit 0 : include source line information for debug purposes (This is displayed with the -X command line option).
  }
  //
  // ===================================================================================================================


implementation


  function  espeak_Initialize;           external espeak_dllpath delayed;
  procedure espeak_SetSynthCallback;     external espeak_dllpath delayed;
  procedure espeak_SetUriCallback;       external espeak_dllpath delayed;
  function  espeak_Synth;                external espeak_dllpath delayed;
  function  espeak_Synth_Mark;           external espeak_dllpath delayed;
  function  espeak_Key;                  external espeak_dllpath delayed;
  function  espeak_Char;                 external espeak_dllpath delayed;
  function  espeak_SetParameter;         external espeak_dllpath delayed;
  function  espeak_GetParameter;         external espeak_dllpath delayed;
  function  espeak_SetPunctuationList;   external espeak_dllpath delayed;
  function  espeak_TextToPhonemes;       external espeak_dllpath delayed;
  function  espeak_ListVoices;           external espeak_dllpath delayed;
  function  espeak_SetVoiceByName;       external espeak_dllpath delayed;
  function  espeak_SetVoiceByProperties; external espeak_dllpath delayed;
  function  espeak_GetCurrentVoice;      external espeak_dllpath delayed;
  function  espeak_Cancel;               external espeak_dllpath delayed;
  function  espeak_IsPlaying;            external espeak_dllpath delayed;
  function  espeak_Synchronize;          external espeak_dllpath delayed;
  function  espeak_Terminate;            external espeak_dllpath delayed;
  function  espeak_Info;                 external espeak_dllpath delayed;

  procedure espeak_SetPhonemeTrace;      external espeak_dllpath delayed; // deprecated
  procedure espeak_CompileDictionary;    external espeak_dllpath delayed; // deprecated


{$WARN SYMBOL_DEPRECATED OFF}
//
  procedure espeak_SetPhonemeTraceSafe;
  begin
    espeak_SetPhonemeTrace( 0, nil);             // <-- deprecated, but needed here, this call should be safe.
  end;
//
  procedure espeak_SafeCompileDictionary( Path: PECHAR; Flags: LongInt);
  begin
    espeak_CompileDictionary( Path, nil, Flags); // <-- deprecated, but needed here, this call should be safe.
  end;
//
{$WARN SYMBOL_DEPRECATED ON}


end.

