unit FrmMain;

{

   COPYRIGHT 2013 .. 2019 Blue Hell / Jan Punter

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2 as
  published by the Free Software Foundation;

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  For all listed email addresses :

    _dot. to be substituted by a dot      '.'
    2@t2  to be substituted by an at sign '@'


  Blue Hell is a trade mark owned by

    Jan Punter
    https://www.bluehell.nl/
    jan2@t2mail_dot_bluehell_dot_nl
}

{$ifdef DEBUG}
  {$define DEBUG_WORMS}
{$endif}

interface

uses

  WinApi.Windows, WinApi.Messages, Winapi.CommCtrl, WinApi.ShellApi, WinApi.UxTheme,

  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons, Vcl.ExtCtrls, Vcl.ComCtrls,
  Vcl.Menus, Vcl.Samples.Spin, Vcl.Imaging.pngimage, Vcl.FileCtrl, Vcl.ImgList, Vcl.Themes, Vcl.Imaging.jpeg,
  Vcl.Mask,

  VCLTee.Chart, VCLTee.Series, VclTee.TeeGDIPlus, VCLTee.TeeProcs, VCLTee.TeEngine,

  System.SysUtils, System.UITypes, System.TypInfo, System.Classes, System.IniFiles, System.Math, System.Win.Registry,
  System.StrUtils, System.Types,


  OverbyteIcsWndControl, OverbyteIcsWSocket,

  KnobsConversions, KnobsUtils, Globals, wave_dlg, KnobParser, CpuUsage, module_defs, module_scales,
  module_implementations, knobs2013, Rationals, WaveStorage, WaveUtils, wave_tools, midi_defs, midi_reader, synth_info,
  KnobsWorms, mod_external, ctypes, portaudio, fftw_, Talkie, OSCif, grains, FormantControl, Speech, SpeechLib_TLB,
  ESpeakInterface, HrastUnit,

  FrmStore, FrmMidiCC, FrmRandomizer, FrmLastEdits, FrmSplash;


const

  UM_MIDIDATA   = KNOBS_UM_USER + 1;
  UM_OSCDATA    = KNOBS_UM_USER + 2;
  UM_MIDI_LOG   = KNOBS_UM_USER + 3;
  UM_LIVE_MORPH = KNOBS_UM_USER + 4;


type

  TMsgMIDIData   = TMessage;
  TMsgOSCData    = TMessage;
  TMsgMIDILog    = TMessage;

  TPageControl = class( Vcl.ComCtrls.TPageControl)
  // Some stuff to fix the border width for TPageControls
  private
    procedure   TCMAdjustRect(var Msg: TMessage); message TCM_ADJUSTRECT;
  end;

  TEdit = class( Vcl.StdCtrls.TEdit)
  // Fix VK_DELETE issues for TEdits
  private
    procedure    CNKeyDown( var aMessage: TWMKeyDown); message CN_KEYDOWN;
  end;


  EWren               = class( Exception);
  EWrenExecutionError = class( Ewren);

  TColorSetter = procedure( aColor: TColor) of object;
  TColorGetter = function: TColor           of object;

  TColorId = (
    cidEditorBackground    ,
    cidModule              ,
    cidConnectorBorder     ,
    cidSelector            ,
    cidSelectorBorder      ,
    cidSelectorBorderSingle,
    cidDisplay             ,
    cidDisplayBorder       ,
    cidKnobMIDI            ,
    cidKnobFocus           ,
    cidKnobMIDIFocus       ,
    cidViewer              ,
    cidViewerBorder        ,
    cidViewerLine          ,
    cidViewerFill          ,
    cidIndicatorBarPeak    ,
    cidIndicatorBarValey   ,
    cidAudioRate           ,
    cidControlRate         ,
    cidControlRateLogic    ,
    cidLogic               ,
    cidUnconnectedWire     ,
    cidWireHghlight        ,
    cidGroupIO             ,
    cidGroupOSC            ,
    cidGroupLFO            ,
    cidGroupEnv            ,
    cidGroupFilter         ,
    cidGroupSwitch         ,
    cidGroupMix            ,
    cidGroupControl        ,
    cidGroupNote           ,
    cidGroupMath           ,
    cidGroupLogic          ,
    cidGroupSeq            ,
    cidGroupGenerator      ,
    cidGroupFX             ,
    cidGroupDelay          ,
    cidGroupUtility
  );

  TColorMap = record
    Id     : TColorId;
    Name   : string;
    Setter : TColorSetter;
    Getter : TColorGetter;
  end;

  TColorMaps = array of TColorMap;

  TAttentionItem = (
    atNothing          ,
    atMuted            ,
    atSmalls           ,
    atManualCompilation,
    atPastLast                             // Keep this one to be the final item
  );
  TAttentionItems = set of TAttentionItem;

  TFormWren = class(TForm)
    PanelControl: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    TimerStatsUpdate: TTimer;
    PanelMain: TPanel;
    PageControlMain: TPageControl;
    SaveDialogPatch: TSaveDialog;
    TabSheetEditor: TTabSheet;
    OpenDialogPatch: TOpenDialog;
    MainMenu: TMainMenu;
    MenuFile: TMenuItem;
    MenuFileLoad: TMenuItem;
    MenuFileSave: TMenuItem;
    MenuEdit: TMenuItem;
    MenuFileExitProgram: TMenuItem;
    MenuEditDelete: TMenuItem;
    MenuEditCut: TMenuItem;
    MenuEditCopy: TMenuItem;
    MenuEditPaste: TMenuItem;
    N2: TMenuItem;
    MenuEditSelectAll: TMenuItem;
    MenuEditInvertSelection: TMenuItem;
    N3: TMenuItem;
    MenuEditUndo: TMenuItem;
    MenuEditRedo: TMenuItem;
    MenuFileSaveAs: TMenuItem;
    MenuSetup: TMenuItem;
    MenuSetupDevices: TMenuItem;
    MenuFileNew: TMenuItem;
    MenuHelp: TMenuItem;
    MenuHelpHelp: TMenuItem;
    MenuSetupSettings: TMenuItem;
    MenuView: TMenuItem;
    MenuViewEditor: TMenuItem;
    MenuViewDebugger: TMenuItem;
    MenuViewGraphs: TMenuItem;
    MenuViewSettings: TMenuItem;
    N8: TMenuItem;
    MenuFileReopen: TMenuItem;
    knob_outputlevel1: TKnobsKnob;
    knob_inputlevel1: TKnobsKnob;
    IndicatorBarVolumeInLeft1: TKnobsIndicatorBar;
    IndicatorBarVolumeInRight1: TKnobsIndicatorBar;
    IndicatorBarVolumeOutLeft1: TKnobsIndicatorBar;
    IndicatorBarVolumeOutRight1: TKnobsIndicatorBar;
    LabeldBInPeak1: TLabel;
    LabeldbOutPeak1: TLabel;
    MenuAction: TMenuItem;
    MenuActionRunStop: TMenuItem;
    OpenDialogWave: TOpenDialog;
    PanelEditorTop: TPanel;
    MenuEditSelectNone: TMenuItem;
    PatchEditor: TKnobsWirePanel;
    WSocketNetMidi: TWSocket;
    TimerNetMidiConnect: TTimer;
    PanelEditorTopRight: TPanel;
    LabelRunTime: TLabel;
    LabelWires: TLabel;
    EditSearch: TEdit;
    MenuViewHelp: TMenuItem;
    MenuActionProfile: TMenuItem;
    N6: TMenuItem;
    MenuEditFind: TMenuItem;
    PopupMenuConnector: TPopupMenu;
    DeleteConnector: TMenuItem;
    BreakWire: TMenuItem;
    DisconnectConnector: TMenuItem;
    PopupMenuModule: TPopupMenu;
    MenuItemModuleCopy: TMenuItem;
    MenuItemModuleCut: TMenuItem;
    MenuItemModuleDelete: TMenuItem;
    PopupMenuKnob: TPopupMenu;
    SetKnobDefaultvalue: TMenuItem;
    LockKnob: TMenuItem;
    LabeldBInMax1: TLabel;
    LabeldBOutMax1: TLabel;
    TimerLightsUpdate: TTimer;
    PopupMenuSelector: TPopupMenu;
    dynamics1: TMenuItem;
    SaveDialogWave: TSaveDialog;
    KnobsLedrendering: TKnobsLed;
    KnobsSelectorFileRender: TKnobsSelector;
    LabeldBInMin1: TLabel;
    LabeldBOutMin1: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    IndicatorBarVolumeInLeft2: TKnobsIndicatorBar;
    IndicatorBarVolumeInRight2: TKnobsIndicatorBar;
    IndicatorBarVolumeOutLeft2: TKnobsIndicatorBar;
    IndicatorBarVolumeOutRight2: TKnobsIndicatorBar;
    LabeldBInPeak2: TLabel;
    LabeldbOutPeak2: TLabel;
    LabeldBInMax2: TLabel;
    LabeldBOutMax2: TLabel;
    LabeldBInMin2: TLabel;
    LabeldBOutMin2: TLabel;
    knob_outputlevel2: TKnobsKnob;
    knob_inputlevel2: TKnobsKnob;
    Label39: TLabel;
    Label40: TLabel;
    IndicatorBarVolumeInLeft3: TKnobsIndicatorBar;
    IndicatorBarVolumeInRight3: TKnobsIndicatorBar;
    IndicatorBarVolumeOutLeft3: TKnobsIndicatorBar;
    IndicatorBarVolumeOutRight3: TKnobsIndicatorBar;
    LabeldBInPeak3: TLabel;
    LabeldbOutPeak3: TLabel;
    LabeldBInMax3: TLabel;
    LabeldBOutMax3: TLabel;
    LabeldBInMin3: TLabel;
    LabeldBOutMin3: TLabel;
    knob_outputlevel3: TKnobsKnob;
    knob_inputlevel3: TKnobsKnob;
    Label47: TLabel;
    Label48: TLabel;
    IndicatorBarVolumeInLeft4: TKnobsIndicatorBar;
    IndicatorBarVolumeInRight4: TKnobsIndicatorBar;
    IndicatorBarVolumeOutLeft4: TKnobsIndicatorBar;
    IndicatorBarVolumeOutRight4: TKnobsIndicatorBar;
    LabeldBInPeak4: TLabel;
    LabeldbOutPeak4: TLabel;
    LabeldBInMax4: TLabel;
    LabeldBOutMax4: TLabel;
    LabeldBInMin4: TLabel;
    LabeldBOutMin4: TLabel;
    knob_outputlevel4: TKnobsKnob;
    knob_inputlevel4: TKnobsKnob;
    SplitterMain: TSplitter;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    ColorDialogModule: TColorDialog;
    MenuItemModuleHelp: TMenuItem;
    MenuItemModuleColor: TMenuItem;
    MenuEditFindunconnectedmodules: TMenuItem;
    MenuFileSaveastemplate1: TMenuItem;
    MenuFileSaveastemplate2: TMenuItem;
    MenuActionStartfilerender: TMenuItem;
    N1: TMenuItem;
    MenuFileImportmodules: TMenuItem;
    MenuFileExportselectedmodules: TMenuItem;
    MenuActionReset: TMenuItem;
    MenuEditPasteValues: TMenuItem;
    MenuActionRecompile: TMenuItem;
    LabeldBInValey1: TLabel;
    LabeldBInValey2: TLabel;
    LabeldBInValey3: TLabel;
    LabeldBInValey4: TLabel;
    LabeldbOutValey1: TLabel;
    LabeldbOutValey2: TLabel;
    LabeldbOutValey3: TLabel;
    LabeldbOutValey4: TLabel;
    Checkforupdates1: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    TabSheetSettings: TTabSheet;
    TabSheetGraphs: TTabSheet;
    TabSheetDebug: TTabSheet;
    PanelSettings: TPanel;
    ChartDebug: TChart;
    PanelGraphControl: TPanel;
    BitBtnDebigStep: TBitBtn;
    BitBtnDebugRun: TBitBtn;
    BitBtnDebugReset: TBitBtn;
    BitBtnClearGraphs: TBitBtn;
    CheckBoxGraphStairs: TCheckBox;
    BitBtnCloseGraphs: TBitBtn;
    MemoDebug: TMemo;
    PanelDebugControl: TPanel;
    LabelAudioInOverflows: TLabel;
    LabelAudioInUnderflows: TLabel;
    BitBtnClear: TBitBtn;
    BitBtnDump: TBitBtn;
    BitBtnCloseDubugger: TBitBtn;
    BitBtnProfile: TBitBtn;
    N5: TMenuItem;
    Makegreen1: TMenuItem;
    Redwires1: TMenuItem;
    Bluewires1: TMenuItem;
    Yellowwires1: TMenuItem;
    Customwirecolor1: TMenuItem;
    Defaultwirecolor1: TMenuItem;
    LabelExceptions: TLabel;
    LabelAudioOutOverflows: TLabel;
    LabelAudioOutUnderflows: TLabel;
    FontDialog: TFontDialog;
    GroupBoxDebugSettings: TGroupBox;
    CheckBoxCompilerDebug: TCheckBox;
    CheckBoxAbsTimeStamps: TCheckBox;
    CheckBoxLogToFile: TCheckBox;
    CheckBoxLogMidi: TCheckBox;
    CheckBoxLogMidiMsgs: TCheckBox;
    CheckBoxUseGraphs: TCheckBox;
    MenuItemModuleDefaultcolor: TMenuItem;
    WSocketOSC: TWSocket;
    CheckBoxLogOSC: TCheckBox;
    CheckBoxLogOSCMsgs: TCheckBox;
    TimerOSCGuard: TTimer;
    LabelLightsTime: TLabel;
    KnobMIDICC: TMenuItem;
    N7: TMenuItem;
    PanelTemplates: TPanel;
    MenuViewMidi: TMenuItem;
    AssigntoCC: TMenuItem;
    UnassignCC: TMenuItem;
    EditPark: TEdit;
    BitBtnView1: TBitBtn;
    BitBtnView2: TBitBtn;
    BitBtnView3: TBitBtn;
    BitBtnView4: TBitBtn;
    N14: TMenuItem;
    MenuItemModuleSaveAsPreset: TMenuItem;
    MenuItemModuleLoadFromPreset: TMenuItem;
    SaveDialogPreset: TSaveDialog;
    OpenDialogPreset: TOpenDialog;
    MenuFileLoadpatchPreset: TMenuItem;
    MenuSavepatchpreset: TMenuItem;
    SplitterModuleSelector: TSplitter;
    SpeedButtonChangeModuleSelector: TSpeedButton;
    ModuleSelector: TKnobsModuleSelector;
    PopupMenuEditor: TPopupMenu;
    MenuItemInsertmodule: TMenuItem;
    N17: TMenuItem;
    cut1: TMenuItem;
    copy1: TMenuItem;
    paste1: TMenuItem;
    N18: TMenuItem;
    pastevalues1: TMenuItem;
    delete1: TMenuItem;
    selectall1: TMenuItem;
    invertselection1: TMenuItem;
    selectnone1: TMenuItem;
    MenuFileLoadtemplate1: TMenuItem;
    MenuFileLoadtemplate2: TMenuItem;
    N10: TMenuItem;
    MenuActionToggleSound: TMenuItem;
    MenuViewTopPane: TMenuItem;
    N15: TMenuItem;
    MenuActionTogglelights: TMenuItem;
    N13: TMenuItem;
    MenuActionPanic: TMenuItem;
    ScrollBoxSettings: TScrollBox;
    GroupBoxEditorSettings: TGroupBox;
    Label30: TLabel;
    Label15: TLabel;
    CheckBoxReloadLastPatch: TCheckBox;
    CheckBoxAutoRun: TCheckBox;
    CheckBoxWarnOnPatchChange: TCheckBox;
    KnobsSmallKnob_LightsRate: TKnobsSmallKnob;
    KnobsDisplayLightsRate: TKnobsDisplay;
    CheckBoxResetOnRender: TCheckBox;
    CheckBoxClearVUOnStop: TCheckBox;
    KnobsDisplayHistoryCount: TKnobsDisplay;
    KnobsNoKnob_HistoryCount: TKnobsNoKnob;
    CheckBoxClearVUOnRecompile: TCheckBox;
    CheckBoxWarnChangeOnLoad: TCheckBox;
    CheckBoxUndoAfterSave: TCheckBox;
    CheckBoxUndoAfterLoad: TCheckBox;
    CheckBoxSearchPatch: TCheckBox;
    CheckBoxSearchSelector: TCheckBox;
    CheckBoxWarnOnStructMismatch: TCheckBox;
    GroupBoxNetMidi: TGroupBox;
    Label16: TLabel;
    Label17: TLabel;
    LedNetMidiConnect2: TKnobsLed;
    LedNetMidiTx2: TKnobsLed;
    LedNetMidiRx2: TKnobsLed;
    Label23: TLabel;
    Label22: TLabel;
    Label21: TLabel;
    Label42: TLabel;
    EditNetMidiServer: TEdit;
    EditNetMidiPort: TEdit;
    BitBtnApplyNetMidi: TBitBtn;
    BitBtnCancelNetMidi: TBitBtn;
    BitBtnNetMidiConnect: TBitBtn;
    CheckBoxNetMidiAutoConnect: TCheckBox;
    main_midich: TKnobsNoKnob;
    main_display_midich: TKnobsDisplay;
    GroupBoxProgramInfo: TGroupBox;
    LabelProgramVersion: TLabel;
    LabelPatchVersion: TLabel;
    BitBtnCheckForUpdates: TBitBtn;
    BitBtnAcknowledgements: TBitBtn;
    BitBtnDocument: TBitBtn;
    GroupBoxLooks: TGroupBox;
    Label27: TLabel;
    CheckBoxCurvedLines: TCheckBox;
    GroupBoxEditorBorders: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    KnobsDisplayOffsetLeft: TKnobsDisplay;
    KnobsDisplayOffsetTop: TKnobsDisplay;
    KnobsSmallKnob_LeftOffset: TKnobsNoKnob;
    KnobsSmallKnob_TopOffset: TKnobsNoKnob;
    CheckBoxStandardColors: TCheckBox;
    KnobsSmallKnobModuleOpacity: TKnobsSmallKnob;
    KnobsDisplayModuleOpacity: TKnobsDisplay;
    BitBtnModuleTitleFont: TBitBtn;
    BitBtnModuleFont: TBitBtn;
    GroupBoxOSC: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    LedOSCTx2: TKnobsLed;
    LedOSCRx2: TKnobsLed;
    Label9: TLabel;
    Label14: TLabel;
    Label41: TLabel;
    EditOSCServer: TEdit;
    EditOSCPort: TEdit;
    BitBtnApplyOSC: TBitBtn;
    BitBtnCancelOSC: TBitBtn;
    CheckBoxUseOSC: TCheckBox;
    BitBtnSendOSCTestMessage: TBitBtn;
    EditSynthName: TEdit;
    RadioGroupSampleRate: TRadioGroup;
    ComboBoxThemes: TComboBox;
    LabelThemes: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Label49: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label54: TLabel;
    display_inputlevel1: TKnobsDisplay;
    display_inputlevel2: TKnobsDisplay;
    display_inputlevel3: TKnobsDisplay;
    display_inputlevel4: TKnobsDisplay;
    display_outputlevel1: TKnobsDisplay;
    display_outputlevel2: TKnobsDisplay;
    display_outputlevel3: TKnobsDisplay;
    display_outputlevel4: TKnobsDisplay;
    KnobsWirePanelLooks: TKnobsWirePanel;
    RadioGroupControlMode: TRadioGroup;
    Label26: TLabel;
    CheckBoxUseWheelOnKnobs: TCheckBox;
    knob_WheelSensitivity: TKnobsSmallKnob;
    KnobsDisplayWheelSensitivity: TKnobsDisplay;
    ComboBoxColors: TComboBox;
    ColorBoxCombo: TColorBox;
    looks: TKnobsModule;
    looks_editlabel: TKnobsEditLabel;
    looks_outaudio: TKnobsOutput;
    looks_inaudio: TKnobsInput;
    looks_textlabel_modulefont: TKnobsTextLabel;
    looks_outcontrol: TKnobsOutput;
    looks_incontrol: TKnobsInput;
    looks_outcontrollogic: TKnobsOutput;
    looks_incontrollogic: TKnobsInput;
    looks_outlogic: TKnobsOutput;
    looks_inlogic: TKnobsInput;
    looks_indicator_off: TKnobsIndicator;
    looks_indicator_on: TKnobsIndicator;
    looks_smallknob: TKnobsSmallKnob;
    looks_display_knob: TKnobsDisplay;
    looks_selectordouble: TKnobsSelector;
    looks_selectorsingle: TKnobsSelector;
    looks_fader: TKnobsSlider;
    looks_noknob: TKnobsNoKnob;
    looks_knob: TKnobsKnob;
    looks_smallknobmidi: TKnobsSmallKnob;
    looks_noknobmidi: TKnobsNoKnob;
    looks_knobmidi: TKnobsKnob;
    looks_fadermidi: TKnobsSlider;
    looks_faderlocked: TKnobsSlider;
    looks_smallknoblocked: TKnobsSmallKnob;
    looks_noknoblocked: TKnobsNoKnob;
    looks_knoblocked: TKnobsKnob;
    looks_inspare1: TKnobsInput;
    looks_inspare2: TKnobsInput;
    looks_outspare: TKnobsOutput;
    looks_inspare: TKnobsInput;
    looks_viewer: TKnobsDataViewer;
    looks_indicatorbar: TKnobsIndicatorBar;
    ComboBoxPresets: TComboBox;
    Label24: TLabel;
    BitBtnSaveLookAndFeel: TBitBtn;
    CheckBoxPatchChangedInCaption: TCheckBox;
    CheckBoxSourceNameInCaption: TCheckBox;
    CheckBoxProfiledInCaption: TCheckBox;
    CheckBoxAudioStatusInCaption: TCheckBox;
    CheckBoxProgramNameInCaption: TCheckBox;
    CheckBoxFileVersionInCaption: TCheckBox;
    CheckBoxPatchNameInCaption: TCheckBox;
    CheckBoxSynthNameInCaption: TCheckBox;
    CheckBoxUseUnFocus: TCheckBox;
    Label56: TLabel;
    UpDownWireThickness1: TUpDown;
    UpDownWireThickness2: TUpDown;
    CheckBoxUseConnectorBorders: TCheckBox;
    CheckBoxUseTypedConnectorBorders: TCheckBox;
    CheckBoxAutoCollectDenormals: TCheckBox;
    MenuItemModuleAlternates: TMenuItem;
    MenuItemModulePasteParamsStrict: TMenuItem;
    MenuItemPasteParamsNonStrict: TMenuItem;
    PopupMenuDataMaker: TPopupMenu;
    PopupMenuDataMakerClear: TMenuItem;
    PopupMenuDataMakerSine: TMenuItem;
    PopupMenuDataMakerCosine: TMenuItem;
    PopupMenuDataMakerArcTan: TMenuItem;
    PopupMenuDataMakerBell: TMenuItem;
    PopupMenuDataMakerTri: TMenuItem;
    PopupMenuDataMakerSaw: TMenuItem;
    PopupMenuDataMakerSquare3: TMenuItem;
    PopupMenuDataMakerSquare10: TMenuItem;
    PopupMenuDataMakerSquare33: TMenuItem;
    PopupMenuDataMakerSquare50: TMenuItem;
    PopupMenuDataMakerSquare67: TMenuItem;
    PopupMenuDataMakerSquare90: TMenuItem;
    PopupMenuDataMakerSquare97: TMenuItem;
    PopupMenuDataMakerNoise: TMenuItem;
    PopupMenuDataMakerSwapLeftRight: TMenuItem;
    PopupMenuDataMakerSwapTopBottom: TMenuItem;
    PopupMenuDataMakerRotate180: TMenuItem;
    N9: TMenuItem;
    N16: TMenuItem;
    PopupMenuDataMakerSavetofile: TMenuItem;
    PopupMenuDataMakerLoadfromfile: TMenuItem;
    SaveDialogGraphs: TSaveDialog;
    OpenDialogGraphs: TOpenDialog;
    PopupMenuDataMakerMakeloopable: TMenuItem;
    N19: TMenuItem;
    MenuActionWigglewires: TMenuItem;
    MenuActionToggleWirevisibility: TMenuItem;
    CheckBoxDisableAutoDocs: TCheckBox;
    N4: TMenuItem;
    MenuActionRandomparams: TMenuItem;
    N20: TMenuItem;
    MenuItemModuleRandomize: TMenuItem;
    MenuItemModuleExludeFromRandomization: TMenuItem;
    N21: TMenuItem;
    MenuItemKnobExcludeFromRandomization: TMenuItem;
    MenuActionToggleExcludedModules: TMenuItem;
    MenuItemKnobRandomize: TMenuItem;
    ActionMenuExcludeallfromrandomization: TMenuItem;
    ActionMenuIncludeallforrandomization: TMenuItem;
    MenuViewRandomizer: TMenuItem;
    PopupMenuXYControl: TPopupMenu;
    MenuItemXYControlRandomize: TMenuItem;
    MenuItemXYControlExcludefromrandomization: TMenuItem;
    N22: TMenuItem;
    MenuItemDataMakerExcludefromrandomization: TMenuItem;
    MenuItemDataMakerRandomize: TMenuItem;
    KnobsWormPanelVariations: TKnobsWormPanel;
    N23: TMenuItem;
    MenuViewVariation1: TMenuItem;
    MenuViewVariation2: TMenuItem;
    MenuViewVariation3: TMenuItem;
    MenuViewVariation4: TMenuItem;
    MenuViewVariation5: TMenuItem;
    MenuViewVariation6: TMenuItem;
    MenuViewVariation7: TMenuItem;
    MenuViewVariation8: TMenuItem;
    SpeedButtonChangeControlPanel: TSpeedButton;
    knob_livemorph: TKnobsKnob;
    display_livemorph: TKnobsDisplay;
    KnobsWormPatch: TKnobsWorm;
    knobsSelector_allowlivemorph: TKnobsSelector;
    TimerLiveMorphVisuals: TTimer;
    MenuActionLiveMorphModulation: TMenuItem;
    N24: TMenuItem;
    MenuActionRandomize: TMenuItem;
    MenuActionMutte: TMenuItem;
    MenuActionMate: TMenuItem;
    MenuActionMorph: TMenuItem;
    SaveDialogGridControl: TSaveDialog;
    OpenDialogGridControl: TOpenDialog;
    MenuFileLoadlastpatch: TMenuItem;
    PopupMenuGridControl: TPopupMenu;
    MenuItemGridControlSaveToFile: TMenuItem;
    MenuItemGridControlLoadFromFile: TMenuItem;
    RadioGroupRpnMode: TRadioGroup;
    LabelInputLatency: TLabel;
    Label55: TLabel;
    LabelOutputLatency: TLabel;
    Label58: TLabel;
    LabelLockSkips: TLabel;
    Label57: TLabel;
    KMakefullscale1: TMenuItem;
    RadioGroupControlDecimation: TRadioGroup;
    CheckBoxUseConfigHints: TCheckBox;
    CheckBoxUseModuleTitleHints: TCheckBox;
    ActionMenuManualCompilation: TMenuItem;
    PopupMenuTextControl: TPopupMenu;
    TextMenuEdit: TMenuItem;
    MenuViewLatestEdits: TMenuItem;
    MenuItemKnobHistory: TMenuItem;
    CheckBoxAllowAutoLoad: TCheckBox;
    MenuItemModuleHistory: TMenuItem;
    MenuItemEditorHistory: TMenuItem;
    BitBtnFindBlankControlTypes: TBitBtn;
    BitBtnShowStore: TBitBtn;
    KnobsSelectorAudioRunning: TKnobsSelector;
    KnobsSelectorReset: TKnobsSelector;
    KnobsSelectorRandomize: TKnobsSelector;
    KnobsSelectorMutate: TKnobsSelector;
    KnobsSelectorMate: TKnobsSelector;
    KnobsSelectorMorph: TKnobsSelector;
    EditNewPatchNameTemplate: TEdit;
    Label43: TLabel;
    MenuFileSaveastemplateNew: TMenuItem;
    CheckBoxGuidInCaption: TCheckBox;
    KnobsSelectorRanges: TKnobsSelector;
    LabelRange: TLabel;
    knob_morph: TKnobsKnob;
    KnobsDisplayCurrentRange: TKnobsDisplay;
    Label37: TLabel;
    Label38: TLabel;
    LedOSCEnabled: TKnobsLed;
    Label29: TLabel;
    Label28: TLabel;
    LedOSCRx1: TKnobsLed;
    LedOSCTx1: TKnobsLed;
    LedNetMidiRx1: TKnobsLed;
    LedNetMidiConnect1: TKnobsLed;
    Label20: TLabel;
    Label19: TLabel;
    Label18: TLabel;
    Label6: TLabel;
    LedNetMidiTx1: TKnobsLed;
    LabelCpuUsage: TLabel;
    KnobsLedUnderflows: TKnobsLed;
    knobsselector_allowmorphmod: TKnobsSelector;
    MenuActionMorphModulation: TMenuItem;
    CheckBoxUseNoteNames: TCheckBox;
    CheckBoxModuleFlatness: TCheckBox;
    CheckBoxModuleTexture: TCheckBox;
    LabelMorph: TLabel;
    BevelCPU: TBevel;
    BevelMutate: TBevel;
    BevelTuning: TBevel;
    LabelAttention: TLabel;
    CheckBoxNoLoadTuning: TCheckBox;
    BevelMorph: TBevel;
    LabelReferenceA: TLabel;
    LabelHz: TLabel;
    LabelNotesPerOctave: TLabel;
    LabelMiddleNote: TLabel;
    LabelOctaveSpan: TLabel;
    EditReferenceA: TEdit;
    EditNotesPerOctave: TEdit;
    EditMiddleNote: TEdit;
    BitBtnApplyTuning: TBitBtn;
    BitBtnCancelTuning: TBitBtn;
    EditOctaveSpan: TEdit;
    EditTextWriterPrefix: TEdit;
    Label3: TLabel;
    procedure BitBtnExItClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtnDebugStepClick(Sender: TObject);
    procedure BitBtnClearClick(Sender: TObject);
    procedure BitBtnClearGraphsClick(Sender: TObject);
    procedure BitBtnDebugRunClick(Sender: TObject);
    procedure CheckBoxUseGraphsClick(Sender: TObject);
    procedure BitBtnDebugResetClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBoxGraphStairsClick(Sender: TObject);
    procedure BitBtnDumpClick(Sender: TObject);
    procedure knob_outputlevel1ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure knob_inputlevel1ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure TimerStatsUpdateTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxReloadLastPatchClick(Sender: TObject);
    procedure CheckBoxAutoRunClick(Sender: TObject);
    procedure BitBtnDocumentClick(Sender: TObject);
    procedure ModuleSelectorModuleButtonClick(aSender: TObject; aModuleclass: Integer);
    procedure MenuFileLoadClick(Sender: TObject);
    procedure MenuFileSaveClick(Sender: TObject);
    procedure MenuFileSaveAsClick(Sender: TObject);
    procedure MenuFileExitProgramClick(Sender: TObject);
    procedure MenuEditDeleteClick(Sender: TObject);
    procedure MenuEditCutClick(Sender: TObject);
    procedure MenuEditCopyClick(Sender: TObject);
    procedure MenuEditPasteClick(Sender: TObject);
    procedure MenuEditSelectAllClick(Sender: TObject);
    procedure MenuEditInvertSelectionClick(Sender: TObject);
    procedure MenuEditUndoClick(Sender: TObject);
    procedure MenuEditRedoClick(Sender: TObject);
    procedure MenuEditWiggleWiresClick(Sender: TObject);
    procedure MenuSetupDevicesClick(Sender: TObject);
    procedure MenuFileNewClick(Sender: TObject);
    procedure CheckBoxCurvedLinesClick(Sender: TObject);
    procedure MenuHelpHelpClick(Sender: TObject);
    procedure MenuSetupSettingsClick(Sender: TObject);
    procedure MenuViewEditorClick(Sender: TObject);
    procedure MenuViewDebuggerClick(Sender: TObject);
    procedure MenuViewGraphsClick(Sender: TObject);
    procedure MenuViewSettingsClick(Sender: TObject);
    procedure EditNotesPerOctaveChange(Sender: TObject);
    procedure EditReferenceAChange(Sender: TObject);
    procedure BitBtnProfileClick(Sender: TObject);
    procedure KnobsSmallKnob_LeftOffsetValueChanged(aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure KnobsSmallKnob_TopOffsetValueChanged(aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure MenuActionRunStopClick(Sender: TObject);
    procedure MenuEditSelectNoneClick(Sender: TObject);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure RadioGroupControlModeClick(Sender: TObject);
    procedure BitBtnNetMidiConnectClick(Sender: TObject);
    procedure CheckBoxNetMidiAutoConnectClick(Sender: TObject);
    procedure BitBtnApplyNetMidiClick(Sender: TObject);
    procedure BitBtnCancelNetMidiClick(Sender: TObject);
    procedure EditNetMidiServerChange(Sender: TObject);
    procedure EditNetMidiPortChange(Sender: TObject);
    procedure TimerNetMidiConnectTimer(Sender: TObject);
    procedure WSocketNetMidiBgException(Sender: TObject; E: Exception; var CanClose: Boolean);
    procedure WSocketNetMidiChangeState(Sender: TObject; OldState, NewState: TSocketState);
    procedure WSocketNetMidiDataAvailable(Sender: TObject; ErrCode: Word);
    procedure WSocketNetMidiDataSent(Sender: TObject; ErrCode: Word);
    procedure WSocketNetMidiSessionClosed(Sender: TObject; ErrCode: Word);
    procedure WSocketNetMidiSessionConnected(Sender: TObject; ErrCode: Word);
    procedure CheckBoxLogMidiClick(Sender: TObject);
    procedure CheckBoxLogMidiMsgsClick(Sender: TObject);
    procedure EditSearchChange(Sender: TObject);
    procedure CheckBoxCompilerDebugClick(Sender: TObject);
    procedure MenuActionProfileClick(Sender: TObject);
    procedure MenuEditFindClick(Sender: TObject);
    procedure EditMiddleNoteChange(Sender: TObject);
    procedure DeleteConnectorClick(Sender: TObject);
    procedure BreakConnectorClick(Sender: TObject);
    procedure DisconnectConnectorClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure CheckBoxWarnOnPatchChangeClick(Sender: TObject);
    procedure MenuItemModuleCutClick(Sender: TObject);
    procedure MenuItemModuleCopyClick(Sender: TObject);
    procedure MenuItemModuleDeleteClick(Sender: TObject);
    procedure SetKnobDefaultvalueClick(Sender: TObject);
    procedure LockKnobClick(Sender: TObject);
    procedure LabeldBOutMaxClick(Sender: TObject);
    procedure LabeldBInMaxClick(Sender: TObject);
    procedure TimerLightsUpdateTimer(Sender: TObject);
    procedure RadioGroupSampleRateClick(Sender: TObject);
    procedure LabelRunTimeClick(Sender: TObject);
    procedure KnobsSmallKnob_LightsRateValueChanged(aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure KnobsSelectorFileRenderValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure MenuItemModuleColorClick(Sender: TObject);
    procedure CheckBoxUseWheelOnKnobsClick(Sender: TObject);
    procedure knob_WheelSensitivityValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure CheckBoxUseUnFocusClick(Sender: TObject);
    procedure MenuEditFindunconnectedmodulesClick(Sender: TObject);
    procedure KnobsSmallKnobModuleOpacityValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure IndicatorBarVolumeDblClick(Sender: TObject);
    procedure CheckBoxClearVUOnStopClick(Sender: TObject);
    procedure MenuFileSaveastemplate1Click(Sender: TObject);
    procedure MenuFileSaveastemplate2Click(Sender: TObject);
    procedure MenuActionStartfilerenderClick(Sender: TObject);
    procedure MenuFileImportmodulesClick(Sender: TObject);
    procedure MenuFileExportselectedmodulesClick(Sender: TObject);
    procedure SpeedButtonChangeControlPanelClick(Sender: TObject);
    procedure MenuActionResetClick(Sender: TObject);
    procedure MenuEditPasteValuesClick(Sender: TObject);
    procedure MenuActionRecompileClick(Sender: TObject);
    procedure BitBtnApplyTuningClick(Sender: TObject);
    procedure BitBtnCancelTuningClick(Sender: TObject);
    procedure Checkforupdates1Click(Sender: TObject);
    procedure BitBtnCheckForUpdatesClick(Sender: TObject);
    procedure KnobsNoKnob_HistoryCountValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure CheckBoxClearVUOnRecompileClick(Sender: TObject);
    procedure CheckBoxWarnChangeOnLoadClick(Sender: TObject);
    procedure CheckBoxUndoAfterSaveClick(Sender: TObject);
    procedure CheckBoxUndoAfterLoadClick(Sender: TObject);
    procedure CheckBoxAbsTimeStampsClick(Sender: TObject);
    procedure ModuleHelpClick(Sender: TObject);
    procedure CheckBoxLogToFileClick(Sender: TObject);
    procedure BitBtnAcknowledgementsClick(Sender: TObject);
    procedure CheckBoxPatchChangedInCaptionClick(Sender: TObject);
    procedure CheckBoxProfiledInCaptionClick(Sender: TObject);
    procedure CheckBoxAudioStatusInCaptionClick(Sender: TObject);
    procedure CheckBoxProgramNameInCaptionClick(Sender: TObject);
    procedure CheckBoxFileVersionInCaptionClick(Sender: TObject);
    procedure CheckBoxPatchNameInCaptionClick(Sender: TObject);
    procedure CheckBoxSourceNameInCaptionClick(Sender: TObject);
    procedure BitBtnCloseDubuggerClick(Sender: TObject);
    procedure BitBtnCloseGraphsClick(Sender: TObject);
    procedure MakeGreenClick(Sender: TObject);
    procedure Redwires1Click(Sender: TObject);
    procedure Bluewires1Click(Sender: TObject);
    procedure Yellowwires1Click(Sender: TObject);
    procedure Customwirecolor1Click(Sender: TObject);
    procedure Defaultwirecolor1Click(Sender: TObject);
    procedure BitBtnModuleTitleFontClick(Sender: TObject);
    procedure BitBtnModuleFontClick(Sender: TObject);
    procedure CheckBoxUseConfigHintsClick(Sender: TObject);
    procedure CheckBoxStandardColorsClick(Sender: TObject);
    procedure MenuItemModuleDefaultcolorClick(Sender: TObject);
    procedure WSocketOSCDataAvailable(Sender: TObject; ErrCode: Word);
    procedure EditOSCServerChange(Sender: TObject);
    procedure EditOSCPortChange(Sender: TObject);
    procedure CheckBoxUseOSCClick(Sender: TObject);
    procedure BitBtnApplyOSCClick(Sender: TObject);
    procedure BitBtnCancelOSCClick(Sender: TObject);
    procedure CheckBoxLogOSCClick(Sender: TObject);
    procedure BitBtnSendOSCTestMessageClick(Sender: TObject);
    procedure WSocketOSCSessionAvailable(Sender: TObject; ErrCode: Word);
    procedure WSocketOSCSessionClosed(Sender: TObject; ErrCode: Word);
    procedure WSocketOSCSessionConnected(Sender: TObject; ErrCode: Word);
    procedure WSocketOSCDataSent(Sender: TObject; ErrCode: Word);
    procedure CheckBoxLogOSCMsgsClick(Sender: TObject);
    procedure WSocketOSCChangeState(Sender: TObject; OldState, NewState: TSocketState);
    procedure TimerOSCGuardTimer(Sender: TObject);
    procedure WSocketOSCBgException(Sender: TObject; E: Exception; var CanClose: Boolean);
    procedure CheckBoxSynthNameInCaptionClick(Sender: TObject);
    procedure EditSynthNameChange(Sender: TObject);
    procedure KnobMIDICCClick(Sender: TObject);
    procedure main_midichValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure MenuViewMidiClick(Sender: TObject);
    procedure AssigntoCCClick(Sender: TObject);
    procedure UnassignCCClick(Sender: TObject);
    procedure knob_inputlevel2ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knob_outputlevel2ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knob_outputlevel3ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knob_inputlevel3ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knob_inputlevel4ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knob_outputlevel4ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure BitBtnView1Click(Sender: TObject);
    procedure knob_iolevel_UnFocus(const aSender: TObject);
    procedure MenuItemModuleSaveAsPresetClick(Sender: TObject);
    procedure MenuItemModuleLoadFromPresetClick(Sender: TObject);
    procedure MenuFileLoadpatchPresetClick(Sender: TObject);
    procedure MenuSavepatchpresetClick(Sender: TObject);
    procedure CheckBoxSearchPatchClick(Sender: TObject);
    procedure CheckBoxSearchSelectorClick(Sender: TObject);
    procedure CheckBoxWarnOnStructMismatchClick(Sender: TObject);
    procedure EditSearchKeyPress(Sender: TObject; var Key: Char);
    procedure SpeedButtonChangeModuleSelectorClick(Sender: TObject);
    procedure ModuleSelectorResize(Sender: TObject);
    procedure cut1Click(Sender: TObject);
    procedure copy1Click(Sender: TObject);
    procedure paste1Click(Sender: TObject);
    procedure pastevalues1Click(Sender: TObject);
    procedure delete1Click(Sender: TObject);
    procedure selectall1Click(Sender: TObject);
    procedure invertselection1Click(Sender: TObject);
    procedure selectnone1Click(Sender: TObject);
    procedure MenuFileLoadtemplate1Click(Sender: TObject);
    procedure MenuFileLoadtemplate2Click(Sender: TObject);
    procedure MenuEditToggleWiresClick(Sender: TObject);
    procedure MenuActionToggleSoundClick(Sender: TObject);
    procedure MenuViewTopPaneClick(Sender: TObject);
    procedure PageControlMainChange(Sender: TObject);
    procedure MenuActionTogglelightsClick(Sender: TObject);
    procedure MenuActionPanicClick(Sender: TObject);
    procedure ComboBoxThemesChange(Sender: TObject);
    procedure ComboBoxColorsChange(Sender: TObject);
    procedure ColorBoxComboChange(Sender: TObject);
    procedure BitBtnSaveLookAndFeelClick(Sender: TObject);
    procedure ComboBoxPresetsChange(Sender: TObject);
    function ModuleSelectorGetGlyph(const aSender: TObject; const aBitmapsFolder, aName: string): TBitmap;
    procedure LocalUnfocus(const aSender: TObject);
    procedure UpDownWireThicknessClick(Sender: TObject; Button: TUDBtnType);
    procedure CheckBoxUseConnectorBordersClick(Sender: TObject);
    procedure CheckBoxUseTypedConnectorBordersClick(Sender: TObject);
    procedure CheckBoxAutoCollectDenormalsClick(Sender: TObject);
    procedure MenuItemPasteParamsNonStrictClick(Sender: TObject);
    procedure MenuItemModulePasteParamsStrictClick(Sender: TObject);
    procedure PopupMenuDataMakerClick(Sender: TObject);
    procedure CheckBoxDisableAutoDocsClick(Sender: TObject);
    procedure MenuActionRandomparamsClick(Sender: TObject);
    procedure MenuItemModuleRandomizeClick(Sender: TObject);
    procedure ToggleSelectorRandomizationClick(Sender: TObject);
    procedure MenuItemModuleExludeFromRandomizationClick(Sender: TObject);
    procedure MenuActionToggleExcludedModulesClick(Sender: TObject);
    procedure MenuItemKnobRandomizeClick(Sender: TObject);
    procedure ActionMenuExcludeallfromrandomizationClick(Sender: TObject);
    procedure ActionMenuIncludeallforrandomizationClick(Sender: TObject);
    procedure MenuViewRandomizerClick(Sender: TObject);
    procedure MenuItemXYControlRandomizeClick(Sender: TObject);
    procedure MenuItemXYControlExcludefromrandomizationClick(Sender: TObject);
    procedure MenuItemDataMakerRandomizeClick(Sender: TObject);
    procedure MenuItemDataMakerExcludefromrandomizationClick(Sender: TObject);
    procedure VariationSelectClicked(Sender: TObject);
    procedure KnobsWormPanelVariationsSelected(Sender: TObject);
    procedure knob_livemorphValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure knobsSelector_allowlivemorphValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure TimerLiveMorphVisualsTimer(Sender: TObject);
    procedure MenuActionLiveMorphModulationClick(Sender: TObject);
    procedure MenuActionRandomizeClick(Sender: TObject);
    procedure MenuActionMutteClick(Sender: TObject);
    procedure MenuActionMateClick(Sender: TObject);
    procedure MenuActionMorphClick(Sender: TObject);
    procedure MenuFileLoadlastpatchClick(Sender: TObject);
    procedure MenuItemGridControlSaveToFileClick(Sender: TObject);
    procedure MenuItemGridControlLoadFromFileClick(Sender: TObject);
    procedure RadioGroupRpnModeClick(Sender: TObject);
    procedure RadioGroupControlDecimationClick(Sender: TObject);
    procedure CheckBoxUseModuleTitleHintsClick(Sender: TObject);
    procedure ActionMenuManualCompilationClick(Sender: TObject);
    procedure TextMenuEditClick(Sender: TObject);
    procedure MenuViewLatestEditsClick(Sender: TObject);
    procedure CheckBoxAllowAutoLoadClick(Sender: TObject);
    procedure BitBtnFindBlankControlTypesClick(Sender: TObject);
    procedure BitBtnShowStoreClick(Sender: TObject);
    procedure KnobsSelectorResetValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure KnobsSelectorAudioRunningValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure KnobsSelectorRandomizeValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure KnobsSelectorMutateValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure KnobsSelectorMateValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure KnobsSelectorMorphValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
      IsFinal, IsAutomation: Boolean);
    procedure EditNewPatchNameTemplateChange(Sender: TObject);
    procedure MenuFileSaveastemplateNewClick(Sender: TObject);
    procedure CheckBoxGuidInCaptionClick(Sender: TObject);
    procedure KnobsSelectorRangesKnobPositionChanged(const aSender: TKnobsValuedControl; const aPath,
      aControlType: string; aPosition: Integer);
    procedure knob_morphValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure SelectorRightClick(const aSender: TObject);
    procedure knobsselector_allowmorphmodValueChanged(const aSender: TObject; const aPath, aControlType: string;
      aValue: Double; IsFinal, IsAutomation: Boolean);
    procedure MenuActionMorphModulationClick(Sender: TObject);
    procedure CheckBoxUseNoteNamesClick(Sender: TObject);
    procedure CheckBoxModuleFlatnessClick(Sender: TObject);
    procedure CheckBoxModuleTextureClick(Sender: TObject);
    procedure EditOctaveSpanChange(Sender: TObject);
    procedure CheckBoxNoLoadTuningClick(Sender: TObject);
    procedure EditTextWriterPrefixChange(Sender: TObject);
  private
    FOldMemoDebug             : TWndMethod;                   // Startup (original) window proc for the debug memo
  private
    FSynthName                : string;                       // OSC synth name
    FClosing                  : Boolean;                      // Set to true when closing down the program, precenting some actions to be processed
    FSavedLogs                : TStringList;                  // Used to store log strings when logging is still disabled.
    FCanLog                   : Boolean;                      // Indicates whether logging is enableed or not
    FLogToFile                : Boolean;                      // When true log to a logfile in addition to the internal memo
    FIniLoaded                : Boolean;                      // True on successful load of ini file - no auto ini save when false
    FEditorBackgroundColor    : TColor;                       // Color of the patch editor pane
    FStandardColors           : Boolean;                      // When true use the standard color on new modules added.
    FUseConnectorBorders      : Boolean;                      // Whether to draw a border around connectors or not
    FUseTypedConnectorBorders : Boolean;                      // Whether to give connectors a border colored acording to signal type or not
    FUseNoteNames             : Boolean;                      // Whether note names should be used in frequency displays instead of frequencies
    FPrioLevel                : Integer;                      // Current process priority level
    FBufferSize               : Integer;                      // Audio buffer size as requested by user
    FInMasks                  : array[ 0 .. 7] of Integer;    // Audio channel selections
    FOutMasks                 : array[ 0 .. 7] of Integer;    // Audio channel selections
    FLightsActive             : Boolean;                      // Debug thingie for turning lights updates on / off
    FAbsTimeStamps            : Boolean;                      // Use absolute time or time relative to program start time
    FUseGraphs                : Boolean;                      // Make use of the graphs or not
    FGraphStairs              : Boolean;                      // Make the graphs smooth or stair stepped
    FHistoryCount             : Integer;                      // Number of files to hold in file history
    FRecentSourceFiles        : TRecentStrings;               // The file history itself
    FOrigCaption              : string;                       // Program startup caption for main screen (as set at design time)
    FReloadLastPatch          : Boolean;                      // True when on program start the last patch must be reloaded
    FDoAutoRun                : Boolean;                      // Autorun flag as read from INI file, used to delay autorun going active
    FAutoRun                  : Boolean;                      // True when audio processing must be turned on after program start
    FClearVUOnStop            : Boolean;                      // Clear main VU meters when audio processing is stopped
    FClearVUOnRecompile       : Boolean;                      // Clear main VU meters when a patch gets compiled
    FRenderToFile             : Boolean;                      // Do not output real time audio, but write it to a file
    FRenderFileName           : string;                       // The file used to write generated audio into
    FRenderDuration           : string;                       // The maximum render time as set by the user on render start
    FRenderFile               : TStereoWaveWriter;            // The render file encapsulation
    FPatchChanged             : Boolean;                      // True when the in memory patch differs from the one on disk
    FWarnOnPatchChange        : Boolean;                      // Whether a patch changed warning must be issued on program exit
    FWarnChangeOnLoad         : Boolean;                      // Whether a patch changed warning must be issued on loading a new patch
    FUndoAfterSave            : Boolean;                      // Allow for undo after a patch was saved
    FUndoAfterLoad            : Boolean;                      // Allow for a patch load action to be undone
    FUseWheelOnKnobs          : Boolean;                      // Use the mouse wheel to control knobs
    FWheelSensitivity         : Integer;                      // The amount of mouse wheel action needed for a ceratin knob movement
    FUseUnfocus               : Boolean;                      // Whether a knob should loose focus when the mouse moves out of it
    FPopupSender              : TControl;                     // The control that caused a popup menu to be shown
    FTuningChanged            : Boolean;                      // True when the main tuning was changed but not applied or cancelled yet
    FSearchPatch              : Boolean;                      // True when search operations work on the patch
    FSearchSelector           : Boolean;                      // True when search operations work on the module selector
    FWarnOnStructMismatch     : Boolean;                      // True when struct mismatch warnings must be shown on param pastes
    FDisableAutoDocs          : Boolean;                      // True when documenttion should not be automaticlly generated
    FAllowAutoLoad            : Boolean;                      // True when the editor's auto mode is to be loaded from the the ini file
    FNoLoadTuning             : Boolean;                      // True when tuning parameters should never be loaded on patch read
    FNewPatchNameTemplate     : string;                       // Template to use for names of newly created patches
    FTextWriterPrefix         : string;                       // Prefix text to use on the TextWriter module's output strings
  private
    FMidiReceiver             : TMidiReceiver;                // MIDI data reception    handler
    FMidiTransmitter          : TMidiTransmitter;             // MIDI data transmission handler
    FNetMidiServer            : string;                       // IP address of NetMIDI / MidiTangle server
    FNetMidiPort              : string;                       // IP port    of NetMIDI / MidiTangle server
    FNetMidiAutoConnect       : Boolean;                      // True when at program startup a connection to the MIDI servrr should be made
    FNetMidiConnected         : Boolean;                      // True when a MIDI server is connected
    FNetMidiChanged           : Boolean;                      // True when unapplied or uncancelled changes were made for the MIDI server settings
    FLogMidi                  : Boolean;                      // True when MIDI activity should be logged
    FLogMidiMsgs              : Boolean;                      // True when MIDI messages should be logged
    FMidiChannel              : Byte;                         // MIDI channel for non-midi modules, 0 -> channel 1, 16 -> OMNI (xmit on 1)
    FMidiRpnMode              : TRpnMode;                     // Select between 7 and 14 bit (N)RPN modes
  private
    FOSCServer                : string;                       // IP address of OSC server, or blank when client
    FOSCPort                  : string;                       // IP port    of OSC server or client
    FUSeOSC                   : Boolean;                      // True when OSC is to be used
    FOSCChanged               : Boolean;                      // True when OSC settings were changed and not applied or cancelled
    FLogOSC                   : Boolean;                      // True when OSC activity should be logged
    FLogOSCMsgs               : Boolean;                      // True when OSC messages should be logged
  private
    FManualCompilation        : Boolean;                      // When true automatic patch compilation is off
    FUncompiledChanges        : Boolean;                      // When true there are pending patch changes needing recompilation.
    FAutoCollectDenormals     : Boolean;                      // When true scan current patch for denormals once every second.
    FCompilerDebug            : Boolean;                      // When true some compiler related files will be generated when a patch gets compiled
    FDebugRunning             : Boolean;                      // True for a debug run, a debug run makes graphs instead of audio
    FSynthPatch               : TSynthPatch;                  // The compiled synth patch - the audio generator
    FChartSeries              : array of TFastLineSeries;     // A set of graphs for the graphs mode
    FUpdateCounter            : Integer;                      // Cycle counter for toggling between lights updating and other update actions
    FCanCreateAudio           : Boolean;                      // Set to true when the program is ready to create and handle audio devices
  private
    FPortAudioAvailable       : Boolean;                      // True when the port audio DLL was detected and initialised
    FSelectedAPIID            : Integer;                      // The selected port audio API to be used (DirectX, ASIO, etc.)
  private
    FFFTWAvailable            : Boolean;                      // True when the FFTW DLL was found to be present and usable
    FESpeaker                 : TESpeakSpeaker;               // Interface to the espeaj API
    FESpeakAvailable          : Boolean;                      // True whe eSpeak's espeak-sapidll was found, FESpeaker will be non-nil then too
  private
    FSampleCount              : Int64;                        // Number of samples processed, being reset on patch compilation
    FTickInData               : TSignalArray;                 // Audio samples passed into the synth
    FTickInZeroData           : TSignalArray;                 // Audio samples passed into the synth, all set to zero
    FTickOutData              : TSignalArray;
  private
    FSelectedInputIdPA        : DWORD;                        // Input  device IS for port audio audio
    FSelectedOutputIdPA       : DWORD;                        // Output device ID for port audio audio
  private
    FPaStream                 : Pointer;                      // Port Audio stream handle
    FPaInstreamParameters     : TPaStreamParameters;          // Port audio input  stream parameters
    FPaOutstreamParameters    : TPaStreamParameters;          // Port audio output stream parameters
    FPaAsioInStreamInfo       : TPaAsioStreamInfo;            // Port audio asio input  stream parameters
    FPaAsioOutStreamInfo      : TPaAsioStreamInfo;            // Port audio asio output stream parameters
    FPaAsioMinFrames          : clong;
    FPaAsioMaxFrames          : clong;
    FPaAsioPrefFrames         : clong;
    FPaAsioGranFrames         : clong;
  private
    FPaInUnderflows           : Int64;                        // Port audio input  underflow counter
    FPaInoverflows            : Int64;                        // Port audio input  overflow  counter
    FPaOutUnderflows          : Int64;                        // Port audio output underflow counter
    FPaOutoverflows           : Int64;                        // Port audio output overflow  counter
    FLastAudioInUnderflows    : Int64;                        // Used to keep track of changes in input  underflow count
    FLastAudioInOverflows     : Int64;                        // Used to keep track of changes in input  overflow  count
    FLastAudioOutUnderflows   : Int64;                        // Used to keep track of changes in output underflow count
    FLastAudioOutOverflows    : Int64;                        // Used to keep track of changes in output overflow  count
    FPatchReader              : IKnobsPatchReader;            // Patch reader
    FPatchWriter              : IKnobsPatchWriter;            // Patch writer
  private
    FInShadow1                : TSignal;                      // Dezipper register for InVolume1
    FInShadow2                : TSignal;                      //
    FInShadow3                : TSignal;                      //  ... ...
    FInShadow4                : TSignal;                      //
    FOutShadow1               : TSignal;                      //
    FOutShadow2               : TSignal;                      //  ... ...
    FOutShadow3               : TSignal;                      //
    FOutShadow4               : TSignal;                      // Dezipper register for OutVolume4
    FInVolume1                : TSignal;                      // Current channel 1 input volume
    FInVolume2                : TSignal;                      //
    FInVolume3                : TSignal;                      //  ... ...
    FInVolume4                : TSignal;                      //
    FOutVolume1               : TSignal;                      //
    FOutVolume2               : TSignal;                      //  ... ...
    FOutVolume3               : TSignal;                      //
    FOutVolume4               : TSignal;                      // Current channel 4 output volume
    FSounding                 : Boolean;                      // True when sound out not muted
    FAudioRunning             : Boolean;
  private
    FUseConfigHints           : Boolean;                      // Whether to use popup hints on the config screens
    FUseModuleTitleHints      : Boolean;                      // Whether to use popup hints on module titles
    FWireThickness            : Integer;                      // Pen size for wire drawing
    FCurvedLines              : Boolean;                      // True for curved lines instead of straight ones
    FControlMode              : TDistanceMode;                // Knob control mode (circular, horizontal, vertical)
    FReferenceA               : TSignal;                      // Frequency of reference A
    FNotesPerOctave           : TSignal;                      // The number of notes in a octave
    FMiddleNote               : TSignal;                      // The MIDI note number used to result in the reference A
    FOctaveSpan               : TSignal;                      // The span factor of an octave
    FLightsRate               : TSignal;                      // Lights update rate in the patch editor
    FResetOnRender            : Boolean;                      // When true a patch reset is issued when rendering starts, otherwise rendering starts where the patch currently happens to be
    FShowTopPane              : Boolean;                      // When true the top pane with the module selector on it will be visible
  private
    FSynthNameInCaption       : Boolean;                      // When true show a 'OSC synth name'   indicator in the main window title bar
    FPatchChangedInCaption    : Boolean;                      // When true show a 'patch changed'    indicator in the main window title bar
    FProfiledInCaption        : Boolean;                      // When true show a 'profiled'         indicator in the main window title bar
    FAudioStatusInCaption     : Boolean;                      // When true show a 'audio status'     indicator in the main window title bar
    FProgramNameInCaption     : Boolean;                      // When true show a 'program exe name' indicator in the main window title bar
    FFileVersionInCaption     : Boolean;                      // When true show a 'program version'  indicator in the main window title bar
    FPatchNameInCaption       : Boolean;                      // When true show a 'patch name'       indicator in the main window title bar
    FSourceNameInCaption      : Boolean;                      // When true show a 'patch file name'  indicator in the main window title bar
    FGuidInCaption            : Boolean;                      // When true show a 'patch uniqueID'   indicator in the main window title bar
  private
    FDbMinMaxIn               : TArray<TDbMinMax>;            // dB calculators for input  channelse
    FDbMinMaxOut              : TArray<TDbMinMax>;            // dB calculators for output channelse
    FVuSampleCount            : Integer;                      // Samples / buffer, used to calculate VU timing
    FVuSystemRate             : Integer;                      // Samples / second, used to check sample rate change for VU meters
    FLightsTime               : TSignal;                      // Time spent in lights updater
  private
    FCpuUsageData             : PCPUUsageData;                // CPU usage calculator
    FProcessTime              : Single;                       // Current CPU usage percentage
  private
    FRequestAudioStart        : Boolean;                      // Async request to start audio devices
    FRequestAsioPanel         : Boolean;                      // Async request to start ASIO panel
    FRequestAudioRestart      : Boolean;                      // Async request to restart audio devices
    FPanelAudioWasRunning     : Boolean;                      // Flag to restart audio after ASIO panel was shown
    FAsioPanelDevice          : TPaDeviceIndex;               // The device on whcich the ASIO panel was opened
    FAsioPanelPointer         : Pointer;                      // Handle for ASIO panel
  private
    FRequestImport            : Boolean;                      // Flag to signal file import request
    FRequestedImportName      : string;                       // Name of file requested to be imported
  private
    FLastControlWidth         : Integer;                      // State for volume control panel folding
    FLastSelectorWidth        : Integer;                      // State for module selector folding
  private
    FMidiFifo                 : TBytesFifo;                   // Fifo for storing MIDI messages coming from synth
    FOSCFifo                  : TBytesFifo;                   // Fifo for storing OSC  messages coming from synth
    FLastCC                   : Byte;                         // Last MIDI CC seen (on assigned channel, or in OMNI mode).
    FLastFrozenCC             : Byte;                         // Last frozen MIDI CC seen (on assigned channel, or in OMNI mode).
  private
    FPatchFolder              : string;                       // Name of last folder used for regular patch read or write operations
    FTemplateFolder           : string;                       // Name of last folder used to do anything with (module) templates or presets.
    FImportFolder             : string;                       // Name of last folder used for file imports
    FGraphsFolder             : string;                       // Name of last folder used for graph        load or save
    FGridControlFolder        : string;                       // Name of last folder used for grid control load or save
  private
    FColorMaps                : TColorMaps;                   // All custom colors and their names
    FCurrentColor             : TColorId;                     // The currently selected color items
    FClonedLooks              : TKnobsCustomModule;           // The looks preview
    FCanLoadLookAndFeel       : Boolean;                      // (Dis)Allow loading of look and feel
    FLooksFolder              : string;                       // Folder last looks were loaded from
    FInFormShow               : Boolean;                      // Flag to indicate we are in FormShow, we can not do some theme stuff in that case
  private
    FSignalSpecs              : TKnobsModuleSignalSpecs;      // Detailed patch information
  private
    FLastWiresVisible         : Boolean;
  private
    FMorphAccu                : TSignal;
    FWormUpdateLock           : Integer;
    FLiveMorph                : TSignal;
    FOldLiveMorph             : TSignal;
    FallowLiveMorphMod        : Boolean;
    FAllowMorphMod            : Boolean;
  private
    FAttentionItems           : TAttentionItems;
    FAttentionItem            : TAttentionItem;
  private
    FMazeList                 : TStringList;
    FSapiVoiceNames           : TStringList;
    FSapiRateNames            : TStringList;
  private
    procedure   UpdateCaptions;
    procedure   FixControlFoldButton;
    procedure   FixSelectorFoldButton;
    procedure   FixSearchVisuals;
    procedure   FixLocalControls;
    procedure   FixTabColors;
    procedure   FixMenu;
    procedure   FixMorphsAndRanges;
    procedure   FixLookAndFeelPresets;
    procedure   SyncLookAndFeelPresets;
    procedure   LoadModuleGlyphs;
    function    LooksIniName: string;
    procedure   SaveLookAndFeel;
    procedure   LoadLookAndFeel( const aFolder: string);
    procedure   DoLooksEditorClicked( aSender: TObject);
  private
    procedure   SplashKill;
  private
    function    GetColorMapLength: Integer;
    procedure   SetColorMapLength( aValue: Integer);
    procedure   SetCurrentColor( aValue: TColorId);
    function    GetColor( anIndex: TColorId): TColor;
    procedure   SetColor( anIndex: TColorId; aValue: TColor);
    procedure   AddColorMap( anId: TColorId; const aName: string; const aGetter: TColorGetter; const aSetter: TColorSetter);
    procedure   FixColorMaps;
    procedure   ChangeColorId( anIndex: Integer);
    procedure   ChangeCurrentColor( aColor: TColor);
  private
    procedure   SetSynthName               ( const aValue: string);
    procedure   SetCanLog                  ( aValue: Boolean);
    procedure   SetLogToFile               ( aValue: Boolean);
    function    GetOffsetLeft              : Integer;
    procedure   SetOffsetLeft              ( aValue: Integer);
    function    GetOffsetTop               : Integer;
    procedure   SetOffsetTop               ( aValue: Integer);
    function    GetModuleColor             : TColor;
    procedure   SetModuleColor             ( aValue: TColor);
    function    GetConnectorBorderColor    : TColor;
    procedure   SetConnectorBorderColor    ( aValue: TColor);
    function    GetSelectorColor           : TColor;
    procedure   SetSelectorColor           ( aValue: TColor);
    function    GetSelectorBorderColor     : TColor;
    procedure   SetSelectorBorderColor     ( aValue: TColor);
    function    GetSelectorBorderColorS    : TColor;
    procedure   SetSelectorBorderColorS    ( aValue: TColor);
    function    GetDisplayColor            : TColor;
    procedure   SetDisplayColor            ( aValue: TColor);
    function    GetDisplayBorderColor      : TColor;
    procedure   SetDisplayBorderColor      ( aValue: TColor);
    function    GetKnobMIDIColor           : TColor;
    procedure   SetKnobMIDIColor           ( aValue: TColor);
    function    GetKnobFocusColor          : TColor;
    procedure   SetKnobFocusColor          ( aValue: TColor);
    function    GetKnobMIDIFocusColor      : TColor;
    procedure   SetKnobMIDIFocusColor      ( aValue: TColor);
    function    GetViewerColor             : TColor;
    procedure   SetViewerColor             ( aValue: TColor);
    function    GetViewerBorderColor       : TColor;
    procedure   SetViewerBorderColor       ( aValue: TColor);
    function    GetViewerLineColor         : TColor;
    procedure   SetViewerLineColor         ( aValue: TColor);
    function    GetViewerFillColor         : TColor;
    procedure   SetViewerFillColor         ( aValue: TColor);
    function    GetIndBarPeakColor         : TColor;
    procedure   SetIndBarPeakColor         ( aValue: TColor);
    function    GetIndBarValeyColor        : TColor;
    procedure   SetIndBarValeyColor        ( aValue: TColor);
    function    GetGroupIOColor            : TColor;
    procedure   SetGroupIOColor            ( aValue: TColor);
    function    GetGroupOSCColor           : TColor;
    procedure   SetGroupOSCColor           ( aValue: TColor);
    function    GetGroupLFOColor           : TColor;
    procedure   SetGroupLFOColor           ( aValue: TColor);
    function    GetGroupEnvColor           : TColor;
    procedure   SetGroupEnvColor           ( aValue: TColor);
    function    GetGroupFilterColor        : TColor;
    procedure   SetGroupFilterColor        ( aValue: TColor);
    function    GetGroupSwitchColor        : TColor;
    procedure   SetGroupSwitchColor        ( aValue: TColor);
    function    GetGroupMixColor           : TColor;
    procedure   SetGroupMixColor           ( aValue: TColor);
    function    GetGroupControlColor       : TColor;
    procedure   SetGroupControlColor       ( aValue: TColor);
    function    GetGroupNoteColor          : TColor;
    procedure   SetGroupNoteColor          ( aValue: TColor);
    function    GetGroupMathColor          : TColor;
    procedure   SetGroupMathColor          ( aValue: TColor);
    function    GetGroupLogicColor         : TColor;
    procedure   SetGroupLogicColor         ( aValue: TColor);
    function    GetGroupSeqColor           : TColor;
    procedure   SetGroupSeqColor           ( aValue: TColor);
    function    GetGroupGeneratorColor     : TColor;
    procedure   SetGroupGeneratorColor     ( aValue: TColor);
    function    GetGroupFXColor            : TColor;
    procedure   SetGroupFXColor            ( aValue: TColor);
    function    GetGroupDelayColor         : TColor;
    procedure   SetGroupDelayColor         ( aValue: TColor);
    function    GetGroupVoiceColor         : TColor;
    procedure   SetGroupVoiceColor         ( aValue: TColor);
    function    GetGroupUtilityColor       : TColor;
    procedure   SetGroupUtilityColor       ( aValue: TColor);
    function    GetAudioRateColor          : TColor;
    procedure   SetAudioRateColor          ( aValue: TColor);
    function    GetControlRateColor        : TColor;
    procedure   SetControlRateColor        ( aValue: TColor);
    function    GetControlRateLogicColor   : TColor;
    procedure   SetControlRateLogicColor   ( aValue: TColor);
    function    GetLogicColor              : TColor;
    procedure   SetLogicColor              ( aValue: TColor);
    function    GetUnconnectedWireColor    : TColor;
    procedure   SetUnconnectedWireColor    ( aValue: TColor);
    function    GetWireHighlightColor      : TColor;
    procedure   SetWireHighlightColor      ( aValue: TColor);
    function    GetEditorBackgroundColor   : TColor;
    procedure   SetEditorBackgroundColor   ( aValue: TColor);
    procedure   SetStandardColors          ( aValue: Boolean);
    procedure   SetUseConnectorBorders     ( aValue: Boolean);
    procedure   SetUseTypedConnectorBorders( aValue: Boolean);
    procedure   SetUseNoteNames            ( aValue: Boolean);
    function    Gettheme                   : string;
    procedure   SetTheme                   ( const aValue: string);
    function    GetModuleOpacity           : Byte;
    procedure   SetModuleOpacity           ( aValue: Byte);
    function    GetModuleFlatness          : Boolean;
    procedure   SetModuleFlatness          ( aValue: Boolean);
    function    GetModuleTexture           : Boolean;
    procedure   SetModuleTexture           ( aValue: Boolean);
    procedure   SetPrioLevel               ( aValue: Integer);
    function    GetWaveDebug               : Boolean;
    procedure   SetWaveDebug               ( aValue: Boolean);
    function    GetSampleRate              : Integer;
    procedure   SetSampleRate              ( aValue: Integer);
    function    GetControlDecimation       : Integer;
    procedure   SetControlDecimation       ( aValue: Integer);
    procedure   SetLightsActive            ( aValue: Boolean);
    procedure   SetAbsTimeStamps           ( aValue: Boolean);
    procedure   SetUseGraphs               ( aValue: Boolean);
    procedure   SetGraphStairs             ( aValue: Boolean);
    procedure   SetHistoryCount            ( aValue: Integer);
    function    GetSourceFileName          : string;
    procedure   SetSourceFileName          ( const aValue: string);
    function    GetPatchName               : string;
    procedure   SetPatchName               ( const aValue: string);
    procedure   SetReloadLastPatch         ( aValue: Boolean);
    procedure   SetAutoRun                 ( aValue: Boolean);
    procedure   SetClearVUOnStop           ( aValue: Boolean);
    procedure   SetClearVUOnRecompile      ( aValue: Boolean);
    procedure   SetRenderToFile            ( aValue: Boolean);
    procedure   SetPatchChanged            ( aValue: Boolean);
    procedure   SetWarnOnPatchChange       ( aValue: Boolean);
    procedure   SetWarnChangeOnLoad        ( aValue: Boolean);
    procedure   SetUndoAfterSave           ( aValue: Boolean);
    procedure   SetUndoAfterLoad           ( aValue: Boolean);
    procedure   SetUseWheelOnKnobs         ( aValue: Boolean);
    procedure   SetWheelSensitivity        ( aValue: Integer);
    procedure   SetUseUnFocus              ( aValue: Boolean);
    procedure   SetTuningChanged           ( aValue: Boolean);
    procedure   SetSearchPatch             ( aValue: Boolean);
    procedure   SetSearchSelector          ( aValue: Boolean);
    procedure   SetWarnOnStructMismatch    ( aValue: Boolean);
    procedure   SetDisableAutoDocs         ( aValue: Boolean);
    procedure   SetAllowAutoLoad           ( aValue: Boolean);
    procedure   SetNoLoadTuning            ( aValue: Boolean);
    procedure   SetNewPatchNameTemplate    ( const aValue: string);
    procedure   SetTextWriterPrefix        ( const aValue: string);
  private
    procedure   SetNetMidiServer           ( const aValue: string);
    procedure   SetNetMidiPort             ( const aValue: string);
    procedure   SetNetMidiAutoConnect      ( aValue: Boolean );
    procedure   SetNetMidiConnected        ( aValue: Boolean );
    procedure   SetNetMidiChanged          ( aValue: Boolean );
    procedure   SetLogMidi                 ( aValue: Boolean );
    procedure   SetLogMidiMsgs             ( aValue: Boolean );
    procedure   SetMidiChannel             ( aValue: Byte    );
    procedure   SetMidiRpnMode             ( aValue: TRpnMode);
  private
    procedure   SetOSCServer               ( const aValue: string);
    procedure   SetOSCPort                 ( const aValue: string);
    procedure   SetUseOSC                  ( aValue: Boolean);
    procedure   SetOSCChanged              ( aValue: Boolean);
    procedure   SetLogOSC                  ( aValue: Boolean);
    procedure   SetLogOSCMsgs              ( aValue: Boolean);
  private
    procedure   SetManualCompilation       ( aValue: Boolean);
    procedure   SetAutoCollectDenormals    ( aValue: Boolean);
    procedure   SetCompilerDebug           ( aValue: Boolean);
    procedure   PaDebugProc                ( const aMsg: string);
  private
    function    GetInVolume1               : Integer;
    procedure   SetInVolume1               ( aValue: Integer);
    function    GetOutVolume1              : Integer;
    procedure   SetOutVolume1              ( aValue: Integer);
    function    GetInVolume2               : Integer;
    procedure   SetInVolume2               ( aValue: Integer);
    function    GetOutVolume2              : Integer;
    procedure   SetOutVolume2              ( aValue: Integer);
    function    GetInVolume3               : Integer;
    procedure   SetInVolume3               ( aValue: Integer);
    function    GetOutVolume3              : Integer;
    procedure   SetOutVolume3              ( aValue: Integer);
    function    GetInVolume4               : Integer;
    procedure   SetInVolume4               ( aValue: Integer);
    function    GetOutVolume4              : Integer;
    procedure   SetOutVolume4              ( aValue: Integer);
    procedure   SetSounding                ( aValue: Boolean);
  private
    procedure   StartRendering;
    procedure   StopRendering;
    procedure   AddRenderData( const aLeft, aRight: TSignal);
  private
    procedure   OpenRecentFile( const anIndex: Integer);
    procedure   DorecentMenuItemClick( aSender: TObject);
    procedure   AddRecentMenuItem( anIndex: Integer; const aFileName: string);
    procedure   RemoveRecentMenuItems;
    procedure   SetRecentMenuItems;
    procedure   SetMostRecentFile( const aFileName: string);
    procedure   DoSelectorMenuItemClick( aSender: TObject);
    procedure   AddSelectorMenuItem( anIndex, aShortcut: Integer; const aName: string);
    procedure   RemoveSelectorMenuItems;
    procedure   DoAlternateModuleMenuItemClick( aSender: TObject);
    procedure   AddModuleAlternateMenuItem( anIndex: Integer; const aCurrent, aName: string; aModuleType: Integer);
    procedure   RemoveModuleAlternateMenuItems;
    procedure   ChangeModuleType( var aTarget: TKnobsCustomModule; aWantedType: TKnobsModuleType);
    procedure   AddModule( aModuleType: TKnobsModuleType);
    procedure   DoEditorMenuAddModule( aSender: TObject);
    function    HandleContextMenu( const aControl: TControl): Boolean;
    procedure   LoadIni( const aFileName: string; LooksOnly: Boolean);
    procedure   SaveIni( const aFileName: string; LooksOnly: Boolean);
    procedure   ShowHelp;
    function    FixHtmlTokens( const S: string): string;
    procedure   ShowModuleHelp( aModule: TKnobsCustomModule);
    function    MustMakeDocs: Boolean;
    procedure   MakeDocs( const aFolder : string);
    procedure   PopulateThemes;
    procedure   ShowAcknowledgements;
    procedure   CheckForUpdates;
  private
    function    LogTimeStamp: string;
    function    RtcTimeStamp: string;
    procedure   WriteFileLog( const aMsg: string);
    procedure   Log( aLogClass: TLogClass; const aMsg: string; TimeStamped: Boolean = True);                                 overload;
    procedure   Log( aLogClass: TLogClass; const aMsgs: TStrings; DoClear: Boolean);                                         overload;
    procedure   LogFmt( aLogClass: TLogClass; const aFmt: string; const anArgs: array of const);
    procedure   MidiLog( const aMsg: string);
    procedure   MidiLogFmt( const aFmt: string; const anArgs: array of const);
    procedure   MidiMsgLog( const aMsg: string);
    procedure   MidiMsgLogFmt( const aFmt: string; const anArgs: array of const);
    procedure   OSCLog( const aMsg: string);
    procedure   OSCLogFmt( const aFmt: string; const anArgs: array of const);
    procedure   OSCMsgLog( const aMsg: string);
    procedure   OSCMsgLogFmt( const aFmt: string; const anArgs: array of const);
    procedure   LogRandomizer( const aSender: TObject; const aMsg: string);
    procedure   LogVariations( const aSender: TObject; const aMsg: string);
    procedure   ViewEditor;
    procedure   ViewDebug;
    procedure   ViewSettings;
    procedure   ViewGraphs;
    procedure   ClearLog;
    procedure   ClearGraphs;
    procedure   BuildGraphs;
    procedure   DumpPatch;
    procedure   ProfilePatch;
    function    CreateSpeechVoiceNames: TStringList;
    function    CreateSpeechRateNames: TStringList;
    procedure   FixModuleStatics;
    procedure   FixDynamicConverter( const aName: string; const aValues: TStringList);
    function    FixTalkieStatics        ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixGranulatorStatics    ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixSeqRandomStatics     ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixScaleQuantizeStatics ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixProbSequencerStatics ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixFormant2Statics      ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixModal2Statics        ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixMazeTypeStatics      ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixSapiSpeechTypeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixSpeechRateTypeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixESpeakVoiceStatics   ( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    FixESpeakLanguageStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    function    ChangeSynthPatch( const aSynthPatch: TSynthPatch; ModulesChanged: Boolean): Boolean;
    procedure   ExecutePatch;
    procedure   ChartOutput( anIndex: Integer; aValue: TSignal);
    procedure   ChartOoutputs;
    procedure   DebugRunStop;
  private
    procedure   DeZipper;
    procedure   UpdateStats;
    procedure   UpdateLights;
    procedure   SetVuSampleCount( aCount: Integer);
    procedure   UpdateVUMeters;
    procedure   UpdateDbLabels;
    function    HandleAudioInOut           ( anInput, anOutput: Pointer; aFrameCount: culong; aTimeInfo: PPaStreamCallbackTimeInfo; aStatusFlags: TPaStreamCallbackFlags; UserData: Pointer): cint;
    procedure   HandleAudioOnStartPA       ( userdata: Pointer);
    procedure   HandleAudioOnStopPA        ( userdata: Pointer);
    procedure   WaveShowAsioPanel( aSender: TObject; aDevice: TPaDeviceIndex; aHandle: HWND);
    procedure   WaveRestartAudio( aSender: TObject; aDebug: Boolean);
    procedure   WaveLog( aSender: TObject; const aMsg: string);
    procedure   CreateDevices;
    procedure   FreeDevices;
    procedure   StopAudio;
    procedure   StartAudio;
    procedure   StartStopAudio;
    procedure   VerifyDevices;
    procedure   SelectDevices;
    procedure   ClearVolumeIndicators;
    procedure   ShowOverUnderFlows;
    procedure   ClearOverUnderFlows;
    procedure   ShowRunTime;
    procedure   ResetRuntime;
    function    GetDefaultModuleColor    ( const aSender: TObject; const aModuleType: TKnobsModuleType): TColor;
    procedure   ConnectorDelete          ( const aConnector    : TKnobsConnector    );
    procedure   ConnectorBreak           ( const aConnector    : TKnobsConnector    );
    procedure   ConnectorDisconnect      ( const aConnector    : TKnobsConnector    );
    procedure   SetWireColor             ( const aConnector    : TKnobsConnector; const aColor: TColor);
    procedure   SetWireColorDefault      ( const aConnector    : TKnobsConnector    );
    procedure   SetWireColorCustom       ( const aConnector    : TKnobsConnector    );
    procedure   ModuleCut                ( const aModule       : TKnobsModule       );
    procedure   ModuleCopy               ( const aModule       : TKnobsModule       );
    procedure   ModuleDelete             ( const aModule       : TKnobsModule       );
    procedure   ModulePasteParams        ( const aModule       : TKnobsModule; StrictCopy: Boolean);
    procedure   ChangeModuleColor        ( const aModule       : TKnobsModule       );
    procedure   ModuleColorDefault       ( const aModule       : TKnobsModule       );
    procedure   ModuleRandomize          ( const aModule       : TKnobsModule       );
    procedure   ModuleRandomizationToggle( const aModule       : TKnobsModule       );
    procedure   KnobSetDefaultValue      ( const aValuedControl: TKnobsValuedControl);
    procedure   KnobChangeLock           ( const aKnob         : TKnobsKnob         );
    procedure   KnobToggleRandomization  ( const aControl      : IKnobsVariation    );
    procedure   SetRandomKnobValue       ( const aControl      : IKnobsVariation    );
    procedure   AssignMidiCC             ( const aValuedControl: TKnobsValuedControl);
    procedure   AssignLastCCToKnob       ( const aValuedControl: TKnobsValuedControl);
    procedure   UnAssignMidiCC           ( const aValuedControl: TKnobsValuedControl);
    procedure   ViewMIDIAssignments;
    procedure   ViewHideRandomizer;
    procedure   LoadPatchPreset;
    procedure   SavePatchPreset;
    procedure   LoadPreset( aModule: TKnobsCustomModule);
    procedure   SavePreset( aModule: TKnobsCustomModule);
  private
    procedure   SetUseConfigHints       ( aValue: Boolean);
    procedure   SetUseModuleTitleHints  ( aValue: Boolean);
    procedure   SetWireThickness        ( aValue: Integer);
    procedure   SetCurvedLines          ( aValue: Boolean);
    procedure   SetControlMode          ( aValue: TDistanceMode);
    procedure   SetLightsRate           ( aValue: TSignal);
    procedure   SetReferenceA           ( aValue: TSignal);
    procedure   SetNotesPerOctave       ( aValue: TSignal);
    procedure   SetOctaveSpan           ( aValue: TSignal);
    procedure   SetMiddleNote           ( aValue: TSignal);
    procedure   SetResetOnRender        ( aValue: Boolean);
    function    GetTitleFont            : TFont;
    procedure   SetTitleFont            ( const aValue: TFont);
    function    GetModuleFont           : TFont;
    procedure   SetModuleFont           ( const aValue: TFont);
    procedure   SetShowTopPane          ( aValue: Boolean);
  private
    procedure   SetSynthNameInCaption   ( aValue: Boolean);
    procedure   SetPatchChangedInCaption( aValue: Boolean);
    procedure   SetProfiledInCaption    ( aValue: Boolean);
    procedure   SetAudioStatusInCaption ( aValue: Boolean);
    procedure   SetProgramNameInCaption ( aValue: Boolean);
    procedure   SetFileVersionInCaption ( aValue: Boolean);
    procedure   SetPatchNameInCaption   ( aValue: Boolean);
    procedure   SetSourceNameInCaption  ( aValue: Boolean);
    procedure   SetGuidInCaption        ( aValue: Boolean);
  private
    procedure   DoDesignerLog   ( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    procedure   DoWirePanelLog  ( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    procedure   DoHistoryChanged( const aSender: TObject; anUndoCount, aRedoCount, aSavedMarker: Integer);
    procedure   DoShowHint( var aHintStr: string; var CanShow: Boolean; var aHintInfo: Vcl.Controls.THintInfo);
    function    DoCreateModuleBitmap( const aModuleType: TKnobsModuleType; UseCache: Boolean): TBitmap;
    function    DoReadModuleComment ( const aModuleType: TKnobsModuleType): string;
    procedure   DoPopupEditorShow( const aSender: TObject);
    procedure   DoPopupEditorHide( const aSender: TObject);
    procedure   DoValueChanged( const aSender: TObject; const aPath, aControlType: string; aValue: TSignal; IsFinal, IsAutomation: Boolean);
    procedure   DoTextChanged ( const aSender: TObject; const aPath, aValue: string);
  private
    function    SplitValueInfo      ( const aPath: string; var aModule: TKnobsCustomModule; var aModuleType, aSignalName: string): Boolean;
    procedure   HandleSpecialValues ( const aPath, aControlType: string; aValue: TSignal; const anOrigin: TKnobsValuedControl);
    procedure   ChangeRangeFor      ( const aModule: TKnobsCustomModule; const aModuleType, aRangeType: string; aValue: TSignal; const anOrigin: TKnobsValuedControl);
    procedure   ChangeModeFor       ( const aModule: TKnobsCustomModule; const aModuleType, aModeType : string; aValue: TSignal);
    procedure   ChangeControlTypeTo ( const aControl: TKnobsValuedControl; const aValue: string );
    procedure   ChangeKnobPositionTo( const aControl: TKnobsValuedControl; const aValue: Integer);
    procedure   ChangeStepCountTo   ( const aControl: TKnobsValuedControl; const aValue: Integer);
    procedure   ChangePairingModeTo ( const aKnob   : TKnobsKnob; aValue: TKnobsPairingMode);
  private
    procedure   SetFileText             ( const aFileName, aLine: string);
    procedure   DoSignals               ( const aSender: TMod; const anInfo: TLightsInfo);
    procedure   DoLights                ( const aSender: TMod; const anInfo: TLightsInfo);
    procedure   DoData                  ( const aSender: TMod; const anInfo: TDataInfo  );
    procedure   DoXYData                ( const aSender: TMod; const anInfo: TXYDataInfo);
    procedure   DoStringData            ( const aSender: TMod; const anInfo: TStringInfo);
    procedure   DoCursorData            ( const aSender: TMod; const anInfo: TCursorInfo);
    procedure   DoRecompile             ( const aSender: TKnobsWirePanel; ModulesChanged: Boolean);
    procedure   DoHistoryItemClicked    ( aSender: TObject);
    procedure   DoShowPopupMenu         ( const aSender: TKnobsWirePanel; const aControl: TControl);
    procedure   DoUnFocus               ( const aSender: TObject);
    function    DoLoadDataGraph         ( const aSender: TObject): string;
    procedure   DoSaveDataGraph         ( const aSender: TObject; const aValue: string);
    function    DoLoadGridControl       ( const aSender: TObject): string;
    procedure   DoSaveGridControl       ( const aSender: TObject; const aValue: string);
    procedure   DoActiveVariationChanged( const aSender: TObject; aVariation: Integer);
    procedure   DoLoadCaptions          ( const aSender: TObject; const aModule: TKnobsCustomModule; const aControl: TKnobsSelector; const aDependency: TKnobsValuedControl);
    procedure   DoEditHistoryChanged    ( aSender: TObject);
    procedure   DoModulesRenamed        ( const aSender: TObject; const anOldNames, aNewNames: TStringArray);
    procedure   DoModulesRenamedFriendly( const aSender: TObject; const anOldNames, aNewNames: TStringArray);
    function    Template1Name  : string;
    function    Template2Name  : string;
    function    TemplateNewName: string;
    function    CheckDiscardPatchChanges( const aReason: string; MustAsk: Boolean): Boolean;
    function    LastPatchName: string;
    procedure   SaveLastPatch;
    procedure   LoadLastPatch;
    function    SavePatchNamed( const aFileName: string; WriteAlways: Boolean)  : Boolean;
    function    SavePatch  : Boolean;
    function    SavePatchAs: Boolean;
    function    SaveAsTemplate( const aFileName: string): Boolean;
    function    SaveAsTemplate1  : Boolean;
    function    SaveAsTemplate2  : Boolean;
    function    SaveAsTemplateNew: Boolean;
    procedure   ExportModules;
    procedure   DoLoadPatch( const aFileName: string; ChangePatchName: Boolean);
    procedure   DoImportPatch( const aFileName: string);
    procedure   LoadPatch;
    procedure   ImportPatch;
    procedure   NewPatch;
    procedure   DoOnValuedControlRemoved( const aSender: TKnobsValuedControl);
    procedure   DeleteModules;
    procedure   CutModules;
    procedure   CopyModules;
    procedure   PasteModules;
    procedure   PasteParameters( StrictCopy: Boolean);
    procedure   SelectAll;
    procedure   SelectNone;
    procedure   InvertSelection;
    procedure   WiggleWires;
    procedure   ToggleWires;
    function    WiresOff: Boolean;
    procedure   WiresOn( TurnOn: Boolean);
    procedure   ToggleSound;
    procedure   SearchInPatch   ( const aValue: string);
    procedure   SearchInSelector( const aValue: string);
    procedure   FindUnconnectedModules;
    procedure   CollectDenormals( AutoCollected: Boolean);
    procedure   Panic;
    procedure   UpdateLiveMorphVisuals;
    procedure   FillDataMaker( const aDataMaker: TKnobsDataMaker; aShape: TKnobsDMShape);
    procedure   PatchLiveMorph( UpdateVisuals: Boolean);
    procedure   SetRandomValue;
    procedure   PatchRandomize;
    procedure   PatchMutate;
    procedure   PatchMate;
    procedure   PatchMorph;
    procedure   WormSelected( const aWorm: TKnobsWorm);
    procedure   WormDropped ( const aWorm: TKnobsWorm);
    procedure   SetAllowRandomization( aValue: Boolean);
    procedure   ToggleExcludedModules;
    procedure   RangeChanged( aNewRange: Integer);
    procedure   RangeValueChanged( aValue: TSignal);
  private
    function    FunctionalPinName( const aName: string): string;
    function    SplitConnectorName( const aName: string; var aMod, aPin: string): Boolean;
    function    ModuleTypeToModule( aType: Integer; const aParent: TSynthPatch; const aName: string): TMod;
    procedure   CompilePatch( ModulesChanged, AutomaticCompile: Boolean);
    procedure   RegisterMidiControls;
    procedure   RegisterRandomParams;
    procedure   RegisterRandomParamsAll;
  private
    procedure   FixTuningAndSampleRate( const aMsg: string);
    function    GetSignalValue( const anEditor: TEdit; var aValue: TSignal; aLow, aHigh: TSignal; UseClipping: Boolean): Boolean;
    procedure   SignalTuningError( const aName: string; const anEditor: TEdit; aLow, aHigh: TSignal);
    procedure   ApplyTuning;
    procedure   CancelTuning;
  private
    procedure   InitializeCPUCounter;
    procedure   FinalizeCPUCounter;
    procedure   TickCPUCounter;
  private
    procedure   StartNetMidiConnectTimer;
    procedure   StopNetMidiConnectTimer;
    procedure   NetMidiConnectTimerFired;
    procedure   NetMidiConnect;
    procedure   NetMidiDisconnect;
    procedure   NetMidiApply;
    procedure   NetMidiCancel;
    procedure   ReceiveNetMidi;
    procedure   SendMidiBytes( const aMsg: TBytes);
    procedure   QueueMidiBytes( const aMsg: TBytes);
    procedure   DoSendMidiBytes( const aSender: TObject; const aMsg: TBytes);
    procedure   SendShortNetMidi( const aData: TShortMidiMessage);
  private
    procedure   DoMidiRxMessage     ( const aSender: TObject; const aMsg: TMidiMessage);
    procedure   DoRxRpnMessage      ( const aSender: TObject; aCh, aController, aValue: Integer );
    procedure   DoRxNrpnMessage     ( const aSender: TObject; aCh, aController, aValue: Integer );
    procedure   DoSendMidiByte      ( const aSender: TObject; aByte: Byte);
    procedure   DoMidiTxShortMessage( const aSender: TObject; const aMsg: TShortMidiMessage);
  private
    procedure   ResetInPeaks;
    procedure   ResetOutPeaks;
    procedure   ResetPeaks;
    procedure   ClearVUMeters;
    procedure   MemoDebugWindowProc( var aMsg: TMessage);
  private
    procedure   UMMIDILog   ( var aMsg: TMsgMIDILog);                                             message UM_MIDI_LOG;
    procedure   UMMidiData  ( var aMsg: TMsgMidiData);                                            message UM_MIDIDATA;
    procedure   UMOSCString ( var aMsg: TMsgOSCData);                                             message UM_OSCDATA;
    procedure   UMLiveMorph ( var aMsg: TMsg);                                                    message UM_LIVE_MORPH;
  private
    procedure   SendOSCBytes( const aMsg: TBytes);
    procedure   QueueOSCBytes( const aMsg: TBytes);
    procedure   DoSendOSCBytes( const aSender: TObject; const aMsg: TBytes);
    procedure   SendOSCTestMessage;
 // procedure   SendOScMidi( const anAddress: string; aPort, aChannel, aMessage: Byte; aParam1: Byte = $ff; aParam2: Byte = $ff);
    procedure   HandleLocalOSCPacket( anOSCPacket: TOSCPacket);
    function    OscHandler( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    procedure   AcceptOSCBytes( const aMsg: TBytes);
    procedure   LogOSCMessage( const aMsg: TBytes; const aLabel: string);
    procedure   HandleOSCReception;
    procedure   OSCCancel;
    procedure   OSCApply;
    procedure   OSCEnable;
    procedure   OSCDisable;
    procedure   StartOSCGuard;
    procedure   StopOSCGuard;
    procedure   OSCGuardFired;
  public
    // IsShortCut needs be public or otherwise 'less visible than in base class' compiler naggings.
    function    IsShortCut( var aMessage: TWMKey): Boolean; override;
  private
    procedure   FormantLogger( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
  private
    procedure   AcceptCommandLine( aCommandLine: Atom);
  private
    function    GetActiveVariation: Integer;
    procedure   SetActiveVariation( aValue: Integer);
    procedure   DoRandomizerLiveMorphChanged( const aSender: TObject; aValue: TSignal);
    procedure   DoRandomizerSendToEditor    ( const aSender: TKnobsWormPanel; const aSelection: TWormSelection);
    procedure   DoRandomizerLoadFromEditor  ( const aSender: TKnobsWormPanel; const aSelection: TWormSelection);
    procedure   DoPatchRandomize            ( const aSender: TObject);
    procedure   DoPatchMutate               ( const aSender: TObject);
    procedure   DoPatchMate                 ( const aSender: TObject);
    procedure   DoPatchMorph                ( const aSender: TObject);
    procedure   DoWormSelected              ( const aSender: TObject; const aWorm: TKnobsWorm);
    procedure   DoWormDropped               ( const aSender: TObject; const aWorm: TKnobsWorm);
    procedure   SetLiveMorph( aValue: TSignal);
    procedure   SetAllowLiveMorphMod( aValue: Boolean);
    procedure   SetAllowMorphMod    ( aValue: Boolean);
    function    GetMorph( anIndex: Integer): TSignal;
    procedure   SetMorph( anIndex: Integer; aValue : TSignal);
    procedure   HandleMorphing;
  private
    property    SynthName                : string        read FSynthName                 write SetSynthName;
    property    CanLog                   : Boolean       read FCanLog                    write SetCanLog;
    property    LogToFile                : Boolean       read FLogToFile                 write SetLogToFile;
    property    OffsetLeft               : Integer       read GetOffsetLeft              write SetOffsetLeft;
    property    OffsetTop                : Integer       read GetOffsetTop               write SetOffsetTop;
    property    ModuleColor              : TColor        read GetModuleColor             write SetModuleColor;
    property    ConnectorBorderColor     : TColor        read GetConnectorBorderColor    write SetConnectorBorderColor;
    property    SelectorColor            : TColor        read GetSelectorColor           write SetSelectorColor;
    property    SelectorBorderColor      : TColor        read GetSelectorBorderColor     write SetSelectorBorderColor;
    property    SelectorBorderColorS     : TColor        read GetSelectorBorderColorS    write SetSelectorBorderColorS;
    property    DisplayColor             : TColor        read GetDisplayColor            write SetDisplayColor;
    property    DisplayBorderColor       : TColor        read GetDisplayBorderColor      write SetDisplayBorderColor;
    property    KnobMIDIColor            : TColor        read GetKnobMIDIColor           write SetKnobMIDIColor;
    property    KnobFocusColor           : TColor        read GetKnobFocusColor          write SetKnobFocusColor;
    property    KnobMIDIFocusColor       : TColor        read GetKnobMIDIFocusColor      write SetKnobMIDIFocusColor;
    property    ViewerColor              : TColor        read GetViewerColor             write SetViewerColor;
    property    ViewerBorderColor        : TColor        read GetViewerBorderColor       write SetViewerBorderColor;
    property    ViewerLineColor          : TColor        read GetViewerLineColor         write SetViewerLineColor;
    property    ViewerFillColor          : TColor        read GetViewerFillColor         write SetViewerFillColor;
    property    IndBarPeakColor          : TColor        read GetIndBarPeakColor         write SetIndBarPeakColor;
    property    IndBarValeyColor         : TColor        read GetIndBarValeyColor        write SetIndBarValeyColor;
    property    GroupIOColor             : TColor        read GetGroupIOColor            write SetGroupIOColor;
    property    GroupOSCColor            : TColor        read GetGroupOSCColor           write SetGroupOSCColor;
    property    GroupLFOColor            : TColor        read GetGroupLFOColor           write SetGroupLFOColor;
    property    GroupEnvColor            : TColor        read GetGroupEnvColor           write SetGroupEnvColor;
    property    GroupFilterColor         : TColor        read GetGroupFilterColor        write SetGroupFilterColor;
    property    GroupSwitchColor         : TColor        read GetGroupSwitchColor        write SetGroupSwitchColor;
    property    GroupMixColor            : TColor        read GetGroupMixColor           write SetGroupMixColor;
    property    GroupControlColor        : TColor        read GetGroupControlColor       write SetGroupControlColor;
    property    GroupNoteColor           : TColor        read GetGroupNoteColor          write SetGroupNoteColor;
    property    GroupMathColor           : TColor        read GetGroupMathColor          write SetGroupMathColor;
    property    GroupLogicColor          : TColor        read GetGroupLogicColor         write SetGroupLogicColor;
    property    GroupSeqColor            : TColor        read GetGroupSeqColor           write SetGroupSeqColor;
    property    GroupGeneratorColor      : TColor        read GetGroupGeneratorColor     write SetGroupGeneratorColor;
    property    GroupFXColor             : TColor        read GetGroupFXColor            write SetGroupFXColor;
    property    GroupDelayColor          : TColor        read GetGroupDelayColor         write SetGroupDelayColor;
    property    GroupVoiceColor          : TColor        read GetGroupVoiceColor         write SetGroupVoiceColor;
    property    GroupUtilityColor        : TColor        read GetGroupUtilityColor       write SetGroupUtilityColor;
    property    AudioRateColor           : TColor        read GetAudioRateColor          write SetAudioRateColor;
    property    ControlRateColor         : TColor        read GetControlRateColor        write SetControlRateColor;
    property    ControlRateLogicColor    : TColor        read GetControlRateLogicColor   write SetControlRateLogicColor;
    property    LogicColor               : TColor        read GetLogicColor              write SetLogicColor;
    property    UnconnectedWireColor     : TColor        read GetUnconnectedWireColor    write SetUnconnectedWireColor;
    property    WireHighlightColor       : TColor        read GetWireHighlightColor      write SetWireHighlightColor;
    property    EditorBackgroundColor    : TColor        read FEditorBackgroundColor     write SetEditorBackgroundColor;
    property    StandardColors           : Boolean       read FStandardColors            write SetStandardColors;
    property    UseConnectorBorders      : Boolean       read FUseConnectorBorders       write SetUseConnectorBorders;
    property    UseTypedConnectorBorders : Boolean       read FUseTypedConnectorBorders  write SetUseTypedConnectorBorders;
    property    UseNoteNames             : Boolean       read FUseNoteNames              write SetUseNoteNames;
    property    ModuleOpacity            : Byte          read GetModuleOpacity           write SetModuleOpacity;
    property    ModuleFlatness           : Boolean       read GetModuleFlatness          write SetModuleFlatness;
    property    ModuleTexture            : Boolean       read GetModuleTexture           write SetModuleTexture;
    property    Theme                    : string        read GetTheme                   write SetTheme;
    property    PrioLevel                : Integer       read FPrioLevel                 write SetPrioLevel;
    property    WaveDebug                : Boolean       read GetWaveDebug               write SetWaveDebug;
    property    BufferSize               : Integer       read FBufferSize                write FBufferSize;
    property    Samplerate               : Integer       read GetSampleRate              write SetSampleRate;
    property    ControlDecimation        : Integer       read GetControlDecimation       write SetControlDecimation;
    property    LightsActive             : Boolean       read FLightsActive              write SetLightsActive;
    property    AbsTimeStamps            : Boolean       read FAbsTimeStamps             write SetAbsTimeStamps;
    property    UseGraphs                : Boolean       read FUseGraphs                 write SetUseGraphs;
    property    GraphStairs              : Boolean       read FGraphStairs               write SetGraphStairs;
    property    HistoryCount             : Integer       read FHistoryCount              write SetHistoryCount;
    property    SourceFileName           : string        read GetSourceFileName          write SetSourceFileName;
    property    PatchName                : string        read GetPatchName               write SetPatchName;
    property    ReloadLastPatch          : Boolean       read FReloadLastPatch           write SetReloadLastPatch;
    property    AutoRun                  : Boolean       read FAutoRun                   write SetAutoRun;
    property    ClearVUOnStop            : Boolean       read FClearVUOnStop             write SetClearVUOnStop;
    property    ClearVUOnRecompile       : Boolean       read FClearVUOnRecompile        write SetClearVUOnRecompile;
    property    RenderToFile             : Boolean       read FRenderToFile              write SetRenderToFile;
    property    PatchChanged             : Boolean       read FPatchChanged              write SetPatchChanged;
    property    WarnOnPatchChange        : Boolean       read FWarnOnPatchChange         write SetWarnOnPatchChange;
    property    WarnChangeOnLoad         : Boolean       read FWarnChangeOnLoad          write SetWarnChangeOnLoad;
    property    UndoAfterSave            : Boolean       read FUndoAfterSave             write SetUndoAfterSave;
    property    UndoAfterLoad            : Boolean       read FUndoAfterLoad             write SetUndoAfterLoad;
    property    UseWheelOnKnobs          : Boolean       read FUseWheelOnKnobs           write SetUseWheelOnKnobs;
    property    WheelSensitivity         : Integer       read FWheelSensitivity          write SetWheelSensitivity;
    property    UseUnFocus               : Boolean       read FUseUnfocus                write SetUseUnFocus;
    property    TuningChanged            : Boolean       read FTuningChanged             write SetTuningChanged;
    property    SearchPatch              : Boolean       read FSearchPatch               write SetSearchPatch;
    property    SearchSelector           : Boolean       read FSearchSelector            write SetSearchSelector;
    property    WarnOnStructMismatch     : Boolean       read FWarnOnStructMismatch      write SetWarnOnStructMismatch;
    property    DisableAutoDocs          : Boolean       read FDisableAutoDocs           write SetDisableAutoDocs;
    property    AllowAutoLoad            : Boolean       read FAllowAutoLoad             write SetAllowAutoLoad;
    property    NoLoadTuning             : Boolean       read FNoLoadTuning              write SetNoLoadTuning;
    property    NewPatchNameTemplate     : string        read FNewPatchNameTemplate      write SetNewPatchNameTemplate;
    property    TextWriterPrefix         : string        read FTextWriterPrefix          write SetTextWriterPrefix;
  private
    property    NetMidiServer            : string        read FNetMidiServer             write SetNetMidiServer;
    property    NetMidiPort              : string        read FNetMidiPort               write SetNetMidiPort;
    property    NetMidiAutoConnect       : Boolean       read FNetMidiAutoConnect        write SetNetMidiAutoConnect;
    property    NetMidiConnected         : Boolean       read FNetMidiConnected          write SetNetMidiConnected;
    property    NetMidiChanged           : Boolean       read FNetMidiChanged            write SetNetMidiChanged;
    property    LogMidi                  : Boolean       read FLogMidi                   write SetLogMidi;
    property    LogMidiMsgs              : Boolean       read FLogMidiMsgs               write SetLogMidiMsgs;
    property    MidiChannel              : Byte          read FMidiChannel               write SetMidiChannel;
    property    MidiRpnMode              : TRpnMode      read FMidiRpnMode               write SetMidiRpnMode;
  private
    property    OSCServer                : string        read FOSCServer                 write SetOSCServer;
    property    OSCPort                  : string        read FOSCPort                   write SetOSCPort;
    property    UseOSC                   : Boolean       read FUSeOSC                    write SetUseOSC;
    property    OSCChanged               : Boolean       read FOSCChanged                write SetOSCChanged;
    property    LogOSC                   : Boolean       read FLogOSC                    write SetLogOSC;
    property    LogOSCMsgs               : Boolean       read FLogOSCMsgs                write SetLogOSCMsgs;
  private
    property    ManualCompilation        : Boolean       read FManualCompilation         write SetManualCompilation;
    property    AutoCollectDenormals     : Boolean       read FAutoCollectDenormals      write SetAutoCollectDenormals;
    property    CompilerDebug            : Boolean       read FCompilerDebug             write SetCompilerDebug;
  private
    property    InVolume1                : Integer       read GetInVolume1               write SetInVolume1;
    property    OutVolume1               : Integer       read GetOutVolume1              write SetOutVolume1;
    property    InVolume2                : Integer       read GetInVolume2               write SetInVolume2;
    property    OutVolume2               : Integer       read GetOutVolume2              write SetOutVolume2;
    property    InVolume3                : Integer       read GetInVolume3               write SetInVolume3;
    property    OutVolume3               : Integer       read GetOutVolume3              write SetOutVolume3;
    property    InVolume4                : Integer       read GetInVolume4               write SetInVolume4;
    property    OutVolume4               : Integer       read GetOutVolume4              write SetOutVolume4;
    property    Sounding                 : Boolean       read FSounding                  write SetSounding;
  private
    property    UseConfigHints           : Boolean       read FUseConfigHints            write SetUseConfigHints;
    property    UseModuleTitleHints      : Boolean       read FUseModuleTitleHints       write SetUseModuleTitleHints;
    property    WireThickness            : Integer       read FWireThickness             write SetWireThickness;
    property    CurvedLines              : Boolean       read FCurvedLines               write SetCurvedLines;
    property    ControlMode              : TDistanceMode read FControlMode               write SetControlMode;
    property    LightsRate               : TSignal       read FLightsRate                write SetLightsRate;
    property    ReferenceA               : TSignal       read FReferenceA                write SetReferenceA;
    property    NotesPerOctave           : TSignal       read FNotesPerOctave            write SetNotesPerOctave;
    property    MiddleNote               : TSignal       read FMiddleNote                write SetMiddleNote;
    property    OctaveSpan               : TSignal       read FOctaveSpan                write SetOctaveSpan;
    property    ResetOnRender            : Boolean       read FResetOnRender             write SetResetOnRender;
    property    TitleFont                : TFont         read GetTitleFont               write SetTitleFont;
    property    ModuleFont               : TFont         read GetModuleFont              write SetModuleFont;
    property    ShowTopPane              : Boolean       read FShowTopPane               write SetShowTopPane;
  private
    property    SynthNameInCaption       : Boolean       read FSynthNameInCaption        write SetSynthNameInCaption   ;
    property    PatchChangedInCaption    : Boolean       read FPatchChangedInCaption     write SetPatchChangedInCaption;
    property    ProfiledInCaption        : Boolean       read FProfiledInCaption         write SetProfiledInCaption    ;
    property    AudioStatusInCaption     : Boolean       read FAudioStatusInCaption      write SetAudioStatusInCaption ;
    property    ProgramNameInCaption     : Boolean       read FProgramNameInCaption      write SetProgramNameInCaption ;
    property    FileVersionInCaption     : Boolean       read FFileVersionInCaption      write SetFileVersionInCaption ;
    property    PatchNameInCaption       : Boolean       read FPatchNameInCaption        write SetPatchNameInCaption   ;
    property    SourceNameInCaption      : Boolean       read FSourceNameInCaption       write SetSourceNameInCaption  ;
    property    GuidInCaption            : Boolean       read FGuidInCaption             write SetGuidInCaption        ;
  private
    property    PatchFolder              : string        read FPatchFolder               write FPatchFolder;
    property    TemplateFolder           : string        read FTemplateFolder            write FTemplateFolder;
    property    ImportFolder             : string        read FImportFolder              write FImportFolder;
    property    GraphsFolder             : string        read FGraphsFolder              write FGraphsFolder;
    property    GridControlFolder        : string        read FGridControlFolder         write FGridControlFolder;
    property    ColorMapLength           : Integer       read GetColorMapLength          write SetColorMapLength;
    property    CurrentColor             : TColorId      read FCurrentColor              write SetCurrentColor;
  private
    property    ActiveVariation          : Integer       read GetActiveVariation         write SetActiveVariation;
    property    LiveMorph                : TSignal       read FLiveMorph                 write SetLiveMorph;
    property    Morph[ anIndex: Integer] : TSignal       read GetMorph                   write SetMorph;
    property    AllowLiveMorphMod        : Boolean       read FallowLiveMorphMod         write SetAllowLiveMorphMod;
    property    AllowMorphMod            : Boolean       read FallowMorphMod             write SetAllowMorphMod;
  end;

var

  FormWren: TFormWren;



implementation



type

  TSample    = SmallInt;                 // External value type for OS samples
  TSamples   = packed array[ 0 .. MaxInt div SizeOf( TSample) - 1] of TSample;
  PSamples   = ^TSamples;

const

  SAMP_MAX         =   High( TSample);   // Maximum value for a sample
  SAMP_MIN         = - High( TSample);   // Minimum value for a sample
  SAMP_MAX_REC     = 1.0 / SAMP_MAX;
  MIN_DB           = -100.0;             // Minimum dB value to be shown on Main VU meters
  MAX_DB           =   20.0;             // Maximum dB value to be shown on Main VU meters
  DB_DECAY_RATE    =    1.0;             // Decay rate for peak indicators on VU meters (seconds)
  TEST_PACKET_NAME = '/*/testmessage';   // Pattern for the OSC test message

  sdfs             = 'settings';         // General setting section in ini file


var

  GOldWindowProc : Pointer;               // Variable to hold the original WindowProc function


{$R *.dfm}

// User area

    function NewWindowProc(
      aWindowHandle: hWnd;
      aMessage     : Cardinal;
      aParamW      : LongInt;
      aParamL      : LongInt
    ): LongInt stdCall;
    begin
      if   aMessage = WrenMessage
      then begin
        SendMessage( Application.Handle, WM_SYSCOMMAND, SC_RESTORE, 0);
        SetForeGroundWindow( Application.Handle);
        FormWren.AcceptCommandLine( Atom( aParamW));
        Result := 0;
        Exit;
      end;

      Result := CallWindowProc( GOldWindowProc, aWindowHandle, aMessage, aParamW, aParamL);
    end;


    function  SocketStateToStr( aValue: TSocketState): string;
    begin
      Result := GetEnumName( TypeInfo( TSocketState), Integer( aValue));
    end;


    function IndexToMenuShortCut( aShortcutIndex: Integer): string;
    const
      ShortcutSeparator : string = '   ';
    begin
      if   aShortCutIndex >= 0
      then begin
        if   aShortcutIndex <= 9
        then Result := '&' + Char( aShortcutIndex + Ord( '0')) + ShortcutSeparator
        else if aShortcutIndex <= 35
        then Result := '&' + Char( aShortcutIndex + Ord( 'A') - 10) + ShortcutSeparator
        else Result := '  ' + ShortcutSeparator;
      end
      else Result := '';
    end;


    // PortAudio callbacks

    function    GHandleAudioOnBufferFilledPA( anInput, anOutput: Pointer; aFrameCount: culong; aTimeInfo: PPaStreamCallbackTimeInfo; aStatusFlags: TPaStreamCallbackFlags; UserData: Pointer): cint; cdecl;
    begin
      if   Assigned( FormWren)
      then Result := FormWren.HandleAudioInOut( anInput, anOutput, aFrameCount, aTimeInfo, aStatusFlags, UserData)
      else Result := paAbort;
    end;


    procedure   GHandleAudioOnStopPA( userdata: Pointer); cdecl;
    begin
      if   Assigned( FormWren)
      then FormWren.HandleAudioOnStopPA( userdata);
    end;


    procedure   GPaDebugProc( const aMsg: PAnsiChar); cdecl;
    begin
      if   Assigned( FormWren)
      then FormWren.PaDebugProc( string( aMsg));
    end;


    function    MakeMidiCCName( const aValuedControl: TKnobsValuedControl): string;
    var
      aParts : TStringList;
    begin
      if   Assigned( aValuedControl)
      then begin
        Result := aValuedControl.Name;
        aParts := Explode( Result, '_');

        try
          if   ( aParts.Count = 2)
          then begin
            if   Assigned( aValuedControl.Parent)
            and  ( aValuedControl.Parent is TKnobsModule)
            then Result := TKnobsModule( aValuedControl.Parent).Name + '_' + aParts[ 1]
            else Result := 'global_' + aParts[ 1];
          end
        finally
          aParts.DisposeOf;
        end;
      end;
    end;


{ ========
  TPageControl = class( Vcl.ComCtrls.TPageControl)
  // Some stuff to fix the border width for TPageControls
  private
}

    procedure   TPageControl.TCMAdjustRect( var Msg: TMessage); // message TCM_ADJUSTRECT;
    begin
      inherited;
      if   Msg.WParam = 0
      then InflateRect( PRect( Msg.LParam)^,  4,  4)
      else InflateRect( PRect( Msg.LParam)^, -4, -4);
    end;


{ ========
  TEdit = class( Vcl.StdCtrls.TEdit)
  // Fix VK_DELETE issues for TEdits
  private
}

    procedure    TEdit.CNKeyDown( var aMessage: TWMKeyDown); // message CN_KEYDOWN;
    // Copied from TWinControl.CNKeyDown - but left out the check for IsShortcut
    // as that one was 'stealing away' the menu shortcut keys resulting in the DEL
    // key (VK_DELETE) not working for editing the editor's text. Now this control
    // behaves like there are no menu shortcuts at all, and that is what is wanted
    // here. Then added some checks to make it apply only to certain controls
    // under certain conditions .. oddly enough VK_DELETE works fine on tabs being
    // not the main tab ... so apparently it is the PopupMenuEditor causing the
    // issue with the delete key (and not the MainMenu, but both have DEL as a
    // shortcut key). Anyways .. this solves the issues .. clumsy though.
    var
      Mask        : Integer;
      aShiftState : TShiftState;
      aCharCode   : Word;
    begin
      aShiftState := KeyDataToShiftState( aMessage.KeyData);
      aCharCode   := aMessage.CharCode;

      if   Assigned( FormWren)
      and  ( aShiftState = [])
      and  ( aCharCode   = VK_DELETE)
      and
      (
           FormWren.EditSearch        .Focused
        or FormWren.EditReferenceA    .Focused
        or FormWren.EditNotesPerOctave.Focused
        or FormWren.EditOctaveSpan    .Focused
        or FormWren.EditMiddleNote    .Focused
      )
      then begin
        with aMessage
        do begin
          Result := 1;
          UpdateUIState( aMessage.CharCode);

          if Perform( CM_CHILDKEY, CharCode, Winapi.Windows.LPARAM( Self)) <> 0
          then Exit;

          Mask := 0;

          case CharCode of
            VK_TAB:                                      Mask := DLGC_WANTTAB;
            VK_LEFT, VK_RIGHT, VK_UP, VK_DOWN:           Mask := DLGC_WANTARROWS;
            VK_RETURN, VK_EXECUTE, VK_ESCAPE, VK_CANCEL: Mask := DLGC_WANTALLKEYS;
          end;

          if   ( Mask <> 0)
          and  ( Perform( CM_WANTSPECIALKEY, CharCode, 0) = 0)
          and  ( Perform( WM_GETDLGCODE, 0, 0) and Mask = 0)
          and  ( GetParentForm( Self).Perform( CM_DIALOGKEY, CharCode, KeyData) <> 0)
          then Exit;

          Result := 0;
        end;
      end
      else inherited;
    end;


{ ========
  TFormModules = class( TForm)
  private
}

    procedure   TFormWren.UpdateCaptions;

      procedure Addpart( const aParts: TStringList; const aPart: string);
      begin
        if   aPart <> ''
        then aParts.Add( aPart);
      end;

      function GetGuid: string;
      begin
        if   Assigned( PatchEditor)
        then Result := PatchEditor.Guid
        else Result := '<no-guid>';
      end;

    const
    {$ifdef DEBUG}
      Changed   : array[ Boolean] of string = ( 'DEBUG'  , '*** DEBUG'                                               );
    {$else}
      Changed   : array[ Boolean] of string = ( ''       , '***'                                                     );
    {$endif}
      Runs      : array[ Boolean] of string = ( 'STOPPED', ''                                                        );
      Caps      : array[ Boolean] of string = ( 'run'    , 'stop'                                                    );
      Pleases1  : array[ Boolean] of string = ( ''       , 'Please stop audio processing before making changes here,');
      Pleases2  : array[ Boolean] of string = ( ''       , 'and stop and restart the program after making changes.'  );

    {$IFDEF PATCH_PROFILER}
      Profiled = 'PROFILED';
    {$ELSE}
      Profiled = '';
    {$ENDIF}

    var
      aParts : TStringList;
    begin
      aparts := TStringList.Create;

      try
    {$ifdef DEBUG}
        if SynthNameInCaption    then Addpart( aParts, SynthName);
        if PatchChangedInCaption then Addpart( aParts, Changed[ PatchChanged]);
    {$else}
        if PatchChangedInCaption then Addpart( aParts, Changed[ PatchChanged]);
        if SynthNameInCaption    then Addpart( aParts, SynthName);
    {$endif}
        if ProfiledInCaption     then AddPart( aParts, Profiled);
        if AudioStatusInCaption  then Addpart( aParts, Runs[ FAudioRunning]);
        if ProgramNameInCaption  then AddPart( aParts, FOrigCaption);
        if FileVersionInCaption  then AddPart( aParts, GetFileVersion);
        if PatchNameInCaption    then AddPart( aParts, PatchName);
        if SourceNameInCaption   then Addpart( aparts, ExtractFileName( SourceFileName));
        if GuidInCaption         then Addpart( aparts, GetGuid);

        Caption := Implode( aParts, '  ::  ');
        KnobsSelectorAudioRunning.KnobPosition := Ord( FAudioRunning);
        MenuActionRunStop        .Checked      :=      FAudioRunning;
      finally
        aParts.DisposeOf;
      end;
    end;


    procedure   TFormWren.FixControlFoldButton;
    const
      Captions : array[ Boolean] of string = ( '', '');
    begin
      SpeedButtonChangeControlPanel.Caption := Captions[ PanelControl.Width <> 0];
    end;


    procedure   TFormWren.FixSelectorFoldButton;
    const
      Captions : array[ Boolean] of string = (  '', '');
    begin
      SpeedButtonChangeModuleSelector.Caption := Captions[ ModuleSelector.Width > 30];
    end;


    procedure   TFormWren.FixSearchVisuals;
    const
      Captions: array[ 0 .. 3] of string = (
        'find disabled'   ,
        'find in patch'   ,
        'find in selector',
        'find in patch + selector'
      );
      Colors: array[ 0 .. 3] of TColor = (
        clGray ,
        clBlack,
        clBlack,
        clBlack
      );

      procedure FixLabel( anIndex: Integer);
      begin
        EditSearch.TextHint := Captions[ anIndex];
      end;

    begin
      EditSearch  .Enabled := SearchPatch or SearchSelector;
      MenuEditFind.Enabled := ShowTopPane and ( SearchPatch or SearchSelector);

      if      SearchPatch
      and     SearchSelector
      then    FixLabel( 3)
      else if SearchSelector
      then    FixLabel( 2)
      else if SearchPatch
      then    FixLabel( 1)
      else    FixLabel( 0);
    end;


    procedure   TFormWren.FixLocalControls;
    var
      i : Integer;
    begin
      for i := 0 to ComponentCount - 1
      do  begin
        if   Components[ i] is TKnobsKnob
        then begin
          TKnobsKnob(         Components[ i]).WheelSupport      := UseWheelOnKnobs;
          TKnobsKnob(         Components[ i]).WheelSensitivity  := WheelSensitivity;
          TKnobsKnob(         Components[ i]).MIDIColor         := KnobMIDIColor;
          TKnobsKnob(         Components[ i]).FocusColor        := KnobFocusColor;
          TKnobsKnob(         Components[ i]).MIDIFocusColor    := KnobMIDIFocusColor;
          if   not ( Components[ i] is TKnobsNoKnob)
          then TKnobsKnob(    Components[ i]).ControlMode       := ControlMode;
        end
        else if Components[ i] is TKnobsSelector
        then begin
          TKnobsSelector(     Components[ i]).Color             := SelectorColor;
          TKnobsSelector(     Components[ i]).BorderColor       := SelectorBorderColor;
          TKnobsSelector(     Components[ i]).BorderColorSingle := SelectorBorderColorS;
        end
        else if Components[ i] is TKnobsDisplay
        then begin
          TKnobsDisplay(      Components[ i]).Color             := DisplayColor;
          TKnobsDisplay(      Components[ i]).BorderColor       := DisplayBorderColor;
        end
        else if Components[ i] is TKnobsDataViewer
        then begin
          TKnobsDataViewer(   Components[ i]).Color             := ViewerColor;
          TKnobsDataViewer(   Components[ i]).BorderColor       := ViewerBorderColor;
          TKnobsDataViewer(   Components[ i]).LineColor         := ViewerLineColor;
          TKnobsDataViewer(   Components[ i]).FillColor         := ViewerFillColor;
        end
        else if Components[ i] is TKnobsDataMaker
        then begin
          TKnobsDataMaker(    Components[ i]).LineColor         := ViewerLineColor;
        end
        else if Components[ i] is TKnobsIndicatorBar
        then begin
          TKnobsIndicatorBar( Components[ i]).PeakColor         := IndBarPeakColor;
          TKnobsIndicatorBar( Components[ i]).ValeyColor        := IndBarValeyColor;
        end
      end;
    end;


    procedure   TFormWren.FixTabColors;
    begin
      if   Assigned( ModuleSelector)
      and  Assigned( FormStore)
      then ModuleSelector.GetTabColors( FormStore.GetTabColor, clSilver, 128, 192);
    end;


    procedure   TFormWren.FixMenu;
    begin
      if   PageControlMain.ActivePage = TabSheetEditor
      then MenuViewEditor.Checked := True
      else if PageControlMain.ActivePage = TabSheetSettings
      then MenuViewSettings.Checked := True
      else if PageControlMain.ActivePage = TabSheetGraphs
      then MenuViewGraphs.Checked := True
      else if PageControlMain.ActivePage = TabSheetDebug
      then MenuViewGraphs.Checked := True;
    end;


    procedure   TFormWren.FixMorphsAndRanges;
    var
      aNames : TStringList;
    begin
      aNames := CreateRangeNames;

      try
        KnobsSelectorRanges.Captions := aNames;
      finally
        aNames.DisposeOf;
      end;

      RangeChanged( 0);
    end;


    procedure   TFormWren.FixLookAndFeelPresets;
    var
      aDirList : TStrings;
      i        : Integer;
    begin
      aDirList := CreateFileNames( LooksPath, '*.*', faDirectory, True);

      if   Assigned( aDirList)
      then begin
        try
          i := aDirList.Count - 1;

          while i >= 0
          do begin
            if  ( aDirList[ i] = '.') or ( aDirList[ i] = '..')
            then aDirList.Delete( i)
            else Dec( i);
          end;

          ComboBoxPresets.Items.Assign( aDirList);

          FLooksFolder := '';

          if   ComboBoxPresets.Items.Count > 0
          then begin
            ComboBoxPresets.ItemIndex := 0;
            FLooksFolder := Format( '%s\%s', [ LooksPath, ComboBoxPresets.Items[ 0]], AppLocale);
          end;

          SyncLookAndFeelPresets;
        finally
          aDirList.Free;
        end;
      end;
    end;


    procedure   TFormWren.SyncLookAndFeelPresets;
    var
      aName : string;
      i     : Integer;
    begin
      aName      := CleanFileName( FLooksFolder);
      GLooksPath := FLooksFolder;

      for i := 0 to ComboBoxPresets.Items.Count - 1
      do begin
        if   Sametext( aName, ComboBoxPresets.Items[ i])
        then begin
          ComboBoxPresets.ItemIndex := i;
          Break;
        end;
      end;
    end;


    procedure   TFormWren.LoadModuleGlyphs;
    begin
      ModuleSelector     .ReloadGlyphs ( FLooksFolder);
      knobs2013          .CreateBitmaps( FLooksFolder);
      PatchEditor        .FixBitmaps;
      KnobsWirePanelLooks.FixBitmaps;
    end;


    function    TFormWren.LooksIniName: string;
    begin
      Result := Format( '%s\looks.ini', [ FLooksFolder], AppLocale);
    end;


    procedure   TFormWren.SaveLookAndFeel;
    begin
      if
        SelectDirectory(
          'please select, or create, a folder to save the settings in',
          LooksPath,
          FLooksFolder,
          [
            sdNewFolder,
            sdShowEdit,
            sdShowShares,
            sdNewUI,
            sdValidateDir
          ]
        )
      then begin
        SyncLookAndFeelPresets;
        SaveIni( LooksIniName, True);
      end;
    end;


    procedure   TFormWren.LoadLookAndFeel( const aFolder: string);
    var
      anIniFile  : TMemIniFile;
      aUserTheme : string;
    begin
      FLooksFolder := aFolder;
      SyncLookAndFeelPresets;

      if   FCanLoadLookAndFeel
      then begin
        LoadIni( LooksIniName, True );
        SaveIni( IniFileName , False);
        LoadModuleGlyphs;

        if   Assigned( FormStore)
        then FormStore.LoadControlGlyphs( aFolder);

        if   UseThemes
        and  not FInFormShow
        then begin
          try
            anIniFile := TMemIniFile.Create( LooksIniName);

            try
              aUserTheme := anIniFile.ReadString( slooks, 'Theme', UserTheme);

              if   aUserTheme = ''
              then aUserTheme := DefaultUserTheme;
            finally
              anIniFile.DisposeOf;
            end;

            Theme := aUserTheme;
          except
            on E: Exception
            do KilledException( E);
          end;
        end;
      end;
    end;


    procedure   TFormWren.DoLooksEditorClicked( aSender: TObject);
    var
      aColorId : TColorId;
      i        : Integer;
    begin
      if   aSender is TComponent
      then begin
        aColorId := TColorId(( aSender as TComponent).Tag);

        for i := 0 to ComboBoxColors.Items.Count - 1
        do begin
          if   TColorId( ComboBoxColors.Items.Objects[ i]) = aColorId
          then begin
            ComboBoxColors.ItemIndex := i;
            ChangeColorId( i);
            Break;
          end;
        end;
      end;
    end;


    procedure   TFormWren.SplashKill;
    begin
      FreeAndNil( FormSplash);
    end;


    function    TFormWren.GetColorMapLength: Integer;
    begin
      Result := Length( FColorMaps);
    end;


    procedure   TFormWren.SetColorMapLength( aValue: Integer);
    begin
      SetLength( FColorMaps, aValue);
    end;


    procedure   TFormWren.SetCurrentColor( aValue: TColorId);
    var
      aColor : TColor;
    begin
      if   aValue <> FCurrentColor
      then begin
        FCurrentColor := aValue;
        aColor        := GetColor( aValue);
        ColorBoxCombo.DefaultColorColor := aColor;
        ColorBoxCombo.Selected          := aColor;
      end;
    end;


    function    TFormWren.GetColor( anIndex: TColorId): TColor;
    var
      i : Integer;
    begin
      Result := clNone;

      for i := 0 to ColorMapLength - 1
      do begin
        if   FColorMaps[ i].Id = anIndex
        then begin
          Result := FColorMaps[ i].Getter;
          Break;
        end;
      end;
    end;


    procedure   TFormWren.SetColor( anIndex: TColorId; aValue: TColor);
    var
      i : Integer;
    begin
      for i := 0 to ColorMapLength - 1
      do begin
        if   FColorMaps[ i].Id = anIndex
        then begin
          FColorMaps[ i].Setter( aValue);
          Break;
        end;
      end;
    end;


    procedure   TFormWren.AddColorMap( anId: TColorId; const aName: string; const aGetter: TColorGetter; const aSetter: TColorSetter);
    begin
      ColorMapLength := ColorMapLength + 1;
      FColorMaps[ ColorMapLength - 1].Id     := anId;
      FColorMaps[ ColorMapLength - 1].Name   := aName;
      FColorMaps[ ColorMapLength - 1].Getter := aGetter;
      FColorMaps[ ColorMapLength - 1].Setter := aSetter;
    end;


    procedure   TFormWren.FixColorMaps;
    var
      i : Integer;
    begin
      ColorMapLength := 0;

      AddColorMap( cidEditorBackground    , 'Editor background color'     , GetEditorBackgroundColor, SetEditorBackgroundColor);
      AddColorMap( cidModule              , 'Module color'                , GetModuleColor          , SetModuleColor          );
      AddColorMap( cidConnectorBorder     , 'Connector border color'      , GetConnectorBorderColor , SetConnectorBorderColor );
      AddColorMap( cidSelector            , 'Selector color'              , GetSelectorColor        , SetSelectorColor        );
      AddColorMap( cidSelectorBorder      , 'Selector border color'       , GetSelectorBorderColor  , SetSelectorBorderColor  );
      AddColorMap( cidSelectorBorderSingle, 'Selector border color single', GetSelectorBorderColorS , SetSelectorBorderColorS );
      AddColorMap( cidDisplay             , 'Display color'               , GetDisplayColor         , SetDisplayColor         );
      AddColorMap( cidDisplayBorder       , 'Display border color'        , GetDisplayBorderColor   , SetDisplayBorderColor   );
      AddColorMap( cidKnobMIDI            , 'Knob MIDI color'             , GetKnobMIDIColor        , SetKnobMIDIColor        );
      AddColorMap( cidKnobFocus           , 'Knob focus color'            , GetKnobFocusColor       , SetKnobFocusColor       );
      AddColorMap( cidKnobMIDIFocus       , 'Knob MIDI and focus color'   , GetKnobMIDIFocusColor   , SetKnobMIDIFocusColor   );
      AddColorMap( cidViewer              , 'Viewer color'                , GetViewerColor          , SetViewerColor          );
      AddColorMap( cidViewerBorder        , 'Viewer border color'         , GetViewerBorderColor    , SetViewerBorderColor    );
      AddColorMap( cidViewerLine          , 'Viewer line color'           , GetViewerLineColor      , SetViewerLineColor      );
      AddColorMap( cidViewerFill          , 'Viewer fill color'           , GetViewerFillColor      , SetViewerFillColor      );
      AddColorMap( cidIndicatorBarPeak    , 'Indicatorbar peak color'     , GetIndBarPeakColor      , SetIndBarPeakColor      );
      AddColorMap( cidIndicatorBarValey   , 'Indicatorbar valey color'    , GetIndBarValeyColor     , SetIndBarValeyColor     );
      AddColorMap( cidAudioRate           , 'Audiorate color'             , GetAudioRateColor       , SetAudioRateColor       );
      AddColorMap( cidControlRate         , 'Controlrate color'           , GetControlRateColor     , SetControlRateColor     );
      AddColorMap( cidControlRateLogic    , 'ControlrateLogic color'      , GetControlRateLogicColor, SetControlRateLogicColor);
      AddColorMap( cidLogic               , 'Logic color'                 , GetLogicColor           , SetLogicColor           );
      AddColorMap( cidUnconnectedWire     , 'Unconnected wire color'      , GetUnconnectedWireColor , SetUnconnectedWireColor );
      AddColorMap( cidWireHghlight        , 'Wire highlight color'        , GetWireHighlightColor   , SetWireHighlightColor   );
      AddColorMap( cidGroupIO             , 'Module group I/O color'      , GetGroupIOColor         , SetGroupIOColor         );
      AddColorMap( cidGroupOSC            , 'Module group OSC color'      , GetGroupOSCColor        , SetGroupOSCColor        );
      AddColorMap( cidGroupLFO            , 'Module group LFO color'      , GetGroupLFOColor        , SetGroupLFOColor        );
      AddColorMap( cidGroupEnv            , 'Module group Env color'      , GetGroupEnvColor        , SetGroupEnvColor        );
      AddColorMap( cidGroupFilter         , 'Module group Filter color'   , GetGroupFilterColor     , SetGroupFilterColor     );
      AddColorMap( cidGroupSwitch         , 'Module group Switch color'   , GetGroupSwitchColor     , SetGroupSwitchColor     );
      AddColorMap( cidGroupMix            , 'Module group Mix color'      , GetGroupMixColor        , SetGroupMixColor        );
      AddColorMap( cidGroupControl        , 'Module group Control color'  , GetGroupControlColor    , SetGroupControlColor    );
      AddColorMap( cidGroupNote           , 'Module group Note color'     , GetGroupNoteColor       , SetGroupNoteColor       );
      AddColorMap( cidGroupMath           , 'Module group Math color'     , GetGroupMathColor       , SetGroupMathColor       );
      AddColorMap( cidGroupLogic          , 'Module group Logic color'    , GetGroupLogicColor      , SetGroupLogicColor      );
      AddColorMap( cidGroupSeq            , 'Module group Seq color'      , GetGroupSeqColor        , SetGroupSeqColor        );
      AddColorMap( cidGroupGenerator      , 'Module group Gen color'      , GetGroupGeneratorColor  , SetGroupGeneratorColor  );
      AddColorMap( cidGroupFX             , 'Module group FX color'       , GetGroupFXColor         , SetGroupFXColor         );
      AddColorMap( cidGroupDelay          , 'Module group Delay color'    , GetGroupDelayColor      , SetGroupDelayColor      );
      AddColorMap( cidGroupDelay          , 'Module group Voice color'    , GetGroupVoiceColor      , SetGroupVoiceColor      );
      AddColorMap( cidGroupUtility        , 'Module group Utility color'  , GetGroupUtilityColor    , SetGroupUtilityColor    );

      ComboBoxColors.Items.Clear;

      for i := 0 to ColorMapLength - 1
      do  ComboBoxColors.Items.AddObject( FColorMaps[ i].Name, Pointer( FColorMaps[ i].Id));

      CurrentColor := cidGroupOSC;
      ChangeColorId( 0);
    end;


    procedure   TFormWren.ChangeColorId( anIndex: Integer);
    begin
      ComboBoxColors.ItemIndex := anIndex;

      if   anIndex >= 0
      then CurrentColor := FColorMaps[ anIndex].Id;
    end;


    procedure   TFormWren.ChangeCurrentColor( aColor: TColor);
    begin
      SetColor( CurrentColor, aColor);
    end;


    //  private

    procedure   TFormWren.SetSynthName( const aValue: string);
    begin
      if   aValue <> FSynthName
      then begin
        FSynthName         := aValue;
        EditSynthName.Text := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetCanLog( aValue: Boolean);
    begin
      if   aValue <> FCanLog
      then begin
        FCanLog := aValue;

        if   CanLog
        then Log( LC_STARTUP, FSavedLogs, True);     // This will clear FSavedLogs
      end;
    end;


    procedure   TFormWren.SetLogToFile( aValue: Boolean);
    begin
      if   aValue <> FLogToFile
      then begin
        FLogToFile                := aValue;
        CheckBoxLogToFile.Checked := aValue;
      end;
    end;


    function    TFormWren.GetOffsetLeft: Integer;
    begin
      if   Assigned( PatchEditor)
      then Result := PatchEditor.OffsetLeft
      else Result := 4;
    end;


    procedure   TFormWren.SetOffsetLeft( aValue: Integer);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.OffsetLeft := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.OffsetLeft := aValue;

      KnobsSmallKnob_LeftOffset.KnobPosition := aValue;
    end;


    function    TFormWren.GetOffsetTop: Integer;
    begin
      if   Assigned( PatchEditor)
      then Result := PatchEditor.OffsetTop
      else Result := 4;
    end;


    procedure   TFormWren.SetOffsetTop( aValue: Integer);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.OffsetTop := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.OffsetTop := aValue;

      KnobsSmallKnob_TopOffset.KnobPosition := aValue;
    end;


    function    TFormWren.GetModuleColor: TColor;
    begin
      Result := PatchEditor.ModuleColor;
    end;


    procedure   TFormWren.SetModuleColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ModuleColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks .ModuleColor := aValue;
    end;


    function    TFormWren.GetConnectorBorderColor: TColor;
    begin
      Result := PatchEditor.ConnectorBorderColor;
    end;


    procedure   TFormWren.SetConnectorBorderColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ConnectorBorderColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ConnectorBorderColor := aValue;

      if   Assigned( FormStore)
      then FormStore.ConnectorBorderColor := aValue;
    end;


    function    TFormWren.GetSelectorColor: TColor;
    begin
      Result := PatchEditor.SelectorColor;
    end;


    procedure   TFormWren.SetSelectorColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SelectorColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks .SelectorColor := aValue;

      if   Assigned( FormStore)
      then FormStore.SelectorColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetSelectorBorderColor: TColor;
    begin
      Result := PatchEditor.SelectorBorderColor;
    end;


    procedure   TFormWren.SetSelectorBorderColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SelectorBorderColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.SelectorBorderColor := aValue;

      if   Assigned( FormStore)
      then FormStore.SelectorBorderColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetSelectorBorderColorS: TColor;
    begin
      Result := PatchEditor.SelectorBorderColorSingle;
    end;


    procedure   TFormWren.SetSelectorBorderColorS( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SelectorBorderColorSingle := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.SelectorBorderColorSingle := aValue;

      if   Assigned( FormStore)
      then FormStore.SelectorBorderColorS := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetDisplayColor: TColor;
    begin
      Result := PatchEditor.DisplayColor;
    end;


    procedure   TFormWren.SetDisplayColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.DisplayColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.DisplayColor := aValue;

      if   Assigned( FormStore)
      then FormStore.DisplayColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetDisplayBorderColor: TColor;
    begin
      Result := PatchEditor.DisplayBorderColor;
    end;


    procedure   TFormWren.SetDisplayBorderColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.DisplayBorderColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.DisplayBorderColor := aValue;

      if   Assigned( FormStore)
      then FormStore.DisplayBorderColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetKnobMIDIColor: TColor;
    begin
      Result := PatchEditor.KnobMIDIColor;
    end;


    procedure   TFormWren.SetKnobMIDIColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.KnobMIDIColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.KnobMIDIColor := aValue;

      if   Assigned( FormStore)
      then FormStore.KnobMIDIColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetKnobFocusColor: TColor;
    begin
      Result := PatchEditor.KnobFocusColor;
    end;


    procedure   TFormWren.SetKnobFocusColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.KnobFocusColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.KnobFocusColor := aValue;

      if   Assigned( FormStore)
      then FormStore.KnobFocusColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetKnobMIDIFocusColor: TColor;
    begin
      Result := PatchEditor.KnobMIDIFocusColor;
    end;


    procedure   TFormWren.SetKnobMIDIFocusColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.KnobMIDIFocusColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.KnobMIDIFocusColor := aValue;

      if   Assigned( FormStore)
      then FormStore.KnobMIDIFocusColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetViewerColor: TColor;
    begin
      Result := PatchEditor.ViewerColor;
    end;


    procedure   TFormWren.SetViewerColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ViewerColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ViewerColor := aValue;

      if   Assigned( FormStore)
      then FormStore.ViewerColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetViewerBorderColor: TColor;
    begin
      Result := PatchEditor.ViewerBorderColor;
    end;


    procedure   TFormWren.SetViewerBorderColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ViewerBorderColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ViewerBorderColor := aValue;

      if   Assigned( FormStore)
      then FormStore.ViewerBorderColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetViewerLineColor: TColor;
    begin
      Result := PatchEditor.ViewerLineColor;
    end;


    procedure   TFormWren.SetViewerLineColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ViewerLineColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ViewerLineColor := aValue;

      if   Assigned( FormStore)
      then FormStore.ViewerLineColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetViewerFillColor: TColor;
    begin
      Result := PatchEditor.ViewerFillColor;
    end;


    procedure   TFormWren.SetViewerFillColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ViewerFillColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ViewerFillColor := aValue;

      if   Assigned( FormStore)
      then FormStore.ViewerFillColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetIndBarPeakColor: TColor;
    begin
      Result := PatchEditor.IndBarPeakColor;
    end;


    procedure   TFormWren.SetIndBarPeakColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.IndBarPeakColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.IndBarPeakColor := aValue;

      if   Assigned( FormStore)
      then FormStore.IndBarPeakColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetIndBarValeyColor: TColor;
    begin
      Result := PatchEditor.IndBarValeyColor;
    end;


    procedure   TFormWren.SetIndBarValeyColor( aValue: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.IndBarValeyColor := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.IndBarValeyColor := aValue;

      if   Assigned( FormStore)
      then FormStore.IndBarValeyColor := aValue;

      FixLocalControls;
    end;


    function    TFormWren.GetGroupIOColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupIOColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupIOColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupIOColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupOSCColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupOSCColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupOSCColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupOSCColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupLFOColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupLFOColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupLFOColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupLFOColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupEnvColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupEnvColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupEnvColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupEnvColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupFilterColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupFilterColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupFilterColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupFilterColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupSwitchColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupSwitchColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupSwitchColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupSwitchColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupMixColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupMixColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupMixColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupMixColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupControlColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupControlColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupControlColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupControlColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupNoteColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupNoteColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupNoteColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupNoteColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupMathColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupMathColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupMathColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupMathColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupLogicColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupLogicColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupLogicColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupLogicColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupSeqColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupSeqColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupSeqColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupSeqColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupGeneratorColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupGeneratorColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupGeneratorColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupGeneratorColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupFXColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupFXColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupFXColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupFXColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupDelayColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupDelayColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupDelayColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupDelayColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupVoiceColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupVoiceColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupVoiceColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupVoiceColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetGroupUtilityColor: TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.GroupUtilityColor
      else Result := clNone;
    end;


    procedure   TFormWren.SetGroupUtilityColor( aValue: TColor);
    begin
      if   Assigned( FormStore)
      then begin
        FormStore.GroupUtilityColor := aValue;
        FixTabColors;
      end;
    end;


    function    TFormWren.GetAudioRateColor: TColor;
    begin
      Result := ColorAudio;
    end;


    procedure   TFormWren.SetAudioRateColor( aValue: TColor);
    begin
      if   aValue <> ColorAudio
      then begin
        ColorAudio := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetControlRateColor: TColor;
    begin
      Result := ColorControl;
    end;


    procedure   TFormWren.SetControlRateColor( aValue: TColor);
    begin
      if   aValue <> ColorControl
      then begin
        ColorControl := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetControlRateLogicColor: TColor;
    begin
      Result := ColorContrLogic;
    end;


    procedure   TFormWren.SetControlRateLogicColor( aValue: TColor);
    begin
      if   aValue <> ColorContrLogic
      then begin
        ColorContrLogic := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetLogicColor: TColor;
    begin
      Result := ColorLogic;
    end;


    procedure   TFormWren.SetLogicColor( aValue: TColor);
    begin
      if   aValue <> ColorLogic
      then begin
        ColorLogic := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetUnconnectedWireColor: TColor;
    begin
      Result := ColorUnknown;
    end;


    procedure   TFormWren.SetUnconnectedWireColor( aValue: TColor);
    begin
      if   aValue <> ColorUnknown
      then begin
        ColorUnknown := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetWireHighlightColor: TColor;
    begin
      Result := ColorHighlight;
    end;


    procedure   TFormWren.SetWireHighlightColor( aValue: TColor);
    begin
      if   aValue <> ColorHighlight
      then begin
        ColorHighlight := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.InvalidateWires;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.InvalidateWires;
      end;
    end;


    function    TFormWren.GetEditorBackgroundColor : TColor;
    begin
      Result := FEditorBackgroundColor;
    end;

    procedure   TFormWren.SetEditorBackgroundColor( aValue: TColor);
    begin
      if   aValue <> FEditorBackgroundColor
      then begin
        if   Assigned( PatchEditor)
        then PatchEditor.Color := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.Color := aValue;

        if   Assigned( FormStore)
        then FormStore.Color := aValue;
      end;
    end;


    procedure   TFormWren.SetStandardColors( aValue: Boolean);
    begin
      if   aValue <> FStandardColors
      then begin
        FStandardColors                := aValue;
        CheckboxStandardColors.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetUseConnectorBorders( aValue: Boolean);
    begin
      if   aValue <> FUseConnectorBorders
      then begin
        FUseConnectorBorders                := aValue;
        CheckBoxUseConnectorBorders.Checked := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.UseConnectorBorders := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.UseConnectorBorders := aValue;

        if   Assigned( FormStore)
        then FormStore.ConnectorBorders := aValue;
      end;
    end;


    procedure   TFormWren.SetUseTypedConnectorBorders( aValue: Boolean);
    begin
      if   aValue <> FUseTypedConnectorBorders
      then begin
        FUseTypedConnectorBorders                := aValue;
        CheckBoxUseTypedConnectorBorders.Checked := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.UseTypedConnectorBorders := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.UseTypedConnectorBorders := aValue;

        if   Assigned( FormStore)
        then FormStore.ConnectorTypedBorders := aValue;
      end;
    end;


    procedure   TFormWren.SetUseNoteNames( aValue: Boolean);
    begin
      if   aValue <> FUseNoteNames
      then begin
        FUseNoteNames := aValue;
        GUseNoteNames := aValue;
        CheckBoxUseNoteNames.Checked := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.Invalidate;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.Invalidate;

        if   Assigned( FormStore)
        then FormStore.Invalidate;
      end;
    end;


    function    TFormWren.GetModuleOpacity: Byte;
    begin
      Result := PatchEditor.ModuleOpacity;
    end;


    procedure   TFormWren.SetModuleOpacity( aValue: Byte);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ModuleOpacity := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ModuleOpacity := aValue;

      KnobsSmallKnobModuleOpacity.KnobPosition  := aValue;
    end;


    function    TFormWren.GetModuleFlatness: Boolean;
    begin
      Result := PatchEditor.ModuleFlatness;
    end;


    procedure   TFormWren.SetModuleFlatness( aValue: Boolean);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ModuleFlatness := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ModuleFlatness := aValue;

      CheckboxModuleFlatness.Checked  := aValue;
    end;


    function    TFormWren.GetModuleTexture: Boolean;
    begin
      Result := PatchEditor.ModuleTexture;
    end;


    procedure   TFormWren.SetModuleTexture( aValue: Boolean);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ModuleTexture := aValue;

      if   Assigned( KnobsWirePanelLooks)
      then KnobsWirePanelLooks.ModuleTexture := aValue;

      CheckboxModuleTexture.Checked  := aValue;
    end;


    function    TFormWren.Gettheme: string;
    begin
      Result := UserTheme;
    end;


    procedure   TFormWren.SetTheme( const aValue: string);
    begin
      if   aValue <> UserTheme
      then begin
        UserTheme := aValue;
        SaveIni( IniFileName, False);                                      // Must ssave ini as theme change reloads it.
        FAutoRun := False;                                                 // Set AutoRun off, will be reset from ini later on
        ComboBoxThemes.ItemIndex := ComboBoxThemes.Items.IndexOf( aValue); // Show the new them
        TStyleManager.TrySetStyle( aValue);                                // Set the new theme
        InvalidateEditors;                                                 // Must invalidate synth popup editors
      end;
    end;


    procedure   TFormWren.SetPrioLevel( aValue: Integer);

      function PriorityLevelToStr( aValue : Integer): string;
      begin
        case aValue of
         -1  : Result := 'idle';
          0  : Result := 'normal';
          1  : Result := 'higher';
          2  : Result := 'real time';
          else Result := Format( 'unknown (%d)', [ aValue], AppLocale);
        end;
      end;

    begin
      if   aValue <> FPrioLevel
      then begin
        if   SetPriorityLevel( aValue)
        then begin
          FPrioLevel := aValue;
          LogFmt( LC_GENERAL, 'priority level was set to "%s".', [ PriorityLevelToStr( FPrioLevel)]);
        end
        else LogFmt( LC_GENERAL, 'could not set priority level to "%s".', [ PriorityLevelToStr( aValue)]);
      end;
    end;


    function    TFormWren.GetWaveDebug: Boolean;
    begin
      if   Assigned( FormWaveDeviceSelect)
      then Result := FormWaveDeviceSelect.Debug
      else Result := False;
    end;


    procedure   TFormWren.SetWaveDebug( aValue: Boolean);
    begin
      if   Assigned( FormWaveDeviceSelect)
      then FormWaveDeviceSelect.Debug := aValue;
    end;


    function    TFormWren.GetSampleRate: Integer;
    begin
      Result := System_Rate;
    end;


    procedure   TFormWren.SetSampleRate( aValue: Integer);
    var
      WasRunning : Boolean;
    begin
      if   ( aValue <> 44100)
      and  ( aValue <> 48000)
      and  ( aValue <> 88200)
      and  ( aValue <> 96000)
      then aValue := 44100;

      if   aValue <> System_Rate
      then begin
        WasRunning := FAudioRunning;
        FreeDevices;                // Recreate devices for new sample rate

        while FAudioRunning
        do    Application.ProcessMessages;

        SetSystemRate( aValue);     // Recalculate lookup tables and such
        FixTuningAndSampleRate( 'SetSampleRate');
        CreateDevices;

        case aValue of
          44100 : RadioGroupSampleRate.ItemIndex := 0;
          48000 : RadioGroupSampleRate.ItemIndex := 1;
          88200 : RadioGroupSampleRate.ItemIndex := 2;
          96000 : RadioGroupSampleRate.ItemIndex := 3;
        end;

        if   WasRunning
        then StartAudio;
      end;
    end;


    function    TFormWren.GetControlDecimation: Integer;
    begin
      Result := Control_Decimation;
    end;


    procedure   TFormWren.SetControlDecimation( aValue: Integer);
    var
      WasRunning : Boolean;
    begin
      if   ( aValue <>  4)
      and  ( aValue <>  8)
      and  ( aValue <> 16)
      and  ( aValue <> 32)
      then aValue := 8;

      if   aValue <> Control_Decimation
      then begin
        WasRunning := FAudioRunning;
        FreeDevices;                          // Recreate devices for new decimation value

        while FAudioRunning
        do    Application.ProcessMessages;

        SetSystemControlDecimation( aValue);  // Recalculate lookup tables and such
        FixTuningAndSampleRate( 'SetControlDecimation');
        CreateDevices;

        case aValue of
           4 : RadioGroupControlDecimation.ItemIndex := 0;
           8 : RadioGroupControlDecimation.ItemIndex := 1;
          16 : RadioGroupControlDecimation.ItemIndex := 2;
          32 : RadioGroupControlDecimation.ItemIndex := 3;
        end;

        if   WasRunning
        then StartAudio;
      end;
    end;


    procedure   TFormWren.SetUseGraphs( aValue: Boolean);
    begin
      if   aValue <> FUseGraphs
      then begin
        FUseGraphs                := aValue;
        CheckBoxUseGraphs.Checked := aValue;
        TabSheetGraphs   .Visible := aValue;
        MenuViewGraphs   .Visible := aValue;
        FixMenu;
        BuildGraphs;
      end;
    end;


    procedure   TFormWren.SetLightsActive( aValue: Boolean);
    begin
      if   aValue <> FLightsActive
      then FLightsActive := aValue;
    end;


    procedure   TFormWren.SetAbsTimeStamps( aValue: Boolean);
    begin
      if   aValue <> FAbsTimeStamps
      then begin
        FAbsTimeStamps                := aValue;
        CheckBoxAbsTimeStamps.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetGraphStairs( aValue: Boolean);
    var
      i : Integer;
    begin
      if   aValue <> FGraphStairs
      then begin
        FGraphStairs                := aValue;
        CheckBoxGraphStairs.Checked := aValue;

        for i := 0 to Length( FChartSeries) - 1
        do  FChartSeries[ i].Stairs := aValue;
      end;
    end;


    procedure   TFormWren.SetHistoryCount( aValue: Integer);
    begin
      if   aValue <> FHistoryCount
      then begin
        FHistoryCount                         := aValue;
        KnobsNoKnob_HistoryCount.KnobPosition := aValue - 1;

        if   Assigned( FRecentSourceFiles)
        then FRecentSourceFiles.MaxDepth := aValue;
      end;
    end;


    function    TFormWren.GetSourceFileName : string;
    begin
      if   Assigned( PatchEditor)
      then Result := PatchEditor.Filename
      else Result := '';
    end;


    procedure   TFormWren.SetSourceFileName( const aValue: string);
    begin
      if   ( aValue <> SourceFileName)
      and  Assigned( PatchEditor)
      then begin
        PatchEditor.Filename := aValue;
        SetMostRecentFile( aValue);
        UpdateCaptions;
      end;
    end;


    function    TFormWren.GetPatchName: string;
    begin
      if   Assigned( PatchEditor)
      then Result := PatchEditor.Title
      else Result := 'no name';
    end;


    procedure   TFormWren.SetPatchName( const aValue: string);
    begin
      if   ( aValue <> PatchName)
      and  Assigned( PatchEditor)
      then begin
        PatchEditor.Title := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetPatchChanged( aValue: Boolean);
    begin
      if   aValue <> FPatchChanged
      then begin
        FPatchChanged := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetWarnOnPatchChange( aValue: Boolean);
    begin
      if   aValue <> FWarnOnPatchChange
      then begin
        FWarnOnPatchChange                := aValue;
        CheckBoxWarnOnPatchChange.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetWarnChangeOnLoad( aValue: Boolean);
    begin
      if   aValue <> FWarnChangeOnLoad
      then begin
        FWarnChangeOnLoad                := aValue;
        CheckBoxWarnChangeOnLoad.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetUndoAfterSave( aValue: Boolean);
    begin
      if   aValue <> FUndoAfterSave
      then begin
        FUndoAfterSave                := aValue;
        CheckBoxUndoAfterSave.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetUndoAfterLoad( aValue: Boolean);
    begin
      if   aValue <> FUndoAfterLoad
      then begin
        FUndoAfterLoad                := aValue;
        CheckBoxUndoAfterLoad.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetUseWheelOnKnobs( aValue: Boolean);
    begin
      if   aValue <> FUseWheelOnKnobs
      then begin
        FUseWheelOnKnobs                := aValue;
        CheckBoxUseWheelOnKnobs.Checked := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.WheelSupportOnKnobs := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.WheelSupportOnKnobs := aValue;

        if   Assigned( FormSelectMidiCC)
        then FormSelectMidiCC.UseWheelOnKnobs := aValue;

        if   Assigned( FormRandomizer)
        then FormRandomizer.WheelSupport := aValue;

        FixLocalControls;
        CheckBoxUseUnFocus.Enabled := aValue;
      end;
    end;


    procedure   TFormWren.SetWheelSensitivity( aValue: Integer);
    begin
      if   aValue <> FWheelSensitivity
      then begin
        FWheelSensitivity                  := aValue;
        knob_WheelSensitivity.KnobPosition := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.WheelSensitivity := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.WheelSensitivity := aValue;

        if   Assigned( FormSelectMidiCC)
        then FormSelectMidiCC.WheelSensitivity := aValue;

        if   Assigned( FormRandomizer)
        then FormRandomizer.WheelSensitivity := aValue;

        FixLocalControls;
      end;
    end;


    procedure   TFormWren.SetUseUnFocus( aValue: Boolean);
    begin
      if   aValue <> FUseUnfocus
      then begin
        FUSeUnFocus                := aValue;
        CheckBoxUseUnFocus.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetTuningChanged( aValue: Boolean);
    begin
      if   aValue <> FTuningChanged
      then begin
        FTuningChanged             := aValue;
        BitBtnApplyTuning .Enabled := aValue;
        BitBtnCancelTuning.Enabled := aValue;
      end;
    end;


    procedure   TFormWren.SetSearchPatch( aValue: Boolean);
    begin
      if   aValue <> FSearchPatch
      then begin
        FSearchPatch                := aValue;
        CheckBoxSearchPatch.Checked := aValue;
        FixSearchVisuals;
      end;
    end;


    procedure   TFormWren.SetSearchSelector( aValue: Boolean);
    begin
      if   aValue <> FSearchSelector
      then begin
        FSearchSelector                := aValue;
        CheckBoxSearchSelector.Checked := aValue;
        FixSearchVisuals;
      end;
    end;


    procedure   TFormWren.SetWarnOnStructMismatch( aValue: Boolean);
    begin
      if   aValue <> FWarnOnStructMismatch
      then begin
        FWarnOnStructMismatch                := aValue;
        CheckBoxWarnOnStructMismatch.Checked := aValue;

        if   Assigned( FPatchReader)
        then FPatchReader.WarnOnStructMismatch := aValue;
      end;
    end;


    procedure   TFormWren.SetDisableAutoDocs( aValue: Boolean);
    begin
      if   aValue <> FDisableAutoDocs
      then begin
        FDisableAutoDocs                := aValue;
        CheckBoxDisableAutoDocs.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetAllowAutoLoad( aValue: Boolean);
    begin
      if   aValue <> FAllowAutoLoad
      then begin
        FAllowAutoLoad                := aValue;
        CheckBoxAllowAutoLoad.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetNoLoadTuning( aValue: Boolean);
    begin
      if   aValue <> FNoLoadTuning
      then begin
        FNoLoadTuning                := aValue;
        CheckBoxNoLoadTuning.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetNewPatchNameTemplate( const aValue: string);
    begin
      if   aValue <> FNewPatchNameTemplate
      then begin
        FNewPatchNameTemplate         := aValue;
        EditNewPatchNameTemplate.Text := aValue;
      end;
    end;


    procedure   TFormWren.SetTextWriterPrefix( const aValue: string);
    begin
      if   aValue <> FTextWriterPrefix
      then begin
        FTextWriterPrefix         := aValue;
        EditTextWriterPrefix.Text := aValue;
      end;
    end;


    procedure   TFormWren.SetReloadLastPatch( aValue: Boolean);
    begin
      if   aValue <> FReloadLastPatch
      then begin
        FReloadLastPatch                := aValue;
        CheckBoxReloadLastPatch.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetAutoRun( aValue: Boolean);
    begin
      if   aValue <> FAutoRun
      then begin
        FAutoRun                := aValue;
        CheckBoxAutoRun.Checked := aValue;

        if  AutoRun
        and FCanCreateAudio
        then begin
          if   not FAudioRunning
          then StartAudio;
        end;
      end;
    end;


    procedure   TFormWren.SetClearVUOnStop( aValue: Boolean);
    begin
      if   aValue <> FClearVUOnStop
      then begin
        FClearVUOnStop                := aValue;
        CheckBoxClearVUOnStop.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetClearVUOnRecompile( aValue: Boolean);
    begin
      if   aValue <> FClearVUOnRecompile
      then begin
        FClearVUOnRecompile                := aValue;
        CheckBoxClearVUOnRecompile.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetRenderToFile( aValue: Boolean);
    begin
      if   aValue <> FRenderToFile
      then begin
        FRenderToFile := aValue;
        KnobsSelectorFileRender.KnobPosition := Ord( aValue);

        if   aValue
        then begin
          Sounding := True;
          StartRendering;
        end;
      end;
    end;


//  private

    procedure   TFormWren.SetNetMidiServer( const aValue: string);
    var
      WasConnected : Boolean;
    begin
      if   aValue <> FNetMidiServer
      then begin
        EditNetMidiServer.Text := aValue;
        WasConnected := NetMidiConnected;
        NetMidiDisconnect;
        FNetMidiServer := aValue;

        if   WasConnected
        then NetMidiConnect;
      end;
    end;


    procedure   TFormWren.SetNetMidiPort( const aValue: string);
    var
      WasConnected : Boolean;
    begin
      if   aValue <> FNetMidiPort
      then begin
        EditNetMidiPort.Text := aValue;
        WasConnected := NetMidiConnected;
        NetMidiDisconnect;
        FNetMidiPort := aValue;

        if   WasConnected
        then NetMidiConnect;
      end;
    end;


    procedure   TFormWren.SetNetMidiAutoConnect( aValue: Boolean);
    begin
      if   aValue <> FNetMidiAutoConnect
      then begin
        FNetMidiAutoConnect                := aValue;
        CheckBoxNetMidiAutoConnect.Checked := aValue;

        if   NetMidiAutoConnect
        and  not NetMidiConnected
        then StartNetMidiConnectTimer;
      end;
    end;


    procedure   TFormWren.SetNetMidiConnected( aValue: Boolean);
    const
      Caps : array[ Boolean] of string = (
        'connect',
        'disconnect'
      );
    begin
      if   aValue <> FNetMidiConnected
      then begin
        FNetMidiConnected            := aValue;
        LedNetMidiConnect1  .Active  := aValue;
        LedNetMidiConnect2  .Active  := aValue;
        BitBtnNetMidiConnect.Caption := Caps[ aValue];
      end;
    end;


    procedure   TFormWren.SetNetMidiChanged( aValue: Boolean);
    begin
      if   aValue <> FNetMidiChanged
      then begin
        FNetMidiChanged             := aValue;
        BitBtnApplyNetMidi .Enabled := aValue;
        BitBtnCancelNetMidi.Enabled := aValue;
      end;
    end;


    procedure   TFormWren.SetLogMidi( aValue: Boolean);
    begin
      if  aValue <> FLogMidi
      then begin
        FLogMidi                := aValue;
        CheckBoxLogMidi.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetLogMidiMsgs( aValue: Boolean);
    begin
      if  aValue <> FLogMidiMsgs
      then begin
        FLogMidiMsgs                := aValue;
        CheckBoxLogMidiMsgs.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetMidiChannel( aValue: Byte);
    begin
      if  aValue <> FMidiChannel
      then begin
        FMidiChannel             := aValue;
        main_midich.KnobPosition := aValue;

        if   Assigned( FSynthPatch)
        then FSynthPatch.MidiChannel := MidiChannel;
      end;
    end;


    procedure   TFormWren.SetMidiRpnMode( aValue: TRpnMode);
    begin
      if   aValue <> FMidiRpnMode
      then begin
        FMidiRpnMode                := aValue;
        RadioGroupRpnMode.ItemIndex := Ord( aValue);
        FMidiReceiver    .RpnMode   := aValue;
      end;
    end;


//  private

    procedure   TFormWren.SetOSCServer( const aValue: string);
    begin
      if   aValue <> FOSCServer
      then begin
        EditOSCServer.Text := aValue;
        FOSCServer         := aValue;
      end;
    end;


    procedure   TFormWren.SetOSCPort( const aValue: string);
    begin
      if   aValue <> FOSCPort
      then begin
        EditOSCPort.Text := aValue;
        FOSCPort         := aValue;
      end;
    end;


    procedure   TFormWren.SetUseOSC( aValue: Boolean);
    begin
      if   aValue <> FUSeOSC
      then begin
        CheckBoxUseOSC.Checked := aValue;
        FUSeOSC                := aValue;
      end;
    end;


    procedure   TFormWren.SetOSCChanged( aValue: Boolean);
    begin
      if   aValue <> FOSCChanged
      then begin
        FOSCChanged             := aValue;
        BitBtnApplyOSC .Enabled := aValue;
        BitBtnCancelOSC.Enabled := aValue;
      end;
    end;


    procedure   TFormWren.SetLogOSC( aValue: Boolean);
    begin
      if   aValue <> FLogOSC
      then begin
        FLogOSC                := aValue;
        CheckBoxLogOSC.Checked := aValue;
      end;
    end;


    procedure   TFormWren.SetLogOSCMsgs( aValue: Boolean);
    begin
      if   aValue <> FLogOSCMsgs
      then begin
        FLogOSCMsgs                := aValue;
        CheckBoxLogOSCMsgs.Checked := aValue;
      end;
    end;


//  private

    procedure   TFormWren.SetAutoCollectDenormals( aValue: Boolean);
    begin
      if   aValue <> FAutoCollectDenormals
      then begin
        FAutoCollectDenormals                := aValue;
        CheckBoxAutoCollectDenormals.Checked := aValue;

        if   AutoCollectDenormals
        then begin
          FAttentionItems := FAttentionItems + [ atSmalls];
          Log( LC_PROFILER, 'WARNING :: AutoCollectDenormals was turned on - this WILL INTERFERE with module selection in the patch');
          Log( LC_PROFILER, 'This is a debug tool :)');
          Log( LC_PROFILER, 'The current patch will be polled once every second for the presence of "small values", when such values are found');
          Log( LC_PROFILER, 'they will be 1) listed in the debug log and 2) the module they were found in will be highlighted in the editor.');

          if   Assigned( PatchEditor)
          then PatchEditor.UnSelectAllModules;
        end
        else begin
          FAttentionItems := FAttentionItems - [ atSmalls];
          Log( LC_PROFILER, 'AutoCollectDenormals was turned off');
        end;
      end;
    end;


    procedure   TFormWren.SetManualCompilation( aValue: Boolean);
    begin
      if   aValue <> FManualCompilation
      then begin
        FManualCompilation                  := aValue;
        ActionMenuManualCompilation.Checked := aValue;

        if   ManualCompilation
        then begin
          FAttentionItems := FAttentionItems + [ atManualCompilation];
          Log( LC_COMPILER, 'Manual compilation turned on');
        end
        else begin
          FAttentionItems := FAttentionItems - [ atManualCompilation];
          Log( LC_COMPILER, 'Manual compilation turned off');

          if   FUncompiledChanges            // When needed enforce recompilation on turning manual compilation off
          then CompilePatch( True, False);
        end;
      end;
    end;


    procedure   TFormWren.SetCompilerDebug( aValue: Boolean);
    begin
      if   aValue <> FCompilerDebug
      then begin
        FCompilerDebug                := aValue;
        CheckBoxCompilerDebug.Checked := aValue;
      end;
    end;


    procedure   TFormWren.PaDebugProc( const aMsg: string);
    begin
      Log( LC_PORTAUDIO, aMsg);
    end;


//  private

    function    TFormWren.GetInVolume1: Integer;
    begin
      Result := knob_inputlevel1.KnobPosition;
    end;


    procedure   TFormWren.SetInVolume1( aValue: Integer);
    begin
      knob_inputlevel1.KnobPosition := aValue;
      FInShadow1                    := knob_inputlevel1.AsValue;
    end;


    function    TFormWren.GetOutVolume1: Integer;
    begin
      Result := knob_outputlevel1.KnobPosition;
    end;


    procedure   TFormWren.SetOutVolume1( aValue: Integer);
    begin
      knob_outputlevel1.KnobPosition := aValue;
      FOutShadow1                    := knob_outputlevel1.AsValue;
    end;


    function    TFormWren.GetInVolume2: Integer;
    begin
      Result := knob_inputlevel2.KnobPosition;
    end;


    procedure   TFormWren.SetInVolume2( aValue: Integer);
    begin
      knob_inputlevel2.KnobPosition := aValue;
      FInShadow2                    := knob_inputlevel2.AsValue;
    end;


    function    TFormWren.GetOutVolume2: Integer;
    begin
      Result := knob_outputlevel2.KnobPosition;
    end;


    procedure   TFormWren.SetOutVolume2( aValue: Integer);
    begin
      knob_outputlevel2.KnobPosition := aValue;
      FOutShadow2                    := knob_outputlevel2.AsValue;
    end;


    function    TFormWren.GetInVolume3: Integer;
    begin
      Result := knob_inputlevel3.KnobPosition;
    end;


    procedure   TFormWren.SetInVolume3( aValue: Integer);
    begin
      knob_inputlevel3.KnobPosition := aValue;
      FInShadow3                    := knob_inputlevel3.AsValue;
    end;


    function    TFormWren.GetOutVolume3: Integer;
    begin
      Result := knob_outputlevel3.KnobPosition;
    end;


    procedure   TFormWren.SetOutVolume3( aValue: Integer);
    begin
      knob_outputlevel3.KnobPosition := aValue;
      FOutShadow3                    := knob_outputlevel3.AsValue;
    end;


    function    TFormWren.GetInVolume4: Integer;
    begin
      Result := knob_inputlevel4.KnobPosition;
    end;


    procedure   TFormWren.SetInVolume4( aValue: Integer);
    begin
      knob_inputlevel4.KnobPosition := aValue;
      FInShadow4                    := knob_inputlevel4.AsValue;
    end;


    function    TFormWren.GetOutVolume4: Integer;
    begin
      Result := knob_outputlevel4.KnobPosition;
    end;


    procedure   TFormWren.SetOutVolume4( aValue: Integer);
    begin
      knob_outputlevel4.KnobPosition := aValue;
      FOutShadow4                    := knob_outputlevel4.AsValue;
    end;


    procedure   TFormWren.SetSounding( aValue: Boolean);
    begin
      if   RenderToFile
      then aValue := True;

      if   aValue <> FSounding
      then begin
        FSounding := aValue;

        if   Sounding
        then begin
          FAttentionItems := FAttentionItems - [ atMuted];
          FOutShadow1 := knob_outputlevel1.AsValue;
          FOutShadow2 := knob_outputlevel2.AsValue;
          FOutShadow3 := knob_outputlevel3.AsValue;
          FOutShadow4 := knob_outputlevel4.AsValue;
        end
        else begin
          FAttentionItems := FAttentionItems + [ atMuted];
          FOutShadow1 := 0.0;
          FOutShadow2 := 0.0; 
          FOutShadow3 := 0.0; 
          FOutShadow4 := 0.0; 
        end;
      end;
    end;


//  private

    procedure   TFormWren.StartRendering;
    // Start recording
    const
      FRAME_SIZE = 512;
    var
      WasRunning : Boolean;
      i          : Integer;
      OldPrio    : Integer;
      aLeft      : TSignal;
      aRight     : TSignal;
      aMaxLeft   : TSignal;
      aMaxRight  : TSignal;
      aTimeLimit : TSignal;
    begin
      with SaveDialogWave
      do begin
        WasRunning := FAudioRunning;

        if   WasRunning
        then StopAudio;

        FileName := FRenderFileName;

        if
          Assigned( FSynthPatch) and
          Execute                and
          InputQuery(
            'Please give a maximum duration for recording',
            'Duration in minutes (may be fractional; 0 or blank means: file size limited to 2 GiB)',
            FRenderDuration
          )
        then begin
          StopRendering;                      // Close any render file that would still be open for whatever reason ...
          FRenderFileName := FileName;
          FRenderFile     := TStereoWaveWriter.Create( FRenderFileName, System_Rate);
          ResetRunTime;
          FOutShadow1     := knob_outputlevel1.AsValue;
          aTimeLimit      := StrToFloatDef( FRenderDuration, 0) * 60 * 1000;
          OldPrio         := PrioLevel;
          PrioLevel       := -1;                // Set 'idle' priority level for rendering

          LogFmt( LC_RENDERER, 'Rendering to file %s', [ FRenderFileName]);

          try
            try
              FSynthPatch.FixDeZippers;

              if   ResetOnRender
              then FSynthPatch.Reset;

              while RenderToFile
              and   not FAudioRunning
              do begin
                Application.ProcessMessages;
                aMaxLeft  := 0;
                aMaxRight := 0;

                SetVuSampleCount( FRAME_SIZE);                    // todo: moved here from inside the loop **1

                for i := 1 to FRAME_SIZE
                do begin
                  {$Q-R-}Inc( FSampleCount);{$Q+R+}

                  if   FSampleCount and Control_Dec_Min_One = 0
                  then begin
                    DeZipper;
                    HandleMorphing;
                  end;

                  if   FRenderFile.Size >= 2 * Int64( GIBI)
                  then begin
                    Log( LC_RENDERER, 'Rendering stopped, file size >= 2 GiB');
                    RenderToFile := False;
                    Break;
                  end;

                  FSynthPatch.TickWithData( FTickInZeroData);
                  aLeft  := FOutVolume1 * FSynthPatch.Output[ 0];
                  aRight := FOutVolume1 * FSynthPatch.Output[ 1];

                  AddRenderData( aLeft, aRight);
                  aMaxLeft  := Max( aMaxLeft , Abs( aLeft ));
                  aMaxRight := Max( aMaxRight, Abs( aRight));

                  // **1 SetVuSampleCount() was here, seemed a bit oft

                  FDbMinMaxOut[ 0].Tick( aMaxLeft );
                  FDbMinMaxOut[ 1].Tick( aMaxRight);
                end;

                if   aTimeLimit > 0
                then begin
                  if   FRenderFile.Duration >= aTimeLimit
                  then begin
                    Log( LC_RENDERER, 'Rendering stopped, time limit reached');
                    RenderToFile := False;
                  end;

                  LabelRunTime.Caption := FormatDateTime( '"R" hh:mm:ss', ( aTimeLimit - FRenderFile.Duration) / ( 1000 * 60 * 60 * 24), AppLocale);
                  LabelRunTime.Hint    := 'Remaining time for current recording, abort by clicking the ''stop file render'' button';
                end
                else begin
                  LabelRunTime.Caption := FormatDateTime( '"T" hh:mm:ss', FRenderFile.Duration / ( 1000 * 60 * 60 * 24), AppLocale);
                  LabelRunTime.Hint    := 'Duration of current recording, abort by clicking the ''stop file render'' button';
                end;
              end;
            except
              on E: Exception
              do begin
                LogFmt( LC_RENDERER, 'Rendering stopped with error: %s', [ E.ToString]);
                RenderToFile := False;
              end;
            end;
          finally
            RenderToFile := False;
            PrioLevel    := OldPrio;
            StopRendering;
          end;
        end
        else begin
          // File dialog or time dialog was cancelled, do not start a rendering
          // cleanup visuals and restart audio when it was running before.
          RenderToFile := False;

          if   WasRunning
          then StartAudio;
        end;
      end;
    end;


    procedure   TFormWren.StopRendering;
    // End a recording, saves the render file.
    begin
      FreeAndNil( FRenderFile);
    end;


    procedure   TFormWren.AddRenderData( const aLeft, aRight: TSignal);
    begin
      if   Assigned( FRenderFile)
      then FRenderFile.WriteSample( Round( SAMP_MAX * Clip( aLeft, -1.0, 1.0)) + Round( SAMP_MAX * Clip( aRight, -1.0, 1.0)) shl 16);
    end;


//  private

    procedure   TFormWren.OpenRecentFile( const anIndex: Integer);
    var
      aFileName: string;
    begin
      if   Assigned( FRecentSourceFiles)
      and  ( anIndex >= 0)
      and  ( anIndex < FRecentSourceFiles.Count)
      then begin
        aFileName := FRecentSourceFiles[ anIndex];

        if   FileExists( aFileName)
        then DoLoadPatch( aFileName, True)
        else begin
          FRecentSourceFiles.Delete( anIndex);
          SetRecentMenuItems;
        end;
      end;
    end;


    procedure   TFormWren.DorecentMenuItemClick( aSender: TObject);
    var
      aMenuItem: TMenuItem;
    begin
      aMenuItem := aSender as TMenuItem;

      if   Assigned( aMenuItem)
      then OpenRecentFile( aMenuItem.Tag);
    end;


    procedure   TFormWren.AddRecentMenuItem( anIndex: Integer; const aFileName: string);
    var
      aMenuItem : TMenuItem;
    begin
      if   FileExists( aFileName)
      then begin
        aMenuItem := TMenuItem.Create( MenuFileReopen);

        with aMenuItem
        do begin
          Caption  := Format( '%s%s', [ IndexToMenuShortCut( anIndex), aFileName], AppLocale);
          Tag      := anIndex;
          OnClick  := DorecentMenuItemClick;
        end;

        MenuFileReopen.Add( aMenuItem);
      end;
    end;


    procedure   TFormWren.RemoveRecentMenuItems;
    begin
      while MenuFileReopen.Count > 0
      do    MenuFileReopen[ 0].DisposeOf;
    end;


    procedure   TFormWren.SetRecentMenuItems;
    var
      i : Integer;
    begin
      RemoveRecentMenuItems;

      for i := 0 to FRecentSourceFiles.Count - 1
      do  AddRecentMenuItem( i, FRecentSourceFiles[ i]);
    end;


    procedure   TFormWren.SetMostRecentFile( const aFileName: string);
    begin
      FRecentSourceFiles.SetMostRecent( aFileName);
      SetRecentMenuItems;
    end;


    procedure   TFormWren.DoSelectorMenuItemClick( aSender: TObject);
    var
      aSelector : TKnobsSelector;
      aMenuItem : TMenuItem;
    begin
      aMenuItem := aSender as TMenuItem;

      if   Assigned( aMenuItem)
      then begin
        aSelector := TKnobsSelector( FPopupSender);
        aSelector.BeginStateChange;

        try
          aSelector.KnobPosition := aMenuItem.Tag;
        finally
          aSelector.EndStateChange;
        end;

        aSelector.FixPeers;
      end;
    end;


    procedure   TFormWren.AddSelectorMenuItem( anIndex, aShortcut: Integer; const aName: string);
    var
      aMenuItem : TMenuItem;
    begin
      aMenuItem := TMenuItem.Create( PopupMenuSelector);

      with aMenuItem
      do begin

        if   aName <> '-'
        then begin
          Caption    := Format( '%s (%d) %s', [ IndexToMenuShortCut( aShortcut), anIndex, aName], AppLocale);
          OnClick    := DoSelectorMenuItemClick;
          Tag        := anIndex;
          ImageIndex := anIndex;
        end
        else Caption := aName;
      end;

      PopupMenuSelector.Items.Add( aMenuItem);
    end;


    procedure   TFormWren.RemoveSelectorMenuItems;
    var
      i : Integer;
    begin
      with PopupMenuSelector
      do begin
        for i := Items.Count - 1 downto 0
        do  Items.Delete( i);
      end;
    end;


    procedure   TFormWren.DoAlternateModuleMenuItemClick( aSender: TObject);
    var
      aMenuItem   : TMenuItem;
      aModule     : TKnobsCustomModule;
      CurrentType : Integer;
      WantedType  : Integer;
    begin
      if   Assigned( PatchEditor)
      then begin
        aMenuItem := aSender as TMenuItem;

        if   Assigned( aMenuItem)
        then begin
          aModule := TKnobsCustomModule( FPopupSender);

          if   Assigned( aModule)
          then begin
            CurrentType := aModule.ModuleType;
            WantedType  := aMenuItem.Tag;

            if   CurrentType <> WantedType
            then ChangeModuleType( aModule, WantedType);  // This Frees aModule, do not use it after that ...
          end;
        end;
      end;
    end;


    procedure   TFormWren.AddModuleAlternateMenuItem( anIndex: Integer; const aCurrent, aName: string; aModuleType: Integer);
    var
      aMenuItem : TMenuItem;
    begin
      aMenuItem := TMenuItem.Create( MenuItemModuleAlternates);

      with aMenuItem
      do begin
        if   aName <> '-'
        then begin
          Caption := Format( '%s%s', [ IndexToMenuShortCut( anIndex), aName], AppLocale);
          Tag     := aModuleType;
          OnClick := DoAlternateModuleMenuItemClick;
        end
        else Caption := aName;
      end;

      MenuItemModuleAlternates.Add( aMenuItem);
      aMenuItem.Checked := SameText( aCurrent, aName);
    end;


    procedure   TFormWren.RemoveModuleAlternateMenuItems;
    var
      i : Integer;
    begin
      with MenuItemModuleAlternates
      do begin
        for i := Count - 1 downto 0
        do  Delete( i);
      end;
    end;


    procedure   TFormWren.ChangeModuleType( var aTarget: TKnobsCustomModule; aWantedType: TKnobsModuleType);
    // User requested a module type change trough the module popup menu.
    //
    //   get connections for aTarget
    //   remove MIDI stuff for aTarget
    //   remove aTarget
    //   Insert aWantedType with AddModule
    //   connect new module with the obtained connections
    //   copy over same named parameters
    //
    // NOTE : aTarget is freed and set to Nil in the process, do not use it after
    var
      aWire         : TKnobsWire;
      aConnections  : TStringList;
      aModule       : TKnobsCustomModule;
      anOldName     : string;
      aNewName      : string;
      anOldTypeName : string;
      aNewTypeName  : string;
      anOldType     : string;
      aNewType      : string;
      i             : Integer;
      aConnection   : string;
      aParams       : string;
    begin
      if   Assigned( aTarget)
      then begin
        PatchEditor.BeginStateChange( True);
        aTarget.SelectUnique;
        aConnections := TStringList.Create;

        try
          anOldType     := IntToStr( aTarget.ModuleType);
          aNewType      := IntToStr( aWantedType);
          anOldName     := aTarget.Name;
          anOldTypeName := LookupModuleTypeName( aTarget.ModuleType);

          for i := 0 to PatchEditor.WireCount - 1                                                          // Obtain wires
          do begin
            aWire := PatchEditor.Wire[ i];

            if   aWire.Involves( aTarget)
            then aConnections.Add( aWire.AsCompactString);
          end;

          aParams := FPatchWriter.WriteString( PatchEditor, '', wmSelected);                               // Obtain parameter settings
          aModule := FormStore.ChangeModule( PatchEditor, aTarget, aWantedType, DoOnValuedControlRemoved); // NILs aTarget and unassigns MIDI cintrol, do not use it after here
          aModule.FixupInsertion;
          aNewName     := aModule.Name;                                                                    // The new module name
          aNewTypeName := LookupModuleTypeName( aWantedType);                                              // The new module type name
          aModule.SelectUnique;
          FPatchReader.ReadParams( aParams, PatchEditor, NO_STRICT);                                       // Fix parameter settings

          for i := 0 to aConnections.Count - 1                                                             // Restore wires
          do begin
            aConnection := ReplaceText( aConnections[ i], Format( '%s.%s', [ anOldName, anOldTypeName], AppLocale) , Format( '%s.%s', [ aNewName, aNewTypeName], AppLocale));
            PatchEditor.AddWire( aConnection);
          end;
        finally
          aConnections.DisposeOf;
          PatchEditor.EndStateChange( True, False);
        end;
      end;
    end;


    procedure   TFormWren.AddModule( aModuleType: TKnobsModuleType);
    // User requested module creation by clicking a button in the module selector,
    // or by selecting a menu item from the editor context menu, create it !
    begin
      PatchEditor.BeginStateChange( True);

      try
        SelectNone; // todo: Quick patch for module jumps on insertion issue
                    //       TKnobsModuleList.CreateModule needs some love ...
        FormStore.CreateModule( PatchEditor, aModuleType, DO_DRAG, StandardColors).FixupInsertion;
      finally
        PatchEditor.EndStateChange( True, True);
      end;
    end;


    procedure   TFormWren.DoEditorMenuAddModule( aSender: TObject);
    var
      aMenuItem : TMenuItem;
    begin
      if   aSender is TMenuItem
      then begin
        aMenuItem := TMenuItem( aSender);

        if   aMenuItem.Tag >= 0
        then AddModule( aMenuItem.Tag);
      end;
    end;


    function    TFormWren.HandleContextMenu( const aControl: TControl): Boolean;
    begin
      Result := False;

      if   Assigned( aControl)
      then begin
        if   ( aControl is TKnobsWirePanel    )
        or   ( aControl is TKnobsModule       )
        or   ( aControl is TKnobsConnector    )
        or   ( aControl is TKnobsValuedControl)
        or   ( aControl is TKnobsDataMaker    )
        or   ( aControl is TKnobsGridControl  )
        then begin
          Result := True;
          DoShowPopupMenu( nil, aControl);
        end;
      end;
    end;


    procedure   TFormWren.LoadIni( const aFileName: string; LooksOnly: Boolean);
    var
      L, T, W, H    : Integer;
      anIniFile     : TMemIniFile;
      WinState      : TWindowState;
      LRate         : Integer;
      ControlWidth  : Integer;
      SelectorWidth : Integer;
      aCount        : Integer;
      i             : Integer;
    begin
      logFmt( LC_GENERAL, 'Loading inifile: ''%s'', LooksOnly = %s', [ IniFileName, BoolToStr( LooksOnly, True)]);

      anIniFile          := TMemIniFile.Create( aFileName);
      LRate              := KnobsSmallKnob_LightsRate.KnobPosition;
      ControlWidth       := PanelControl.Width;
      FLastControlWidth  := ControlWidth;
      SelectorWidth      := ModuleSelector.Width;
      FLastSelectorWidth := SelectorWidth;

      with anIniFile
      do begin
        Log( LC_GENERAL, 'Loading looks');

        try
          // User inteerfce stuff
          OffsetLeft               :=                ReadInteger( slooks, 'OffsetLeft'              ,                OffsetLeft               );
          OffsetTop                :=                ReadInteger( slooks, 'OffsetTop'               ,                OffsetTop                );
          UseConnectorBorders      :=                ReadBool   ( slooks, 'UseConnectorBorders'     ,                UseConnectorBorders      );
          UseTypedConnectorBorders :=                ReadBool   ( slooks, 'UseTypedConnectorBorders',                UseTypedConnectorBorders );
          UseNoteNames             :=                ReadBool   ( slooks, 'UseNoteNames'            ,                UseNoteNames             );
          ModuleColor              := StringToColor( ReadString ( slooks, 'ModuleColor'             , ColorToString( ModuleColor            )));
          SelectorColor            := StringToColor( ReadString ( slooks, 'SelectorColor'           , ColorToString( SelectorColor          )));
          SelectorBorderColor      := StringToColor( ReadString ( slooks, 'SelectorBorderColor'     , ColorToString( SelectorBorderColor    )));
          SelectorBorderColorS     := StringToColor( ReadString ( slooks, 'SelectorBorderColorS'    , ColorToString( SelectorBorderColorS   )));
          DisplayColor             := StringToColor( ReadString ( slooks, 'DisplayColor'            , ColorToString( DisplayColor           )));
          DisplayBorderColor       := StringToColor( ReadString ( slooks, 'DisplayBorderColor'      , ColorToString( DisplayBorderColor     )));
          KnobMIDIColor            := StringToColor( ReadString ( slooks, 'KnobMIDIColor'           , ColorToString( KnobMIDIColor          )));

          KnobFocusColor           := StringToColor( ReadString ( slooks, 'KnobFocusColor'          , ColorToString( KnobFocusColor         )));
          KnobMIDIFocusColor       := StringToColor( ReadString ( slooks, 'KnobMIDIFocusColor'      , ColorToString( KnobMIDIFocusColor     )));
          ViewerColor              := StringToColor( ReadString ( slooks, 'ViewerColor'             , ColorToString( ViewerColor            )));
          ViewerBorderColor        := StringToColor( ReadString ( slooks, 'ViewerBorderColor'       , ColorToString( ViewerBorderColor      )));
          ViewerLineColor          := StringToColor( ReadString ( slooks, 'ViewerLineColor'         , ColorToString( ViewerLineColor        )));
          ViewerFillColor          := StringToColor( ReadString ( slooks, 'ViewerFillColor'         , ColorToString( ViewerFillColor        )));
          IndBarPeakColor          := StringToColor( ReadString ( slooks, 'IndBarPeakColor'         , ColorToString( IndBarPeakColor        )));
          IndBarValeyColor         := StringToColor( ReadString ( slooks, 'IndBarValeyColor'        , ColorToString( IndBarValeyColor       )));
          GroupIOColor             := StringToColor( ReadString ( slooks, 'GroupIOColor'            , ColorToString( GroupIOColor           )));
          GroupOSCColor            := StringToColor( ReadString ( slooks, 'GroupOSCColor'           , ColorToString( GroupOSCColor          )));
          GroupLFOColor            := StringToColor( ReadString ( slooks, 'GroupLFOColor'           , ColorToString( GroupLFOColor          )));
          GroupEnvColor            := StringToColor( ReadString ( slooks, 'GroupEnvColor'           , ColorToString( GroupEnvColor          )));
          GroupFilterColor         := StringToColor( ReadString ( slooks, 'GroupFilterColor'        , ColorToString( GroupFilterColor       )));
          GroupSwitchColor         := StringToColor( ReadString ( slooks, 'GroupSwitchColor'        , ColorToString( GroupSwitchColor       )));
          GroupMixColor            := StringToColor( ReadString ( slooks, 'GroupMixColor'           , ColorToString( GroupMixColor          )));
          GroupControlColor        := StringToColor( ReadString ( slooks, 'GroupControlColor'       , ColorToString( GroupControlColor      )));
          GroupNoteColor           := StringToColor( ReadString ( slooks, 'GroupNoteColor'          , ColorToString( GroupNoteColor         )));
          GroupMathColor           := StringToColor( ReadString ( slooks, 'GroupMathColor'          , ColorToString( GroupMathColor         )));
          GroupLogicColor          := StringToColor( ReadString ( slooks, 'GroupLogicColor'         , ColorToString( GroupLogicColor        )));
          GroupSeqColor            := StringToColor( ReadString ( slooks, 'GroupSeqColor'           , ColorToString( GroupSeqColor          )));
          GroupGeneratorColor      := StringToColor( ReadString ( slooks, 'GroupGenratorColor'      , ColorToString( GroupGeneratorColor    )));
          GroupFXColor             := StringToColor( ReadString ( slooks, 'GroupFXColor'            , ColorToString( GroupFXColor           )));
          GroupDelayColor          := StringToColor( ReadString ( slooks, 'GroupDelayColor'         , ColorToString( GroupDelayColor        )));
          GroupVoiceColor          := StringToColor( ReadString ( slooks, 'GroupVoiceColor'         , ColorToString( GroupVoiceColor        )));
          GroupUtilityColor        := StringToColor( ReadString ( slooks, 'GroupUtilityColor'       , ColorToString( GroupUtilityColor      )));
          AudioRateColor           := StringToColor( ReadString ( slooks, 'AudioRateColor'          , ColorToString( AudioRateColor         )));

          ControlRateColor         := StringToColor( ReadString ( slooks, 'ControlRateColor'        , ColorToString( ControlRateColor       )));
          ControlRateLogicColor    := StringToColor( ReadString ( slooks, 'ControlRateLogicColor'   , ColorToString( ControlRateLogicColor  )));
          LogicColor               := StringToColor( ReadString ( slooks, 'LogicColor'              , ColorToString( LogicColor             )));
          UnconnectedWireColor     := StringToColor( ReadString ( slooks, 'UnconnectedWireColor'    , ColorToString( UnconnectedWireColor   )));
          WireHighlightColor       := StringToColor( ReadString ( slooks, 'WireHighlightColor'      , ColorToString( WireHighlightColor     )));
          EditorBackgroundColor    := StringToColor( ReadString ( slooks, 'EditorBackgroundColor'   , ColorToString( EditorBackgroundColor  )));
          StandardColors           :=                ReadBool   ( slooks, 'StandardColors'          ,                StandardColors           );
          ModuleOpacity            :=                ReadInteger( slooks, 'ModuleOpacity'           ,                ModuleOpacity            );
          ModuleFlatness           :=                ReadBool   ( slooks, 'ModuleFlatness'          ,                ModuleFlatness           );
          ModuleTexture            :=                ReadBool   ( slooks, 'ModuleTexture'           ,                ModuleTexture            );
          WireThickness            :=                ReadInteger( slooks, 'WireThickness'           ,                WireThickness            );
          CurvedLines              :=                ReadBool   ( slooks, 'CurvedLines'             ,                CurvedLines              );
          SynthNameInCaption       :=                ReadBool   ( slooks, 'SynthNameInCaption'      ,                SynthNameInCaption       );
          PatchChangedInCaption    :=                ReadBool   ( slooks, 'PatchChangedInCaption'   ,                PatchChangedInCaption    );
          ProfiledInCaption        :=                ReadBool   ( slooks, 'ProfiledInCaption'       ,                ProfiledInCaption        );
          AudioStatusInCaption     :=                ReadBool   ( slooks, 'AudioStatusInCaption'    ,                AudioStatusInCaption     );
          ProgramNameInCaption     :=                ReadBool   ( slooks, 'ProgramNameInCaption'    ,                ProgramNameInCaption     );
          FileVersionInCaption     :=                ReadBool   ( slooks, 'FileVersionInCaption'    ,                FileVersionInCaption     );

          PatchNameInCaption       :=                ReadBool   ( slooks, 'PatchNameInCaption'      ,                PatchNameInCaption       );
          SourceNameInCaption      :=                ReadBool   ( slooks, 'SourceNameInCaption'     ,                SourceNameInCaption      );
          GuidInCaption            :=                ReadBool   ( slooks, 'GuidInCaption'           ,                GuidInCaption            );
          ControlWidth             :=                ReadInteger( slooks, 'ControlWidth'            ,                ControlWidth             );
          FLastControlWidth        :=                ReadInteger( slooks, 'LastControlWidth'        ,                FLastControlWidth        );
          SelectorWidth            :=                ReadInteger( slooks, 'SelectorWidth'           ,                SelectorWidth            );
          FLastSelectorWidth       :=                ReadInteger( slooks, 'LastSelectorWidth'       ,                FLastSelectorWidth       );
          LRate                    :=                ReadInteger( slooks, 'LightsRate'              ,                LRate                    );
          ControlMode              := TDistanceMode( ReadInteger( slooks, 'ControlMode'             , Integer(       ControlMode            )));
          UseWheelOnKnobs          :=                ReadBool   ( slooks, 'UseWheelOnKnobs'         ,                UseWheelOnKnobs          );
          WheelSensitivity         :=                ReadInteger( slooks, 'WheelSensitivity'        ,                WheelSensitivity         );
          UseUnFocus               :=                ReadBool   ( slooks, 'UseUnFocus'              ,                UseUnFocus               );
          SearchPatch              :=                ReadBool   ( slooks, 'SearchPatch'             ,                SearchPatch              );
          SearchSelector           :=                ReadBool   ( slooks, 'SearchSelector'          ,                SearchSelector           );

          if   Assigned( TitleFont)
          then begin
            TitleFont.Name  :=                ReadString ( slooks, 'TitleFont.Name' ,                TitleFont.Name   );
            TitleFont.Size  :=                ReadInteger( slooks, 'TitleFont.Size' ,                TitleFont.Size   );
            TitleFont.Color := StringToColor( ReadString ( slooks, 'TitleFont.Color', ColorToString( TitleFont.Color)));
            TitleFont       := TitleFont;
          end;

          if   Assigned( ModuleFont)
          then begin
            ModuleFont.Name  :=                ReadString ( slooks, 'ModuleFont.Name' ,                ModuleFont.Name   );
            ModuleFont.Size  :=                ReadInteger( slooks, 'ModuleFont.Size' ,                ModuleFont.Size   );
            ModuleFont.Color := StringToColor( ReadString ( slooks, 'ModuleFont.Color', ColorToString( ModuleFont.Color)));
            ModuleFont       := ModuleFont;
          end;

          if   not LooksOnly
          then begin
            // General settings
            Log( LC_GENERAL, 'Loading general settings');

            FRecentSourceFiles.LoadFromIni( anIniFile, 'RecentFiles');
            HistoryCount := FRecentSourceFiles.MaxDepth;

            L                      :=                ReadInteger( sdfs, 'Left'                  ,          Left                );
            T                      :=                ReadInteger( sdfs, 'Top'                   ,          Top                 );
            W                      :=                ReadInteger( sdfs, 'Width'                 ,          Width               );
            H                      :=                ReadInteger( sdfs, 'Height'                ,          Height              );
            WinState               := TWindowState ( ReadInteger( sdfs, 'WindowState'           , Integer( WindowState       )));
            LogToFile              :=                ReadBool   ( sdfs, 'LogToFile'             ,          LogToFile            );
            SynthName              :=                ReadString ( sdfs, 'SynthName'             ,          SynthName            );
            ReloadLastPatch        :=                ReadBool   ( sdfs, 'ReloadLastPatch'       ,          ReloadLastPatch      );
            FDoAutoRun             :=                ReadBool   ( sdfs, 'AutoRun'               ,          AutoRun              );
            ClearVUOnStop          :=                ReadBool   ( sdfs, 'ClearVUOnStop'         ,          ClearVUOnStop        );
            ClearVUOnRecompile     :=                ReadBool   ( sdfs, 'ClearVUOnRecompile'    ,          ClearVUOnRecompile   );
            FRenderFileName        :=                ReadString ( sdfs, 'RenderFileName'        ,          FRenderFileName      );
            FRenderDuration        :=                ReadString ( sdfs, 'RenderDuration'        ,          FRenderDuration      );
            SourceFileName         :=                ReadString ( sdfs, 'SourceFileName'        ,          SourceFileName       );
            AbsTimeStamps          :=                ReadBool   ( sdfs, 'AbsTimeStamps'         ,          AbsTimeStamps        );

            UseGraphs              :=                ReadBool   ( sdfs, 'UseGraphs'             ,          UseGraphs            );
            GraphStairs            :=                ReadBool   ( sdfs, 'GraphStairs'           ,          GraphStairs          );
            InVolume1              :=                ReadInteger( sdfs, 'InVolume1'             ,          InVolume1            );
            InVolume2              :=                ReadInteger( sdfs, 'InVolume2'             ,          InVolume2            );
            InVolume3              :=                ReadInteger( sdfs, 'InVolume3'             ,          InVolume3            );
            InVolume4              :=                ReadInteger( sdfs, 'InVolume4'             ,          InVolume4            );
            OutVolume1             :=                ReadInteger( sdfs, 'OutVolume1'            ,          OutVolume1           );
            OutVolume2             :=                ReadInteger( sdfs, 'OutVolume2'            ,          OutVolume2           );
            OutVolume3             :=                ReadInteger( sdfs, 'OutVolume3'            ,          OutVolume3           );
            OutVolume4             :=                ReadInteger( sdfs, 'OutVolume4'            ,          OutVolume4           );
            UseConfigHints         :=                ReadBool   ( sdfs, 'UseConfigHints'        ,          UseConfigHints       );
            UseModuleTitleHints    :=                ReadBool   ( sdfs, 'UseModuleTitleHints'   ,          UseModuleTitleHints  );
            SampleRate             :=                ReadInteger( sdfs, 'SampleRate'            ,          Samplerate           );
            ControlDecimation      :=                ReadInteger( sdfs, 'ControlDecimation'     ,          ControlDecimation    );
            WaveDebug              :=                ReadBool   ( sdfs, 'WaveDebug'             ,          WaveDebug            );
            BufferSize             :=                ReadInteger( sdfs, 'BufferSize'            ,          BufferSize           );
            ReferenceA             :=                ReadFloat  ( sdfs, 'ReferenceA'            ,          ReferenceA           );
            NotesPerOctave         :=                ReadFloat  ( sdfs, 'NotesPerOctave'        ,          NotesPerOctave       );
            MiddleNote             :=                ReadFloat  ( sdfs, 'MiddleNote'            ,          MiddleNote           );
            OctaveSpan             :=                ReadFloat  ( sdfs, 'OctaveSpan'            ,          OctaveSpan           );
            FSelectedAPIID         :=                ReadInteger( sdfs, 'SelectedAPIID'         ,          FSelectedAPIID       );
            FSelectedInputIdPA     := DWORD(         ReadInteger( sDfs, 'SelectedInputPA'       , Integer( FSelectedInputIdPA )));

            FSelectedOutputIdPA    := DWORD(         ReadInteger( sDfs, 'SelectedOutputPA'      , Integer( FSelectedOutputIdPA)));
            NetMidiServer          :=                ReadString ( sdfs, 'NetMidiServer'         ,          NetMidiServer        );
            NetMidiPort            :=                ReadString ( sdfs, 'NetMidiPort'           ,          NetMidiPort          );
            NetMidiAutoConnect     :=                ReadBool   ( sdfs, 'NetMidiAutoConnect'    ,          NetMidiAutoConnect   );
            LogMidi                :=                ReadBool   ( sdfs, 'LogMidi'               ,          LogMidi              );
            LogMidiMsgs            :=                ReadBool   ( sdfs, 'LogMidiMsgs'           ,          LogMidiMsgs          );
            MidiChannel            :=                ReadInteger( sdfs, 'MidiChannel'           ,          MidiChannel          );
            MidiRpnMode            := TRpnMode(      ReadInteger( sdfs, 'MidiRpnMode'           , Integer( MidiRpnMode        )));
            LogOSC                 :=                ReadBool   ( sdfs, 'LogOSC'                ,          LogOSC               );
            LogOSCMsgs             :=                ReadBool   ( sdfs, 'LogOSCMsgs'            ,          LogOSCMsgs           );
            OSCServer              :=                ReadString ( sdfs, 'OSCServer'             ,          OSCServer            );
            OSCPort                :=                ReadString ( sdfs, 'OSCPort'               ,          OSCPort              );
            UseOSC                 :=                ReadBool   ( sdfs, 'UseOSC'                ,          UseOSC               );
            CompilerDebug          :=                ReadBool   ( sdfs, 'CompilerDebug'         ,          CompilerDebug        );
            WarnOnPatchChange      :=                ReadBool   ( sdfs, 'WarnOnPatchChange'     ,          WarnOnPatchChange    );
            WarnChangeOnLoad       :=                ReadBool   ( sdfs, 'WarnChangeOnLoad'      ,          WarnChangeOnLoad     );
            UndoAfterSave          :=                ReadBool   ( sdfs, 'UndoAfterSave'         ,          UndoAfterSave        );
            UndoAfterLoad          :=                ReadBool   ( sdfs, 'UndoAfterLoad'         ,          UndoAfterLoad        );
            WarnOnStructMismatch   :=                ReadBool   ( sdfs, 'WarnOnStructMismatch'  ,          WarnOnStructMismatch );
            DisableAutoDocs        :=                ReadBool   ( sdfs, 'DisableAutoDocs'       ,          DisableAutoDocs      );
            AllowAutoLoad          :=                ReadBool   ( sdfs, 'AllowAutoLoad'         ,          AllowAutoLoad        );
            NoLoadTuning           :=                ReadBool   ( sdfs, 'NoLoadTuning'          ,          NoLoadTuning         );
            NewPatchNameTemplate   :=                ReadString ( sdfs, 'NewPatchNameTemplate'  ,          NewPatchNameTemplate );
            TextWriterPrefix       := UnQuote(       ReadString ( sdfs, 'TextWriterPrefix'      ,          TextWriterPrefix     ), '''', '''');

            ResetOnRender          :=                ReadBool   ( sdfs, 'ResetOnRender'         ,          ResetOnRender        );
            PatchFolder            :=                ReadString ( sdfs, 'PatchFolder'           ,          PatchFolder          );
            TemplateFolder         :=                ReadString ( sdfs, 'TemplateFolder'        ,          TemplateFolder       );
            ImportFolder           :=                ReadString ( sdfs, 'ImportFolder'          ,          ImportFolder         );
            GraphsFolder           :=                ReadString ( sdfs, 'GraphsFolder'          ,          GraphsFolder         );
            GridControlFolder      :=                ReadString ( sdfs, 'GridControlFolder'     ,          GridControlFolder    );
            ShowTopPane            :=                ReadBool   ( sdfs, 'ShowTopPane'           ,          ShowTopPane          );
            FLooksFolder           :=                ReadString ( sdfs, 'LooksFolder'           ,          FLooksFolder         );

            if   AllowAutoLoad
            then begin
              AllowLiveMorphMod := ReadBool( sdfs, 'AllowLiveMorphMod', AllowLiveMorphMod);
              AllowMorphMod     := ReadBool( sdfs, 'AllowMorphMod'    , AllowMorphMod     );
            end;

            SyncLookAndFeelPresets;
            NetMidiCancel;
            OSCApply;

            if ( L < 0) or ( L > Screen.Width  - 20) then L := 0;
            if ( T < 0) or ( T > Screen.Height - 20) then T := 0;
            if W > Screen.Width                      then W := Screen.Width  - 20;
            if H > Screen.Height                     then H := Screen.Height - 20;

            SetBounds( L, T, W, H);

            if   WinState = wsMaximized
            then WindowState := wsMaximized;

            PanelControl.Width := ControlWidth;
            FixControlFoldButton;
            ModuleSelector.Width := SelectorWidth;
            FixSelectorFoldButton;
            KnobsConversions.DefaultReferenceA     := ReferenceA    ;
            KnobsConversions.DefaultNotesPerOctave := NotesPerOctave;
            KnobsConversions.DefaultMiddleNote     := MiddleNote    ;
            KnobsConversions.DefaultOctaveSpan     := OctaveSpan    ;
            ApplyTuning;
            VerifyDevices;

            with FormWaveDeviceSelect
            do begin
              aCount := ReadInteger( sdfs, 'InMaskCount', 0);

              for i := 0 to aCount - 1
              do begin
                InMasks      [ i] := ReadInteger( sdfs, Format( 'InMask%d', [ i], AppLocale), i);
                Self.FInMasks[ i] := InMasks[ i];
              end;

              aCount := ReadInteger( sdfs, 'OutMaskCount', 0);

              for i := 0 to aCount - 1
              do begin
                OutMasks      [ i] := ReadInteger( sdfs, Format( 'OutMask%d', [ i], AppLocale), i);
                Self.FOutMasks[ i] := OutMasks[ i];
              end;
            end;

            VerifyDevices;

            if   Assigned( FormRandomizer)
            then FormRandomizer.LoadSettings( anInifile, 'Randomizer');

            UpdateCaptions;
            KnobsSmallKnob_LightsRate.KnobPosition := LRate;
            LightsRate := KnobsSmallKnob_LightsRate.AsValue;
            FixTabColors;

            if   UseThemes
            then ComboBoxThemes.ItemIndex := ComboBoxThemes.Items.IndexOf( UserTheme)
            else begin
              ComboBoxThemes.Visible := False;
              LabelThemes   .Visible := False;
            end;

            if   Assigned( FormLastEdits)
            then FormLastEdits.LoadIni( 'FormLastEdits', anIniFile);

            FIniLoaded := True;
          end;
        finally
          DisposeOf;
        end;
      end;
    end;


    procedure   TFormWren.SaveIni( const aFileName: string; LooksOnly: Boolean);
    var
      anIniFile     : TMemIniFile;
      LRate         : Integer;
      ControlWidth  : Integer;
      SelectorWidth : Integer;
      aCount        : Integer;
      i             : Integer;
    begin
      LogFmt( LC_GENERAL, 'TFormWren.SaveIni( ''%s'', LooksOnly = %s)', [ aFileName, BoolToStr( LooksOnly, True)]);
   // CancelTuning;  // todo: why was there a CancelTuning here ???
      anIniFile     := TMemIniFile.Create( aFileName);
      LRate         := KnobsSmallKnob_LightsRate.KnobPosition;
      ControlWidth  := PanelControl.Width;
      SelectorWidth := ModuleSelector.Width;

      with anIniFile
      do begin
        Log( LC_GENERAL, 'Saving looks');

        try
          // User interface stuff
          EraseSection( slooks);
          WriteString ( slooks, 'Theme'                   ,                Theme                   );
          WriteBool   ( slooks, 'UseThemes'               ,                UseThemes               );
          WriteBool   ( slooks, 'UseConnectorBorders'     ,                UseConnectorBorders     );
          WriteBool   ( slooks, 'UseTypedConnectorBorders',                UseTypedConnectorBorders);
          WriteBool   ( slooks, 'UseNoteNames'            ,                UseNoteNames            );
          WriteInteger( slooks, 'OffsetLeft'              ,                OffsetLeft              );
          WriteInteger( slooks, 'OffsetTop'               ,                OffsetTop               );
          WriteString ( slooks, 'ModuleColor'             , ColorToString( ModuleColor            ));
          WriteString ( slooks, 'SelectorColor'           , ColorToString( SelectorColor          ));
          WriteString ( slooks, 'SelectorBorderColor'     , ColorToString( SelectorBorderColor    ));
          WriteString ( slooks, 'SelectorBorderColorS'    , ColorToString( SelectorBorderColorS   ));
          WriteString ( slooks, 'DisplayColor'            , ColorToString( DisplayColor           ));
          WriteString ( slooks, 'DisplayBorderColor'      , ColorToString( DisplayBorderColor     ));
          WriteString ( slooks, 'KnobMIDIColor'           , ColorToString( KnobMIDIColor          ));
          WriteString ( slooks, 'KnobFocusColor'          , ColorToString( KnobFocusColor         ));
          WriteString ( slooks, 'KnobMIDIFocusColor'      , ColorToString( KnobMIDIFocusColor     ));
          WriteString ( slooks, 'ViewerColor'             , ColorToString( ViewerColor            ));
          WriteString ( slooks, 'ViewerBorderColor'       , ColorToString( ViewerBorderColor      ));
          WriteString ( slooks, 'ViewerLineColor'         , ColorToString( ViewerLineColor        ));
          WriteString ( slooks, 'ViewerFillColor'         , ColorToString( ViewerFillColor        ));
          WriteString ( slooks, 'IndBarPeakColor'         , ColorToString( IndBarPeakColor        ));
          WriteString ( slooks, 'IndBarValeyColor'        , ColorToString( IndBarValeyColor       ));
          WriteString ( slooks, 'GroupIOColor'            , ColorToString( GroupIOColor           ));
          WriteString ( slooks, 'GroupOSCColor'           , ColorToString( GroupOSCColor          ));
          WriteString ( slooks, 'GroupLFOColor'           , ColorToString( GroupLFOColor          ));
          WriteString ( slooks, 'GroupEnvColor'           , ColorToString( GroupEnvColor          ));
          WriteString ( slooks, 'GroupFilterColor'        , ColorToString( GroupFilterColor       ));
          WriteString ( slooks, 'GroupSwitchColor'        , ColorToString( GroupSwitchColor       ));
          WriteString ( slooks, 'GroupMixColor'           , ColorToString( GroupMixColor          ));
          WriteString ( slooks, 'GroupControlColor'       , ColorToString( GroupControlColor      ));
          WriteString ( slooks, 'GroupNoteColor'          , ColorToString( GroupNoteColor         ));
          WriteString ( slooks, 'GroupMathColor'          , ColorToString( GroupMathColor         ));
          WriteString ( slooks, 'GroupLogicColor'         , ColorToString( GroupLogicColor        ));
          WriteString ( slooks, 'GroupSeqColor'           , ColorToString( GroupSeqColor          ));
          WriteString ( slooks, 'GroupGeneratorColor'     , ColorToString( GroupGeneratorColor    ));
          WriteString ( slooks, 'GroupFXColor'            , ColorToString( GroupFXColor           ));
          WriteString ( slooks, 'GroupDelayColor'         , ColorToString( GroupDelayColor        ));
          WriteString ( slooks, 'GroupVoiceColor'         , ColorToString( GroupVoiceColor        ));
          WriteString ( slooks, 'GroupUtilityColor'       , ColorToString( GroupUtilityColor      ));
          WriteString ( slooks, 'AudioRateColor'          , ColorToString( AudioRateColor         ));
          WriteString ( slooks, 'ControlRateColor'        , ColorToString( ControlRateColor       ));
          WriteString ( slooks, 'ControlRateLogicColor'   , ColorToString( ControlRateLogicColor  ));
          WriteString ( slooks, 'LogicColor'              , ColorToString( LogicColor             ));
          WriteString ( slooks, 'UnconnectedWireColor'    , ColorToString( UnconnectedWireColor   ));
          WriteString ( slooks, 'WireHighlightColor'      , ColorToString( WireHighlightColor     ));
          WriteString ( slooks, 'EditorBackgroundColor'   , ColorToString( EditorBackgroundColor  ));
          WriteBool   ( slooks, 'StandardColors'          ,                StandardColors          );
          WriteInteger( slooks, 'ModuleOpacity'           ,                ModuleOpacity           );
          WriteBool   ( slooks, 'ModuleFlatness'          ,                ModuleFlatness          );
          WriteBool   ( slooks, 'ModuleTexture'           ,                ModuleTexture           );
          WriteInteger( slooks, 'WireThickness'           ,                WireThickness           );
          WriteBool   ( slooks, 'CurvedLines'             ,                CurvedLines             );
          WriteBool   ( slooks, 'SynthNameInCaption'      ,                SynthNameInCaption      );
          WriteBool   ( slooks, 'PatchChangedInCaption'   ,                PatchChangedInCaption   );
          WriteBool   ( slooks, 'ProfiledInCaption'       ,                ProfiledInCaption       );
          WriteBool   ( slooks, 'AudioStatusInCaption'    ,                AudioStatusInCaption    );
          WriteBool   ( slooks, 'ProgramNameInCaption'    ,                ProgramNameInCaption    );
          WriteBool   ( slooks, 'FileVersionInCaption'    ,                FileVersionInCaption    );
          WriteBool   ( slooks, 'PatchNameInCaption'      ,                PatchNameInCaption      );
          WriteBool   ( slooks, 'SourceNameInCaption'     ,                SourceNameInCaption     );
          WriteBool   ( slooks, 'GuidInCaption'           ,                GuidInCaption           );
          WriteInteger( slooks, 'ControlWidth'            ,                ControlWidth            );
          WriteInteger( slooks, 'LastControlWidth'        ,                FLastControlWidth       );
          WriteInteger( slooks, 'SelectorWidth'           ,                SelectorWidth           );
          WriteInteger( slooks, 'LastSelectorWidth'       ,                FLastSelectorWidth      );
          WriteInteger( slooks, 'LightsRate'              ,                LRate                   );
          WriteInteger( slooks, 'ControlMode'             , Integer(       ControlMode            ));
          WriteBool   ( slooks, 'UseWheelOnKnobs'         ,                UseWheelOnKnobs         );
          WriteInteger( slooks, 'WheelSensitivity'        ,                WheelSensitivity        );
          WriteBool   ( slooks, 'UseUnFocus'              ,                UseUnFocus              );
          WriteBool   ( slooks, 'SearchPatch'             ,                SearchPatch             );
          WriteBool   ( slooks, 'SearchSelector'          ,                SearchSelector          );

          if   Assigned( TitleFont)
          then begin
            WriteString ( slooks, 'TitleFont.Name' ,                TitleFont.Name  );
            WriteInteger( slooks, 'TitleFont.Size' ,                TitleFont.Size  );
            WriteString ( slooks, 'TitleFont.Color', ColorToString( TitleFont.Color));
          end;

          if   Assigned( ModuleFont)
          then begin
            WriteString ( slooks, 'ModuleFont.Name' ,                ModuleFont.Name  );
            WriteInteger( slooks, 'ModuleFont.Size' ,                ModuleFont.Size  );
            WriteString ( slooks, 'ModuleFont.Color', ColorToString( ModuleFont.Color));
          end;

          if   not LooksOnly
          then begin
            Log( LC_GENERAL, 'Saving general settings');
            // General settings
            EraseSection( sdfs);
            WriteInteger( sdfs, 'Left'                  ,          Left                 );
            WriteInteger( sdfs, 'Top'                   ,          Top                  );
            WriteInteger( sdfs, 'Width'                 ,          Width                );
            WriteInteger( sdfs, 'Height'                ,          Height               );
            WriteInteger( sdfs, 'WindowState'           , Integer( WindowState          ));
            WriteBool   ( sdfs, 'LogToFile'             ,          LogToFile            );
            WriteString ( sdfs, 'SynthName'             ,          SynthName            );
            WriteBool   ( sdfs, 'ReloadLastPatch'       ,          ReloadLastPatch      );
            WriteBool   ( sdfs, 'AutoRun'               ,          AutoRun              );
            WriteBool   ( sdfs, 'ClearVUOnStop'         ,          ClearVUOnStop        );
            WriteBool   ( sdfs, 'ClearVUOnRecompile'    ,          ClearVUOnRecompile   );
            WriteBool   ( sdfs, 'RenderToFile'          ,          RenderToFile         );
            WriteString ( sdfs, 'RenderFileName'        ,          FRenderFileName      );
            WriteString ( sdfs, 'RenderDuration'        ,          FRenderDuration      );
            WriteString ( sdfs, 'SourceFileName'        ,          SourceFileName       );
            WriteBool   ( sdfs, 'AbsTimeStamps'         ,          AbsTimeStamps        );
            WriteBool   ( sdfs, 'UseGraphs'             ,          UseGraphs            );
            WriteBool   ( sdfs, 'GraphStairs'           ,          GraphStairs          );
            WriteFloat  ( sdfs, 'InVolume1'             ,          InVolume1            );
            WriteFloat  ( sdfs, 'InVolume2'             ,          InVolume2            );
            WriteFloat  ( sdfs, 'InVolume3'             ,          InVolume3            );
            WriteFloat  ( sdfs, 'InVolume4'             ,          InVolume4            );
            WriteFloat  ( sdfs, 'OutVolume1'            ,          OutVolume1           );
            WriteFloat  ( sdfs, 'OutVolume2'            ,          OutVolume2           );
            WriteFloat  ( sdfs, 'OutVolume3'            ,          OutVolume3           );
            WriteFloat  ( sdfs, 'OutVolume4'            ,          OutVolume4           );
            WriteBool   ( sdfs, 'UseConfigHints'        ,          UseConfigHints       );
            WriteBool   ( sdfs, 'UseModuleTitleHints'   ,          UseModuleTitleHints  );
            WriteInteger( sdfs, 'SampleRate'            ,          Samplerate           );
            WriteInteger( sdfs, 'ControlDecimation'     ,          ControlDecimation    );
            WriteBool   ( sdfs, 'WaveDebug'             ,          WaveDebug            );
            WriteInteger( sdfs, 'BufferSize'            ,          BufferSize           );

            if NoLoadTuning // Not loading tuning from patches, old time behaviour, save tuning stuff in ini file
            then begin
              WriteFloat  ( sdfs, 'ReferenceA'            ,          ReferenceA           );
              WriteFloat  ( sdfs, 'NotesPerOctave'        ,          NotesPerOctave       );
              WriteFloat  ( sdfs, 'MiddleNote'            ,          MiddleNote           );
              WriteFloat  ( sdfs, 'OctaveSpan'            ,          OctaveSpan           );
            end;

            WriteInteger( sdfs, 'SelectedAPIID'         ,          FSelectedAPIID       );
            WriteInteger( sDfs, 'SelectedInputPA'       , Integer( FSelectedInputIdPA  ));
            WriteInteger( sDfs, 'SelectedOutputPA'      , Integer( FSelectedOutputIdPA ));
            WriteString ( sdfs, 'NetMidiServer'         ,          NetMidiServer        );
            WriteString ( sdfs, 'NetMidiPort'           ,          NetMidiPort          );
            WriteBool   ( sdfs, 'NetMidiAutoConnect'    ,          NetMidiAutoConnect   );
            WriteBool   ( sdfs, 'LogMidi'               ,          LogMidi              );
            WriteBool   ( sdfs, 'LogMidiMsgs'           ,          LogMidiMsgs          );
            WriteInteger( sdfs, 'MidiChannel'           ,          MidiChannel          );
            WriteInteger( sdfs, 'MidiRpnMode'           , Integer( MidiRpnMode         ));
            WriteBool   ( sdfs, 'LogOSC'                ,          LogOSC               );
            WriteBool   ( sdfs, 'LogOSCMsgs'            ,          LogOSCMsgs           );
            WriteString ( sdfs, 'OSCServer'             ,          OSCServer            );
            WriteString ( sdfs, 'OSCPort'               ,          OSCPort              );
            WriteBool   ( sdfs, 'UseOSC'                ,          UseOSC               );
            WriteBool   ( sdfs, 'CompilerDebug'         ,          CompilerDebug        );
            WriteBool   ( sdfs, 'WarnOnPatchChange'     ,          WarnOnPatchChange    );
            WriteBool   ( sdfs, 'WarnChangeOnLoad'      ,          WarnChangeOnLoad     );
            WriteBool   ( sdfs, 'UndoAfterSave'         ,          UndoAfterSave        );
            WriteBool   ( sdfs, 'UndoAfterLoad'         ,          UndoAfterLoad        );
            WriteBool   ( sdfs, 'WarnOnStructMismatch'  ,          WarnOnStructMismatch );
            WriteBool   ( sdfs, 'DisableAutoDocs'       ,          DisableAutoDocs      );
            WriteBool   ( sdfs, 'AllowLiveMorphMod'     ,          AllowLiveMorphMod    );
            WriteBool   ( sdfs, 'AllowMorphMod'         ,          AllowMorphMod        );
            WriteBool   ( sdfs, 'AllowAutoLoad'         ,          AllowAutoLoad        );
            WriteBool   ( sdfs, 'NoLoadTuning'          ,          NoLoadTuning         );
            WriteString ( sdfs, 'NewPatchNameTemplate'  ,          NewPatchNameTemplate );
            WriteString ( sdfs, 'TextWriterPrefix'      , Quote(   TextWriterPrefix     , '''', ''''));
            WriteBool   ( sdfs, 'ResetOnRender'         ,          ResetOnRender        );
            WriteString ( sdfs, 'PatchFolder'           ,          PatchFolder          );
            WriteString ( sdfs, 'TemplateFolder'        ,          TemplateFolder       );
            WriteString ( sdfs, 'ImportFolder'          ,          ImportFolder         );
            WriteString ( sdfs, 'GraphsFolder'          ,          GraphsFolder         );
            WriteString ( sdfs, 'GridControlFolder'     ,          GridControlFolder    );
            WriteBool   ( sdfs, 'ShowTopPane'           ,          ShowTopPane          );
            WriteString ( sdfs, 'LooksFolder'           ,          FLooksFolder         );

            with FormWaveDeviceSelect
            do begin
              aCount := InMaskCount;
              WriteInteger( sdfs, 'InMaskCount', aCount);

              for i := 0 to aCount - 1
              do  WriteInteger( sdfs, Format( 'InMask%d', [ i], AppLocale), InMasks[ i]);

              aCount := OutMaskCount;
              WriteInteger( sdfs, 'OutMaskCount', aCount);

              for i := 0 to aCount - 1
              do  WriteInteger( sdfs, Format( 'OutMask%d', [ i], AppLocale), OutMasks[ i]);
            end;

            FRecentSourceFiles.SaveToIni( anIniFile, 'RecentFiles');

            if   Assigned( FormRandomizer)
            then FormRandomizer.SaveSettings( anInifile, 'Randomizer');

            if   Assigned( FormLastEdits)
            then FormLastEdits.SaveIni( 'FormLastEdits', anIniFile);
          end;
        finally
          UpdateFile;
          DisposeOf;
        end;
      end;
    end;


    procedure   TFormWren.ShowHelp;
    var
      aHelpIndex : string;
      aModule    : TKnobsCustomModule;
      anURL      : string;
    begin
      aHelpIndex := '';

      if   Assigned( PatchEditor)
      then begin
        aModule := PatchEditor.FindFirstSelectedModule;

        if   Assigned( aModule)
        then aHelpIndex := Format( '#%d', [ aModule.ModuleType], AppLocale);
      end;

      if   MustMakeDocs
      then MakeDocs( DocsPath);

      if   FileExists( DocsPath + '\modules.html')
      then begin
        anURL := Format( '"file:///%s/modules.html%s"', [ DocsPath, aHelpIndex], AppLocale);
        anURL := StringReplace( anURL, '\', '/', [ rfReplaceAll]);

        if   not BrowseURL( anURL)
        then MessageDlg( Format( 'Could not open the docs [%s] in the default web browser ...', [ anURL], AppLocale), mtError, [ mbOK], 0);
      end
      else MessageDlg( Format( 'Could not create docs in [%s]', [ DocsPath], AppLocale), mtError, [ mbOK], 0);
    end;


    function    TFormWren.FixHtmlTokens( const S: string): string;
    begin
      Result := ReplaceText( S     , '&quot;'  , '"' );
      Result := ReplaceText( Result, '&apos;'  , '''');
      Result := ReplaceText( Result, '&gt;'    , '>' );
      Result := ReplaceText( Result, '&lt;'    , '<' );
      Result := ReplaceText( Result, '&amp;'   , '&' );

      Result := ReplaceText( Result, '<b>'     , ''  );
      Result := ReplaceText( Result, '<table>' , ''  );
      Result := ReplaceText( Result, '<tbody>' , ''  );
      Result := ReplaceText( Result, '<tr>'    , ''  );
      Result := ReplaceText( Result, '<td>'    , ''  );

      Result := ReplaceText( Result, '</b>'    , ''  );
      Result := ReplaceText( Result, '</table>', ''  );
      Result := ReplaceText( Result, '</tbody>', ''  );
      Result := ReplaceText( Result, '</tr>'   , ''  );
      Result := ReplaceText( Result, '</td>'   , ''  );

      Result := ReplaceText( Result, '<br>'    , ''  );
    end;


    procedure   TFormWren.ShowModuleHelp( aModule: TKnobsCustomModule);
    var
      S : PChar;
    begin                                                       // GetText uses StrNew ...
      S := aModule.Docs.GetText;                                // ... so we need use StrDispose to free it -
      ShowMessage( FixHtmlTokens( aModule.Title + ^M^M + S));   // this is what the help on GetText sez too, right.
      StrDispose( S);                                           // ok.
    end;


    function    TFormWren.MustMakeDocs: Boolean;
    begin
      if   DisableAutoDocs
      then Result := False
      else if not FileExists( DocsPath + '\modules.html')
      then Result := True
      else begin
        if   System.SysUtils.DirectoryExists( DocsPath + '\images')
        then begin
          if   FileExists( Format( '%s\images\%s', [ DocsPath, GetFileVersion], AppLocale))
          then Result := False
          else Result := True;
        end
        else Result := True;
      end;
    end;


    procedure   TFormWren.MakeDocs( const aFolder : string);
    const
      Images = '\images';
    var
      aFileNames   : TStrings;
      aFileName    : string;
      aFile        : TextFile;
      aFileVersion : string;
      aVersion     : string;
      anOldCap     : string;
    begin
      aFileVersion := GetFileVersion;

      if   not System.SysUtils.DirectoryExists ( aFolder)
      then System.SysUtils.ForceDirectories( aFolder);

      if   not System.SysUtils.DirectoryExists ( aFolder + Images)
      then System.SysUtils.ForceDirectories( aFolder + Images);

      aFileNames := CreateFileNames( aFolder + Images, '*.*', faAnyFile - faDirectory, False);

      if   Assigned( aFileNames)
      then begin
        try
          for aFileName in aFileNames
          do DeleteFile( aFileName);
        finally
          aFileNames.DisposeOf;
        end;
      end;

      anOldCap := FormStore.Caption;
      FormStore.Caption := 'generating module help ...';
      FormStore.Show; // must be made visible, or not everything will be rendered ...

      try
        FormStore.Document(
          aFolder, Images,
          aFileVersion
        );
      finally
        FormStore.Caption := anOldCap;
        FormStore.Hide;
      end;

      aVersion := Format( '%s\%s\%s', [ aFolder, Images, aFileVersion], AppLocale);
      AssignFile( aFile, aVersion);
      Rewrite( aFile);

      try
        WriteLn( aFile, 'this file is for WREN documentation version checking');
        WriteLn( aFile, aVersion);
        WriteLn( aFile, 'when the path above is not my actual position and name, just delete me please.');
      finally
        CloseFile( aFile);
      end;
    end;


    procedure   TFormWren.PopulateThemes;
    var
      S : string;
    begin
      ComboBoxThemes.Items.BeginUpdate;

      try
        ComboBoxThemes.Items.Clear;

        for S in TStyleManager.StyleNames
        do ComboBoxThemes.Items.Add( S);

        ComboBoxThemes.Sorted := True;
        // Select the style that's currently in use in the combobox
        ComboBoxThemes.ItemIndex := ComboBoxThemes.Items.IndexOf( TStyleManager.ActiveStyle.Name);
      finally
        ComboBoxThemes.Items.EndUpdate;
      end;
    end;


    procedure   TFormWren.ShowAcknowledgements;
    const
      URL = BaseURL + 'index.php#acknowledgements';
    begin
      ShellExecute(
        Handle,
        Nil,
        PChar( URL),
        Nil,
        Nil,
        SW_SHOWNORMAL
      );
    end;


    procedure   TFormWren.CheckForUpdates;
    const
      URL = BaseURL + 'index.php';
    begin
      ShellExecute(
        Handle,
        Nil,
        PChar( Format( '%s?user_version=%s', [ URL, GetFileVersion], AppLocale)),
        Nil,
        Nil,
        SW_SHOWNORMAL
      );
    end;


//  private

    function    TFormWren.LogTimeStamp: string;
    begin
      if   AbsTimeStamps
      then Result := RtcTimeStamp        // Current PC time
      else Result := GetDebugTimeStr;    // Time since program start
    end;


    function    TFormWren.RtcTimeStamp: string;
    begin
      Result := FormatDateTime( 'yyyy-mm-dd hh:nn:ss:zzz', Now, AppLocale)  // Current PC time
    end;


    procedure   TFormWren.WriteFileLog( const aMsg: string);
    var
      aFile : TextFile;
    begin
      try
        AssignFile( aFile, LogFileName);

        if   FileExists( LogFileName)
        then Append ( aFile)
        else Rewrite( aFile);
        try
          WriteLn( aFile, aMsg);
        finally
          CloseFile( aFile);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.Log( aLogClass: TLogClass; const aMsg: string; TimeStamped: Boolean = True); // overloadl
    var
      S : string;
    begin
      if   aLogClass = LC_NO_CLASS
      then begin
        if   TimeStamped
        then S := Format( '%s %s', [ LogTimeStamp, aMsg], AppLocale)
        else S := aMsg
      end
      else begin
        if   TimeStamped
        then S := Format( '%s [%s] %s', [ LogTimeStamp, LogClassToStr( aLogClass), aMsg], AppLocale)
        else S := Format( '[%s] %s'   , [               LogClassToStr( aLogClass), aMsg], AppLocale);
      end;

      if   LogToFile
      then WriteFileLog( S);

      if   CanLog                                                      // We can not log before the form is constructed
      then MemoDebug.Lines.Add( S)
      else begin
        if   not Assigned( FSavedLogs)                                 // When we can not log logs are stored on a string
        then FSavedLogs := TStringList.Create;                         // list to be logged later on.

        FSavedLogs.Add( S);
      end;
    end;


    procedure   TFormWren.Log( aLogClass: TLogClass; const aMsgs: TStrings; DoClear: Boolean); // overload;
    var
      S : string;
    begin
      if   Assigned( aMsgs)
      then begin
        for S in aMsgs
        do  Log( LC_NO_CLASS, S, False);                                 // No TimeStamps, no class indication - those were added before.

        if   DoClear
        then aMsgs.Clear;
      end;
    end;


    procedure   TFormWren.LogFmt( aLogClass: TLogClass; const aFmt: string; const anArgs: array of const);
    begin
      Log( aLogClass, Format( aFmt, anArgs, AppLocale));
    end;


    procedure   TFormWren.MidiLog( const aMsg: string);
    begin
      if   LogMidi
      then LogFmt( LC_MIDI, 'NET MIDI %s', [ aMsg]);
    end;


    procedure   TFormWren.MidiLogFmt( const aFmt: string; const anArgs: array of const);
    begin
      MidiLog( Format( aFmt, anArgs, AppLocale));
    end;


    procedure   TFormWren.MidiMsgLog( const aMsg: string);
    begin
      if   LogMidiMsgs
      then LogFmt( LC_MIDI_MSG, 'NET MIDI msg %s', [ aMsg]);
    end;


    procedure   TFormWren.MidiMsgLogFmt( const aFmt: string; const anArgs: array of const);
    begin
      MidiMsgLog( Format( aFmt, anArgs, AppLocale));
    end;


    procedure   TFormWren.OSCLog( const aMsg: string);
    begin
      if   LogOSC
      then LogFmt( LC_OSC, 'OSC %s', [ aMsg]);
    end;


    procedure   TFormWren.OSCLogFmt( const aFmt: string; const anArgs: array of const);
    begin
      OSCLog( Format( aFmt, anArgs, AppLocale));
    end;


    procedure   TFormWren.OSCMsgLog( const aMsg: string);
    begin
      if   LogOSCMsgs
      then LogFmt( LC_OSC_MSG, 'OSC msg %s', [ aMsg]);
    end;


    procedure   TFormWren.OSCMsgLogFmt( const aFmt: string; const anArgs: array of const);
    begin
      OSCMsgLog( Format( aFmt, anArgs, AppLocale));
    end;


    procedure   TFormWren.LogRandomizer( const aSender: TObject; const aMsg: string);
    begin
      Log( LC_RANDOMIZER, aMsg);
    end;


    procedure   TFormWren.LogVariations( const aSender: TObject; const aMsg: string);
    begin
      Log( LC_RANDOMIZER, aMsg);
    end;


    procedure   TFormWren.ViewEditor;
    begin
      PageControlMain.ActivePage := TabSheetEditor;
      FixMenu;
    end;


    procedure   TFormWren.ViewDebug;
    begin
      PageControlMain.ActivePage := TabSheetDebug;
      FixMenu;
    end;


    procedure   TFormWren.ViewSettings;
    begin
      PageControlMain.ActivePage := TabSheetSettings;
      FixMenu;
    end;


    procedure   TFormWren.ViewGraphs;
    begin
      if   UseGraphs
      then PageControlMain.ActivePage := TabSheetGraphs;

      FixMenu;
    end;


    procedure   TFormWren.ClearLog;
    begin
      MemoDebug.Clear;
    end;


    procedure   TFormWren.ClearGraphs;
    var
      i : Integer;
    begin
      for i := 0 to Length( FChartSeries) - 1
      do  FChartSeries[ i].Clear;
    end;


    procedure   TFormWren.BuildGraphs;
    const
      Colors : array[ 0 .. 7] of TColor = ( clRed, clBlue, clGreen, clPurple, clLime, clNavy, clBlack, clGray);
    var
      aChartCount : Integer;
      i           : Integer;
      aSeries     : TChartSeries;
    begin

      while ChartDebug.SeriesList.Count > 0
      do begin
        aSeries := ChartDebug.SeriesList[ ChartDebug.SeriesList.Count - 1];
        ChartDebug.RemoveSeries( aSeries);
        aSeries.DisposeOf;
      end;

      if   UseGraphs
      then begin

        // RemoveAllSeries does not work ... well, it frees them not ... do it manually

        if   Assigned( FSynthPatch)
        then begin
          aChartCount := FSynthPatch.OutputCount;
          SetLength( FChartSeries, aChartCount);

          for i := 0 to aChartCount - 1
          do begin
            FChartSeries[ i]                := TFastLineSeries.Create( ChartDebug);
            FChartSeries[ i].Name           := Format( 'out_%d', [ i], AppLocale);
            FChartSeries[ i].Stairs         := GraphStairs;
            FChartSeries[ i].InvertedStairs := True;
            FChartSeries[ i].LinePen.Width  := 2;
            FChartSeries[ i].Active         := True;
            FChartSeries[ i].Visible        := True;

            if   i < Length( Colors)
            then FChartSeries[ i].Color := Colors[ i];

            ChartDebug.AddSeries( FChartSeries[ i]);
          end;
        end;
      end;
    end;


    procedure   TFormWren.DumpPatch;
    var
      S : string;
    begin
      S := '';

      if   Assigned( FSynthPatch)
      then begin
        FSynthPatch.Dump( 0, S);
        LogFmt( LC_PATCH_DUMP, '%s', [ S]);
      end
      else Log( LC_PATCH_DUMP, 'FSynthPatch not assigned, can not dump patch')
    end;


    procedure   TFormWren.ProfilePatch;
    var
      aProfile : TStringList;
      aPath    : string;
    begin
      CollectDenormals( False);

      if   not HAS_PATCH_PROFILER
      then Exit;

      if   Assigned( FSynthPatch)
      then begin
        aProfile := FSynthPatch.CreateProfileHtml;

        if Assigned( aProfile)
        then begin
          try
            aPath := IncludeTrailingPathDelimiter( IncludeTrailingPathDelimiter( ApplicationPath) + 'data');

            if   not System.SysUtils.DirectoryExists( aPath)
            then System.SysUtils.ForceDirectories( aPath);

            aProfile.SaveToFile( aPath + 'profile.html');

            if   FileExists( aPath + 'profile.html')
            then begin
              ShellExecute(
                Handle,
                Nil,
                PChar( Format( 'file://%s', [ aPath + 'profile.html'], AppLocale)),
                Nil,
                Nil,
                SW_SHOWNORMAL
              );
            end
          finally
            FreeAndNil( aProfile);
          end;
        end;
      end
      else Log( LC_PROFILER, 'No synth patch avaialable, can not profile');
    end;


    function    TFormWren.CreateSpeechVoiceNames: TStringList;
    var
      aVoice  : TSpVoice;
      aTokens : ISpeechObjectTokens;
      i       : Integer;
    begin
      Result := TStringList.Create;

      try
        try
          aVoice  := TSpVoice.Create( nil);
          aTokens := aVoice.GetVoices( '', '');

          for i := 0 to aTokens.Count - 1
          do Result.Add( aTokens.Item( i).GetDescription( 0));
        except
          Result.Insert( 0, '* Error: SAPI not present? *');
        end;
      finally
        FreeAndNil( aVoice);
      end;
    end;


    function    TFormWren.CreateSpeechRateNames: TStringList;
    begin
      Result := TStringList.Create;
      Result.Add( '8 kHz' );
      Result.Add( '11 kHz');
      Result.Add( '12 kHz');
      Result.Add( '16 kHz');
      Result.Add( '22 kHz');
      Result.Add( '24 kHz');
      Result.Add( '32 kHz');
      Result.Add( '44 kHz');
      Result.Add( '48 kHz');
    end;


    procedure   TFormWren.FixModuleStatics;
    // This is to fix controls with a dynamic step count. These are set from here with a stringlist for their captions,
    // setting the string list will change the step count. At load time of a patch this information is not available yet
    // so there is an additional clutch, the DynamicStepCount property which should be set to true for the
    // ValuedControls handled here.
    begin
      if   Assigned( PatchEditor)
      then begin
        try
          PatchEditor.VisitControls(  335, TKnobsSelector, 'scalequantizer_scale'    , FixScaleQuantizeStatics , nil);
          PatchEditor.VisitControls(  510, TKnobsSelector, 'talkie_bank'             , FixTalkieStatics        , nil);
          PatchEditor.VisitControls(  528, TKnobsSelector, 'sapivoice_voice'         , FixSapiSpeechTypeStatics, nil);
          PatchEditor.VisitControls(  528, TKnobsSelector, 'sapivoice_rate'          , FixSpeechRateTypeStatics, nil);
          PatchEditor.VisitControls(  529, TKnobsSelector, 'espeakvoice_voice'       , FixESpeakVoiceStatics   , nil);
          PatchEditor.VisitControls(  529, TKnobsSelector, 'espeakvoice_language'    , FixESpeakLanguageStatics, nil);
          PatchEditor.VisitControls(  709, TKnobsSelector, 'rndgranulator_envtype'   , FixGranulatorStatics    , nil);
          PatchEditor.VisitControls(  710, TKnobsSelector, 'granulator_envtype'      , FixGranulatorStatics    , nil);
          PatchEditor.VisitControls(  711, TKnobsSelector, 'simplegranulator_envtype', FixGranulatorStatics    , nil);
          PatchEditor.VisitControls( 1012, TKnobsSelector, 'formant2_vowelset'       , FixFormant2Statics      , nil);
          PatchEditor.VisitControls( 1023, TKnobsSelector, 'modal2_preset'           , FixModal2Statics        , nil);
          PatchEditor.VisitControls( 1208, TKnobsSelector, 'seqrandom_scale'         , FixSeqRandomStatics     , nil);
          PatchEditor.VisitControls( 1214, TKnobsSelector, 'probsequencer_scale'     , FixProbSequencerStatics , nil);
          PatchEditor.VisitControls( 1227, TKnobsSelector, 'swansong_mazetype'       , FixMazeTypeStatics      , nil);
        except
          on E: Exception
          do KilledException( E);
        end;
      end;
    end;


    procedure   TFormWren.FixDynamicConverter( const aName: string; const aValues: TStringList);
    var
      aConverter : TKnobsDynamicConverter;
    begin
      aConverter := Converters.GetDynamicConverter( aName);

      if   Assigned( aConverter)
      then aConverter.Captions := aValues;
    end;


    function    TFormWren.FixTalkieStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aPhraseSets : TTalkiePhraseSets;
      aStringList : TStringList;
    begin
      Result      := True;
      aStringList := nil;
      aSelector   := aControl as TKnobsSelector;
      aPhraseSets := TalkiePhraseSets;

      try
        if   Assigned( aPhraseSets)
        then aStringList := aPhraseSets.CreateBankNames;

        if   not Assigned( aStringList)
        then begin
          aStringList := TStringList.Create;
          aStringList.Add( 'words.lpc missing?');
        end;

        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Talkie bank', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixGranulatorStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result    := True;
      aSelector := aControl as TKnobsSelector;

      if   Assigned( aSelector)
      then begin
        aStringList := CreateEnvelopeTypeNames;

        try
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Grain envelopes', aStringList);
        finally
          FreeAndNil( aStringList);
        end;
      end;
    end;


    function    TFormWren.FixSeqRandomStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result      := True;
      aSelector   := aControl as TKnobsSelector;
      aStringList := SystemScales.CreateScaleNames;

      try
        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Scale', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixScaleQuantizeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result      := True;
      aSelector   := aControl as TKnobsSelector;
      aStringList := SystemScales.CreateScaleNames;

      try
        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Scale', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixProbSequencerStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result      := True;
      aSelector   := aControl as TKnobsSelector;
      aStringList := SystemScales.CreateScaleNames;

      try
        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Scale', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixFormant2Statics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result      := True;
      aSelector   := aControl as TKnobsSelector;
      aStringList := FormantControl.CreateFormantNames;

      try
        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Formant2 vowels', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixModal2Statics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector   : TKnobsSelector;
      aStringList : TStringList;
    begin
      Result      := True;
      aSelector   := aControl as TKnobsSelector;
      aStringList := FormantControl.CreateModalNames;

      try
        if   Assigned( aStringList)
        then begin
          aSelector.Captions := aStringList;
          FixDynamicConverter( 'Dyn Modal2', aStringList);
        end;
      finally
        FreeAndNil( aStringList);
      end;
    end;


    function    TFormWren.FixMazeTypeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector : TKnobsSelector;
    begin
      Result    := True;
      aSelector := aControl as TKnobsSelector;

      if   Assigned( FMazeList)
      then begin
        aSelector.Captions := FMazeList;
        FixDynamicConverter( 'Dyn maze type', FMazeList);
      end;
    end;


    function    TFormWren.FixSapiSpeechTypeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector : TKnobsSelector;
    begin
      Result    := True;
      aSelector := aControl as TKnobsSelector;

      if   Assigned( FSapiVoiceNames)
      then begin
        aSelector.Captions := FSapiVoiceNames;
        FixDynamicConverter( 'Dyn sapi speech voices', FSapiVoiceNames);
      end;
    end;


    function    TFormWren.FixSpeechRateTypeStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector : TKnobsSelector;
    begin
      Result    := True;
      aSelector := aControl as TKnobsSelector;

      if   Assigned( FSapiRateNames)
      then begin
        aSelector.Captions := FSapiRateNames;
        FixDynamicConverter( 'Dyn sapi speech rates', FSapiRateNames);
      end;
    end;


    function    TFormWren.FixESpeakVoiceStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aSelector : TKnobsSelector;
      aVoices   : TStringList;
    begin
      Result    := True;
      aSelector := aControl as TKnobsSelector;

      if   FESpeakAvailable
      and  Assigned( FESpeaker)
      then begin
        aVoices := FEspeaker.CreateVoiceNames;

        try
          aSelector.Captions := aVoices;
          FixDynamicConverter( 'Dyn eSpeak speech voices', aVoices);
        finally
          aVoices.DisposeOf;
        end;
      end;
    end;


    function    TFormWren.FixESpeakLanguageStatics( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aVoiceSelector    : TKnobsSelector;
      aLanguageSelector : TKnobsSelector;
      aVoiceIndex       : Integer;
      aLanguages        : TStringList;
    begin
      Result := True;

      if   FESpeakAvailable
      and  Assigned( FESpeaker)
      and  ( aUserData is TKnobsSelector)
      then begin
        aLanguageSelector := aControl  as TKnobsSelector;
        aVoiceSelector    := aUserData as TKnobsSelector;
        aVoiceIndex       := aVoiceSelector.KnobPosition;
        aLanguages        := FESpeaker.CreateLanguageNames( aVoiceIndex);

        try
          aLanguageSelector.Captions := aLanguages;
        finally
          aLanguages.DisposeOf;
        end;
      end;
    end;


    function    TFormWren.ChangeSynthPatch( const aSynthPatch: TSynthPatch; ModulesChanged: Boolean): Boolean;
    // Swap in a new synth patch, return false when the patch did not change.
    var
      OldSynth    : TSynthPatch;
      WasSounding : Boolean;
    begin
      Result := False;

      if   Assigned( aSynthPatch)
      then begin

        // Do not change the patch if it's 'the same' or 'equivalent' at least.
        // But always do change when modules were changed, or otherwise the
        // mapping of the patch to the synth may be wrong.
        // When IsSamePatch retured true there still may be added or deleted moodules,
        // in the case such modules are uncompiled ones, like blanks, comments etc.

        if   not aSynthPatch.IsSamePatch( FSynthPatch) or ModulesChanged
        then begin
          aSynthPatch.Locked          := True;                    // Do not allow execution of the new patch yet
          aSynthPatch.OnSendShortMidi := DoMidiTxShortMessage;    // Set up callbacks for new patch
          aSynthPatch.OnSendOSCString := DoSendOSCBytes;
          aSynthPatch.OnSendMidiBytes := DoSendMidiBytes;
          aSynthPatch.FixDeZippers;                               // Set the dezipper registers to the knob values

          WasSounding := Sounding;
          Sounding    := False;                                   // Stop audio io

          try
            if   Assigned( FSynthPatch)
            then begin
              FSynthPatch.Locked          := True;                // Stop executing the old patch
              FSynthPatch.OnSendShortMidi := nil;
              FSynthPatch.OnSendOSCString := nil;
              FSynthPatch.OnSendMidiBytes := nil;
            end;

            OldSynth  := AtomicExchange( Pointer( FSynthPatch), Pointer( aSynthPatch));
            PatchName := FSynthPatch.Name;
            FSynthPatch.Locked := False;                          // Allow execution for new patch
            BuildGraphs;

            if   Assigned( OldSynth)
            then FreeAndNil( OldSynth);

            Result := True;
          finally
            Sounding := WasSounding;                              // Reenable audio io (when it was on before)
          end;
        end;
      end
      else begin
        Log( LC_COMPILER, 'BUG: ChangeSynthPatch, aSynthPatch not assigned');
        ViewDebug;
      end;
    end;


    procedure   TFormWren.ExecutePatch;
    begin
      if   Assigned( FSynthPatch)
      then begin
        {$Q-R-}Inc( FSampleCount);{$Q+R+}

        FSynthPatch.TickWithData( FTickInZeroData);
      end;

      if   not FAudioRunning
      and  UseGraphs
      then ChartOoutputs;
    end;


    procedure   TFormWren.ChartOutput( anIndex: Integer; aValue: TSignal);
    begin
      if   Assigned( FSynthPatch)
      then begin
        if   FChartSeries[ anIndex].Count > 409600
        then FChartSeries[ anIndex].Clear;

        FChartSeries[ anIndex].AddXY( SampleCountToTime( FSampleCount) * 1000, aValue - anIndex); // in ms
      end;
    end;


    procedure   TFormWren.ChartOoutputs;
    var
      i : Integer;
      V : TSignal;
    begin
      if   Assigned( FSynthPatch)
      then begin
        for i := 0 to Length( FChartSeries) - 1
        do begin
          V := FSynthPatch.Output[ i];

          if   not IsNan( V)
          then ChartOutput( i, Clip( V, -256.0, 256.0));
        end;
      end;
    end;


    procedure   TFormWren.DebugRunStop;
    const
      FRAME_SIZE = 512;
    var
      i : Integer;
    begin
      if   FAudioRunning
      then Log( LC_AUDIO, 'can not do a debug run while real time audio generation is on')
      else begin
        if   FDebugRunning
        then begin
          FDebugRunning          := False;
          BitBtnDebugRun.Caption := 'debug Run';
          Log( LC_AUDIO, 'DebugRun stopped');
        end
        else begin
          Assert( Assigned( FSynthPatch), 'FSynthPatch should be assigned here');
          FDebugRunning          := True;
          BitBtnDebugRun.Caption := 'debug Stop';
          Log( LC_AUDIO, 'DebugRun started');

          try
            FSampleCount := 0;

            while   FDebugRunning
            and not FAudioRunning
            do begin
              Application.ProcessMessages;

              for i := 1 to FRAME_SIZE
              do begin
                {$Q-R-}Inc( FSampleCount);{$Q+R+}

                if   FSampleCount and Control_Dec_Min_One = 0
                then HandleMorphing;

                ExecutePatch;
              end;
            end;
          except
            on E: Exception
            do KilledException( E);
          end;

          FDebugRunning := False;
          BitBtnDebugRun.Caption := 'debug Run';
        end;
      end;
    end;


//   private

    procedure   TFormWren.DeZipper;
    const
      REC_1024 = 1.0 / 1024.0;
    begin
      FOutVolume1 := Normalize(( FOutShadow1 + FOutVolume1 * 1023) * REC_1024);
      FInVolume1  := Normalize(( FInShadow1  + FInVolume1  * 1023) * REC_1024);
      FOutVolume2 := Normalize(( FOutShadow2 + FOutVolume2 * 1023) * REC_1024);
      FInVolume2  := Normalize(( FInShadow2  + FInVolume2  * 1023) * REC_1024);
      FOutVolume3 := Normalize(( FOutShadow3 + FOutVolume3 * 1023) * REC_1024);
      FInVolume3  := Normalize(( FInShadow3  + FInVolume3  * 1023) * REC_1024);
      FOutVolume4 := Normalize(( FOutShadow4 + FOutVolume4 * 1023) * REC_1024);
      FInVolume4  := Normalize(( FInShadow4  + FInVolume4  * 1023) * REC_1024);
    end;


    procedure   TFormWren.UpdateStats;
    var
      anError     : TPaError;
      aStreamInfo : PPaStreamInfo;
    begin
      if   AutoCollectDenormals
      then CollectDenormals( True);

      TickCPUCounter;

      if   Assigned( FPaStream)
      then begin
        LabelCpuUsage.Caption := Format( 'CPU: %.1f', [ Pa_GetStreamCpuLoad( FPaStream) * 100.0], AppLocale);
        aStreamInfo := Pa_GetStreamInfo( FPaStream);
        LabelInputLatency .Caption := Format( ': %.0f ms', [ aStreamInfo^.inputLatency  * 1000], AppLocale);
        LabelOutputLatency.Caption := Format( ': %.0f ms', [ aStreamInfo^.outputLatency * 1000], AppLocale);
      end;

      UpdateDbLabels;
      ShowOverUnderFlows;

      if   FAttentionItem = atNothing
      then begin
        LabelAttention.Font.Color := clGray;
        LabelAttention.Caption    := '';
      end
      else begin
        if   ( FAttentionItem = atManualCompilation)
        and  ( atManualCompilation in FAttentionItems)
        then begin
          if   FUncompiledChanges
          then LabelAttention.Font.Color := clYellow
          else LabelAttention.Font.Color := clWhite;
        end
        else LabelAttention.Font.Color := clYellow;

        case FAttentionItem of
          atNothing           : LabelAttention.Caption := 'nothing' ;
          atMuted             : LabelAttention.Caption := 'muted'   ;
          atSmalls            : LabelAttention.Caption := 'smalls'  ;
          atManualCompilation : LabelAttention.Caption := 'manual'  ;
        end;
      end;

      repeat
        if   FAttentionItem = atPastLast
        then FAttentionItem := atNothing
        else FAttentionItem := Succ( FAttentionItem);
      until FAttentionItem in FAttentionItems;

      if   FAudioRunning
      then ShowRunTime;

      if   RenderToFile
      then KnobsLedrendering.Active := True;

      if   FRequestAsioPanel
      then begin
        if   not FAudioRunning
        then begin
          FRequestAsioPanel := False;
          anError           := PaAsio_ShowControlPanel( FAsioPanelDevice, FAsioPanelPointer);

          if   anError = paNoError
          then Log( LC_AUDIO, 'ASIO panel opened')
          else begin
            ViewDebug;
            LogFmt( LC_AUDIO, 'Error opening ASIO panel: "%s"', [ string( Pa_GetErrorText( anError))]);
          end;

          if   FPanelAudioWasRunning
          then begin
            FreeDevices;
            FPanelAudioWasRunning := False;
            FRequestAudioRestart  := True;
            CreateDevices;
          end;
        end;
      end;

      if   FRequestAudioStart
      then begin
        if   not FAudioRunning
        then begin
          FreeDevices;
          FRequestAudioStart   := False;
          FRequestAudioRestart := True;
          CreateDevices;
        end;
      end;

      if   FRequestAudioRestart
      then begin
        FRequestAudioRestart := False;

        if   not FAudioRunning
        then StartStopAudio;
      end;

      if   FRequestImport
      then begin
        FRequestImport := False;
        DoImportPatch( FRequestedImportName);
      end;
    end;


    procedure   TFormWren.UpdateLights;
    const
      DECAY = 0.001;
    var
      aClocks : Int64;
      aTime   : TSignal;
    begin
      if   Assigned( FSynthPatch)
      then begin
        aClocks        := FSampleCount;
        FUpdateCounter := ( FUpdateCounter + 1) and 3;

        if   LightsActive
        then begin
          case FUpdateCounter of

            0 :
              begin
                FSynthPatch.GatherLights    ( '', DoLights    );
              end;

            1 :
              begin
                FSynthPatch.GatherSignals   ( '', DoSignals   );
                FSynthPatch.GatherData      ( '', DoData      );
                FSynthPatch.GatherStringData( '', DoStringData);
              end;

            2 :
              begin
                FSynthPatch.GatherLights    ( '', DoLights    );
              end;

            3 :
              begin
                FSynthPatch.GatherXYData    ( '', DoXYData    );
                FSynthPatch.GatherCursorData( '', DoCursorData);
              end;

          end;
        end;

        UpdateVUMeters;
        aTime := (( FSampleCount - aClocks) * System_Rate_Rec) * 1000;

        if   aTime > FLightsTime
        then FLightsTime := aTime
        else FLightsTime := DECAY * ( aTime - FlightsTime) + FLightsTime;
      end;
    end;


    procedure   TFormWren.SetVuSampleCount( aCount: Integer);
    var
      aCallRate : TSignal;
      i         : Integer;
    begin
      if   ( aCount > 0)
      and  (( aCount <> FVuSampleCount) or ( System_Rate <> FVuSystemRate))
      then begin
        FVuSampleCount := aCount;
        FVuSystemRate  := System_Rate;
        aCallRate      := FVuSystemRate / FVuSampleCount;

        for i := Low( FDbMinMaxIn) to High( FDbMinMaxIn)
        do begin
          if   Assigned( FDbMinMaxIn[ i])
          then FDbMinMaxIn[ i].CallRate := aCallRate;
        end;

        for i := Low( FDbMinMaxOut) to High( FDbMinMaxOut)
        do begin
          if   Assigned( FDbMinMaxOut[ i])
          then FDbMinMaxOut[ i].CallRate := aCallRate;
        end;
      end;
    end;


    procedure   TFormWren.UpdateVUMeters;

      procedure ShowVU( const aVU: TKnobsIndicatorBar; const aDbMinMax: TDbMinMax);
      begin
        if   Assigned( aDbMinMax)
        then begin
          aVU.     Value := aDbMinMax.ValueRanged( 0, aVU.IndicatorCount);
          aVU.ValeyValue := aDbMinMax.ValeyRanged( 0, aVU.IndicatorCount);
          aVU. PeakValue := aDbMinMax.PeakRanged ( 0, aVU.IndicatorCount);
        end;
      end;

    begin
      ShowVU( IndicatorBarVolumeInLeft1  , FDbMinMaxIn [ 0]);
      ShowVU( IndicatorBarVolumeInRight1 , FDbMinMaxIn [ 1]);
      ShowVU( IndicatorBarVolumeInLeft2  , FDbMinMaxIn [ 2]);
      ShowVU( IndicatorBarVolumeInRight2 , FDbMinMaxIn [ 3]);
      ShowVU( IndicatorBarVolumeInLeft3  , FDbMinMaxIn [ 4]);
      ShowVU( IndicatorBarVolumeInRight3 , FDbMinMaxIn [ 5]);
      ShowVU( IndicatorBarVolumeInLeft4  , FDbMinMaxIn [ 6]);
      ShowVU( IndicatorBarVolumeInRight4 , FDbMinMaxIn [ 7]);

      ShowVU( IndicatorBarVolumeOutLeft1 , FDbMinMaxOut[ 0]);
      ShowVU( IndicatorBarVolumeOutRight1, FDbMinMaxOut[ 1]);
      ShowVU( IndicatorBarVolumeOutLeft2 , FDbMinMaxOut[ 2]);
      ShowVU( IndicatorBarVolumeOutRight2, FDbMinMaxOut[ 3]);
      ShowVU( IndicatorBarVolumeOutLeft3 , FDbMinMaxOut[ 4]);
      ShowVU( IndicatorBarVolumeOutRight3, FDbMinMaxOut[ 5]);
      ShowVU( IndicatorBarVolumeOutLeft4 , FDbMinMaxOut[ 6]);
      ShowVU( IndicatorBarVolumeOutRight4, FDbMinMaxOut[ 7]);
    end;


    procedure   TFormWren.UpdateDbLabels;

      procedure FixDbLabels( const aDbMinMaxL, aDbMinMaxR : TDbMinMax; aLabelPeak, aLabelValey, aLabelAbsMax, aLabelAbsMin: TLabel);
      var
        aPeak    : TSignal;
        aValey   : TSignal;
        anAbsMax : TSignal;
        anAbsMin : TSignal;
      begin
        if   Assigned( aDbMinMaxL)
        and  Assigned( aDbMinMaxR)
        then begin
          aPeak    := Max( aDbMinMaxL.Peak  , aDbMinMaxR.Peak  );
          aValey   := Min( aDbMinMaxL.Valey , aDbMinMaxR.Valey );
          anAbsMax := Max( aDbMinMaxL.AbsMax, aDbMinMaxR.AbsMax);
          anAbsMin := Min( aDbMinMaxL.AbsMin, aDbMinMaxR.AbsMin);

          if   aPeak    <= MIN_DB                           then aLabelPeak  .Caption := '-oo dB' else aLabelPeak  .Caption := Format( '%.1f dB', [ aPeak   ], AppLocale);
          if   aValey   <= MIN_DB                           then aLabelValey .Caption := '-oo dB' else aLabelValey .Caption := Format( '%.1f dB', [ aValey  ], AppLocale);
          if   anAbsMax <= MIN_DB                           then aLabelAbsMax.Caption := '-oo dB' else aLabelAbsMax.Caption := Format( '%.1f dB', [ anAbsMax], AppLocale);
          if ( anAbsMin >= MAX_DB) or ( anAbsMin <= MIN_DB) then aLabelAbsMin.Caption := '-oo dB' else aLabelAbsMin.Caption := Format( '%.1f dB', [ anAbsMin], AppLocale);

          if aPeak    > 0 then aLabelPeak  .Font.Color := clYellow else aLabelPeak  .Font.Color := clBlack;
          if anAbsMax > 0 then aLabelAbsMax.Font.Color := clYellow else aLabelAbsMax.Font.Color := clBlack;
        end;
      end;

    begin
      FixDbLabels( FDbMinMaxIn [ 0], FDbMinMaxIn [ 1], LabeldBInPeak1 , LabeldBInValey1 , LabeldBInMax1 , LabeldBInMin1 );
      FixDbLabels( FDbMinMaxIn [ 2], FDbMinMaxIn [ 3], LabeldBInPeak2 , LabeldBInValey2 , LabeldBInMax2 , LabeldBInMin2 );
      FixDbLabels( FDbMinMaxIn [ 4], FDbMinMaxIn [ 5], LabeldBInPeak3 , LabeldBInValey3 , LabeldBInMax3 , LabeldBInMin3 );
      FixDbLabels( FDbMinMaxIn [ 6], FDbMinMaxIn [ 7], LabeldBInPeak4 , LabeldBInValey4 , LabeldBInMax4 , LabeldBInMin4 );

      FixDbLabels( FDbMinMaxOut[ 0], FDbMinMaxOut[ 1], LabeldbOutPeak1, LabeldbOutValey1, LabeldBOutMax1, LabeldBOutMin1);
      FixDbLabels( FDbMinMaxOut[ 2], FDbMinMaxOut[ 3], LabeldbOutPeak2, LabeldbOutValey2, LabeldBOutMax2, LabeldBOutMin2);
      FixDbLabels( FDbMinMaxOut[ 4], FDbMinMaxOut[ 5], LabeldbOutPeak3, LabeldbOutValey3, LabeldBOutMax3, LabeldBOutMin3);
      FixDbLabels( FDbMinMaxOut[ 6], FDbMinMaxOut[ 7], LabeldbOutPeak4, LabeldbOutValey4, LabeldBOutMax4, labeldboutmin4);
    end;


    function    TFormWren.HandleAudioInOut( anInput, anOutput: Pointer; aFrameCount: culong; aTimeInfo: PPaStreamCallbackTimeInfo; aStatusFlags: TPaStreamCallbackFlags; UserData: Pointer): cint;
    //
    // ** This function is called from the PortAudio thread **
    //
    // Handle PortAudio audio input and drive the local dezippers
    // Collect PortAudio audio output from synth and send it to the output device
    // Drive the synth, an output channel must always be active
    var
      i               : Integer;
      j               : Integer;
      InVolumes       : array[ 0 .. IN_CHANNEL_COUNT  - 1] of TSignal;
      OutVolumes      : array[ 0 .. OUT_CHANNEL_COUNT - 1] of TSignal;
      InMaxima        : array[ 0 .. IN_CHANNEL_COUNT  - 1] of TSignal;
      OutMaxima       : array[ 0 .. OUT_CHANNEL_COUNT - 1] of TSignal;
      InChCount       : Integer;
      OutChCount      : Integer;
    begin
      Result := paContinue;

      try
        for j := 0 to IN_CHANNEL_COUNT - 1
        do  InMaxima[ j] := 0;

        for j := 0 to OUT_CHANNEL_COUNT - 1
        do  OutMaxima[ j] := 0;

        InVolumes[ 0] := FInVolume1; OutVolumes[ 0] := FOutVolume1;
        InVolumes[ 1] := FInVolume1; OutVolumes[ 1] := FOutVolume1;
        InVolumes[ 2] := FInVolume2; OutVolumes[ 2] := FOutVolume2;
        InVolumes[ 3] := FInVolume2; OutVolumes[ 3] := FOutVolume2;
        InVolumes[ 4] := FInVolume3; OutVolumes[ 4] := FOutVolume3;
        InVolumes[ 5] := FInVolume3; OutVolumes[ 5] := FOutVolume3;
        InVolumes[ 6] := FInVolume4; OutVolumes[ 6] := FOutVolume4;
        InVolumes[ 7] := FInVolume4; OutVolumes[ 7] := FOutVolume4;
        InChCount     := FPaInstreamParameters .channelCount;
        OutChCount    := FPaOutstreamParameters.channelCount;

        if   Assigned( FSynthPatch)
        then begin
          for i := 0 to aFrameCount - 1
          do begin
            {$Q-R-}Inc( FSampleCount);{$Q+R+}

            if   FSampleCount and Control_Dec_Min_One = 0
            then begin
              DeZipper;
              HandleMorphing;
            end;

            for j := 0 to IN_CHANNEL_COUNT - 1
            do begin
              if   j < InChCount
              then FTickInData[ j] := InVolumes[ j] * SAMP_MAX_REC * PSamples( anInput)[ InChCount * i + j]
              else FTickInData[ j] := 0;

              InMaxima[ j] := Max( InMaxima[ j], Abs( FTickInData[ j]));
            end;

            FSynthPatch.TickWithData( FTickInData);

            for j := 0 to OUT_CHANNEL_COUNT - 1
            do begin
              FTickOutData[ j] := OutVolumes[ j] * FSynthPatch.Output[ j];
              OutMaxima   [ j] := Max( OutMaxima[ j] , Abs( FTickOutData[ j]));

              if   j < OutChCount
              then PSamples( anOutput)[ OutChCount * i + j] := Round( SAMP_MAX * Clip( FTickOutData[ j], -1.0, 1.0));
            end;
          end;
        end;

        SetVuSampleCount( aFrameCount);

        for i := 0 to IN_CHANNEL_COUNT  - 1 do FDbMinMaxIn [ i].Tick( InMaxima [ i]);
        for i := 0 to OUT_CHANNEL_COUNT - 1 do FDbMinMaxOut[ i].Tick( OutMaxima[ i]);

        {$Q-R-}
        if aStatusFlags and paInputUnderflow  <> 0 then Inc( FPaInUnderflows );
        if aStatusFlags and paInputOverflow   <> 0 then Inc( FPaInoverflows  );
        if aStatusFlags and paOutputUnderflow <> 0 then Inc( FPaOutUnderflows);
        if aStatusFlags and paOutputOverflow  <> 0 then Inc( FPaOutoverflows );
        {$Q+R+}
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.HandleAudioOnStartPA( userdata: Pointer);
    begin
      Log( LC_AUDIO, 'PortAudio was started'); // Not called from audio thread, ok to log
      FAudioRunning := True;
      UpdateCaptions;
    end;


    procedure   TFormWren.HandleAudioOnStopPA( userdata: Pointer);
    //
    // ** This function is called from the PortAudio thread **
    //
    // which means that we can not use Log() here.
    begin
      FAudioRunning := False;
    end;


    procedure   TFormWren.WaveShowAsioPanel( aSender: TObject; aDevice: TPaDeviceIndex; aHandle: HWND);
    begin
      if   FAudioRunning
      then begin
        FPanelAudioWasRunning := True;
        StartStopAudio;
      end;

      FAsioPanelDevice  := aDevice;
      FAsioPanelPointer := Pointer( aHandle);
      FRequestAsioPanel := True;
    end;


    procedure   TFormWren.WaveRestartAudio( aSender: TObject; aDebug: Boolean);
    begin
      if   aDebug
      then ViewDebug;

      if   not FAudioRunning
      then StartStopAudio
      else begin
        StartStopAudio;
        FRequestAudioStart := True;
      end;
    end;


    procedure   TFormWren.WaveLog( aSender: TObject; const aMsg: string);
    begin
      LogFmt( LC_AUDIO, 'WaveDlg: %s', [ aMsg]);
    end;


    procedure   TFormWren.CreateDevices;
    begin
      if   not FCanCreateAudio
      then Exit;

      Log( LC_AUDIO,    'creating  PortAudio device');

      with FPaInstreamParameters
      do begin
        device           := FormWaveDeviceSelect.PaInDeviceId;
        sampleFormat     := paInt16;
        suggestedLatency := FormWaveDeviceSelect.PaInDevice.defaultLowInputLatency;

        if   FormWaveDeviceSelect.IsAsioIn
        then begin
          PaAsio_GetAvailableBufferSizes( FPaInstreamParameters.device, FPaAsioMinFrames, FPaAsioMaxFrames, FPaAsioPrefFrames, FPaAsioGranFrames);
          FPaAsioInStreamInfo       := FormWaveDeviceSelect.CreateAsioInStreamInfo;
          hostApiSpecificStreamInfo := @ FPaAsioInStreamInfo;
          channelCount              := Min( IN_CHANNEL_COUNT, FormWaveDeviceSelect.InMaskCount);
        end
        else begin
          FPaAsioMinFrames          := 0;
          FPaAsioMaxFrames          := 0;
          FPaAsioPrefFrames         := 0;
          FPaAsioGranFrames         := 0;
          hostApiSpecificStreamInfo := nil;
          channelCount              := Min( IN_CHANNEL_COUNT, FormWaveDeviceSelect.PaInDevice.maxInputChannels);
        end;
      end;

      with FPaOutstreamParameters
      do begin
        device                    := FormWaveDeviceSelect.PaOutDeviceId;
        sampleFormat              := paInt16;
        suggestedLatency          := 20e-3;

        if   FormWaveDeviceSelect.IsAsioOut
        then begin
          PaAsio_GetAvailableBufferSizes( FPaOutstreamParameters.device, FPaAsioMinFrames, FPaAsioMaxFrames, FPaAsioPrefFrames, FPaAsioGranFrames);
          FPaAsioOutStreamInfo      := FormWaveDeviceSelect.CreateAsioOutStreamInfo;
          hostApiSpecificStreamInfo := @ FPaAsioOutStreamInfo;
          channelCount              := Min( OUT_CHANNEL_COUNT, FormWaveDeviceSelect.OutMaskCount);
        end
        else begin
          FPaAsioMinFrames          := 0;
          FPaAsioMaxFrames          := 0;
          FPaAsioPrefFrames         := 0;
          FPaAsioGranFrames         := 0;
          hostApiSpecificStreamInfo := nil;
          channelCount              := Min( OUT_CHANNEL_COUNT, FormWaveDeviceSelect.PaOutDevice.maxOutputChannels);
        end;
      end;
    end;


    procedure   TFormWren.FreeDevices;
    begin
      if   not FCanCreateAudio
      then Exit;

      StopAudio;
      Log( LC_AUDIO,    'freeing   PortAudio device');
      FormWaveDeviceSelect.FreeAsioStreamInfo( FPaAsioInStreamInfo );
      FormWaveDeviceSelect.FreeAsioStreamInfo( FPaAsioOutStreamInfo);
      FPaStream := nil; // Pa_CloseStream should have been closed by StopAudio, but we did not open it at this
                        // level, just to be sure set it to nil here so it will not be used anymore.
    end;


    procedure   TFormWren.StopAudio;
    begin
      if   not FAudioRunning
      then Exit;

      if   Assigned( FPaStream)
      then begin
        if   FAudioRunning
        then begin
          LogFmt( LC_AUDIO, 'stopping  PortAudio, patch "%s"', [ PatchName]);
          Pa_StopStream( FPaStream);
        end;

        Pa_CloseStream( FPaStream);
      end;

      FPaStream   := nil;
      FOutVolume1 := 0;
      ClearVolumeIndicators;
      UpdateCaptions;

      if   ClearVUOnStop
      then ClearVUMeters;
    end;


    procedure   TFormWren.StartAudio;
    var
      BufSize : Integer;
      anError : TPaError;
      i       : Integer;
      aFlags  : TPaStreamFlags;
    begin
      if   ( not FCanCreateAudio)
      or   FAudioRunning
      then Exit;

      try
        BufSize := BufferSize;

        if   ( FPaInstreamParameters .channelCount = 0)
        and  ( FPaOutstreamParameters.channelCount = 0)
        then CreateDevices;

        LogFmt(
          LC_AUDIO,
          'starting  PA [api: "%s", in: "%s" ch: %d, out: "%s" ch: %d], patch "%s" at %.1f ks/s with buffer size %d frames',
          [
            FormWaveDeviceSelect  .SelectedAPI     ,
            FormWaveDeviceSelect  .SelectedInputPA ,
            FPaInstreamParameters .channelCount    ,
            FormWaveDeviceSelect  .SelectedOutputPA,
            FPaOutstreamParameters.channelCount    ,
            PatchName                              ,
            System_Rate / 1000                     ,
            BufSize
          ]
        );


        if   FormWaveDeviceSelect.IsAsioIn         // Masks only used for ASIO
        then begin
          for i := 0 to FPaInstreamParameters.channelCount - 1
          do LogFmt( LC_AUDIO, '  ASIO mask: input  %d -> %d ', [ i + 1, FormWaveDeviceSelect.InMasks[ i]]);
        end;

        if   FormWaveDeviceSelect.IsAsioOut        // Masks only used for ASIO
        then begin
          for i := 0 to FPaOutstreamParameters.channelCount - 1
          do LogFmt( LC_AUDIO, '  ASIO mask: output %d -> %d', [ i + 1, FormWaveDeviceSelect.OutMasks[ i]]);
        end;

        // Fixed a bug below .. where an input-only or an output-only system would npt work .. not that an input-only
        // system would make much sense .. but still .. it should open.

        aFlags := paClipOff {or paDitherOff};

        if      FPaInstreamParameters .channelCount = 0
        then    anError := Pa_OpenStream( FPaStream, nil                    , @ FPaOutstreamParameters, System_Rate, BufSize, aFlags, @ GHandleAudioOnBufferFilledPA, nil)
        else if FPaOutstreamParameters.channelCount = 0
        then    anError := Pa_OpenStream( FPaStream, @ FPaInstreamParameters, nil                     , System_Rate, BufSize, aFlags, @ GHandleAudioOnBufferFilledPA, nil)
        else    anError := Pa_OpenStream( FPaStream, @ FPaInstreamParameters, @ FPaOutstreamParameters, System_Rate, BufSize, aFlags, @ GHandleAudioOnBufferFilledPA, nil);

        if   anError = paNoError
        then begin
          anError := Pa_SetStreamFinishedCallback( FPaStream, @ GHandleAudioOnStopPA);

          if   anError = paNoError
          then begin
            anError := Pa_StartStream( FPaStream);

            if   anError = paNoError
            then HandleAudioOnStartPA( nil)
            else LogFmt( LC_AUDIO, 'error starting PA stream: %s', [ string( Pa_GetErrorText( anError))]);
          end
          else LogFmt( LC_AUDIO, 'error setting PA stream finished callback: %s', [ string( Pa_GetErrorText( anError))]);
        end
        else begin
          LogFmt( LC_AUDIO, 'error opening PA stream: %s', [ string( Pa_GetErrorText( anError))]);
          FPaStream := nil;
        end;

        if   anError <> paNoError
        then ViewDebug;
      except
        on E: Exception
        do begin
          LogFmt( LC_AUDIO, 'exception on opening PA stream: "%s"', [ E.ToString]);
          ViewDebug;
        end;
      end;

      ClearVolumeIndicators;
      UpdateCaptions;
      FPaInUnderflows  := 0;
      FPaInoverflows   := 0;
      FPaOutUnderflows := 0;
      FPaOutoverflows  := 0;

      if   Assigned( FSynthPatch)
      then FSynthPatch.FixDeZippers;

      FOutShadow1 := knob_outputlevel1.AsValue;
      FOutShadow2 := knob_outputlevel2.AsValue;
      FOutShadow3 := knob_outputlevel3.AsValue;
      FOutShadow4 := knob_outputlevel4.AsValue;

      if   not RenderToFile
      then ResetRunTime;
    end;


    procedure   TFormWren.StartStopAudio;
    begin
      if   FAudioRunning
      then StopAudio
      else StartAudio;
    end;


    procedure   TFormWren.VerifyDevices;
    var
      i : Integer;
    begin
      FormWaveDeviceSelect.SelectedAPIID      := Self.FSelectedAPIID;
      FormWaveDeviceSelect.SelectedInputIdPA  := Self.FSelectedInputIdPA;
      FormWaveDeviceSelect.SelectedOutputIdPA := Self.FSelectedOutputIdPA;
      FormWaveDeviceSelect.BufferSize         := Self.FBufferSize;

      for i := 0 to 7
      do begin
        FormWaveDeviceSelect.InMasks [ i] := Self.FInMasks [ i];
        FormWaveDeviceSelect.OutMasks[ i] := Self.FOutMasks[ i];
      end;

      SelectDevices;
    end;


    procedure   TFormWren.SelectDevices;
    var
      WasRunning   : Boolean;
      i            : Integer;
    begin
      WasRunning := FAudioRunning;

      if   WasRunning
      then StopAudio;

      FreeDevices;
      FSelectedAPIID       := FormWaveDeviceSelect.SelectedAPIID;
      FSelectedInputIdPA   := FormWaveDeviceSelect.SelectedInputIdPA;
      FSelectedOutputIdPA  := FormWaveDeviceSelect.SelectedOutputIdPA;
      FBufferSize          := FormWaveDeviceSelect.BufferSize;

      for i := 0 to 7
      do begin
        Self.FInMasks [ i] := FormWaveDeviceSelect.InMasks [ i];
        Self.FOutMasks[ i] := FormWaveDeviceSelect.OutMasks[ i];
      end;

      CreateDevices;

      if   WasRunning
      then StartAudio;
    end;


    procedure   TFormWren.ClearVolumeIndicators;
    begin
      IndicatorBarVolumeInLeft1  .Value := 0.0;
      IndicatorBarVolumeInRight1 .Value := 0.0;
      IndicatorBarVolumeOutLeft1 .Value := 0.0;
      IndicatorBarVolumeOutRight1.Value := 0.0;
      IndicatorBarVolumeInLeft2  .Value := 0.0;
      IndicatorBarVolumeInRight2 .Value := 0.0;
      IndicatorBarVolumeOutLeft2 .Value := 0.0;
      IndicatorBarVolumeOutRight2.Value := 0.0;
      IndicatorBarVolumeInLeft3  .Value := 0.0;
      IndicatorBarVolumeInRight3 .Value := 0.0;
      IndicatorBarVolumeOutLeft3 .Value := 0.0;
      IndicatorBarVolumeOutRight3.Value := 0.0;
      IndicatorBarVolumeInLeft4  .Value := 0.0;
      IndicatorBarVolumeInRight4 .Value := 0.0;
      IndicatorBarVolumeOutLeft4 .Value := 0.0;
      IndicatorBarVolumeOutRight4.Value := 0.0;
      ResetPeaks;
    end;


    procedure   TFormWren.ShowOverUnderFlows;
    var
      LockSkips : Cardinal;
    begin
      if   Assigned( FSynthPatch)
      then LockSkips := FSynthPatch.LockSkips
      else LockSkips := 0;

      LabelAudioInUnderflows .Caption := Format( ': %d'     , [ FPaInUnderflows  ], AppLocale);
      LabelAudioInOverflows  .Caption := Format( ': %d'     , [ FPaInOverflows   ], AppLocale);
      LabelAudioOutUnderflows.Caption := Format( ': %d'     , [ FPaOutUnderflows ], AppLocale);
      LabelAudioOutOverflows .Caption := Format( ': %d'     , [ FPaOutOverflows  ], AppLocale);
      LabelExceptions        .Caption := Format( ': %d'     , [ ExceptionCounter ], AppLocale);
      LabelLightsTime        .Caption := Format( ': %.2f ms', [ FLightsTime      ], AppLocale);
      LabelLockSkips         .Caption := Format( ': %d'     , [ LockSkips        ], AppLocale);

      if   ( FLastAudioInUnderflows  <> FPaInUnderflows )
      or   ( FLastAudioInOverflows   <> FPaInOverflows  )
      or   ( FLastAudioOutUnderflows <> FPaOutUnderflows)
      or   ( FLastAudioOutOverflows  <> FPaOutOverflows )
      then KnobsLedUnderflows.Active :=
        ( FPaInUnderflows  <> 0) or
        ( FPaInOverflows   <> 0) or
        ( FPaOutUnderflows <> 0) or
        ( FPaOutOverflows  <> 0);

      FLastAudioInUnderflows  := FPaInUnderflows;
      FLastAudioInOverflows   := FPaInOverflows;
      FLastAudioOutUnderflows := FPaOutUnderflows;
      FLastAudioOutOverflows  := FPaOutOverflows;
    end;


    procedure   TFormWren.ClearOverUnderFlows;
    begin
      FPaInUnderflows  := 0;
      FPaOutUnderflows := 0;
      FPaInoverflows   := 0;
      FPaOutoverflows  := 0;
    end;


    procedure   TFormWren.ShowRunTime;
    begin
      LabelRunTime.Caption := Format( 'T %s', [ FormatTime64( GetTimeStamp)], AppLocale);
      LabelRunTime.Hint    := 'Current run time for the program, click to reset';
    end;


    procedure   TFormWren.ResetRuntime;
    begin
      ResetTimeStamp;
      ShowRunTime;
    end;


    function    TFormWren.GetDefaultModuleColor( const aSender: TObject; const aModuleType: TKnobsModuleType): TColor;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.DefaultModuleColor( aModuleType, ModuleColor)
      else Result := ModuleColor;
    end;


    procedure   TFormWren.ConnectorDelete( const aConnector: TKnobsConnector);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ConnectorDelete( aConnector);
    end;


    procedure   TFormWren.ConnectorBreak( const aConnector: TKnobsConnector);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ConnectorBreak( aConnector);
    end;


    procedure   TFormWren.ConnectorDisconnect( const aConnector: TKnobsConnector);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ConnectorDisconnect( aConnector);
    end;


    procedure   TFormWren.SetWireColor( const aConnector : TKnobsConnector; const aColor: TColor);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SetWireColor( aConnector, aColor);
    end;


    procedure   TFormWren.SetWireColorDefault( const aConnector: TKnobsConnector);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SetWireColorDefault( aConnector);
    end;


    procedure   TFormWren.SetWireColorCustom( const aConnector: TKnobsConnector);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aConnector)
      then begin
        with ColorDialogModule
        do begin
          Color := aConnector.WireColor;

          if   Execute
          then PatchEditor.SetWireColor( aConnector, Color);
        end;
      end;
    end;


    procedure   TFormWren.ModuleCut( const aModule: TKnobsModule);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aModule)
      then begin
        aModule.FixSelection;
        CutModules;
      end;
    end;


    procedure   TFormWren.ModuleCopy( const aModule: TKnobsModule);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aModule)
      then begin
        aModule.FixSelection;
        CopyModules;
      end;
    end;


    procedure   TFormWren.ModuleDelete( const aModule: TKnobsModule);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aModule)
      then begin
        aModule.FixSelection;
        DeleteModules;
      end;
    end;


    procedure   TFormWren.ModulePasteParams( const aModule: TKnobsModule; StrictCopy: Boolean);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aModule)
      then PasteParameters( StrictCopy);
    end;


    procedure   TFormWren.ChangeModuleColor( const aModule: TKnobsModule);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( aModule)
      then begin
        aModule.FixSelection;

        with ColorDialogModule
        do begin
          Color := aModule.Color;

          if   Execute
          then PatchEditor.SetSelectedModuleColor( Color);
        end;
      end;
    end;


    procedure   TFormWren.ModuleColorDefault ( const aModule: TKnobsModule);
    begin
      if   Assigned( PatchEditor)
      and  Assigned( FormStore  )
      and  Assigned( aModule    )
      then begin
        aModule.FixSelection;
        PatchEditor.SetSelectedModuleColorDefault( GetDefaultModuleColor);
      end;
    end;


    procedure   TFormWren.ModuleRandomize( const aModule: TKnobsModule);
    begin
      if   Assigned( aModule)
      then begin
        if   not aModule.Selected
        then aModule.SelectUnique;

        SetRandomValue;
      end;
    end;


    procedure   TFormWren.ModuleRandomizationToggle( const aModule: TKnobsModule);
    begin
      if   Assigned( aModule)
      then begin
        if   not aModule.Selected
        then aModule.SelectUnique;

        SetAllowRandomization( not aModule.AllowRandomization)
      end;
    end;


    procedure   TFormWren.KnobSetDefaultValue( const aValuedControl: TKnobsValuedControl);
    begin
      if   Assigned( aValuedControl)
      then aValuedControl.SetDefault;
    end;


    procedure   TFormWren.KnobChangeLock( const aKnob: TKnobsKnob);
    begin
      if   Assigned( aKnob)
      then aKnob.Locked := not aKnob.Locked;
    end;


    procedure   TFormWren.KnobToggleRandomization( const aControl: IKnobsVariation);
    begin
      if   Assigned( aControl)
      then aControl.AllowRandomization := not aControl.AllowRandomization;
    end;


    procedure   TFormWren.SetRandomKnobValue( const aControl: IKnobsVariation);
    begin
      if   Assigned( aControl      )
      and  Assigned( PatchEditor   )
      and  Assigned( FormRandomizer)
      then aControl.SetRandomValue( FormRandomizer.RandomAmount, ActiveVariation);
    end;


    procedure   TFormWren.AssignMidiCC( const aValuedControl: TKnobsValuedControl);
    begin
      if   Assigned( FormSelectMidiCC)
      then begin
        if   Assigned( aValuedControl)
        and  ( aValuedControl.AllowAutomation)
        then begin
          with FormSelectMidiCC
          do begin
            if   Execute( MakeMidiCCName( aValuedControl), aValuedControl.AssignedMIDICC, aValuedControl)
            then begin
              if   Assigned( PatchEditor)
              then PatchEditor.UnassignMidiCC( MidiCC);

              aValuedControl.AssignedMIDICC := MidiCC;
            end;
          end;
        end;
      end;
    end;


    procedure   TFormWren.AssignLastCCToKnob( const aValuedControl: TKnobsValuedControl);
    var
      aName : string;
    begin
      if   Assigned( FormSelectMidiCC)
      and  Assigned( aValuedControl  )
      then begin
        aName := MakeMidiCCName( aValuedControl);
        FormSelectMidiCC.RegisterControlName( FLastFrozenCC, aName, aValuedControl);

        if   Assigned( PatchEditor)
        then PatchEditor.UnassignMidiCC( FLastFrozenCC);

        aValuedControl.AssignedMIDICC := FLastFrozenCC;
      end;
    end;


    procedure   TFormWren.UnAssignMidiCC( const aValuedControl: TKnobsValuedControl);
    begin
      if   Assigned( FormSelectMidiCC)
      and  Assigned( aValuedControl  )
      then begin
        FormSelectMidiCC.UnregisterCC( aValuedControl.AssignedMIDICC);

        if   Assigned( PatchEditor)
        then PatchEditor.UnassignMidiCC( aValuedControl.AssignedMIDICC);

        aValuedControl.AssignedMIDICC := 0;
      end;
    end;


    procedure   TFormWren.ViewMIDIAssignments;
    begin
      if   Assigned( FormSelectMidiCC)
      then FormSelectMidiCC.View;
    end;


    procedure   TFormWren.ViewHideRandomizer;
    begin
      if   Assigned( FormRandomizer)
      then begin
        if   FormRandomizer.Visible
        then FormRandomizer.Close
        else FormRandomizer.View;
      end;
    end;


    procedure   TFormWren.LoadPatchPreset;
    begin
      try
        PatchEditor.SelectAllModules;

        with OpenDialogPreset
        do begin
          FileName   := ChangeFileExt( ExtractFileName( PatchEditor.Filename), EXT_PRESET);
          InitialDir := TemplateFolder;

          if   Execute
          then begin
            TemplateFolder := ExtractFilePath( FileName);
            FPatchReader.WarnOnStructMismatch := Self.WarnOnStructMismatch;
            FPatchReader.ParamsFromFile( FileName, PatchEditor, DO_STRICT);
          end;
        end;
      finally
        PatchEditor.UnSelectAllModules;
      end;
    end;


    procedure   TFormWren.SavePatchPreset;
    begin
      try
        PatchEditor.SelectAllModules;

        with SaveDialogPreset
        do begin
          FileName   := ChangeFileExt( ExtractFileName( PatchEditor.Filename), EXT_PRESET);
          InitialDir := TemplateFolder;

          if   Execute
          then begin
            TemplateFolder := ExtractFilePath( FileName);

            try
              FPatchWriter.WriteFile( PatchEditor, FileName, wmParams);
            except
              on E: Exception
              do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ FileName, E.ToString]);
            end;
          end;
        end;
      finally
        PatchEditor.UnSelectAllModules;
      end;
    end;


    procedure   TFormWren.LoadPreset( aModule: TKnobsCustomModule);
    begin
      if   Assigned( aModule)
      then begin
        with OpenDialogPreset
        do begin
          if   aModule.TemplateName <> ''
          then begin
            FileName   := ChangeFileExt( ExtractFileName( aModule.TemplateName), EXT_PRESET);
            InitialDir := ExtractFilePath( aModule.TemplateName);
          end
          else begin
            FileName   := ChangeFileExt( aModule.Title, EXT_PRESET);
            InitialDir := TemplateFolder;
          end;

          if   Execute
          then begin
            aModule.FixSelection;
            aModule.TemplateName := FileName;
            TemplateFolder       := ExtractFilePath( FileName);
            FPatchReader.WarnOnStructMismatch := Self.WarnOnStructMismatch;
            FPatchReader.ParamsFromFile( FileName, PatchEditor, DO_STRICT);
          end;
        end;
      end;
    end;


    procedure   TFormWren.SavePreset( aModule: TKnobsCustomModule);
    begin
      if   Assigned( aModule)
      then begin
        with SaveDialogPreset
        do begin
          if   aModule.TemplateName <> ''
          then begin
            FileName   := ChangeFileExt( ExtractFileName( aModule.TemplateName), EXT_PRESET);
            InitialDir := ExtractFilePath( aModule.TemplateName);
          end
          else begin
            FileName   := ChangeFileExt( aModule.Title, EXT_PRESET);
            InitialDir := TemplateFolder;
          end;

          if   Execute
          then begin
            aModule.FixSelection;
            aModule.TemplateName := FileName;
            TemplateFolder       := ExtractFilePath( FileName);

            try
              FPatchWriter.WriteFile( PatchEditor, FileName, wmParams);
            except
              on E: Exception
              do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ FileName, E.ToString]);
            end;
          end;
        end;
      end;
    end;


//  private

    procedure   TFormWren.SetUseConfigHints( aValue: Boolean);
    begin
      if   aValue <> FUseConfigHints
      then begin
        FUseConfigHints                := aValue;
        CheckBoxUseConfigHints.Checked := aValue;
        TabSheetSettings.ShowHint      := aValue;
        TabSheetGraphs  .ShowHint      := aValue;
        TabSheetDebug   .ShowHint      := aValue;
        PanelControl    .ShowHint      := aValue;
      end;
    end;


    procedure   TFormWren.SetUseModuleTitleHints( aValue: Boolean);
    begin
      if   aValue <> FUseModuleTitleHints
      then begin
        FUseModuleTitleHints                := aValue;
        CheckBoxUseModuleTitleHints.Checked := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.UseTitleHints := aValue;
      end;
    end;


    procedure   TFormWren.SetWireThickness( aValue: Integer);
    begin
      aValue := Clip( aValue, 0, 6);

      if   aValue <> FWireThickness
      then begin
        FWireThickness := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.WireThickness := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.WireThickness := aValue;

        UpDownWireThickness1.Position := aValue;
        UpDownWireThickness2.Position := aValue;
      end;
    end;


    procedure   TFormWren.SetCurvedLines( aValue: Boolean);
    begin
      if   aValue <> FCurvedLines
      then begin
        FCurvedLines := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.CurvedLines := aValue;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.CurvedLines := aValue;

        CheckBoxCurvedLines.Checked  := aValue;
      end;
    end;


    procedure   TFormWren.SetControlMode( aValue: TDistanceMode);
    begin
      if   aValue <> FControlMode
      then begin
        FControlMode := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.ControlMode := FControlMode;

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.ControlMode := FControlMode;

        if   Assigned( FormSelectMidiCC)
        then FormSelectMidiCC.ControlMode := FControlMode;

        if  Assigned( FormRandomizer)
        then FormRandomizer.ControlMode := FControlMode;

        FixLocalControls;
        RadioGroupControlMode.ItemIndex := Integer( FControlMode);
      end;
    end;


    procedure   TFormWren.SetLightsRate( aValue: TSignal);
    begin
      aValue := UnitsToLfoFastFrequency( aValue);
      PClip( aValue, 0.254, 401.8);

      if   ( aValue <> FLightsRate)
      and  Assigned( TimerLightsUpdate)
      then begin
        FLightsRate := aValue;
        TimerLightsUpdate.Interval := Round( 1000 / aValue);
      end;
    end;


    procedure   TFormWren.SetReferenceA( aValue: TSignal);
    begin
      if   aValue <> FReferenceA
      then begin
        LogFmt( LC_GENERAL, 'Setting reference A to %g', [ aValue]);
        FReferenceA := aValue;
        EditReferenceA.Text := Format( '%g', [ aValue], AppLocale);
        TuningChanged := True;
      end;
    end;


    procedure   TFormWren.SetNotesPerOctave( aValue: TSignal);
    begin
      if   aValue <> FNotesPerOctave
      then begin
        LogFmt( LC_GENERAL, 'Setting notes/oct to %g', [ aValue]);
        FNotesPerOctave := aValue;
        EditNotesPerOctave.Text := Format( '%g', [ aValue], AppLocale);
        TuningChanged := True;
      end;
    end;


    procedure   TFormWren.SetMiddleNote( aValue: TSignal);
    begin
      if   aValue <> FMiddleNote
      then begin
        LogFmt( LC_GENERAL, 'Setting middle note to %g', [ aValue]);
        FMiddleNote := aValue;
        EditMiddleNote.Text := Format( '%g', [ aValue], AppLocale);
        TuningChanged := True;
      end;
    end;


    procedure   TFormWren.SetOctaveSpan( aValue: TSignal);
    begin
      if   aValue <> FOctaveSpan
      then begin
        LogFmt( LC_GENERAL, 'Setting octave span to %g', [ aValue]);
        FOctaveSpan := aValue;
        EditOctaveSpan.Text := Format( '%g', [ aValue], AppLocale);
        TuningChanged := True;
      end;
    end;


    procedure   TFormWren.SetResetOnRender( aValue: Boolean);
    begin
      if   aValue <> FResetOnRender
      then begin
        FResetOnRender                := aValue;
        CheckBoxResetOnRender.Checked := aValue;
      end;
    end;


    function    TFormWren.GetTitleFont: TFont;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.TitleFont
      else Result := nil;
    end;


    procedure   TFormWren.SetTitleFont( const aValue: TFont);
    begin
      if   Assigned( aValue)
      then begin
        if   Assigned( FormStore)
        then FormStore.TitleFont := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.SetTitleFont( FormStore.TitleFont);

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.SetTitleFont( FormStore.TitleFont);
      end;
    end;


    function    TFormWren.GetModuleFont: TFont;
    begin
      if   Assigned( FormStore)
      then Result := FormStore.ModuleFont
      else Result := nil;
    end;


    procedure   TFormWren.SetModuleFont( const aValue: TFont);
    begin
      if   Assigned( aValue)
      then begin
        if   Assigned( FormStore)
        then FormStore.ModuleFont := aValue;

        if   Assigned( PatchEditor)
        then PatchEditor.SetModuleFont( FormStore.ModuleFont);

        if   Assigned( KnobsWirePanelLooks)
        then KnobsWirePanelLooks.SetModuleFont( FormStore.ModuleFont);
      end;
    end;


    procedure   TFormWren.SetShowTopPane( aValue: Boolean);
    begin
      if   aValue <> FShowTopPane
      then begin
        FShowTopPane            := aValue;
        PanelEditorTop .Visible := ShowTopPane;
        MenuEditFind   .Enabled := ShowTopPane and ( SearchPatch or SearchSelector);
        MenuViewTopPane.Checked := ShowTopPane;
      end;
    end;


//  private

    procedure   TFormWren.SetSynthNameInCaption( aValue: Boolean);
    begin
      if   aValue <> FSynthNameInCaption
      then begin
        FSynthNameInCaption                := aValue;
        CheckBoxSynthNameInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetPatchChangedInCaption( aValue: Boolean);
    begin
      if   aValue <> FPatchChangedInCaption
      then begin
        FPatchChangedInCaption                := aValue;
        CheckBoxPatchChangedInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetProfiledInCaption( aValue: Boolean);
    begin
      if   aValue <> FProfiledInCaption
      then begin
        FProfiledInCaption                := aValue;
        CheckBoxProfiledInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetAudioStatusInCaption( aValue: Boolean);
    begin
      if   aValue <> FAudioStatusInCaption
      then begin
        FAudioStatusInCaption                := aValue;
        CheckBoxAudioStatusInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetProgramNameInCaption( aValue: Boolean);
    begin
      if   aValue <> FProgramNameInCaption
      then begin
        FProgramNameInCaption                := aValue;
        CheckBoxProgramNameInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetFileVersionInCaption( aValue: Boolean);
    begin
      if   aValue <> FFileVersionInCaption
      then begin
        FFileVersionInCaption                := aValue;
        CheckBoxFileVersionInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetPatchNameInCaption( aValue: Boolean);
    begin
      if   aValue <> FPatchNameInCaption
      then begin
        FPatchNameInCaption                := aValue;
        CheckBoxPatchNameInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetSourceNameInCaption( aValue: Boolean);
    begin
      if   aValue <> FSourceNameInCaption
      then begin
        FSourceNameInCaption                := aValue;
        CheckBoxSourceNameInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


    procedure   TFormWren.SetGuidInCaption( aValue: Boolean);
    begin
      if   aValue <> FGuidInCaption
      then begin
        FGuidInCaption                := aValue;
        CheckBoxGuidInCaption.Checked := aValue;
        UpdateCaptions;
      end;
    end;


//  private

    procedure   TFormWren.DoDesignerLog( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    begin
      Log( aLogClass, aMsg);
    end;


    procedure   TFormWren.DoWirePanelLog( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    begin
      Log( aLogClass, aMsg);
    end;


    procedure   TFormWren.DoHistoryChanged( const aSender: TObject; anUndoCount, aRedoCount, aSavedMarker: Integer);
    begin
      MenuEditUndo.Enabled := anUndoCount  > 0;
      MenuEditRedo.Enabled := aRedoCount   > 0;
      PatchChanged         := anUndoCount <> aSavedMarker;
    end;


    procedure   TFormWren.DoShowHint( var aHintStr: string; var CanShow: Boolean; var aHintInfo: Vcl.Controls.THintInfo);
    begin
      if   Pos( '~', aHintStr) > 0
      then aHintInfo.HintWindowClass := TKnobsHintWindow
      else aHintInfo.HintWindowClass := TKnobsSimpleHintWindow;
    end;


    function    TFormWren.DoCreateModuleBitmap( const aModuleType: TKnobsModuleType; UseCache: Boolean): TBitmap;
    var
      aModuleTypeName : string;
      anImageFileName : string;
      aJPEGImg        : TJPEGImage;
    begin

      // When help docs for the correct program version were created before and an image file is actually present
      // use that image file.

      aModuleTypeName := FormStore.BitmapName( aModuleType);
      anImageFileName := Format( '%s\images\%s', [ DocsPath, aModuleTypeName], AppLocale);

      if   UseCache
      and  FileExists( anImageFileName)
      then begin
        aJPEGImg := TJPEGImage.Create;

        try
          aJPEGImg.LoadFromFile( anImageFileName);
          Result := TBitmap.Create;
          Result.Assign( aJPEGImg);
        finally
          aJPEGImg.DisposeOf;
        end;
      end
      // and otherwise just create a (more basic) image.
      else Result := FormStore.CreateModuleBitmap( aModuleType);
    end;


    function    TFormWren.DoReadModuleComment( const aModuleType: TKnobsModuleType): string;
    begin
      Result := FormStore.ReadModuleComment( aModuleType);
    end;


    procedure   TFormWren.DoPopupEditorShow( const aSender: TObject);
    begin
      FLastWiresVisible := WiresOff;
    end;


    procedure   TFormWren.DoPopupEditorHide( const aSender: TObject);
    begin
      WiresOn( FLastWiresVisible);
    end;


    procedure   TFormWren.DoValueChanged( const aSender: TObject; const aPath, aControlType: string; aValue: TSignal; IsFinal, IsAutomation: Boolean);
    // An editor module's control changed value, to be reflected in a synth setting
    var
      aPrefix        : string;
      aFullname      : string;
      aValuedControl : TKnobsValuedControl;
    begin
      if   Assigned( FSynthPatch)
      then begin
        if   IsFinal or IsAutomation
        then begin
          if   aSender is TKnobsValuedControl
          then aValuedControl := TKnobsValuedControl( aSender)
          else aValuedControl := nil;

          HandleSpecialValues( aPath, aControlType, aValue, aValuedControl); // Handle some special cases here - stuff in the editor may need change
          RegisterRandomParams;
        end;

        ParsePrefix( aPath, aPrefix, aFullname);                     // Parse off the container prefix - and ignore that.

        if   IsAutomation
        then FSynthPatch.AcceptAutomationParam( aFullname, aValue)   // Pass on the value to the Synth as an automation
        else FSynthPatch.AcceptParam          ( aFullname, aValue);  // Pass on the value to the Synth as a user action
      end;
    end;


    procedure   TFormWren.DoTextChanged( const aSender: TObject; const aPath, aValue: string);
    // An editor module's text control changed value, to be reflected in a synth setting
    // These changes are assumed to always be 'final' - i.e. 'inbetween' edits should
    // not make it to here. Text changes can be automated .. for a grid for instance or graph thingies
    var
      aPrefix        : string;
      aRest          : string;
      aModuleName    : string;
      aFullParamName : string;
      aModuleIndex   : Integer;
      aModule        : TMod;
      aParts         : TStringList;
    begin
      if   Assigned( FSynthPatch)
      then begin
        ParsePrefix( aPath, aPrefix, aRest);                   // Parse off the container prefix - and ignore that.
        ParsePrefix( aRest, aModuleName, aFullParamName);
        aModuleIndex := FSynthPatch.FindModule( aModuleName);

        if   aModuleIndex >= 0
        then begin
          aModule := FSynthPatch.Module[ aModuleIndex];

          if   Assigned( aModule)
          then begin

            if   ( aModule is TModTextSequencer) and SameText( aFullParamName, 'textsequencer_values')
            then TModTextSequencer( aModule).SetStepValues( ParseTextSequencerValue( aValue))
            else if
              (( aModule is TModWavePlayer  ) and SameText( aFullParamName, 'waveplayer_fileselector_filename' )) or
              (( aModule is TModCsvData     ) and SameText( aFullParamName, 'csvdata_fileselector_filename'    )) or
              (( aModule is TModMidiPlayer  ) and SameText( aFullParamName, 'midiplayer_fileselector_filename' )) or
              (( aModule is TModTextWriter  ) and SameText( aFullParamName, 'textwriter_fileselector_filename' )) or
              (( aModule is TModPad         ) and SameText( aFullParamName, 'pad_fileselector_filename'        )) or
              (( aModule is TModSwanSong    ) and SameText( aFullParamName, 'swansong_fileselector_filename'   )) or
              (( aModule is TModScala       ) and SameText( aFullParamName, 'scala_fileselector_mapping'       )) or
              (( aModule is TModScala       ) and SameText( aFullParamName, 'scala_fileselector_scale'         )) or
              (( aModule is TModMorse       ) and SameText( aFullParamName, 'morse_display_text'               )) or
              (( aModule is TModTSS         ) and SameText( aFullParamName, 'tss_display_text'                 )) or
              (( aModule is TModSong        ) and SameText( aFullParamName, 'song_display_text'                )) or
              (( aModule is TModSapiVoice   ) and SameText( aFullParamName, 'sapivoice_display_text'           )) or
              (( aModule is TModESpeakVoice ) and SameText( aFullParamName, 'espeakvoice_display_text'         )) or
              (( aModule is TModOscMessage  ) and SameText( aFullParamName, 'oscmessage_display_address'       )) or
              (( aModule is TModTextWriter  ) and SameText( aFullParamName, 'textwriter_display_text'          )) or
              (( aModule is TModValues      ) and SameText( aFullParamName, 'values_display_values'            )) or
              (( aModule is TModMidiSysexOut) and SameText( aFullParamName, 'midisysexout_display_message'     )) or
              (( aModule is TModSeqValues   ) and SameText( aFullParamName, 'seqvalues_valuedata'              )) or
              (( aModule is TModSeqValues   ) and SameText( aFullParamName, 'seqvalues_espdata'                )) or
              (( aModule is TModLifeSeq     ) and SameText( aFullParamName, 'lifeseq_grid'                     )) or
              (( aModule is TModLifeSeq     ) and SameText( aFullParamName, 'lifeseq_stops'                    )) or
              (( aModule is TModSmallLifeSeq) and SameText( aFullParamName, 'smalllifeseq_grid'                )) or
              (( aModule is TModSmallLifeSeq) and SameText( aFullParamName, 'vitaphobium_grid'                 )) or
              (( aModule is TModSeqPattern  ) and SameText( aFullParamName, 'seqpattern_bitdata'               )) or
              (( aModule is TModSeqPattern  ) and SameText( aFullParamName, 'seqpattern_espdata'               ))
            then begin
              aModule.StringValue[ ParsePostfix( aFullParamName)] := aValue;
            end
            else if
              (( aModule is TModDataGraph   ) and SameText( aFullParamName, 'datagraph_data'                   )) or
              (( aModule is TModAudioGraph  ) and SameText( aFullParamName, 'audiograph_data'                  ))
            then begin
              aModule.StringValue[ ParsePostfix( aFullParamName)] := aValue;
              RegisterRandomParams;
            end
            else if
              ( aModule is TModRewriter     ) or
              ( aModule is TModRewriterNote ) or
              ( aModule is TModTuneSmithy   )
            then begin
              aParts := Explode( aFullParamName, '_');

              try
                if   ( aParts.Count = 3)
                and  SameText( aParts[ 1], 'display')
                then aModule.StringValue[ aParts[ 2]] := aValue;
              finally
                aParts.DisposeOf;
              end;
            end

            else begin
              aParts := Explode( aFullParamName, '_');

              try
                if   ( aParts.Count = 3)
                and  SameText( aParts[ 1], 'display')
                then begin
                  if   aSender is TKnobsValuedControl
                  then aModule.InternalStringValue[ TKnobsValuedControl( aSender).ControlType, aParts[ 2]] := aValue
                  else aModule.InternalStringValue[ ''                                       , aParts[ 2]] := aValue;   // Which can set both a param value or an internal value
                end;
              finally
                aParts.DisposeOf;
              end;
            end;
          end;
        end;
      end;
    end;


//  private

    function    TFormWren.SplitValueInfo( const aPath: string; var aModule: TKnobsCustomModule; var aModuleType, aSignalName: string): Boolean;
    var
      aParts      : TStringList;
      bParts      : TStringList;
      aModuleName : string;
      aMod        : TKnobsCustomModule;
    begin
      Result      := False;
      aModule     := nil;
      aModuleType := '';
      aSignalName := '';
      aParts := Explode( aPath, '/');

      try
        if   aParts.Count >= 2
        then begin
          aModuleName := aParts[ aParts.Count - 2];
          aMod        := PatchEditor.FindModule( aModuleName);

          if   Assigned( aMod)
          then begin
            aSignalName := aParts[ aParts.Count - 1];
            bParts      := Explode( aSignalName, '_');

            try
              if   bParts.Count = 2
              then begin
                aModuleType := bParts[ 0];
                aSignalName := bParts[ 1];
                aModule     := aMod;
                Result      := True;
              end;
            finally
              bParts.DisposeOf;
            end;
          end;
        end;
      finally
        aParts.DisposeOf;
      end;
    end;


    procedure   TFormWren.HandleSpecialValues( const aPath, aControlType: string; aValue: TSignal; const anOrigin: TKnobsValuedControl);
    var
      aPostFix    : string;
      aModule     : TKnobsCustomModule;
      aModuleType : string;
      aSignalName : string;
    begin
      if   SplitValueInfo( aPath, aModule, aModuleType, aSignalName)
      then begin
        aPostFix := ParsePostFix( aPath);

        if
          SameText( aPostFix, 'range'      ) or
          SameText( aPostFix, 'arange'     ) or
          SameText( aPostFix, 'hrange'     ) or
          SameText( aPostFix, 'drange'     ) or
          SameText( aPostFix, 'delay'      ) or
          SameText( aPostFix, 'delaystereo') or
          SameText( aPostFix, 'rrange'     ) or
          SameText( aPostFix, 'clr'        ) or
          SameText( aPostFix, 'rnd'        ) or
          SameText( aPostFix, 'rndone'     ) or
          SameText( aPostFix, 'rndf'       ) or
          SameText( aPostFix, 'rndq'       ) or
          SameText( aPostFix, 'rnda'       ) or
          SameText( aPostFix, 'clr'        ) or
          SameText( aPostFix, 'voice'      )
        then ChangeRangeFor( aModule, aModuleType, aPostFix, aValue, anOrigin)
        else if
          SameText( aPostFix, 'mode'       ) or
          SameText( aPostFix, 'mode1'      ) or
          SameText( aPostFix, 'mode2'      ) or
          SameText( aPostFix, 'mode3'      ) or
          SameText( aPostFix, 'mode4'      ) or
          SameText( aPostFix, 'lock'       ) or
          SameText( aPostFix, 'lockxy'     ) or
          SameText( aPostFix, 'valmode'    )
        then ChangeModeFor( aModule, aModuleType, aPostFix, aValue);
      end;
    end;


    procedure   TFormWren.ChangeRangeFor( const aModule: TKnobsCustomModule; const aModuleType, aRangeType: string; aValue: TSignal; const anOrigin: TKnobsValuedControl);
    // This is meant to be used when a range value for a module changes, it is used to dynamically alter
    // control types for knobs affected by the curent range.
    var
      aKnob       : TKnobsKnob;
      aSelector   : TKnobsSelector;
      aKnobName   : string;
      i           : Integer;
      p           : Integer;
      anEnvRange  : TEnvRange;
      anLfoRange  : TLfoRange;
      aDelayRange : TDelayRange;
    begin
      if   Assigned( aModule)
      then begin
        with aModule
        do begin

          if   SameText( aModuleType, 'envahd'    )
          or   SameText( aModuleType, 'envadsr'   )
          or   SameText( aModuleType, 'pulsedelay')
          then begin
            anEnvRange := SignalToEnvRange( aValue);

            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob     := TKnobsKnob( Controls[ i]);
                aKnobName := aKnob.Name;

                if   ( SameText( aKnobName, 'envahd_attack'   ) and SameText( aRangeType, 'arange'))
                or   ( SameText( aKnobName, 'envahd_hold'     ) and SameText( aRangeType, 'hrange'))
                or   ( SameText( aKnobName, 'envahd_decay'    ) and SameText( aRangeType, 'drange'))
                or   ( SameText( aKnobName, 'envadsr_attack'  ) and SameText( aRangeType, 'arange'))
                or   ( SameText( aKnobName, 'envadsr_decay'   ) and SameText( aRangeType, 'drange'))
                or   ( SameText( aKnobName, 'envadsr_release' ) and SameText( aRangeType, 'rrange'))
                or   ( SameText( aKnobName, 'pulsedelay_delay') and SameText( aRangeType, 'range' ))
                then begin
                  if   aModule.IsSpedUp
                  then begin
                    case anEnvRange of
                      erFast   : ChangeControlTypeTo( aKnob, 'EnvTimeFastAr'  );
                      erMedium : ChangeControlTypeTo( aKnob, 'EnvTimeMediumAr');
                      erSlow   : ChangeControlTypeTo( aKnob, 'EnvTimeSlowAr'  );
                    end;
                  end
                  else begin
                    case anEnvRange of
                      erFast   : ChangeControlTypeTo( aKnob, 'EnvTimeFast'  );
                      erMedium : ChangeControlTypeTo( aKnob, 'EnvTimeMedium');
                      erSlow   : ChangeControlTypeTo( aKnob, 'EnvTimeSlow'  );
                    end;
                  end;
                end;
              end;
            end;
          end

          else if
            SameText( aModuleType, 'lfo'           ) or
            SameText( aModuleType, 'lfomultiphase' ) or
            SameText( aModuleType, 'squarelfo'     ) or
            SameText( aModuleType, 'squaresinelfo' ) or
            SameText( aModuleType, 'lfotrig'       ) or
            SameText( aModuleType, 'squarelfotrig' ) or
            SameText( aModuleType, 'randsig'       ) or
            SameText( aModuleType, 'randsigs'      ) or
            SameText( aModuleType, 'randomwalklfo' ) or
            SameText( aModuleType, 'attractorLfo'  ) or
            SameText( aModuleType, 'vanderpolLfo'  ) or
            SameText( aModuleType, 'logisticmaplfo') or
            SameText( aModuleType, 'pulses'        )
          then begin
            anLfoRange := SignalToLfoRange( aValue);

            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob     := TKnobsKnob( Controls[ i]);
                aKnobName := aKnob.Name;

                if   SameText( aKnobName, 'lfo_frequency'           )
                or   SameText( aKnobName, 'lfomultiphase_frequency' )
                or   SameText( aKnobName, 'lfotrig_frequency'       )
                or   SameText( aKnobName, 'squarelfo_frequency'     )
                or   SameText( aKnobName, 'squaresinelfo_frequency' )
                or   SameText( aKnobName, 'squarelfotrig_frequency' )
                or   SameText( aKnobName, 'randsig_frequency'       )
                or   SameText( aKnobName, 'randsigs_frequency'      )
                or   SameText( aKnobName, 'randomwalklfo_frequency' )
                or   SameText( aKnobName, 'attractorlfo_frequency'  )
                or   SameText( aKnobName, 'vanderpollfo_frequency'  )
                or   SameText( aKnobName, 'logisticmaplfo_frequency')
                or   SameText( aKnobName, 'pulses_frequency'        )
                then begin
                  case anLfoRange of
                    lsFast    : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseFast'   );
                    lsMedium  : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseMedium' );
                    lsSlow    : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseSlow'   );
                    lsBPM     : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseBPM'    );
                    lsLin     : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseLin'    );
                    lsFast2   : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseFast2'  );
                    lsMedium2 : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseMedium2');
                    lsSlow2   : ChangeControlTypeTo( aKnob, 'LfoFreqCoarseSlow2'  );
                  end;
                end
              end;
            end;
          end

          else if
            SameText( aModuleType, 'delay'           ) or
            SameText( aModuleType, 'delaystereo'     ) or
            SameText( aModuleType, 'delaymod'        ) or
            SameText( aModuleType, 'delay8'          ) or
            SameText( aModuleType, 'simplegranulator') or
            SameText( aModuleType, 'granulator'      ) or
            SameText( aModuleType, 'rndgranulator'   ) or
            SameText( aModuleType, 'looper'          ) or
            SameText( aModuleType, 'stereolooper'    )
          then begin
            aDelayRange := SignalToDelayRange( aValue);

            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob     := TKnobsKnob( Controls[ i]);
                aKnobName := aKnob.Name;

                if   SameText( aKnobName, 'delay_length'              )
                or   SameText( aKnobName, 'delaystereo_length'        )
                or   SameText( aKnobName, 'delaymod_length'           )
                or   SameText( aKnobName, 'delay8_length'             )
                or   SameText( aKnobName, 'simplegranulator_delaytime')
                or   SameText( aKnobName, 'granulator_delaytime'      )
                or   SameText( aKnobName, 'rndgranulator_delaytime'   )
                or   SameText( aKnobName, 'looper_length'             )
                or   SameText( aKnobName, 'stereolooper_length'       )
                then begin
                  case aDelayRange of
                    dsShort  : ChangeControlTypeTo( aKnob, 'DelayTimeShort' );
                    dsMedium : ChangeControlTypeTo( aKnob, 'DelayTimeMedium');
                    dsLong   : ChangeControlTypeTo( aKnob, 'DelayTimeLong'  );
                  end;
                end;
              end;
            end;
          end

          else if
            SameText( aModuleType, 'sequencer'   ) or
            SameText( aModuleType, 'gateseq'     ) or
            SameText( aModuleType, 'leakygateseq') or
            SameText( aModuleType, 'seq16'       ) or
            SameText( aModuleType, 'vcps'        ) or
            SameText( aModuleType, 'lut'         ) or
            SameText( aModuleType, 'multicompare')
          then begin
            p := Random( Round( aValue));

            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                if   aKnob.Tag = 1
                then begin
                  if SameText( aRangeType, 'rnd')
                  and  not aKnob.Locked
                  then ChangeKnobPositionTo( aKnob, Random( aKnob.StepCount))
                  else if SameText( aRangeType, 'clr')
                  and     not aKnob.Locked
                  then begin
                    if SameText( aKnob.ControlType, 'NoteName')
                    then ChangeKnobPositionTo( aKnob, 69)
                    else ChangeKnobPositionTo( aKnob,  0);
                  end
                  else if SameText( aRangeType, 'rndone')
                  and  not aKnob.Locked
                  then begin
                    if p = 0
                    then ChangeKnobPositionTo( aKnob, Random( aKnob.StepCount));

                    Dec( p);
                  end
                  else if SameText( aRangeType, 'clr')
                  and     not aKnob.Locked
                  then begin
                    if SameText( aKnob.ControlType, 'NoteName')
                    then ChangeKnobPositionTo( aKnob, 69)
                    else ChangeKnobPositionTo( aKnob,  0);
                  end;
                end;
              end
              else if Controls[ i] is TKnobsSelector        // For the gateseq and leakygateseq only, to select gate modes
              then begin
                aSelector := TKnobsSelector( Controls[ i]);

                if   ( aSelector.Tag = 1)
                and  not aSelector.Locked
                then begin
                  if   SameText( aRangeType, 'rnd')
                  then ChangeKnobPositionTo( aSelector, Random( aSelector.StepCount))
                  else if SameText( aRangeType, 'clr')
                  then ChangeKnobPositionTo( aSelector, 0);
                end;
              end;
            end;
          end

          else if
            SameText( aModuleType, 'modal')
          then begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                if   SameText( aRangeType, 'rndf')          // Random frequency
                then begin
                  if   aKnob.Tag = 1
                  then ChangeKnobPositionTo( aKnob, aKnob.StepCount div 4 + Random( aKnob.StepCount div 2));
                end
                else if SameText( aRangeType, 'rndq')       // Random Q
                then begin
                  if   aKnob.Tag = 2
                  then ChangeKnobPositionTo( aKnob, aKnob.StepCount div 2 + Random( aKnob.StepCount div 2 - 3));
                end
                else if SameText( aRangeType, 'rnda')       // Random amplitude
                then begin
                  if   aKnob.Tag = 3
                  then ChangeKnobPositionTo( aKnob, 3 * aKnob.StepCount div 4 + Random( aKnob.StepCount div 4));
                end;
              end;
            end;
          end

          else if
            SameText( aModuleType, 'probsequencer')
          then begin
            for i := 0 to ControlCount - 1
            do begin
              if   SameText( aRangeType, 'rnd')
              then begin
                if   Controls[ i] is TKnobsSlider
                then begin
                  aKnob := TKnobsKnob( Controls[ i]);

                  if   aKnob.Tag = 1
                  then ChangeKnobPositionTo( aKnob, Random( aKnob.StepCount));
                end;
              end
              else if SameText( aRangeType, 'clr')
                then begin
                if   Controls[ i] is TKnobsSlider
                then begin
                  aKnob := TKnobsKnob( Controls[ i]);

                  if   aKnob.Tag = 1
                  then ChangeKnobPositionTo( aKnob, aKnob.DefaultPosition);
                end;
              end
            end;
          end

          else if SameText( aModuleType, 'espeakvoice')
          then begin
            with aModule
            do begin
              for i := 0 to ControlCount - 1
              do begin
                if   ( Controls[ i] is TKnobsSelector)
                and  ( Controls[ i].Tag = 1)
                then FixESpeakLanguageStatics( Controls[ i], nil, anOrigin);
              end;
            end;
          end

        end;
      end;
    end;


    procedure   TFormWren.ChangeModeFor( const aModule: TKnobsCustomModule; const aModuleType, aModeType: string; aValue: TSignal);
    // This is used when the mode for a control on a mpdule changes, to change the control type
    // of affected controls. Or to change its dynamics ..
    var
      aName     : string;
      aKnob     : TKnobsKnob;
      aSelector : TKnobsSelector;
      aSteps    : Integer;
      i         : Integer;
    begin
      if   Assigned( aModule)
      then begin
        if   SameText( aModuleType, 'scaler')
        then begin
          aKnob := nil;

          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]); // Pick the first Knob found ... it should
                Break;                              // be paired in the designer already.
              end;
            end;
          end;

          if   Assigned( aKnob)
          then ChangePairingModeTo( aKnob, TKnobsPairingMode( Round( aValue)));
        end

        else if SameText( aModuleType, 'mixingscaler')
        then begin
          aKnob := nil;

          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aName := TKnobsKnob( Controls[ i]).Name;

                if   ( SameText( aModeType, 'mode' ) and SameText( aName, 'mixingscaler_gain' ))
                or   ( SameText( aModeType, 'mode2') and SameText( aName, 'mixingscaler_gain2'))
                or   ( SameText( aModeType, 'mode3') and SameText( aName, 'mixingscaler_gain3'))
                or   ( SameText( aModeType, 'mode4') and SameText( aName, 'mixingscaler_gain4'))
                then begin
                  aKnob := TKnobsKnob( Controls[ i]);  // Pick the gain Knob only ... it should be paired
                  Break;                               // with the offset knob in the designer already.
                end;
              end;
            end;
          end;

          if   Assigned( aKnob)
          then ChangePairingModeTo( aKnob, TKnobsPairingMode( Round( aValue)));
        end

        else if SameText( aModuleType, 'xyscope')
        then begin
          aKnob := nil;

          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   ( Controls[ i] is TKnobsKnob)
              and  ( TKnobsKnob( Controls[ i]).Name = 'xyscope_levx')
              then begin
                aKnob := TKnobsKnob( Controls[ i]); // Pick the X level Knob ... it should be paired in the designer already with the Y level one.
                Break;
              end;
            end;
          end;

          if   Assigned( aKnob)
          then ChangePairingModeTo( aKnob, TKnobsPairingMode( Round( aValue)));
        end

        else if SameText( aModuleType, 'hardclip')
        then begin
          aKnob := nil;

          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   ( Controls[ i] is TKnobsKnob)
              and  ( TKnobsKnob( Controls[ i]).Name = 'hardclip_lowlevel')
              then begin
                aKnob := TKnobsKnob( Controls[ i]); // Pick the low level Knob ... it should be paired in the designer already with the high level one.
                Break;
              end;
            end;
          end;

          if   Assigned( aKnob)
          then ChangePairingModeTo( aKnob, TKnobsPairingMode( Round( aValue)));
        end

        else if
          SameText( aModuletype, 'mixm3to1' ) or
          SameText( aModuletype, 'mixm4to1' ) or
          SameText( aModuletype, 'mixs2to1' ) or
          SameText( aModuletype, 'mixs5to1' ) or
          SameText( aModuletype, 'mixt1to1' ) or
          SameText( aModuletype, 'mixq1to1' ) or
          SameText( aModuletype, 'mixm6to6' )
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                case  Round( aValue) of
                  0 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[-1,1]');
                  1 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'dB[0,1]'     );
                  2 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[0,1]' );
                  3 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[0,4]' );
                  4 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[-4,4]');
                  5 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'dB[0,4]'     );
                end;
              end;
            end;
          end;
        end

        else if
          SameText( aModuletype, 'mixm16to1' ) or
          SameText( aModuletype, 'mixmm16to1') or
          SameText( aModuletype, 'mixms8to1' )
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                case Round( aValue) of
                  0 :  ChangeControlTypeTo( aKnob, 'linear[-4,4]');
                  1 :  ChangeControlTypeTo( aKnob, 'dB[0,4]'     );
                  2 :  ChangeControlTypeTo( aKnob, 'linear[-1,1]');
                  3 :  ChangeControlTypeTo( aKnob, 'dB[0,1]'     );
                  4 :  ChangeControlTypeTo( aKnob, 'linear[0,4]' );
                  5 :  ChangeControlTypeTo( aKnob, 'linear[0,1]' );
                end;
              end;
            end;
          end;
        end

        else if SameText( aModuletype, 'amplifier')
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                case  Round( aValue) of
                  0 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[-4,4]');   // 0 : for compatibility with older patches
                  1 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'dB[0,4]'     );   // 1 : for compatibility with older patches
                  2 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[-1,1]');   // 2 : extended : lin -1,1
                  3 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'dB[0,1]'     );   // 3 : extended : dB 0
                  4 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[0,1]' );   // 4 : extended : lin 0,1
                  5 : ChangeControlTypeTo( TKnobsKnob( Controls[ i]), 'linear[0,4]' );   // 5 : extended : lin 0,4
                end;
              end;
            end;
          end;
        end

        else if
          SameText( aModuletype, 'constant'    ) or
          SameText( aModuletype, 'seq16'       ) or
          SameText( aModuleType, 'vcps'        ) or
          SameText( aModuletype, 'lut'         ) or
          SameText( aModuletype, 'rewriternote') or
          SameText( aModuletype, 'seqvalues'   )
        then begin
          with aModule
          do begin
            if
              SameText( aModuletype, 'constant' ) or
              SameText( aModuletype, 'seqvalues')
            then aSteps := 513
            else if
              SameText( aModuletype, 'lut'      )
            then aSteps := 257
            else aSteps := 128;

            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                if   aKnob.Tag = 1
                then begin
                  case Round( aValue) of
                    0 :  begin ChangeControlTypeTo( aKnob, 'linear[-4,4]'); ChangeStepCountTo( aKnob, aSteps); end; // 0 : for compatibility with older patches
                    1 :  begin ChangeControlTypeTo( aKnob, 'dB[0,4]'     ); ChangeStepCountTo( aKnob, aSteps); end; // 1 : for compatibility with older patches
                    2 :  begin ChangeControlTypeTo( aKnob, 'linear[-1,1]'); ChangeStepCountTo( aKnob, aSteps); end;
                    3 :  begin ChangeControlTypeTo( aKnob, 'dB[0,1]'     ); ChangeStepCountTo( aKnob, aSteps); end;
                    4 :  begin ChangeControlTypeTo( aKnob, 'linear[0,4]' ); ChangeStepCountTo( aKnob, aSteps); end;
                    5 :  begin ChangeControlTypeTo( aKnob, 'linear[0,1]' ); ChangeStepCountTo( aKnob, aSteps); end;
                    else begin ChangeControlTypeTo( aKnob, 'NoteName'    ); ChangeStepCountTo( aKnob,    128); end;
                  end;
                end;
              end;
            end;
          end;
        end

        else if
          SameText( aModuletype, 'knobs4' )
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   Controls[ i] is TKnobsKnob
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                if   (( aKnob.Tag = 1) and SameText( aModeType, 'mode1'))
                or   (( aKnob.Tag = 2) and SameText( aModeType, 'mode2'))
                or   (( aKnob.Tag = 3) and SameText( aModeType, 'mode3'))
                or   (( aKnob.Tag = 4) and SameText( aModeType, 'mode4'))
                then begin
                  case Round( aValue) of
                    0 :  begin ChangeControlTypeTo( aKnob, 'linear[-4,4]'); ChangeStepCountTo( aKnob, 1025); end;
                    1 :  begin ChangeControlTypeTo( aKnob, 'dB[0,4]'     ); ChangeStepCountTo( aKnob, 1025); end;
                    2 :  begin ChangeControlTypeTo( aKnob, 'linear[-1,1]'); ChangeStepCountTo( aKnob, 1025); end;
                    3 :  begin ChangeControlTypeTo( aKnob, 'dB[0,1]'     ); ChangeStepCountTo( aKnob, 1025); end;
                    4 :  begin ChangeControlTypeTo( aKnob, 'linear[0,4]' ); ChangeStepCountTo( aKnob, 1025); end;
                    5 :  begin ChangeControlTypeTo( aKnob, 'linear[0,1]' ); ChangeStepCountTo( aKnob, 1025); end;
                    else begin ChangeControlTypeTo( aKnob, 'NoteName'    ); ChangeStepCountTo( aKnob,  128); end;
                  end;
                end;
              end;
            end;
          end;
        end

        else if
          SameText( aModuletype, 'seqpattern') or
          SameText( aModuletype, 'seqvalues' )
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   ( Controls[ i].Tag = 1)
              and  ( Controls[ i] is TKnobsSelector)
              then begin
                aSelector := TKnobsSelector( Controls[ i]);

                if   Round( aValue) = 0
                then begin aSelector.Glyphs := FormStore.ImageListDotsGreen ; aSelector.Invalidate; end
                else begin aSelector.Glyphs := FormStore.ImageListDotsYellow; aSelector.Invalidate; end;
              end;
            end;
          end;
        end

        else if
          SameText( aModuletype, 'quantizer' ) or
          SameText( aModuletype, 'seqrandval')
        then begin
          with aModule
          do begin
            for i := 0 to ControlCount - 1
            do begin
              if   ( Controls[ i].Tag = 1)
              and  ( Controls[ i] is TKnobsKnob)
              then begin
                aKnob := TKnobsKnob( Controls[ i]);

                if   Round( aValue) = 0
                then begin ChangeControlTypeTo( aKnob, 'QSteps'   ); aKnob.FriendlyName := 'Notes';      end
                else begin ChangeControlTypeTo( aKnob, 'Fractions'); aKnob.FriendlyName := 'Fractions';  end;
              end;
            end;
          end;
        end;

      end;
    end;


    procedure   TFormWren.ChangeControlTypeTo( const aControl: TKnobsValuedControl; const aValue: string);
    begin
      aControl.BeginStateChange;

      try
        aControl.ControlType := aValue;
      finally
        aControl.EndStateChange;
      end;
    end;


    procedure   TFormWren.ChangeKnobPositionTo( const aControl: TKnobsValuedControl; const aValue: Integer);
    begin
      aControl.BeginStateChange;

      try
        aControl.KnobPosition := aValue;
      finally
        aControl.EndStateChange;
        aControl.AddToHistory;
      end;
    end;


    procedure   TFormWren.ChangeStepCountTo( const aControl: TKnobsValuedControl; const aValue: Integer);
    begin
      aControl.BeginStateChange;

      try
        aControl.StepCount := aValue;
      finally
        aControl.EndStateChange;
      end;
    end;


    procedure   TFormWren.ChangePairingModeTo( const aKnob: TKnobsKnob; aValue: TKnobsPairingMode);
    begin
      aKnob.BeginStateChange;

      try
        aKnob.PairingMode := aValue;
      finally
        aKnob.EndStateChange;
      end;
    end;


    procedure   TFormWren.SetFileText( const aFileName, aLine: string);
    var
      aFile : TextFile;
    begin
      AssignFile( aFile, aFileName);

      try
        Rewrite( aFile);

        try
          WriteLn( aFile, TextWriterPrefix + aLine);
        finally
          CloseFile( aFile);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoSignals( const aSender: TMod; const anInfo: TLightsInfo);
    // A synth signal to be reflected in a module's valued control or in a
    // datamaker (graph).
    var
      aMod : TKnobsCustomModule;
    begin
      aMod := PatchEditor.FindModule( anInfo.Name);         // Find the module in the editor

      if   Assigned( aMod)
      then aMod.SetSignal( anInfo.Signal, anInfo.Data);
    end;


    procedure   TFormWren.DoLights( const aSender: TMod; const anInfo: TLightsInfo);
    // A synth signal to be reflected in a module light ... or another control ...
    var
      aMod : TKnobsCustomModule;
    begin
      aMod := PatchEditor.FindModule( anInfo.Name);         // Find the module in the editor

      if   Assigned( aMod)
      then aMod.SetLight( anInfo.Signal, anInfo.Data);
    end;


    procedure   TFormWren.DoData( const aSender: TMod; const anInfo: TDataInfo);
    // An array of synth signals to be reflected in a module control in the editor
    var
      aMod : TKnobsCustomModule;
    begin
      aMod := PatchEditor.FindModule( anInfo.Name);         // Find the module in the editor

      if   Assigned( aMod)
      then aMod.SetData( anInfo.Signal, anInfo.Data);
    end;


    procedure   TFormWren.DoXYData( const aSender: TMod; const anInfo: TXYDataInfo);
    // A series of X, Y data points to be sent from a synth module to some
    // graphic control in the editor
    var
      aMod : TKnobsCustomModule;
    begin
      aMod := PatchEditor.FindModule( anInfo.Name);        // Find the module in the editor

      if   Assigned( aMod)
      then aMod.SetXYData( anInfo.Signal, anInfo.Data);
    end;


    procedure   TFormWren.DoStringData( const aSender: TMod; const anInfo: TStringInfo);
    // A synth string signal to be reflected in a module display or grid in the editor
    // can be a file update request too now
    const
      FileMarker = '::text::file::';
    var
      aMod      : TKnobsCustomModule;
      aFileName : string;
    begin
      if   anInfo.Signal.Contains( FileMarker)
      then begin
        aFileName := anInfo.Signal.Substring( FileMarker.Length);
        SetFileText( aFileName, anInfo.Data);
      end
      else begin
        aMod := PatchEditor.FindModule( anInfo.Name);         // Find the module in the editor

        if   Assigned( aMod)
        then aMod.SetInfo( anInfo.Signal, anInfo.Data);
      end;
    end;


    procedure   TFormWren.DoCursorData( const aSender: TMod; const anInfo: TCursorInfo);
    // Cursor tracking from synth patch to a DataMaker or Grid in the editor
    var
      aMod : TKnobsCustomModule;
    begin
      aMod := PatchEditor.FindModule( anInfo.Name);         // Find the module in the editor

      if   Assigned( aMod)
      then aMod.SetCursorData( anInfo.Signal, anInfo.Data);
    end;


    procedure   TFormWren.DoRecompile( const aSender: TKnobsWirePanel; ModulesChanged: Boolean);
    // The patch changed module-, module-type- or wire-wise.
    begin
      CompilePatch( ModulesChanged, True);
    end;


    procedure   TFormWren.DoHistoryItemClicked( aSender: TObject);
    begin
      if   Assigned( FPopupSender)
      and  IsUndoable( FPopupSender)
      and  ( aSender is TMenuItem)
      then ( FPopupSender as IKnobsUndoable).UndoItem( TMenuItem( aSender).Tag);
    end;


    procedure   TFormWren.DoShowPopupMenu( const aSender: TKnobsWirePanel; const aControl: TControl);

      procedure PopUp( aPopUp: TPopupMenu; aControl: TControl);
      var
        aPoint : TPoint;
      begin
        FPopupSender := aControl;
        aPoint := Mouse.CursorPos;
        aPopup.Popup( aPoint.X + 10, aPoint.Y + 10);
      end;

      procedure AddHistoryItems( aMenuItem: TMenuItem; anUndoable: IKnobsUndoable; aMaxItems: Integer);
      var
        aList        : TStringList;
        i            : Integer;
        aSubMenuItem : TMenuItem;
      begin
        if   Assigned( anUndoable)
        then begin
          with aMenuItem
          do begin
            for i := Count - 1 downto 0
            do Delete( i);
          end;

          aMenuItem.Enabled := False;
          aList             := anUndoable.CreateStringList( aMaxItems); // max 36 items - 0 .. 9. A .. Z

          try
            for i := 0 to aList.Count - 1
            do begin
              aSubMenuItem := TMenuItem.Create( aMenuItem);

              with aSubMenuItem
              do begin
                Caption := Format( '%s%s', [ IndexToMenuShortCut( i), aList[ i]], AppLocale);
                Tag     := i;
                OnClick := DoHistoryItemClicked;
                Enabled := True;
              end;

              aMenuItem.Add( aSubMenuItem);
            end;
          finally
            aList.DisposeOf;
          end;

          aMenuItem.Enabled := aMenuItem.Count > 0;
        end;
      end;


      procedure ShowPopupModule( aPopup: TPopupMenu; aControl: TControl);
      var
        aModule    : TKnobsCustomModule;
        Alternates : string;
        aCurrent   : string;
        aType      : Integer;
        aName      : string;
        aList      : TStringList;
        i          : Integer;
        p          : Integer;
      begin
        RemoveModuleAlternateMenuItems;
        aModule    := TKnobsCustomModule( aControl);
        Alternates := aModule.ModuleAlternateTypes;
        aCurrent   := LookupModuleTypeName( aModule.ModuleType);
        aList      := Explode( Alternates, ' ');
        p          := 0;

        try
          try
            for i := 0 to aList.Count - 1
            do begin
              aType := StrToIntDef( aList[ i], -1);

              if   atype >= 0
              then begin
                aName  := LookupModuleTypeName( aType);

                if   aName <> ''
                then begin
                  AddModuleAlternateMenuItem( p, aCurrent, aName, aType);
                  Inc( p);
                end;
              end;
            end;
          finally
            aList.DisposeOf;
          end;
        except
          on E: Exception
          do KilledException( E);
        end;

        MenuItemModuleAlternates             .Enabled := p > 0;
        MenuItemModuleExludeFromRandomization.Checked := not aModule.AllowRandomization;

        if   IsUndoable( aControl)
        then AddHistoryItems( MenuItemModuleHistory, aControl as IKnobsUndoable, MODULE_HISTORY_COUNT);

        PopUp( aPopup, aControl);
      end;


      procedure ShowPopupSelector( aPopup: TPopupMenu; aControl: TControl);
      var
        i         : Integer;
        p         : Integer;
        aMenuItem : TMenuItem;
        anAuto    : IKnobsAutomatable;
        aRand     : IKnobsVariation;
        aSelect   : TKnobsSelector;
      begin
        if   Assigned( aControl)
        and  ( aControl is TKnobsSelector)
        then begin
          aSelect       := TKnobsSelector( aControl);
          p             := 0;
          aPopup.Images := aSelect.Glyphs;
          RemoveSelectorMenuItems;

          if   IsAutomatable( aControl)
          and  Assigned( aSender)
          then begin
            anAuto    := aControl as IKnobsAutomatable;
            aMenuItem := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              if   anAuto.AssignedMIDICC = 0
              then Caption := Format( '%sMIDI CC ...'     , [ IndexToMenuShortCut( p)                       ], AppLocale)
              else Caption := Format( '%sMIDI CC [%d] ...', [ IndexToMenuShortCut( p), anAuto.AssignedMIDICC], AppLocale);

              OnClick := KnobMIDICCClick;
              Enabled := anAuto.AllowAutomation;
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            Inc( p);
            FLastFrozenCC := FlastCC;
            aMenuItem     := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              Caption := Format( '%sAssign CC %d', [ IndexToMenuShortCut( p), FlastFrozenCC], AppLocale);
              OnClick := AssigntoCCClick;
              Enabled := ( FlastCC > 0) and anAuto.AllowAutomation;
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            Inc( p);
            aMenuItem := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              Caption := Format( '%sUnassign CC %d', [ IndexToMenuShortCut( p), anAuto.AssignedMIDICC], AppLocale);
              OnClick := UnassignCCClick;
              Enabled := anAuto.AllowAutomation and ( anAuto.AssignedMIDICC > 0);
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            Inc( p);

            if   p > 0
            then AddSelectorMenuItem( 0, -1, '-');
          end;

          if   IsVariation( aControl)
          and  Assigned( aSender)
          then begin
            aRand     := aControl as IKnobsVariation;
            aMenuItem := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              Caption := Format( '%sRandomize', [ IndexToMenuShortCut( p)], AppLocale);
              OnClick := MenuItemKnobRandomizeClick;
              Enabled := aRand.CanAllowRandomization and aRand.AllowRandomization;
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            Inc( p);

            aMenuItem := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              Caption := Format( '%sExclude from randomization', [ IndexToMenuShortCut( p)], AppLocale);
              Checked := not aRand.AllowRandomization;
              OnClick := ToggleSelectorRandomizationClick;
              Enabled := aRand.CanAllowRandomization;
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            Inc( p);

            AddSelectorMenuItem( 0, -1, '-');
          end;

          if   IsUndoable( aControl)
          and  Assigned( aSender)
          and  ( aSelect.StepCount > 1)
          then begin
            aMenuItem := TMenuItem.Create( PopupMenuSelector);

            with aMenuItem
            do begin
              Caption := Format( '%sHistory', [ IndexToMenuShortCut( p)], AppLocale);
              Inc( p);
              OnClick := nil;
            end;

            PopupMenuSelector.Items.Add( aMenuItem);
            AddHistoryItems( aMenuItem, aControl as IKnobsUndoable, CONTROL_HISTORY_COUNT);
            AddSelectorMenuItem( 0, -1, '-');
          end;

          for i := 0 to aSelect.Captions.Count - 1
          do begin
            if   aSelect.Captions[ i] = '-'
            then AddSelectorMenuItem( -1, -1, '-')
            else begin
              AddSelectorMenuItem( i, p, aSelect.Captions[ i]);
              Inc( p);
            end;
          end;

          PopUp( aPopup, aControl);
        end;
      end;


      procedure ShowPopupKnob( aPopup: TPopupMenu; aControl: TControl);
      begin
        if   aControl is TKnobsKnob
        then LockKnob.Checked := TKnobsKnob( aControl).Locked
        else LockKnob.Visible := False;

        if   IsAutomatable( aControl)
        then begin
          if  ( aControl as IKnobsAutomatable).AssignedMIDICC = 0
          then KnobMIDICC.Caption := Format( '%sMIDI CC ...'     , [ IndexToMenuShortcut( 0)], AppLocale)
          else KnobMIDICC.Caption := Format( '%sMIDI CC [%d] ...', [ IndexToMenuShortcut( 0), ( aControl as IKnobsAutomatable).AssignedMIDICC], AppLocale);

          KnobMIDICC.Enabled := ( aControl as IKnobsAutomatable).AllowAutomation;
          FLastFrozenCC      := FLastCC;
          AssigntoCC.Caption := Format( '%sAssign to CC %d', [ IndexToMenuShortcut( 1), FlastFrozenCC], AppLocale);
          AssigntoCC.Enabled := ( FLastFrozenCC > 0) and ( aControl as IKnobsAutomatable).AllowAutomation;
          UnAssignCC.Caption := Format( '%sUnassign CC %d', [ IndexToMenuShortcut( 2), ( aControl as IKnobsAutomatable).AssignedMIDICC], AppLocale);
          UnAssignCC.Enabled := ( aControl as IKnobsAutomatable).AssignedMIDICC > 0;
        end;

        if   IsVariation( aControl)
        then begin
          MenuItemKnobExcludeFromRandomization.Checked := not ( aControl as IKnobsVariation).AllowRandomization;
          MenuItemKnobExcludeFromRandomization.Enabled := ( aControl as IKnobsVariation).CanAllowRandomization;
          MenuItemKnobRandomize               .Enabled := ( aControl as IKnobsVariation).CanAllowRandomization and ( aControl as IKnobsVariation).AllowRandomization;
        end
        else begin
          MenuItemKnobExcludeFromRandomization.Checked := True;
          MenuItemKnobExcludeFromRandomization.Enabled := False;
          MenuItemKnobRandomize               .Enabled := False;
        end;

        if   IsUndoable( aControl)
        then AddHistoryItems( MenuItemKnobHistory, aControl as IKnobsUndoable, CONTROL_HISTORY_COUNT);

        PopUp( aPopup, aControl);
      end;


      procedure ShowPopupXYControl( aPopup: TPopupMenu; aControl: TControl);
      begin
        if   IsVariation( aControl)
        then begin
          MenuItemXYControlExcludeFromRandomization.Checked := not ( aControl as IKnobsVariation).AllowRandomization;
          MenuItemXYControlExcludeFromRandomization.Enabled := ( aControl as IKnobsVariation).CanAllowRandomization;
          MenuItemXYControlRandomize               .Enabled := ( aControl as IKnobsVariation).CanAllowRandomization and ( aControl as IKnobsVariation).AllowRandomization;
        end
        else begin
          MenuItemXYControlExcludeFromRandomization.Checked := True;
          MenuItemXYControlExcludeFromRandomization.Enabled := False;
          MenuItemXYControlRandomize               .Enabled := False;
        end;

        PopUp( aPopup, aControl);
      end;


      procedure ShowPopupDataMaker( aPopup: TPopupMenu; aControl: TControl);
      begin
        if   IsVariation( aControl)
        then begin
          MenuItemDataMakerExcludeFromRandomization.Checked := not ( aControl as IKnobsVariation).AllowRandomization;
          MenuItemDataMakerExcludeFromRandomization.Enabled := ( aControl as IKnobsVariation).CanAllowRandomization;
          MenuItemDataMakerRandomize               .Enabled := ( aControl as IKnobsVariation).CanAllowRandomization and ( aControl as IKnobsVAriation).AllowRandomization;
        end
        else begin
          MenuItemDataMakerExcludeFromRandomization.Checked := True;
          MenuItemDataMakerExcludeFromRandomization.Enabled := False;
          MenuItemDataMakerRandomize               .Enabled := False;
        end;

        PopUp( aPopup, aControl);
      end;


      procedure ShowPopupEditor( aPopup: TPopupMenu; aControl: TControl);
      begin
        if   IsUndoable( aControl)
        then AddHistoryItems( MenuItemEditorHistory, aControl as IKnobsUndoable, EDITOR_HISTORY_COUNT);

        PopUp( aPopup, aControl);
      end;


      procedure ShowPopupSimple( aPopup: TPopupMenu; aControl: TControl);
      begin
        PopUp( aPopup, aControl);
      end;

    begin
      if      aControl is TKnobsConnector
      then ShowPopupSimple( PopupMenuConnector, aControl)
      else if aControl is TKnobsDataMaker
      then ShowPopupDataMaker( PopupMenuDataMaker, aControl)
      else if aControl is TKnobsWirePanel
      then ShowPopupEditor( PopupMenuEditor, aControl)
      else if aControl is TKnobsModule
      then ShowPopupModule( PopupMenuModule, aControl)
      else if aControl is TKnobsSelector
      then ShowPopupSelector( PopupMenuSelector, aControl)
      else if aControl is TKnobsValuedControl
      then ShowPopupKnob( PopupMenuKnob, aControl)
      else if aControl is TKnobsXYControl
      then ShowPopupXYControl( PopupMenuXYControl, aControl)
      else if aControl is TKnobsGridControl
      then ShowPopupSimple( PopupMenuGridControl, aControl)
      else if aControl is TKnobsTextControl
      then ShowPopupSimple( PopupMenuTextControl, aControl);
    end;


    procedure   TFormWren.DoUnFocus( const aSender: TObject);
    begin
      if   UseUnFocus
      then EditPark.SetFocus;
    end;


    function    TFormWren.DoLoadDataGraph( const aSender: TObject): string;
    var
      aFile : TextFile;
    begin
      Result := '';

      try
        with OpenDialogGraphs
        do begin
          FileName   := ExtractFileName( FileName);
          InitialDir := GraphsFolder;

          if   Execute
          then begin
            GraphsFolder := ExtractFilePath( FileName);

            AssignFile( aFile, FileName);
            Reset( aFile);

            try
              ReadLn( aFile, Result);
            finally
              CloseFile( aFile);
            end;
          end;
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoSaveDataGraph( const aSender: TObject; const aValue: string);
    var
      aFile : TextFile;
    begin
      try
        with SaveDialogGraphs
        do begin
          FileName   := ExtractFileName( FileName);
          InitialDir := GraphsFolder;

          if   Execute
          then begin
            GraphsFolder := ExtractFilePath( FileName);

            AssignFile( aFile, FileName);
            Rewrite( aFile);

            try
              WriteLn( aFile, aValue);
            finally
              CloseFile( aFile);
            end;
          end;
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    function    TFormWren.DoLoadGridControl( const aSender: TObject): string;
    var
      aFile : TextFile;
    begin
      Result := '';

      try
        with OpenDialogGridControl
        do begin
          FileName   := ExtractFileName( FileName);
          InitialDir := GridControlFolder;

          if   Execute
          then begin
            GridControlFolder := ExtractFilePath( FileName);

            AssignFile( aFile, FileName);
            Reset( aFile);

            try
              ReadLn( aFile, Result);
            finally
              CloseFile( aFile);
            end;
          end;
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoSaveGridControl( const aSender: TObject; const aValue: string);
    var
      aFile : TextFile;
    begin
      try
        with SaveDialogGridControl
        do begin
          FileName   := ExtractFileName( FileName);
          InitialDir := GridControlFolder;

          if   Execute
          then begin
            GridControlFolder := ExtractFilePath( FileName);

            AssignFile( aFile, FileName);
            Rewrite( aFile);

            try
              WriteLn( aFile, aValue);
            finally
              CloseFile( aFile);
            end;
          end;
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoActiveVariationChanged( const aSender: TObject; aVariation: Integer);
    begin
      {$ifdef DEBUG_WORMS} LogFmt( LC_RANDOMIZER, 'TFormWren.DoActiveVariationChanged.Enter to %d', [ aVariation]); {$endif}

      try
        Assert( KnobsWormPanelVariations.WormCount = PatchEditor.VariationCount);

        KnobsWormPanelVariations.Selected := aVariation;
      except
        on E: Exception
        do KilledException( E);
      end;

      {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.DoActiveVariationChanged.Leave'); {$endif}
    end;


    procedure   TFormWren.DoLoadCaptions( const aSender: TObject; const aModule: TKnobsCustomModule; const aControl: TKnobsSelector; const aDependency: TKnobsValuedControl);
    begin
      if   Assigned( aModule)
      and  Assigned( aControl)
      then begin
        if      ( aModule.ModuleType =  335) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'scalequantizer_scale'    ) then FixScaleQuantizeStatics ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  510) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'talkie_bank'             ) then FixTalkieStatics        ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  528) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'sapivoice_voice'         ) then FixSapiSpeechTypeStatics( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  528) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'sapivoice_rate'          ) then FixSpeechRateTypeStatics( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  529) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'espeakvoice_voice'       ) then FixESpeakVoiceStatics   ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  529) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'espeakvoice_language'    ) then FixESpeakLanguageStatics( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  709) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'rndgranulator_envtype'   ) then FixGranulatorStatics    ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  710) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'granulator_envtype'      ) then FixGranulatorStatics    ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType =  711) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'simplegranulator_envtype') then FixGranulatorStatics    ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType = 1012) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'formant2_vowelset'       ) then FixFormant2Statics      ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType = 1023) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'modal2_preset'           ) then FixModal2Statics        ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType = 1208) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'seqrandom_scale'         ) then FixSeqRandomStatics     ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType = 1214) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'probsequencer_scale'     ) then FixProbSequencerStatics ( aControl, TKnobsSelector, aDependency)
        else if ( aModule.ModuleType = 1227) and ( aControl is TKnobsSelector) and SameText( aControl.Name, 'swansong_mazetype'       ) then FixMazeTypeStatics      ( aControl, TKnobsSelector, aDependency);
      end;
    end;


    procedure   TFormWren.DoEditHistoryChanged( aSender: TObject);
    begin
      if   Assigned( FormLastEdits)
      then FormLastEdits.HistoryChanged;
    end;


    procedure   TFormWren.DoModulesRenamed( const aSender: TObject; const anOldNames, aNewNames: TStringArray);
    begin
    end;


    procedure   TFormWren.DoModulesRenamedFriendly( const aSender: TObject; const anOldNames, aNewNames: TStringArray);
    begin
    end;


    function    TFormWren.Template1Name: string;
    begin
      Result := IncludeTrailingPathDelimiter( ApplicationPath) + 'template1' + EXT_WREN;
    end;


    function    TFormWren.Template2Name: string;
    begin
      Result := IncludeTrailingPathDelimiter( ApplicationPath) + 'template2' + EXT_WREN;
    end;


    function    TFormWren.TemplateNewName: string;
    begin
      Result := IncludeTrailingPathDelimiter( ApplicationPath) + 'templatenew' + EXT_WREN;
    end;


    function    TFormWren.CheckDiscardPatchChanges( const aReason: string; MustAsk: Boolean): Boolean;
    var
      MResult : TModalResult;
    begin
      if   FPatchChanged
      and  MustAsk
      then begin
        MResult := MessageDlg
        (
          'Requested operation:' + aReason                                     + ^M^M +
          '** The current patch has unsaved changes **'                        + ^M^M +
          'Do you want to save your changes before proceeding?'                + ^M^M +
          '- Yes - to save and proceeed with the requested operation'          + ^M   +
          '- No - to not save and proceed with the requested operation anyway' + ^M   +
          '- Cancel - to not do anything',
          mtWarning,
          [ mbYes, mbNo, mbCancel],
          0,
          mbYes
        );

        if   MResult = mrYes
        then Result := SavePatch
        else if MResult = mrNo
        then Result := True
        else Result := False;
      end
      else Result := True;
    end;


    function    TFormWren.LastPatchName: string;
    begin
      Result := IncludeTrailingPathDelimiter( ApplicationPath) + '__l__a__t__e__s__t__' + EXT_WREN;
    end;


    procedure   TFormWren.SaveLastPatch;
    var
      aFileName : string;
    begin
      aFileName := LastPatchName;

      try
        LogFmt( LC_GENERAL, 'Saving "%s"', [ aFileName]);

        try
          FPatchWriter.WriteFile( PatchEditor, aFileName);
        except
          on E: Exception
          do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ aFileName, E.ToString]);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.LoadLastPatch;
    var
      aFileName : string;
    begin
      aFileName := LastPatchName;

      if   FileExists( aFileName)
      then begin
        try
          DoLoadPatch( aFileName, True);
        except
          on E: Exception
          do KilledException( E);
        end;
      end;
    end;


    function    TFormWren.SavePatchNamed( const aFileName: string; WriteAlways: Boolean): Boolean;
    begin
      if   FileExists( aFileName) or WriteAlways
      and  Assigned( PatchEditor)
      then begin
        LogFmt( LC_GENERAL, 'Saving "%s"', [ aFileName]);

        try
          FPatchWriter.WriteFile( PatchEditor, aFileName);
        except
          on E: Exception
          do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ aFileName, E.ToString]);
        end;

        if   UndoAfterSave
        then PatchEditor.SetSavedMarker
        else PatchEditor.ClearUndoRedo;

        Result := True;
      end
      else Result := SavePatchAs;
    end;


    function    TFormWren.SavePatch: Boolean;
    begin
      Result := SavePatchNamed( PatchEditor.Filename, False);

      if   Result
      then PatchFolder := ExtractFilePath( PatchEditor.Filename);
    end;


    function    TFormWren.SavePatchAs: Boolean;
    begin
      Result := False;

      with SaveDialogPatch
      do begin
        if   FileName = ''
        then Filename := PatchEditor.Filename;

        InitialDir := ExtractFilePath( Filename);
        FileName   := ExtractFileName( Filename);

        if   InitialDir = ''
        then InitialDir := IncludeTrailingPathDelimiter( ApplicationPath) + 'patches';

        if   Execute
        then begin
          SourceFileName := FileName;
          PatchFolder    := ExtractFilePath( FileName);
          PatchName      := CleanFileName( FileName);
          LogFmt( LC_GENERAL, 'Saving patch as "%s"', [ FileName]);

          try
            FPatchWriter.WriteFile( PatchEditor, FileName);
          except
            on E: Exception
            do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ FileName, E.ToString]);
          end;

          if   UndoAfterSave
          then PatchEditor.SetSavedMarker
          else PatchEditor.ClearUndoRedo;

          Result := True;
        end;
      end;
    end;


    function    TFormWren.SaveAsTemplate( const aFileName: string): Boolean;
    var
      DoSave  : Boolean;
      OldName : string;
    begin
      if   FileExists( aFileName)
      then DoSave := MessageDlg( Format( '"%s" already exists, overwrite it?', [ aFileName], AppLocale), mtConfirmation, [ mbYes, mbNo], 0) = mrYes
      else DoSave := True;

      if   DoSave
      then begin
        OldName   := PatchName;
        Result    := SavePatchNamed( aFileName, True);
        PatchName := OldName;
      end
      else Result := False;
    end;


    function    TFormWren.SaveAsTemplate1: Boolean;
    begin
      Result := SaveAsTemplate( Template1Name);
    end;


    function    TFormWren.SaveAsTemplate2: Boolean;
    begin
      Result := SaveAsTemplate( Template2Name);
    end;


    function    TFormWren.SaveAsTemplateNew: Boolean;
    begin
      Result := SaveAsTemplate( TemplateNewName);
    end;


    procedure   TFormWren.ExportModules;
    begin
      with SaveDialogPatch
      do begin
        FileName   := '';
        InitialDir := ImportFolder;

        if   Execute
        then begin
          ImportFolder := ExtractFilePath( FileName);
          LogFmt( LC_GENERAL, 'Exporting selected modules to "%s"', [ FileName]);

          try
            FPatchWriter.WriteFile( PatchEditor, FileName, wmSelected);
          except
            on E: Exception
            do LogFmt( LC_GENERAL, 'Failed to write "%s", reason: %s', [ FileName, E.ToString]);
          end;
        end;
      end;
    end;


    procedure   TFormWren.DoLoadPatch( const aFileName: string; ChangePatchName: Boolean);
    var
      OldName   : string;
      OldSource : string;
      OldGuid   : string;
      OldActive : Integer;
    begin
      if   FileExists( aFileName)
      then begin
        if   CheckDiscardPatchChanges( 'Load a new patch', WarnChangeOnLoad)
        then begin
          OldName   := PatchName;
          OldSource := SourceFileName;
          OldGuid   := PatchEditor.Guid;
          OldActive := PatchEditor.ActiveRange;
          PatchEditor.BlockWireUpdates;

          try
            LogFmt( LC_GENERAL, 'loading file %s', [ aFileName]);
            SourceFileName           := aFileName;
            SaveDialogPatch.FileName := '';

            try
              FPatchReader.ReadFile(
                aFileName,
                PatchEditor,
                DO_STRICT,
                NO_DRAG,
                DO_COPY_MIDI,
                not NoLoadTuning,
                rmReplace
              );

              if   ChangePatchName
              then PatchName := PatchEditor.Title
              else begin
                PatchName        := OldName;
                SourceFileName   := OldSource;
                PatchFolder      := ExtractFilePath( SourceFileName);
                PatchEditor.Guid := OldGuid;
              end;

              if   UndoAfterLoad
              then PatchEditor.SetSavedMarker
              else PatchEditor.ClearUndoRedo;

              PatchEditor.UnSelectAllModules;
              PatchEditor.FixUserSettings;
              PatchEditor.ClearHistory;
              RegisterMidiControls;
              PatchEditor.FixActiveRange( OldActive);

              if FPatchReader.TuningChanged
              then begin
                TuningChanged := True;
                CancelTuning;                 // This will read the newly set global tuning vars into the edit controls.
                FixTuningAndSampleRate( 'DoLoadPatch');
              end;
            except
              on E: Exception
              do begin
                LogFmt( LC_GENERAL, 'loading failed with message ''%s''', [ E.ToString]);
                PatchEditor.Undo;
                MessageDlg( Format( 'Patch load failed with message ''%s''', [ E.ToString], AppLocale), mtError, [ mbOK], 0);
              end;
            end;

            ClearVolumeIndicators;
          finally
            PatchEditor.UnblockWireUpdates;
          end;
        end;
      end;
    end;


    procedure   TFormWren.DoImportPatch( const aFileName: string);
    // modules need be in drag mode after paste ... and MIDI CCs should not be copied
    begin
      if   FileExists( aFileName)
      and  Assigned( FPatchReader)
      then begin
        PatchEditor.BlockWireUpdates;

        try
          LogFmt( LC_GENERAL, 'importing file %s', [ aFileName]);
          try
            FPatchReader.ImportFile( aFileName, PatchEditor, DO_STRICT, DO_DRAG, NO_COPY_MIDI, DO_COPY_TUNING, rmAppend);
          except
            on E: Exception
            do begin
              LogFmt( LC_GENERAL, 'importing failed with message ''%s''', [ E.ToString]);
              PatchEditor.Undo;
              MessageDlg( Format( 'Patch import fialed with message ''%s''', [ E.ToString], AppLocale), mtError, [ mbOK], 0);
            end;
          end;
        finally
          PatchEditor.UnblockWireUpdates;
        end;
      end;
    end;


    procedure   TFormWren.LoadPatch;
    begin
      with OpenDialogPatch
      do begin
        if   FileName = ''
        then Filename := PatchEditor.Filename;

        InitialDir := ExtractFilePath( Filename);
        FileName   := ExtractFileName( Filename);

        if   InitialDir = ''
        then InitialDir := PatchFolder;

        if   Execute
        then DoLoadPatch( FileName, True);
      end;
    end;


    procedure   TFormWren.ImportPatch;
    begin
      with OpenDialogPatch
      do begin
        InitialDir := ImportFolder;

        if   Execute
        then begin
          ImportFolder         := ExtractFilePath( FileName);
          FRequestedImportName := FileName;
          FRequestImport       := True;
        end;
      end;
    end;


    procedure   TFormWren.NewPatch;
    begin
      if   Assigned( PatchEditor)
      then begin
        PatchEditor.FreeModules( DoOnValuedControlRemoved);
        PatchEditor  .Guid  := '';     // Force creation of a new GUID
        SourceFileName      := UniqueFilenameFromTemplate( PatchFolder, NewPatchNameTemplate, EXT_WREN, PatchEditor.Guid);
        PatchEditor  .Title := Trim( UnQuote( ChangeFileExt( ExtractFileName( SourceFileName), ''), '', '.'));
        PatchName           := PatchEditor.Title;
        DoLoadPatch( TemplateNewName, False);
      end
      else begin
        SourceFileName := 'new';
        PatchName      := SourceFileName;
      end;
    end;


    procedure   TFormWren.DoOnValuedControlRemoved( const aSender: TKnobsValuedControl);
    begin
      UnAssignMidiCC( aSender);

      if   Assigned( FormLastEdits)
      then FormLastEdits.RemoveValuedControl( aSender);
    end;


    procedure   TFormWren.DeleteModules;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.FreeSelectedModules( DoOnValuedControlRemoved);
    end;


    procedure   TFormWren.CutModules;
    begin
      CopyModules;
      DeleteModules;
    end;


    procedure   TFormWren.CopyModules;
    begin
      if   Assigned( FPatchWriter)
      then FPatchWriter.WriteToClipboard( PatchEditor, wmSelected);
    end;


    procedure   TFormWren.PasteModules;
    begin

      // Note : PasteModules (ReadFromClipboard) should not alter Midi CC assignments.

      if   Assigned( FPatchReader)
      then FPatchReader.ReadFromClipboard( PatchEditor, DO_STRICT, DO_DRAG, NO_COPY_MIDI, DO_COPY_TUNING, rmAppend);
    end;


    procedure   TFormWren.PasteParameters( StrictCopy: Boolean);
    begin

      // Note : PasteParameters (ParamsFromClipboard) should not alter Midi CC assignments.

      if   Assigned( FPatchReader)
      then begin
        FPatchReader.WarnOnStructMismatch := Self.WarnOnStructMismatch;
        FPatchReader.ParamsFromClipboard( PatchEditor, StrictCopy);
      end;
    end;


    procedure   TFormWren.SelectAll;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.SelectAllModules;
    end;


    procedure   TFormWren.SelectNone;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.UnselectAllModules;
    end;


    procedure   TFormWren.InvertSelection;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.InvertModuleSelection;
    end;


    procedure   TFormWren.WiggleWires;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.WiggleWires;
    end;


    procedure   TFormWren.ToggleWires;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ToggleWires;
    end;


    function    TFormWren.WiresOff: Boolean;
    begin
      if   Assigned( PatchEditor)
      then Result := PatchEditor.WiresOff
      else Result := True;
    end;


    procedure   TFormWren.WiresOn( TurnOn: Boolean);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.WiresOn( TurnOn);
    end;


    procedure   TFormWren.ToggleSound;
    begin
      Sounding := not Sounding;
    end;


    procedure   TFormWren.SearchInPatch( const aValue: string);
    begin
      if   Assigned( PatchEditor)
      and  SearchPatch
      then PatchEditor.Search( aValue);
    end;


    procedure   TFormWren.SearchInSelector( const aValue: string);
    begin
      if   Assigned( ModuleSelector)
      and  SearchSelector
      then ModuleSelector.Search( aValue);
    end;


    procedure   TFormWren.FindUnconnectedModules;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.FindUnconnectedModules;
    end;


    procedure   TFormWren.CollectDenormals( AutoCollected: Boolean);
    var
      aMap      : TPinMaps;
      aList     : TStringList;
      i         : Integer;
      j         : Integer;
      S         : string;
      anIns     : string;
      anOuts    : string;
      aName     : string;
      aTitle    : string;
      aPin      : string;
    begin
      if   Assigned( FSynthPatch)
      then begin
        aList := TStringList.Create;

        try
          if   Assigned( PatchEditor)
          and  not AutoCollected
          then PatchEditor.UnSelectAllModules;

          FSynthPatch.CollectDenormals( aMap);

          for i := 0 to Length( aMap) - 1
          do begin
            if   ( aMap[ i].Ins <> []) or ( aMap[ i].Outs <> [])
            then begin
              aName := FSynthPatch.ModuleName( aMap[ i].ModuleIndex);

              if   Assigned( PatchEditor)
              then aTitle := PatchEditor.FindTitle( aName)
              else aTitle := '';

              anIns := '[';

              for j := 0 to FSynthPatch.Module[ aMap[ i].ModuleIndex].InputCount - 1
              do begin
                if   j in aMap[ i].Ins
                then begin
                  if   Assigned( PatchEditor)
                  then aPin := FSynthPatch.InputPinName( aMap[ i].ModuleIndex, j)
                  else aPin := IntToStr( j);

                  anIns := Format( '%s %s', [ anIns, aPin], AppLocale);
                end;
              end;

              anIns  := anIns + ']';
              anOuts := '[';

              for j := 0 to FSynthPatch.Module[ aMap[ i].ModuleIndex].OutputCount - 1
              do begin
                if   j in aMap[ i].Outs
                then begin
                  if   Assigned( PatchEditor)
                  then aPin := FSynthPatch.OutputPinName( aMap[ i].ModuleIndex, j)
                  else aPin := IntToStr( j);

                  anOuts := Format( '%s %s', [ anOuts, aPin], AppLocale);
                end;
              end;

              anOuts := anOuts + ']';
              S := Format( '  %s [%s] %s %s', [ aName, aTitle, anIns, anOuts], AppLocale);
              aList.Add( S);

              if   Assigned( PatchEditor)
              then PatchEditor.AddToSelection( aName);
            end;
          end;

          if   aList.Count > 0
          then begin
            Log( LC_PROFILER, '---- possible denormals:');

            for i := 0 to aList.Count - 1
            do Log( LC_PROFILER, aList[ i]);

            Log( LC_PROFILER, '---- end');
          end
          else begin
            if   not AutoCollected
            then Log( LC_PROFILER, 'No denormals found');
          end;
        finally
          aList.DisposeOf;
        end;
      end;
    end;


    procedure   TFormWren.Panic;
    begin
      if   Assigned( FSynthPatch)
      then FSynthPatch.Panic;
    end;


    procedure   TFormWren.FillDataMaker( const aDataMaker: TKnobsDataMaker; aShape: TKnobsDMShape);
    begin
      if   Assigned( aDataMaker)
      then aDataMaker.MakeWave( aShape);
    end;


    procedure   TFormWren.UpdateLiveMorphVisuals;
    begin
      if   Assigned( FormRandomizer)
      then FormRandomizer.PatchChanged( -1);

      if   Assigned( PatchEditor)
      then PatchEditor.FillWorm( KnobsWormPatch, -1);

      TimerLiveMorphVisuals.Enabled := False;
    end;


    procedure   TFormWren.PatchLiveMorph( UpdateVisuals: Boolean);
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchLiveMorph.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.LiveMorph( LiveMorph);
            PatchEditor.FixAllSynthParams( True);

            if   Assigned( FormRandomizer)
            and  FormRandomizer.Visible
            then FormRandomizer.LiveMorph := LiveMorph;
          finally
            Unlock( FWormUpdateLock)
          end;
        end;

        if   UpdateVisuals
        then UpdateLiveMorphVisuals
        else begin
          TimerLiveMorphVisuals.Enabled := False;
          TimerLiveMorphVisuals.Enabled := True;
        end;
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchLiveMorph.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.SetRandomValue;
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.SetRandomValue.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.SetRandomValue( FormRandomizer.RandomAmount, ActiveVariation);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock)
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch                       , ActiveVariation);
        PatchEditor.FillWorm( KnobsWormPanelVariations.SelectedWorm, ActiveVariation);
        FormRandomizer.PatchChanged( ActiveVariation);

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.SetRandomValue.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.PatchRandomize;
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchRandomize.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.Randomize( FormRandomizer.RandomAmount);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, -1);
        PatchEditor.FillWormPanel( KnobsWormPanelVariations);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchRandomize.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.PatchMutate;
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMutate.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.Mutate( FormRandomizer.MutationProbability, FormRandomizer.MutationRange);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, -1);
        PatchEditor.FillWormPanel( KnobsWormPanelVariations);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMutate.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.PatchMate;
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMate.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.Mate( FormRandomizer.CrossoverProbability, FormRandomizer.MutationProbability, FormRandomizer.MutationRange);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, -1);
        PatchEditor.FillWormPanel( KnobsWormPanelVariations);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMate.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.PatchMorph;
    begin
      if   Assigned( FormRandomizer)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMorph.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.Morph;
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, -1);
        PatchEditor.FillWormPanel( KnobsWormPanelVariations);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.PatchMorph.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.WormSelected( const aWorm: TKnobsWorm);
    begin
      if   Assigned( FormRandomizer)
      and  Assigned( aWorm)
      and  ( aWorm.Size > 0)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.WormSelected.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.AcceptGene( aWorm.Gene, -1);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, -1);
        PatchEditor.FillWormPanel( KnobsWormPanelVariations);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.WormSelected.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.WormDropped( const aWorm: TKnobsWorm);
    begin
      if   Assigned( FormRandomizer)
      and  Assigned( aWorm)
      and  ( aWorm.Size > 0)
      then begin
        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.WormDropped.Enter'); {$endif}

        if   Lock( FWormUpdateLock)
        then begin
          try
            PatchEditor.AcceptGene( aWorm.Gene, aWorm.Tag);
            PatchEditor.FixAllSynthParams( True);
          finally
            Unlock( FWormUpdateLock);
          end;
        end;

        PatchEditor.FillWorm( KnobsWormPatch, aWorm.Tag);
        FormRandomizer.PatchRecompiled;

        {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.WormDropped.Leave'); {$endif}
      end;
    end;


    procedure   TFormWren.SetAllowRandomization( aValue: Boolean);
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.AllowRandomization := aValue;
    end;


    procedure   TFormWren.ToggleExcludedModules;
    begin
      if   Assigned( PatchEditor)
      then PatchEditor.ShowAllowRandomization := not PatchEditor.ShowAllowRandomization;
    end;


    procedure   TFormWren.RangeChanged( aNewRange: Integer);
    var
      IsMorph : Boolean;
    begin
      if   Assigned( PatchEditor)
      then begin
        aNewRange := Clip( aNewRange, 0, RangeCount - 1);
        PatchEditor.ActiveRange := aNewRange;
        IsMorph := RangeIsMorph( aNewRange);
        knob_morph              .Visible := IsMorph;
        KnobsDisplayCurrentRange.Visible := IsMorph;

        if   IsMorph
        then PatchEditor.RangeValue := RangeValue( PatchEditor.ActiveRange);
      end;
    end;


    procedure   TFormWren.RangeValueChanged( aValue: TSignal);
    begin
      if   Assigned( PatchEditor)
      and  not AllowMorphMod
      then begin
        PatchEditor.RangeValue := aValue;
        SetRangeValue( PatchEditor.ActiveRange, aValue);
      end;
    end;


//  private

    function    TFormWren.FunctionalPinName( const aName: string): string;
    begin
      Result := ParsePostfix( aName);
    end;


    function    TFormWren.SplitConnectorName( const aName: string; var aMod, aPin: string): Boolean;
    var
      aList: TStringList;
    begin
      aMod   := '';
      aPin   := '';
      Result := False;
      aList  := Explode( aName, '.');

      try
        if   aList.Count = 2
        then begin
          aMod   := aList[ 0];
          aPin   := aList[ 1];
          Result := not ( SameText( aMod, '<nil>') or SameText( aPin, '<nil>'));

          if   Result
          then aPin := FunctionalPinName( aPin);
        end;
      finally
        aList.DisposeOf;
      end;
    end;


    function    TFormWren.ModuleTypeToModule( aType: Integer; const aParent: TSynthPatch; const aName: string): TMod;
    // This couples an editor module ID to it's synth implementation
    // Stuff that needs or can not be compiled, i.e. 'editor only' modules should return nil here
    var
      M : TModuleClass;
    begin
      Result := nil;
      M      := LookupModuleClass( aType);

      if   Assigned( M)
      and  Assigned( aParent)
      then Result := M.Create( aParent, aName);
    end;


    procedure   TFormWren.CompilePatch( ModulesChanged, AutomaticCompile: Boolean);
    // This creates a synth patch from an editor patch, deletes the old synth patch
    // and plugs in the new one.
    var
      aSynthPatch   : TSynthPatch;
      i             : Integer;
      aPatchModule  : TKnobsCustomModule;
      aModuleType   : Integer;
      aModuleName   : string;
      aModule       : TMod;
      S             : string;
      aSrcMod       : string;
      aSrcPin       : string;
      aDstMod       : string;
      aDstPin       : string;
    begin
      if   AutomaticCompile
      and  ManualCompilation
      and  not ModulesChanged
      then begin
        Log( LC_COMPILER, 'NOT compiling synth patch, automatic compile called for and manual compilation mode is in effect');
        FUncompiledChanges := True;
      end
      else begin
        Log( LC_COMPILER, 'compiling synth patch');
        FUncompiledChanges := False;

        if   Assigned( PatchEditor)
        then begin
          try
            if   ClearVUOnRecompile
            then ResetPeaks;

            FixModuleStatics;

            if   CompilerDebug
            then begin
              if   Assigned( FSignalSpecs)
              then FSignalSpecs.Load( PatchEditor)
              else FSignalSpecs := TKnobsModuleSignalSpecs.Create( PatchEditor);
            end;

            aSynthPatch := TSynthPatch.Create( nil, PatchName);
            aSynthPatch.Initialize;

            try
              aSynthPatch.Version       := PatchEditor.Version;
              TimerLightsUpdate.Enabled := False;

              with PatchEditor
              do begin
                FixAllWires;                                 // Get the wire directions right before wire compilation
  //            SortGraph;                                   // Sort modules according to strongly connected components to get shortest loop delays

                if   CompilerDebug
                then DumpGraph( IncludeTrailingPathDelimiter( ApplicationPath) + 'graphdump.txt');

                Log( LC_COMPILER, 'compiling synth patch - modules');

                for i := 0 to ModuleCount - 1
                do begin
                  aPatchModule := Module[ i];
                  aModuleType  := aPatchModule.ModuleType;
                  aModuleName  := aPatchModule.Name;
                  aModule      := ModuleTypeToModule( aModuleType, aSynthPatch, aModuleName);

                  if   Assigned( aModule)                    // Module translates, add it, set it's OSC properties and speed it up if needed
                  then begin
                    if   ( aPatchModule.ExternalName <> '')
                    and  ( aModule is TModExternal)
                    then TModExternal( aModule).ExternalName := aPatchModule.ExternalName;

                    aModule.Initialize;
                    aSynthPatch.AddModule( aModule);

                    if   aPatchModule.IsSpedUp
                    then begin
                      if   aModule.IsFast
                      then LogFmt( LC_COMPILER, 'Tried to speed up fast module type %s, this is not allowed', [ aModule.ClassName])
                      else aModule.MakeFast;
                    end;
                  end;
                end;

                BuildModuleIndex;

                // todo: Log( 'compiling synth patch - apply mappings'); // Apply mappings to aSignalSpecs

                Log( LC_COMPILER, 'compiling synth patch - wires');

                for i := 0 to WireCount - 1
                do begin
                  if   SplitConnectorName( Wire[ i].SourceName     , aSrcMod, aSrcPin)
                  and  SplitConnectorName( Wire[ i].DestinationName, aDstMod, aDstPin)
                  then begin
                    try
                      aSynthPatch.AddConnection( aSrcMod, aSrcPin, aDstMod, aDstPin);
                    except
                      on E: Exception
                      do LogFmt( LC_COMPILER, 'Error adding connection: ''%s''', [ E.ToString]);
                    end;
                  end;
                end;

                aSynthPatch.CompileLinks;
             // aSynthPatch.CompileTickers;
                aSynthPatch.MidiChannel := MidiChannel;
                Log( LC_COMPILER, 'compiling synth patch - switching in new synth patch');

                if   not ChangeSynthPatch( aSynthPatch, ModulesChanged)
                then FreeAndNil( aSynthPatch);

                if   Assigned( FSynthPatch)
                then begin
                  Log( LC_COMPILER, 'compiling synth patch - post processing');
                  FSynthPatch.FixDeZippers;                                      // Must fix the zippers in the new patch always

                  for i := 0 to RangeCount - 1
                  do  FSynthPatch.Morph[ i] := Knobs2013.RangeValue( i);

                  FSynthPatch.Reset;

                  // moved some stuff from here to --->      ----+
                                                             //  |
                  if   Lock( FWormUpdateLock)                //  |
                  then begin                                 //  |
                    try                                      //  |
                      PatchEditor.FixAllSynthParams( False); //  |
                    finally                                  //  |
                      Unlock( FWormUpdateLock);              //  |
                    end;                                     //  |
                  end;                                       //  |
                                                             //  |
                  // ---> from there to here stuff           <---+

                  FSynthPatch.GatherSignals   ( '', DoSignals   );
                  FSynthPatch.GatherLights    ( '', DoLights    );
                  FSynthPatch.GatherData      ( '', DoData      );
                  FSynthPatch.GatherXYData    ( '', DoXYData    );
                  FSynthPatch.GatherStringData( '', DoStringData);
                  FSynthPatch.GatherCursorData( '', DoCursorData);

                  // ---- end stuff ----

                  RegisterRandomParamsAll;

                  if   Lock( FWormUpdateLock)
                  then begin
                    try
                      PatchEditor.FixAllSynthParams( False);
                    finally
                      Unlock( FWormUpdateLock);
                    end;
                  end;

                  // Some debug stuff - write the just created synth patch to test.txt - in the current (application) directory

                  if   CompilerDebug
                  then begin
                    try
                      S := '';
                      FSynthPatch.Dump( 0, S);
                      StringTofile( S, IncludeTrailingPathDelimiter( ApplicationPath) + 'test.txt');

                      if   Assigned( FSignalSpecs)
                      then FSignalSpecs.Dump( IncludeTrailingPathDelimiter( ApplicationPath) + 'signalspecs.txt');
                    except
                      on E: Exception
                      do KilledException( E);
                    end;
                  end;
                end
                else Log( LC_COMPILER, 'compiling synth patch - No new synth patch, this is odd, but no post processing needed in that case');
              end; // with WirePanel ..

              TimerLightsUpdate.Enabled := True;
              FSampleCount := 0;
              ResetRuntime;
              ClearOverUnderFlows;
              Log( LC_COMPILER, 'compiled synth patch');
            except
              on E: Exception
              do begin
                LogFmt( LC_COMPILER, 'Error compiling synth patch: %s', [ E.ToString]);
                FreeAndNil( aSynthPatch);
              end;
            end;
          except
            on E: Exception
            do LogFmt( LC_COMPILER, 'Error in compilation: %s', [ E.ToString]);
          end;

        end; // if Assigned( PatchEditor)
      end;
    end;


    procedure   TFormWren.RegisterMidiControls;
    var
      aList    : TStringList;
      i        : Integer;
      aControl : TKnobsValuedControl;
    begin
      if   Assigned( PatchEditor     )
      and  Assigned( FormSelectMidiCC)
      then begin
        aList             := PatchEditor.CreateMidiCCList;
        aList.Sorted      := False;
        aList.OwnsObjects := False;
        aList.Duplicates  := dupError;

        if   Assigned( aList)
        then begin
          try
            FormSelectMidiCC.UnregisterComtrolNames;

            for i := 0 to aList.Count - 1
            do begin
              if   aList.Objects[ i] is TKnobsValuedControl
              then begin
                aControl := TKnobsValuedControl( aList.Objects[ i]);
                FormSelectMidiCC.RegisterControlName( i + 1, MakeMidiCCName( aControl), aControl);
              end;
            end;
          finally
            aList.DisposeOf;
          end;
        end;
      end;
    end;


    procedure   TFormWren.RegisterRandomParams;
    begin
      if   Lock( FWormUpdateLock)
      then begin
        try
          {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.RegisterRandomParams.Enter'); {$endif}

          PatchEditor.FillWorm( KnobsWormPatch, -1);

          if   Assigned( FormRandomizer)
          and  FormRandomizer.Visible
          then FormRandomizer.PatchChanged( -1);

          {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.RegisterRandomParams.Leave'); {$endif}
        finally
          Unlock( FWormUpdateLock);
        end;
      end;
    end;


    procedure   TFormWren.RegisterRandomParamsAll;
    begin
      if   Lock( FWormUpdateLock)
      then begin
        try
          {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.RegisterRandomParamsAll.Enter'); {$endif}

          PatchEditor.FillWormPanel( KnobsWormPanelVariations);
          PatchEditor.FillWorm( KnobsWormPatch, -1);

          if   Assigned( FormRandomizer)
          and  FormRandomizer.Visible
          then FormRandomizer.PatchRecompiled;

          {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.RegisterRandomParamsAll.Leave'); {$endif}
        finally
          Unlock( FWormUpdateLock);
        end;
      end;
    end;


//  private


    procedure   TFormWren.FixTuningAndSampleRate( const aMsg: string);
    begin
      ComputeTables;                                // Recalculate all tables
      HrastUnit.CreateTables;                       // Recalculate Hrast lookup tables too
      Speech   .InitModule;                         // Recalculate phoneme table

      if   Assigned( FSynthPatch)                   // Give modules a chance to recompute stuff too
      then begin
        FSynthPatch.SampleRateChanged;
        FSynthPatch.TuningChanged;
      end;

      if   Assigned( PatchEditor)                   // Frequency displays and such may need to reflect a new sample rate and or tuning
      then PatchEditor.InvalidateDisplays;

      TuningChanged := False;
      LogFmt( LC_GENERAL, 'Reinitialized tuning and sample rate ( from ''%s'')', [ aMsg]);
    end;


    function    TFormWren.GetSignalValue( const anEditor: TEdit; var aValue: TSignal; aLow, aHigh: TSignal; UseClipping: Boolean): Boolean;
    var
      aNewValue : TSignal;
    begin
      Result := False;

      if   Assigned( anEditor)
      then begin
        if anEditor.Text <> ''
        then begin
          ReplaceText( anEditor.Text, ',', '.');
          ReplaceText( anEditor.Text, '.', AppLocale.DecimalSeparator);
          aNewValue := StrToFloatDef( anEditor.Text, Nan);

          if not IsNan( aNewValue)
          then begin

            if UseClipping
            then begin
              aValue := Clip( aNewValue, aLow, aHigh);
              Result := True;
            end
            else begin
              Result := ( aNewValue >= aLow) and ( aNewValue <= aHigh);

              if Result
              then aValue := aNewValue;
            end;
          end;
        end;
      end;

      if Result
      then anEditor.Text := Format( '%g', [ aValue], AppLocale);
    end;


    procedure   TFormWren.SignalTuningError( const aName: string; const anEditor: TEdit; aLow, aHigh: TSignal);
    begin
      if Assigned( anEditor)
      then begin
        MessageDlg(
          Format(
            'Error detected in value (%s) for %s, this should be a valid floating point number in a range of [ %g, %g]',
            [
              anEditor.Text,
              aName        ,
              aLow         ,
              aHigh
            ],
            AppLocale
          ),
          mtInformation,
          [
            mbOk
          ],
          0
        );

        anEditor.SetFocus;
      end;
    end;


    procedure   TFormWren.ApplyTuning;

      function HandleSignalValue( const anEdit: TEdit; const aName: string; var aValue: TSignal; const aLow, aHigh: TSignal): Boolean;
      begin
        Result := True;

        if not GetSignalValue( anEdit, aValue, aLow, aHigh, True)
        then begin
          SignalTuningError( aName, anEdit, aLow, aHigh);
          Result := False;
        end;
      end;

    var
      OK : Boolean;
    begin
      OK := HandleSignalValue( EditReferenceA    , 'Ref.A'    , FReferenceA    ,    1    , 10000)
        and HandleSignalValue( EditNotesPerOctave, 'notes/oct', FNotesPerOctave,    1    ,   250)
        and HandleSignalValue( EditOctaveSpan    , 'oct. span', FOctaveSpan    ,    1.001,    16)
        and HandleSignalValue( EditMiddleNote    , 'mid. note', FMiddleNote    , -127    ,   127);

      if OK
      then begin
        KnobsConversions.ReferenceA        :=       ReferenceA    ;
        KnobsConversions.NotesPerOctave    :=       NotesPerOctave;
        KnobsConversions.NotesPerOctaveRec := 1.0 / NotesPerOctave;
        KnobsConversions.MiddleNote        :=       MiddleNote    ;
        KnobsConversions.OctaveSpan        :=       OctaveSpan    ;

        FixTuningAndSampleRate(
          Format(
            'Applied tuning ( A: %g, N/O: %g, MN: %g, OS: %g)',
            [
              ReferenceA    ,
              NotesPerOctave,
              MiddleNote    ,
              OctaveSpan
            ],
            AppLocale
          )
        );
      end;
    end;


    procedure   TFormWren.CancelTuning;
    begin
      ReferenceA     := KnobsConversions.ReferenceA;
      NotesPerOctave := KnobsConversions.NotesPerOctave;
      MiddleNote     := KnobsConversions.MiddleNote;
      OctaveSpan     := KnobsConversions.OctaveSpan;
      TuningChanged  := False;

      Log(
        LC_GENERAL,
        Format(
          'Cancelled tuning ( A: %g, N/O: %g, MN: %g, OS: %g)',
          [
            ReferenceA    ,
            NotesPerOctave,
            MiddleNote    ,
            OctaveSpan
          ],
          AppLocale
        )
      );
    end;


//  private

    procedure   TFormWren.InitializeCPUCounter;
    begin
      FCpuUsageData := CreateCpuUsageCounter( GetCurrentProcessId);
    end;


    procedure   TFormWren.FinalizeCPUCounter;
    begin
      if   Assigned( FCpuUsageData)
      then begin
        DestroyCpuUsageCounter( FCpuUsageData);
        FCpuUsageData := nil;
      end;
    end;


    procedure   TFormWren.TickCPUCounter;
    begin
      if   Assigned( FCpuUsageData)
      then FProcessTime := ( FProcessTime + 2 * GetCpuUsage( FCpuUsageData) / CpuCount) / 3
      else FProcessTime := -1;
    end;


//  private

    procedure   TFormWren.StartNetMidiConnectTimer;
    begin
      StopNetMidiConnectTimer;
      TimerNetMidiConnect.Interval := 1000;
      TimerNetMidiConnect.Enabled  := True;
    end;


    procedure   TFormWren.StopNetMidiConnectTimer;
    begin
      TimerNetMidiConnect.Enabled  := False;
    end;


    procedure   TFormWren.NetMidiConnectTimerFired;
    begin
      if   NetMidiAutoConnect
      and  not NetMidiConnected
      then NetMidiConnect;
    end;


    procedure   TFormWren.NetMidiConnect;
    begin
      if   not NetMidiConnected
      then begin
        try
          WSocketNetMidi.Addr := NetMidiServer;     // set net midi connect params
          WSocketNetMidi.Port := NetMidiPort;
          WSocketNetMidi.Connect;                   // start net midi client
        except
          on E: Exception
          do begin
            LogFmt( LC_MIDI, 'NetMidi connection error: %s - auto connect will be disabled', [ E.ToString]);
            NetMidiAutoConnect := False;
          end;
        end;
      end;
    end;


    procedure   TFormWren.NetMidiDisconnect;
    begin
      if   NetMidiConnected
      then begin

        // stop net midi client

        try
          WSocketNetMidi.Close;
        except
          on E: Exception
          do begin
            LogFmt( LC_MIDI, 'Error closing NetMidi: %s - auto connect will be disabled', [ E.ToString]);
            NetMidiAutoConnect := False;
          end;
        end;
      end;
    end;


    procedure   TFormWren.NetMidiApply;
    var
      WasConnected : Boolean;
    begin
      WasConnected := NetMidiConnected;
      NetMidiDisconnect;
      NetMidiServer := EditNetMidiServer.Text;
      NetMidiPort   := EditNetMidiPort  .Text;

      if   WasConnected
      then NetMidiConnect;

      NetMidiChanged := False;
    end;


    procedure   TFormWren.NetMidiCancel;
    begin
      EditNetMidiServer.Text := NetMidiServer;
      EditNetMidiPort  .Text := NetMidiPort;
      NetMidiChanged := False;
    end;


    procedure   TFormWren.ReceiveNetMidi;
    const
      BufSize = 1024;
    var
      aBuffer : packed array[ 0 .. BufSize - 1] of Byte;
      aCount  : Integer;
    begin
      try
        aCount := WSocketNetMidi.Receive( @ aBuffer, BufSize);

        if   ( aCount > 0)
        and  Assigned( FMidiReceiver)
        and  Assigned( FSynthPatch)
        and  FAudioRunning
        then FMidiReceiver.AcceptBytes( BytesFromByteArray( aBuffer, aCount));
      except
        on E: Exception
        do LogFmt( LC_MIDI, 'Error handling NetMidi RX data: %s', [ E.ToString]);
      end;
    end;


    procedure   TFormWren.SendMidiBytes( const aMsg: TBytes);
    begin
      FMidiTransmitter.Accept( aMsg);
    end;


    procedure   TFormWren.QueueMidiBytes( const aMsg: TBytes);
    //
    // todo: it would be better to NOT use PostMessage from the audio thread
    //
    // ** This function is being called from the audio thread.
    //
    // We can not send MIDI from here, but we can post a message
    //
    begin

      try
        if   WSocketNetMidi.State = wsConnected
        then begin
          FMidiFifo.Append( aMsg);
          PostMessage( Handle, UM_MIDIDATA, 0, 0);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoSendMidiBytes( const aSender: TObject; const aMsg: TBytes);
    begin
      try
        QueueMidiBytes( aMsg);
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.SendShortNetMidi( const aData: TShortMidiMessage);
    //
    // ** This function is being called from the audio thread - note that we can not log from here
    //
    begin
      FMidiTransmitter.Accept( aData);
    end;


//  private

    procedure   TFormWren.DoMidiRxMessage( const aSender: TObject; const aMsg: TMidiMessage);
    var
      aParts      : TStringList;
      aModule     : string;
      aControl    : string;
      aController : IKnobsAutomatable;
      aValue      : Byte;
      aSteps      : Integer;
      aPos        : Integer;
    begin
      if   Assigned( FSynthPatch)
      and  FAudioRunning
      then begin
        FSynthPatch.AcceptMidi( aMsg);

        if   (( aMsg.Channel = MidiChannel) or ( MidiChannel = MIDI_CH_OMNI)) and ( aMsg.Command = CControlChange)
        then begin
          FLastCC := aMsg.Data[ 0];

          if   Assigned( FormSelectMidiCC)
          then begin
            aController := FormSelectMidiCC.CCToController( aMsg.Data[ 0]);

            if   Assigned( aController)
            then begin
              aParts := Explode( FormSelectMidiCC.CCToControlName( aMsg.Data[ 0]), '_');

              try
                if   aParts.Count = 2
                then begin
                  aModule  := aParts[ 0];
                  aControl := aParts[ 1];
                  aValue   := aMsg.Data[ 1];
                  aSteps   := aController.StepCount;
                  aPos     := Round( RangeMap( aValue, 0, 127, 0, aSteps));

                  try
                    aController.AutomationPosition := aPos;
                  except
                    on E: Exception
                    do KilledException( E);
                  end;
                end;
              finally
                aParts.DisposeOf;
              end;
            end;
          end;
        end;

        if   LogMidiMsgs
        then MidiMsgLogFmt( 'RX : %s', [ MidiMessageToLog( aMsg)]);
      end;
    end;


    procedure   TFormWren.DoRxRpnMessage( const aSender: TObject; aCh, aController, aValue: Integer );
    begin
      if   Assigned( FSynthPatch)
      and  FAudioRunning
      then begin
        FSynthPatch.AcceptPn( aCh, aController, aValue, True);

        if   LogMidiMsgs
        then MidiMsgLogFmt( 'RX RPN  : %s', [ RpnToLog( aCh, aController, aValue)]);
      end;
    end;


    procedure   TFormWren.DoRxNrpnMessage( const aSender: TObject; aCh, aController, aValue: Integer );
    begin
      if   Assigned( FSynthPatch)
      and  FAudioRunning
      then begin
        FSynthPatch.AcceptPn( aCh, aController, aValue, False);

        if   LogMidiMsgs
        then MidiMsgLogFmt( 'RX NRPN : %s', [ NrpnToLog( aCh, aController, aValue)]);
      end;
    end;


    procedure   TFormWren.DoSendMidiByte( const aSender: TObject; aByte: Byte);
    // NOTE: Called from audio thread ...
    begin
      try
        if   WSocketNetMidi.State = wsConnected
        then begin
          WSocketNetMidi.Send( @ aByte, 1);
       // LogMidi( aMsg, 'out');
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoMidiTxShortMessage( const aSender: TObject; const aMsg: TShortMidiMessage);
    //
    // todo: it would be better to NOT use PostMessage from the audio thread
    //
    // ** This function is being called from the audio thread.
    //
    // We can not log from here, but we can post the MIDI message to have it logged.
    //
    var
      LParam : NativeInt;
      WParam : NativeUInt;
    begin
      try
        SendShortNetMidi( aMsg);
      except
        on E: Exception
        do KilledException( E);
      end;

      if   LogMidiMsgs
      then begin
        LParam := aMsg.DataLen;
        WParam :=
          ( NativeUInt( aMsg.Command) shl  0) +
          ( NativeUInt( aMsg.Channel) shl  8) +
          ( NativeUInt( aMsg.Data1  ) shl 16) +
          ( NativeUInt( aMsg.Data2  ) shl 24) ;
        PostMessage( Handle, UM_MIDI_LOG, WParam, LParam);
      end;
    end;


// private

    procedure   TFormWren.ResetInPeaks;
    var
      i : Integer;
    begin
      for i := Low( FDbMinMaxIn) to High( FDbMinMaxIn)
      do  FDbMinMaxIn[ i].Clear;

      UpdateDbLabels;
    end;


    procedure   TFormWren.ResetOutPeaks;
    var
      i : Integer;
    begin
      for i := Low( FDbMinMaxOut) to High( FDbMinMaxOut)
      do  FDbMinMaxOut[ i].Clear;

      UpdateDbLabels;
    end;


    procedure   TFormWren.ResetPeaks;
    begin
      ResetInPeaks;
      ResetOutPeaks;
    end;


    procedure   TFormWren.ClearVUMeters;
    begin
      ResetPeaks;
    end;


    procedure   TFormWren.MemoDebugWindowProc( var aMsg: TMessage);
    var
      aTicks     : SmallInt;
      aScrollMsg : TWMVScroll;
    begin
      if   aMsg.Msg = WM_MOUSEWHEEL
      then begin
        aScrollMsg.Msg := WM_VSCROLL;
        aTicks         := SmallInt( HiWord( aMsg.WParam));

        if   aTicks > 0
        then aScrollMsg.ScrollCode := SB_LINEUP
        else aScrollMsg.ScrollCode := SB_LINEDOWN;

        aScrollMsg.Pos := 0;
        MemoDebug.Dispatch( aScrollMsg) ;
      end
      else FOldMemoDebug( aMsg);
    end;


//  private


    procedure   TFormWren.UMMIDILog( var aMsg: TMsgMIDILog); // message UM_MIDI_LOG;
    var
      aMidiMsg : TShortMidiMessage;
    begin
      if   LogMidiMsgs
      then begin
        aMidiMsg.DataLen := aMsg.LParam;
        aMidiMsg.Command := ( aMsg.WParam shr  0) and $ff;
        aMidiMsg.Channel := ( aMsg.WParam shr  8) and $ff;
        aMidiMsg.Data1   := ( aMsg.WParam shr 16) and $ff;
        aMidiMsg.Data2   := ( aMsg.WParam shr 24) and $ff;
        MidiMsgLogFmt( 'TX : %s', [ ShortMidiMessageToLog( aMidiMsg)]);
      end;
    end;


    procedure   TFormWren.UMMidiData ( var aMsg: TMsgMidiData); // message   UM_MIDIDATA;
    begin
      try
        while FMidiFifo.FillCount > 0
        do    SendMidiBytes( FMidiFifo.GetData);
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.UMOSCString( var aMsg: TMsgOSCData); //message UM_OSCDATA;
    begin
      try
        while FOSCFifo.FillCount > 0
        do    SendOSCBytes( FOSCFifo.GetData);
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.UMLiveMorph( var aMsg: TMsg); // message UM_LIVE_MORPH;
    var
      i : Integer;
    begin
      if   Assigned( FSynthPatch)
      then begin
        if   AllowLiveMorphMod
        then begin
          LiveMorph := FSynthPatch.Morph[ 0];

          if   FSynthPatch.AutoFlag[ afRandomize]
          then begin
            FSynthPatch.AutoFlag[ afRandomize] := False;
            PatchRandomize;
          end;

          if   FSynthPatch.AutoFlag[ afMutate]
          then begin
            FSynthPatch.AutoFlag[ afMutate] := False;
            PatchMutate;
          end;

          if   FSynthPatch.AutoFlag[ afMate]
          then begin
            FSynthPatch.AutoFlag[ afMate] := False;
            PatchMate;
          end;

          if   FSynthPatch.AutoFlag[ afMorph]
          then begin
            FSynthPatch.AutoFlag[ afMorph] := False;
            PatchMorph;
          end;

          if   FSynthPatch.AutoFlag[ afPatchReset]
          then begin
            FSynthPatch.AutoFlag[ afPatchReset] := False;
            FSynthPatch.Reset;
          end;

          if   FSynthPatch.AutoFlag[ afPatchCompile]
          then begin
            FSynthPatch.AutoFlag[ afPatchCompile] := False;
            CompilePatch( False, False);
          end;
        end;

        if   AllowMorphMod
        then begin
          for i := 1 to 4
          do  Morph[ i] := FSynthPatch.Morph[ i];
        end;
      end;
    end;


//  private

    procedure   TFormWren.SendOSCBytes( const aMsg: TBytes);
    begin
      try
        if   UseOSC
        and  ( WSocketOSC.State = wsConnected)
        and  ( OSCServer <> '')
        then begin
          WSocketOSC.Send( @ aMsg[ 0], Length( aMsg));
          LogOSCMessage( aMsg, 'out');
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.QueueOSCBytes( const aMsg: TBytes);
    //
    // todo: it would be better to NOT use PostMessage from the audio thread
    //
    // ** This function is being called from the audio thread.
    //
    // We can not directly send from here, but we can post the OSC message
    //
    begin
      try
        if   UseOSC
        and  ( WSocketOSC.State = wsConnected)
        and  ( OSCServer <> '')
        then begin
          FOSCFifo.Append( aMsg);
          PostMessage( Handle, UM_OSCDATA, 0, 0);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.DoSendOSCBytes( const aSender: TObject; const aMsg: TBytes);
    begin
      try
        QueueOSCBytes( aMsg);
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.SendOSCTestMessage;
    var
      anOSCMessage: TOSCMessage;
    begin
      anOSCMessage := TOSCMessage.Create( TEST_PACKET_NAME);
      try
        anOSCMessage.AddFloat  ( 1.000 ); // Send float first, so an OScMessage module can pick it up.
        anOSCMessage.AddInteger( 1001  );
        anOSCMessage.AddString ( '1002');
        SendOSCBytes( anOSCMessage.ToOSCBytes);
      finally
        FreeAndNil( anOSCMessage);
      end;
    end;


    procedure   TFormWren.HandleLocalOSCPacket( anOSCPacket: TOSCPacket);
    begin

      // nothing yet .. may do volume controls .. for instance

    end;


    function    TFormWren.OscHandler( const aControl: TControl; aControlClass: TControlClass; const aUserData: TObject): Boolean;
    var
      aValuedControl : TKnobsValuedControl;
      anOSCPacket    : TOSCPacket;
      aModule        : TKnobsCustomModule;
      aModuleName    : string;
      anOSCPattern   : string;
      aLocMsg        : TOSCMessage;
      aValue         : TSignal;
      aSteps         : Integer;
      aPos           : Integer;
    begin
      Result := True;

      if   ( aUserData is TOSCPacket         )
      and  ( aControl  is TKnobsValuedControl)
      then begin
        aValuedControl := TKnobsValuedControl( aControl);

        if   aValuedControl.AllowAutomation
        then begin
          if    Assigned( aValuedControl.Parent)
          and  ( aValuedControl.Parent is TKnobsCustomModule)
          then begin
            aModule := TKnobsCustomModule( aValuedControl.Parent);

            if   ( Length( aModule.Name) > 0)
            and  ( aModule.Name[ Low( aModule.Name)] = '@')
            then begin
              aModuleName := Copy( aModule.Name, Low( aModule.Name) + 1, Length( aModule.Name) - 1);

              if   aModuleName <> ''
              then begin
                anOSCPattern  := Format( '/%s/%s/%s', [ SynthName, aModuleName, aValuedControl.Name], AppLocale);
                anOSCPacket   := TOSCPacket( aUserData);
                aLocMsg       := anOSCPacket.MatchAddress( anOSCPattern);

                if   Assigned( aLocMsg)
                then begin
                  aLocMsg.Decode;

                  if   SameText( string( aLocMsg.TypeTag[ 0]), 'f')
                  then begin
                    aValue := Clip( aLocMsg.ArgumentAsFloat[ 0], 0.0, 1.0);
                    aSteps := aValuedControl.StepCount;
                    aPos   := Round( RangeMap( aValue, 0.0, 1.0, 0.0, aSteps));
                    Result := False;

                    try
                      aValuedControl.AutomationPosition := aPos;
                    except
                      on E: Exception
                      do KilledException( E);
                    end;
                  end;
                end
              end;
            end;
          end;
        end;
      end;
    end;


    procedure   TFormWren.AcceptOSCBytes( const aMsg: TBytes);
    var
      anOSCPacket : TOSCPacket;
    begin
      try
        anOSCPacket := TOSCPacket.Unpack( aMsg, Length( aMsg));

        try
          if   Assigned( anOSCPacket)
          then begin
            if   Assigned( FSynthPatch)
            and  FAudioRunning
            then FSynthPatch.AcceptOSC( SynthName, anOSCPacket);

            if   not anOSCPacket.Matched
            then begin
              if   Assigned( PatchEditor)
              and  FAudioRunning
              then PatchEditor.VisitControls( 0, nil, '', OscHandler, anOSCPacket);

              if   not anOSCPacket.Matched
              then HandleLocalOSCPacket( anOSCPacket);
            end;

            LogOSCMessage( aMsg, 'in ');
          end;
        finally
          anOSCPacket.DisposeOf;
        end;

        LedOSCRx1.Active := True;
        LedOSCRx2.Active := True;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.LogOSCMessage( const aMsg: TBytes; const aLabel: string);
    var
      anOSCPacket : TOSCPacket;
      aLocMsg     : TOSCMessage;
    begin
      if   LogOSCMsgs
      then begin
        anOSCPacket := TOSCPacket.Unpack( aMsg, Length( aMsg));

        try
          if   Assigned( anOSCPacket)
          then begin
            aLocMsg := anOSCPacket.MatchAddress( '*');

            if   Assigned( aLocMsg)
            then begin
              aLocMsg.Decode;
              OSCMsgLogFmt( '%s: %s', [ aLabel, aLocMsg.AsString( NO_REVERSE)]);
            end;
          end;
        finally
          anOSCPacket.DisposeOf;
        end;
      end;
    end;


    procedure   TFormWren.HandleOSCReception;
    type
      TBuffer = array[ 0 .. MaxInt div SizeOf( Byte) - 1] of Byte;
      PBuffer = ^TBuffer;
    var
      aData   : TBytes;
      i       : Integer;
      aBuffer : PBuffer;
      aSize   : Integer;
      bSize   : Integer;
    begin
      try
        aSize := 32768;
        GetMem( aBuffer, aSize);

        try
          bSize := WSocketOSC.Receive( aBuffer, aSize);

          if   bSize > 0
          then begin
            SetLength( aData, bSize);

            for i := 0 to bSize - 1
            do  aData[ i] := aBuffer^[ i];

            AcceptOSCBytes( aData);
          end;
        finally
          FreeMem( aBuffer, aSize);
        end;
      except
        on E: Exception
        do KilledException( E);
      end;
    end;


    procedure   TFormWren.OSCCancel;
    begin
      EditOSCServer .Text    := OSCServer;
      EditOSCPort   .Text    := OSCPort;
      CheckBoxUseOSC.Checked := UseOSC;
      EditSynthName .Text    := SynthName;
      OSCChanged := False;
    end;


    procedure   TFormWren.OSCApply;
    begin
      OSCDisable;
      OSCServer  := EditOSCServer .Text;
      OSCPort    := EditOSCPort   .Text;
      UseOSC     := CheckBoxUseOSC.Checked;
      SynthName  := EditSynthName .Text;
      OSCChanged := False;

      if   UseOSC
      then StartOSCGuard;

      LedOSCEnabled.Active := UseOSC;
    end;


    procedure   TFormWren.OSCEnable;
    begin
      if   UseOSC
      then begin
        try
          WSocketOSC.Port := OSCPort;

          if   OSCServer = ''                     // We are a server - that is we receive broadcasts
          then begin
            OSCLog( 'Setting up server mode');
            WSocketOSC.Proto     := 'udp';
            WSocketOSC.Addr      := '0.0.0.0';
            WSocketOSC.ReuseAddr := True;
            WSocketOSC.Listen;
            BitBtnSendOSCTestMessage.Visible := False;
            StartOSCGuard;
          end
          else begin                              // We are a client, that is we send broadcasts
            OSCLog( 'Setting up client mode');
            WSocketOSC.Proto     := 'udp';
            WSocketOSC.Addr      := OSCServer;
            WSocketOSC.ReuseAddr := False;
            WSocketOSC.Connect;
            BitBtnSendOSCTestMessage.Visible := True;
            StartOSCGuard;
          end;
        except
          on E: Exception
          do OSCLogFmt( 'Error opening socket : %s', [ E.ToString]);
        end;
      end;
    end;


    procedure   TFormWren.OSCDisable;
    begin
      try
        if   WSocketOSC.State <> wsClosed
        then begin
          OSCLog( 'Shutting down');
          StopOSCGuard;
          WSocketOSC.CloseDelayed;
        end;
      except
        on E: Exception
        do OSCMsgLogFmt( 'Error closing socket: %s', [ E.ToString]);
      end;
    end;


    procedure   TFormWren.StartOSCGuard;
    begin
      StopOSCGuard;
      TimerOSCGuard.Interval := 1000;
      TimerOSCGuard.Enabled  := True;
    end;


    procedure   TFormWren.StopOSCGuard;
    begin
      TimerOSCGuard.Enabled := False;
    end;


    procedure   TFormWren.OSCGuardFired;
    begin
      StopOSCGuard;

      if   ( WSocketOSC.State = wsClosed)
      and  UseOSC
      and  not ( csDestroying in ComponentState)
      then OSCEnable;
    end;


// public

    function    TFormWren.IsShortCut( var aMessage: TWMKey): Boolean; // override;
    // also see knobs2013.TKnobsLabelEditor.CNKeyDown and knobs2013.TKnobsDisplayEditor.CNKeyDown
    var
      aShiftState : TShiftState;
      aCharCode   : Word;
      aChar       : Char;
    begin
      aShiftState := KeyDataToShiftState( aMessage.KeyData);
      aCharCode   := aMessage.CharCode;
      aChar       := Char( aCharCode);

      if   ( Screen.ActiveForm          = Self          )
      and  ( PageControlMain.ActivePage = TabSheetEditor)
      then begin                                                      // Patch editor is visible
        if   PatchEditor.HasEditPopup                                 // exlude some situations
        then begin                                                    // Editing some text in patch editor
          if                                                          // still ..
            (
              ( ssAlt  in aShiftState) and
              ( aChar = 'X')                                          // Allow program termination
            )
          then Result := inherited                                    // allow
          else Result := False;                                       // Otherwise no know shortcut keys
        end
        else if
             ( UpCase( aChar) = 'R')                                  // R is Randomize .. except when in a an edit control
          or CharInSet( aChar, [ '1' .. '8'])                         // 1 .. 8 select variations
          or ( aCharCode = VK_DELETE)                                 // Should be able to use DEL in edit controls
        then begin
          if   ( aShiftState = [])
          and  (
                 EditSearch      .Focused
            or EditReferenceA    .Focused
            or EditNotesPerOctave.Focused
            or EditOctaveSpan    .Focused
            or EditMiddleNote    .Focused
          )
          then Result := False                                        // Editing, dont allow these keys as shortcuts
          else Result := inherited;                                   // Not editing, allow all shortcuts
        end
        else Result := inherited;                                     // Not a special char, allow as shortcut
      end
      else begin                                                      // Patch editor is not visible
        if                                                            // still ...
          (
            ( aShiftState = []) and
            (
              aCharCode in [ VK_F1 .. VK_F7, VK_F9, VK_F10, VK_F12]   // Allow help etc.
            )
          ) or
          (
            ( ssAlt  in aShiftState) and
            (
              ( aChar = 'X') or                                       // Alow program termination
              ( aChar = 'D') or                                       // Allow sound mute on/off
              ( aChar = 'P') or                                       // Allow MIDI panic
              ( aChar = 'M')                                          // Allow MIDI view
            )
          )
        then Result := inherited                                      // allow
        else Result := False;                                         // Otherwise no know shortcut keys
      end;
    end;


//  private

    procedure   TFormWren.FormantLogger( const aSender: TObject; aLogClass: TLogClass; const aMsg: string);
    begin
      LogFmt( aLogClass, 'Formantlog: %s', [ aMsg]);
    end;


//  private

    procedure   TFormWren.AcceptCommandLine( aCommandLine: Atom);
    const
      BufSize = 1024;
    var
      Buf : array[ 0 .. BufSize] of Char;
      S   : string;
    begin
      if   aCommandLine <> 0
      then Begin
        GlobalGetAtomName( aCommandLine, Buf, BufSize);
        S := StrPas( Buf);

        try
          if   FileExists( S)
          then DoLoadPatch( S, True);
        finally
          GlobalDeleteAtom( aCommandLine);
        end;
      end;
    end;


//  private

    function    TFormWren.GetActiveVariation: Integer;
    begin
      Result := PatchEditor.ActiveVariation;
    end;


    procedure   TFormWren.SetActiveVariation( aValue: Integer);
    begin
      {$ifdef DEBUG_WORMS} LogFmt( LC_RANDOMIZER, 'TFormWren.SetActiveVariation.Enter: %d -> %d', [ ActiveVariation, aValue]); {$endif}

      PatchEditor.ActiveVariation := aValue;
      PatchEditor.FillWorm( KnobsWormPatch, -1);

      if   Assigned( FormRandomizer)
      and  FormRandomizer.Visible
      then FormRandomizer.PatchChanged( -1);

      {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.SetActiveVariation.Leave'); {$endif}
    end;


    procedure   TFormWren.DoRandomizerLiveMorphChanged( const aSender: TObject; aValue: TSignal);
    begin
      {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.DoRandomizerWormsChanged.Enter'); {$endif}

      LiveMorph := aValue;

      {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.DoRandomizerWormsChanged.Leave'); {$endif}
    end;


    procedure   TFormWren.DoRandomizerSendToEditor( const aSender: TKnobsWormPanel; const aSelection: TWormSelection);
    var
      s : Integer;
      t : Integer;
    begin
      if   Assigned( aSender)
      then begin
        s := 0;
        t := 0;

        while ( s < 24)
        and   ( t <  8)
        do begin
          if   s in aSelection
          then begin
            if   KnobsWormPanelVariations.Worm[ t].Size = aSender.Worm[ s].Size
            then begin
              KnobsWormPanelVariations.Worm[ t].CopyFrom( aSender.Worm[ s]);
              PatchEditor.AcceptGene( KnobsWormPanelVariations.Worm[ t].Gene, t);
            end;

            Inc( t);
          end;

          Inc( s);
        end;

      end;
    end;


    procedure   TFormWren.DoRandomizerLoadFromEditor( const aSender: TKnobsWormPanel; const aSelection: TWormSelection);
    var
      s : Integer;
      t : Integer;
    begin
      if Assigned( aSender)
      then begin
        s := 0;
        t := 0;

        while ( s <  8)
        and   ( t < 24)
        do begin
          if   t in aSelection
          then begin
            aSender.Worm[ t].CopyFrom( KnobsWormPanelVariations.Worm[ s]);
            Inc( s);
          end;

          Inc( t);
        end;
      end;
    end;


    procedure   TFormWren.DoPatchRandomize( const aSender: TObject);
    begin
      PatchRandomize;
    end;


    procedure   TFormWren.DoPatchMutate( const aSender: TObject);
    begin
      PatchMutate;
    end;


    procedure   TFormWren.DoPatchMate( const aSender: TObject);
    begin
      PatchMate;
    end;


    procedure   TFormWren.DoPatchMorph( const aSender: TObject);
    begin
      PatchMorph;
    end;


    procedure   TFormWren.DoWormSelected( const aSender: TObject; const aWorm: TKnobsWorm);
    begin
      WormSelected( aWorm);
    end;


    procedure   TFormWren.DoWormDropped( const aSender: TObject; const aWorm: TKnobsWorm);
    begin
      WormDropped( aWorm);
    end;


    procedure   TFormWren.SetLiveMorph( aValue: TSignal);
    var
      UpdateVisuals : Boolean;
    begin
      aValue := Clip( aValue, 0.0, 1.0);

      if   aValue <> FLiveMorph
      then begin
        FLiveMorph := aValue;
        knob_livemorph.KnobPosition := Round( aValue * ( knob_livemorph.StepCount - 1));
        UpdateVisuals := Abs( FOldLiveMorph - aValue) > 0.1;

        if   UpdateVisuals
        then FOldLiveMorph := aValue;

        PatchLiveMorph( UpdateVisuals);
      end;
    end;


    procedure   TFormWren.SetAllowLiveMorphMod( aValue: Boolean);
    begin
      if   aValue <> FallowLiveMorphMod
      then begin
        FallowLiveMorphMod    := aValue;
        knob_livemorph.Locked := aValue;
        knobsSelector_allowlivemorph .KnobPosition := IfThen( aValue, 1, 0);
        MenuActionLiveMorphModulation.Checked      := FallowLiveMorphMod;
      end;
    end;


    procedure   TFormWren.SetAllowMorphMod( aValue: Boolean);
    begin
      if   aValue <> FallowMorphMod
      then begin
        FallowMorphMod    := aValue;
        knob_morph.Locked := aValue;
        knobsselector_allowmorphmod.KnobPosition := IfThen( aValue, 1, 0);
        MenuActionMorphModulation  .Checked      := FallowMorphMod;
      end;
    end;


    function    TFormWren.GetMorph( anIndex: Integer): TSignal;
    begin
      Result := RangeValue( anIndex);
    end;


    procedure   TFormWren.SetMorph( anIndex: Integer; aValue : TSignal);
    begin
      if   Morph[ anIndex] <> aValue
      then begin
        SetRangeValue( anIndex, aValue);

        if  Assigned( PatchEditor)
        then begin
          PatchEditor.SetValueForRange( anIndex, aValue);

          if   ( PatchEditor.ActiveRange = anIndex)
          and  RangeIsMorph( anIndex)
          then knob_morph.KnobPosition := Round( aValue * ( knob_morph.StepCount - 1));
        end;
      end;
    end;


    procedure   TFormWren.HandleMorphing;
    //
    // todo: it would be better to NOT use PostMessage from the audio thread
    //
    // ** This function is being called from the audio thread.
    //
    // We can not morph from here, but we can post a message
    //
    begin
      FMorphAccu := FMorphAccu + 1;

      if   FMorphAccu >= MorphDecimation
      then begin
        FMorphAccu := FMorphAccu - MorphDecimation;
        PostMessage( handle, UM_LIVE_MORPH, 0, 0);
      end;
    end;


// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Delphi area


procedure TFormWren.VariationSelectClicked(Sender: TObject);
begin
  {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.VariationSelectClicked.Enter'); {$endif}

  KnobsWormPanelVariations.Selected := ( Sender as TMenuItem).Tag;

  {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.VariationSelectClicked.Leave'); {$endif}
end;


procedure TFormWren.ActionMenuExcludeallfromrandomizationClick(Sender: TObject);
begin
  if   Assigned( PatchEditor)
  then PatchEditor.SetAllowAllRandomization( False);
end;


procedure TFormWren.ActionMenuIncludeallforrandomizationClick(Sender: TObject);
begin
  if   Assigned( PatchEditor)
  then PatchEditor.SetAllowAllRandomization( True);
end;


procedure TFormWren.ActionMenuManualCompilationClick(Sender: TObject);
begin
  ManualCompilation := not ManualCompilation;
end;

procedure TFormWren.MenuItemDataMakerExcludefromrandomizationClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then KnobToggleRandomization( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.MenuItemDataMakerRandomizeClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then SetRandomKnobValue( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.MenuItemGridControlLoadFromFileClick(Sender: TObject);
begin
  ( FPopupSender as TKnobsGridControl).LoadFromFile;
end;

procedure TFormWren.MenuItemGridControlSaveToFileClick(Sender: TObject);
begin
  ( FPopupSender as TKnobsGridControl).SaveToFile;
end;

procedure TFormWren.MenuItemKnobRandomizeClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then SetRandomKnobValue( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.ToggleSelectorRandomizationClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then KnobToggleRandomization( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.PopupMenuDataMakerClick(Sender: TObject);
begin
  FillDataMaker( FPopupSender as TKnobsDataMaker, TKnobsDMShape(( Sender as TMenuItem).Tag))
end;


procedure TFormWren.UpDownWireThicknessClick(Sender: TObject; Button: TUDBtnType);
begin
  if   Button = btNext
  then WireThickness := WireThickness + 1
  else WireThickness := WireThickness - 1;
end;

procedure TFormWren.ComboBoxColorsChange(Sender: TObject);
begin
  ChangeColorId( ComboBoxColors.ItemIndex);
end;


procedure TFormWren.ComboBoxPresetsChange(Sender: TObject);
begin
  LoadLookAndFeel( Format( '%s\%s', [ LooksPath, ComboboxPresets.Items[ ComboboxPresets.ItemIndex]], AppLocale));
end;


procedure TFormWren.ComboBoxThemesChange(Sender: TObject);
begin
  Theme := ComboBoxThemes.Items[ ComboBoxThemes.ItemIndex];
end;


procedure TFormWren.PageControlMainChange(Sender: TObject);
begin
  FixMenu;

  if PageControlMain.ActivePage = TabSheetEditor
  then DoUnFocus( Self);
end;

procedure TFormWren.MenuActionLiveMorphModulationClick(Sender: TObject);
begin
  AllowLiveMorphMod := not AllowLiveMorphMod;
end;


procedure TFormWren.MenuActionMateClick(Sender: TObject);
begin
  PatchMate;
end;


procedure TFormWren.MenuActionMorphClick(Sender: TObject);
begin
  PatchMorph;
end;


procedure TFormWren.MenuActionMorphModulationClick(Sender: TObject);
begin
  AllowMorphMod := not AllowMorphMod;
end;

procedure TFormWren.MenuActionMutteClick(Sender: TObject);
begin
  PatchMutate;
end;


procedure TFormWren.MenuActionPanicClick(Sender: TObject);
begin
  Panic;
end;


procedure TFormWren.MenuViewTopPaneClick(Sender: TObject);
begin
  ShowTopPane := not ShowTopPane;
end;


procedure TFormWren.MenuActionToggleExcludedModulesClick(Sender: TObject);
begin
  ToggleExcludedModules;
end;


procedure TFormWren.MenuActionTogglelightsClick(Sender: TObject);
begin
  LightsActive := not LightsActive;
end;


procedure TFormWren.MenuActionToggleSoundClick(Sender: TObject);
begin
  ToggleSound;
end;


procedure TFormWren.MenuEditToggleWiresClick(Sender: TObject);
begin
  ToggleWires;
end;


procedure TFormWren.MenuFileLoadtemplate1Click(Sender: TObject);
begin
  DoLoadPatch( Template1Name, False);
end;


procedure TFormWren.MenuFileLoadtemplate2Click(Sender: TObject);
begin
  DoLoadPatch( Template2Name, False);
end;


procedure TFormWren.selectnone1Click(Sender: TObject);
begin
  SelectNone;
end;


procedure TFormWren.invertselection1Click(Sender: TObject);
begin
  InvertSelection;
end;


procedure TFormWren.selectall1Click(Sender: TObject);
begin
  SelectAll;
end;


procedure TFormWren.pastevalues1Click(Sender: TObject);
begin
  PasteParameters( True);
end;


procedure TFormWren.paste1Click(Sender: TObject);
begin
  PasteModules;
end;


procedure TFormWren.copy1Click(Sender: TObject);
begin
  CopyModules;
end;


procedure TFormWren.MenuSavepatchpresetClick(Sender: TObject);
begin
  SavePatchPreset;
end;


procedure TFormWren.MenuFileLoadpatchPresetClick(Sender: TObject);
begin
  LoadPatchPreset;
end;


procedure TFormWren.MenuItemModuleLoadFromPresetClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsCustomModule
  then LoadPreset( FPopupSender as TKnobsCustomModule);
end;


procedure TFormWren.MenuItemModulePasteParamsStrictClick(Sender: TObject);
begin
  ModulePasteParams( FPopupSender as TKnobsModule, True);
end;


procedure TFormWren.MenuItemModuleRandomizeClick(Sender: TObject);
begin
  ModuleRandomize( FPopupSender as TKnobsModule);
end;


procedure TFormWren.MenuItemModuleSaveAsPresetClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsCustomModule
  then SavePreset( FPopupSender as TKnobsCustomModule);
end;


procedure TFormWren.MenuItemPasteParamsNonStrictClick(Sender: TObject);
begin
  ModulePasteParams( FPopupSender as TKnobsModule, False);
end;


procedure TFormWren.MenuItemXYControlExcludefromrandomizationClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then KnobToggleRandomization( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.MenuItemXYControlRandomizeClick(Sender: TObject);
begin
  if   IsVariation( FPopupSender)
  then SetRandomKnobValue( FPopupSender as IKnobsVariation);
end;


procedure TFormWren.UnassignCCClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsValuedControl
  then UnAssignMidiCC( FPopupSender as TKnobsValuedControl);
end;


procedure TFormWren.AssigntoCCClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsValuedControl
  then AssignLastCCToKnob( FPopupSender as TKnobsValuedControl);
end;


procedure TFormWren.main_midichValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
  IsFinal, IsAutomation: Boolean);
begin
  MidiChannel := Round( aValue);
end;


procedure TFormWren.MenuItemModuleDefaultcolorClick(Sender: TObject);
begin
  ModuleColorDefault( FPopupSender as TKnobsModule);
end;


procedure TFormWren.Defaultwirecolor1Click(Sender: TObject);
begin
  SetWireColorDefault( FPopupSender as TKnobsConnector);
end;


procedure TFormWren.delete1Click(Sender: TObject);
begin
  DeleteModules;
end;

procedure TFormWren.Redwires1Click(Sender: TObject);
begin
  SetWireColor( FPopupSender as TKnobsConnector, clRed);
end;


procedure TFormWren.MakeGreenClick(Sender: TObject);
begin
  SetWireColor( FPopupSender as TKnobsConnector, clLime);
end;


procedure TFormWren.ModuleHelpClick(Sender: TObject);
begin
  ShowModuleHelp( FPopupSender as TKnobsModule);
end;


procedure TFormWren.MenuEditPasteValuesClick(Sender: TObject);
begin
  PasteParameters( True);
end;


procedure TFormWren.MenuActionRecompileClick(Sender: TObject);
begin
  CompilePatch( False, False);
end;


procedure TFormWren.MenuActionResetClick(Sender: TObject);
begin
  if   Assigned( FSynthPatch)
  then begin
    FSynthPatch.Reset;
    ClearOverUnderFlows;
  end;
end;


procedure TFormWren.MenuFileExportselectedmodulesClick(Sender: TObject);
begin
  ExportModules;
end;


procedure TFormWren.MenuFileImportmodulesClick(Sender: TObject);
begin
  ImportPatch;
end;


procedure TFormWren.MenuActionStartfilerenderClick(Sender: TObject);
begin
  RenderToFile := not RenderToFile;
end;


procedure TFormWren.MenuFileSaveastemplate1Click(Sender: TObject);
begin
  SaveAsTemplate1;
end;


procedure TFormWren.MenuFileSaveastemplate2Click(Sender: TObject);
begin
  SaveAsTemplate2;
end;


procedure TFormWren.MenuFileSaveastemplateNewClick(Sender: TObject);
begin
  SaveAsTemplateNew;
end;

procedure TFormWren.IndicatorBarVolumeDblClick(Sender: TObject);
begin
  ClearVUMeters;
end;


procedure TFormWren.MenuItemModuleColorClick(Sender: TObject);
begin
  ChangeModuleColor( FPopupSender as TKnobsModule);
end;


procedure TFormWren.ColorBoxComboChange(Sender: TObject);
begin
  ChangeCurrentColor( ColorBoxCombo.Selected);
end;


procedure TFormWren.LabeldBInMaxClick(Sender: TObject);
begin
  ResetInPeaks;
end;


procedure TFormWren.LabeldBOutMaxClick(Sender: TObject);
begin
  ResetOutPeaks;
end;


procedure TFormWren.TextMenuEditClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsTextControl
  then TKnobsTextControl( FPopupSender).Edit;
end;

procedure TFormWren.LabelRunTimeClick(Sender: TObject);
begin
  if   not RenderToFile
  then ResetRuntime;
end;


procedure TFormWren.LockKnobClick(Sender: TObject);
begin
  KnobChangeLock( FPopupSender as TKnobsKnob);
end;


procedure TFormWren.SetKnobDefaultvalueClick(Sender: TObject);
begin
  KnobSetDefaultValue( FPopupSender as TKnobsValuedcontrol)
end;


procedure TFormWren.MenuItemModuleDeleteClick(Sender: TObject);
begin
  ModuleDelete( FPopupSender as TKnobsModule);
end;


procedure TFormWren.MenuItemModuleExludeFromRandomizationClick(Sender: TObject);
begin
  ModuleRandomizationToggle( FPopupSender as TKnobsModule);
end;


procedure TFormWren.MenuItemModuleCopyClick(Sender: TObject);
begin
  ModuleCopy( FPopupSender as TKnobsModule);
end;


procedure TFormWren.Customwirecolor1Click(Sender: TObject);
begin
  SetWireColorCustom( FPopupSender as TKnobsConnector);
end;


procedure TFormWren.cut1Click(Sender: TObject);
begin
  CutModules;
end;


procedure TFormWren.MenuItemModuleCutClick(Sender: TObject);
begin
  ModuleCut( FPopupSender as TKnobsModule);
end;


procedure TFormWren.DisconnectConnectorClick(Sender: TObject);
begin
  ConnectorDisconnect( FPopupSender as TKnobsConnector);
end;


procedure TFormWren.DeleteConnectorClick(Sender: TObject);
begin
  ConnectorDelete( FPopupSender as TKnobsConnector);
end;


procedure TFormWren.MenuEditFindClick(Sender: TObject);
begin
  if   EditSearch.Enabled
  then EditSearch.SetFocus;
end;


procedure TFormWren.MenuEditFindunconnectedmodulesClick(Sender: TObject);
begin
  FindUnconnectedModules;
end;


procedure TFormWren.MenuActionProfileClick(Sender: TObject);
begin
  ProfilePatch;
end;


procedure TFormWren.WSocketNetMidiBgException(Sender: TObject; E: Exception; var CanClose: Boolean);
begin
  MidiLogFmt( 'exception : %s', [ E.ToString]);
  CanClose := True;
end;


procedure TFormWren.WSocketNetMidiChangeState(Sender: TObject; OldState, NewState: TSocketState);
begin
  MidiLogFmt( 'state changed from %s to %s', [ SocketStateToStr( OldState), SocketStateToStr( NewState)]);
end;


procedure TFormWren.WSocketNetMidiDataAvailable(Sender: TObject; ErrCode: Word);
begin
  if   FClosing
  then Exit;

  LedNetMidiRx1.Active := True;
  LedNetMidiRx2.Active := True;

  try
    ReceiveNetMidi;
  except
    on E: Exception
    do KilledException( E);
  end;
end;


procedure TFormWren.WSocketNetMidiDataSent(Sender: TObject; ErrCode: Word);
begin
  if   FClosing
  then Exit;

  // MidiLogFmt( 'data sent, error code %d', [ ErrCode]);
  LedNetMidiTx1.Active := True;
  LedNetMidiTx2.Active := True;
end;


procedure TFormWren.WSocketNetMidiSessionClosed(Sender: TObject; ErrCode: Word);
begin
  MidiLogFmt( 'session closed, error code %d', [ ErrCode]);
  NetMidiConnected := False;

  if   NetMidiAutoConnect
  and  not FClosing
  then StartNetMidiConnectTimer;
end;


procedure TFormWren.WSocketNetMidiSessionConnected(Sender: TObject; ErrCode: Word);
begin
  MidiLogFmt( 'session connected, error code %d', [ ErrCode]);
  NetMidiConnected := ErrCode = 0;
end;


procedure TFormWren.WSocketOSCBgException(Sender: TObject; E: Exception; var CanClose: Boolean);
begin
  OSCLogFmt( 'Socket background exception : %s', [ E.ToString]);
  CanClose := True;
end;


procedure TFormWren.WSocketOSCChangeState(Sender: TObject; OldState, NewState: TSocketState);
begin
  OSCLogFmt( 'state changed from %s to %s', [ SocketStateToStr( OldState), SocketStateToStr( NewState)]);
end;


procedure TFormWren.WSocketOSCDataAvailable(Sender: TObject; ErrCode: Word);
begin
  if   ErrCode = 0
  then HandleOSCReception
  else OSCMsgLogFmt( 'Data Available, error: %d', [ ErrCode]);
end;


procedure TFormWren.WSocketOSCDataSent(Sender: TObject; ErrCode: Word);
begin
  if   ErrCode = 0
  then begin
    if   FClosing
    then Exit;

    LedOSCTx1.Active := True;
    LedOSCTx2.Active := True;
  end
  else OSCMsgLogFmt( 'Data Sent, error: %d', [ ErrCode]);
end;


procedure TFormWren.WSocketOSCSessionAvailable(Sender: TObject; ErrCode: Word);
begin
  if   ErrCode = 0
  then OSCLog( 'Session Available')
  else OSCLogFmt( 'Session Available, error %d', [ ErrCode]);
end;


procedure TFormWren.WSocketOSCSessionClosed(Sender: TObject; ErrCode: Word);
begin
  if   ErrCode = 0
  then begin
    OSCLog( 'Session Closed');

    if   UseOSC
    and  not FClosing
    then StartOSCGuard;
  end
  else OSCLogFmt( 'Session Closed, error: %d', [ ErrCode]);
end;


procedure TFormWren.WSocketOSCSessionConnected(Sender: TObject; ErrCode: Word);
begin
  OscLogFmt( 'session connected, error code %d', [ ErrCode]);

  if   UseOSC
  and  not FClosing
  and  ( ErrCode <> 0)
  then StartOSCGuard;
end;


procedure TFormWren.Yellowwires1Click(Sender: TObject);
begin
  SetWireColor( FPopupSender as TKnobsConnector, clYellow);
end;


procedure TFormWren.MenuViewGraphsClick(Sender: TObject);
begin
  ViewGraphs;
end;


procedure TFormWren.MenuViewLatestEditsClick(Sender: TObject);
begin
  if   Assigned( FormLastEdits)
  then FormLastEdits.Show;
end;

procedure TFormWren.MenuViewDebuggerClick(Sender: TObject);
begin
  ViewDebug;
end;


procedure TFormWren.EditMiddleNoteChange(Sender: TObject);
begin
  TuningChanged := True;
end;


procedure TFormWren.EditNetMidiPortChange(Sender: TObject);
begin
  NetMidiChanged := True;
end;


procedure TFormWren.EditNetMidiServerChange(Sender: TObject);
begin
  NetMidiChanged := True;
end;


procedure TFormWren.EditNewPatchNameTemplateChange(Sender: TObject);
begin
  NewPatchNameTemplate := EditNewPatchNameTemplate.Text;
end;

procedure TFormWren.EditNotesPerOctaveChange(Sender: TObject);
begin
  TuningChanged := True;
end;


procedure TFormWren.EditOctaveSpanChange(Sender: TObject);
begin
  TuningChanged := True;
end;

procedure TFormWren.EditOSCPortChange(Sender: TObject);
begin
  OSCChanged := True;
end;


procedure TFormWren.EditOSCServerChange(Sender: TObject);
begin
  OSCChanged := True;
end;


procedure TFormWren.MenuViewEditorClick(Sender: TObject);
begin
  ViewEditor;
end;


procedure TFormWren.EditReferenceAChange(Sender: TObject);
begin
  TuningChanged := True;
end;


procedure TFormWren.EditSearchChange(Sender: TObject);
begin
  SearchInPatch   ( EditSearch.Text);
  SearchInSelector( EditSearch.Text);
end;


procedure TFormWren.EditSearchKeyPress(Sender: TObject; var Key: Char);
begin
  if   Word( Key) = VK_ESCAPE
  then begin
    EditSearch.Text := '';
    Key             := #0;
    DoUnfocus( Sender);
  end;
end;


procedure TFormWren.EditSynthNameChange(Sender: TObject);
begin
  OSCChanged := True;
end;


procedure TFormWren.EditTextWriterPrefixChange(Sender: TObject);
begin
  TextWriterPrefix := EditTextWriterPrefix.Text;
end;

procedure TFormWren.RadioGroupControlDecimationClick(Sender: TObject);
begin
  case RadioGroupControlDecimation.ItemIndex of
    0 :  ControlDecimation :=  4;
    2 :  ControlDecimation := 16;
    3 :  ControlDecimation := 32;
    else ControlDecimation :=  8;
  end;
end;

procedure TFormWren.RadioGroupControlModeClick(Sender: TObject);
begin
  ControlMode := TDistanceMode( RadioGroupControlMode.ItemIndex);
end;


procedure TFormWren.RadioGroupRpnModeClick(Sender: TObject);
begin
  MidiRpnMode := TRpnMode( RadioGroupRpnMode.ItemIndex);
end;

procedure TFormWren.RadioGroupSampleRateClick(Sender: TObject);
begin
  case RadioGroupSampleRate.ItemIndex of
    1 :  Samplerate := 48000;
    2 :  Samplerate := 88200;
    3 :  Samplerate := 96000;
    else Samplerate := 44100;
  end;
end;


procedure TFormWren.MenuActionRandomizeClick(Sender: TObject);
begin
  PatchRandomize;
end;


procedure TFormWren.MenuActionRandomparamsClick(Sender: TObject);
begin
  SetRandomValue;
end;

procedure TFormWren.MenuSetupSettingsClick(Sender: TObject);
begin
  ViewSettings;
end;


procedure TFormWren.MenuViewSettingsClick(Sender: TObject);
begin
  ViewSettings;
end;


procedure TFormWren.MenuViewMidiClick(Sender: TObject);
begin
  ViewMIDIAssignments;
end;


procedure TFormWren.MenuViewRandomizerClick(Sender: TObject);
begin
  ViewHideRandomizer;
end;


procedure TFormWren.KnobMIDICCClick(Sender: TObject);
begin
  if   FPopupSender is TKnobsValuedControl
  then AssignMidiCC( FPopupSender as TKnobsValuedControl);
end;


procedure TFormWren.MenuHelpHelpClick(Sender: TObject);
begin
  ShowHelp;
end;


procedure TFormWren.SpeedButtonChangeControlPanelClick(Sender: TObject);
var
  NewWidth : Integer;
  OldWidth : Integer;
begin
  OldWidth := PanelControl.Width;

  if   PanelControl.Width = 0
  then NewWidth := FLastControlWidth
  else begin
    FLastControlWidth := PanelControl.Width;
    NewWidth          := 0;
  end;

  if   NewWidth < OldWidth
  then begin
    PanelControl.Width := NewWidth;
    Width              := Width - OldWidth + NewWidth;
  end
  else begin
    Width              := Width - OldWidth + NewWidth;
    PanelControl.Width := NewWidth;
  end;

  FixControlFoldButton;
end;


procedure TFormWren.SpeedButtonChangeModuleSelectorClick(Sender: TObject);
begin
  if   ModuleSelector.Width = 0
  then ModuleSelector.Width := FLastSelectorWidth
  else begin
    FLastSelectorWidth  := ModuleSelector.Width;
    ModuleSelector.Width := 0;
  end;

  FixSelectorFoldButton;
end;


procedure TFormWren.MenuFileNewClick(Sender: TObject);
begin
  NewPatch;
end;


procedure TFormWren.MenuSetupDevicesClick(Sender: TObject);
begin
  with FormWaveDeviceSelect
  do begin
    PAInitialized      := Self.FPortAudioAvailable;
    SelectedAPIID      := Self.FSelectedAPIID;
    SelectedInputIdPA  := Self.FSelectedInputIdPA;
    SelectedOutputIdPA := Self.FSelectedOutputIdPA;
    BufferSize         := Self.FBufferSize;

    if   Execute
    then begin
      FRequestAudioStart     := False;
      FRequestAsioPanel      := False;
      FRequestAudioRestart   := False;
      FPanelAudioWasRunning  := False;
      SelectDevices;
    end;
  end;
end;


procedure TFormWren.MenuEditWiggleWiresClick(Sender: TObject);
begin
  WiggleWires;
end;


procedure TFormWren.MenuEditRedoClick(Sender: TObject);
begin
  if   Assigned( PatchEditor)
  then begin
    PatchEditor.Redo;
    RegisterMidiControls;
    RegisterRandomParamsAll;
  end;
end;


procedure TFormWren.MenuEditUndoClick(Sender: TObject);
begin
  if   Assigned( PatchEditor)
  then begin
    PatchEditor.Undo;
    RegisterMidiControls;
    RegisterRandomParamsAll;
  end;
end;


procedure TFormWren.MenuEditInvertSelectionClick(Sender: TObject);
begin
  InvertSelection;
end;


procedure TFormWren.MenuEditSelectAllClick(Sender: TObject);
begin
  SelectAll;
end;


procedure TFormWren.MenuEditSelectNoneClick(Sender: TObject);
begin
  SelectNone;
end;


procedure TFormWren.MenuEditPasteClick(Sender: TObject);
begin
  PasteModules;
end;


procedure TFormWren.MenuActionRunStopClick(Sender: TObject);
begin
  StartStopAudio;
end;


procedure TFormWren.MenuEditCopyClick(Sender: TObject);
begin
  CopyModules;
end;


procedure TFormWren.MenuEditCutClick(Sender: TObject);
begin
  CutModules;
end;


procedure TFormWren.MenuEditDeleteClick(Sender: TObject);
begin
  DeleteModules;
end;


procedure TFormWren.MenuFileExitProgramClick(Sender: TObject);
begin
  if   FDebugRunning
  then DebugRunStop;

  if   RenderToFile
  then RenderToFile := False
  else Close;
end;


procedure TFormWren.MenuFileSaveClick(Sender: TObject);
begin
  SavePatch;
end;


procedure TFormWren.MenuFileSaveAsClick(Sender: TObject);
begin
  SavePatchAs;
end;


procedure TFormWren.MenuFileLoadClick(Sender: TObject);
begin
  LoadPatch;
end;


procedure TFormWren.MenuFileLoadlastpatchClick(Sender: TObject);
begin
  LoadLastPatch;
end;

function TFormWren.ModuleSelectorGetGlyph(const aSender: TObject; const aBitmapsFolder, aName: string): TBitmap;
begin
  Result := FormStore.FindBitmap( aName);
end;


procedure TFormWren.ModuleSelectorModuleButtonClick(aSender: TObject; aModuleclass: Integer);
begin
  AddModule( aModuleclass);
end;


procedure TFormWren.ModuleSelectorResize(Sender: TObject);
begin
  FixSelectorFoldButton;
  SplitterModuleSelector.Left := ModuleSelector.Width + 1;
end;

procedure TFormWren.TimerStatsUpdateTimer(Sender: TObject);
begin
  UpdateStats;
end;


procedure TFormWren.TimerLightsUpdateTimer(Sender: TObject);
begin
  UpdateLights;
end;


procedure TFormWren.TimerLiveMorphVisualsTimer(Sender: TObject);
begin
  UpdateLiveMorphVisuals;
end;


procedure TFormWren.TimerNetMidiConnectTimer(Sender: TObject);
begin
  if   NetMidiAutoConnect
  and  not NetMidiConnected
  then NetMidiConnectTimerFired
  else StopNetMidiConnectTimer;
end;


procedure TFormWren.TimerOSCGuardTimer(Sender: TObject);
begin
  OSCGuardFired;
end;


procedure TFormWren.knob_iolevel_UnFocus(const aSender: TObject);
begin
  DoUnFocus( aSender);
end;


procedure TFormWren.knob_livemorphValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  LiveMorph := aValue;
end;


procedure TFormWren.knob_inputlevel1ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  InVolume1 := knob_inputlevel1.KnobPosition;
end;


procedure TFormWren.knob_inputlevel2ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  InVolume2 := knob_inputlevel2.KnobPosition;
end;


procedure TFormWren.knob_inputlevel3ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  InVolume3 := knob_inputlevel3.KnobPosition;
end;


procedure TFormWren.knob_inputlevel4ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  InVolume4 := knob_inputlevel4.KnobPosition;
end;


procedure TFormWren.knob_outputlevel1ValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OutVolume1 := knob_outputlevel1.KnobPosition;
end;


procedure TFormWren.knob_outputlevel2ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OutVolume2 := knob_outputlevel2.KnobPosition;
end;


procedure TFormWren.knob_outputlevel3ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OutVolume3 := knob_outputlevel3.KnobPosition;
end;


procedure TFormWren.knob_outputlevel4ValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OutVolume4 := knob_outputlevel4.KnobPosition;
end;


procedure TFormWren.LocalUnfocus(const aSender: TObject);
begin
  DoUnfocus( aSender);
end;


procedure TFormWren.KnobsSmallKnob_LightsRateValueChanged(aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  if   IsFinal
  then LightsRate := aValue;
end;


procedure TFormWren.knob_morphValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  RangeValueChanged( aValue);
end;

procedure TFormWren.KnobsNoKnob_HistoryCountValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  HistoryCount := Round( aValue);
end;


procedure TFormWren.knobsSelector_allowlivemorphValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  AllowLiveMorphMod := Round( aValue) = 1;
end;


procedure TFormWren.knobsselector_allowmorphmodValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  AllowMorphMod := Round( aValue) = 1;
end;

procedure TFormWren.KnobsSelectorRandomizeValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  PatchRandomize;
end;

procedure TFormWren.KnobsSelectorRangesKnobPositionChanged(const aSender: TKnobsValuedControl; const aPath,
  aControlType: string; aPosition: Integer);
begin
  RangeChanged( aPosition);
end;

procedure TFormWren.SelectorRightClick(const aSender: TObject);
begin
  if   aSender is TControl
  then DoShowPopupMenu( nil, TControl( aSender));
end;

procedure TFormWren.KnobsSelectorResetValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  if   Assigned( FSynthPatch)
  then FSynthPatch.Reset;
end;

procedure TFormWren.KnobsSelectorAudioRunningValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  if   Round( aValue) = 1
  then StartAudio
  else StopAudio;
end;

procedure TFormWren.KnobsSelectorFileRenderValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  RenderToFile := SignalToLogic( aValue);
end;


procedure TFormWren.KnobsSelectorMateValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  PatchMate;
end;

procedure TFormWren.KnobsSelectorMorphValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  PatchMorph;
end;

procedure TFormWren.KnobsSelectorMutateValueChanged(const aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  PatchMutate;
end;

procedure TFormWren.knob_WheelSensitivityValueChanged(const aSender: TObject; const aPath,
  aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  WheelSensitivity := knob_WheelSensitivity.KnobPosition;
end;


procedure TFormWren.KnobsSmallKnobModuleOpacityValueChanged(const aSender: TObject; const aPath,
  aControlType: string; aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  ModuleOpacity := Clip( Round( aValue), 0, 255);
end;


procedure TFormWren.KnobsSmallKnob_LeftOffsetValueChanged(aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OffsetLeft := Round( aValue);
end;


procedure TFormWren.KnobsSmallKnob_TopOffsetValueChanged(aSender: TObject; const aPath, aControlType: string;
  aValue: Double; IsFinal, IsAutomation: Boolean);
begin
  OffsetTop := Round( aValue);
end;


procedure TFormWren.KnobsWormPanelVariationsSelected(Sender: TObject);
begin
  if   Lock( FWormUpdateLock)
  then begin
    try
      {$ifdef DEBUG_WORMS} LogFmt( LC_RANDOMIZER, 'TFormWren.KnobsWormPanelVariationsSelected.Unlocked.Enter, active variation := %d', [ KnobsWormPanelVariations.Selected]); {$endif}

      ActiveVariation := KnobsWormPanelVariations.Selected;

      {$ifdef DEBUG_WORMS} Log( LC_RANDOMIZER, 'TFormWren.KnobsWormPanelVariationsSelected.Unlocked.Leave'); {$endif}
    finally
      Unlock( FWormUpdateLock);
    end;
  end;
end;


procedure TFormWren.CheckBoxClearVUOnRecompileClick(Sender: TObject);
begin
  ClearVUOnRecompile := CheckBoxClearVUOnRecompile.Checked;
end;


procedure TFormWren.CheckBoxClearVUOnStopClick(Sender: TObject);
begin
  ClearVUOnStop := CheckBoxClearVUOnStop.Checked;
end;


procedure TFormWren.CheckBoxDisableAutoDocsClick(Sender: TObject);
begin
  DisableAutoDocs := CheckBoxDisableAutoDocs.Checked;
end;

procedure TFormWren.CheckBoxAbsTimeStampsClick(Sender: TObject);
begin
 AbsTimeStamps := CheckBoxAbsTimeStamps.Checked;
end;


procedure TFormWren.CheckBoxAllowAutoLoadClick(Sender: TObject);
begin
  AllowAutoLoad := CheckBoxAllowAutoLoad.Checked;
end;

procedure TFormWren.CheckBoxAudioStatusInCaptionClick(Sender: TObject);
begin
  AudioStatusInCaption := CheckBoxAudioStatusInCaption.Checked;
end;


procedure TFormWren.CheckBoxAutoCollectDenormalsClick(Sender: TObject);
begin
  AutoCollectDenormals := CheckBoxAutoCollectDenormals.Checked;
end;


procedure TFormWren.CheckBoxAutoRunClick(Sender: TObject);
begin
  AutoRun := CheckBoxAutoRun.Checked;
end;


procedure TFormWren.CheckBoxCompilerDebugClick(Sender: TObject);
begin
  CompilerDebug := CheckBoxCompilerDebug.Checked;
end;


procedure TFormWren.CheckBoxCurvedLinesClick(Sender: TObject);
begin
  CurvedLines := CheckBoxCurvedLines.Checked;
end;


procedure TFormWren.CheckBoxFileVersionInCaptionClick(Sender: TObject);
begin
  FileVersionInCaption := CheckBoxFileVersionInCaption.Checked;
end;


procedure TFormWren.CheckBoxGraphStairsClick(Sender: TObject);
begin
  GraphStairs := CheckBoxGraphStairs.Checked;
end;


procedure TFormWren.CheckBoxGuidInCaptionClick(Sender: TObject);
begin
  GuidInCaption := CheckBoxGuidInCaption.Checked;
end;

procedure TFormWren.CheckBoxLogMidiClick(Sender: TObject);
begin
  LogMidi := CheckBoxLogMidi.Checked;
end;


procedure TFormWren.CheckBoxLogMidiMsgsClick(Sender: TObject);
begin
  LogMidiMsgs := CheckBoxLogMidiMsgs.Checked;
end;


procedure TFormWren.CheckBoxLogOSCClick(Sender: TObject);
begin
  LogOSC := CheckBoxLogOSC.Checked;
end;


procedure TFormWren.CheckBoxLogOSCMsgsClick(Sender: TObject);
begin
  LogOSCMsgs := CheckBoxLogOSCMsgs.Checked;
end;


procedure TFormWren.CheckBoxLogToFileClick(Sender: TObject);
begin
  LogToFile := CheckBoxLogToFile.Checked;
end;


procedure TFormWren.CheckBoxModuleFlatnessClick(Sender: TObject);
begin
  ModuleFlatness := CheckboxModuleFlatness.Checked;
end;

procedure TFormWren.CheckBoxModuleTextureClick(Sender: TObject);
begin
  ModuleTexture := CheckboxModuleTexture.Checked;
end;

procedure TFormWren.CheckBoxNetMidiAutoConnectClick(Sender: TObject);
begin
  NetMidiAutoConnect := CheckBoxNetMidiAutoConnect.Checked;
end;


procedure TFormWren.CheckBoxNoLoadTuningClick(Sender: TObject);
begin
  NoLoadTuning := CheckBoxNoLoadTuning.Checked;
end;

procedure TFormWren.CheckBoxPatchChangedInCaptionClick(Sender: TObject);
begin
  PatchChangedInCaption := CheckBoxPatchChangedInCaption.Checked;
end;


procedure TFormWren.CheckBoxPatchNameInCaptionClick(Sender: TObject);
begin
  PatchNameInCaption := CheckBoxPatchNameInCaption.Checked;
end;


procedure TFormWren.CheckBoxProfiledInCaptionClick(Sender: TObject);
begin
  ProfiledInCaption := CheckBoxProfiledInCaption.Checked;
end;


procedure TFormWren.CheckBoxProgramNameInCaptionClick(Sender: TObject);
begin
  ProgramNameInCaption := CheckBoxProgramNameInCaption.Checked;
end;


procedure TFormWren.CheckBoxReloadLastPatchClick(Sender: TObject);
begin
  ReloadLastPatch := CheckBoxReloadLastPatch.Checked;
end;


procedure TFormWren.CheckBoxSearchPatchClick(Sender: TObject);
begin
  SearchPatch := CheckBoxSearchPatch.Checked;
end;

procedure TFormWren.CheckBoxSearchSelectorClick(Sender: TObject);
begin
  SearchSelector := CheckBoxSearchSelector.Checked;
end;


procedure TFormWren.CheckBoxSourceNameInCaptionClick(Sender: TObject);
begin
  SourceNameInCaption := CheckBoxSourceNameInCaption.Checked;
end;


procedure TFormWren.CheckBoxStandardColorsClick(Sender: TObject);
begin
  StandardColors := CheckBoxStandardColors.Checked;
end;


procedure TFormWren.CheckBoxSynthNameInCaptionClick(Sender: TObject);
begin
  SynthNameInCaption := CheckBoxSynthNameInCaption.Checked;
end;


procedure TFormWren.CheckBoxUndoAfterLoadClick(Sender: TObject);
begin
  UndoAfterLoad := CheckBoxUndoAfterLoad.Checked;
end;


procedure TFormWren.CheckBoxUndoAfterSaveClick(Sender: TObject);
begin
  UndoAfterSave := CheckBoxUndoAfterSave.Checked;
end;


procedure TFormWren.CheckBoxUseConfigHintsClick(Sender: TObject);
begin
  UseConfigHints := CheckBoxUseConfigHints.Checked;
end;


procedure TFormWren.CheckBoxUseConnectorBordersClick(Sender: TObject);
begin
  UseConnectorBorders := CheckBoxUseConnectorBorders.Checked;
end;

procedure TFormWren.CheckBoxUseGraphsClick(Sender: TObject);
begin
  UseGraphs := CheckBoxUseGraphs.Checked;
end;


procedure TFormWren.CheckBoxUseModuleTitleHintsClick(Sender: TObject);
begin
  UseModuleTitleHints := CheckBoxUseModuleTitleHints.Checked;
end;

procedure TFormWren.CheckBoxUseNoteNamesClick(Sender: TObject);
begin
  UseNoteNames := CheckBoxUseNoteNames.Checked;
end;

procedure TFormWren.CheckBoxUseOSCClick(Sender: TObject);
begin
  OSCChanged := True;
end;


procedure TFormWren.CheckBoxUseTypedConnectorBordersClick(Sender: TObject);
begin
  UseTypedConnectorBorders := CheckBoxUseTypedConnectorBorders.Checked;
end;


procedure TFormWren.CheckBoxUseUnFocusClick(Sender: TObject);
begin
  UseUnFocus := CheckBoxUseUnFocus.Checked;
end;


procedure TFormWren.CheckBoxUseWheelOnKnobsClick(Sender: TObject);
begin
  UseWheelOnKnobs := CheckBoxUseWheelOnKnobs.Checked;
end;


procedure TFormWren.CheckBoxWarnChangeOnLoadClick(Sender: TObject);
begin
  WarnChangeOnLoad := CheckBoxWarnChangeOnLoad.Checked;
end;


procedure TFormWren.CheckBoxWarnOnPatchChangeClick(Sender: TObject);
begin
  WarnOnPatchChange := CheckBoxWarnOnPatchChange.Checked;
end;


procedure TFormWren.CheckBoxWarnOnStructMismatchClick(Sender: TObject);
begin
  WarnOnStructMismatch := CheckBoxWarnOnStructMismatch.Checked;
end;


procedure TFormWren.Checkforupdates1Click(Sender: TObject);
begin
  CheckForUpdates;
end;


procedure TFormWren.BitBtnDebugStepClick(Sender: TObject);
begin
  if   FAudioRunning
  then Log( LC_GENERAL, 'can not do a debug step while audio generation is on')
  else ExecutePatch;
end;


procedure TFormWren.BitBtnDocumentClick(Sender: TObject);
begin
  MakeDocs( DocsPath);    // Forcibly make docs.
  ShowHelp;
end;


procedure TFormWren.BitBtnClearGraphsClick(Sender: TObject);
begin
  ClearGraphs;
end;


procedure TFormWren.BitBtnCloseDubuggerClick(Sender: TObject);
begin
  ViewEditor;
end;


procedure TFormWren.BitBtnCloseGraphsClick(Sender: TObject);
begin
  ViewEditor;
end;


procedure TFormWren.BitBtnModuleTitleFontClick(Sender: TObject);
begin
  if   Assigned( FormStore)
  then begin
    FontDialog.Font.Assign( TitleFont);

    if   FontDialog.Execute
    then TitleFont := FontDialog.Font;
  end;
end;


procedure TFormWren.BitBtnSaveLookAndFeelClick(Sender: TObject);
begin
  SaveLookAndFeel;
end;


procedure TFormWren.BitBtnSendOSCTestMessageClick(Sender: TObject);
begin
  SendOSCTestMessage;
end;


procedure TFormWren.BitBtnShowStoreClick(Sender: TObject);
begin
  FormStore.Show;
end;

procedure TFormWren.BitBtnAcknowledgementsClick(Sender: TObject);
begin
  ShowAcknowledgements;
end;


procedure TFormWren.BitBtnApplyNetMidiClick(Sender: TObject);
begin
  NetMidiApply;
end;


procedure TFormWren.BitBtnApplyOSCClick(Sender: TObject);
begin
  OSCApply;
end;


procedure TFormWren.BitBtnApplyTuningClick(Sender: TObject);
begin
  ApplyTuning;
end;


procedure TFormWren.BitBtnCancelNetMidiClick(Sender: TObject);
begin
  NetMidiCancel;
end;


procedure TFormWren.BitBtnCancelOSCClick(Sender: TObject);
begin
  OSCCancel;
end;


procedure TFormWren.BitBtnCancelTuningClick(Sender: TObject);
begin
  CancelTuning;
end;


procedure TFormWren.BitBtnCheckForUpdatesClick(Sender: TObject);
begin
  CheckForUpdates;
end;


procedure TFormWren.BitBtnClearClick(Sender: TObject);
begin
  ClearLog;
end;


procedure TFormWren.BitBtnDebugResetClick(Sender: TObject);
begin
  if   FAudioRunning
  then Log( LC_GENERAL, 'can not do a debug reset while audio generation is on')
  else begin
    if   Assigned( FSynthPatch)
    then begin
      FSynthPatch.Reset;
      FSynthPatch.ResetSampleCounts;
      FSampleCount := 0;
    end;

    ClearGraphs;
  end;
end;


procedure TFormWren.BitBtnView1Click(Sender: TObject);
var
  NewWidth : Integer;
  OldWidth : Integer;
begin
  OldWidth := PanelControl.Width;
  NewWidth := 48 * ( Sender as TBitBtn).Tag;

  if   NewWidth < OldWidth
  then begin
    PanelControl.Width := NewWidth;
    Width              := Width - OldWidth + NewWidth;
  end
  else begin
    Width              := Width - OldWidth + NewWidth;
    PanelControl.Width := NewWidth;
  end;

  FixControlFoldButton;
end;


procedure TFormWren.Bluewires1Click(Sender: TObject);
begin
  SetWireColor( FPopupSender as TKnobsConnector, clBlue);
end;


procedure TFormWren.BreakConnectorClick(Sender: TObject);
begin
  ConnectorBreak( FPopupSender as TKnobsConnector);
end;


procedure TFormWren.BitBtnDebugRunClick(Sender: TObject);
begin
  DebugRunStop;
end;


procedure TFormWren.BitBtnDumpClick(Sender: TObject);
begin
  DumpPatch;
end;


procedure TFormWren.BitBtnExItClick(Sender: TObject);
begin
  FDebugRunning := False;
  Close;
end;


procedure TFormWren.BitBtnFindBlankControlTypesClick(Sender: TObject);
var
  aResult : TStringList;
begin
  if   Assigned( FormStore)
  then begin
    aResult := FormStore.CreateBlankControlTypeList;

    try
      aResult.SaveToFile( 'blank_controls.txt');
    finally
      aResult.DisposeOf;
    end;
  end;
end;

procedure TFormWren.BitBtnModuleFontClick(Sender: TObject);
begin
  if   Assigned( FormStore)
  then begin
    FontDialog.Font.Assign( ModuleFont);

    if   FontDialog.Execute
    then ModuleFont := FontDialog.Font;
  end;
end;


procedure TFormWren.BitBtnNetMidiConnectClick(Sender: TObject);
begin
  if   NetMidiConnected
  then NetMidiDisconnect
  else NetMidiConnect;
end;


procedure TFormWren.BitBtnProfileClick(Sender: TObject);
begin
  ProfilePatch;
end;


procedure TFormWren.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Log( LC_TERMINATE, 'TFormWren.FormClose');
  FClosing := True;

  try
    StopAudio;
    NetMidiDisconnect;
    OSCDisable;

    if   assigned( FSynthPatch)
    then FSynthPatch.Locked := True;
  except
    on E: Exception
    do KilledException( E);
  end;

  if   FIniLoaded
  then SaveIni( IniFileName, False);
end;


procedure TFormWren.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := CheckDiscardPatchChanges( 'Program Exit', WarnOnPatchChange);
end;


procedure TFormWren.FormCreate(Sender: TObject);
var
  PaInitCrashed       : Boolean;
  aPAError            : TPAError;
  aPAErrorInfo        : PPaHostErrorInfo;
  anErrVal            : Integer;
  i                   : Integer;
  aLooksFolderName    : string;
  aDefaultsFolderName : string;
  aPhraseSets         : TTalkiePhraseSets;
  ESpeakVersion       : string;
  Paths               : TStringList;
  S                   : string;
begin
  GOldWindowProc            := Pointer( SetWindowLong( Handle, GWL_WNDPROC, LongInt( @ NewWindowProc)));
  GOnLoadCaptions           := DoLoadCaptions;     // Set a global caption loader for dynamic count selectors.
  FAttentionItem            := atNothing;
  FAttentionItems           := [ atNothing];       // NOTE : FAttentionItems MUST not be empty, use [ atNothing] to signl emptiness
  LabelAttention.Font.Color := clGray;
  LabelAttention.Caption    := '';
  FVuSampleCount := 1;                             // Number of sample sets / frame - this can not be zero, it will be
                                                   // set later on in this method to a larger value, and the audio
                                                   // input and output functions will change it as well.
  ClearDebugTiming;                                // For relative debug time stamps
  CanLog     := False;                             // Causes logs to be stored on FSavedLogs
  LogToFile  := True;                              // Causes logs to be written to a file as well as to the log memo

  if   FileExists( LogFileName)                    // Delete existing logs
  then DeleteFile( LogFileName);

  if   LogToFile
  then LogFmt( LC_GENERAL, 'For logs also see the log file: %s', [ LogFileName]);

  Log   ( LC_STARTUP, 'Creating main form');
  LogFmt( LC_STARTUP, 'Wren version  : %s', [ GetFileVersion   ]);
  LogFmt( LC_STARTUP, 'Patch version : %d', [ KnobsPatchVersion]);
  Log   ( LC_STARTUP, '**  Note: all DLLs are being searched for in the following folders:');
  LogFmt( LC_STARTUP, '    %s', [ ApplicationPath]);

  Paths := Explode( System.SysUtils.GetEnvironmentVariable( 'path'), ';');
  try
    for i := 0 to Paths.Count - 1
    do begin
      S := Trim( Paths[ i]);

      if   S <> ''
      then LogFmt( LC_STARTUP, '    %s', [ S]);
    end;
  finally
    FreeAndNil(Paths);
  end;

  FOrigCaption        := Caption;
  FSelectedAPIID      := -1;
  FPortAudioAvailable := False;
  SetLength( FTickInData    , IN_CHANNEL_COUNT );
  SetLength( FTickInZeroData, IN_CHANNEL_COUNT );
  SetLength( FTickOutData   , OUT_CHANNEL_COUNT);

  for i := 0 to IN_CHANNEL_COUNT - 1
  do  FTickInZeroData[ i] := 0;

  try
    PaInitCrashed := False;
    aPAError      := paNotInitialized;
    LogFmt( LC_STARTUP, 'PortAudio: probing DLL presence, looking for "%s"', [ portaudio.LibName]);

    try
      aPAError := Pa_Initialize;
    except
      on E: Exception
      do begin
        LogFmt( LC_STARTUP, 'PortAudio: crashed in Pa_Initialze [%s]', [ E.ToString]);
        PaInitCrashed := True;
      end;
    end;

    FPortAudioAvailable := aPAError = paNoError;

    if not PaInitCrashed
    then LogFmt( LC_STARTUP, 'PortAuddio: Pa_Initialize returned code %d', [ aPAError]);

    if   not FPortAudioAvailable
    then begin
      try
        LogFmt( LC_STARTUP, 'PortAuddio: Pa_Initialize returned error %d', [ aPAError]);

        try
          LogFmt( LC_STARTUP, 'PortAuddio: Pa_Initialize returned error "%s"', [ Pa_GetErrorText( aPAError)]);
        except
          on E: Exception
          do LogFmt( LC_STARTUP, 'PortAudio: crashed in Pa_GetErrorText (%s)', [ E.Message]);
        end;

        if   aPAError = paUnanticipatedHostError
        then begin
          aPAErrorInfo := Pa_GetLastHostErrorInfo;

          if   Assigned( aPAErrorInfo)
          then
            LogFmt(
              LC_STARTUP,
              'PortAuddio: extra info: host API type: %d, error code : %d : with message "%s"',
              [
                aPAErrorInfo.hostApiType,
                aPAErrorInfo.errorCode,
                aPAErrorInfo.errorText
              ]
            );
        end;
      except
        on E: Exception
        do LogFmt( LC_STARTUP, 'PortAudio: Error retrieving error information - it may be that the DLL is not present on the search path [%s]', [ E.ToString]);
      end;
    end;

  {$IFDEF DEBUG(*_PORT_AUDIO*)}
    if   FPortAudioAvailable
    then PaUtil_SetDebugPrintFunction( @ GPaDebugProc);
  {$ENDIF}

  except
    on E: Exception
    do begin
      FPortAudioAvailable := False;
      KilledException( E);
    end;
  end;

  if   FPortAudioAvailable
  then Log( LC_STARTUP, 'PortAudio: DLL found, version is "' + Pa_GetVersionText + '"')
  else Log( LC_STARTUP, 'PortAudio: No DLL found, or it''s initialization failed, see messages above. Wren can not do any audio IO');

  FFFTWAvailable := False;
  try
    LogFmt( LC_STARTUP, 'probing FFTW DLL presence, looking for "%s"', [ fftw_dllpath]);
    anErrVal := fftw_init_threads;

    if   anErrVal <> 0
    then begin
      fftw_plan_with_nthreads( 1);                         // Set maximum number of threads for FFTW to use
      Log( LC_STARTUP, 'FFTW DLL found (it has no version information)');
      FFFTWAvailable := True;
    end
    else Log( LC_STARTUP, 'FFTW DLL found, but no threads avaliable, some modules may not work');
  except
    on E: Exception
    do begin
      LogFmt( LC_STARTUP, 'FFTW DLL not found, or an error occurred calling into it (%s), some modules will not work', [ E.ToString]);
      KilledException( E);
    end;
  end;

  FESpeakAvailable := False;
  LogFmt( LC_STARTUP, 'probing eSpeak presence, looking for "%s" (using API revision %d)', [ ESpeakDllName, ESpeakApiVersion]);
  FESpeaker := nil;
  try
    FESpeaker        := TESpeakSpeaker.Create;
    ESpeakVersion    := FESpeaker.ESpeakVersion;
    FESpeakAvailable := True;
  except
    on E: Exception
    do begin
      LogFmt( LC_STARTUP, 'eSpeak DLL not found, or an error occurred calling into it (%s]), some modules may not work', [ E.ToString]);
      KilledException( E);
    end;
  end;

  if FESpeakAvailable
  then LogFmt( LC_STARTUP, 'eSpeak DLL found, version "%s', [ ESpeakVersion]);

  Log( LC_STARTUP, 'reading Talkie phrase sets from ''words.lpc''');
  TalkieCreatePhrases( ApplicationPath + 'words.lpc');
  aPhraseSets := TalkiePhraseSets;

  if   not Assigned( aPhraseSets)
  then Log( LC_STARTUP, '''words.lpc'' not found or erroneous, some modules will not work')
  else Log( LC_STARTUP, 'phrase sets loaded');

  Log( LC_STARTUP, 'reading Formant sets sets from ''wren.formants''');
  try
    ReadFormantCollection( ApplicationPath + 'wren.formants', FormantLogger);
    {$ifdef DEBUG}
    FormantCollection.Dump( IncludeTrailingPathDelimiter( ApplicationPath) + 'formants.txt'); // for debugging only
    {$endif}
  except
    on E: Exception
    do begin
      KilledException( E);
      LogFmt( LC_STARTUP, 'Error reading wren.formants (%s), some modules will not work', [ E.Message]);
    end;
  end;

  Log( LC_STARTUP, 'formants rules were checked, now reading modal sets from ''wren.modal''');
  try
    ReadModalCollection( ApplicationPath + 'wren.modal', FormantLogger);
    {$ifdef DEBUG}
    ModalCollection.Dump( IncludeTrailingPathDelimiter( ApplicationPath) + 'modal.txt'); // for debugging only
    {$endif}
  except
    on E: Exception
    do begin
      KilledException( E);
      LogFmt( LC_STARTUP, 'Error reading wren.modal (%s), some modules will not work', [ E.Message]);
    end;
  end;

  Log( LC_STARTUP, 'modal rules were checked, some fiddling ...');
  FMidiFifo             := TBytesFifo.Create( 256);
  FOSCFifo              := TBytesFifo.Create( 256);
  FOldMemoDebug         := MemoDebug.WindowProc;           // Make mousewheel support for the debug memo
  MemoDebug.WindowProc  := MemoDebugWindowProc;
  System.Randomize;                                        // Randomize the random generator
  InitializeCPUCounter;
  GOnCreateModuleBitmap := DoCreateModuleBitmap;           // Helpers for help system and for module selector
  GOnReadModuleComment  := DoReadModuleComment;
  GOnLookupModuleClass  := LookupModuleGeneralClass;
  GOnPopupEditorShow    := DoPopupEditorShow;
  GOnPopupEditorHide    := DoPopupEditorHide;

  with Application
  do begin
    HintPause     :=    0;
    HintHidePause := 5000;
    OnShowHint    := DoShowHint;
  end;

  Log( LC_STARTUP, 'fiddling done, creating SAPI speech voice names');
  try
    FSapiVoiceNames := CreateSpeechVoiceNames;
    FSapiRateNames  := CreateSpeechRateNames;
    Log( LC_STARTUP, 'created SAPI speech voice names');
  except
    on E: Exception
    do LogFmt( LC_STARTUP, 'Error creating SAPI speech voice names: %s, you may try to install the windows speech API', [ E.Message]);
  end;

  Log( LC_STARTUP, 'Creating designer form');
  FormStore := TFormStore.Create( Application);
  Log( LC_STARTUP, 'Created designer form, creating last edits form');
  FormLastEdits := TFormLastEdits.Create( Application);

  if   Assigned( FormLastEdits)
  then FormLastEdits.Initialize( PatchEditor);

  if   Assigned( FormStore)
  then FMazeList := FormStore.CreateMazeTypes;

  Log( LC_STARTUP, 'created last edits form, creating randomizer form');
  FormRandomizer := TFormRandomizer.Create( Application);
  Log( LC_STARTUP, 'created randomizer form, creating MIDI CC selector');
  FormSelectMidiCC := TFormSelectMidiCC.Create( Application);
  Log( LC_STARTUP, 'Created MIDI CC selector, creating looks');
  aLooksFolderName    := Format( '%slooks', [ IncludeTrailingPathDelimiter( ApplicationPath)], AppLocale);
  aDefaultsFolderName := Format( '%slooks\default', [ IncludeTrailingPathDelimiter( ApplicationPath)], AppLocale);

  if   not System.SysUtils.DirectoryExists( aLooksFolderName)
  then begin
    LogFmt( LC_STARTUP, 'looks folder (%s) not found, trying to create it', [ aLooksFolderName]);

    try
      System.SysUtils.ForceDirectories( aLooksFolderName);
      Log( LC_STARTUP, 'looks folder was created');
    except
      on E: Exception
      do LogFmt( LC_STARTUP, 'Could not create looks folder, error: %s', [ E.ToString]);
    end
  end;

  if   System.SysUtils.DirectoryExists( aLooksFolderName)
  then begin
    LogFmt( LC_STARTUP, 'looks folder (%s) found, checking for default theme', [ aLooksFolderName]);

    if   System.SysUtils.DirectoryExists( aDefaultsFolderName)
    then LogFmt( LC_STARTUP, 'default theme folder (%s) found, done', [ aDefaultsFolderName])
    else begin
      LogFmt( LC_STARTUP, 'default theme folder (%s) not found, trying to create it', [ aDefaultsFolderName]);

      try
        System.SysUtils.ForceDirectories( aDefaultsFolderName);
        Log( LC_STARTUP, 'default theme folder was created, done');
      except
        on E: Exception
        do LogFmt( LC_STARTUP, 'Could not create default theme folder, error: %s', [ E.ToString]);
      end
    end;
  end;

  Log( LC_STARTUP, 'Preset folders checked, creating patch reader and writer and signal specs');
  FPatchReader := TPatchReader.Create;                     // For patch reading / writing to/from file and clipboard
  FPatchWriter := TPatchWriter.Create;
  FSignalSpecs := TKnobsModuleSignalSpecs.Create( PatchEditor);
  Log( LC_STARTUP, 'Created patch reader and writer and signal specs, configuring Editor');

  with PatchEditor
  do begin
    OnLog                    := DoWirePanelLog;
    PatchReader              := FPatchReader;
    PatchWriter              := FPatchWriter;
    OnHistoryChange          := DoHistoryChanged;
    OnValueChanged           := DoValueChanged;
    OnTextChanged            := DoTextChanged;
    OnRecompile              := DoRecompile;
    OnShowPoup               := DoShowPopupMenu;
    OnUnFocus                := DoUnFocus;
    OnLoadDataGraph          := DoLoadDataGraph;
    OnSaveDataGraph          := DoSaveDataGraph;
    OnLoadGridControl        := DoLoadGridControl;
    OnSaveGridControl        := DoSaveGridControl;
    OnActiveVariationChanged := DoActiveVariationChanged;
    OnLoadCaptions           := DoLoadCaptions;
    OnEditHistoryChanged     := DoEditHistoryChanged;
    OnModulesRenamed         := DoModulesRenamed;
    OnModulesRenamedFriendly := DoModulesRenamedFriendly;
    Title                    := 'no name';
    MaxHistory               := 100;
  end;

  with KnobsWirePanelLooks
  do begin
    OnLog           := DoWirePanelLog;
    OnUnFocus       := DoUnFocus;
  end;

  Log( LC_STARTUP, 'Configured Editor, creating RecentSourceFiles');
  FRecentSourceFiles := TRecentStrings.Create( 20);
  Log( LC_STARTUP, 'Created RecentSourceFiles, setting up PageControlMain');

  with PageControlMain                             // Hide outer level tabs
  do begin
    for i := 0 to PageCount - 1
    do Pages[ i].TabVisible := False;
  end;

  ViewEditor;
  Log( LC_STARTUP, 'Set up PageControlMain, setting some defaults and clearing VU meters');
  SetLength( FDbMinMaxIn , IN_CHANNEL_COUNT  );
  SetLength( FDbMinMaxOut, OUT_CHANNEL_COUNT );

  for i := Low( FDbMinMaxIn) to High( FDbMinMaxIn)
  do FDbMinMaxIn[ i] := TDbMinMax.Create( MIN_DB, MAX_DB, DB_DECAY_RATE, DB_DECAY_RATE);

  for i := Low( FDbMinMaxOut) to High( FDbMinMaxOut)
  do FDbMinMaxOut[ i] := TDbMinMax.Create( MIN_DB, MAX_DB, DB_DECAY_RATE, DB_DECAY_RATE);

  SetVuSampleCount( 512);                          // As long as its not zero ... a default frame size
  FSounding := False; Sounding := True;            // We statrt with unmuted outputs
  Log( LC_STARTUP, 'Set defaults, setup Midi receiver/transmitter');
  FMidiReceiver                   := TMidiReceiver.Create;
  FMidiReceiver.OnMessage         := DoMidiRxMessage;
  FMidiReceiver.OnRpnMessage      := DoRxRpnMessage;
  FMidiReceiver.OnNrpnMessage     := DoRxNrpnMessage;
  FMidiTransmitter                := TMidiTransmitter.Create;
  FMidiTransmitter.OnSendMidiByte := DoSendMidiByte;
  Log( LC_STARTUP, 'Midi receiver set up');
  Log( LC_STARTUP, 'Created main form');
end;


procedure TFormWren.FormDestroy(Sender: TObject);
var
  i : Integer;
begin
  Log( LC_TERMINATE, 'Destroying main form');
  Log( LC_TERMINATE, 'Destroying synth patch');

  if   Assigned( FSynthPatch)
  then begin
    FSynthPatch.OnSendShortMidi := nil;
    FSynthPatch.OnSendOSCString := nil;
    FSynthPatch.OnSendMidiBytes := nil;
  end;

  FreeAndNil( FSynthPatch);

  Log( LC_TERMINATE, 'Destroying audio devices');
  FreeDevices;

  Log( LC_TERMINATE, 'Destroying RecentSourceFiles');
  FreeAndNil( FRecentSourceFiles);

  Log( LC_TERMINATE, 'Finalizing CPU counter');
  FinalizeCPUCounter;

  Log( LC_TERMINATE, 'Freeing MIN/MAX tools');

  for i := Low( FDbMinMaxIn) to High( FDbMinMaxIn)
  do FreeAndNil( FDbMinMaxIn[ i]);

  for i := Low( FDbMinMaxOut) to High( FDbMinMaxOut)
  do FreeAndNil( FDbMinMaxOut[ i]);

  Log( LC_TERMINATE, 'Cleaning up DLL stuff');

  // Clean up DLL stuff
  //
  try
    if   FFFTWAvailable
    then begin
      fftw_cleanup_threads;
      FFFTWAvailable := False;
    end;
  except
    on E: Exception
    do KilledException( E);
  end;
  //
  try
    if   FPortAudioAvailable
    then begin
      Pa_Terminate;
      FPortAudioAvailable := False;
    end;
  except
    on E: Exception
    do KilledException( E);
  end;
  //
  try
    if FESpeakAvailable
    then FreeAndNil( FESpeaker);
  except
    on E: Exception
    do KilledException( E);
  end;
  //
  // end Clean up DLL stuff

  Log( LC_TERMINATE, 'Cleaned up DLL stuff, free the logger, MIDI reciever/transmitter, OSC stuff, Talkie stuff etc.');
  FMidiReceiver   .OnMessage      := nil;
  FMidiReceiver   .OnRpnMessage   := nil;
  FMidiReceiver   .OnNrpnMessage  := nil;
  FMidiTransmitter.OnSendMidiByte := nil;
  FreeAndNil( FSavedLogs      );
  FreeAndNil( FMidiReceiver   );
  FreeAndNil( FMidiTransmitter);
  FreeAndNil( FMidiFifo       );
  FreeAndNil( FOSCFifo        );
  FreeAndNil( FSignalSpecs    );
  FreeAndNil( FMazeList       );
  FreeAndNil( FSapiVoiceNames );
  FreeAndNil( FSapiRateNames  );
  TalkieDestroyPhrases;

  Log( LC_TERMINATE, 'Saving last patch');
  try
    SaveLastPatch;
  except
    on E: Exception
    do begin
      LogFmt( LC_TERMINATE, 'Error saving last patch: %s', [ E.Message]);
      KilledException( E);
    end;
  end;

  Log( LC_TERMINATE, 'Main form destroyed, bye ...');
end;


procedure TFormWren.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if   Shift = []
  then begin
    if   Key = VK_APPS
    then begin
      if   HandleContextMenu( FindControlUnderMouse)
      then Key := 0;
    end
  end;
end;


procedure TFormWren.FormMouseWheel(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
Var
  aMsg  : Cardinal;
  aCode : Cardinal;
  i     : Integer;
  n     : Integer;
begin
  MousePos := ScreenToClient( MousePos);

  if   ( MousePos.X > PatchEditor.Left                     )
  and  ( MousePos.Y > PatchEditor.Top                      )
  and  ( MousePos.X < PatchEditor.Left + PatchEditor.Width )
  and  ( MousePos.Y < PatchEditor.Top  + PatchEditor.Height)
  then begin
    if   ssShift in Shift
    then aMsg := WM_HSCROLL
    else aMsg := WM_VSCROLL;

    if   WheelDelta < 0
    then aCode := SB_LINEDOWN
    else aCode := SB_LINEUP;

    n := Mouse.WheelScrollLines;

    for i:= 1 to n
    do  PatchEditor.Perform( aMsg, aCode, 0);

    PatchEditor.Perform( aMsg, SB_ENDSCROLL, 0);
    Handled := True;
  end;
end;


procedure TFormWren.FormShow(Sender: TObject);
var
  WasFileLogging : Boolean;
  aColor         : TColor;
begin
  FInFormShow := True;

  try
    Log( LC_STARTUP, 'TFormWren.FormShow started, handle saved logs');

    try
      ClearLog;                                        // Clear log window
      WasFileLogging := LogToFile;
      LogToFile      := False;                         // Do not log old logs to the log file, they are in it already

      try
        CanLog := True;                                // This will dump FSavedLogs to to the log view
      finally
        LogToFile := WasFileLogging;
      end;
    except
      on E: Exception
      do KilledException( E);
    end;

    Log( LC_STARTUP, 'Saved logs written to log view');
    KnobsWormPanelVariations.OnLog := LogVariations;
    PatchName      := '';
    SourceFileName := '';

    if   UseThemes
    then begin
      LogFmt( LC_STARTUP, 'Initialize themes, current theme is ''%s''', [ UserTheme]);
      PopulateThemes;
    end
    else Log( LC_STARTUP, 'Not using theming, skipped theme initialization');

    Log( LC_STARTUP, 'Initialize wave selector window');
    FormWaveDeviceSelect := TFormWaveDeviceSelect.Create( Self);

    with FormWaveDeviceSelect
    do begin
      OnLog           := WaveLog;
      PAInitialized   := Self.FPortAudioAvailable;
      OnShowAsioPanel := WaveShowAsioPanel;
      OnRestartAudio  := WaveRestartAudio;
      Initialize;
    end;

    ClearVUMeters;
    Log( LC_STARTUP, 'Setup looks viewer');

    if   Assigned( looks)      // Treat looks as a template, can be disposed off after usage.
    then begin
      FClonedLooks := looks.Clone( KnobsWirePanelLooks, KnobsWirePanelLooks, Point( OffsetLeft, OffsetTop), False, True);
      FreeAndNil( looks);
    end;

    KnobsWirePanelLooks.UnSelectAllModules;
    KnobsWirePanelLooks.AddWire( 'looks.looks_inaudio'       , 'looks.looks_outaudio'       );
    KnobsWirePanelLooks.AddWire( 'looks.looks_incontrol'     , 'looks.looks_outcontrol'     );
    KnobsWirePanelLooks.AddWire( 'looks.looks_incontrollogic', 'looks.looks_outcontrollogic');
    KnobsWirePanelLooks.AddWire( 'looks.looks_inlogic'       , 'looks.looks_outlogic'       );
    KnobsWirePanelLooks.AddWire( 'looks.looks_inspare1'      , 'looks.looks_inspare2'       );
    KnobsWirePanelLooks.Tag     := Ord( cidEditorBackground);
    KnobsWirePanelLooks.OnClick := DoLooksEditorClicked;
    KnobsWirePanelLooks.SetOnClickFor( 'looks'                , Ord( cidModule          ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_outspare'       , Ord( cidConnectorBorder ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_inspare'        , Ord( cidConnectorBorder ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_selectordouble' , Ord( cidSelector        ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_selectorsingle' , Ord( cidSelectorBorder  ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_display_knob'   , Ord( cidDisplay         ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_knobmidi'       , Ord( cidKnobMIDI        ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_noknobmidi'     , Ord( cidKnobMIDI        ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_fadermidi'      , Ord( cidKnobMIDI        ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_smallknobmidi'  , Ord( cidKnobFocus       ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_viewer'         , Ord( cidViewer          ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_indicatorbar'   , Ord( cidIndicatorBarPeak), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_inaudio'        , Ord( cidAudioRate       ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_outaudio'       , Ord( cidAudioRate       ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_incontrol'      , Ord( cidControlRate     ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_outcontrol'     , Ord( cidControlRate     ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_incontrollogic' , Ord( cidControlRateLogic), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_outcontrollogic', Ord( cidControlRateLogic), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_inlogic'        , Ord( cidLogic           ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_outlogic'       , Ord( cidLogic           ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_inspare1'       , Ord( cidUnconnectedWire ), DoLooksEditorClicked);
    KnobsWirePanelLooks.SetOnClickFor( 'looks_inspare2'       , Ord( cidUnconnectedWire ), DoLooksEditorClicked);

    Log( LC_STARTUP, 'Fix look and feel preset folders');
    FCanLoadLookAndFeel := False;
    FixLookAndFeelPresets;
    FCanLoadLookAndFeel := True;
    Log( LC_STARTUP, 'Set default values');
    Width                 := 1322;                // Default form width
    Height                :=  700;                // Default form height
    SplitterMain.ShowHint := True;                // Hints on VU/main splitter
    PanelControl.Width    := 48;                  // By default show channel 1 controls only
    FLastControlWidth     := PanelControl.Width;
    FixControlFoldButton;
    SplitterModuleSelector.ShowHint := True;      // Hints on module selector splitter
    ModuleSelector.Width := 389;                  // By default show everything
    FLastSelectorWidth   := ModuleSelector.Width;
    FixSelectorFoldButton;
    FixMorphsAndRanges;
    FCurvedLines              := False;        CurvedLines              := True;
    FControlMode              := dmHorizontal; ControlMode              := dmCircular;
    FUseConfigHints           := False;        UseConfigHints           := True;
    FUseModuleTitleHints      := False;        UseModuleTitleHints      := True;
    FWireThickness            := 2;            WireThickness            := 1;
    OffsetLeft                := 6;
    OffsetTop                 := 6;
    FUseWheelOnKnobs          := False;        UseWheelOnKnobs          := True;
    FWheelSensitivity         := 1;            WheelSensitivity         := 50;
    FUseUnFocus               := False;        UseUnFocus               := True;
    FUseConnectorBorders      := False;        UseConnectorBorders      := True;
    FUseTypedConnectorBorders := False;        UseTypedConnectorBorders := True;
    FUseNoteNames             := True;         UseNoteNames             := False;
    ModuleColor               := clNone;       ModuleColor              := clWhite;
    ConnectorBorderColor      := clNone;       ConnectorBorderColor     := clWhite;
    SelectorColor             := clNone;       SelectorColor            := clGray;
    SelectorBorderColor       := clNone;       SelectorBorderColor      := clYellow;
    SelectorBorderColorS      := clNone;       SelectorBorderColorS     := clWhite;
    DisplayColor              := clNone;       DisplayColor             := clGray;
    DisplayBorderColor        := clNone;       DisplayBorderColor       := clSilver;
    KnobMIDIColor             := clNone;       KnobMIDIColor            := clBlue;
    KnobFocusColor            := clNone;       KnobFocusColor           := clRed;
    KnobMIDIFocusColor        := clNone;       KnobMIDIFocusColor       := clFuchsia;
    ViewerColor               := clNone;       ViewerColor              := clGray;
    ViewerBorderColor         := clNone;       ViewerBorderColor        := clGray;
    ViewerLineColor           := clNone;       ViewerLineColor          := clWhite;
    ViewerFillColor           := clNone;       ViewerFillColor          := $009E9E9E;
    IndBarPeakColor           := clNone;       IndBarPeakColor          := clWhite;
    IndBarValeyColor          := clNone;       IndBarValeyColor         := clBlack;
    GroupIOColor              := clNone;       GroupIOColor             := clSilver;
    GroupOSCColor             := clNone;       GroupOSCColor            := clRed;
    GroupLFOColor             := clNone;       GroupLFOColor            := clLime;
    GroupEnvColor             := clNone;       GroupEnvColor            := clYellow;
    GroupFilterColor          := clNone;       GroupFilterColor         := clBlue;
    GroupSwitchColor          := clNone;       GroupSwitchColor         := clFuchsia;
    GroupMixColor             := clNone;       GroupMixColor            := clAqua;
    GroupControlColor         := clNone;       GroupControlColor        := clTeal;
    GroupNoteColor            := clNone;       GroupNoteColor           := $000080FF; // Orange
    GroupMathColor            := clNone;       GroupMathColor           := clWhite;
    GroupLogicColor           := clNone;       GroupLogicColor          := clGreen;
    GroupGeneratorColor       := clNone;       GroupGeneratorColor      := $009882FF; // Pink
    GroupSeqColor             := clNone;       GroupSeqColor            := clPurple;
    GroupFXColor              := clNone;       GroupFXColor             := clMaroon;
    GroupDelayColor           := clNone;       GroupDelayColor          := clTeal;
    GroupVoiceColor           := clNone;       GroupVoiceColor          := $00404080; // Brown
    GroupUtilityColor         := clNone;       GroupUtilityColor        := clBlack;
    AudioRateColor            := clNone;       AudioRateColor           := clRed;
    ControlRateColor          := clNone;       ControlRateColor         := clBlue;
    ControlRateLogicColor     := clNone;       ControlRateLogicColor    := clLime;
    LogicColor                := clNone;       LogicColor               := clYellow;
    UnconnectedWireColor      := clNone;       UnconnectedWireColor     := clAqua;
    WireHighlightColor        := clNone;       WireHighlightColor       := clWhite;
    FEditorBackgroundColor    := clNone;       EditorBackgroundColor    := $00313131;
    ModuleOpacity             := 195;
    ModuleFlatness            := False;
    ModuleTexture             := True;
    FStandardColors           := False;        StandardColors           := True;
    FSearchPatch              := False;        SearchPatch              := True;
    FSearchSelector           := False;        SearchSelector           := True;
    FSynthNameInCaption       := False;        SynthNameInCaption       := True;
    FPatchChangedInCaption    := False;        PatchChangedInCaption    := True;
    FProfiledInCaption        := False;        ProfiledInCaption        := True;
    FAudioStatusInCaption     := True;         AudioStatusInCaption     := False;
    FProgramNameInCaption     := False;        ProgramNameInCaption     := True;
    FFileVersionInCaption     := True;         FileVersionInCaption     := False;
    FPatchNameInCaption       := True;         PatchNameInCaption       := False;
    FSourceNameInCaption      := False;        SourceNameInCaption      := True;
    FGuidInCaption            := True;         GuidInCaption            := False;
    FPatchFolder              := '-';          PatchFolder              := ApplicationPath;
    FTemplateFolder           := '-';          TemplateFolder           := ApplicationPath;
    FImportFolder             := '-';          ImportFolder             := ApplicationPath;
    FGraphsFolder             := '-';          GraphsFolder             := ApplicationPath;
    FGridControlFolder        := '-';          GridControlFolder        := ApplicationPath;
    FShowTopPane              := False;        ShowTopPAne              := True;
    FSynthName                := '-';          SynthName                := 'wren';
    FLightsActive             := False;        LightsActive             := True;
    FAbsTimeStamps            := False;        AbsTimeStamps            := True;
    FUseGraphs                := True;         UseGraphs                := False;
    InVolume1                 := 1;            InVolume1                := 0;
    InVolume2                 := 1;            InVolume2                := 0;
    InVolume3                 := 1;            InVolume3                := 0;
    InVolume4                 := 1;            InVolume4                := 0;
    OutVolume1                := 1;            OutVolume1               := 81;
    OutVolume2                := 1;            OutVolume2               := 81;
    OutVolume3                := 1;            OutVolume3               := 81;
    OutVolume4                := 1;            OutVolume4               := 81;
    FClearVUOnStop            := False;        ClearVUOnStop            := True;
    FClearVUOnRecompile       := False;        ClearVUOnRecompile       := True;
    FAudioRunning             := False;
    FReloadLastPatch          := False;        ReloadLastPatch          := True;
    FHistoryCount             := 0;            HistoryCount             := 15;
    Samplerate                := 48000;        Samplerate               := 88200;
    ControlDecimation         := 16;           ControlDecimation        := 8;
    BufferSize                := 0;
    WaveDebug                 := True;
    ReferenceA                := 100;          ReferenceA               := DefaultReferenceA;
    NotesPerOctave            := 3;            NotesPerOctave           := DefaultNotesPerOctave;
    MiddleNote                := 1;            MiddleNote               := DefaultMiddleNote;
    OctaveSpan                := 1.5;          OctaveSpan               := DefaultOctaveSpan;
    FPrioLevel                := 1;            PrioLevel                := 0;
    NetMidiServer             := 'localhost';
    NetMidiPort               := '31415';                                                // NetMIDI is TCP, so can use the same port as for OSC (which is UDP).
    FNetMidiAutoConnect       := True;         NetMidiAutoConnect       := False;
    FLogMidi                  := False;        LogMidi                  := True;
    FLogMidiMsgs              := True;         LogMidiMsgs              := False;
    FMidiChannel              := 1;            MidiChannel              := MIDI_CH_OMNI; // Default to onmi RX mode and TX on channel 1
    FMidiRpnMode              := mrm7;         MidiRpnMode              := mrm14;
    FNetMidiChanged           := True;         NetMidiChanged           := False;
    FOscServer                := '-';          OSCServer                := '';           // default to be a transmitter
    OSCPort                   := '31435';                                                // OSC is UDP, so can use the same port as for NetMIDI (which is TCP).
    FUSeOSC                   := True;         UseOSC                   := False;
    FLogOSC                   := False;        LogOSC                   := True;
    FLogOSCMsgs               := True;         LogOSCMsgs               := False;
    FOSCChanged               := True;         OSCChanged               := False;
    FAutoCollectDenormals     := True;         AutoCollectDenormals     := False;
    FManualCompilation        := True;         ManualCompilation        := False;
    FCompilerDebug            := True;         CompilerDebug            := False;
    FWarnOnPatchChange        := False;        WarnOnPatchChange        := True;
    FWarnChangeOnLoad         := False;        WarnChangeOnLoad         := True;
    FUndoAfterSave            := True;         UndoAfterSave            := False;
    FUndoAfterLoad            := True;         UndoAfterLoad            := False;
    FRenderToFile             := True;         RenderToFile             := False;
    FResetOnRender            := False;        ResetOnRender            := True;
    FWarnOnStructMismatch     := False;        WarnOnStructMismatch     := True;
    DisableAutoDocs           := True;         DisableAutoDocs          := False;
    AllowAutoLoad             := True;         AllowAutoLoad            := False;
    NoLoadTuning              := False;        NoLoadTuning             := True;
    NewPatchNameTemplate      := '$D $T $N';
    TextWriterPrefix          := '-';          TextWriterPrefix         := '';
    FSelectedAPIID            := paDirectSound;
    FSelectedInputIdPA        := 0;
    FSelectedOutputIdPA       := 0;
    Log( LC_STARTUP, 'Check audio devices');
    VerifyDevices;
    Log( LC_STARTUP, 'Setup profiler');

    if   not HAS_PATCH_PROFILER
    then begin
      BitBtnProfile    .Caption := 'find small values';
      MenuActionProfile.Caption := 'Find small values';
    end;

    Log( LC_STARTUP, 'Clear some user interface stuff');
    FLightsRate                            :=   0;
    KnobsSmallKnob_LightsRate.KnobPosition :=   0;
    KnobsSmallKnob_LightsRate.KnobPosition := 156;
    LabelProgramVersion.Caption := Format( 'program version: %s', [ GetFileVersion   ], AppLocale);
    LabelPatchVersion  .Caption := Format( 'patch version: %d'  , [ KnobsPatchVersion], AppLocale);
    ClearVolumeIndicators;
    ResetRuntime;

    // Load user prefs when they are available


    if   FileExists( IniFileName)
    then begin
      LogFmt( LC_STARTUP, 'Trying to load user prefs from ''%s''', [ IniFileName]);
      LoadIni( IniFileName, False);
    end
    else if FileExists( WrenIniFileName)
    then begin
      LogFmt( LC_STARTUP, 'trying to load user prefs from ''%s''', [ WrenIniFileName]);
      LoadIni( IniFileName, False)
    end
    else begin
      LogFmt( LC_STARTUP, 'No on disk user prefs found, creating initial prefs in ''%s''', [ IniFileName]);
      AutoRun    := True;
      FIniLoaded := True;
      SaveIni( IniFileName, False);   // Save default settings
      AutoRun    := False;            // To be reloaded from ini file

      if   FileExists( IniFileName)   // and load them
      then begin
        Log( LC_STARTUP, 'Trying to load freshly created user prefs');
        LoadIni( IniFileName, False);
        Log( LC_STARTUP, 'User prefs loaded');
      end
      else Log( LC_STARTUP, 'Could read suppusedly created ini file, probaly could not create it');
    end;

    Log( LC_STARTUP, 'Fixing color maps');
    FixColorMaps;
    LogFmt( LC_STARTUP, 'Color maps fixed, fix look and feel for designer window [from %s]', [ FLooksFolder]);

    with FormStore
    do begin
      FormStore.OnDesignerLog := DoDesignerLog;                     // Set a logger for the module store
      PopulateSelector( ModuleSelector, FLooksFolder);              // Poplulate module selector from the module store
      PopulateMenu( MenuItemInsertmodule, DoEditorMenuAddModule);   // Populate the editor context menu as well
      FixTabColors;                                                 // Obtain tab colors for the module selector
    end;


    // FormStore.RegisterModules;

    LogFmt( LC_STARTUP, 'Designer window fixed, load the theme bitmaps [from %s]', [ FLooksFolder]);
    LoadModuleGlyphs;

    if   Assigned( FormStore)
    then FormStore.LoadControlGlyphs( FLooksFolder);

    if   Assigned( PatchEditor)
    then begin
      Log( LC_STARTUP, 'Theme settings completed, colorize the editor');
      aColor := GetThemedPanelColor;

      if   aColor <> clNone
      then begin
        PatchEditor.Color := aColor;
        ChartDebug .Color := aColor;
      end;

      Log( LC_STARTUP, 'Colorized the editor, initializing randomizer');

      if   Assigned( FormRandomizer)
      then begin
        FormRandomizer.PatchEditor        := PatchEditor;
        FormRandomizer.Logger             := LogRandomizer;
        FormRandomizer.OnLiveMorphChanged := DoRandomizerLiveMorphChanged;
        FormRandomizer.OnSendToEditor     := DoRandomizerSendToEditor;
        FormRandomizer.OnLoadFromEditor   := DoRandomizerLoadFromEditor;
        FormRandomizer.OnPatchRandomize   := DoPatchRandomize;
        FormRandomizer.OnPatchMutate      := DoPatchMutate;
        FormRandomizer.OnPatchMate        := DoPatchMate;
        FormRandomizer.OnPatchMorph       := DoPatchMorph;
        FormRandomizer.OnWormSelected     := DoWormSelected;
        FormRandomizer.OnWormDropped      := DoWormDropped;

        Log( LC_STARTUP, 'Randomizer initialized, checking help files');
      end
      else Log( LC_STARTUP, 'BUG: FormRandomizer is not available, could not initialize it');
    end
    else Log( LC_STARTUP, 'BUG: PatchEditor is NIL - could not colorize editor, could not set up randomizer');

    if   MustMakeDocs
    then begin
      Log( LC_STARTUP, 'Help files are not up to date, generating new ones from designer window');
      try
        MakeDocs( DocsPath);
        Log( LC_STARTUP, 'Generated help files');
      except
        on E: Exception
        do LogFmt( LC_STARTUP, 'Help file generation failed, reason: ''%s''', [ E.ToString]);
      end;
    end
    else Log( LC_STARTUP, 'Help files were up to date, not making new ones');

    Log( LC_STARTUP, 'Help files checked, some minor stuff now ...');
    DoUnfocus( Self);                         // Set keyboard and mouse wheel focus to something harmless .. if possible
    Log( LC_STARTUP, '... start NetMidi and Stats timer');
    StartNetMidiConnectTimer;
    TimerStatsUpdate.Enabled := True;
    Log( LC_STARTUP, 'trying to load a patch, either nothing the last past used or one specified on the command line');

    try
      if   ( ParamCount >= 1)
      and  FileExists( ParamStr( 1))
      then Begin
        SourceFileName := ParamStr( 1);
        LogFmt( LC_STARTUP, 'Opening patch passed on command line [%s]', [ SourceFileName]);
        DoLoadPatch( SourceFileName, True);
        PatchEditor.ClearUndoRedo;            // This prevents undo to a blank patch when undo after load is in effect
      end
      else if ReloadLastPatch
      and     FileExists( SourceFileName)
      then begin
        LogFmt( LC_STARTUP, 'Reopening last used patch [%s]', [ SourceFileName]);
        DoLoadPatch( SourceFileName, True);
        PatchEditor.ClearUndoRedo;            // This prevents undo to a blank patch when undo after load is in effect
      end
      else begin
        LogFmt( LC_STARTUP, 'Could not find last used patch [%s] or reload was not specified - starting a new patch', [ SourceFileName]);
        NewPatch;
      end;

      Log( LC_STARTUP, 'patch loading done OK');
    except
      on E: Exception
      do LogFmt( LC_STARTUP, 'patch loading failed for reason: %s', [ E.ToString]);
    end;

    Log( LC_STARTUP, 'Allow audio from here on');
    FCanCreateAudio := True;

    if   Lock( FWormUpdateLock)
    then begin
      try
        PatchEditor.FixAllSynthParams( False);  // todo: raaaaar .. this is needed ... non comprendo .. anyway .. otherwise stuff doesnt properly start up on the initial patch ...
      finally
        Unlock( FWormUpdateLock);
      end;
    end;

    if   FDoAutoRun
    then AutoRun := True
    else VerifyDevices;

    Log( LC_STARTUP, '... done with TFormWren.FormShow, all seems OK');
  finally
    FInFormShow := False;
    SplashKill;
  end;
end;



  procedure RegisterModuleTypes;
  begin
    // Couple editor module IDs (design) to synth module types (run-time)
    // Audio in and output need pre-defined module type IDs
    // (all modules without run-time semantics are skipped here)

    RegisterModuleType( MTYPE_AUDIO_INPUT , TModInput );
    RegisterModuleType( MTYPE_AUDIO_OUTPUT, TModOutput);

    RegisterModuleType(  201, TModXFade            );  RegisterModuleType(  202, TModPan              );
    RegisterModuleType(  203, TModMixM4to1         );  RegisterModuleType(  204, TModMixS2to1         );
    RegisterModuleType(  205, TModMixM6to6         );  RegisterModuleType(  206, TModMixT1to1         );
    RegisterModuleType(  207, TModMixAudio         );  RegisterModuleType(  208, TModMixQ1to1         );
    RegisterModuleType(  209, TModMixM16to1        );  RegisterModuleType(  210, TModMixMM16to1       );
    RegisterModuleType(  211, TModMixM3to1         );  RegisterModuleType(  212, TModVolume           );
    RegisterModuleType(  213, TModMixS5to1         );  RegisterModuleType(  214, TModMixMS8to1        );
    RegisterModuleType(  215, TModMixQS2to1        );  RegisterModuleType(  216, TModMixQS1to1        );
    RegisterModuleType(  217, TModQuadPan          );

    RegisterModuleType(  301, TModConstant         );  RegisterModuleType(  302, TModInverter         );
    RegisterModuleType(  303, TModAdder            );  RegisterModuleType(  304, TModMultiplier       );
    RegisterModuleType(  305, TModAmplifier        );  RegisterModuleType(  306, TModScaler           );
    RegisterModuleType(  307, TModQuantize         );  RegisterModuleType(  308, TModRatio            );
    RegisterModuleType(  309, TModRotator          );  RegisterModuleType(  310, TModRectifier        );
    RegisterModuleType(  311, TModMinMax           );  RegisterModuleType(  312, TModMultiMult        );
    RegisterModuleType(  313, TModNoteToDelay      );  RegisterModuleType(  314, TModZeroCounter      );
    RegisterModuleType(  315, TModMedian           );  RegisterModuleType(  316, TModScala            );
    RegisterModuleType(  317, TModHardClip         );  RegisterModuleType(  318, TModTransInv         );
    RegisterModuleType(  319, TModPad              );  RegisterModuleType(  320, TModEuclideanScale   );
    RegisterModuleType(  321, TModSpiral           );  RegisterModuleType(  322, TModRangeConverter   );
    RegisterModuleType(  323, TModLogisticMap      );  RegisterModuleType(  324, TModWaveWiper        );
    RegisterModuleType(  325, TModWaveWrapper      );  RegisterModuleType(  326, TModChebGen          );
    RegisterModuleType(  327, TModPoetry           );  RegisterModuleType(  328, TModNoteQuantize     );
    RegisterModuleType(  329, TModLevelConverter   );  RegisterModuleType(  330, TModReciprocal       );
    RegisterModuleType(  331, TModDivide           );  RegisterModuleType(  332, TModMonadic          );
    RegisterModuleType(  333, TModDyadic           );  RegisterModuleType(  334, TModMultipleMult     );
    RegisterModuleType(  335, TModScaleQuantizer   );  RegisterModuleType(  336, TModModQuantizer     );
    RegisterModuleType(  337, TModSlew             );  RegisterModuleType(  338, TModMixingScaler     );
    RegisterModuleType(  339, TModRMS              );  RegisterModuleType(  340, TModCubicClip        );
    RegisterModuleType(  341, TModWavolver         );  RegisterModuleType(  342, TModSawMill          );
    RegisterModuleType(  343, TModTypeFlip         );  RegisterModuleType(  344, TModFastToSlow       );
    RegisterModuleType(  345, TModPolar            );  RegisterModuleType(  346, TModMConst           );
    RegisterModuleType(  347, TModRectangular      );  RegisterModuleType(  348, TModRandomScale      );
    RegisterModuleType(  349, TModArpeggiator      );  RegisterModuleType(  350, TModMarkov           );
    RegisterModuleType(  351, TModAmMod            );  RegisterModuleType(  352, TModModControl       );
    RegisterModuleType(  353, TModTranspose        );  RegisterModuleType(  354, TModShaper           );
    RegisterModuleType(  355, TModPropScaler       );  RegisterModuleType(  356, TModAnalogXor        );
    RegisterModuleType(  357, TModCuClipStereo     );  RegisterModuleType(  358, TModValues           );
    RegisterModuleType(  359, TModMatrixMult       );  RegisterModuleType(  360, TModChladniControl   );
    RegisterModuleType(  361, TModSlowToFast       );  RegisterModuleType(  362, TModRotator2         );
    RegisterModuleType(  363, TModAutoQuantizer    );  RegisterModuleType(  364, TModNoteSplit        );
    RegisterModuleType(  365, TModNoteMerge        );  RegisterModuleType(  366, TModFindNearest      );
    RegisterModuleType(  367, TModChangeDetector   );

    RegisterModuleType(  401, TModLfo              );  RegisterModuleType(  402, TModSquareLfo        );
    RegisterModuleType(  403, TModNoiseLfo         );  RegisterModuleType(  404, TModRandomWalkLfo    );
    RegisterModuleType(  405, TModLfoTrig          );  RegisterModuleType(  406, TModSquareLfoTrig    );
    RegisterModuleType(  407, TModNoiseLfoTrig     );  RegisterModuleType(  408, TModRandSig          );
    RegisterModuleType(  409, TModPulses           );  RegisterModuleType(  410, TModAttractorLfo     );
    RegisterModuleType(  411, TModClockGen         );  RegisterModuleType(  412, TModTod              );
    RegisterModuleType(  413, TModSquareSineLfo    );  RegisterModuleType(  414, TModLfoMultiPhase    );
    RegisterModuleType(  415, TModRandSigs         );  RegisterModuleType(  416, TModVanDerPolLfo     );

    RegisterModuleType(  501, TModOsc              );  RegisterModuleType(  502, TModSquare           );
    RegisterModuleType(  503, TModNoise            );  RegisterModuleType(  504, TModOscTrig          );
    RegisterModuleType(  505, TModSquareTrig       );  RegisterModuleType(  506, TModNoiseTrig        );
    RegisterModuleType(  507, TModTerraGen         );  RegisterModuleType(  508, TModPluck            );
    RegisterModuleType(  509, TModKS               );  RegisterModuleType(  510, TModTalkie           );
    RegisterModuleType(  511, TModAttractor        );  RegisterModuleType(  512, TModTss              );
    RegisterModuleType(  513, TModSong             );  RegisterModuleType(  514, TModVosim            );
    RegisterModuleType(  515, TModPerlinNoise      );  RegisterModuleType(  516, TModPerlinNoiseTrig  );
    RegisterModuleType(  517, TModPerlinTone       );  RegisterModuleType(  518, TModPhasor           );
    RegisterModuleType(  519, TModAudioGraph       );  RegisterModuleType(  520, TModMultiOsc         );
    RegisterModuleType(  521, TModModOsc           );  RegisterModuleType(  522, TModMultiSine        );
    RegisterModuleType(  523, TModPdOsc            );  RegisterModuleType(  524, TModMasterOsc        );
    RegisterModuleType(  525, TModMultiPhaseOsc    );  RegisterModuleType(  526, TModVanDerPol        );
    RegisterModuleType(  527, TModChladnicOsc      );  RegisterModuleType(  528, TModSapiVoice        );
    RegisterModuleType(  529, TModESpeakVoice      );

    RegisterModuleType(  601, TModNot              );  RegisterModuleType(  602, TModGate             );
    RegisterModuleType(  603, TModDivider          );  RegisterModuleType(  604, TModDFlipFlop        );
    RegisterModuleType(  605, TModRSFlipFlop       );  RegisterModuleType(  606, TModCounter          );
    RegisterModuleType(  607, TModAdc              );  RegisterModuleType(  608, TModDac              );
    RegisterModuleType(  609, TModPhaseDetect      );  RegisterModuleType(  610, TModCompare          );
    RegisterModuleType(  611, TModLogicSelector    );  RegisterModuleType(  612, TModProgDivider      );
    RegisterModuleType(  613, TModMultiCompare     );  RegisterModuleType(  614, TModPulseDelay       );
    RegisterModuleType(  615, TModRungler          );  RegisterModuleType(  616, TModFixedDiv         );
    RegisterModuleType(  617, TModPulseSync        );  RegisterModuleType(  618, TModPrimeDiv         );
    RegisterModuleType(  619, TModPulseSkip        );  RegisterModuleType(  620, TModShifter          );
    RegisterModuleType(  621, TModLFSR             );  RegisterModuleType(  622, TModStack            );
    RegisterModuleType(  623, TModMultiGate        );

    RegisterModuleType(  701, TModDelay            );  RegisterModuleType(  702, TModWavePlayer       );
    RegisterModuleType(  703, TModReverb           );  RegisterModuleType(  704, TModFlangeChorus     );
    RegisterModuleType(  705, TModPitchChange      );  RegisterModuleType(  706, TModClockedDelay     );
    RegisterModuleType(  707, TModGVerb            );  RegisterModuleType(  708, TModDelay8           );
    RegisterModuleType(  709, TModRndGranulator    );  RegisterModuleType(  710, TModGranulator       );
    RegisterModuleType(  711, TModSimpleGranulator );  RegisterModuleType(  712, TModClockedDelay16   );
    RegisterModuleType(  713, TModAllPass          );  RegisterModuleType(  714, TModLooper           );
    RegisterModuleType(  715, TModStereoLooper     );  RegisterModuleType(  716, TModDelayMod         );
    RegisterModuleType(  717, TModDelayStereo      );  RegisterModuleType(  718, TModDelayMix         );

    RegisterModuleType(  801, TModSampleAndHold    );  RegisterModuleType(  802, TModTrackAndHold     );
    RegisterModuleType(  803, TModSwitch2to1       );  RegisterModuleType(  804, TModMultiSAndH       );
    RegisterModuleType(  805, TModMux              );  RegisterModuleType(  806, TModDemux            );
    RegisterModuleType(  807, TModDigiMux          );  RegisterModuleType(  808, TModDigiDemux        );
    RegisterModuleType(  809, TModSerPar           );

    RegisterModuleType(  901, TModEnvAR            );  RegisterModuleType(  902, TModEnvARRetrig      );
    RegisterModuleType(  903, TModEnvAHD           );  RegisterModuleType(  904, TModEnvADSR          );
    RegisterModuleType(  905, TModEnvelope         );  RegisterModuleType(  906, TModCompressor       );
    RegisterModuleType(  907, TModVocoder          );  RegisterModuleType(  908, TModEnvControl       );
    RegisterModuleType(  909, TModConvoder         );  RegisterModuleType(  910, TModPitchShift       );
    RegisterModuleType(  911, TModMultiEnvelope    );  RegisterModuleType(  912, TModStereoWiden      );
    RegisterModuleType(  913, TModPhaseDistort     );

    RegisterModuleType( 1001, TModAverage          );  RegisterModuleType( 1002, TModSVF              );
    RegisterModuleType( 1003, TModIntDif           );  RegisterModuleType( 1004, TModFormant          );
    RegisterModuleType( 1005, TModPinkFilter       );  RegisterModuleType( 1006, TModResonator        );
    RegisterModuleType( 1007, TModTritoneBank      );  RegisterModuleType( 1008, TModThirdBank        );
    RegisterModuleType( 1009, TModTritoneSplitter  );  RegisterModuleType( 1010, TModThirdSplitter    );
    RegisterModuleType( 1011, TModModal            );  RegisterModuleType( 1012, TModFormant2         );
    RegisterModuleType( 1013, TModFilter6dB        );  RegisterModuleType( 1014, TModFilter6dBBP      );
    RegisterModuleType( 1015, TModFilter6dBBPS     );  RegisterModuleType( 1016, TModTiltFilter       );
    RegisterModuleType( 1017, TModMoogFilter       );  RegisterModuleType( 1018, TModDCBlock          );
    RegisterModuleType( 1019, TModFilter6dBBPSM    );  RegisterModuleType( 1020, TModTritoneCombiner  );
    RegisterModuleType( 1021, TModThirdCombiner    );  RegisterModuleType( 1022, TModTiltFilterStereo );
    RegisterModuleType( 1023, TModModal2           );  RegisterModuleType( 1024, TModChladni          );
    RegisterModuleType( 1025, TModMovingAverage    );  RegisterModuleType( 1026, TModUnclick          );
    RegisterModuleType( 1027, TModDif              );

    RegisterModuleType( 1106, TModDisplay          );  RegisterModuleType( 1108, TModXYScope          );
    RegisterModuleType( 1109, TModKnobs4           );  RegisterModuleType( 1110, TModSwitches4        );
    RegisterModuleType( 1111, TModButtons4         );  RegisterModuleType( 1112, TModValue            );
    RegisterModuleType( 1113, TModTapper           );  RegisterModuleType( 1114, TModCount            );
    RegisterModuleType( 1115, TModDataGraph        );  RegisterModuleType( 1116, TModFreqCount        );
    RegisterModuleType( 1117, TModTextWriter       );

    RegisterModuleType( 1201, TModSequencer        );  RegisterModuleType( 1202, TModTextSequencer    );
    RegisterModuleType( 1203, TModSeqStep          );  RegisterModuleType( 1204, TModSeqClockStep     );
    RegisterModuleType( 1205, TModEuclideanRhythm  );  RegisterModuleType( 1206, TModCsvData          );
    RegisterModuleType( 1207, TModKleeBit          );  RegisterModuleType( 1208, TModSeqRandom        );
    RegisterModuleType( 1209, TModMorse            );  RegisterModuleType( 1210, TModGateSeq          );
    RegisterModuleType( 1211, TModSeq16            );  RegisterModuleType( 1212, TModSeqSeq           );
    RegisterModuleType( 1213, TModPattern          );  RegisterModuleType( 1214, TModProbSequencer    );
    RegisterModuleType( 1215, TModLut              );  RegisterModuleType( 1216, TModSeqChord         );
    RegisterModuleType( 1217, TModSeqRandVal       );  RegisterModuleType( 1218, TModRewriter         );
    RegisterModuleType( 1219, TModRewriterNote     );  RegisterModuleType( 1220, TModTuneSmithy       );
    RegisterModuleType( 1221, TModCellAut          );  RegisterModuleType( 1222, TModLifeSeq          );
    RegisterModuleType( 1223, TModSeqPattern       );  RegisterModuleType( 1224, TModSeqValues        );
    RegisterModuleType( 1225, TModAmuse            );  RegisterModuleType( 1226, TModAnalogStack      );
    RegisterModuleType( 1227, TModSwanSong         );  RegisterModuleType( 1228, TModCellAut2         );
    RegisterModuleType( 1229, TModSeq32            );  RegisterModuleType( 1230, TModLeakyGateSeq     );
    RegisterModuleType( 1231, TModNeuralPulser     );  RegisterModuleType( 1232, TModSmallLifeSeq     );
    RegisterModuleType( 1233, TModVcps             );  RegisterModuleType( 1234, TModQueue            );
    RegisterModuleType( 1235, TModVitaPHoBium      );

    RegisterModuleType( 1301, TModMidiNoteIn       );  RegisterModuleType( 1302, TModMidiCCIn         );
    RegisterModuleType( 1303, TModMidiNoteOut      );  RegisterModuleType( 1304, TModMidiCCOut        );
    RegisterModuleType( 1305, TModMidiPlayer       );  RegisterModuleType( 1306, TModSync             );
    RegisterModuleType( 1307, TModOscMessage       );  RegisterModuleType( 1308, TModMidiMultiNoteIn  );
    RegisterModuleType( 1309, TModLiveMorph        );  RegisterModuleType( 1310, TModAuto             );
    RegisterModuleType( 1311, TModMidiPCOut        );  RegisterModuleType( 1312, TModMidiPNOut        );
    { 1313 free for future use, was autmationstep}     RegisterModuleType( 1314, TModMorphControl     );
    RegisterModuleType( 1315, TModMidiSysexOut     );

    RegisterModuleType( 1401, TModFreqShifter      );

    RegisterModuleType( 4001, TModHrastOsc         );  RegisterModuleType( 4002, TModHrastSVF         );
  end;


initialization

  RegisterModuleTypes;

end.

