unit MarkdownProcessor;

{
  Copyright (C) 2015+ Grahame Grieve <grahameg@gmail.com> (pascal port)

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
}

{
  Contribution Credits
  --------------------

  - Pavel Stugel - revisions for support of older Delphi versions and FPC

  =====================================================================================================================

  This code was translated from delph-markdown ( https://github.com/grahamegrieve/delphi-markdown)

  Modified for use in Wren by Blue Hell.

  [ 2016-06-12]

  - redid the code layout.
  - renamed various stuff.
  - added const qualifiers where appropriate.
  - Free changed into DisposeOff.
  - fixed speLings and CapItAlizationz stuvvs.
  - removed the FPC stuff and possibly some 'older Delphi' stuff (as XE5 complained a bit).

  For all listed email addresses :

    _dot. to be substituted by a dot      '.'
    2@t2  to be substituted by an at sign '@'


  Blue Hell is a trade mark owned by

    Jan Punter
    https://www.bluehell.nl/
    jan2@t2mail_dot_bluehell_dot_nl
}


interface

uses

  SysUtils;


type

  EMarkDownException        = class( Exception);
  EUnknownMarkDownDialect   = class( EMarkDownException);
  TMarkdownProcessorDialect =
  (
    mdDaringFireball
  );


  TMarkdownProcessor = class
  protected
    function    GetUnSafeMode: Boolean;                                                               virtual; abstract;
    procedure   SetUnSafeMode( const aValue: Boolean);                                                virtual; abstract;
  public
    function    Process( const aSource : string): string;                                             virtual; abstract;
  public
    class function CreateDialect( aDialect: TMarkdownProcessorDialect): TMarkdownProcessor;
  public
    property    UnSafeMode: boolean read GetUnSafeMode write SetUnSafeMode;    // when Unsafe = true, then the processor can create scripts etc.
  end;


implementation


uses

  MarkdownDaringFireball;


    {TMarkdownProcessor }

    class function TMarkdownProcessor.CreateDialect( aDialect: TMarkdownProcessorDialect): TMarkdownProcessor;
    begin
      case aDialect of
        mdDaringFireball : Result := TMarkdownDaringFireball.Create;
        else raise EUnknownMarkDownDialect.Create( 'Unknown Markdown dialect');
      end;
    end;


end.

