needs work
//{$I AlGun.inc}

interface

uses

  System.Math;

//  -------------------------------------------------------------------------------------------------------------------
//
// Original copyright message:
//
//   This file is part of Gnuspeech, an extensible, text-to-speech package, based on real-time, articulatory,
//   speech-synthesis-by-rules.
//
//   Copyright 1991-2012 David R. Hill, Leonard Manzara, Craig Schock
//
//  -------------------------------------------------------------------------------------------------------------------
//
// Translated to Pascal by Blue Hell, copyright note for the changes:
//
//   (C) COPYRIGHT 2019 Blue Hell / Jan Punter
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License version 2 as
//   published by the Free Software Foundation;
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//   For all listed email addresses :
//
//     _dot. to be substituted by a dot      '.'
//     2@t2  to be substituted by an at sign '@'
//
//
//   Blue Hell is a trade mark owned by
//
//     Jan Punter
//     https://www.bluehell.nl/
//     jan2@t2mail_dot_bluehell_dot_nl
//
//  -------------------------------------------------------------------------------------------------------------------


(*  REVISION INFORMATION  *****************************************************
$Author: len $
$Date: 1995/04/17 19:51:21 $
$Revision: 1.9 $
$Source: /cvsroot/softwareTRM/tube.c,v $
$State: Exp $


$Log: tube.c,v $
 * Revision 1.10 2009-04-19 15:14 david
 * Initial 0.7 release -- added pthread and buffers needed to interface with Objective-C
 * aComponents created to implement 'Synthesizer' for the Macintosh under OS X
 * Note that the frication volume final output increases when glottal volume decreases.
 * This needs to be fixed not
 *
 * Revision 1.9 2006/04/01 18:11 david
 * Remove all things not required for running Synthesizer and split off structures
 *
 * Revision 1.8  1995/04/17  19:51:21  len
 * Temporary fix to frication balance.
 *
 * Revision 1.7  1995/03/21  04:52:37  len
 * Now compiles FAT.  Also adjusted mono and stereo output volume to match
 * approximately the output volume of the DSP.
 *
 * Revision 1.6  1995/03/04  05:55:57  len
 * Changed controlRate parameter to a Single.
 *
 * Revision 1.5  1995/03/02  04:33:04  len
 * Added amplitude scaling to input of vocal tract and throat, to keep the
 * software TRM in line with the DSP version.
 *
 * Revision 1.4  1994/11/24  05:24:12  len
 * Added Hi/Low output sample rate case.
 *
 * Revision 1.3  1994/10/20  21:20:19  len
 * Changed nose and mouth aperture filter coefficients, so now specified as
 * Hz values (which scale appropriately as the tube length changes), rather
 * than arbitrary coefficient values (which don't scale).
 *
 * Revision 1.2  1994/08/05  03:12:52  len
 * Resectioned tube so that it more closely conforms the the DRM proportions.
 * Also changed frication injection so now allowed from S3 to S10.
 *
 * Revision 1.1.1.1  1994/07/07  03:48:52  len
 * Initial archived version.
 *

******************************************************************************)


(******************************************************************************
*
*     aProgram:       tube
*
*     Description:   Software (non-aReal-time) implementation of the Tube
*                    Resonance Model for speech production.
*
*     Author:        Leonard Manzara
*
*     Date:          July 5th, 1994
*
******************************************************************************)

implementation


// Stuff from syn_structs.h

const

TOTAL_NASAL_SECTIONS     =     6;
TOTAL_REGIONS            =     8;
//FALSE                  =     0;
TABLE_LENGTH             =   512;
TEMPERATURE_DEF		       =    32.0;
GLOT_PITCH_DEF           =     0.0;
GLOT_VOL_DEF             =    60;
CIRC_BUFF_SIZE			     =  2048;
CIRC_BUFF2_SIZE			     =  8192;
EMPTY					           =    -1;
FULL					           =     1;
OK						           =     0;
TOTAL_SECTIONS           =    10;
TOTAL_NASAL_COEFFICIENTS = TOTAL_NASAL_SECTIONS;
TOTAL_COEFFICIENTS       = TOTAL_REGIONS;
TOTAL_ALPHA_COEFFICIENTS = 3;
TABLE_MODULUS            = TABLE_LENGTH - 1;


var

  controlPeriod     : Integer;
  sampleRate        : Integer;
  actualTubeLength  : Double;
  breathinessFactor : Double;
  crossmixFactor    : Double;
  dampingFactor     : Double;
  tableDiv1         : Integer;
  tableDiv2         : Integer;
  tnLength          : Double;
  tnDelta           : Double;
  basicIncrement    : Double;
  currentPosition   : Double;
  wavetable         : array[ 0 .. TABLE_LENGTH - 1] of Double;
  nasal_coeff       : array[ 0 .. TOTAL_NASAL_COEFFICIENTS - 1] of Double;
  nasal             : array[ 0 .. TOTAL_NASAL_SECTIONS - 1, 0 .. 1, 0 .. 1] of Double;
  oropharynx_coeff  : array[ 0 .. TOTAL_COEFFICIENTS - 1] of Double;
  oropharynx        : array[ 0 .. TOTAL_SECTIONS -1, 0 .. 1, 0 .. 1] of Double;
  alpha             : array[ 0 .. TOTAL_ALPHA_COEFFICIENTS - 1] of Double;
  circBuff2         : array[ 0 .. CIRC_BUFF2_SIZE - 1] of Double;
  circBuff2Start    : PDouble;
  circBuff2InPtr    : PDouble;
  circBuff2OutPtr   : PDouble;
  circBuff2End      : PDouble;
  circBuff2Flag     : Integer;
  circBuff2Count    : Integer;



(*  COMPILE WITH OVERSAMPLING OR PLAIN OSCILLATOR  *)
const OVERSAMPLING_OSCILLATOR = 1;

(*  1 MEANS COMPILE SO THAT INTERPOLATION NOT DONE FOR
    SOME CONTROL RATE PARAMETERS  *)
const MATCH_DSP = 0;


(*  OROPHARYNX REGIONS  *)
const R1 = 0;	(*  S1  *)
const R2 = 1;	(*  S2  *)
const R3 = 2;	(*  S3  *)
const R4 = 3;	(*  S4 & S5  *)
const R5 = 4;	(*  S6 & S7  *)
const R6 = 5;	(*  S8  *)
const R7 = 6;	(*  S9  *)
const R8 = 7;	(*  S10  *)
//#define TOTAL_REGIONS             8  (moved to structs.h)

(*  OROPHARYNX SCATTERING JUNCTION COEFFICIENTS (BETWEEN EACH REGION)  *)
const C1 = R1;	(*  R1-R2 (S1-S2)  *)
const C2 = R2;	(*  R2-R3 (S2-S3)  *)
const C3 = R3;	(*  R3-R4 (S3-S4)  *)
const C4 = R4;	(*  R4-R5 (S5-S6)  *)
const C5 = R5;	(*  R5-R6 (S7-S8)  *)
const C6 = R6;	(*  R6-R7 (S8-S9)  *)
const C7 = R7;	(*  R7-R8 (S9-S10)  *)
const C8 = R8;	(*  R8-AIR (S10-AIR)  *)
//#define TOTAL_COEFFICIENTS        TOTAL_REGIONS  (moved to structs.h)

(*  OROPHARYNX SECTIONS  *)
const S1 = 0;	(*  R1  *)
const S2 = 1;	(*  R2  *)
const S3 = 2;	(*  R3  *)
const S4 = 3;	(*  R4  *)
const S5 = 4;	(*  R4  *)
const S6 = 5;	(*  R5  *)
const S7 = 6;	(*  R5  *)
const S8 = 7;	(*  R6  *)
const S9 = 8;	(*  R7  *)
const S10 = 9;	(*  R8  *)
//#define TOTAL_SECTIONS            10  (moved to structs.h)

(*  NASAL TRACT SECTIONS  *)
const N1 = 0;
const VELUM = N1;
const N2 = 1;
const N3 = 2;
const N4 = 3;
const N5 = 4;
const N6 = 5;
//#define TOTAL_NASAL_SECTIONS      6 (moved to structs.h)

(*  NASAL TRACT COEFFICIENTS  *)
const NC1 = N1;	(*  N1-N2  *)
const NC2 = N2;	(*  N2-N3  *)
const NC3 = N3;	(*  N3-N4  *)
const NC4 = N4;	(*  N4-N5  *)
const NC5 = N5;	(*  N5-N6  *)
const NC6 = N6;	(*  N6-AIR  *)
//#define TOTAL_NASAL_COEFFICIENTS  TOTAL_NASAL_SECTIONS (moved to structs.h)

(*  THREE-WAY JUNCTION ALPHA COEFFICIENTS  *)
const LEFT = 0;
const RIGHT = 1;
const UPPER = 2;
//#define TOTAL_ALPHA_COEFFICIENTS  3

(*  FRICATION INJECTION COEFFICIENTS  *)
const FC1 = 0;	(*  S3  *)
const FC2 = 1;	(*  S4  *)
const FC3 = 2;	(*  S5  *)
const FC4 = 3;	(*  S6  *)
const FC5 = 4;	(*  S7  *)
const FC6 = 5;	(*  S8  *)
const FC7 = 6;	(*  S9  *)
const FC8 = 7;	(*  S10  *)
const TOTAL_FRIC_COEFFICIENTS = 8;


(*  GLOTTAL SOURCE OSCILLATOR TABLE VARIABLES  *)
//#define TABLE_LENGTH              512
//#define TABLE_MODULUS             (TABLE_LENGTH-1)

(*  WAVEFORM TYPES  *)
const WPULSE = 0;
const WSINE = 1;

(*  OVERSAMPLING FIR FILTER CHARACTERISTICS  *)
const FIR_BETA = 0.2;
const FIR_GAMMA = 0.1;
const FIR_CUTOFF = 0.00000001;

(*  PITCH VARIABLES  *)
const PITCH_BASE = 220.0;
const PITCH_OFFSET = 3;	(*  MIDDLE C = 0  *)
const LOG_FACTOR = 3.32193;

(*  RANGE OF ALL VOLUME CONTROLS  *)
const VOL_MAX = 60;

(*  SCALING CONSTANT FOR INPUT TO VOCAL TRACT & THROAT (MATCHES DSP)  *)
//#define VT_SCALE                  0.03125     /*  2^(-5)  */
// this is a temporary fix only, to try to match dsp synthesizer
const VT_SCALE = 0.125;	(*  2^(-3)  *)

(*  FINAL OUTPUT SCALING, SO THAT .SND FILES APPROX. MATCH DSP OUTPUT  *)
const OUTPUT_SCALE = 0.25;

(*  CONSTANTS FOR THE FIR FILTER  *)
const LIMIT = 200;
const BETA_OUT_OF_RANGE = 1;
const GAMMA_OUT_OF_RANGE = 2;
const GAMMA_TOO_SMALL = 3;

(*  CONSTANTS FOR NOISE GENERATOR  *)
const FACTOR = 377.0;
const INITIAL_SEED = 0.7892347;

(*  MAXIMUM SAMPLE VALUE  *)
const RANGE_MAX = 32767.0;

(*  FUNCTION RETURN CONSTANTS  *)
const ERROR = (-1);
const SUCCESS = 0;

(*  BI-DIRECTIONAL TRANSMISSION LINE POINTERS  *)
const TOP = 0;
const BOTTOM = 1;


(*  SAMPLE RATE CONVERSION CONSTANTS  *)
const ZERO_CROSSINGS = 13;	(*  SRC CUTOFF FRQ      *)
const LP_CUTOFF = (11.0/13.0);	(*  (0.846 OF NYQUIST)  *)

const N_BITS = 16;
const L_BITS = 8;
const L_RANGE = 256;	(*  must be 2^L_BITS  *)
const M_BITS = 8;
const M_RANGE = 256;	(*  must be 2^M_BITS  *)
const FRACTION_BITS = (L_BITS + M_BITS);
const FRACTION_RANGE = 65536;	(*  must be 2^FRACTION_BITS  *)
const FILTER_LENGTH = (ZERO_CROSSINGS * L_RANGE);
const FILTER_LIMIT = (FILTER_LENGTH - 1);

const N_MASK = $FFFF0000;
const L_MASK = $0000FF00;
const M_MASK = $000000FF;
const FRACTION_MASK = $0000FFFF;

// const nValue(((x) and N_MASK) shr FRACTION_BITS);

function nValue( x: Cardinal): Cardinal; begin Result := ( x and N_MASK) shr FRACTION_BITS; end;

//const lValue(((x) and L_MASK) shr M_BITS);

function lValue( x: Cardinal): Cardinal; begin Result := ( x and L_MASK) shr M_BITS; end;

//const mValue((x) and M_MASK);

function mValue( x: Cardinal): Cardinal; begin Result := x and M_MASK; end;

//const fractionValue((x) and FRACTION_MASK);

function fractionValue( x: Cardinal): Cardinal; begin Result := x and FRACTION_MASK; end;

const BETA = 5.658;	(*  kaiser window parameters  *)
const IzeroEPSILON = 1E-21;

const OUTPUT_SRATE_LOW = 22050.0;	(* not used apparently *)
const OUTPUT_SRATE_HIGH = 44100.0;	(* not used apparently *)
const BUFFER_SIZE = 1024;	(*  ring buffer size  *)

(*  OUTPUT FILE FORMAT CONSTANTS  *)
const AU_FILE_FORMAT = 0;
const AIFF_FILE_FORMAT = 1;
const WAVE_FILE_FORMAT = 2;

(*  SIZE IN BITS PER OUTPUT SAMPLE  *)
const BITS_PER_SAMPLE = 16;

(*  BOOLEAN CONSTANTS  *)
const FALSE = 0;
const TRUE = 1;

var
(*  REFLECTION AND RADIATION FILTER MEMORY  *)
a10, b11, a20, a21, b21: Double;

(*  NASAL REFLECTION AND RADIATION FILTER MEMORY  *)
na10, nb11, na20, na21, nb21: Double;

(*  THROAT LOWPASS FILTER MEMORY, GAIN  *)
tb1, ta0, throatGain: Double;

(*  FRICATION BANDPASS FILTER MEMORY  *)
bpAlpha, bpBeta, bpGamma: Double;

(*  TEMPORARY SAMPLE STORAGE VALUES  *)
const maximumSampleValue : Double = 0.0;
const numberSamples : LongInt = 0;
// const aFile  * tempFilePtr;

var
(*  MEMORY FOR FRICATION TAPS  *)
fricationTap: array[0 .. TOTAL_FRIC_COEFFICIENTS - 1] of Double;

(*  VARIABLES FOR FIR LOWPASS FILTER  *)
FIRData, FIRCoef : ^Double;
FIRPtr, numberTaps: Integer;

(*  VARIABLES FOR SAMPLE RATE CONVERSION  *)

sampleRateRatio : Double;
h               : array[ 0 .. FILTER_LENGTH - 1] of Double;
deltaH          : array[ 0 .. FILTER_LENGTH  -1] of Double;
buffer          : array[ 0 .. BUFFER_SIZE   - 1] of Double;

fillPtr : Integer;

const emptyPtr : Integer = 0;

var

padSize, fillSize: Integer;

timeRegisterIncrement, filterIncrement, phaseIncrement: Cardinal;

const timeRegister : Cardinal = 0;

var

originalTime, outputTime, signal1, signal2: Double;  // Keep track of where we are in resampling
originalPeriod, outputPeriod: Double;                // The two sample periods
sampleCount: Integer;

type

  TRadii        = array[ 0 .. TOTAL_REGIONS - 1] of Double;
  TCoefficients = array[ 0 .. LIMIT            ] of Double; // Yes, no -1 there
  PCoefficients = ^TCoefficients;
  TDoubles      = array[ 0 .. MaxInt div SizeOf( Double) - 1] of Double;
  PDoubles      = ^TDoubles;

type
	_postureRateParameters = record
		glotPitch      : Double;	//   -0.0
		glotPitchDelta : Double;	//    0
		glotVol        : Double;	//   60
		glotVolDelta   : Double;	//    0
		aspVol         : Double;	//    0
		aspVolDelta    : Double;	//    0
		fricVol        : Double;	//    0
		fricVolDelta   : Double;	//    0
		fricPos        : Double;	//    0
		fricPosDelta   : Double;	//    0
		fricCF         : Double;	// 5000
		fricCFDelta    : Double;	//    0
		fricBW         : Double;	//  250
		fricBWDelta    : Double;	//    0
		radius         : TRadii;  //    0.8, 1.67, 1.905, 1.985, 0.81, 0.495, 0.73, 1.485
		radiusDelta    : TRadii;  //    0,0,0,0,0,0,0,0
		velum          : Double;	//    0
		velumDelta     : Double;	//    0
	end;
	T_postureRateParameters = _postureRateParameters;

var

// _postureRateParameters current :=begin -0.0, 0, 60, 0, 0, 0, 0, 0, 8, 0, 5000, 0, 250, 0, 0.8, 1.67, 1.905, 1.985, 0.81, 0.495, 0.73, 1.485, 0,0,0,0,0,0,0,0, 0,0);  // "ee"

 current : _postureRateParameters = ( // "ee"
   glotPitch      :   -0.0;
   glotPitchDelta :    0;
   glotVol        :   60;
   glotVolDelta   :    0;
   aspVol         :    0;
   aspVolDelta    :    0;
   fricVol        :    0;
   fricVolDelta   :    0;
   fricPos        :    8;
   fricPosDelta   :    0;
   fricCF         : 5000;
   fricCFDelta    :    0;
   fricBW         :  250;
   fricBWDelta    :    0;
   radius         : ( 0.8, 1.67, 1.905, 1.985, 0.81, 0.495, 0.73, 1.485);
   radiusDelta    : ( 0, 0, 0, 0, 0, 0, 0, 0);
   velum          : 0;
   velumDelta     : 0
);


 //_postureRateParameters originalDefaults :=  begin
// GLOT_PITCH_DEF,
// 0.1,
// GLOT_VOL_DEF,
// 0.1,
// 0,
// 0.1,
// 0,
// 0.1,
// 8,
// 0.1,
// 5000,
// 10,
// 250,
// 2,
// 0.8, 1.67, 1.905, 1.985, 0.81, 0.495, 0.73, 1.485,
// 0,0,0,0,0,0,0,0,
// 0,
// 0);  // "ee"

 originalDefaults : _postureRateParameters = ( // "ee"
   glotPitch      : GLOT_PITCH_DEF;
   glotPitchDelta :    0.1;
   glotVol        : GLOT_VOL_DEF;
   glotVolDelta   :    0.1;
   aspVol         :    0;
   aspVolDelta    :    0.1;
   fricVol        :    0;
   fricVolDelta   :    0.1;
   fricPos        :    8;
   fricPosDelta   :    0.1;
   fricCF         : 5000;
   fricCFDelta    :   10;
   fricBW         :  250;
   fricBWDelta    :    0;
   radius         : ( 0.8, 1.67, 1.905, 1.985, 0.81, 0.495, 0.73, 1.485);
   radiusDelta    : ( 0, 0, 0, 0, 0, 0, 0, 0);
   velum          : 0;
   velumDelta     : 0
);



// 18 of the utterance rate parameters follow in the next 21 lines There are 6 more
//static void *currentPointer = &current;

(* Assign values to utterance rate parameters.There are 25 total.
 waveform -- 0 or 1 -- selects pulse or sin wave, and controlRate selects the input control rate -- 1 to 1000
 the default is 100, i.e. every 10 millisecond. waveform and controlRate really don't need to be archived. *)
apScale : Double = 2.5;
balance : Double = 0;
breathiness : Double = 2.5;
channels : Integer = 2;
controlRate : Single = 100;                            // ****

tubeLength : Double = 17;
lossFactor : Double = 0.0;
mixOffset : Double = 48.0;
modulation : Integer = 1;
mouthCoef : Double = 4000.0;
noseCoef : Double = 4000.0;
noseRadiusOriginalDefaults: array [ 0  .. TOTAL_NASAL_SECTIONS - 1] of Double = (1.35, 1.35, 1.7, 1.7, 1.3, 0.9);  (*  fixed nose radii (0 - 3 cm)  *)

temperature : Double = 32;                            (*  tube temperature (25 - 40 C)  *)
throatCutoff : Double = 1500.0;                       (*  throat lp cutoff (50 - nyquist Hz)  *)
throatVol : Double = 6.0;                             (*  throat volume (0 - 48 dB) *)
tnMax : Double = 40;                                  (*  % glottal pulse fall time maximum  *)
tnMin : Double = 16;                                  (*  % glottal pulse fall time minimum  *)
tp : Double = 35;                                     (*  % glottal pulse rise time  *)
volume : Double = 60;                                 (*  master volume (0 - 60 dB)  *)
waveform : Integer = 0;                               (*  GS waveform type (0=PULSE, 1=SINE)  *)

//Integer verbose := FALSE;
current_ptr : Integer = 1;
noseRadius: array[ 0 ..TOTAL_NASAL_SECTIONS - 1] of Double = (1.35, 1.35, 1.7, 1.7, 1.3, 0.9);  (*  fixed nose radii (0 - 3 cm)  *)

outputFileFormat : Integer = 1;
outputRate : Single = 44100;                          (*  output sample rate (22.05, 44.1 KHz)  *)
prev_ptr : Integer = 0;
run : Integer = 0;


//Circular Buffer initialistation

circBuff: array[ 0 .. CIRC_BUFF_SIZE - 1] of Single;


circBuffEnd : PSingle = @ circBuff[ CIRC_BUFF_SIZE - 1];
circBuffInPtr : PSingle = @circBuff[ 0];
circBuffOutPtr : PSingle = @circBuff[ 0];
circBuffStart : PSingle = @circBuff[0];
circBuffFlag : Integer = EMPTY;

//procedure resample(value: Double);

// pthread_mutex_t circBuff2Mutex := PTHREAD_MUTEX_INITIALIZER;
// pthread_cond_t circBuff2Cond := PTHREAD_COND_INITIALIZER;
// pthread_mutex_t circBuffMutex := PTHREAD_MUTEX_INITIALIZER;
// pthread_cond_t circBuffCond := PTHREAD_COND_INITIALIZER;

// Flag to signal pitch period

pitchFlag : Integer = 0;                                  // 0 unless pitch period just started
threadFlag : Integer = 0;




(*	FUNCTIONS TO ALLOW OBJECTIVE-C TO ACCESS THE SYNTHESIS VARIABLES  *)
//procedure setGlotPitch(value: Single);
//procedure setGlotVol(value: Single);
//procedure setAspVol(value: Single);
//procedure setFricVol(value: Single);
//procedure setfricPos(value: Single);
//procedure setFricCF(value: Single);
//procedure setFricBW(value: Single);
//procedure setRadius(value: Single; index: Integer);
//procedure setVelum(value: Single);
//procedure setVolume(value: Double);
//procedure setWaveformType(value: Integer);
//procedure setTp(value: Double);
//procedure setTnMin(value: Double);
//procedure setTnMax(value: Double);
//procedure setBreathiness(value: Double);
//procedure setLength(value: Double);
//procedure setTemperature(value: Double);
//procedure setLossFactor(value: Double);
//procedure setApScale(value: Double);
//procedure setMouthCoef(value: Double);
//procedure setNoseCoef(value: Double);
//procedure setNoseRadius(value: Double; index: Integer);
//procedure setThroatCoef(value: Double);
//procedure setModulation(value: Integer);
//procedure setMixOffset(value: Double);

(*  FUNCTIONS TO ALLOW INTERFACE OBJECTIVE-C ACCESS TO DEFAULT TUBE PARAMETERS  *)
//function  getGlotPitchDefault(): Double;
//function  getGlotVolDefault(): Double;
//function  getAspVolDefault(): Double;
//function  getFricVolDefault(): Double;
//function  getFricPosDefault(): Double;
//function  getFricCFDefault(): Double;
//function  getFricBWDefault(): Double;
//function  getRadiusDefault(index: Integer): Double;
//function  getVelumRadiusDefault(): Double;
//function  getVolumeDefault(): Double;
//function  getBalanceDefault(): Double;
//function  getWaveformDefault(): Integer;
//function  getTpDefault(): Double;
//function  getTnMinDefault(): Double;
//function  getTnMaxDefault(): Double;
//function  getBreathinessDefault(): Double;
//function  getLengthDefault(): Double;
//function  getTemperatureDefault(): Double;
//function  getLossFactorDefault(): Double;
//function  getApScaleDefault(): Double;
//function  getMouthCoefDefault(): Double;
//function  getNoseCoefDefault(): Double;
//function  getNoseRadiusDefault(index: Integer): Double;
//function  getThroatCutoffDefault(): Double;
//function  getThroatVolDefault(): Double;
//function  getModulationDefault(): Integer;
//function  getMixOffsetDefault(): Double;

(*  FUNCTIONS TO ALLOW INTERFACE OBJECTIVE-C ACCESS TO TUBE PARAMETERS  *)
//function  getGlotPitch(): Double;
//function  getGlotVol(): Double;
//function  getAspVol(): Double;
//function  getFricVol(): Double;
//function  getFricPos(): Double;
//function  getFricCF(): Double;
//function  getFricBW(): Double;
//function  getRadius(index: Integer): Double;
//function  getVelumRadius(): Double;
//function  getVolume(): Double;
//function  getBalance(): Double;
//function  getWaveform(): Integer;
//function  getTp(): Double;
//function  getTnMin(): Double;
//function  getTnMax(): Double;
//function  getBreathiness(): Double;
//function  getLength(): Double;
//function  getTemperature(): Double;
//function  getLossFactor(): Double;
//function  getApScale(): Double;
//function  getMouthCoef(): Double;
//function  getNoseCoef(): Double;
//function  getNoseRadius(index: Integer): Double;
//function  getThroatCutoff(): Double;
//function  getThroatVol(): Double;
//function  getModulation(): Integer;
//function  getMixOffset(): Double;
//function  getActualTubeLength(): Double;
//function  getControlPeriod(): Integer;
//function  getControlRate(): Single;
//function  getSampleRate(): Integer;


// local globals .. erm ...

  seed             : Double  = INITIAL_SEED;
  noiseX           : Double  = 0.0;
  reflectionY      : Double  = 0.0;
  radiationX       : Double  = 0.0;
  radiationY       : Double  = 0.0;
  nasalReflectionY : Double  = 0.0;
  nasalRadiationX  : Double  = 0.0;
  nasalRadiationY  : Double  = 0.0;
  throatY          : Double  = 0.0;
  xn1              : Double  = 0.0;
  xn2              : Double  = 0.0;
  yn1              : Double  = 0.0;
  yn2              : Double  = 0.0;
  fillCounter      : Integer = 0;



value : Double;
value1 : Integer;


(*  GLOBAL FUNCTIONS (LOCAL TO THIS FILE)  ***********************************)

//procedure setupInputTables(
//	glotPitch: Double;  Double glotVol, Double aspVol, Double fricVol, Double fricPos, Double fricCF,
//	fricBW: Double Double *radius, Double velum);

//void printInfo(void);
//int parseInputFile(char *inputFile);
//int initializeSynthesizer(void);

procedure initializeWavetable();                                           forward;
function speedOfSound(temperature: Double): Double;                        forward;
//void updateWavetable(double amplitude);                                  forward;
procedure initializeFIR(beta: Double; gamma: Double; cutoff: Double);      forward;
function noise(): Double;                                                  forward;
function noiseFilter(input: Double): Double;                               forward;
procedure initializeMouthCoefficients(coeff: Double);                      forward;
function reflectionFilter(input: Double): Double;                          forward;
function radiationFilter(input: Double): Double;                           forward;
procedure initializeNasalFilterCoefficients(coeff: Double);                forward;
function nasalReflectionFilter(input: Double): Double;                     forward;
function nasalRadiationFilter(input: Double): Double;                      forward;


procedure initializeNasalCavity();                                         forward;
procedure initializeThroat();                                              forward;
procedure calculateTubeCoefficients();                                     forward;
procedure setFricationTaps();                                              forward;
procedure calculateBandpassCoefficients();                                 forward;
function mod0(value: Double): Double;                                      forward;
procedure incrementTablePosition(frequency: Double);                       forward;
function oscillator(frequency: Double): Double;                            forward;
function vocalTract(input: Double; frication: Double): Double;             forward;
function throat(input: Double): Double;                                    forward;
function bandpassFilter(input: Double): Double;                            forward;
//void convertIntToFloat80(unsigned int value, unsigned char buffer[10]);  forward;
function amplitude(decibelLevel: Double): Double;                          forward;
function frequency(pitch: Double): Double;                                 forward;
function maximallyFlat(beta: Double; gamma: Double; var np: Integer; coefficient : PCoefficients): Integer;  forward;
procedure trim(cutoff: Double; var numberCoefficients: Integer; coefficient: PCoefficients);                 forward;
procedure rationalApproximation( number: Double; var order, numerator, denominator: Integer);               forward;
function FIRFilter(input: Double; needOutput: Integer): Double;                                          forward;
function increment(aPointer: Integer; modulus: Integer): Integer;                                        forward;
function decrement(aPointer: Integer; modulus: Integer): Integer;                                        forward;
procedure initializeConversion();                                                                        forward;
procedure initializeFilter();                                                                            forward;
function Izero2( x: Double): Double;                                                                     forward;
procedure initializeBuffer();                                                                            forward;
procedure dataFill(data: Double);                                                                        forward;
procedure dataEmpty();                                                                                   forward;
function putCircBuff2(circBuff2Value: Single): Integer;                                                  forward;
procedure flushBuffer();                                                                                 forward;
procedure srIncrement( var aPointer: Integer; modulus: Integer);                                         forward;
procedure srDecrement( var aPointer: Integer; modulus: Integer);                                         forward;

procedure initCircBuff;                                                                                  forward
procedure initCircBuff2;                                                                                 forward



(******************************************************************************
*
*	aFunction:	speedOfSound
*
*	purpose:	Returns the speed of sound according to the value of
*                       the temperature (in Celsius degrees).
*			
*       arguments:      temperature
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function speedOfSound(temperature: Double): Double;
begin
  Result := 331.4 + (0.6 * temperature);
  //printf('In tube.c:493 (sp-of-snd) temperature passed is %f computed value s-o-snd %fn', temperature, computedSpeed);
 end;



(******************************************************************************
*
*	aFunction:	initializeSynthesizer
*
*	purpose:	Initializes all variables so that the synthesis can
*                       be run.
*			
*       arguments:      none
*
*	internal
*	functions:	speedOfSound, amplitude, initializeWavetable,
*                       initializeFIR, initializeNasalFilterCoefficients,
*                       initializeNasalCavity, initializeThroat,
*                       initializeConversion
*
*	aLibrary
*	functions:	rint, fprintf, tmpfile, rewind
*
******************************************************************************)

function initializeSynthesizer: Integer;
var
//  initResult : Integer;
// pthread_t synthThreadID;
  nyquist : Double;
  c       : Double;
begin
  //printf('tube.c:531 Initialising synthesisern');

  if( threadFlag = 0 ) then
  begin
    initCircBuff;
    initCircBuff2;
    originalTime   := 0;
    outputTime     := 0;
    sampleCount    := 0;
    circBuff2Count := 0;
   end;


  (*  CALCULATE THE SAMPLE RATE, BASED ON NOMINAL TUBE LENGTH AND SPEED OF SOUND  *)
  if( tubeLength > 0.0 ) then
  begin
    c := speedOfSound(temperature);
    controlPeriod := Round((c * TOTAL_SECTIONS * 100.0) /(tubeLength * controlRate));
    //printf('tube.c:530 ControlPeriod is %d n', controlPeriod);  //rint((c * TOTAL_SECTIONS * 100.0) /(tubeLength * controlRate))); //*((double *) getControlPeriod()));
    sampleRate := Round( controlRate * controlPeriod);       // ****
    originalPeriod := 1.0 / sampleRate;          // ****

    //printf('tube.c:555 SampleRate is %f control period is %d control rate is %f n', controlRate * controlPeriod, controlPeriod, controlRate);  //sampleRate);
    actualTubeLength := (c * TOTAL_SECTIONS * 100.0) / sampleRate;
    //printf('tube.c:557 Actual tube length is %f originalPeriod is %f sampleRate is %un', actualTubeLength, originalPeriod, sampleRate);
    nyquist := 0.5 * sampleRate;
   end
  else
  begin
    //fprintf(stderr, 'tube.c:538Illegal tube length.n');
    Result := ERROR;
    Exit;
  end;

  (*  CALCULATE THE BREATHINESS FACTOR  *)
  breathinessFactor := breathiness / 100.0;

  (*  CALCULATE CROSSMIX FACTOR  *)
  //printf('mixOffset is %fn', mixOffset);
  crossmixFactor := 1.0 / amplitude(mixOffset);
  //printf('**** mixOffset Factor is %fn', crossmixFactor);

  (*  CALCULATE THE DAMPING FACTOR  *)
  dampingFactor := (1.0 - (lossFactor / 100.0));
  //printf('tube.c:563 dampingFactor is %f, lossFactor is %fn', dampingFactor, lossFactor);

  (*  INITIALIZE THE WAVE TABLE  *)
  initializeWavetable();

  (*  INITIALIZE THE FIR FILTER  *)
  initializeFIR(FIR_BETA, FIR_GAMMA, FIR_CUTOFF);

  (*  INITIALIZE REFLECTION AND RADIATION FILTER COEFFICIENTS FOR MOUTH  *)
  initializeMouthCoefficients(( nyquist - mouthCoef) / nyquist);

  (*  INITIALIZE REFLECTION AND RADIATION FILTER COEFFICIENTS FOR NOSE  *)
  initializeNasalFilterCoefficients((nyquist - noseCoef) / nyquist);

  (*  INITIALIZE NASAL CAVITY FIXED SCATTERING COEFFICIENTS  *)
  initializeNasalCavity();

  (*  INITIALIZE THE THROAT LOWPASS FILTER  *)
  initializeThroat();

  (*  INITIALIZE THE SAMPLE RATE CONVERSION ROUTINES  *)
  initializeConversion();

  (*  INITIALIZE THE TEMPORARY OUTPUT FILE  *)
  //tempFilePtr := tmpfile();                          // ****
  //rewind(tempFilePtr);                              // ****

  (*  INITIALIZE THE CIRCULAR HOLDING BUFFER  *)
  //initCircBuff();
  temperature := TEMPERATURE_DEF;

  //printf('tube.c:579 SampleRate is %f control period is %d control rate is %f n', controlRate * controlPeriod, controlPeriod, controlRate);  //sampleRate);


  outputPeriod := 1/outputRate;
  //printf('tube.c:606 outputPeriod is %f, threadFlag is %dn', outputPeriod, threadFlag);

  //Create synthesis thread if it isn't already running
  if( threadFlag = 0 ) then
  begin
    //printf('tube.c:617 thread createdn');
    threadFlag := 1;
//    initResult := pthread_create (@synthThreadID, 0, synthesize, 0);
//    if( initResult <> 0 ) then
//    begin
//      //printf('could not create synthesis thread -- error is %d/%sn', initResult, strerror(initResult));
//      Result:= (-1);
//     end;
//
     end;

  //Return success

  Result:=(SUCCESS);
 end;



(******************************************************************************
*
*	aFunction:	initializeWavetable
*
*	purpose:	Calculates the initial glottal pulse and stores it
*                       in the wavetable, for use in the oscillator.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	calloc, rint
*
******************************************************************************)

procedure initializeWavetable;
var
  i, j : Integer;
  x    : Double;
  x2   : Double;
  x3   : Double;
begin
  // ALLOCATE MEMORY FOR WAVETABLE;
	// var = (double )calloc(TABLE_LENGTH: //wavetable sizeof(double));
  //printf('In tube init wavetable Tp is %f, TnMin is %f and TnMax is %fn', tp, tnMin, tnMax);
  (*  CALCULATE WAVE TABLE PARAMETERS  *)
  tableDiv1 := Round(TABLE_LENGTH * (tp / 100.0));
  tableDiv2 := Round(TABLE_LENGTH * ((tp + tnMax) / 100.0));  // **** works for tnMax but not if tnMin is substituted?
  //printf('tableDiv1 is %d tableDiv2 is %dn', tableDiv1, tableDiv2);
  tnLength := tableDiv2 - tableDiv1;
  tnDelta := Round(TABLE_LENGTH * ((tnMax - tnMin) / 100.0));
  basicIncrement := TABLE_LENGTH / sampleRate;
  currentPosition := 0;

  (*  INITIALIZE THE WAVETABLE WITH EITHER A GLOTTAL PULSE OR SINE TONE  *)
  if waveform = WPULSE
  then begin
    (*  CALCULATE RISE PORTION OF WAVE TABLE  *)
    for i := 0 to tableDiv1 - 1
    do begin
      x := i / tableDiv1;
      x2 := x * x;
      x3 := x2 * x;
      wavetable[ i] := (3.0 * x2) - (2.0 * x3);
     end;

    (*  CALCULATE FALL PORTION OF WAVE TABLE  *)
    j := 0;

    for i := tableDiv1 to tableDiv2 -1
    do begin
      x := j / tnLength;
      wavetable[i] := 1.0 - (x * x);
      Inc( j);
     end;

    (*  SET CLOSED PORTION OF WAVE TABLE  *)
    for i := tableDiv2 to TABLE_LENGTH - 1
    do wavetable[i] := 0.0;
   end
  else begin
    (*  SINE WAVE  *)
    for i := 0 to TABLE_LENGTH - 1
    do wavetable[i] := sin(( i/TABLE_LENGTH) * 2.0 * PI );
   end;
 end;



(******************************************************************************
*
*	aFunction:	updateWavetable
*
*	purpose:	Rewrites the changeable part of the glottal pulse
*                       according to the amplitude.
*			
*       arguments:      amplitude
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	rint
*
******************************************************************************)

procedure updateWavetable( amplitude: Double);
var
  i, j        : Integer;
  x           : Double;
  newDiv2     : Double;
  newTnLength : Double;
begin
  (*  CALCULATE NEW CLOSURE POINT, BASED ON AMPLITUDE  *)
  newDiv2     := tableDiv2 - round( amplitude * tnDelta);
  newTnLength := newDiv2 - tableDiv1;
  //printf("Values in updateWavetable tube.c:684 for i, %d newDiv2 %d, and tableDiv2 %d are:", i, newDiv2, tableDiv2);

  (*  RECALCULATE THE FALLING PORTION OF THE GLOTTAL PULSE  *)
  j := 0;
  i := TableDiv1;

  while i < newDiv2
  do begin
    x := j / newTnLength;
    wavetable[i] := 1.0 - (x * x);
    inc( i);
    inc( j);
  end;

  (*  FILL IN WITH CLOSED PORTION OF GLOTTAL PULSE  *)
  i := Round( newDiv2);

  while i < tableDiv2
  do begin
    wavetable[i] := 0.0;
    Inc( i);
  end;
 end;



(******************************************************************************
*
*	aFunction:	initializeFIR
*
*	purpose:	Allocates memory and initializes the coefficients
*                       for the FIR filter used in the oversampling oscillator.
*			
*       arguments:      beta, gamma, cutoff
*
*	internal
*	functions:	maximallyFlat, trim
*
*	aLibrary
*	functions:	calloc
*
******************************************************************************)

procedure initializeFIR(beta: Double; gamma: Double; cutoff: Double);
var
  i, aPointer, increment, numberCoefficients : Integer;
  coefficient : TCoefficients;
begin
  // DETERMINE IDEAL LOW PASS FILTER COEFFICIENTS
  maximallyFlat(beta, gamma, numberCoefficients, @ coefficient);

  (*  TRIM LOW-VALUE COEFFICIENTS  *)
  trim(cutoff, numberCoefficients, @ coefficient);

  (*  DETERMINE THE NUMBER OF TAPS IN THE FILTER  *)
  numberTaps := (numberCoefficients * 2) - 1;

  (*  ALLOCATE MEMORY FOR DATA AND COEFFICIENTS  *)
//  FIRData := (Double )calloc(numberTaps, SizeOf(Double));
//  FIRCoef := (Double )calloc(numberTaps, SizeOf(Double));

  GetMem( FIRData, numberTaps * SizeOf( Double));
  GetMem( FIRCoef, numberTaps * SizeOf( Double));

  (*  INITIALIZE THE COEFFICIENTS  *)
  increment := -1;
  aPointer  := numberCoefficients;

  for i := 0 to numberTaps - 1
  do begin
    PCoefficients( FIRCoef)^[i] := coefficient[aPointer];
    aPointer := aPointer + increment;
    if( aPointer <= 0 ) then 
    begin 
      aPointer := 2;
      increment := 1;
     end;
   end;

  (*  SET POINTER TO FIRST ELEMENT  *)
  FIRPtr := 0;

{$ifdef DEBUG}
  (*  PRINT OUT  *)
  // printf('n');
  // for( i := 0; i < numberTaps; i++ )
  //   printf('FIRCoef[%-d] := %11.8fn', i, FIRCoef[i]);
{$endif}
 end;



(******************************************************************************
*
*	aFunction:	noise
*
*	purpose:	Returns one value of a random sequence.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function noise: Double;
var
  product : Double;
begin
  seed    := INITIAL_SEED;
  product := seed * FACTOR;
  seed    := product - Floor( product);
  Result:=(seed - 0.5);
end;



(******************************************************************************
*
*	aFunction:	noiseFilter
*
*	purpose:	One-zero lowpass filter.
*
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function noiseFilter(input: Double): Double;
begin
  Result := input + noiseX;
  noiseX := input;
 end;



(******************************************************************************
*
*	aFunction:	initializeMouthCoefficients
*
*	purpose:	Calculates the reflection/radiation filter coefficients
*                       for the mouth, according to the mouth aperture
*                       coefficient.
*			
*       arguments:      coeff - mouth aperture coefficient
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	fabs
*
******************************************************************************)

procedure initializeMouthCoefficients( coeff: Double);
begin
  b11 := - coeff;
  a10 := 1.0 - Abs( b11);
  a20 := coeff;
  a21 := -a20;
  b21 := -a20;
 end;



(******************************************************************************
*
*	aFunction:	reflectionFilter
*
*	purpose:	Is a variable, one-pole lowpass filter, whose cutoff
*                       is determined by the mouth aperture coefficient.
*			
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function reflectionFilter(input: Double): Double;
begin
  Result      := (a10 * input) - (b11 * reflectionY);
  reflectionY := Result;
end;



(******************************************************************************
*
*	aFunction:	radiationFilter
*
*	purpose:	Is a variable, one-zero, one-pole, highpass filter,
*                       whose cutoff point is determined by the mouth aperture
*                       coefficient.
*			
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function radiationFilter(input: Double): Double;
begin 
  Result     := ( a20 * input) + (a21 * radiationX) - (b21 * radiationY);
  radiationX := input;
  radiationY := Result;
 end;



(******************************************************************************
*
*	aFunction:	initializeNasalFilterCoefficients
*
*	purpose:	Calculates the fixed coefficients for the nasal
*                       reflection/radiation filter pair, according to the
*                       nose aperture coefficient.
*			
*       arguments:      coeff - nose aperture coefficient
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	fabs
*
******************************************************************************)

procedure initializeNasalFilterCoefficients( coeff: Double);
begin

  nb11 := -coeff;
  na10 := 1.0 - abs( nb11);

  na20 := coeff;
  na21 := -na20;
  nb21 := -na20;
 end;



(******************************************************************************
*
*	aFunction:	nasalReflectionFilter
*
*	purpose:	Is a one-pole lowpass filter, used for terminating
*                       the end of the nasal cavity.
*			
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function nasalReflectionFilter(input: Double): Double;
begin 
  Result           := (na10 * input) - (nb11 * nasalReflectionY);
  nasalReflectionY := Result;
 end;



(******************************************************************************
*
*	aFunction:	nasalRadiationFilter
*
*	purpose:	Is a one-zero, one-pole highpass filter, used for the
*                       radiation characteristic from the nasal cavity.
*			
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function nasalRadiationFilter(input: Double): Double;
begin 
  Result := (na20 * input) + (na21 * nasalRadiationX) - (nb21 * nasalRadiationY);
  nasalRadiationX := input;
  nasalRadiationY := Result;
 end;



(******************************************************************************
*
*	aFunction:	synthesize
*
*	purpose:	Performs the actual synthesis of sound samples.
*			
*       arguments:      none
*
*	internal
*	functions:	setControlRateParameters, frequency, amplitude,
*                       calculateTubeCoefficients, noise, noiseFilter,
*                       updateWavetable, oscillator, vocalTract, throat,
*                       dataFill, sampleRateInterpolation
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function synthesize: Pointer;
var
  f0, ax, ah1, pulse, lp_noise, pulsed_noise, crossmix, gsignal: Double;  // signal,
  aResult: Integer;
begin
  (*  SAMPLE RATE LOOP TO FILL BUFFER FOR Core Audio IOProc  *)

  //initCircBuff();

  // aResult := pthread_detach ( pthread_self());
  aResult := 0;

  if   aResult <> 0
  then begin
    // printf('could not detach synthesize thread -- error %d/%sn', aResult, strerror(result));
    Result := nil;
    Exit;
  end;

  //printf('tube.c:1063 thread detached, threadFlag is %dn', threadFlag);
  threadFlag := 1;
  // threadID := pthread_self();
  //printf('thread running, threadFlag is %dn', threadFlag);

  while 1 = 1
  do begin

    (*  CONVERT PARAMETERS HERE  *)
    f0 := frequency(current.glotPitch);
    ax := amplitude(current.glotVol);


    //if (j == 10) {

    //	printf("current.glotVol is %f, ax is %f, j is %d", current.glotVol, ax, j);
    //}



    ah1 := amplitude(current.aspVol);
    //printf("Current ah1 is %f", current.aspVol);
    calculateTubeCoefficients();
    setFricationTaps();
    calculateBandpassCoefficients();

    (*  DO SYNTHESIS HERE  *)
    (*  CREATE LOW-PASS FILTERED NOISE  *)
    lp_noise := noiseFilter(noise());

    (*  UPDATE THE SHAPE OF THE GLOTTAL PULSE, IF NECESSARY  *)

    if   waveform = WPULSE
    then updateWavetable(ax);


    (*  CREATE GLOTTAL PULSE (OR SINE TONE) by sampling wavetable in oscillator()  *)
    pulse := oscillator(f0);

    (*  CREATE PULSED NOISE  *)
    pulsed_noise := lp_noise * pulse;

    (*  CREATE NOISY GLOTTAL PULSE  *)
    pulse := ax * ((pulse * (1.0 - breathinessFactor)) + (pulsed_noise * breathinessFactor));

    (*  CROSS-MIX PURE NOISE WITH PULSED NOISE  *)
    if( modulation <> 0)
    then begin
      crossmix := ax * crossmixFactor;

//    crossmix := (crossmix < 1.0) ? crossmix : 1.0;
      if   crossmix > 1.0
      then crossmix := 1.0;

      gsignal := (pulsed_noise * crossmix) + (lp_noise * (1.0 - crossmix));
    end
    else gsignal := lp_noise;

    (*  PUT SIGNAL THROUGH VOCAL TRACT  *)
    gsignal := vocalTract(((pulse + (ah1 * gsignal)) * VT_SCALE),
                         bandpassFilter(gsignal));

    (*  PUT PULSE THROUGH THROAT  *)
    gsignal := gsignal + throat(pulse * VT_SCALE);

    //printf("gsignal b4 %f     ", gsignal);

    gsignal := gsignal * 100;

    // RESAMPLE SUCCESSIVE VALUES FROM TUBE SAMPLE RATE TO OUTPUT SAMPLE RATE
    dataFill(gsignal);

    originalTime:= originalTime + originalPeriod;
   end;

  //return (NULL);
 end;


(******************************************************************************
*
*	aFunction:	sampleRateInterpolation
*
*	purpose:	Interpolates table values at the sample rate.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure sampleRateInterpolation;
var
  i : Integer;
begin
  current.glotPitch := current.glotPitch + current.glotPitchDelta;
  current.glotVol   := current.glotVol   + current.glotVolDelta;
  current.aspVol    := current.aspVol    + current.aspVolDelta;
  current.fricVol   := current.fricVol   + current.fricVolDelta;
  current.fricPos   := current.fricPos   + current.fricPosDelta;
  current.fricCF    := current.fricCF    + current.fricCFDelta;
  current.fricBW    := current.fricBW    + current.fricBWDelta;

  for i := 0 to TOTAL_REGIONS - 1
  do current.radius[ i] := current.radius[ i] + current.radiusDelta[ i];

  current.velum := current.velum + current.velumDelta;

  //printf("current radius R5 is %f", current.radius[4]);
end;



(******************************************************************************
*
*	aFunction:	initializeNasalCavity
*
*	purpose:	Calculates the scattering coefficients for the fixed
*                       sections of the nasal cavity.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure initializeNasalCavity;
var
  i, j : Integer;
  radA2, radB2 : Double;
begin
	// ALCULATE COEFFICIENTS FOR INTERNAL FIXED SECTIONS OF NASAL CAVITY;
  j := NC2;

	for i := N2 to N6 - 1
  do begin
  	radA2          := noseRadius[i]    * noseRadius[i];
	  radB2          := noseRadius[i+1]  * noseRadius[i+1];
  	nasal_coeff[j] := (radA2 - radB2) / (radA2 + radB2);
    Inc( j);
  end;

  (*  CALCULATE THE FIXED COEFFICIENT FOR THE NOSE APERTURE  *)
  radA2 := noseRadius[N6] * noseRadius[N6];
  radB2 := apScale * apScale;
  nasal_coeff[NC6] := (radA2 - radB2) / (radA2 + radB2);
 end;



(******************************************************************************
*
*	aFunction:	initializeThroat
*
*	purpose:	Initializes the throat lowpass filter coefficients
*                       according to the throatCutoff value, and also the
*                       throatGain, according to the throatVol value.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	fabs
*
******************************************************************************)

procedure initializeThroat;
begin
  ta0 := (throatCutoff * 2.0)/sampleRate;
  tb1 := 1.0 - ta0;

  throatGain := amplitude(throatVol);
end;



(******************************************************************************
*
*	aFunction:	calculateTubeCoefficients
*
*	purpose:	Calculates the scattering coefficients for the vocal
*                       tract according to the current radii.  Also calculates
*                       the coefficients for the reflection/radiation filter
*                       pair for the mouth and nose.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure calculateTubeCoefficients;
var
  i : Integer;
  radA2, radB2, r0_2, r1_2, r2_2, sum: Double;
begin
	// CALCULATE COEFFICIENTS FOR THE OROPHARYNX;
	for i := 0 to TOTAL_REGIONS - 2
  do begin
    radA2 := current.radius[i] * current.radius[i];
    radB2 := current.radius[i+1] * current.radius[i+1];
    oropharynx_coeff[i] := (radA2 - radB2) / (radA2 + radB2);
  end;

  //printf("Current radius 8 is %f", current.radius[7]);
  (*  CALCULATE THE COEFFICIENT FOR THE MOUTH APERTURE  *)
  radA2 := current.radius[R8] * current.radius[R8];
  radB2 := apScale * apScale;
  oropharynx_coeff[C8] := (radA2 - radB2) / (radA2 + radB2);

  (*  CALCULATE ALPHA COEFFICIENTS FOR 3-WAY JUNCTION  *)
  (*  NOTE:  SINCE JUNCTION IS IN MIDDLE OF REGION 4, r0_2 = r1_2  *)
  r0_2 := current.radius[R4] * current.radius[R4];
  r1_2 := r0_2;
  r2_2 := current.velum * current.velum;
  sum := 2.0 / (r0_2 + r1_2 + r2_2);
  alpha[LEFT] := sum * r0_2;
  alpha[RIGHT] := sum * r1_2;
  alpha[UPPER] := sum * r2_2;

  (*  AND 1ST NASAL PASSAGE COEFFICIENT  *)
  radA2 := current.velum * current.velum;
  //printf("current.velum is %f", current.velum);
  radB2 := noseRadius[N2] * noseRadius[N2];
  nasal_coeff[NC1] := (radA2 - radB2) / (radA2 + radB2);
 end;



(******************************************************************************
*
*	aFunction:	setFricationTaps
*
*	purpose:	Sets the frication taps according to the current
*                       position and amplitude of frication.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure setFricationTaps;
var
    i, integerPart : Integer;
    complement, remainder : Double;
    fricationAmplitude : Double;
begin
  fricationAmplitude := 10 * (amplitude( current.fricVol)); // Volume x 10 to be audible. Investigate

  //printf("tube.c:1329 frication amplitude is %f, current.fricvol %f", fricationAmplitude, current.fricVol);
  //printf("tube.c:1329 fricPos is %f", current.fricPos);

  (*  CALCULATE POSITION REMAINDER AND COMPLEMENT  *)
  integerPart := Floor( current.fricPos);
  complement  := current.fricPos - integerPart;
  remainder   := 1.0 - complement;
  //printf("tube.c:1336 complement is %f, remainder is %f", complement, remainder);

  (*  SET THE FRICATION TAPS  *)
  for i := FC1 to TOTAL_FRIC_COEFFICIENTS - 1
  do begin
    if i = integerPart
    then begin
      fricationTap[i] := remainder * fricationAmplitude;

      if( (i+1) < TOTAL_FRIC_COEFFICIENTS )
      then fricationTap[++i] := complement * fricationAmplitude;
    end
    else fricationTap[i] := 0.0;
  end;

{$ifdef DEBUG}
  (*  PRINT OUT  *)
//  printf('fricationTaps:  ');
//  for( i := FC1; i < TOTAL_FRIC_COEFFICIENTS; i++ )
//    printf('%.6f  ', fricationTap[i]);
//  printf('n');
{$endif}
 end;



(******************************************************************************
*
*	aFunction:	calculateBandpassCoefficients
*
*	purpose:	Sets the frication bandpass filter coefficients
*                       according to the current center frequency and
*                       bandwidth.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	tan, cos
*
******************************************************************************)

procedure calculateBandpassCoefficients;
var
  tanValue, cosValue: Double;
begin
  tanValue := tan((PI * current.fricBW) / sampleRate);
  cosValue := cos((2.0 * PI * current.fricCF) / sampleRate);

  bpBeta := (1.0 - tanValue) / (2.0 * (1.0 + tanValue));
  bpGamma := (0.5 + bpBeta) * cosValue;
  bpAlpha := (0.5 - bpBeta) / 2.0;
 end;



(******************************************************************************
*
*	aFunction:	mod0
*
*	purpose:	Returns the modulus of 'value', keeping it in the
*                       range 0 ^. TABLE_MODULUS.
*			
*       arguments:      value
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function mod0( value: Double): Double;
begin
  if( value > TABLE_MODULUS )
  then value := value - TABLE_LENGTH;

  Result:= value;
 end;



(******************************************************************************
*
*	aFunction:	incrementTablePosition
*
*	purpose:	Increments the position in the wavetable according to
*                       the desired frequency.
*			
*       arguments:      frequency
*
*	internal
*	functions:	mod0
*
*	aLibrary
*	functions:	none
*
*	Crafty use of mod0() to wrap the currentPosition around at about 510
*	to keep in bounds of wavetable while repeating.  mod0(value) Returns the
*	modulus of 'value', keeping it in the range 0 -> TABLE_MODULUS.
*
*
******************************************************************************)

procedure incrementTablePosition(frequency: Double);
var
  temp : Double;
begin
  temp            := currentPosition;
  currentPosition := mod0( currentPosition + ( frequency * basicIncrement));

  if( currentPosition < temp )
  then pitchFlag := 1
  else pitchFlag := 0;
 end;



(******************************************************************************
*
*	aFunction:	oscillator
*
*	purpose:	Is a 2X oversampling interpolating wavetable
*                       oscillator.
*			
*       arguments:      frequency
*
*	internal
*	functions:	incrementTablePosition, mod0, FIRFilter
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

{$ifdef OVERSAMPLING_OSCILLATOR}
function oscillator(frequency: Double): Double;                (*  2X OVERSAMPLING OSCILLATOR  *)
begin 
  Integer i, lowerPosition, upperPosition;
  Double interpolatedValue, output;


  for( i := 0; i < 2; i++ )
  begin 
    (*  FIRST INCREMENT THE TABLE POSITION, DEPENDING ON FREQUENCY  *)
    incrementTablePosition(frequency/2.0);          // ****

    (*  FIND SURROUNDING INTEGER TABLE POSITIONS  *)
    lowerPosition := (Integer)currentPosition;
    upperPosition := mod0(lowerPosition + 1);

    (*  CALCULATE INTERPOLATED TABLE VALUE  *)
    interpolatedValue = (wavetable[lowerPosition] +
                         ((currentPosition - lowerPosition) *
                          (wavetable[upperPosition] -
                           wavetable[lowerPosition])));

    (*  PUT VALUE THROUGH FIR FILTER  *)
    output := FIRFilter(interpolatedValue, i);
   end;

  (*  SINCE WE DECIMATE, TAKE ONLY THE SECOND OUTPUT VALUE  *)
  Result:=(output);
 end;
{$else}
function oscillator(frequency: Double): Double;                (*  PLAIN OSCILLATOR  *)
var
  lowerPosition, upperPosition: Integer;
begin
  (*  FIRST INCREMENT THE TABLE POSITION, DEPENDING ON FREQUENCY  *)
  incrementTablePosition(frequency);

  (*  FIND SURROUNDING INTEGER TABLE POSITIONS  *)
  lowerPosition := Floor( currentPosition);
  upperPosition := Floor( mod0( lowerPosition + 1));

(*  RETURN INTERPOLATED TABLE VALUE  *)
  Result:=(wavetable[lowerPosition] +
         ((currentPosition - lowerPosition) *
          (wavetable[upperPosition] - wavetable[lowerPosition])));
end;
{$endif}



(******************************************************************************
*
*	aFunction:	vocalTract
*
*	purpose:	Updates the pressure wave throughout the vocal tract,
*                       and returns the summed output of the oral and nasal
*                       cavities.  Also injects frication appropriately.
*			
*       arguments:      input, frication
*
*	internal
*	functions:	reflectionFilter, radiationFilter,
*                       nasalReflectionFilter, nasalRadiationFilter
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function vocalTract(input: Double; frication: Double): Double;
var
  i, j, k : Integer;
  delta, junctionPressure: Double;
begin
  (*  INCREMENT CURRENT AND PREVIOUS POINTERS  *)

  Inc( current_ptr);
  Inc( prev_ptr   );

  if current_ptr > 1
  then current_ptr := 0;

  if prev_ptr > 1
  then prev_ptr := 0;

  (*  UPDATE OROPHARYNX  *)
  (*  INPUT TO TOP OF TUBE  *)
  oropharynx[S1][TOP][current_ptr] := (oropharynx[S1][BOTTOM][prev_ptr] * dampingFactor) + input;

  (*  CALCULATE THE SCATTERING JUNCTIONS FOR S1-S2  *)
  delta := oropharynx_coeff[C1] * (oropharynx[S1][TOP][prev_ptr] - oropharynx[S2][BOTTOM][prev_ptr]);
  oropharynx[S2][TOP][current_ptr] := (oropharynx[S1][TOP][prev_ptr] + delta) * dampingFactor;
  oropharynx[S1][BOTTOM][current_ptr] := (oropharynx[S2][BOTTOM][prev_ptr] + delta) * dampingFactor;

  (*  CALCULATE THE SCATTERING JUNCTIONS FOR S2-S3 AND S3-S4  *)

  j := C2;
  k := FC1;

  for i := S2 to S4 - 1
  do begin
    delta := oropharynx_coeff[j] * (oropharynx[i][TOP][prev_ptr] - oropharynx[i+1][BOTTOM][prev_ptr]);
    oropharynx[i+1][TOP][current_ptr] := ((oropharynx[i][TOP][prev_ptr] + delta) * dampingFactor) + (fricationTap[k] * frication);
    oropharynx[i][BOTTOM][current_ptr] := (oropharynx[i+1][BOTTOM][prev_ptr] + delta) * dampingFactor;
    Inc( j);
    Inc( k);
   end;

  (*  UPDATE 3-WAY JUNCTION BETWEEN THE MIDDLE OF R4 AND NASAL CAVITY  *)
  junctionPressure := (alpha[LEFT] * oropharynx[S4][TOP][prev_ptr])+ (alpha[RIGHT] * oropharynx[S5][BOTTOM][prev_ptr]) + (alpha[UPPER] * nasal[VELUM][BOTTOM][prev_ptr]);
  oropharynx[S4][BOTTOM][current_ptr] := (junctionPressure - oropharynx[S4][TOP][prev_ptr]) * dampingFactor;
  oropharynx[S5][TOP][current_ptr] := ((junctionPressure - oropharynx[S5][BOTTOM][prev_ptr]) * dampingFactor) + (fricationTap[FC3] * frication);
  nasal[VELUM][TOP][current_ptr] := (junctionPressure - nasal[VELUM][BOTTOM][prev_ptr]) * dampingFactor;

  (*  CALCULATE JUNCTION BETWEEN R4 AND R5 (S5-S6)  *)
  delta := oropharynx_coeff[C4] * (oropharynx[S5][TOP][prev_ptr] - oropharynx[S6][BOTTOM][prev_ptr]);
  oropharynx[S6][TOP][current_ptr] := ((oropharynx[S5][TOP][prev_ptr] + delta) * dampingFactor) + (fricationTap[FC4] * frication);
  oropharynx[S5][BOTTOM][current_ptr] := (oropharynx[S6][BOTTOM][prev_ptr] + delta) * dampingFactor;

  (*  CALCULATE JUNCTION INSIDE R5 (S6-S7) (PURE DELAY WITH DAMPING)  *)
  oropharynx[S7][TOP][current_ptr] := (oropharynx[S6][TOP][prev_ptr] * dampingFactor) + (fricationTap[FC5] * frication);
  oropharynx[S6][BOTTOM][current_ptr] := oropharynx[S7][BOTTOM][prev_ptr] * dampingFactor;

  (*  CALCULATE LAST 3 INTERNAL JUNCTIONS (S7-S8, S8-S9, S9-S10)  *)

  j := C5;
  k := FC6;

  for i := S7 to S10 - 1
  do begin
    delta := oropharynx_coeff[j] * (oropharynx[i][TOP][prev_ptr] - oropharynx[i+1][BOTTOM][prev_ptr]);
    oropharynx[i+1][TOP][current_ptr] := ((oropharynx[i][TOP][prev_ptr] + delta) * dampingFactor) + (fricationTap[k] * frication);
    oropharynx[i][BOTTOM][current_ptr] := (oropharynx[i+1][BOTTOM][prev_ptr] + delta) * dampingFactor;
    Inc( j);
    Inc( k);
  end;

  (*  REFLECTED SIGNAL AT MOUTH GOES THROUGH A LOWPASS FILTER  *)
  oropharynx[S10][BOTTOM][current_ptr] :=  dampingFactor * reflectionFilter(oropharynx_coeff[C8] * oropharynx[S10][TOP][prev_ptr]);

  (*  OUTPUT FROM MOUTH GOES THROUGH A HIGHPASS FILTER  *)
  Result := radiationFilter((1.0 + oropharynx_coeff[C8]) * oropharynx[S10][TOP][prev_ptr]);


  (*  UPDATE NASAL CAVITY  *)

  j := NC1;

  for i := VELUM to N6 - 1
  do begin
    delta := nasal_coeff[j] * (nasal[i][TOP][prev_ptr] - nasal[i+1][BOTTOM][prev_ptr]);
    nasal[i+1][TOP][current_ptr] := (nasal[i][TOP][prev_ptr] + delta) * dampingFactor;
    nasal[i][BOTTOM][current_ptr] := (nasal[i+1][BOTTOM][prev_ptr] + delta) * dampingFactor;
    Inc( j);
  end;

  (*  REFLECTED SIGNAL AT NOSE GOES THROUGH A LOWPASS FILTER  *)
  nasal[N6][BOTTOM][current_ptr] := dampingFactor * nasalReflectionFilter(nasal_coeff[NC6] * nasal[N6][TOP][prev_ptr]);

  (*  OUTPUT FROM NOSE GOES THROUGH A HIGHPASS FILTER  *)
  Result := Result + nasalRadiationFilter((1.0 + nasal_coeff[NC6]) * nasal[N6][TOP][prev_ptr]);

  (*  RETURN SUMMED OUTPUT FROM MOUTH AND NOSE  *) // == Result
 end;



(******************************************************************************
*
*	aFunction:	throat
*
*	purpose:	Simulates the radiation of sound through the walls
*                       of the throat.  Note that this form of the filter
*                       uses addition instead of subtraction for the
*                       second term, since tb1 has reversed sign.
*
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function throat(input: Double): Double;
begin 
  Result  := (ta0 * input) + (tb1 * throatY);
  throatY := Result;
  Result  := Result * throatGain;
end;



(******************************************************************************
*
*	aFunction:	bandpassFilter
*
*	purpose:	Frication bandpass filter, with variable center
*                       frequency and bandwidth.
*			
*       arguments:      input
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function bandpassFilter(input: Double): Double;
begin 
  Result := 2.0 * (( bpAlpha * ( input - xn2)) + ( bpGamma * yn1) - ( bpBeta * yn2));
  xn2    := xn1;
  xn1    := input;
  yn2    := yn1;
  yn1    := Result;
 end;



(******************************************************************************
*
*       aFunction:       amplitude
*
*       purpose:        Converts dB value to amplitude value.
*
*       internal
*       functions:      none
*
*       aLibrary
*       functions:      pow
*
******************************************************************************)

function amplitude(decibelLevel: Double): Double;
begin
  //printf("Value passed to amplitude() tube.c:1647 is %f", decibelLevel);
  (*  CONVERT 0-60 RANGE TO -60-0 RANGE  *)
  decibelLevel := decibelLevel - VOL_MAX;

  (*  IF -60 OR LESS, RETURN AMPLITUDE OF 0  *)
  if decibelLevel <= -VOL_MAX
  then Result := 0.0

  (*  IF 0 OR GREATER, RETURN AMPLITUDE OF 1  *)
  else if decibelLevel >= 0.0
  then Result := 1.0

  (*  ELSE RETURN INVERSE LOG VALUE  *)
  else Result := ( Power( 10.0, ( decibelLevel / 20.0)));
end;



(******************************************************************************
*
*       aFunction:       frequency
*
*       purpose:        Converts a given pitch (0 = middle C) to the
*                       corresponding frequency.
*
*       internal
*       functions:      none
*
*       aLibrary
*       functions:      pow
*
******************************************************************************)

function frequency( pitch: Double): Double;
begin
  Result := PITCH_BASE * Power( 2.0, ((pitch + PITCH_OFFSET) / 12.0));
 end;



(******************************************************************************
*
*	aFunction:	maximallyFlat
*
*	purpose:	Calculates coefficients for a linear phase lowpass FIR
*                       filter, with beta being the center frequency of the
*                       transition band (as a fraction of the sampling
*                       frequency), and gamme the width of the transition
*                       band.
*			
*       arguments:      beta, gamma, np, coefficient
*
*	internal
*	functions:	rationalApproximation
*
*	aLibrary
*	functions:	cos, pow
*
******************************************************************************)

function maximallyFlat(beta: Double; gamma: Double; var np: Integer; coefficient : PCoefficients): Integer;
var
  a : TCoefficients;
  c : TCoefficients;
  betaMinimum, ac : Double;
  nt, numerator, n, ll, i : Integer;
  j, jj, m : Integer;
  x, sum, y, z: Double;
begin
  (*  INITIALIZE NUMBER OF POINTS  *)
  np := 0;

  (*  CUT-OFF FREQUENCY MUST BE BETWEEN 0 HZ AND NYQUIST  *)
  if( (beta <= 0.0) or (beta >= 0.5) )
  then begin
    Result := BETA_OUT_OF_RANGE;
    Exit;
  end;

  (*  TRANSITION BAND MUST FIT WITH THE STOP BAND  *)
  // betaMinimum := ((2.0 * beta) < (1.0 - 2.0 * beta)) ? (2.0 * beta) : (1.0 - 2.0 * beta);

  if (2.0 * beta) < (1.0 - 2.0 * beta)
  then betaMinimum := 2.0 * beta
  else betaMinimum := 1.0 - 2.0 * beta;

  if( (gamma <= 0.0) or (gamma >= betaMinimum) )
  then begin
    Result := GAMMA_OUT_OF_RANGE;
    Exit;
  end;

  (*  MAKE SURE TRANSITION BAND NOT TOO SMALL  *)
  nt := Floor( 1.0 / ( 4.0 * gamma * gamma));

  if   nt > 160
  then begin
    Result := GAMMA_TOO_SMALL;
    Exit;
  end;

  (*  CALCULATE THE RATIONAL APPROXIMATION TO THE CUT-OFF POINT  *)
  ac := (1.0 + cos( 2 * PI * beta)) / 2.0;
  rationalApproximation( ac, nt, numerator, np);

  (*  CALCULATE FILTER ORDER  *)
  n := (2 * (np)) - 1;

  if( numerator = 0 )
  then numerator := 1;


  (*  COMPUTE MAGNITUDE AT NP POINTS  *)
  c[1] := 1.0;
  a[1] := 1.0;
  ll   := nt - numerator;

  for i := 2 to np       // note .. to np, not np - 1
  do begin
    sum := 1.0;
    c[i] := cos( 2 * PI * ((i-1)/n));
    x := (1.0 - c[i]) / 2.0;
    y := x;

    if( numerator = nt ) then
      continue;

    for j := 1 to ll      // note .. to ll, not ll - 1
    do begin
      z := y;

      if numerator <> 1
      then begin
        for jj := 1 to numerator - 1
        do z := z * 1.0 + (j / jj);
      end;
      y   := y * x;
      sum := z + z;
    end;

    a[i] := sum * Power((1.0 - x), numerator);
   end;


  (*  CALCULATE WEIGHTING COEFFICIENTS BY AN N-POINT IDFT  *)
  for i := 1 to np
  do begin
    coefficient[i] := a[1] / 2.0;

    for j := 2 to np
    do begin
      m := ((i - 1) * (j - 1)) mod n;

      if( m > nt )
      then m := n - m;

      coefficient[i] := coefficient[i] + c[m+1] * a[j];
    end;

    coefficient[i]:= coefficient[i] * 2.0/n;
   end;

  Result := 0;
 end;



(******************************************************************************
*
*	aFunction:	trim
*
*	purpose:	Trims the higher order coefficients of the FIR filter
*                       which fall below the cutoff value.
*			
*       arguments:      cutoff, numberCoefficients, coefficient
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	fabs
*
******************************************************************************)

procedure trim(cutoff: Double; var numberCoefficients: Integer; coefficient: PCoefficients);
begin
  while numberCoefficients > 0
  do begin
    if abs( coefficient^[ numberCoefficients]) >= abs( cutoff)
    then Exit
    else numberCoefficients := numberCoefficients - 1;
  end;
end;



(******************************************************************************
*
*	aFunction:	rationalApproximation
*
*	purpose:	Calculates the best rational approximation to 'number',
*                       given the maximum 'order'.
*
*       arguments:      number, order, numerator, denominator
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	fabs
*
******************************************************************************)

procedure rationalApproximation( number: Double; var order, numerator, denominator: Integer);
var
  fractionalPart, minimumError: Double;
  i, orderMaximum, modulus: Integer;
  ps : Double;
  ip : Integer;
  error : Double;
begin
  minimumError := 1.0;
  modulus      := 0;

	// RETURN IMMEDIATELY IF THE ORDER IS LESS THAN ONE

  if order <= 0
  then begin
    numerator   := 0;
    denominator := 0;
    order       := -1;
    Exit;
  end;

  // FIND THE ABSOLUTE VALUE OF THE FRACTIONAL PART OF THE NUMBER
	fractionalpart := abs( number - Floor( number));

  (*  DETERMINE THE MAXIMUM VALUE OF THE DENOMINATOR  *)
  orderMaximum := 2 * order;

  // orderMaximum := (orderMaximum > LIMIT) ? LIMIT : orderMaximum;
  if orderMaximum > LIMIT
  then orderMaximum := LIMIT;

  (*  FIND THE BEST DENOMINATOR VALUE  *)
  for i := order to orderMaximum
  do begin
    ps    := i * fractionalPart;
    ip    := Floor(ps + 0.5);
    error := abs(( ps - ip) / i);

    if error < minimumError
    then
    begin
      minimumError := error;
      modulus      := ip;
      denominator  := i;
    end;
  end;

  (*  DETERMINE THE NUMERATOR VALUE, MAKING IT NEGATIVE IF NECESSARY  *)
  numerator := Floor( Abs( number)) * denominator + modulus;

  if number < 0
  then numerator := - numerator;

  (*  SET THE ORDER  *)
  order := denominator - 1;

  (*  RESET THE NUMERATOR AND DENOMINATOR IF THEY ARE EQUAL  *)
  if numerator = denominator
  then begin
    denominator := orderMaximum;
    numerator   := denominator - 1;
    order       := numerator;
   end;
 end;



(******************************************************************************
*
*	aFunction:	FIRFilter
*
*	purpose:	Is the linear phase, lowpass FIR filter.
*			
*       arguments:      input, needOutput
*
*	internal
*	functions:	increment, decrement
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function FIRFilter( input: Double; needOutput: Integer): Double;
var
  i : Integer;
begin
  if needOutput <> 0
  then begin
    Result := 0.0;

    (*  PUT INPUT SAMPLE INTO DATA BUFFER  *)
    PDoubles( FIRData)^[ FIRPtr] := input;

    (*  SUM THE OUTPUT FROM ALL FILTER TAPS  *)
    for i := 0 to numberTaps - 1
    do begin
      Result := Result + PDoubles( FIRData)^[FIRPtr] * PDoubles( FIRCoef)^[i];
      FIRPtr := increment( FIRPtr, numberTaps);
     end;

    (*  DECREMENT THE DATA POINTER READY FOR NEXT CALL  *)
    FIRPtr := decrement( FIRPtr, numberTaps);

    (*  RETURN THE OUTPUT VALUE  *)  // Implicit .. in Result
  end
  else begin
    (*  PUT INPUT SAMPLE INTO DATA BUFFER  *)
    PDoubles( FIRData)^[ FIRPtr] := input;

    (*  ADJUST THE DATA POINTER, READY FOR NEXT CALL  *)
    FIRPtr := decrement( FIRPtr, numberTaps);

    Result := 0.0;
  end;
end;



(******************************************************************************
*
*	aFunction:	increment
*
*	purpose:	Increments the aPointer to the circular FIR filter
*                       buffer, keeping it in the range 0 ^. modulus-1.
*			
*       arguments:      aPointer, modulus
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function increment( aPointer: Integer; modulus: Integer): Integer;
begin
  if   aPointer + 1 >= modulus
  then Result := 0
  else Result := aPointer + 1;
 end;


(******************************************************************************
*
*	aFunction:	decrement
*
*	purpose:	Decrements the aPointer to the circular FIR filter
*                       buffer, keeping it in the range 0 ^. modulus-1.
*
*       arguments:      aPointer, modulus
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function decrement(aPointer: Integer; modulus: Integer): Integer;
begin
  if   aPointer - 1 < 0
  then Result := modulus-1
  else Result := aPointer - 1;
 end;



(******************************************************************************
*
*	aFunction:	initializeConversion
*
*	purpose:	Initializes all the sample rate conversion functions.
*
*       arguments:      none
*
*	internal
*	functions:	initializeFilter, initializeBuffer
*
*	aLibrary
*	functions:	rint, pow
*	[apparently not called 2009-01-07]
*
******************************************************************************)

procedure initializeConversion;
var
  roundedSampleRateRatio: Double;
begin
  // INITIALIZE FILTER IMPULSE RESPONSE;
	initializeFilter;

  (*  CALCULATE SAMPLE RATE RATIO  *)
  sampleRateRatio := outputRate / sampleRate;
  // printf('tube.c:2047 output-rate is: %f, sample rate is: %d, sample rate ratio is: %fn',outputRate, sampleRate, sampleRateRatio);

  (*  CALCULATE TIME REGISTER INCREMENT  *)
  timeRegisterIncrement := Round( Power( 2.0, FRACTION_BITS) / sampleRateRatio);

  (*  CALCULATE ROUNDED SAMPLE RATE RATIO  *)
  roundedSampleRateRatio := Power( 2.0, FRACTION_BITS) / timeRegisterIncrement;

  (*  CALCULATE PHASE OR FILTER INCREMENT  *)
  if( sampleRateRatio >= 1.0 )
  then filterIncrement := L_RANGE
  else phaseIncrement  := Round( sampleRateRatio * FRACTION_RANGE);

  (*  CALCULATE PAD SIZE  *)
  // padSize := (sampleRateRatio >= 1.0) ? ZERO_CROSSINGS : (Integer)((Single)ZERO_CROSSINGS / roundedSampleRateRatio) + 1;

  if sampleRateRatio >= 1.0
  then padSize := ZERO_CROSSINGS
  else padSize := Floor(( ZERO_CROSSINGS / roundedSampleRateRatio) + 1);

  (*  INITIALIZE THE RING BUFFER  *)
  initializeBuffer();
 end;



(******************************************************************************
*
*	aFunction:	initializeFilter
*
*	purpose:	Initializes filter impulse response and impulse delta
*                       values.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	sin, cos
*
******************************************************************************)

procedure initializeFilter;
var
  x, y, IBeta : Double;
  i           : Integer;
  temp        : Double;
begin
	// INITIALIZE THE FILTER IMPULSE RESPONSE
	h[ 0] := LP_CUTOFF;
	x     := PI / L_RANGE;

	for i := 1 to FILTER_LENGTH - 1
	do begin
    y     := i * x;
    h[ i] := Sin( y * LP_CUTOFF) / y;
  end;

  // APPLY A KAISER WINDOW TO THE IMPULSE RESPONSE;
	IBeta := 1.0 / Izero2( BETA);

  for i := 0 to FILTER_LENGTH - 1
  do begin
    temp  := i / FILTER_LENGTH;
    h[ i] := h[ i] * Izero2( BETA * sqrt( 1.0 - ( temp * temp))) * IBeta;
   end;

  (*  INITIALIZE THE FILTER IMPULSE RESPONSE DELTA VALUES  *)
  for i := 0 to FILTER_LIMIT - 1
  do  deltaH[i] := h[i+1] - h[i];

  deltaH[FILTER_LIMIT] := 0.0 - h[FILTER_LIMIT];
 end;



(******************************************************************************
*
*	aFunction:	Izero2
*
*	purpose:	Returns the value for the modified Bessel aFunction of
*                       the first kind, order 0, as a Double.
*
*       arguments:      x - input argument
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

function Izero2( x: Double): Double;
var
  sum, u, halfx, temp : Double;
  n : Integer;
begin
  sum   := 1;
  u     := 1;
  n     := 1;
  halfx := x / 2.0;

  repeat
    temp := halfx / n;
    n    := n + 1;
    temp := temp * temp;
    u    := u * temp;
    sum  := sum + u;
  until u < IzeroEPSILON * sum;

  Result:=(sum);
 end;



(******************************************************************************
*
*	aFunction:	initializeBuffer
*
*	purpose:	Initializes the ring buffer used for sample rate
*                       conversion.
*			
*       arguments:      none
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure initializeBuffer;
var
  i : Integer;
begin
  //  FILL THE RING BUFFER WITH ALL ZEROS
  for i := 0 to BUFFER_SIZE - 1
  do buffer[ i] := 0.0;

  //  INITIALIZE FILL POINTER
  fillPtr := padSize;

  //  CALCULATE FILL SIZE
  fillSize := BUFFER_SIZE - ( 2 * padSize);
end;


(******************************************************************************
*
*	aFunction:	dataFill
*
*	purpose:	Fills the ring buffer with one sample, increments
*                       the counters and pointers, and empties the buffer when
*                       full.
*			
*       arguments:      data
*
*	internal
*	functions:	srIncrement, dataEmpty
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure dataFill( data: Double);
begin
  // PUT THE DATA INTO THE RING BUFFER;
	buffer[ fillPtr] := data;

	// INCREMENT THE FILL POINTER: (;  MODULO THE BUFFER SIZE  *)
	srIncrement( fillPtr, BUFFER_SIZE);

  (*  INCREMENT THE COUNTER, AND EMPTY THE BUFFER IF FULL  *)

  Inc( fillCounter);

  if   fillCounter >= fillSize
  then begin
    dataEmpty();
    (* RESET THE FILL COUNTER  *)
    fillCounter := 0;
  end;
end;



(******************************************************************************
*
*	aFunction:	dataEmpty
*
*	purpose:	Converts available portion of the input signal to the
*                       new sampling rate, and outputs the samples to the
*                       sound .
*
*       arguments:      none
*
*	internal
*	functions:	srDecrement, srIncrement
*
*	aLibrary
*	functions:	rint, fabs, FileWrite
*
******************************************************************************)

procedure dataEmpty;
var
  endPtr : Integer;
  index : Integer;
  phaseIndex, impulseIndex : Cardinal;
  absoluteSampleValue, output, impulse : Double;
  failed : Integer;
  filterIndex: Cardinal;
  interpolation : Double;
begin
	// CALCULATE END POINTER
	endPtr := fillPtr - padSize;

	// ADJUST THE END POINTER: IF LESS THAN ZERO
  if   endPtr < 0
  then endPtr := endPtr + BUFFER_SIZE;

	// ADJUST THE ENDPOINT, IF LESS THAN THE EMPTY POINTER
  if   endPtr < emptyPtr
  then endPtr := endPtr + BUFFER_SIZE;


	// UPSAMPLE LOOP (SLIGHTLY MORE EFFICIENT THAN DOWNSAMPLING)
  if   sampleRateRatio >= 1.0
  then begin
    while emptyPtr < endPtr
    do begin

      // RESET ACCUMULATOR TO ZERO;
      output := 0.0;

      // CALCULATE INTERPOLATION VALUE (STATIC WHEN UPSAMPLING
      interpolation := mValue( timeRegister) / M_RANGE;

      // COMPUTE THE LEFT SIDE OF THE FILTER CONVOLUTION;
      index       := emptyPtr;
      filterIndex := lValue( timeRegister);

      while filterIndex < FILTER_LENGTH
      do begin
        output := output + ( buffer[ index] * ( h[ filterIndex] + ( deltaH[ filterIndex] * interpolation)));
        srDecrement( index, BUFFER_SIZE);
        filterIndex := filterIndex + filterIncrement;
      end;

      (*  ADJUST VALUES FOR RIGHT SIDE CALCULATION  *)
      timeRegister  := not timeRegister;
      interpolation := mValue( timeRegister) / M_RANGE;

      (*  COMPUTE THE RIGHT SIDE OF THE FILTER CONVOLUTION  *)
      index := emptyPtr;
      srIncrement( index,BUFFER_SIZE);
      filterIndex := lValue( timeRegister);

      while filterIndex < FILTER_LENGTH
      do begin
        output      := output + (buffer[index] * (h[filterIndex] + (deltaH[filterIndex] * interpolation)));
        filterIndex := filterIndex + filterIncrement;
      end;


      (*  RECORD MAXIMUM SAMPLE VALUE  *)
      absoluteSampleValue := Abs( output);

      if absoluteSampleValue > maximumSampleValue
      then maximumSampleValue := absoluteSampleValue;

      (*  INCREMENT SAMPLE NUMBER  *)
      Inc( numberSamples);

      (*  OUTPUT THE SAMPLE TO THE TEMPORARY FILE  *)
      //fwrite((char *)&output, sizeof(output), 1, tempFilePtr);

      // OUTPUT SAMPLE TO CIRCBUFF2
//        pthread_mutex_lock (@circBuff2Mutex);
//
//        outWait1:
//
//        while( circBuff2Flag := FULL )
//        do pthread_cond_wait (@circBuff2Cond, @circBuff2Mutex);  // if circBuff2 full, sleep & wait
//
//        if( circBuff2Flag := FULL )
//        then  goto outWait1;
//
      failed := putCircBuff2( output);     // if room, put output in circBuff2
//
      if failed = 1
      then { goto outWait1};
//
//        pthread_mutex_unlock (@circBuff2Mutex);
//        pthread_cond_signal(@circBuff2Cond);

        //printf("tube.c:2390 %f  ", output);


      (*  CHANGE TIME REGISTER BACK TO ORIGINAL FORM  *)
      timeRegister := not timeRegister;

      (*  INCREMENT THE TIME REGISTER  *)
      timeRegister := timeRegister + timeRegisterIncrement;

      (*  INCREMENT THE EMPTY POINTER, ADJUSTING IT AND END POINTER  *)
      emptyPtr := emptyPtr + Integer( nValue( timeRegister));

      if emptyPtr >= BUFFER_SIZE
      then begin
        emptyPtr := emptyPtr - BUFFER_SIZE;
        endPtr   := endPtr   - BUFFER_SIZE;
      end;

      (*  CLEAR N PART OF TIME REGISTER  *)
      timeRegister := timeRegister and ( not N_MASK);
    end;
    (* DOWNSAMPLING CONVERSION LOOP  *)
  end
  else begin
    while emptyPtr < endPtr
    do begin

      (*  RESET ACCUMULATOR TO ZERO  *)
      output := 0.0;

      (*  COMPUTE P PRIME  *)
      phaseIndex := Round(( fractionValue( timeRegister)) * sampleRateRatio);

      (*  COMPUTE THE LEFT SIDE OF THE FILTER CONVOLUTION  *)
      index := emptyPtr;

      impulseIndex := phaseIndex shr M_BITS;

      while impulseIndex < FILTER_LENGTH
      do begin
        impulse := h[impulseIndex] + (deltaH[impulseIndex] * (( mValue( phaseIndex)) / M_RANGE));
        output  := output + ( buffer[index] * impulse);
        srDecrement( index, BUFFER_SIZE);
        phaseIndex   := phaseIndex + phaseIncrement;
        impulseIndex := phaseIndex shr M_BITS;
      end;

      (*  COMPUTE P PRIME, ADJUSTED FOR RIGHT SIDE  *)
      phaseIndex := Round( fractionValue( not timeRegister) * sampleRateRatio);

      (*  COMPUTE THE RIGHT SIDE OF THE FILTER CONVOLUTION  *)
      index := emptyPtr;
      srIncrement( index, BUFFER_SIZE);

      impulseIndex := phaseIndex shr M_BITS;

      while impulseIndex < FILTER_LENGTH
      do begin
        impulse := h[impulseIndex] + (deltaH[impulseIndex] * ( mValue( phaseIndex) / M_RANGE));
        output  := output + (buffer[index] * impulse);
        srIncrement( index, BUFFER_SIZE);
        phaseIndex := phaseIndex + phaseIncrement;
        impulseIndex := phaseIndex shr M_BITS;
      end;

      (*  RECORD MAXIMUM SAMPLE VALUE  *)
      absoluteSampleValue := Abs( output);

      if   absoluteSampleValue > maximumSampleValue
      then maximumSampleValue := absoluteSampleValue;

      (*  INCREMENT SAMPLE NUMBER  *)
      numberSamples:= numberSamples + 1;

      (*  OUTPUT THE SAMPLE TO THE TEMPORARY aFile  *)  // ****
      //fwrite((char *)&output, sizeof(output), 1, tempFilePtr);

      // OUTPUT SAMPLE TO CIRCBUFF2
      // pthread_mutex_lock (@circBuff2Mutex);

      // outWait2:

      // while( circBuff2Flag := FULL )
      // do pthread_cond_wait( @ circBuff2Cond, @circBuff2Mutex);  // if circBuff2 full, sleep & wait

      // if   circBuff2Flag := FULL
      // then goto outWait2;

      failed := putCircBuff2( output);     // if room, put output in circBuff2
      if    failed = 1
      then  {goto outWait2};

      //pthread_mutex_unlock (@circBuff2Mutex);
      //pthread_cond_signal(@circBuff2Cond);

      //printf('tube.c:2464 %f  ', output);


      (*  INCREMENT THE TIME REGISTER  *)
      timeRegister := timeRegister + timeRegisterIncrement;

      (*  INCREMENT THE EMPTY POINTER, ADJUSTING IT AND END POINTER  *)
      emptyPtr := emptyPtr + Integer( nValue( timeRegister));

      if   emptyPtr >= BUFFER_SIZE
      then begin
        emptyPtr := emptyPtr - BUFFER_SIZE;
        endPtr   := endPtr   - BUFFER_SIZE;
      end;

      (*  CLEAR N PART OF TIME REGISTER  *)
      timeRegister := timeRegister and ( not N_MASK);
    end;
  end;
end;



(******************************************************************************
*
*	aFunction:	flushBuffer
*
*	purpose:	Pads the buffer with zero samples, and flushes it by
*                       converting the remaining samples.
*			
*       arguments:      none
*
*	internal
*	functions:	dataFill, dataEmpty
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure flushBuffer;
var
  i : Integer;
begin
	// PAD END OF RING BUFFER WITH ZEROS;
  for i := 0 to 2 * padSize - 1
  do dataFill( 0.0);

  (*  FLUSH UP TO FILL POINTER - PADSIZE  *)
  dataEmpty;
end;



(******************************************************************************
*
*	aFunction:	srIncrement
*
*	purpose:	Increments the aPointer, keeping it within the range
*                       0 to (modulus-1).
*
*       arguments:      aPointer, modulus
*
*	internal
*	functions:	none
*
*	aLibrary
*	functions:	none
*
******************************************************************************)

procedure srIncrement( var aPointer: Integer; modulus: Integer);
begin
  aPointer := aPointer + 1;

  if   aPointer >= modulus
  then aPointer := aPointer - modulus;
end;

procedure srDecrement( var aPointer: Integer; modulus: Integer);
begin
  aPointer := aPointer - 1;

  if   aPointer < modulus
  then aPointer := aPointer + modulus;
end;

// FUNCTIONS TO ALLOW OBJECTIVE-C TO SET TUBE PARAMETERS;
//	v31: ;
//	setGlotPitch(Single value): procedure;
//	v33: begin;
//	:= value; current.glotPitch;
//	v35: end;;
//	v36: ;
//	setGlotVol(Single value): procedure;
//	v38: begin;
//	:= value; current.glotVol;
//	v40: end;;
//	v41: ;
//	setAspVol(Single value): procedure;
//	v43: begin;
//	:= value; current.aspVol;
//	v45: end;;
//	v46: ;
//	setFricVol(Single value): procedure;
//	v48: begin;
//	:= value; current.fricVol;
//	v50: end;;
//	v51: ;
//	setfricPos(Single value): procedure;
//	v53: begin;
//	:= value; current.fricPos;
//	v55: end;;
//	v56: ;
//	setFricCF(Single value): procedure;
//	v58: begin;
//	:= value; current.fricPos;
//	v60: end;;
//	v61: ;
//	setFricBW(Single value): procedure;
//	v63: begin;
//	:= value; current.fricBW;
//	v65: end;;
//	v66: ;
//	setRadius(Single value: procedure;  Integer index)
//	v68: begin;
//	:= value; current.radius[index];
//	v70: end;;
//	v71: ;
//	setVelum(Single value): procedure;
//	v73: begin;
//	:= value; current.velum;
//	v75: end;;
//	v76: ;
//	setVolume(Double value): procedure;
//	v78: begin;
//	:= value; volume;
//	v80: end;;
//	v81: ;
//	setWaveformType(Integer value): procedure;
//	v83: begin;
//	:= value; waveform;
//	v85: end;;
//	v86: ;
//	setTp(Double value): procedure;
//	v88: begin;
//	:= value; tp;
//	v90: end;;
//	v91: ;
//	setTnMin(Double value): procedure;
//	v93: begin;
//	:= value; tnMin;
//	v95: end;;
//	v96: ;
//	setTnMax(Double value): procedure;
//	v98: begin;
//	:= value; tnMax;
//	v100: end;;
//	v101: ;
//	setBreathiness(Double value): procedure;
//	v103: begin;
//	:= value; breathiness;
//	v105: end;;
//	v106: ;
//	setLength(Double value): procedure;
//	v108: begin;
//	:= value; length;
//	v110: end;;
//	v111: ;
//	setTemperature(Double value): procedure;
//	v113: begin;
//	:= value; temperature;
//	v115: end;;
//	v116: ;
//	setLossFactor(Double value): procedure;
//	v118: begin;
//	:= value; lossFactor;
//	v120: end;;
//	v121: ;
//	setApScale(Double value): procedure;
//	v123: begin;
//	:= value; apScale;
//	v125: end;;
//	v126: ;
//	setMouthCoef(Double value): procedure;
//	v128: begin;
//	:= value; mouthCoef;
//	v130: end;;
//	v131: ;
//	setNoseCoef(Double value): procedure;
//	v133: begin;
//	:= value; noseCoef;
//	v135: end;;
//	v136: ;
//	setNoseRadius(Double value: procedure;  Integer index)
//	v138: begin;
//	:= value; noseRadius[index];
//	v140: end;;
//	v141: ;
//	setThroatCutoff(Double value): procedure;
//	v143: begin;
//	:= value; throatCutoff;
//	v145: end;;
//	v146: ;
//	setModulation(Integer value): procedure;
//	v148: begin;
//	:= value; modulation;
//	v150: end;;
//	v151: ;
//	setMixOffset(Double value): procedure;
//	v153: begin;
//	:= value; mixOffset;
//	v155: end;;
//	v156: ;
//	v157: ;
//	var ): (  FUNCTIONS TO ALLOW INTERFACE OBJECTIVE-C ACCESS TO DEFAULT TUBE PARAMETERS;
//	v159: ;
//	getGlotPitchDefault(): Double function;
//	v161: begin;
//	(@originalDefaults.glotPitch: Result:=);
// end;

function  getGlotVolDefault(): Double;
begin
  Result:= originalDefaults.glotVol;
 end;

function  getAspVolDefault(): Double;
begin
  Result:= originalDefaults.aspVol;
 end;

function  getFricVolDefault(): Double;
begin
  Result:= originalDefaults.fricVol;
 end;

function  getFricPosDefault(): Double;
begin
  Result:= originalDefaults.fricPos;
 end;


function  getFricCFDefault(): Double;
begin
  Result:= originalDefaults.fricCF;
 end;

function  getFricBWDefault(): Double;
begin
  Result:= originalDefaults.fricBW;
 end;

function  getRadiusDefault(index: Integer): Double;
begin
  Result:= originalDefaults.radius[index];
 end;

function  getVelumRadiusDefault(): Double;
begin
  Result:= originalDefaults.velum;
 end;

function  getVolumeDefault(): Double;
begin
  Result:= volume;
 end;

function  getWaveformDefault(): Integer;
begin
  Result:= waveform;
 end;

function  getBalanceDefault(): Double;
begin
  Result:= balance;
 end;

function  getTpDefault(): Double;
begin
  Result:= tp;
 end;

function  getTnMinDefault(): Double;
begin
  Result:= tnMin;
 end;

function  getTnMaxDefault(): Double;
begin
  Result:= tnMax;
 end;

function  getBreathinessDefault(): Double;
begin
  Result:= breathiness;
 end;

function  getLengthDefault(): Double;
begin
  Result:= tubeLength;
 end;

function  getTemperatureDefault(): Double;
begin
  Result:= temperature;
 end;

function  getLossFactorDefault(): Double;
begin
  Result:= lossFactor;
 end;

function  getApScaleDefault(): Double;
begin
  Result:= apScale;
 end;

function  getMouthCoefDefault(): Double;
begin
  Result:= mouthCoef;
 end;

function  getNoseCoefDefault(): Double;
begin
  Result:= noseCoef;
 end;

function  getNoseRadiusDefault(index: Integer): Double;
begin
  Result:= noseRadiusOriginalDefaults[ index];
 end;

function  getThroatCutoffDefault(): Double;
begin
  Result:= throatCutoff;
 end;

function  getThroatVolDefault(): Double;
begin
  Result:= throatVol;
 end;

function  getModulationDefault(): Integer;
begin
  Result:= modulation;
 end;

function  getMixOffsetDefault(): Double;
begin
  Result:= mixOffset;
 end;

(*  FUNCTIONS TO ALLOW INTERFACE OBJECTIVE-C ACCESS TO TUBE PARAMETERS  *)

function  getGlotPitch(): Double;
begin
  Result:= current.glotPitch;
 end;

function  getGlotVol(): Double;
begin
  Result:= current.glotVol;
 end;

function  getAspVol(): Double;
begin
  Result:= current.aspVol;
 end;

function  getFricVol(): Double;
begin
  Result:= current.fricVol;
 end;

function  getFricPos(): Double;
begin
  Result:= current.fricPos;
 end;


function  getFricCF(): Double;
begin
  Result:= current.fricCF;
 end;

function  getFricBW(): Double;
begin
  Result:= current.fricBW;
 end;

function  getRadius(index: Integer): Double;
begin
  Result:= current.radius[ index];
 end;

function  getVelumRadius(): Double;
begin
  Result:= current.velum;
 end;

function  getVolume(): Double;
begin
  Result:= volume;
 end;

function  getWaveform(): Integer;
begin
  Result:= waveform;
 end;

function  getBalance(): Double;
begin
  Result:= balance;
 end;


function  getTp(): Double;
begin
  Result:= tp;
 end;

function  getTnMin(): Double;
begin
  Result:= tnMin;
 end;

function  getTnMax(): Double;
begin
  Result:= tnMax;
 end;

function  getBreathiness(): Double;
begin
  Result:= breathiness;
 end;

function  getLength(): Double;
begin
  Result:= tubeLength;
 end;

function  getTemperature(): Double;
begin
  Result:= temperature;
 end;

function  getLossFactor(): Double;
begin
  Result:= lossFactor;
 end;

function  getApScale(): Double;
begin
  Result:= apScale;
 end;

function  getMouthCoef(): Double;
begin
  Result:= mouthCoef;
 end;

function  getNoseCoef(): Double;
begin
  Result:= noseCoef;
 end;

function  getNoseRadius(index: Integer): Double;
begin
  Result:= noseRadius[index];
 end;

function  getThroatCutoff(): Double;
begin
  Result:= throatCutoff;
 end;

function  getThroatVol(): Double;
begin
  Result:= throatVol;
 end;

function  getModulation(): Integer;
begin
  Result:= modulation;
 end;

function  getMixOffset(): Double;
begin
  Result:= mixOffset;
 end;

function  getActualTubeLength(): Double;
begin
  Result:= actualTubeLength;
 end;

function  getSampleRate(): Integer;
begin
  //printf("Sample rate in get routine is %f\n", sampleRate);
  Result:= sampleRate;
 end;

function  getControlPeriod(): Integer;
begin
  //printf("Control period in get routine is %f\n", controlPeriod);
  Result:= controlPeriod;
 end;

function  getControlRate(): Single;
begin

  Result:= controlRate;
 end;

function  getWavetable(index: Integer): Double;
begin
  Result:= wavetable[index];
 end;

function  getThreadFlag(): Integer;
begin
  Result:= threadFlag;
 end;


procedure initCircBuff;
begin
	circBuffInPtr  := @ circBuff[0];
  circBuffOutPtr := @ circBuff[0];
	circBuffEnd    := @ circBuff [CIRC_BUFF_SIZE - 1];
	//printf("in, out, first and last pointers are: %d %d %d %d \n", circBuffInPtr, circBuffOutPtr, circBuff, circBuffEnd);
	circBuffFlag   := EMPTY;
end;

// procedure initCircBuff(v1: "in; v2: out; and last pointers are: %d %d %d %d \n" first; v4: circBuffInPtr; v5: circBuffOutPtr; v6: circBuff; v7: circBuffEnd);
//  circBuffFlag := EMPTY;
//  Exit;
// end;

procedure putCircBuff(circBuff2Value: Single);
begin
//  if circBuffInPtr = circBuffOutPtr - SizeOf( Single)
//  then begin
//    circBuffFlag := FULL;
////    pthread_mutex_unlock (@circBuffMutex);
////    pthread_cond_signal(@circBuffCond);
//
//    Exit;
//   end;
//
//  //printf("tube.c:2914 entering putCircBuff, flag is %d, value is %f start is %d\n", circBuffFlag, circBuffValue, &circBuff[0]);
//  if( circBuffInPtr = @ circBuff[ CIRC_BUFF_SIZE - 1] )
//  then begin
//    if( circBuffOutPtr = @ circBuff[0] )
//    then begin
//      circBuffFlag := FULL;
////      pthread_mutex_unlock (@circBuffMutex);
////      pthread_cond_signal(@circBuffCond);
//
//      Exit;
//     end;
//
//
//    circBuffInPtr^ := circBuffValue;
//
//    //printf("tube.c:2931 circBuffValue is %f\n", circBuffValue);
//
//    circBuffInPtr := @ circBuff[ 0];
//
//    circBuffFlag := OK;
//    pthread_mutex_unlock (@circBuffMutex);
//    pthread_cond_signal(@circBuffCond);
//
//    Exit;
//
//   end;
//  else
//    if( circBuffInPtr = circBuffOutPtr - SizeOf(Single) ) then
//  begin
//    circBuffFlag := FULL;
//    pthread_mutex_unlock (@circBuffMutex);
//    pthread_cond_signal(@circBuffCond);
//
//    Exit;
//   end;
//  *circBuffInPtr := circBuffValue;
//  //printf("tube.c:2948 value in 'IN' position of circBiff is %f\n", *circBuffInPtr);
//  circBuffInPtr:= mod + 1;
//  //printf("tube.c:2947 circBuffValue is %f, circBuffInPtr %d, circBuffOutPtr %d, circBuffEnd %d\n",
//  //circBuffValue, circBuffInPtr, circBuffOutPtr, circBuffEnd);
//
//  circBuffFlag := OK;
//  pthread_mutex_unlock (@circBuffMutex);
//  pthread_cond_signal(@circBuffCond);
//
//  Exit;
 end;

function getCircBuff(): Single;
begin
  Result := 0.0;
//  Single circBuffValue;
//  //int cb1MutexState;
//  //printf("In getCircBuff tube.c:2943 In ptr is %d out is %d, circBuffEnd %d\n", circBuffInPtr, circBuffOutPtr, circBuffEnd);
////waitCB1:	while (circBuffFlag != FULL) pthread_cond_wait (&circBuffCond, &circBuffMutex);
////	if (circBuffFlag != FULL) goto waitCB1; //(circBuffInPtr == circBuffOutPtr) goto waitCB1;
////cb1MutexWait:	cb1MutexState = pthread_mutex_trylock (&circBuffMutex);
////	if (cb1MutexState != 0) goto cb1MutexWait;
//
//  pthread_mutex_lock (@circBuffMutex);
//  circBuffValue := *circBuffOutPtr;
//
//  if( circBuffOutPtr := circBuffEnd ) then  circBuffOutPtr = @circBuff[0];
//  else ++circBuffOutPtr;
//  circBuffFlag := OK;
//
//  pthread_mutex_unlock (@circBuffMutex);
//  pthread_cond_signal(@circBuffCond);
//
//
//  //printf("In getCircBuff tube.c:2954 circBufValue is %f\n", circBuffValue);
//  Result:=(circBuffValue);
 end;


procedure initCircBuff2;
begin
  circBuff2InPtr  := @ circBuff2[ 0];
  circBuff2OutPtr := @ circBuff2[ 0];
  circBuff2End    := @ circBuff2 [ CIRC_BUFF2_SIZE -1]; // [CIRC_BUFF2_SIZE - sizeof(float)];
  //printf("tube.c:3029 out, first and last pointers are: %d %d %d %d \n", circBuff2InPtr, circBuff2OutPtr, circ2Buff, circBuff2End);
  circBuff2Flag := EMPTY;
  Exit;
end;

function putCircBuff2( circBuff2Value: Single): Integer;
begin
  Result := error;
//  Integer error := 1;
//  if( circBuff2InPtr = circBuff2OutPtr - 1 ) then
//  begin                                                  //sizeof(float)) {
//    circBuff2Flag := FULL;
//    Result := error;
//    Exit;
//   end;
//
//  else
//  begin
//    //printf("tube.c:3039 entering putCircBuff2, flag is %d, value is %f In is %d\n", circBuff2Flag, circBuff2Value, circBuff2InPtr);
//    if( circBuff2InPtr = circBuff2End )            //&circBuff2[CIRC_BUFF2_SIZE - sizeof(double)]) then
//    begin
//      if( circBuff2OutPtr = @circBuff2[0] ) then
//      begin
//        circBuff2Flag := FULL;
//        Result := error;
//        Exit;
//       end;
//
//      *circBuff2InPtr := circBuff2Value;
//
//      circBuff2Count:= mod + 1;
//      //printf("tube.c:3133 circBuff2Count is %d\n", circBuff2Count);
//
//      //circBuff2InPtr++;
//      error := 0;
//
//      //printf("tube.c:3048 circBuff2Value is %f\n", circBuff2Value);
//
//      circBuff2InPtr := @circBuff2[0];
//
//      circBuff2Flag := OK;
//      Result:=error;
//      Exit
//     end;
//
//    *circBuff2InPtr := circBuff2Value;
//    circBuff2Flag := OK;
//    circBuff2Count:= mod + 1;
//    //printf("tube.c:3150 circBuff2Count is %d\n", circBuff2Count);
//
//    error := 0;
//    //printf("tube.c:3070 value in 'IN' position of circBuff is %f InPtr is %d\n", *circBuff2InPtr, circBuff2InPtr);
//
//    circBuff2InPtr:= mod + 1;
//    circBuff2Flag := OK;
//    Result:=error;
//    Exit;
//   end;
 end;

function getCircBuff2(): Single;
begin
  Result := 0.0;
//  Single circBuff2Value;
//
//
//  pthread_mutex_lock (@circBuff2Mutex);
//  waitCB2:  while( circBuff2Flag := EMPTY ) pthread_cond_wait (@circBuff2Cond, @circBuff2Mutex);  // if circBuff2 EMPTY, sleep & wait
//
//  if( circBuff2InPtr := circBuff2OutPtr ) then  goto waitCB2;
//  circBuff2Value := *circBuff2OutPtr;
//  circBuff2Count:= mod - 1;
//  if( circBuff2OutPtr := circBuff2End ) then  circBuff2OutPtr = @circBuff2[0];
//  else circBuff2OutPtr:= mod + 1;
//  if( circBuff2InPtr = circBuff2OutPtr ) then
//  begin
//    circBuff2Flag := EMPTY;
//    //goto waitCB2;
//   end;
//  else circBuff2Flag := OK;                          // else circBuff2Flag = OK;
//  //printf("In getCircBuff2 tube.c:3085 circBuff2OutPtr is %d circBuff2Value is %f\n", circBuff2OutPtr, circBuff2Value);
//
//
//  pthread_mutex_unlock (@circBuff2Mutex);
//  pthread_cond_signal(@circBuff2Cond);
//
//  //pthread_mutex_lock (&circBuffMutex);
//
//  if( circBuffFlag := FULL ) getCircBuff() then ;         // If circBuff is FULL, discard earliest sample to make room
//
//  putCircBuff(circBuff2Value);
//
//  //pthread_mutex_unlock (&circBuffMutex);
//  //pthread_cond_signal(&circBuffCond);
//
//  Result:=(circBuff2Value);
//
 end;



end.

