unit FrmScala;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics, Vcl.Controls,
  Vcl.Forms, Vcl.Dialogs, Vcl.FileCtrl, Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.Buttons;


const

  ScalaKbmExtMask = '*.kbm';
  ScalaSclExtMask = '*.scl';

type

  TScalaFileType = (
    ftKBM,
    ftSCL
  );


  TFormScala = class(TForm)
    PanelTop: TPanel;
    PanelTopLeft: TPanel;
    DriveComboBox: TDriveComboBox;
    DirectoryListBox: TDirectoryListBox;
    PanelTopRight: TPanel;
    FileListBox: TFileListBox;
    PanelBottom: TPanel;
    PanelBottomLeft: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    EditMask: TEdit;
    PanelBottomRight: TPanel;
    MemoInfo: TMemo;
    EditFileName: TEdit;
    Splitter1: TSplitter;
    procedure FileListBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditMaskChange(Sender: TObject);
  private
    FFileType   : TScalaFileType;
    FMask       : string;
    FFileName   : string;
    FInitialDir : string;
  private
    procedure   SetFileType( const aValue: TScalaFileType);
    procedure   SetMask( const aValue: string);
    procedure   SetFileName( const aValue: string);
    procedure   SetInitialDir( const aValue: string);
  private
    procedure   ReadKbmPreview;
    procedure   ReadSclPreview;
    procedure   ReadPreview;
  private
    property    FileType : TScalaFileType read FFileType write SetFileType;
    property    Mask     : string         read FMask     write SetMask;
  public
    function    Execute( aFileTpe: TScalaFileType): Boolean;
  public
    property    FileName   : string read FFileName   write SetFileName;
    property    InitialDir : string read FInitialDir write SetInitialDir;
  end;

var

  FormScala: TFormScala;



implementation

// User area


    procedure   TFormScala.SetFileType( const aValue: TScalaFileType);
    begin
      FFileType := aValue;

      case FileType of
        ftKBM : begin Mask := ScalaKbmExtMask; Caption := 'Open a Scala keyboard mapping' end;
        else    begin Mask := ScalaSclExtMask; Caption := 'Open a Scala scale file'       end;
      end;
    end;


    procedure   TFormScala.SetMask( const aValue: string);
    begin
      if aValue <> FMask
      then begin
        FMask            := aValue;
        FileListBox.Mask := aValue;
        EditMAsk   .Text := aValue;
      end;
    end;


    procedure   TFormScala.SetFileName( const aValue: string);
    begin
      if aValue <> FFileName
      then begin
        FFileName             := aValue;
        FileListBox .FileName := aValue;
        EditFileName.Text     := aValue;
        ReadPreview;
      end;
    end;


    procedure   TFormScala.SetInitialDir( const aValue: string);
    begin
      if aValue <> FInitialDir
      then begin
        FInitialDir                := aValue;
        DirectoryListBox.Directory := aValue;
      end;
    end;


//  private

    procedure   TFormScala.ReadKbmPreview;
    var
      aLines : TStringList;
      i      : Integer;
    begin
      if FileExists( FileName)
      then begin
        aLines := TStringList.Create;
        try
          aLines.LoadFromFile( FileName);
          MemoInfo.Clear;
          for i := 0 to aLines.Count - 1
          do MemoInfo.Lines.Add( aLines[ i]);
        finally
          aLines.DisposeOf;
        end;
      end;
    end;


    procedure   TFormScala.ReadSclPreview;
    var
      aLines : TStringList;
      i      : Integer;
    begin
      if FileExists( FileName)
      then begin
        aLines := TStringList.Create;
        try
          aLines.LoadFromFile( FileName);
          MemoInfo.Clear;
          for i := 0 to aLines.Count - 1
          do MemoInfo.Lines.Add( aLines[ i]);
        finally
          aLines.DisposeOf;
        end;
      end;
    end;


    procedure   TFormScala.ReadPreview;
    begin
      MemoInfo.Clear;

      if FFileType = ftKBM
      then ReadKbmPreview
      else ReadSclPreview;

      MemoInfo.SelStart := 0;
      MemoInfo.SelLength := 0;
      MemoInfo.Perform( EM_SCROLLCARET, 0, 0);
    end;


//  public



    function    TFormScala.Execute( aFileTpe: TScalaFileType): Boolean;
    begin
      FileType := aFileTpe;
      Result   := ShowModal = mrOk;
    end;




// Delphi area

{$R *.dfm}

procedure TFormScala.FileListBoxChange(Sender: TObject);
begin
  FileName := FileListBox.FileName;
end;


procedure TFormScala.EditMaskChange(Sender: TObject);
begin
  Mask := EditMask.Text;
end;


procedure TFormScala.FormCreate(Sender: TObject);
begin
  MemoInfo.Clear;
end;

end.

