unit Knobs2013_design;

interface

uses

  System.Classes, KnobsConversions,

  // NOTE: When Delphi complains about DesignIntf and DesignEditors ...
  // add -LUDesignIDE to Program Options (Alt P / O) Delphi Compiler / Compiling / Additional options to pass to the
  // compiler. These units are used to add a property selector for the ControlType property on knobs, see
  // TKnobsConverterProperty


  DesignIntf, DesignEditors;

  procedure Register;

implementation

uses

  knobs2013, KnobsWorms;

type

  TKnobsConverterProperty = class( TStringProperty)
  // Property value selector for ControlType property of Knobs
  public
    function    GetAttributes: TPropertyAttributes;                   override;
    procedure   GetValues( Proc: TGetStrProc);                        override;
  end;


{ ========
  TKnobsConverterEditor = class( TStringProperty)
  // Property value selector for ControlType property of Knobs
  public
}

    function    TKnobsConverterProperty.GetAttributes: TPropertyAttributes; // override;
    begin
      Result := inherited + [ paValueList, paSortList];
    end;

    procedure   TKnobsConverterProperty.GetValues( Proc: TGetStrProc); // override;
    var
      i : Integer;
    begin
      with Converters
      do begin
        for i := 0 to Count - 1
        do Proc( Strings[ i]);
      end;
    end;





  procedure Register;
  begin
    RegisterComponents(
      'Knobs2013',
      [
        TKnobsData              , TKnobsLed               , TKnobsSelector          , TKnobsKnob              ,
        TKnobsSmallKnob         , TKnobsNoKnob            , TKnobsSlider            , TKnobsHSlider           ,
        TKnobsPad               , TKnobsValuedButton      , TKnobsValuedButtons     , TKnobsDisplay           ,
        TKnobsFileSelector      , TKnobsIndicator         , TKnobsIndicatorBar      , TKnobsIndicatorText     ,
        TKnobsDataViewer        , TKnobsInput             , TKnobsOutput            , TKnobsTextLabel         ,
        TKnobsEditLabel         , TKnobsBox               , TKnobsWirePanel         , TKnobsModule            ,
        TKnobsModuleSelector    , TKnobsWorm              , TKnobsWormPanel         , TKnobsDataMaker         ,
        TKnobsGridControl       , TKnobsAutomationGrid    , TKnobsTimerSpeedButton  , TKnobsDelayedSpeedButton,
        TKnobsMazeGraphViewer   , TKnobsSelectorChoice    , TKnobsLightningViewer
      ]
    );
    RegisterPropertyEditor( TypeInfo( string), TKnobsValuedControl, 'ControlType', TKnobsConverterProperty);
    RegisterPropertyEditor( TypeInfo( string), TKnobsXYControl    , 'ControlType', TKnobsConverterProperty);
  end;



end.

