#!/usr/bin/env python

from nord.types import Struct

class ParameterMap(Struct): pass
class ParameterDef(Struct): pass

params = [
  ParameterDef(name='Dst_2',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Out, 1 ~ Fx, 2 ~ Bus'],
    comments=''
  ),
  ParameterDef(name='OffOn',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Off, 1 ~ On'],
    comments=''
  ),
  ParameterDef(name='Pad_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ 0 dB, 1 ~ +6 dB'],
    comments=''
  ),
  ParameterDef(name='Dst_1',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Out 1/2, 1 ~ Out 3/4, 2 ~ Fx 1/2, 3 ~ Fx 3/4, 4 ~ Bus 1/2, 5 ~ Bus 3/4'],
    comments=''
  ),
  ParameterDef(name='FreqCoarse',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ C-1, 64 ~ E4, 127 ~ G9', '0 ~ -64, 64 ~ 0, 127 ~ +63', '0 ~ 8.1756 Hz, 64 ~ 329.63 Hz, 127 ~ 12.55 kHz', '0 ~ x0.0248, 64 ~ x1.0000, 127 ~ x38.055', '0 ~ 0 Hz, 64 ~ 1:1, 127 ~ 64:1'],
    comments='Modes : Note, Semi, Freq, Fac and Part'
  ),
  ParameterDef(name='FreqFine',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ -50.0, 64 ~ +0.0, 127 ~ +49.2'],
    comments='In cents'
  ),
  ParameterDef(name='Level_100',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0, 64 ~ 50, 127 ~ 100'],
    comments='Can be used to denote a =not necessarily linear) 0 .. 100 range or a percentage'
  ),
  ParameterDef(name='FreqMode_3',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Semi, 1 ~ Freq, 2 ~ Fac, 3 ~ Part'],
    comments=''
  ),
  ParameterDef(name='PW',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 50%, 127 ~ 99%'],
    comments=''
  ),
  ParameterDef(name='OscBWaveform',
    low=0,
    high=4,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Pulse, 4 ~ DualSaw'],
    comments=''
  ),
  ParameterDef(name='FmLinTrk',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Lin, 1 ~ Trk'],
    comments=''
  ),
  ParameterDef(name='OscWaveform_3',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ Sine1, 1 ~ Sine2, 2 ~ Sine3, 4 ~ TriSaw, 5 ~ DoubleSaw, 6 ~ Pulse, 7 ~ SymPuls'],
    comments=''
  ),
  ParameterDef(name='OscWaveform_2',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Square, 4 ~ Pulse 25%, 5 ~ Pulse 10%'],
    comments=''
  ),
  ParameterDef(name='ReverbTime',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.0ms, 127 ~ 3.000s', '0 ~ 0.0ms, 127 ~ 6.000s', '0 ~ 0.0ms, 127 ~ 9.000s', '0 ~ 0.0ms, 127 ~ 12.00s'],
    comments='Small, Medium, Large, Hall. Determined by [RoomType]'
  ),
  ParameterDef(name='RoomType',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Small, 1 ~ Medium, 2 ~ Large, 3 ~ Hall'],
    comments='Determines ranges for [ReverbTime]'
  ),
  ParameterDef(name='sw_3',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ sw1, 1 ~ sw2, 2 ~ sw3, 3 ~ sw4, 4 ~ sw5, 5 ~ sw6, 6 ~ sw7, 7 ~ sw8'],
    comments=''
  ),
  ParameterDef(name='ValSwVal',
    low=0,
    high=63,
    default=0,
    definitions=['0 ~ 0, 62 ~ 62, 63 ~ 64'],
    comments=''
  ),
  ParameterDef(name='Bipolar_127',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ -64, 64 ~ 0, 127 ~ 64'],
    comments='not necesarraly a linear control'
  ),
  ParameterDef(name='LogLin',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Log, 1 ~ Lin'],
    comments=''
  ),
  ParameterDef(name='MixLevel',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0, 64 ~ 50, 127 ~ 100', '0 ~ 0, 64 ~ 50, 127 ~ 100', '0 ~ -{00}, 64 ~ -17.6, 127 ~ -0'],
    comments='Lin, Exp, dB'
  ),
  ParameterDef(name='ExpLin_2',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Exp, 1 ~ Lin, 2 ~ dB'],
    comments=''
  ),
  ParameterDef(name='EnvShape_3',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ LogExp, 1 ~ LinExp, 2 ~ ExpExp, 3 ~ LinLin'],
    comments=''
  ),
  ParameterDef(name='EnvTime',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.5m, 127 ~ 45.0s'],
    comments=''
  ),
  ParameterDef(name='EnvLevel',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.0, 126 ~ 63.0, 127 ~ 64.0'],
    comments=''
  ),
  ParameterDef(name='PosNegInvBipInv',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Pos, 1 ~ PosInv, 2 ~ Neg, 3 ~ NegInv, 4 ~ Bip, 5 ~ BipInv'],
    comments=''
  ),
  ParameterDef(name='EnvNR',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Normal, 1 ~ Reset'],
    comments=''
  ),
  ParameterDef(name='PartialRange',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ {+-}0, 1 ~ {+-}0, ..., 64 ~ {+-}32, 65 ~ {+-}32*, ... , 126 ~ {+-}63*, 126 ~ {+-}63*'],
    comments='* clipped at {+-}32 and the lowest bit is not effective'
  ),
  ParameterDef(name='LfoRate_3',
    low=0,
    high=127,
    default=1,
    definitions=['0 ~ 699s, 127 ~ 5.46s', '1 ~ 62.9s, 127 ~ 24.4 Hz', '2 ~ 0.26 Hz, 127 ~ 392 Hz', '3 ~ 24, 127 ~ 214'],
    comments='Sub, Lo, Hi, BPM =BPM is the same as for RateBpm). Determined by [LfoRange_3]'
  ),
  ParameterDef(name='PolyMono',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Poly, 1 ~ Mono'],
    comments=''
  ),
  ParameterDef(name='OutTypeLfo',
    low=0,
    high=5,
    default=4,
    definitions=['0 ~ Pos, 1 ~ PosInv, 2 ~ Neg, 3 ~ NegInv, 4 ~ Bip, 5 ~ BipInv'],
    comments=''
  ),
  ParameterDef(name='LfoRange_3',
    low=0,
    high=3,
    default=1,
    definitions=['0 ~ Rate Sub, 1 ~ Rate Lo, 2 ~ Rate Hi, 3 ~ BPM'],
    comments='Determines [LfoRate_3]'
  ),
  ParameterDef(name='LfoWaveform_1',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Square, 4 ~ RndStep, 5 ~ Rnd, 6 ~ RndPulse, 7 ~ RndRoundedPulse'],
    comments=''
  ),
  ParameterDef(name='LfoRate_4',
    low=0,
    high=127,
    default=1,
    definitions=['0 ~ 699s, 127 ~ 5.46s', '1 ~ 62.9s, 127 ~ 24.4 Hz', '2 ~ 0.26 Hz, 127 ~ 392 Hz', '3 ~ 24, 127 ~ 214', '4 ~ 64/1, 64 ~ 1/4D, 127 ~ 1/64T'],
    comments='Sub, Lo, Hi, BPM, Clock =BPM is the same as for RateBpm). Determined by [LfoRange_4]'
  ),
  ParameterDef(name='LfoRange_4',
    low=0,
    high=4,
    default=0,
    definitions=['0 ~ Rate Sub, 1 ~ Rate Lo, 2 ~ Rate Hi, 3 ~ BPM, 4 ~ Clock'],
    comments='Determines [LfoRate_4]'
  ),
  ParameterDef(name='Kbt_1',
    low=0,
    high=4,
    default=1,
    definitions=['0 ~ Off, 1 ~ On'],
    comments=''
  ),
  ParameterDef(name='Kbt_4',
    low=0,
    high=4,
    default=0,
    definitions=['0 ~ Off, 1 ~ 25%, 2 ~ 50%, 3 ~ 75%, 4 ~ 100%'],
    comments=''
  ),
  ParameterDef(name='LfoShpAPW',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 1%, 64 ~ 50%, 127 ~ 98%'],
    comments=''
  ),
  ParameterDef(name='Phase',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0, 64 ~ 180, 127 ~ 357'],
    comments='In degrees, 360 degrees in a full circle'
  ),
  ParameterDef(name='LfoShpA__Waveform',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Sine, 1 ~ CosBell, 2 ~ TriBell, 3 ~ Saw2Tri, 4 ~ Sqr2Tri, 5 ~ Sqr'],
    comments=''
  ),
  ParameterDef(name='LfoA_Waveform',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Aqr, 4 ~ RndStep, 5 ~ Rnd'],
    comments=''
  ),
  ParameterDef(name='FreqMode_2',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Semi, 1 ~ Freq, 2 ~ Fac'],
    comments=''
  ),
  ParameterDef(name='SaturateCurve',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ 1, 1 ~ 2, 2 ~ 3, 3 ~ 4'],
    comments=''
  ),
  ParameterDef(name='NoiseColor',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0 =White), 64 ~ 50, 127 ~ 100 =Colored)'],
    comments=''
  ),
  ParameterDef(name='EqdB',
    low=64,
    high=127,
    default=0,
    definitions=['0 ~ -18.0 dB, 64 ~ 0.0 dB, 127 ~ 18.0 dB'],
    comments=''
  ),
  ParameterDef(name='EqLoFreq',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ 80 Hz, 1 ~ 110 Hz, 2 ~ 160 Hz'],
    comments=''
  ),
  ParameterDef(name='EqHiFreq',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ 6 kHz, 1 ~ 8 kHz, 2 ~ 12 kHz'],
    comments=''
  ),
  ParameterDef(name='EqMidFreq',
    low=0,
    high=127,
    default=93,
    definitions=['0 ~ 100 Hz, 64 ~ 910 Hz, 93 ~ 2.48 kHz, 127 ~ 8.00 kHz'],
    comments=''
  ),
  ParameterDef(name='ShpExpCurve',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ x2, 1 ~ x3, 2 ~ x4, 3 ~ x5'],
    comments=''
  ),
  ParameterDef(name='LogicTime',
    low=0,
    high=127,
    default=1,
    definitions=['0 ~ 0.10m, 127 ~ 1.00s', '0 ~ 1.04m, 127 ~ 10.0s', '0 ~ 10.4m, 127 ~ 100.0s'],
    comments='Sub, Lo, Hi. Determined by [LogicRange]'
  ),
  ParameterDef(name='LogicRange',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Sub, 1 ~ Lo, 2 ~ Hi'],
    comments='Determines [LogicTime]'
  ),
  ParameterDef(name='PulseMode',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Positive edge trigger, 1 ~ Negative edge trigger'],
    comments=''
  ),
  ParameterDef(name='Pad_3',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ 0 dB, 1 ~ -6 dB, 2 ~ -12 dB'],
    comments=''
  ),
  ParameterDef(name='PosNegInv',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Pos, 1 ~ PosInv, 2 ~ Neg, 3 ~ NegInv'],
    comments=''
  ),
  ParameterDef(name='LogicDelayMode',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Positive edge delay, 1 ~ Negative edge delay, 2 ~ Cycle delay'],
    comments=''
  ),
  ParameterDef(name='LevBipUni',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ -64, 64 ~ 0, 127 ~ 64', '0 ~ 0, 64 ~ 50, 127 ~ 100'],
    comments='Bip, Uni. Determined by [BipUni] setting'
  ),
  ParameterDef(name='BipUni',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Bip, 1 ~ Uni'],
    comments='Determines display for [LevBipUni]'
  ),
  ParameterDef(name='Vowel',
    low=0,
    high=8,
    default=0,
    definitions=['0 ~ A, 1 ~ E, 2 ~ I, 3 ~ O, 4 ~ U, 5 ~ Y, 6 ~ AA, 7 ~ AE, 8 ~ OE'],
    comments=''
  ),
  ParameterDef(name='FltFreq',
    low=0,
    high=127,
    default=75,
    definitions=['0 ~ 13.75 Hz, 64 ~ 554.4Hz, 75 ~ 1.05 kHz, 127 ~ 21.1 kHz'],
    comments=''
  ),
  ParameterDef(name='Level_200',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0, 64 ~ 100, 127 ~ 200'],
    comments='Percentage'
  ),
  ParameterDef(name='GcOffOn',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ GC Off, 1 ~ GC On'],
    comments=''
  ),
  ParameterDef(name='Res_1',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.50, 64 ~ 1.67, 127 ~ 50'],
    comments=''
  ),
  ParameterDef(name='FltSlope_1',
    low=0,
    high=1,
    default=1,
    definitions=['0 ~ 6 dB/Oct, 1 ~ 12 dB/Oct'],
    comments=''
  ),
  ParameterDef(name='FltSlope_2',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ 12 dB/Oct, 1 ~ 24 dB/Oct'],
    comments=''
  ),
  ParameterDef(name='LpBpHpBr',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ LP, 1 ~ BP, 2 ~ HP, 3 ~ BR'],
    comments=''
  ),
  ParameterDef(name='SustainMode_2',
    low=0,
    high=3,
    default=2,
    definitions=['0 ~ L1, 1 ~ L2, 2 ~ L3, 3 ~ Trg'],
    comments=''
  ),
  ParameterDef(name='PosNegInvBip',
    low=0,
    high=4,
    default=0,
    definitions=['0 ~ Pos, 1 ~ PosInv, 2 ~ Neg, 3 ~ NegInv, 4 ~ Bip'],
    comments=''
  ),
  ParameterDef(name='LpBpHp',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ LP, 1 ~ BP, 2 ~ HP'],
    comments=''
  ),
  ParameterDef(name='MidiData',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~0, 127 ~ 127'],
    comments='One to one mapping with MIDI data values'
  ),
  ParameterDef(name='MidiCh_20',
    low=0,
    high=20,
    default=0,
    definitions=['0 ~ ch1, 1 ~ ch 2, 2 ~ ch3, 3 ~ ch4, 4 ~ ch5, 5 ~ ch6, 6 ~ ch7, 7 ~ ch8, 8 ~ ch9, 9 ~ ch10, 10 ~ ch11, 11 ~ ch12, 12 ~ ch13, 13 ~ ch14, 14 ~ ch15, 15 ~ ch16, 16 ~ This, 17 ~ Slot A, 18 ~ Slot B, 19 ~ Slot C, 20 ~ Slot D'],
    comments=''
  ),
  ParameterDef(name='DrumSynthFreq',
    low=0,
    high=127,
    default=42,
    definitions=['0 ~ 20 Hz, 64 ~ 127 Hz, 127 ~ 784 Hz'],
    comments=''
  ),
  ParameterDef(name='DrumSynthRatio',
    low=0,
    high=127,
    default=15,
    definitions=['0 ~ 1:1, 64 ~ x2.52, 127 ~ x6.26'],
    comments=''
  ),
  ParameterDef(name='DrumSynthNoiseFlt',
    low=0,
    high=127,
    default=57,
    definitions=['0 ~ 10.30 Hz, 64 ~ 415.3 Hz, 127 ~ 15.8 kHz'],
    comments=''
  ),
  ParameterDef(name='ClipShape',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Asym, 1 ~ Sym'],
    comments=''
  ),
  ParameterDef(name='OverdriveType',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Soft, 1 ~ Hard, 2 ~ Fat, 3 ~ Heavy'],
    comments=''
  ),
  ParameterDef(name='ScratchRatio',
    low=0,
    high=127,
    default=80,
    definitions=['0 ~ -x4.00, 64 ~ x0, 80 ~ x1.00, 127 ~ x4.00'],
    comments='negative speeds mean backwards playing'
  ),
  ParameterDef(name='ScratchDelay',
    low=0,
    high=3,
    default=2,
    definitions=['0 ~ 12.5m, 1 ~ 25m, 2 ~ 50m, 3 ~ 100m'],
    comments='mili seconds'
  ),
  ParameterDef(name='GateMode',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ AND, 1 ~ NAND, 2 ~ OR, 3 ~ NOR, 4 ~ XOR, 5 ~ XNOR'],
    comments=''
  ),
  ParameterDef(name='MixInvert',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Normal, 1 ~ Inverted'],
    comments=''
  ),
  ParameterDef(name='RateBpm',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 24 BPM, 64 ~ 120 BPM, 127 ~ 214 BPM'],
    comments=''
  ),
  ParameterDef(name='InternalMaster',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Internal, 1 ~ Master'],
    comments=''
  ),
  ParameterDef(name='ClkGenBeatSync',
    low=0,
    high=5,
    default=2,
    definitions=['0 ~ 1, 1 ~ 2, 2 ~ 4, 3 ~ 8, 4 ~ 16, 5 ~ 32'],
    comments=''
  ),
  ParameterDef(name='ClkGenSwing',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 50.0%, 64 ~ 62.6%, 127 ~ 75.0%'],
    comments=''
  ),
  ParameterDef(name='Range_128',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 1, 127 ~ 128'],
    comments='Mapping of origin zero to origin one'
  ),
  ParameterDef(name='ClkDivMode',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Gated, 1 ~ Toggled'],
    comments='Gated mode follows input clock''s positive pulse width'
  ),
  ParameterDef(name='EnvFollowAttack',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ Fast, 1 ~ 0.53m, 64 ~ 23.0m, 127 ~ 1.00s'],
    comments=''
  ),
  ParameterDef(name='EnvFollowRelease',
    low=0,
    high=127,
    default=20,
    definitions=['0 ~ 10.0m, 20 ~ 24.6m, 64 ~ 177m, 127 ~ 3.00s'],
    comments=''
  ),
  ParameterDef(name='NoteRange',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ {+-}0, 1 ~ {+-}0.5, 64 ~ {+-}32, 126 ~ {+-}63.0, 127 ~ {+-}64.0'],
    comments=''
  ),
  ParameterDef(name='NoteQuantNotes',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ Off, 1 ~ 1, 127 ~ 127'],
    comments=''
  ),
  ParameterDef(name='sw_2',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ sw1, 1 ~ sw2, 2 ~ sw3, 3 ~ sw4'],
    comments=''
  ),
  ParameterDef(name='LevAmpGain',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ x0.00, 64 ~ x1.00, 127 ~ x4.00'],
    comments=''
  ),
  ParameterDef(name='LinDB',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Lin, 1 ~ dB'],
    comments=''
  ),
  ParameterDef(name='RectMode',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Half wave positive, 1 ~ Half wave negative, 2 ~ Full wave positive, 3 ~ Full wave negative'],
    comments=''
  ),
  ParameterDef(name='ShpStaticMode',
    low=0,
    high=3,
    default=1,
    definitions=['0 ~ Inv x3, 1 ~ Inv x2, 2 ~ x2, 3 ~ x3'],
    comments=''
  ),
  ParameterDef(name='TrigGate',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Trig, 1 ~ Gate'],
    comments=''
  ),
  ParameterDef(name='AdAr',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ AD, 1 ~ AR'],
    comments='Selects between Decay and Release modes'
  ),
  ParameterDef(name='Range_64',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.0, 1 ~ 0.5, 64 ~ 32.0, 126 ~ 63.0, 127 ~ 64.0'],
    comments=''
  ),
  ParameterDef(name='HpLpSlopeMode',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ 6dB/Oct, 1 ~ 12 dB/Oct, 2 ~ 18 dB/Oct, 3 ~ 24 dB/Oct, 4 ~ 30 dB/Oct, 5 ~ 36 dB/Oct'],
    comments=''
  ),
  ParameterDef(name='FlangerRate',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 0.01 Hz, 64 ~ 1.46 Hz, 127 ~ 2.91 Hz'],
    comments=''
  ),
  ParameterDef(name='Sw_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ sw1, 1 ~ sw2'],
    comments=''
  ),
  ParameterDef(name='FlipFlopMode',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ D type, 1 ~ SR type'],
    comments=''
  ),
  ParameterDef(name='ClassicSlope',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ 12 dB/Oct, 1 ~ 18 dB/Oct, 2 ~ 24 dB/Oct'],
    comments=''
  ),
  ParameterDef(name='OscA_Waveform',
    low=0,
    high=5,
    default=2,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Square, 4 ~ Pulse 25%, 5 ~ Pulse 10%'],
    comments=''
  ),
  ParameterDef(name='FreqShiftFreq',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.000 Hz, 64 ~ 1.12 Hz, 127 ~ 8.78 Hz', '0 ~ 0.000 Hz, 64 ~ 12.5 Hz, 127 ~ 97.6 Hz', '0 ~ 0.000 Hz, 64 ~ 201 Hz, 127 ~ 1568 Hz'],
    comments='Sub, Lo, Hi. Determined by [FreqShiftRange]'
  ),
  ParameterDef(name='FreqShiftRange',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Sub, 1 ~ Lo, 2 ~ Hi'],
    comments='Determines [FreqShiftFreq] range'
  ),
  ParameterDef(name='Freq_2',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 100.0 Hz, 64 ~ 1.29 kHz, 127 ~ 16.0 kHz'],
    comments=''
  ),
  ParameterDef(name='FltPhaseNotchCount',
    low=0,
    high=5,
    default=2,
    definitions=['0 ~ 1, 1 ~ 2, 2 ~ 3, 3 ~ 4, 4 ~ 5, 5 ~ 6'],
    comments=''
  ),
  ParameterDef(name='FltPhaseType',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Notch, 1 ~ Peak, 2 ~ Deep'],
    comments=''
  ),
  ParameterDef(name='Freq_3',
    low=0,
    high=127,
    default=60,
    definitions=['0 ~20.00 Hz , 60 ~ 470.5 Hz, 64 ~ 580.8 Hz, 127 ~ 16.0 kHz'],
    comments=''
  ),
  ParameterDef(name='EqPeakBandwidth',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 2.00 Oct, 64 ~ 1.00 Oct, 127 ~ 0.02 Oct'],
    comments=''
  ),
  ParameterDef(name='VocoderBand',
    low=0,
    high=16,
    default=0,
    definitions=['0 ~ Off, 1 ~ 1, 2 ~ 2, 3 ~ 3, 4 ~ 4, 5 ~ 5, 6 ~ 6, 7 ~ 7, 8 ~ 8, 9 ~ 9, 10 ~ 10, 11 ~ 11, 12 ~ 12, 13 ~ 13, 14 ~ 14, 15 ~ 15, 16 ~ 16'],
    comments=''
  ),
  ParameterDef(name='ActiveMonitor',
    low=0,
    high=1,
    default=1,
    definitions=['0 ~ Monitor,1 ~ Active '],
    comments=''
  ),
  ParameterDef(name='Fade12Mix',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ O1:127, 64 ~ Mute, 127 ~ O2:127'],
    comments=''
  ),
  ParameterDef(name='Fade21Mix',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ I1:127, 64 ~ Mute, 127 ~ I2:127'],
    comments=''
  ),
  ParameterDef(name='LevScaledB',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ -8.0 dB, 64 ~ 0.0 dB, 127 ~ 8.0 dB'],
    comments=''
  ),
  ParameterDef(name='LevModAmRm',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ None, 64 ~ AM, 127 ~ RM'],
    comments=''
  ),
  ParameterDef(name='DigitizerBits',
    low=0,
    high=12,
    default=11,
    definitions=['0 ~ 1, 1 ~ 2, 2 ~ 3, 3 ~ 4, 4 ~ 5, 5 ~ 6, 6 ~ 7, 7 ~ 8, 8 ~ 9, 9 ~ 10, 10 ~ 11, 11 ~ 12, 12 ~ Off'],
    comments=''
  ),
  ParameterDef(name='DigitizerRate',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 32.70 Hz, 64 ~ 1.32 kHz, 127 ~ 50.2 kHz'],
    comments=''
  ),
  ParameterDef(name='SustainMode_1',
    low=0,
    high=1,
    default=1,
    definitions=['0 ~ L1, 1 ~ L2'],
    comments=''
  ),
  ParameterDef(name='LoopOnce',
    low=0,
    high=1,
    default=1,
    definitions=['0 ~ Once, 1 ~ Loop'],
    comments=''
  ),
  ParameterDef(name='SeqLen',
    low=0,
    high=15,
    default=0,
    definitions=['0 ~ 1, 1 ~ 2, 2 ~ 3, 3 ~ 4, 4 ~ 5, 5 ~ 6, 6 ~ 7, 7 ~ 8, 8 ~ 9, 9 ~ 10, 10 ~ 11, 11 ~ 12, 12 ~ 13, 13 ~ 14, 14 ~ 15, 15 ~ 16'],
    comments=''
  ),
  ParameterDef(name='Pad_2',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ 0 dB, 1 ~ -6 dB'],
    comments=''
  ),
  ParameterDef(name='Source_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ FX 1/2, 1 ~ FX 3/4'],
    comments=''
  ),
  ParameterDef(name='Pad_4',
    low=0,
    high=3,
    default=1,
    definitions=['0 ~ -12 dB, 1 ~ -6 dB, 2 ~ 0 dB,3 ~ +6 dB'],
    comments=''
  ),
  ParameterDef(name='MidiCh_16',
    low=0,
    high=16,
    default=0,
    definitions=['0 ~ ch1, 1 ~ ch 2, 2 ~ ch3, 3 ~ ch4, 4 ~ ch5, 5 ~ ch6, 6 ~ ch7, 7 ~ ch8, 8 ~ ch9, 9 ~ ch10, 10 ~ ch11, 11 ~ ch12, 12 ~ ch13, 13 ~ ch14, 14 ~ ch15, 15 ~ ch16, 16 ~ This'],
    comments=''
  ),
  ParameterDef(name='MidiCh_17',
    low=0,
    high=17,
    default=0,
    definitions=['0 ~ ch1, 1 ~ ch 2, 2 ~ ch3, 3 ~ ch4, 4 ~ ch5, 5 ~ ch6, 6 ~ ch7, 7 ~ ch8, 8 ~ ch9, 9 ~ ch10, 10 ~ ch11, 11 ~ ch12, 12 ~ ch13, 13 ~ ch14, 14 ~ ch15, 15 ~ ch16, 16 ~ This, 17 ~ keyb'],
    comments=''
  ),
  ParameterDef(name='NoteZoneThru',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Notes Only, 1 ~ Note+Ctrls'],
    comments=''
  ),
  ParameterDef(name='Treshold_42',
    low=0,
    high=42,
    default=18,
    definitions=['0 ~ -30 dB, 18 ~ -12 dB, 42 ~ Off'],
    comments=''
  ),
  ParameterDef(name='CompressorRatio',
    low=0,
    high=66,
    default=20,
    definitions=['0 ~ 1.0:1, 20 ~ 4.0:1, 66 ~ 80:1'],
    comments=''
  ),
  ParameterDef(name='CompressorAttack',
    low=0,
    high=127,
    default=1,
    definitions=['0 ~ Fast, 1 ~ 0.53 m, 64 ~ 20.2 m, 127 ~ 767 m'],
    comments=''
  ),
  ParameterDef(name='CompressorRelease',
    low=0,
    high=127,
    default=20,
    definitions=['0 ~ 125 m, 20 ~ 250 m, 64 ~ 1.15 s, 127 ~ 10.2 s'],
    comments=''
  ),
  ParameterDef(name='CompressorRefLevel',
    low=0,
    high=42,
    default=30,
    definitions=['0 ~ -30 dB, 30 ~ 0 dB, 42 ~ 12 dB'],
    comments=''
  ),
  ParameterDef(name='KeyQuantCapture',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Closest, 1 ~ Evenly'],
    comments=''
  ),
  ParameterDef(name='SeqCtrlXFade',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Off, 1 ~ 25%, 2 ~ 50%, 3 ~ 100%'],
    comments=''
  ),
  ParameterDef(name='BipPosNeg',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Bip, 1 ~ Pos, 2 ~ Neg'],
    comments=''
  ),
  ParameterDef(name='GlideTime',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 0.2 m, 64 ~ 511 m, 127 ~ 22.4s', '0 ~ 0.2 ms/Oct, 64 ~ 480 ms/Oct, 127 ~ 23.5 s/Oct'],
    comments='Log, Lin. Determined by the Shape parameter =[LogLin])'
  ),
  ParameterDef(name='Freq_1',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 8.1758 Hz, 64 ~ 329.63 Hz, 127 ~ 12.55 kHz'],
    comments=''
  ),
  ParameterDef(name='CombType',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Notch, 1 ~ Peak, 2 ~ Deep'],
    comments=''
  ),
  ParameterDef(name='OscShpA_Waveform',
    low=0,
    high=5,
    default=0,
    definitions=['0 ~ Sine1, 1 ~ Sine2, 2 ~ Sine3, 3 ~ Sine4, 4 ~ TriSaw, 5 ~ SymPulse'],
    comments=''
  ),
  ParameterDef(name='DxAlgorithm',
    low=0,
    high=31,
    default=0,
    definitions=['0 ~ 1, 31 ~ 32'],
    comments=''
  ),
  ParameterDef(name='DxFeedback',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ 0, 1 ~ 1, 2 ~ 2, 3 ~ 3, 4 ~ 4, 5 ~ 5, 6 ~ 6, 7 ~ 7'],
    comments=''
  ),
  ParameterDef(name='PShiftCoarse',
    low=0,
    high=127,
    default=64,
    definitions=['1 ~ -16.0, 64 ~ +0.0, 127 ~ +15.8'],
    comments='Semitones'
  ),
  ParameterDef(name='PShiftFine',
    low=0,
    high=127,
    default=64,
    definitions=['1 ~ -50, 64 ~ +0, 127 ~ +49.2'],
    comments='Cents ?'
  ),
  ParameterDef(name='Source_2',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ In 1/2, 1 ~ In 3/4, 2 ~ Bus 1/2, 3 ~ Bus 3/4'],
    comments=''
  ),
  ParameterDef(name='Source_3',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ In, 1 ~ Bus'],
    comments=''
  ),
  ParameterDef(name='DelayTime_3',
    low=0,
    high=127,
    default=0,
    definitions=
    [
    '0 ~ 0.01 m, 64 ~ 2.68 m, 127 ~ 5.30 m',
    '0 ~ 0.01 m, 64 ~ 12.7 m, 127 ~ 25.1 m',
    '0 ~ 0.01 m, 64 ~ 50.7 m, 127 ~ 101 m',
    '0 ~ 0.01 m, 64 ~ 252 m, 127 ~ 500 m',
    '0 ~ 0.01 m, 64 ~ 504 m, 127 ~ 1.000 s',
    '0 ~ 0.01 m, 64 ~ 1.008 s, 127 ~ 2.000 s',
    '0 ~ 0.01 m, 64 ~ 1.361 s, 127 ~ 2.700 s',
    '0 ~ 1/64 T, 64 ~ 1/4 T, 127 ~ 2/1',
    ]
    ,
    comments='Time=5ms, 25ms, 100ms, 500ms, 1.0s, 2.0s, 2.7s), Clk. Determined by [DelayRange_3] and [TimeClk] =if present)'
  ),
  ParameterDef(name='DelayRange_3',
    low=0,
    high=6,
    default=0,
    definitions=['0 ~ 5 m, 1 ~ 25 m, 2 ~ 100 m, 3 ~ 500 m, 4 ~ 1.0 s, 5 ~ 2.0 s, 6 ~ 2.7 s'],
    comments='Determines [DelayTime_3]'
  ),
  ParameterDef(name='TimeClk',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Time, 1 ~ Clk'],
    comments=''
  ),
  ParameterDef(name='DelayTime_2',
    low=0,
    high=127,
    default=0,
    definitions=
    [
    '0 ~ 0.01 m, 64 ~ 252 m, 127 ~ 500 m',
    '0 ~ 0.01 m, 64 ~ 504 m, 127 ~ 1.000 s',
    '0 ~ 0.01 m, 64 ~ 1.008 s, 127 ~ 2.000 s',
    '0 ~ 0.01 m, 64 ~ 1.361 s, 127 ~ 2.700 s',
    '0 ~ 1/64 T, 64 ~ 1/4 T, 127 ~ 2/1',
    ]
    ,
    comments='Time=500 ms, 1.0 s, 2.0 s, 2.7 s), Clk. Determined by [DelayRange_2] and by [TimeClk] =if present)'
  ),
  ParameterDef(name='DelayRange_2',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ 500 m, 1 ~ 1.0 s, 2 ~ 2.0 s, 3 ~ 2.7 s'],
    comments='Possibly determines [DelayTime_1], [DelayTime_2] and [DelayTime_3]'
  ),
  ParameterDef(name='RatioFixed',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Ratio, 1 ~ Fixed'],
    comments=''
  ),
  ParameterDef(name='OpFreqCoarse',
    low=0,
    high=31,
    default=0,
    definitions=['0 ~ 0, 31 ~ 31'],
    comments=''
  ),
  ParameterDef(name='OpFreqFine',
    low=0,
    high=99,
    default=0,
    definitions=['0 ~ 0, 99 ~ 99'],
    comments=''
  ),
  ParameterDef(name='OpFreqDetune',
    low=0,
    high=14,
    default=0,
    definitions=['0 ~ -7, 7 ~ 0, 14 ~ 7'],
    comments=''
  ),
  ParameterDef(name='OpVel',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ 0, 7 ~ 7'],
    comments=''
  ),
  ParameterDef(name='OpRateScale',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ 0, 7 ~ 7'],
    comments=''
  ),
  ParameterDef(name='OpTime',
    low=0,
    high=99,
    default=0,
    definitions=['0 ~ 0, 99 ~ 99'],
    comments=''
  ),
  ParameterDef(name='OpLevel',
    low=0,
    high=99,
    default=0,
    definitions=['0 ~ 0, 99 ~ 99'],
    comments=''
  ),
  ParameterDef(name='OpAmod',
    low=0,
    high=7,
    default=0,
    definitions=['0 ~ 0, 7 ~ 7'],
    comments=''
  ),
  ParameterDef(name='OpBrPpoint',
    low=0,
    high=99,
    default=0,
    definitions=['0 ~ 0, 99 ~ 99'],
    comments=''
  ),
  ParameterDef(name='OpDepthMode',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ 0, 3 ~ 3'],
    comments=''
  ),
  ParameterDef(name='OpDepth',
    low=0,
    high=99,
    default=0,
    definitions=['0 ~ 0, 99 ~ 99'],
    comments=''
  ),
  ParameterDef(name='DelayTime_1',
    low=0,
    high=127,
    default=0,
    definitions=
    [
    '0 ~ 0.01 m, 64 ~ 252 m, 127 ~ 500 m',
    '0 ~ 0.01 m, 64 ~ 504 m, 127 ~ 1.000 s',
    '0 ~ 0.01 m, 64 ~ 661 ms, 127 ~ 1.351 s',
    '0 ~ 1/64 T, 64 ~ 1/4 T, 127 ~ 2/1',
    ]
    ,
    comments='Time=500 ms, 1.0 s, 1.35 s), Clk. Determined by [DelayRange_1] and by [TimeClk] =if present)'
  ),
  ParameterDef(name='DelayRange_1',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ 500 m, 1 ~ 1.0 s, 2 ~ 2.0 s, 3 ~ 1.35 s'],
    comments='Determines [DelayTime_1]'
  ),
  ParameterDef(name='OscWaveform_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri'],
    comments=''
  ),
  ParameterDef(name='Treshold_127',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ -{00}, 64 ~ -6.0 dB, 127 ~ -0 dB'],
    comments=''
  ),
  ParameterDef(name='NoiseGateAttack',
    low=0,
    high=127,
    default=0,
    definitions=['0 ~ 0.2 m, 64 ~ 28.0 m, 127 ~ 100 m'],
    comments=''
  ),
  ParameterDef(name='NoiseGateRelease',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 0.50 m, 64 ~ 86.4 m, 127 ~ 1.00 s'],
    comments=''
  ),
  ParameterDef(name='LfoB_Waveform',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ Sine, 1 ~ Tri, 2 ~ Saw, 3 ~ Square'],
    comments=''
  ),
  ParameterDef(name='PhaserType',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Type I, 1 ~ Type II'],
    comments=''
  ),
  ParameterDef(name='PhaserFreq',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ 0.05 Hz, 64 ~ 2.98 Hz, 127 ~ 11.6 Hz'],
    comments=''
  ),
  ParameterDef(name='ExpLin_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Exp, 1 ~ Lin'],
    comments=''
  ),
  ParameterDef(name='ModAmtInvert',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ m, 1 ~ 1 - m'],
    comments=''
  ),
  ParameterDef(name='MonoKeyMode',
    low=0,
    high=2,
    default=0,
    definitions=['0 ~ Last, 1 ~ Lo, 2 ~ Hi'],
    comments=''
  ),
  ParameterDef(name='RndEdge',
    low=0,
    high=4,
    default=0,
    definitions=['0 ~ 0%, 1 ~ 25%, 2 ~ 50%, 3 ~ 75%, 4 ~ 100%'],
    comments=''
  ),
  ParameterDef(name='RandomAStepProb',
    low=0,
    high=3,
    default=0,
    definitions=['0 ~ 25%, 1 ~ 50%, 2 ~ 75%, 3 ~ 100%'],
    comments=''
  ),
  ParameterDef(name='Rnd_1',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Rnd1, 1 ~ Rnd2'],
    comments=''
  ),
  ParameterDef(name='RangeBip_128',
    low=0,
    high=127,
    default=64,
    definitions=['0 ~ -64, 64 ~ 0, 126 ~ 62, 127 ~ 64'],
    comments=''
  ),
  ParameterDef(name='RndStepPulse',
    low=0,
    high=1,
    default=0,
    definitions=['0 ~ Step, 1 ~ Pulse'],
    comments='',
  ),
]

parammap = ParameterMap()
for param in params:
  setattr(parammap, param.name, param)

