#!/usr/bin/env python

from nord.types import *
from nord.g2.colors import g2conncolors
from params import parammap

class ModuleMap(Struct): pass


modules = [
  ModuleType(
    type=1,
    height=2,
    longnm='Keyboard',
    shortnm='Keyboard',
    page=PageType('In/Out', 5),
    inputs=[],
    outputs=[
      OutputType('Pitch',        g2conncolors.blue,         horiz=2,vert=1),
      OutputType('Gate',         g2conncolors.yellow,       horiz=5,vert=1),
      OutputType('Lin',          g2conncolors.blue,         horiz=9,vert=1),
      OutputType('Release',      g2conncolors.blue,         horiz=12,vert=1),
      OutputType('Note',         g2conncolors.blue,         horiz=15,vert=1),
      OutputType('Exp',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=3,
    height=2,
    longnm='4 outputs',
    shortnm='4-Out',
    page=PageType('In/Out', 1),
    inputs=[
      InputType('In1',          g2conncolors.red,          horiz=13,vert=1),
      InputType('In2',          g2conncolors.red,          horiz=15,vert=1),
      InputType('In3',          g2conncolors.red,          horiz=17,vert=1),
      InputType('In4',          g2conncolors.red,          horiz=19,vert=1),
    ],
    outputs=[],
    params=[
      ParameterType('Destination',  parammap.Dst_2),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Pad',          parammap.Pad_1),
    ],
    modes=[],
  ),
  ModuleType(
    type=4,
    height=2,
    longnm='2 outputs',
    shortnm='2-Out',
    page=PageType('In/Out', 0),
    inputs=[
      InputType('InL',          g2conncolors.red,          horiz=17,vert=1),
      InputType('InR',          g2conncolors.red,          horiz=19,vert=1),
    ],
    outputs=[],
    params=[
      ParameterType('Destination',  parammap.Dst_1),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Pad',          parammap.Pad_1),
    ],
    modes=[],
  ),
  ModuleType(
    type=5,
    height=2,
    longnm='Logic Inverter',
    shortnm='Invert',
    page=PageType('Logic', 1),
    inputs=[
      InputType('In1',          g2conncolors.yellow_orange,horiz=7,vert=1),
      InputType('In2',          g2conncolors.yellow_orange,horiz=15,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.yellow_orange,horiz=11,vert=1),
      OutputType('Out2',         g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=7,
    height=5,
    longnm='Osc B',
    shortnm='OscB',
    page=PageType('Osc', 1),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=4),
      InputType('Sync',         g2conncolors.red,          horiz=0,vert=1),
      InputType('FmMod',        g2conncolors.red,          horiz=9,vert=4),
      InputType('ShapeMod',     g2conncolors.red,          horiz=14,vert=4),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('FmAmount',     parammap.Level_100),
      ParameterType('Shape',        parammap.PW),
      ParameterType('ShapeMod',     parammap.Level_100),
      ParameterType('Waveform',     parammap.OscBWaveform),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FmMode',       parammap.FmLinTrk),
    ],
    modes=[],
  ),
  ModuleType(
    type=8,
    height=4,
    longnm='Osc Shape B',
    shortnm='OscShpB',
    page=PageType('Osc', 6),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('Sync',         g2conncolors.red,          horiz=0,vert=1),
      InputType('FmMod',        g2conncolors.red,          horiz=10,vert=3),
      InputType('ShapeMod',     g2conncolors.red,          horiz=15,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('FmAmount',     parammap.Level_100),
      ParameterType('Shape',        parammap.PW),
      ParameterType('ShapeMod',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FmMode',       parammap.FmLinTrk),
    ],
    modes=[
      ModeType('Waveform',     parammap.OscWaveform_3),
    ],
  ),
  ModuleType(
    type=9,
    height=3,
    longnm='Osc C',
    shortnm='OscC',
    page=PageType('Osc', 2),
    inputs=[
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('Sync',         g2conncolors.red,          horiz=12,vert=2),
      InputType('FmMod',        g2conncolors.red,          horiz=14,vert=2),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('FmAmount',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FmMode',       parammap.FmLinTrk),
      ParameterType('PitchMod',     parammap.Level_100),
    ],
    modes=[
      ModeType('Waveform',     parammap.OscWaveform_2),
    ],
  ),
  ModuleType(
    type=12,
    height=3,
    longnm='reverb',
    shortnm='Reverb',
    page=PageType('FX', 7),
    inputs=[
      InputType('InL',          g2conncolors.red,          horiz=17,vert=0),
      InputType('InR',          g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.red,          horiz=17,vert=2),
      OutputType('OutR',         g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Time',         parammap.ReverbTime),
      ParameterType('Brightness',   parammap.Level_100),
      ParameterType('DryWet',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('RoomType',     parammap.RoomType),
    ],
  ),
  ModuleType(
    type=13,
    height=3,
    longnm='Osc String',
    shortnm='OscString',
    page=PageType('Osc', 13),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Pitch',        g2conncolors.blue,         horiz=0,vert=1),
      InputType('PitchVar',     g2conncolors.blue,         horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('Decay',        parammap.Level_100),
      ParameterType('Moisture',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=15,
    height=4,
    longnm='Switch 8-1',
    shortnm='Sw8-1',
    page=PageType('Switch', 5),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=6,vert=0),
      InputType('In2',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=9,vert=0),
      InputType('In4',          g2conncolors.blue_red,     horiz=11,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=13,vert=0),
      InputType('In6',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=15,vert=0),
      InputType('In8',          g2conncolors.blue_red,     horiz=18,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=3),
      OutputType('Control',      g2conncolors.blue,         horiz=9,vert=3),
    ],
    params=[
      ParameterType('Sel',          parammap.sw_3,
        labels=['In 1','In 2','In 3','In 4','In 5','In 6','In 7','In 8']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=17,
    height=2,
    longnm='Value Switch 1-2',
    shortnm='ValSw1-2',
    page=PageType('Switch', 11),
    inputs=[
      InputType('Input',        g2conncolors.blue_red,     horiz=14,vert=2),
      InputType('Ctrl',         g2conncolors.blue_red,     horiz=0,vert=2),
    ],
    outputs=[
      OutputType('OutOn',        g2conncolors.blue_red,     horiz=16,vert=2),
      OutputType('OutOff',       g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('Val',          parammap.ValSwVal,
        labels=['Out 1','Out 2']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=18,
    height=2,
    longnm='Cross Fader',
    shortnm='X-Fade',
    page=PageType('Mixer', 13),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=14,vert=2),
      InputType('In2',          g2conncolors.blue_red,     horiz=16,vert=2),
      InputType('Mod',          g2conncolors.blue_red,     horiz=6,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('MixMod',       parammap.Level_100),
      ParameterType('Mix',          parammap.Bipolar_127),
      ParameterType('LogLin',       parammap.LogLin),
    ],
    modes=[],
  ),
  ModuleType(
    type=19,
    height=2,
    longnm='Mixer 4-1 B',
    shortnm='Mix4-1B',
    page=PageType('Mixer', 5),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=8,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('Lev3',         parammap.MixLevel),
      ParameterType('Lev4',         parammap.MixLevel),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=20,
    height=4,
    longnm='Envelop ADSR',
    shortnm='EnvADSR',
    page=PageType('Env', 0),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('AM',           g2conncolors.blue,         horiz=0,vert=3),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=18,vert=3),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=3),
    ],
    params=[
      ParameterType('Shape',        parammap.EnvShape_3),
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('Decay',        parammap.EnvTime),
      ParameterType('Sustain',      parammap.EnvLevel),
      ParameterType('Release',      parammap.EnvTime),
      ParameterType('OutputType',   parammap.PosNegInvBipInv),
      ParameterType('KB',           parammap.OffOn),
      ParameterType('NR',           parammap.EnvNR),
    ],
    modes=[],
  ),
  ModuleType(
    type=21,
    height=2,
    longnm='Multiplexer 1-8',
    shortnm='Mux1-8',
    page=PageType('Switch', 14),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=6,vert=1),
      InputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.blue_red,     horiz=7,vert=1),
      OutputType('Out2',         g2conncolors.blue_red,     horiz=9,vert=1),
      OutputType('Out3',         g2conncolors.blue_red,     horiz=11,vert=1),
      OutputType('Out4',         g2conncolors.blue_red,     horiz=12,vert=1),
      OutputType('Out5',         g2conncolors.blue_red,     horiz=14,vert=1),
      OutputType('Out6',         g2conncolors.blue_red,     horiz=16,vert=1),
      OutputType('Out7',         g2conncolors.blue_red,     horiz=18,vert=1),
      OutputType('Out8',         g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=22,
    height=2,
    longnm='Partial Quantizer',
    shortnm='PartQuant',
    page=PageType('Note', 2),
    inputs=[
      InputType('In',           g2conncolors.blue,         horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Range',        parammap.PartialRange),
    ],
    modes=[],
  ),
  ModuleType(
    type=23,
    height=5,
    longnm='Envelope Modulation ADSR',
    shortnm='ModADSR',
    page=PageType('Env', 8),
    inputs=[
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=4),
      InputType('AttackMod',    g2conncolors.blue,         horiz=2,vert=4),
      InputType('DecayMod',     g2conncolors.blue,         horiz=5,vert=4),
      InputType('SustainMod',   g2conncolors.blue,         horiz=8,vert=4),
      InputType('ReleaseMod',   g2conncolors.blue,         horiz=11,vert=4),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
      InputType('AM',           g2conncolors.blue,         horiz=0,vert=4),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=19,vert=4),
      OutputType('Out',          g2conncolors.blue_red,     horiz=17,vert=4),
    ],
    params=[
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('Decay',        parammap.EnvTime),
      ParameterType('Sustain',      parammap.EnvLevel),
      ParameterType('Release',      parammap.EnvTime),
      ParameterType('AttackMod',    parammap.Level_100),
      ParameterType('DecayMod',     parammap.Level_100),
      ParameterType('SustainMod',   parammap.Level_100),
      ParameterType('ReleaseMod',   parammap.Level_100),
      ParameterType('OutputType',   parammap.PosNegInvBipInv),
      ParameterType('KB',           parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=24,
    height=2,
    longnm='LFO C',
    shortnm='LfoC',
    page=PageType('LFO', 2),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_3),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('OutputType',   parammap.OutTypeLfo),
      ParameterType('Range',        parammap.LfoRange_3),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('Waveform',     parammap.LfoWaveform_1),
    ],
  ),
  ModuleType(
    type=25,
    height=5,
    longnm='LFO Shape A',
    shortnm='LfoShpA',
    page=PageType('LFO', 3),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=1,vert=4),
      InputType('RateVar',      g2conncolors.blue,         horiz=2,vert=4),
      InputType('Rst',          g2conncolors.blue,         horiz=0,vert=1),
      InputType('ShapeMod',     g2conncolors.blue,         horiz=9,vert=4),
      InputType('PhaseMod',     g2conncolors.blue,         horiz=12,vert=4),
      InputType('Dir',          g2conncolors.blue,         horiz=1,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=4),
      OutputType('Snc',          g2conncolors.blue,         horiz=0,vert=4),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_4),
      ParameterType('Range',        parammap.LfoRange_4),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('RateMod',      parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Shape',        parammap.LfoShpAPW),
      ParameterType('PhaseMod',     parammap.Level_100),
      ParameterType('Phase',        parammap.Phase),
      ParameterType('ShapeMod',     parammap.Level_100),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('OutputType',   parammap.OutTypeLfo),
      ParameterType('Waveform',     parammap.LfoShpA__Waveform),
    ],
    modes=[],
  ),
  ModuleType(
    type=26,
    height=3,
    longnm='LFO A',
    shortnm='LfoA',
    page=PageType('LFO', 0),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=0,vert=1),
      InputType('RateVar',      g2conncolors.blue,         horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=2),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_3),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('RateMod',      parammap.Level_100),
      ParameterType('Waveform',     parammap.LfoA_Waveform),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('OutputType',   parammap.OutTypeLfo),
      ParameterType('Range',        parammap.LfoRange_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=27,
    height=3,
    longnm='Osc Master',
    shortnm='OscMaster',
    page=PageType('Osc', 16),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('FreqMode',     parammap.FreqMode_2),
      ParameterType('PitchMod',     parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=28,
    height=2,
    longnm='Saturate',
    shortnm='Saturate',
    page=PageType('Shaper', 2),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=8,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Amount',       parammap.Level_100),
      ParameterType('AmountMod',    parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Curve',        parammap.SaturateCurve),
    ],
    modes=[],
  ),
  ModuleType(
    type=29,
    height=2,
    longnm='Metallic Noise Oscillator',
    shortnm='MetNoise',
    page=PageType('Osc', 10),
    inputs=[
      InputType('FreqMod',      g2conncolors.blue_red,     horiz=4,vert=1),
      InputType('ColorMod',     g2conncolors.blue_red,     horiz=11,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Color',        parammap.Level_100),
      ParameterType('Freq',         parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FreqMod',      parammap.Level_100),
      ParameterType('ColorMod',     parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=30,
    height=3,
    longnm='Device',
    shortnm='Device',
    page=PageType('In/Out', 7),
    inputs=[],
    outputs=[
      OutputType('Wheel',        g2conncolors.blue,         horiz=0,vert=2),
      OutputType('AftTouch',     g2conncolors.blue,         horiz=3,vert=2),
      OutputType('ControlPedal', g2conncolors.blue,         horiz=6,vert=2),
      OutputType('SustainPedal', g2conncolors.yellow,       horiz=10,vert=2),
      OutputType('PitchStick',   g2conncolors.blue,         horiz=13,vert=2),
      OutputType('GlobalWheel1', g2conncolors.blue,         horiz=16,vert=2),
      OutputType('GlobalWheel2', g2conncolors.blue,         horiz=19,vert=2),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=31,
    height=2,
    longnm='Noise',
    shortnm='Noise',
    page=PageType('Osc', 9),
    inputs=[],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Color',        parammap.NoiseColor),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=32,
    height=3,
    longnm='Eq 2 Band',
    shortnm='Eq2Band',
    page=PageType('Filter', 12),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('LoSlope',      parammap.EqdB),
      ParameterType('HiSlope',      parammap.EqdB),
      ParameterType('Level',        parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('LoFreq',       parammap.EqLoFreq),
      ParameterType('HiFreq',       parammap.EqHiFreq),
    ],
    modes=[],
  ),
  ModuleType(
    type=33,
    height=4,
    longnm='Eq 3 Band',
    shortnm='Eq3Band',
    page=PageType('Filter', 13),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('LoSlope',      parammap.EqdB),
      ParameterType('MidGain',      parammap.EqdB),
      ParameterType('MidFreq',      parammap.EqMidFreq),
      ParameterType('HiSlope',      parammap.EqdB),
      ParameterType('Level',        parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('LoFreq',       parammap.EqLoFreq),
      ParameterType('HiFreq',       parammap.EqHiFreq),
    ],
    modes=[],
  ),
  ModuleType(
    type=34,
    height=2,
    longnm='Shape Exp',
    shortnm='ShpExp',
    page=PageType('Shaper', 3),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=8,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Amount',       parammap.Level_100),
      ParameterType('AmountMod',    parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Curve',        parammap.ShpExpCurve),
    ],
    modes=[],
  ),
  ModuleType(
    type=36,
    height=2,
    longnm='Switch On/Off Momentary',
    shortnm='SwOnOffM',
    page=PageType('Switch', 0),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('On',           parammap.OffOn,
        labels=['On']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=38,
    height=2,
    longnm='Pulse',
    shortnm='Pulse',
    page=PageType('Logic', 4),
    inputs=[
      InputType('In',           g2conncolors.yellow_orange,horiz=15,vert=0),
      InputType('Time',         g2conncolors.blue_red,     horiz=4,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[
      ParameterType('Time',         parammap.LogicTime),
      ParameterType('TimeMod',      parammap.Level_100),
      ParameterType('Range',        parammap.LogicRange),
    ],
    modes=[
      ModeType('Mode',         parammap.PulseMode),
    ],
  ),
  ModuleType(
    type=40,
    height=4,
    longnm='Mixer 8-1 B',
    shortnm='Mix8-1B',
    page=PageType('Mixer', 9),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=3,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=11,vert=1),
      InputType('In6',          g2conncolors.blue_red,     horiz=13,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('In8',          g2conncolors.blue_red,     horiz=17,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=3),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('Lev3',         parammap.MixLevel),
      ParameterType('Lev4',         parammap.MixLevel),
      ParameterType('Lev5',         parammap.MixLevel),
      ParameterType('Lev6',         parammap.MixLevel),
      ParameterType('Lev7',         parammap.MixLevel),
      ParameterType('Lev8',         parammap.MixLevel),
      ParameterType('ExpLin',       parammap.ExpLin_2),
      ParameterType('Pad',          parammap.Pad_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=41,
    height=2,
    longnm='Envelope Hold',
    shortnm='EnvH',
    page=PageType('Env', 1),
    inputs=[
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=1),
      InputType('AM',           g2conncolors.blue,         horiz=3,vert=1),
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=15,vert=1),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Hold',         parammap.EnvTime),
      ParameterType('OutputType',   parammap.PosNegInv),
    ],
    modes=[],
  ),
  ModuleType(
    type=42,
    height=2,
    longnm='Logic Delay',
    shortnm='Delay',
    page=PageType('Logic', 5),
    inputs=[
      InputType('In',           g2conncolors.yellow_orange,horiz=15,vert=0),
      InputType('TimeMod',      g2conncolors.blue_red,     horiz=4,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[
      ParameterType('Time',         parammap.LogicTime),
      ParameterType('TimeMod',      parammap.Level_100),
      ParameterType('Range',        parammap.LogicRange),
    ],
    modes=[
      ModeType('Mode',         parammap.LogicDelayMode),
    ],
  ),
  ModuleType(
    type=43,
    height=2,
    longnm='Constant Value',
    shortnm='Constant',
    page=PageType('Level', 0),
    inputs=[],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Level',        parammap.LevBipUni),
      ParameterType('BipUni',       parammap.BipUni),
    ],
    modes=[],
  ),
  ModuleType(
    type=44,
    height=2,
    longnm='Level Multiplier',
    shortnm='LevMult',
    page=PageType('Level', 6),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=14,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=45,
    height=4,
    longnm='Filter Voice',
    shortnm='FltVoice',
    page=PageType('Filter', 9),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('VowelMod',     g2conncolors.blue,         horiz=9,vert=3),
      InputType('FreqMod',      g2conncolors.red,          horiz=0,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('Vowel1',       parammap.Vowel),
      ParameterType('Vowel2',       parammap.Vowel),
      ParameterType('Vowel3',       parammap.Vowel),
      ParameterType('Level',        parammap.Level_100),
      ParameterType('Vowel',        parammap.Level_100),
      ParameterType('VowelMod',     parammap.Bipolar_127),
      ParameterType('Freq',         parammap.Level_100),
      ParameterType('FreqMod',      parammap.Bipolar_127),
      ParameterType('Res',          parammap.Bipolar_127),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=46,
    height=4,
    longnm='Envelope AHD',
    shortnm='EnvAHD',
    page=PageType('Env', 4),
    inputs=[
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('AM',           g2conncolors.blue,         horiz=0,vert=3),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=18,vert=0),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    params=[
      ParameterType('Shape',        parammap.EnvShape_3),
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('Hold',         parammap.EnvTime),
      ParameterType('NR',           parammap.EnvNR),
      ParameterType('Decay',        parammap.EnvTime),
      ParameterType('OutputType',   parammap.PosNegInv),
      ParameterType('KB',           parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=47,
    height=2,
    longnm='Pan',
    shortnm='Pan',
    page=PageType('Mixer', 12),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=6,vert=1),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.blue_red,     horiz=16,vert=1),
      OutputType('OutR',         g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('PanMod',       parammap.Level_100),
      ParameterType('Pan',          parammap.Bipolar_127),
      ParameterType('LogLin',       parammap.LogLin),
    ],
    modes=[],
  ),
  ModuleType(
    type=48,
    height=5,
    longnm='Mixer Stereo',
    shortnm='MixStereo',
    page=PageType('Mixer', 11),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('In2',          g2conncolors.blue_red,     horiz=2,vert=2),
      InputType('In3',          g2conncolors.blue_red,     horiz=5,vert=2),
      InputType('In4',          g2conncolors.blue_red,     horiz=8,vert=2),
      InputType('In5',          g2conncolors.blue_red,     horiz=10,vert=2),
      InputType('In6',          g2conncolors.blue_red,     horiz=13,vert=2),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.blue_red,     horiz=17,vert=4),
      OutputType('OutR',         g2conncolors.blue_red,     horiz=19,vert=4),
    ],
    params=[
      ParameterType('Lev1',         parammap.Level_100),
      ParameterType('Lev2',         parammap.Level_100),
      ParameterType('Lev3',         parammap.Level_100),
      ParameterType('Lev4',         parammap.Level_100),
      ParameterType('Lev5',         parammap.Level_100),
      ParameterType('Lev6',         parammap.Level_100),
      ParameterType('Pan1',         parammap.Bipolar_127),
      ParameterType('Pan2',         parammap.Bipolar_127),
      ParameterType('Pan3',         parammap.Bipolar_127),
      ParameterType('Pan4',         parammap.Bipolar_127),
      ParameterType('Pan5',         parammap.Bipolar_127),
      ParameterType('Pan6',         parammap.Bipolar_127),
      ParameterType('LevMaster',    parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=49,
    height=4,
    longnm='Filter Multi-mode',
    shortnm='FltMulti',
    page=PageType('Filter', 4),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
    ],
    outputs=[
      OutputType('LP',           g2conncolors.red,          horiz=19,vert=1),
      OutputType('BP',           g2conncolors.red,          horiz=19,vert=2),
      OutputType('HP',           g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('PitchMod',     parammap.Level_200),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('GC',           parammap.GcOffOn),
      ParameterType('Res',          parammap.Res_1),
      ParameterType('Slope',        parammap.FltSlope_1),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=50,
    height=2,
    longnm='Constant Switch Toggling',
    shortnm='ConstSwT',
    page=PageType('Level', 2),
    inputs=[],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev',          parammap.LevBipUni),
      ParameterType('On',           parammap.OffOn,
        labels=['Switch']
      ),
      ParameterType('BipUni',       parammap.BipUni),
    ],
    modes=[],
  ),
  ModuleType(
    type=51,
    height=5,
    longnm='Filter Nord',
    shortnm='FltNord',
    page=PageType('Filter', 2),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=4),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('FMLin',        g2conncolors.blue_red,     horiz=3,vert=4),
      InputType('Res',          g2conncolors.blue_red,     horiz=9,vert=4),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('PitchMod',     parammap.Level_200),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('GC',           parammap.GcOffOn),
      ParameterType('Res',          parammap.Res_1),
      ParameterType('Slope',        parammap.FltSlope_2),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FM_Lin',       parammap.Level_100),
      ParameterType('FilterType',   parammap.LpBpHpBr),
      ParameterType('ResMod',       parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=52,
    height=6,
    longnm='Envelope Multi',
    shortnm='EnvMulti',
    page=PageType('Env', 6),
    inputs=[
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=0),
      InputType('AM',           g2conncolors.blue,         horiz=2,vert=2),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=19,vert=1),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    params=[
      ParameterType('Level1',       parammap.EnvLevel),
      ParameterType('Level2',       parammap.EnvLevel),
      ParameterType('Level3',       parammap.EnvLevel),
      ParameterType('Level4',       parammap.EnvLevel),
      ParameterType('Time1',        parammap.EnvTime),
      ParameterType('Time2',        parammap.EnvTime),
      ParameterType('Time3',        parammap.EnvTime),
      ParameterType('Time4',        parammap.EnvTime),
      ParameterType('NR',           parammap.EnvNR),
      ParameterType('SustainMode',  parammap.SustainMode_2),
      ParameterType('OutputType',   parammap.PosNegInvBip),
      ParameterType('KB',           parammap.OffOn),
      ParameterType('Shape',        parammap.EnvShape_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=53,
    height=2,
    longnm='Sample & Hold',
    shortnm='S&H',
    page=PageType('Switch', 16),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('Ctrl',         g2conncolors.yellow_orange,horiz=12,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=54,
    height=3,
    longnm='Filter Static',
    shortnm='FltStatic',
    page=PageType('Filter', 5),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('Res',          parammap.Res_1),
      ParameterType('FilterType',   parammap.LpBpHp),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('GC',           parammap.GcOffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=55,
    height=2,
    longnm='Envelope Decay',
    shortnm='EnvD',
    page=PageType('Env', 2),
    inputs=[
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=1),
      InputType('AM',           g2conncolors.blue,         horiz=3,vert=1),
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=15,vert=1),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Decay',        parammap.EnvTime),
      ParameterType('OutputType',   parammap.PosNegInv),
    ],
    modes=[],
  ),
  ModuleType(
    type=57,
    height=2,
    longnm='MIDI Control Automate',
    shortnm='Automate',
    page=PageType('MIDI', 6),
    inputs=[
      InputType('In',           g2conncolors.yellow,       horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow,       horiz=4,vert=1),
    ],
    params=[
      ParameterType('Ctrl',         parammap.MidiData),
      ParameterType('Val',          parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_20),
      ParameterType('Echo',         parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=58,
    height=8,
    longnm='Drum Synthesizer',
    shortnm='DrumSynth',
    page=PageType('Osc', 12),
    inputs=[
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('Vel',          g2conncolors.blue,         horiz=0,vert=7),
      InputType('Pitch',        g2conncolors.blue,         horiz=0,vert=4),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=8),
    ],
    params=[
      ParameterType('Masterfreq',   parammap.DrumSynthFreq),
      ParameterType('SlaveRatio',   parammap.DrumSynthRatio),
      ParameterType('MasterDecay',  parammap.EnvTime),
      ParameterType('SlaveDecay',   parammap.EnvTime),
      ParameterType('MasterLevel',  parammap.Level_100),
      ParameterType('SlaveLevel',   parammap.Level_100),
      ParameterType('NoiseFltFreq', parammap.DrumSynthNoiseFlt),
      ParameterType('NoiseFltRes',  parammap.Level_100),
      ParameterType('NoiseFltSweep',parammap.Level_100),
      ParameterType('NoiseFltDecay',parammap.EnvTime),
      ParameterType('NoiseFltMode', parammap.LpBpHp),
      ParameterType('BendAmount',   parammap.Level_100),
      ParameterType('BendDecay',    parammap.EnvTime),
      ParameterType('Click',        parammap.Level_100),
      ParameterType('Noise',        parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=59,
    height=2,
    longnm='Compare to Level',
    shortnm='CompLev',
    page=PageType('Level', 10),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=9,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[
      ParameterType('C',            parammap.Bipolar_127),
    ],
    modes=[],
  ),
  ModuleType(
    type=60,
    height=3,
    longnm='Multiplexer 8-1 with variable X-Fade',
    shortnm='Mux8-1X',
    page=PageType('Switch', 15),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=10,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('In6',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('In8',          g2conncolors.blue_red,     horiz=17,vert=1),
      InputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('XFade',        parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=61,
    height=2,
    longnm='Clip',
    shortnm='Clip',
    page=PageType('Shaper', 0),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=5,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('ClipLevMod',   parammap.Level_100),
      ParameterType('ClipLev',      parammap.Level_100),
      ParameterType('Shape',        parammap.ClipShape),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=62,
    height=2,
    longnm='Overdrive',
    shortnm='Overdrive',
    page=PageType('Shaper', 1),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=8,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('AmountMod',    parammap.Level_100),
      ParameterType('Amount',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Type',         parammap.OverdriveType),
      ParameterType('Shape',        parammap.ClipShape),
    ],
    modes=[],
  ),
  ModuleType(
    type=63,
    height=3,
    longnm='Scratch',
    shortnm='Scratch',
    page=PageType('FX', 6),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Mod',          g2conncolors.blue,         horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Ratio',        parammap.ScratchRatio),
      ParameterType('RatioMod',     parammap.Level_100),
      ParameterType('Delay',        parammap.ScratchDelay),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=64,
    height=2,
    longnm='Gate',
    shortnm='Gate',
    page=PageType('Logic', 0),
    inputs=[
      InputType('In1_1',        g2conncolors.yellow_orange,horiz=6,vert=0),
      InputType('In1_2',        g2conncolors.yellow_orange,horiz=5,vert=1),
      InputType('In2_1',        g2conncolors.yellow_orange,horiz=13,vert=0),
      InputType('In2_2',        g2conncolors.yellow_orange,horiz=12,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.yellow_orange,horiz=11,vert=1),
      OutputType('Out2',         g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[
      ModeType('GateMode1',    parammap.GateMode),
      ModeType('GateMode2',    parammap.GateMode),
    ],
  ),
  ModuleType(
    type=66,
    height=2,
    longnm='Scratch',
    shortnm='Mix2-1B',
    page=PageType('Mixer', 3),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Inv1',         parammap.MixInvert),
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Inv2',         parammap.MixInvert),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=68,
    height=4,
    longnm='Clock Generator',
    shortnm='ClkGen',
    page=PageType('LFO', 4),
    inputs=[
      InputType('Rst',          g2conncolors.yellow,       horiz=0,vert=1),
    ],
    outputs=[
      OutputType('1/96',         g2conncolors.yellow,       horiz=19,vert=1),
      OutputType('1/16',         g2conncolors.yellow,       horiz=19,vert=2),
      OutputType('ClkActive',    g2conncolors.yellow,       horiz=19,vert=0),
      OutputType('Sync',         g2conncolors.yellow,       horiz=19,vert=3),
    ],
    params=[
      ParameterType('Rate',         parammap.RateBpm),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Source',       parammap.InternalMaster),
      ParameterType('BeatSync',     parammap.ClkGenBeatSync),
      ParameterType('Swing',        parammap.ClkGenSwing),
    ],
    modes=[],
  ),
  ModuleType(
    type=69,
    height=2,
    longnm='Clock Divider',
    shortnm='ClkDiv',
    page=PageType('Logic', 3),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=8,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=5,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[
      ParameterType('Divider',      parammap.Range_128),
    ],
    modes=[
      ModeType('DivMode',      parammap.ClkDivMode),
    ],
  ),
  ModuleType(
    type=71,
    height=2,
    longnm='Envelope Follower',
    shortnm='EnvFollow',
    page=PageType('Level', 8),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Attack',       parammap.EnvFollowAttack),
      ParameterType('Release',      parammap.EnvFollowRelease),
    ],
    modes=[],
  ),
  ModuleType(
    type=72,
    height=2,
    longnm='Note Scaler',
    shortnm='NoteScaler',
    page=PageType('Note', 3),
    inputs=[
      InputType('In',           g2conncolors.blue,         horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Range',        parammap.NoteRange),
    ],
    modes=[],
  ),
  ModuleType(
    type=74,
    height=2,
    longnm='Wave Wrapper',
    shortnm='WaveWrap',
    page=PageType('Shaper', 4),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=8,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('AmountMod',    parammap.Level_100),
      ParameterType('Amount',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=75,
    height=2,
    longnm='Note Quantizer',
    shortnm='NoteQuant',
    page=PageType('Note', 0),
    inputs=[
      InputType('In',           g2conncolors.blue,         horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Range',        parammap.NoteRange),
      ParameterType('Notes',        parammap.NoteQuantNotes),
    ],
    modes=[],
  ),
  ModuleType(
    type=76,
    height=2,
    longnm='Switch On/Off Toggle',
    shortnm='SwOnOffT',
    page=PageType('Switch', 1),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('On',           parammap.OffOn,
        labels=['On']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=78,
    height=4,
    longnm='Switch 1-8',
    shortnm='Sw1-8',
    page=PageType('Switch', 9),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=3,vert=3),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.blue_red,     horiz=6,vert=2),
      OutputType('Out2',         g2conncolors.blue_red,     horiz=8,vert=3),
      OutputType('Out3',         g2conncolors.blue_red,     horiz=10,vert=2),
      OutputType('Out4',         g2conncolors.blue_red,     horiz=12,vert=3),
      OutputType('Out5',         g2conncolors.blue_red,     horiz=13,vert=2),
      OutputType('Out6',         g2conncolors.blue_red,     horiz=15,vert=3),
      OutputType('Out7',         g2conncolors.blue_red,     horiz=17,vert=2),
      OutputType('Out8',         g2conncolors.blue_red,     horiz=19,vert=3),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=3),
    ],
    params=[
      ParameterType('Sel',          parammap.sw_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=79,
    height=3,
    longnm='Switch 4-1',
    shortnm='Sw4-1',
    page=PageType('Switch', 4),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=6,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=13,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=2),
    ],
    params=[
      ParameterType('Sel',          parammap.sw_2,
        labels=['In 1','In 2','In 3','In 4']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=81,
    height=2,
    longnm='Level Amplifier',
    shortnm='LevAmp',
    page=PageType('Level', 5),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Gain',         parammap.LevAmpGain),
      ParameterType('Type',         parammap.LinDB),
    ],
    modes=[],
  ),
  ModuleType(
    type=82,
    height=2,
    longnm='Rectifier',
    shortnm='Rect',
    page=PageType('Shaper', 6),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Mode',         parammap.RectMode),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=83,
    height=2,
    longnm='Shape Static',
    shortnm='ShpStatic',
    page=PageType('Shaper', 5),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Mode',         parammap.ShpStaticMode),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=84,
    height=3,
    longnm='Envelope ADR',
    shortnm='EnvADR',
    page=PageType('Env', 3),
    inputs=[
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
      InputType('AM',           g2conncolors.blue,         horiz=3,vert=2),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=17,vert=2),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
      OutputType('End',          g2conncolors.yellow,       horiz=16,vert=2),
    ],
    params=[
      ParameterType('Shape',        parammap.EnvShape_3),
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('NR',           parammap.EnvNR),
      ParameterType('Release',      parammap.EnvTime),
      ParameterType('TG',           parammap.TrigGate),
      ParameterType('OutputType',   parammap.PosNegInv),
      ParameterType('KB',           parammap.OffOn),
      ParameterType('DcyRel',       parammap.AdAr),
    ],
    modes=[],
  ),
  ModuleType(
    type=85,
    height=2,
    longnm='Window Switch',
    shortnm='WindSw',
    page=PageType('Switch', 12),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Ctrl',         g2conncolors.blue_red,     horiz=14,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Gate',         g2conncolors.yellow_orange,horiz=0,vert=1),
    ],
    params=[
      ParameterType('ValFrom',      parammap.Range_64),
      ParameterType('ValTo',        parammap.Range_64),
    ],
    modes=[],
  ),
  ModuleType(
    type=86,
    height=2,
    longnm='8 Counter',
    shortnm='8Counter',
    page=PageType('Logic', 6),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=3,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.yellow_orange,horiz=5,vert=1),
      OutputType('Out2',         g2conncolors.yellow_orange,horiz=7,vert=1),
      OutputType('Out3',         g2conncolors.yellow_orange,horiz=9,vert=1),
      OutputType('Out4',         g2conncolors.yellow_orange,horiz=11,vert=1),
      OutputType('Out5',         g2conncolors.yellow_orange,horiz=13,vert=1),
      OutputType('Out6',         g2conncolors.yellow_orange,horiz=15,vert=1),
      OutputType('Out7',         g2conncolors.yellow_orange,horiz=17,vert=1),
      OutputType('Out8',         g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=87,
    height=2,
    longnm='Filter Lowpass',
    shortnm='FltLP',
    page=PageType('Filter', 0),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=4,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('FreqMod',      parammap.Level_100),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('SlopeMode',    parammap.HpLpSlopeMode),
    ],
  ),
  ModuleType(
    type=88,
    height=3,
    longnm='Switch 1-4',
    shortnm='Sw1-4',
    page=PageType('Switch', 8),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=3,vert=2),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.blue_red,     horiz=6,vert=2),
      OutputType('Out2',         g2conncolors.blue_red,     horiz=10,vert=2),
      OutputType('Out3',         g2conncolors.blue_red,     horiz=13,vert=2),
      OutputType('Out4',         g2conncolors.blue_red,     horiz=17,vert=2),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=2),
    ],
    params=[
      ParameterType('Sel',          parammap.sw_2,
        labels=['Out 1','Out 2','Out 3','Out 4','Out 5','Out 6','Out 7','Out 8']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=89,
    height=3,
    longnm='Flanger',
    shortnm='Flanger',
    page=PageType('FX', 2),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Rate',         parammap.FlangerRate),
      ParameterType('Range',        parammap.Level_100),
      ParameterType('FeedBack',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=90,
    height=2,
    longnm='Switch 1-2',
    shortnm='Sw1-2',
    page=PageType('Switch', 7),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=14,vert=1),
    ],
    outputs=[
      OutputType('Out2',         g2conncolors.blue_red,     horiz=16,vert=1),
      OutputType('Out1',         g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('Sel',          parammap.Sw_1),
    ],
    modes=[],
  ),
  ModuleType(
    type=91,
    height=2,
    longnm='Flip Flop',
    shortnm='FlipFlop',
    page=PageType('Logic', 2),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=8,vert=1),
      InputType('In',           g2conncolors.yellow_orange,horiz=11,vert=0),
      InputType('Res',          g2conncolors.yellow_orange,horiz=5,vert=1),
    ],
    outputs=[
      OutputType('NotQ',         g2conncolors.yellow_orange,horiz=17,vert=1),
      OutputType('Q',            g2conncolors.yellow_orange,horiz=19,vert=0),
    ],
    params=[],
    modes=[
      ModeType('OperationMode',parammap.FlipFlopMode),
    ],
  ),
  ModuleType(
    type=92,
    height=4,
    longnm='Filter Classic',
    shortnm='FltClassic',
    page=PageType('Filter', 3),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('PitchMod',     parammap.Level_200),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('Res',          parammap.Level_100),
      ParameterType('Slope',        parammap.ClassicSlope),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=94,
    height=3,
    longnm='Stereo Chorus',
    shortnm='StChorus',
    page=PageType('FX', 0),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=18,vert=1),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.red,          horiz=17,vert=2),
      OutputType('OutR',         g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Detune',       parammap.Level_100),
      ParameterType('Amount',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=96,
    height=2,
    longnm='Osc D',
    shortnm='OscD',
    page=PageType('Osc', 3),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('Waveform',     parammap.OscWaveform_2),
    ],
  ),
  ModuleType(
    type=97,
    height=3,
    longnm='Osc A',
    shortnm='OscA',
    page=PageType('Osc', 0),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('Waveform',     parammap.OscA_Waveform),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('FreqMode',     parammap.FreqMode_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=98,
    height=3,
    longnm='Frequency Shifter',
    shortnm='FreqShift',
    page=PageType('FX', 4),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=18,vert=0),
      InputType('Shift',        g2conncolors.blue,         horiz=1,vert=2),
    ],
    outputs=[
      OutputType('Dn',           g2conncolors.red,          horiz=17,vert=1),
      OutputType('Up',           g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('FreqShift',    parammap.FreqShiftFreq),
      ParameterType('ShiftMod',     parammap.Level_100),
      ParameterType('Range',        parammap.FreqShiftRange),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=100,
    height=2,
    longnm='Switch 2-1',
    shortnm='Sw2-1',
    page=PageType('Switch', 3),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=14,vert=0),
      InputType('In2',          g2conncolors.blue_red,     horiz=16,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('Sel',          parammap.Sw_1,
        labels=['In 1','In 2']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=102,
    height=5,
    longnm='Filter Phase',
    shortnm='FltPhase',
    page=PageType('Filter', 6),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=4),
      InputType('Spr',          g2conncolors.blue,         horiz=6,vert=4),
      InputType('FB',           g2conncolors.blue,         horiz=9,vert=4),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('Freq',         parammap.Freq_2),
      ParameterType('SpreadMod',    parammap.Level_100),
      ParameterType('FB',           parammap.Bipolar_127),
      ParameterType('NotchCount',   parammap.FltPhaseNotchCount),
      ParameterType('Spread',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Level',        parammap.Level_100),
      ParameterType('FBMod',        parammap.Level_100),
      ParameterType('Type',         parammap.FltPhaseType),
      ParameterType('Kbt',          parammap.Kbt_4),
    ],
    modes=[],
  ),
  ModuleType(
    type=103,
    height=4,
    longnm='Eq Peak',
    shortnm='EqPeak',
    page=PageType('Filter', 11),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('Freq',         parammap.Freq_3),
      ParameterType('Gain',         parammap.EqdB),
      ParameterType('Bandwidth',    parammap.EqPeakBandwidth),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Level',        parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=105,
    height=2,
    longnm='Value Switch 2-1',
    shortnm='ValSw2-1',
    page=PageType('Switch', 10),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Ctrl',         g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Val',          parammap.ValSwVal),
    ],
    modes=[],
  ),
  ModuleType(
    type=106,
    height=3,
    longnm='Oscillator Noise',
    shortnm='OscNoise',
    page=PageType('Osc', 8),
    inputs=[

    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('Width',        parammap.Level_100),
      ParameterType('WidthMod',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=108,
    height=8,
    longnm='Vocoder',
    shortnm='Vocoder',
    page=PageType('Filter', 10),
    inputs=[
      InputType('Ctrl',         g2conncolors.red,          horiz=0,vert=2),
      InputType('In',           g2conncolors.red,          horiz=16,vert=7),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=7),
    ],
    params=[
      ParameterType('Band1',        parammap.VocoderBand),
      ParameterType('Band2',        parammap.VocoderBand),
      ParameterType('Band3',        parammap.VocoderBand),
      ParameterType('Band4',        parammap.VocoderBand),
      ParameterType('Band5',        parammap.VocoderBand),
      ParameterType('Band6',        parammap.VocoderBand),
      ParameterType('Band7',        parammap.VocoderBand),
      ParameterType('Band8',        parammap.VocoderBand),
      ParameterType('Band9',        parammap.VocoderBand),
      ParameterType('Band10',       parammap.VocoderBand),
      ParameterType('Band11',       parammap.VocoderBand),
      ParameterType('Band12',       parammap.VocoderBand),
      ParameterType('Band13',       parammap.VocoderBand),
      ParameterType('Band14',       parammap.VocoderBand),
      ParameterType('Band15',       parammap.VocoderBand),
      ParameterType('Band16',       parammap.VocoderBand),
      ParameterType('Emphasis',     parammap.OffOn),
      ParameterType('Monitor',      parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=112,
    height=2,
    longnm='Level Add',
    shortnm='LevAdd',
    page=PageType('Level', 3),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Level',        parammap.LevBipUni),
      ParameterType('BipUni',       parammap.BipUni),
    ],
    modes=[],
  ),
  ModuleType(
    type=113,
    height=2,
    longnm='Fade 1-2',
    shortnm='Fade1-2',
    page=PageType('Mixer', 14),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=6,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.blue_red,     horiz=17,vert=1),
      OutputType('Out2',         g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Mix',          parammap.Fade12Mix),
      ParameterType('MixMod',       parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=114,
    height=2,
    longnm='Fade 2-1',
    shortnm='Fade2-1',
    page=PageType('Mixer', 15),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=6,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Mix',          parammap.Fade21Mix),
      ParameterType('MixMod',       parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=115,
    height=3,
    longnm='Level Scaler',
    shortnm='LevScaler',
    page=PageType('Note', 7),
    inputs=[
      InputType('Note',         g2conncolors.blue,         horiz=0,vert=2),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Level',        g2conncolors.blue,         horiz=16,vert=2),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('L',            parammap.LevScaledB),
      ParameterType('BP',           parammap.FreqCoarse),
      ParameterType('R',            parammap.LevScaledB),
      ParameterType('Kbt',          parammap.Kbt_1),
    ],
    modes=[],
  ),
  ModuleType(
    type=116,
    height=2,
    longnm='Mix 8-1 A',
    shortnm='Mix8-1A',
    page=PageType('Mixer', 8),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=8,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=10,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('In6',          g2conncolors.blue_red,     horiz=13,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('In8',          g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Pad',          parammap.Pad_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=117,
    height=3,
    longnm='Level Modulator',
    shortnm='LevMod',
    page=PageType('Level', 7),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=2),
      InputType('Mod',          g2conncolors.blue_red,     horiz=16,vert=0),
      InputType('ModDepth',     g2conncolors.blue_red,     horiz=6,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('ModDepth',     parammap.Level_100),
      ParameterType('ModType',      parammap.LevModAmRm),
    ],
    modes=[],
  ),
  ModuleType(
    type=118,
    height=3,
    longnm='Digitizer',
    shortnm='Digitizer',
    page=PageType('FX', 3),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
      InputType('Rate',         g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=1,vert=2),
    ],
    params=[
      ParameterType('Bits',         parammap.DigitizerBits),
      ParameterType('Rate',         parammap.DigitizerRate),
      ParameterType('RateMod',      parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=119,
    height=5,
    longnm='Envelope ADDSR',
    shortnm='EnvADDSR',
    page=PageType('Env', 5),
    inputs=[
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('AM',           g2conncolors.blue,         horiz=0,vert=3),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=17,vert=3),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=3),
    ],
    params=[
      ParameterType('KB',           parammap.OffOn),
      ParameterType('Shape',        parammap.EnvShape_3),
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('Decay1',       parammap.EnvTime),
      ParameterType('Level1',       parammap.EnvLevel),
      ParameterType('Decay2',       parammap.EnvTime),
      ParameterType('Level2',       parammap.EnvLevel),
      ParameterType('Release',      parammap.EnvTime),
      ParameterType('SustainMode',  parammap.SustainMode_1),
      ParameterType('OutputType',   parammap.PosNegInvBipInv),
      ParameterType('NR',           parammap.EnvNR),
    ],
    modes=[],
  ),
  ModuleType(
    type=121,
    height=9,
    longnm='Sequencer Note',
    shortnm='SeqNote',
    page=PageType('Seq', 3),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=2),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=0,vert=4),
      InputType('Loop',         g2conncolors.yellow_orange,horiz=0,vert=6),
      InputType('Park',         g2conncolors.yellow_orange,horiz=16,vert=0),
      InputType('Note',         g2conncolors.blue_red,     horiz=0,vert=7),
      InputType('Trig',         g2conncolors.yellow_orange,horiz=0,vert=8),
      InputType('RecVal',       g2conncolors.blue_red,     horiz=7,vert=0),
      InputType('RecEnable',    g2conncolors.yellow_orange,horiz=8,vert=0),
    ],
    outputs=[
      OutputType('Link',         g2conncolors.yellow_orange,horiz=19,vert=1),
      OutputType('Note',         g2conncolors.blue_red,     horiz=19,vert=7),
      OutputType('Trig',         g2conncolors.yellow_orange,horiz=19,vert=8),
    ],
    params=[
      ParameterType('Seq1Step1',    parammap.FreqCoarse),
      ParameterType('Seq1Step2',    parammap.FreqCoarse),
      ParameterType('Seq1Step3',    parammap.FreqCoarse),
      ParameterType('Seq1Step4',    parammap.FreqCoarse),
      ParameterType('Seq1Step5',    parammap.FreqCoarse),
      ParameterType('Seq1Step6',    parammap.FreqCoarse),
      ParameterType('Seq1Step7',    parammap.FreqCoarse),
      ParameterType('Seq1Step8',    parammap.FreqCoarse),
      ParameterType('Seq1Step9',    parammap.FreqCoarse),
      ParameterType('Seq1Step10',   parammap.FreqCoarse),
      ParameterType('Seq1Step11',   parammap.FreqCoarse),
      ParameterType('Seq1Step12',   parammap.FreqCoarse),
      ParameterType('Seq1Step13',   parammap.FreqCoarse),
      ParameterType('Seq1Step14',   parammap.FreqCoarse),
      ParameterType('Seq1Step15',   parammap.FreqCoarse),
      ParameterType('Seq1Step16',   parammap.FreqCoarse),
      ParameterType('Seq2Step1',    parammap.OffOn),
      ParameterType('Seq2Step2',    parammap.OffOn),
      ParameterType('Seq2Step3',    parammap.OffOn),
      ParameterType('Seq2Step4',    parammap.OffOn),
      ParameterType('Seq2Step5',    parammap.OffOn),
      ParameterType('Seq2Step6',    parammap.OffOn),
      ParameterType('Seq2Step7',    parammap.OffOn),
      ParameterType('Seq2Step8',    parammap.OffOn),
      ParameterType('Seq2Step9',    parammap.OffOn),
      ParameterType('Seq2Step10',   parammap.OffOn),
      ParameterType('Seq2Step11',   parammap.OffOn),
      ParameterType('Seq2Step12',   parammap.OffOn),
      ParameterType('Seq2Step13',   parammap.OffOn),
      ParameterType('Seq2Step14',   parammap.OffOn),
      ParameterType('Seq2Step15',   parammap.OffOn),
      ParameterType('Seq2Step16',   parammap.OffOn),
      ParameterType('Loop',         parammap.LoopOnce),
      ParameterType('Length',       parammap.SeqLen),
      ParameterType('TG',           parammap.TrigGate),
      ParameterType('Clr_Or_Rnd',   parammap.OffOn),
      ParameterType('Rnd_Or_Clr',   parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=123,
    height=4,
    longnm='Mixer 4-1 C',
    shortnm='Mix4-1C',
    page=PageType('Mixer', 6),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=3,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=11,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=3),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('Lev3',         parammap.MixLevel),
      ParameterType('Lev4',         parammap.MixLevel),
      ParameterType('On1',          parammap.OffOn,
        labels=['Ch 1']
      ),
      ParameterType('On2',          parammap.OffOn,
        labels=['Ch 2']
      ),
      ParameterType('On3',          parammap.OffOn,
        labels=['Ch 3']
      ),
      ParameterType('On4',          parammap.OffOn,
        labels=['Ch 4']
      ),
      ParameterType('Pad',          parammap.Pad_2),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=124,
    height=2,
    longnm='Multiplexer 8-1',
    shortnm='Mux8-1',
    page=PageType('Switch', 13),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=4,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=11,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('In6',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('In8',          g2conncolors.blue_red,     horiz=17,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=125,
    height=2,
    longnm='Wah-Wah',
    shortnm='WahWah',
    page=PageType('Filter', 8),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('SweepMod',     parammap.Level_100),
      ParameterType('Sweep',        parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=126,
    height=1,
    longnm='Name Bar',
    shortnm='Name',
    page=PageType('In/Out', 10),
    inputs=[],
    outputs=[],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=127,
    height=2,
    longnm='Fx Input',
    shortnm='Fx-In',
    page=PageType('In/Out', 4),
    inputs=[],
    outputs=[
      OutputType('OutL',         g2conncolors.red,          horiz=16,vert=1),
      OutputType('OutR',         g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Source',       parammap.Source_1),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Pad',          parammap.Pad_4),
    ],
    modes=[],
  ),
  ModuleType(
    type=128,
    height=2,
    longnm='Min/Max Compare',
    shortnm='MinMax',
    page=PageType('Level', 12),
    inputs=[
      InputType('A',            g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('B',            g2conncolors.blue_red,     horiz=11,vert=1),
    ],
    outputs=[
      OutputType('Min',          g2conncolors.blue_red,     horiz=17,vert=1),
      OutputType('Max',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=130,
    height=2,
    longnm='Binary Counter',
    shortnm='BinCounter',
    page=PageType('Logic', 7),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=2,vert=1),
    ],
    outputs=[
      OutputType('Out001',       g2conncolors.yellow_orange,horiz=5,vert=1),
      OutputType('Out002',       g2conncolors.yellow_orange,horiz=7,vert=1),
      OutputType('Out004',       g2conncolors.yellow_orange,horiz=9,vert=1),
      OutputType('Out008',       g2conncolors.yellow_orange,horiz=11,vert=1),
      OutputType('Out016',       g2conncolors.yellow_orange,horiz=13,vert=1),
      OutputType('Out032',       g2conncolors.yellow_orange,horiz=15,vert=1),
      OutputType('Out064',       g2conncolors.yellow_orange,horiz=17,vert=1),
      OutputType('Out128',       g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=131,
    height=2,
    longnm='A/D Converter',
    shortnm='ADConv',
    page=PageType('Logic', 8),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('D0',           g2conncolors.yellow_orange,horiz=5,vert=1),
      OutputType('D1',           g2conncolors.yellow_orange,horiz=7,vert=1),
      OutputType('D2',           g2conncolors.yellow_orange,horiz=9,vert=1),
      OutputType('D3',           g2conncolors.yellow_orange,horiz=11,vert=1),
      OutputType('D4',           g2conncolors.yellow_orange,horiz=13,vert=1),
      OutputType('D5',           g2conncolors.yellow_orange,horiz=15,vert=1),
      OutputType('D6',           g2conncolors.yellow_orange,horiz=17,vert=1),
      OutputType('D7',           g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=132,
    height=2,
    longnm='D/A Converter',
    shortnm='DAConv',
    page=PageType('Logic', 9),
    inputs=[
      InputType('D0',           g2conncolors.yellow_orange,horiz=5,vert=1),
      InputType('D1',           g2conncolors.yellow_orange,horiz=7,vert=1),
      InputType('D2',           g2conncolors.yellow_orange,horiz=9,vert=1),
      InputType('D3',           g2conncolors.yellow_orange,horiz=11,vert=1),
      InputType('D4',           g2conncolors.yellow_orange,horiz=12,vert=1),
      InputType('D5',           g2conncolors.yellow_orange,horiz=13,vert=1),
      InputType('D6',           g2conncolors.yellow_orange,horiz=15,vert=1),
      InputType('D7',           g2conncolors.yellow_orange,horiz=17,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=134,
    height=2,
    longnm='Filter Highpass',
    shortnm='FltHP',
    page=PageType('Filter', 1),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
      InputType('Pitch',        g2conncolors.blue,         horiz=4,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Freq',         parammap.FltFreq),
      ParameterType('FreqMod',      parammap.Level_100),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('SlopeMode',    parammap.HpLpSlopeMode),
    ],
  ),
  ModuleType(
    type=139,
    height=2,
    longnm='Track & Hold',
    shortnm='T&H',
    page=PageType('Switch', 17),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=15,vert=1),
      InputType('Ctrl',         g2conncolors.yellow_orange,horiz=12,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=140,
    height=4,
    longnm='Mixer 4-1 Stereo',
    shortnm='Mix4-1S',
    page=PageType('Mixer', 7),
    inputs=[
      InputType('In1L',         g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('In1R',         g2conncolors.blue_red,     horiz=1,vert=1),
      InputType('In2L',         g2conncolors.blue_red,     horiz=4,vert=1),
      InputType('In2R',         g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In3L',         g2conncolors.blue_red,     horiz=8,vert=1),
      InputType('In3R',         g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In4L',         g2conncolors.blue_red,     horiz=13,vert=1),
      InputType('In4R',         g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('ChainL',       g2conncolors.blue_red,     horiz=17,vert=0),
      InputType('ChainR',       g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.blue_red,     horiz=17,vert=3),
      OutputType('OutR',         g2conncolors.blue_red,     horiz=19,vert=3),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('Lev3',         parammap.MixLevel),
      ParameterType('Lev4',         parammap.MixLevel),
      ParameterType('On1',          parammap.OffOn,
        labels=['Ch 1']
      ),
      ParameterType('On2',          parammap.OffOn,
        labels=['Ch 2']
      ),
      ParameterType('On3',          parammap.OffOn,
        labels=['Ch 3']
      ),
      ParameterType('On4',          parammap.OffOn,
        labels=['Ch 4']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=141,
    height=2,
    longnm='MIDI Control Send',
    shortnm='CtrlSend',
    page=PageType('MIDI', 0),
    inputs=[
      InputType('Send',         g2conncolors.yellow,       horiz=1,vert=1),
      InputType('Value',        g2conncolors.blue,         horiz=11,vert=1),
    ],
    outputs=[
      OutputType('Send',         g2conncolors.yellow,       horiz=4,vert=1),
    ],
    params=[
      ParameterType('Ctrl',         parammap.MidiData),
      ParameterType('Val',          parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_20),
    ],
    modes=[],
  ),
  ModuleType(
    type=142,
    height=2,
    longnm='MIDI Program Change Send',
    shortnm='PCSend',
    page=PageType('MIDI', 1),
    inputs=[
      InputType('Send',         g2conncolors.yellow,       horiz=1,vert=1),
      InputType('Program',      g2conncolors.blue,         horiz=11,vert=1),
    ],
    outputs=[
      OutputType('Send',         g2conncolors.yellow,       horiz=4,vert=1),
    ],
    params=[
      ParameterType('Program',      parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_16),
    ],
    modes=[],
  ),
  ModuleType(
    type=143,
    height=2,
    longnm='MIDI Note Send',
    shortnm='NoteSend',
    page=PageType('MIDI', 2),
    inputs=[
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=1),
      InputType('Vel',          g2conncolors.blue,         horiz=4,vert=1),
      InputType('Note',         g2conncolors.blue,         horiz=10,vert=1),
    ],
    outputs=[],
    params=[
      ParameterType('Vel',          parammap.MidiData),
      ParameterType('Note',         parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_20),
    ],
    modes=[],
  ),
  ModuleType(
    type=144,
    height=5,
    longnm='Seq Event',
    shortnm='SeqEvent',
    page=PageType('Seq', 0),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow,       horiz=0,vert=2),
      InputType('Loop',         g2conncolors.yellow,       horiz=0,vert=4),
      InputType('Park',         g2conncolors.yellow,       horiz=16,vert=0),
      InputType('Trig1',        g2conncolors.yellow,       horiz=1,vert=3),
      InputType('Trig2',        g2conncolors.yellow,       horiz=1,vert=4),
    ],
    outputs=[
      OutputType('Link',         g2conncolors.yellow,       horiz=19,vert=1),
      OutputType('Trig1',        g2conncolors.yellow_orange,horiz=19,vert=3),
      OutputType('Trig2',        g2conncolors.yellow_orange,horiz=19,vert=4),
    ],
    params=[
      ParameterType('Seq1Step1',    parammap.OffOn),
      ParameterType('Seq1Step2',    parammap.OffOn),
      ParameterType('Seq1Step3',    parammap.OffOn),
      ParameterType('Seq1Step4',    parammap.OffOn),
      ParameterType('Seq1Step5',    parammap.OffOn),
      ParameterType('Seq1Step6',    parammap.OffOn),
      ParameterType('Seq1Step7',    parammap.OffOn),
      ParameterType('Seq1Step8',    parammap.OffOn),
      ParameterType('Seq1Step9',    parammap.OffOn),
      ParameterType('Seq1Step10',   parammap.OffOn),
      ParameterType('Seq1Step11',   parammap.OffOn),
      ParameterType('Seq1Step12',   parammap.OffOn),
      ParameterType('Seq1Step13',   parammap.OffOn),
      ParameterType('Seq1Step14',   parammap.OffOn),
      ParameterType('Seq1Step15',   parammap.OffOn),
      ParameterType('Seq1Step16',   parammap.OffOn),
      ParameterType('Seq2Step1',    parammap.OffOn),
      ParameterType('Seq2Step2',    parammap.OffOn),
      ParameterType('Seq2Step3',    parammap.OffOn),
      ParameterType('Seq2Step4',    parammap.OffOn),
      ParameterType('Seq2Step5',    parammap.OffOn),
      ParameterType('Seq2Step6',    parammap.OffOn),
      ParameterType('Seq2Step7',    parammap.OffOn),
      ParameterType('Seq2Step8',    parammap.OffOn),
      ParameterType('Seq2Step9',    parammap.OffOn),
      ParameterType('Seq2Step10',   parammap.OffOn),
      ParameterType('Seq2Step11',   parammap.OffOn),
      ParameterType('Seq2Step12',   parammap.OffOn),
      ParameterType('Seq2Step13',   parammap.OffOn),
      ParameterType('Seq2Step14',   parammap.OffOn),
      ParameterType('Seq2Step15',   parammap.OffOn),
      ParameterType('Seq2Step16',   parammap.OffOn),
      ParameterType('Loop',         parammap.LoopOnce),
      ParameterType('Length',       parammap.SeqLen),
      ParameterType('TG1',          parammap.TrigGate),
      ParameterType('TG2',          parammap.TrigGate),
    ],
    modes=[],
  ),
  ModuleType(
    type=145,
    height=8,
    longnm='Sequencer Values',
    shortnm='SeqVal',
    page=PageType('Seq', 1),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow,       horiz=0,vert=3),
      InputType('Loop',         g2conncolors.yellow,       horiz=0,vert=4),
      InputType('Park',         g2conncolors.yellow,       horiz=16,vert=0),
      InputType('Val',          g2conncolors.blue_red,     horiz=0,vert=5),
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=7),
    ],
    outputs=[
      OutputType('Link',         g2conncolors.yellow,       horiz=19,vert=1),
      OutputType('Val',          g2conncolors.blue_red,     horiz=19,vert=5),
      OutputType('Trig',         g2conncolors.yellow_orange,horiz=19,vert=7),
    ],
    params=[
      ParameterType('Seq1Step1',    parammap.LevBipUni),
      ParameterType('Seq1Step2',    parammap.LevBipUni),
      ParameterType('Seq1Step3',    parammap.LevBipUni),
      ParameterType('Seq1Step4',    parammap.LevBipUni),
      ParameterType('Seq1Step5',    parammap.LevBipUni),
      ParameterType('Seq1Step6',    parammap.LevBipUni),
      ParameterType('Seq1Step7',    parammap.LevBipUni),
      ParameterType('Seq1Step8',    parammap.LevBipUni),
      ParameterType('Seq1Step9',    parammap.LevBipUni),
      ParameterType('Seq1Step10',   parammap.LevBipUni),
      ParameterType('Seq1Step11',   parammap.LevBipUni),
      ParameterType('Seq1Step12',   parammap.LevBipUni),
      ParameterType('Seq1Step13',   parammap.LevBipUni),
      ParameterType('Seq1Step14',   parammap.LevBipUni),
      ParameterType('Seq1Step15',   parammap.LevBipUni),
      ParameterType('Seq1Step16',   parammap.LevBipUni),
      ParameterType('Seq2Step1',    parammap.OffOn),
      ParameterType('Seq2Step2',    parammap.OffOn),
      ParameterType('Seq2Step3',    parammap.OffOn),
      ParameterType('Seq2Step4',    parammap.OffOn),
      ParameterType('Seq2Step5',    parammap.OffOn),
      ParameterType('Seq2Step6',    parammap.OffOn),
      ParameterType('Seq2Step7',    parammap.OffOn),
      ParameterType('Seq2Step8',    parammap.OffOn),
      ParameterType('Seq2Step9',    parammap.OffOn),
      ParameterType('Seq2Step10',   parammap.OffOn),
      ParameterType('Seq2Step11',   parammap.OffOn),
      ParameterType('Seq2Step12',   parammap.OffOn),
      ParameterType('Seq2Step13',   parammap.OffOn),
      ParameterType('Seq2Step14',   parammap.OffOn),
      ParameterType('Seq2Step15',   parammap.OffOn),
      ParameterType('Seq2Step16',   parammap.OffOn),
      ParameterType('Loop',         parammap.LoopOnce),
      ParameterType('Length',       parammap.SeqLen),
      ParameterType('BipUni',       parammap.BipUni),
      ParameterType('TG',           parammap.TrigGate),
      ParameterType('Clr_Or_Rnd',   parammap.OffOn),
      ParameterType('Rnd_Or_Clr',   parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=146,
    height=8,
    longnm='Sequencer Level',
    shortnm='SeqLev',
    page=PageType('Seq', 2),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=0,vert=3),
      InputType('Loop',         g2conncolors.yellow_orange,horiz=0,vert=4),
      InputType('Park',         g2conncolors.yellow_orange,horiz=16,vert=0),
      InputType('Val',          g2conncolors.blue_red,     horiz=0,vert=6),
      InputType('Trig',         g2conncolors.yellow_orange,horiz=0,vert=7),
    ],
    outputs=[
      OutputType('Link',         g2conncolors.yellow_orange,horiz=19,vert=1),
      OutputType('Val',          g2conncolors.blue_red,     horiz=19,vert=6),
      OutputType('Trig',         g2conncolors.yellow_orange,horiz=19,vert=7),
    ],
    params=[
      ParameterType('Seq1Step1',    parammap.LevBipUni),
      ParameterType('Seq1Step2',    parammap.LevBipUni),
      ParameterType('Seq1Step3',    parammap.LevBipUni),
      ParameterType('Seq1Step4',    parammap.LevBipUni),
      ParameterType('Seq1Step5',    parammap.LevBipUni),
      ParameterType('Seq1Step6',    parammap.LevBipUni),
      ParameterType('Seq1Step7',    parammap.LevBipUni),
      ParameterType('Seq1Step8',    parammap.LevBipUni),
      ParameterType('Seq1Step9',    parammap.LevBipUni),
      ParameterType('Seq1Step10',   parammap.LevBipUni),
      ParameterType('Seq1Step11',   parammap.LevBipUni),
      ParameterType('Seq1Step12',   parammap.LevBipUni),
      ParameterType('Seq1Step13',   parammap.LevBipUni),
      ParameterType('Seq1Step14',   parammap.LevBipUni),
      ParameterType('Seq1Step15',   parammap.LevBipUni),
      ParameterType('Seq1Step16',   parammap.LevBipUni),
      ParameterType('Seq2Step1',    parammap.OffOn),
      ParameterType('Seq2Step2',    parammap.OffOn),
      ParameterType('Seq2Step3',    parammap.OffOn),
      ParameterType('Seq2Step4',    parammap.OffOn),
      ParameterType('Seq2Step5',    parammap.OffOn),
      ParameterType('Seq2Step6',    parammap.OffOn),
      ParameterType('Seq2Step7',    parammap.OffOn),
      ParameterType('Seq2Step8',    parammap.OffOn),
      ParameterType('Seq2Step9',    parammap.OffOn),
      ParameterType('Seq2Step10',   parammap.OffOn),
      ParameterType('Seq2Step11',   parammap.OffOn),
      ParameterType('Seq2Step12',   parammap.OffOn),
      ParameterType('Seq2Step13',   parammap.OffOn),
      ParameterType('Seq2Step14',   parammap.OffOn),
      ParameterType('Seq2Step15',   parammap.OffOn),
      ParameterType('Seq2Step16',   parammap.OffOn),
      ParameterType('Loop',         parammap.LoopOnce),
      ParameterType('Length',       parammap.SeqLen),
      ParameterType('BipUni',       parammap.BipUni),
      ParameterType('TG',           parammap.TrigGate),
      ParameterType('Clr_Or_Rnd',   parammap.OffOn),
      ParameterType('Rnd_Or_Clr',   parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=147,
    height=2,
    longnm='MIDI Control Receive',
    shortnm='CtrlRcv',
    page=PageType('MIDI', 3),
    inputs=[],
    outputs=[
      OutputType('Rcv',          g2conncolors.yellow,       horiz=16,vert=1),
      OutputType('Val',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Ctrl',         parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_16),
    ],
    modes=[],
  ),
  ModuleType(
    type=148,
    height=2,
    longnm='MIDI Note Receive',
    shortnm='NoteRcv',
    page=PageType('MIDI', 4),
    inputs=[],
    outputs=[
      OutputType('Gate',         g2conncolors.yellow,       horiz=14,vert=1),
      OutputType('Vel',          g2conncolors.blue,         horiz=16,vert=1),
      OutputType('RelVel',       g2conncolors.blue,         horiz=18,vert=1),
    ],
    params=[
      ParameterType('Note',         parammap.MidiData),
      ParameterType('Ch',           parammap.MidiCh_17),
    ],
    modes=[],
  ),
  ModuleType(
    type=149,
    height=3,
    longnm='MIDI Note Zone',
    shortnm='NoteZone',
    page=PageType('MIDI', 5),
    inputs=[],
    outputs=[],
    params=[
      ParameterType('RcvCh',        parammap.MidiCh_17),
      ParameterType('RcvMin',       parammap.MidiData),
      ParameterType('RcvMax',       parammap.MidiData),
      ParameterType('SendTrans',    parammap.Bipolar_127),
      ParameterType('SendCh',       parammap.MidiCh_20),
      ParameterType('ThruMode',     parammap.NoteZoneThru),
    ],
    modes=[],
  ),
  ModuleType(
    type=150,
    height=5,
    longnm='Compressor',
    shortnm='Compressor',
    page=PageType('FX', 8),
    inputs=[
      InputType('InL',          g2conncolors.red,          horiz=18,vert=1),
      InputType('InR',          g2conncolors.red,          horiz=19,vert=1),
      InputType('SideChain',    g2conncolors.red,          horiz=5,vert=0),
    ],
    outputs=[
      OutputType('OutR',         g2conncolors.red,          horiz=18,vert=4),
      OutputType('OutL',         g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('Threshold',    parammap.Treshold_42),
      ParameterType('Ratio',        parammap.CompressorRatio),
      ParameterType('Attack',       parammap.CompressorAttack),
      ParameterType('Release',      parammap.CompressorRelease),
      ParameterType('RefLevel',     parammap.CompressorRefLevel),
      ParameterType('SideChain',    parammap.OffOn),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=152,
    height=2,
    longnm='Key Quantizer',
    shortnm='KeyQuant',
    page=PageType('Note', 1),
    inputs=[
      InputType('In',           g2conncolors.blue,         horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Range',        parammap.NoteRange),
      ParameterType('Capture',      parammap.KeyQuantCapture),
      ParameterType('E',            parammap.OffOn),
      ParameterType('F',            parammap.OffOn),
      ParameterType('F#',           parammap.OffOn),
      ParameterType('G',            parammap.OffOn),
      ParameterType('G#',           parammap.OffOn),
      ParameterType('A',            parammap.OffOn),
      ParameterType('A#',           parammap.OffOn),
      ParameterType('B',            parammap.OffOn),
      ParameterType('C',            parammap.OffOn),
      ParameterType('C#',           parammap.OffOn),
      ParameterType('D',            parammap.OffOn),
      ParameterType('D#',           parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=154,
    height=8,
    longnm='Sequencer Controlled',
    shortnm='SeqCtr',
    page=PageType('Seq', 4),
    inputs=[
      InputType('Ctrl',         g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('Val',          g2conncolors.blue_red,     horiz=0,vert=5),
      InputType('Trig',         g2conncolors.yellow_orange,horiz=0,vert=7),
    ],
    outputs=[
      OutputType('Val',          g2conncolors.blue_red,     horiz=19,vert=5),
      OutputType('Trig',         g2conncolors.yellow_orange,horiz=19,vert=7),
    ],
    params=[
      ParameterType('Seq1Step1',    parammap.LevBipUni),
      ParameterType('Seq1Step2',    parammap.LevBipUni),
      ParameterType('Seq1Step3',    parammap.LevBipUni),
      ParameterType('Seq1Step4',    parammap.LevBipUni),
      ParameterType('Seq1Step5',    parammap.LevBipUni),
      ParameterType('Seq1Step6',    parammap.LevBipUni),
      ParameterType('Seq1Step7',    parammap.LevBipUni),
      ParameterType('Seq1Step8',    parammap.LevBipUni),
      ParameterType('Seq1Step9',    parammap.LevBipUni),
      ParameterType('Seq1Step10',   parammap.LevBipUni),
      ParameterType('Seq1Step11',   parammap.LevBipUni),
      ParameterType('Seq1Step12',   parammap.LevBipUni),
      ParameterType('Seq1Step13',   parammap.LevBipUni),
      ParameterType('Seq1Step14',   parammap.LevBipUni),
      ParameterType('Seq1Step15',   parammap.LevBipUni),
      ParameterType('Seq1Step16',   parammap.LevBipUni),
      ParameterType('Seq2Step1',    parammap.OffOn),
      ParameterType('Seq2Step2',    parammap.OffOn),
      ParameterType('Seq2Step3',    parammap.OffOn),
      ParameterType('Seq2Step4',    parammap.OffOn),
      ParameterType('Seq2Step5',    parammap.OffOn),
      ParameterType('Seq2Step6',    parammap.OffOn),
      ParameterType('Seq2Step7',    parammap.OffOn),
      ParameterType('Seq2Step8',    parammap.OffOn),
      ParameterType('Seq2Step9',    parammap.OffOn),
      ParameterType('Seq2Step10',   parammap.OffOn),
      ParameterType('Seq2Step11',   parammap.OffOn),
      ParameterType('Seq2Step12',   parammap.OffOn),
      ParameterType('Seq2Step13',   parammap.OffOn),
      ParameterType('Seq2Step14',   parammap.OffOn),
      ParameterType('Seq2Step15',   parammap.OffOn),
      ParameterType('Seq2Step16',   parammap.OffOn),
      ParameterType('TG',           parammap.TrigGate),
      ParameterType('BipUni',       parammap.BipUni),
      ParameterType('XFade',        parammap.SeqCtrlXFade),
      ParameterType('Clr_Or_Rnd',   parammap.OffOn),
      ParameterType('Rnd_Or_Clr',   parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=156,
    height=2,
    longnm='Note Detector',
    shortnm='NoteDet',
    page=PageType('In/Out', 9),
    inputs=[],
    outputs=[
      OutputType('Gate',         g2conncolors.yellow,       horiz=13,vert=1),
      OutputType('Vel',          g2conncolors.blue,         horiz=16,vert=1),
      OutputType('RelVel',       g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Note',         parammap.FreqCoarse),
    ],
    modes=[],
  ),
  ModuleType(
    type=157,
    height=2,
    longnm='Level Converter',
    shortnm='LevConv',
    page=PageType('Level', 4),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('OutputType',   parammap.PosNegInvBipInv),
      ParameterType('InputType',    parammap.BipPosNeg),
    ],
    modes=[],
  ),
  ModuleType(
    type=158,
    height=2,
    longnm='Glide',
    shortnm='Glide',
    page=PageType('Note', 4),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('On',           g2conncolors.yellow_orange,horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Time',         parammap.GlideTime),
      ParameterType('Glide',        parammap.OffOn),
      ParameterType('Shape',        parammap.LogLin),
    ],
    modes=[],
  ),
  ModuleType(
    type=159,
    height=2,
    longnm='Compare to Signal',
    shortnm='CompSig',
    page=PageType('Level', 11),
    inputs=[
      InputType('A',            g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('B',            g2conncolors.blue_red,     horiz=11,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=160,
    height=2,
    longnm='Zero Crossing Counter',
    shortnm='ZeroCnt',
    page=PageType('Note', 6),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=161,
    height=9,
    longnm='Mixer 8-1 Fader',
    shortnm='MixFader',
    page=PageType('Mixer', 10),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=1,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=2,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('In5',          g2conncolors.blue_red,     horiz=10,vert=1),
      InputType('In6',          g2conncolors.blue_red,     horiz=12,vert=1),
      InputType('In7',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('In8',          g2conncolors.blue_red,     horiz=17,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=8),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('Lev3',         parammap.MixLevel),
      ParameterType('Lev4',         parammap.MixLevel),
      ParameterType('Lev5',         parammap.MixLevel),
      ParameterType('Lev6',         parammap.MixLevel),
      ParameterType('Lev7',         parammap.MixLevel),
      ParameterType('Lev8',         parammap.MixLevel),
      ParameterType('On1',          parammap.OffOn,
        labels=['Ch 1']
      ),
      ParameterType('On2',          parammap.OffOn,
        labels=['Ch 2']
      ),
      ParameterType('On3',          parammap.OffOn,
        labels=['Ch 3']
      ),
      ParameterType('On4',          parammap.OffOn,
        labels=['Ch 4']
      ),
      ParameterType('On5',          parammap.OffOn,
        labels=['Ch 5']
      ),
      ParameterType('On6',          parammap.OffOn,
        labels=['Ch 6']
      ),
      ParameterType('On7',          parammap.OffOn,
        labels=['Ch 7']
      ),
      ParameterType('On8',          parammap.OffOn,
        labels=['Ch 8']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_2),
      ParameterType('Pad',          parammap.Pad_3),
    ],
    modes=[],
  ),
  ModuleType(
    type=162,
    height=4,
    longnm='Filter Comb',
    shortnm='FltComb',
    page=PageType('Filter', 7),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('FB',           g2conncolors.blue,         horiz=9,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Freq',         parammap.Freq_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('FB',           parammap.Bipolar_127),
      ParameterType('FBMod',        parammap.Level_100),
      ParameterType('Type',         parammap.CombType),
      ParameterType('Lev',          parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=163,
    height=5,
    longnm='Osc Shape A',
    shortnm='OscShpA',
    page=PageType('Osc', 5),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=4),
      InputType('Sync',         g2conncolors.red,          horiz=0,vert=1),
      InputType('FmMod',        g2conncolors.red,          horiz=8,vert=3),
      InputType('ShapeMod',     g2conncolors.red,          horiz=14,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('FmAmount',     parammap.Level_100),
      ParameterType('FmMode',       parammap.FmLinTrk),
      ParameterType('Shape',        parammap.PW),
      ParameterType('ShapeMod',     parammap.Level_100),
      ParameterType('Waveform',     parammap.OscShpA_Waveform),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=164,
    height=5,
    longnm='Osc Dual',
    shortnm='OscDual',
    page=PageType('Osc', 7),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=3),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=4),
      InputType('Sync',         g2conncolors.red,          horiz=0,vert=1),
      InputType('PW',           g2conncolors.red,          horiz=9,vert=1),
      InputType('Phase',        g2conncolors.red,          horiz=9,vert=4),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('SqrLevel',     parammap.Level_100),
      ParameterType('PWMod',        parammap.Level_100),
      ParameterType('SawLevel',     parammap.Level_100),
      ParameterType('SawPhase',     parammap.Phase),
      ParameterType('SubOctLevel',  parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('SqrPW',        parammap.PW),
      ParameterType('PhaseMod',     parammap.Level_100),
      ParameterType('Soft',         parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=165,
    height=6,
    longnm='DX Style Router',
    shortnm='DXRouter',
    page=PageType('Osc', 15),
    inputs=[
      InputType('In1',          g2conncolors.red,          horiz=0,vert=5),
      InputType('In2',          g2conncolors.red,          horiz=2,vert=5),
      InputType('In3',          g2conncolors.red,          horiz=5,vert=5),
      InputType('In4',          g2conncolors.red,          horiz=9,vert=5),
      InputType('In5',          g2conncolors.red,          horiz=12,vert=5),
      InputType('In6',          g2conncolors.red,          horiz=15,vert=5),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.red,          horiz=1,vert=5),
      OutputType('Out2',         g2conncolors.red,          horiz=4,vert=5),
      OutputType('Out3',         g2conncolors.red,          horiz=7,vert=5),
      OutputType('Out4',         g2conncolors.red,          horiz=10,vert=5),
      OutputType('Out5',         g2conncolors.red,          horiz=13,vert=5),
      OutputType('Out6',         g2conncolors.red,          horiz=16,vert=5),
      OutputType('Main',         g2conncolors.red,          horiz=19,vert=5),
    ],
    params=[
      ParameterType('Algorithm',    parammap.DxAlgorithm),
      ParameterType('Feedback',     parammap.DxFeedback),
    ],
    modes=[],
  ),
  ModuleType(
    type=167,
    height=3,
    longnm='Pitch Shifter',
    shortnm='PShift',
    page=PageType('FX', 5),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Pitch',        g2conncolors.blue,         horiz=1,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('ShiftSemi',    parammap.PShiftCoarse),
      ParameterType('ShiftFine',    parammap.PShiftFine),
      ParameterType('ShiftMod',     parammap.Level_100),
      ParameterType('Delay',        parammap.ScratchDelay),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=169,
    height=5,
    longnm='Envelope Modulation AHD',
    shortnm='ModAHD',
    page=PageType('Env', 7),
    inputs=[
      InputType('Trig',         g2conncolors.yellow,       horiz=0,vert=2),
      InputType('AttackMod',    g2conncolors.blue,         horiz=4,vert=4),
      InputType('HoldMod',      g2conncolors.blue,         horiz=8,vert=4),
      InputType('DecayMod',     g2conncolors.blue,         horiz=12,vert=4),
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
      InputType('AM',           g2conncolors.blue,         horiz=0,vert=4),
    ],
    outputs=[
      OutputType('Env',          g2conncolors.blue,         horiz=18,vert=4),
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=4),
    ],
    params=[
      ParameterType('Attack',       parammap.EnvTime),
      ParameterType('Hold',         parammap.EnvTime),
      ParameterType('Decay',        parammap.EnvTime),
      ParameterType('AttackMod',    parammap.Level_100),
      ParameterType('HoldMod',      parammap.Level_100),
      ParameterType('DecayMod',     parammap.Level_100),
      ParameterType('OutputType',   parammap.PosNegInv),
      ParameterType('KB',           parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=170,
    height=2,
    longnm='2 inputs',
    shortnm='2-In',
    page=PageType('In/Out', 2),
    inputs=[],
    outputs=[
      OutputType('OutL',         g2conncolors.red,          horiz=17,vert=1),
      OutputType('OutR',         g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Source',       parammap.Source_2),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Pad',          parammap.Pad_4),
    ],
    modes=[],
  ),
  ModuleType(
    type=171,
    height=2,
    longnm='4 inputs',
    shortnm='4-In',
    page=PageType('In/Out', 3),
    inputs=[],
    outputs=[
      OutputType('Out1',         g2conncolors.red,          horiz=12,vert=1),
      OutputType('Out2',         g2conncolors.red,          horiz=14,vert=1),
      OutputType('Out3',         g2conncolors.red,          horiz=17,vert=1),
      OutputType('Out4',         g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Source',       parammap.Source_3),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Pad',          parammap.Pad_4),
    ],
    modes=[],
  ),
  ModuleType(
    type=172,
    height=2,
    longnm='Delay Static',
    shortnm='DlySingleA',
    page=PageType('Delay', 0),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Time',         parammap.DelayTime_3),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_3),
    ],
  ),
  ModuleType(
    type=173,
    height=2,
    longnm='Delay Single',
    shortnm='DlySingleB',
    page=PageType('Delay', 1),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
      InputType('Time',         g2conncolors.red,          horiz=7,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Time',         parammap.DelayTime_3),
      ParameterType('TimeMod',      parammap.Level_100),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_3),
    ],
  ),
  ModuleType(
    type=174,
    height=3,
    longnm='Delay Dual',
    shortnm='DelayDual',
    page=PageType('Delay', 2),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Time1',        g2conncolors.red,          horiz=7,vert=2),
      InputType('Time2',        g2conncolors.red,          horiz=13,vert=2),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.red,          horiz=10,vert=2),
      OutputType('Out2',         g2conncolors.red,          horiz=17,vert=2),
    ],
    params=[
      ParameterType('Time1',        parammap.DelayTime_3),
      ParameterType('Time1Mod',     parammap.Level_100),
      ParameterType('Time2',        parammap.DelayTime_3),
      ParameterType('Time2Mod',     parammap.Level_100),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_3),
    ],
  ),
  ModuleType(
    type=175,
    height=5,
    longnm='Delay Quad',
    shortnm='DelayQuad',
    page=PageType('Delay', 3),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('Time1',        g2conncolors.red,          horiz=3,vert=4),
      InputType('Time2',        g2conncolors.red,          horiz=7,vert=4),
      InputType('Time3',        g2conncolors.red,          horiz=11,vert=4),
      InputType('Time4',        g2conncolors.red,          horiz=15,vert=4),
    ],
    outputs=[
      OutputType('OutMain',      g2conncolors.red,          horiz=19,vert=4),
      OutputType('Out1',         g2conncolors.red,          horiz=5,vert=2),
      OutputType('Out2',         g2conncolors.red,          horiz=9,vert=2),
      OutputType('Out3',         g2conncolors.red,          horiz=13,vert=2),
      OutputType('Out4',         g2conncolors.red,          horiz=17,vert=2),
    ],
    params=[
      ParameterType('Time1',        parammap.DelayTime_3),
      ParameterType('Time1Mod',     parammap.Level_100),
      ParameterType('Time2',        parammap.DelayTime_3),
      ParameterType('Time2Mod',     parammap.Level_100),
      ParameterType('Time3',        parammap.DelayTime_3),
      ParameterType('Time3Mod',     parammap.Level_100),
      ParameterType('Time4',        parammap.DelayTime_3),
      ParameterType('Time4Mod',     parammap.Level_100),
      ParameterType('TimeClk',      parammap.TimeClk),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_3),
    ],
  ),
  ModuleType(
    type=176,
    height=3,
    longnm='Delay A',
    shortnm='DelayA',
    page=PageType('Delay', 7),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Time',         parammap.DelayTime_2),
      ParameterType('FB',           parammap.Level_100),
      ParameterType('Filter',       parammap.Level_100),
      ParameterType('DryWet',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('TimeClk',      parammap.TimeClk),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_2),
    ],
  ),
  ModuleType(
    type=177,
    height=4,
    longnm='Delay B',
    shortnm='DelayB',
    page=PageType('Delay', 8),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
      InputType('FBMod',        g2conncolors.blue_red,     horiz=9,vert=3),
      InputType('DryWetMod',    g2conncolors.blue_red,     horiz=15,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('Time',         parammap.DelayTime_2),
      ParameterType('FB',           parammap.Level_100),
      ParameterType('LP',           parammap.Level_100),
      ParameterType('DryWet',       parammap.Level_100),
      ParameterType('TimeClk',      parammap.TimeClk),
      ParameterType('FBMod',        parammap.Level_100),
      ParameterType('DryWetMod',    parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('HP',           parammap.Level_100),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_2),
    ],
  ),
  ModuleType(
    type=178,
    height=2,
    longnm='Delay Clocked',
    shortnm='DlyClock',
    page=PageType('Delay', 6),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Delay',        parammap.Range_128),
    ],
    modes=[],
  ),
  ModuleType(
    type=179,
    height=2,
    longnm='Shift Register',
    shortnm='DlyShiftReg',
    page=PageType('Delay', 5),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.blue_red,     horiz=7,vert=1),
      OutputType('Out2',         g2conncolors.blue_red,     horiz=9,vert=1),
      OutputType('Out3',         g2conncolors.blue_red,     horiz=11,vert=1),
      OutputType('Out4',         g2conncolors.blue_red,     horiz=12,vert=1),
      OutputType('Out5',         g2conncolors.blue_red,     horiz=14,vert=1),
      OutputType('Out6',         g2conncolors.blue_red,     horiz=15,vert=1),
      OutputType('Out7',         g2conncolors.blue_red,     horiz=17,vert=1),
      OutputType('Out8',         g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=180,
    height=12,
    longnm='FM Operator',
    shortnm='Operator',
    page=PageType('Osc', 14),
    inputs=[
      InputType('Freq',         g2conncolors.blue,         horiz=0,vert=3),
      InputType('FM',           g2conncolors.red,          horiz=19,vert=1),
      InputType('Gate',         g2conncolors.yellow,       horiz=0,vert=5),
      InputType('Note',         g2conncolors.blue,         horiz=0,vert=6),
      InputType('AMod',         g2conncolors.blue,         horiz=0,vert=9),
      InputType('Vel',          g2conncolors.blue,         horiz=0,vert=11),
      InputType('Pitch',        g2conncolors.blue,         horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=11),
    ],
    params=[
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('Sync',         parammap.OffOn,
        labels=['Switch']
      ),
      ParameterType('RatioFixed',   parammap.RatioFixed),
      ParameterType('FreqCoarse',   parammap.OpFreqCoarse),
      ParameterType('FreqFine',     parammap.OpFreqFine),
      ParameterType('FreqDetune',   parammap.OpFreqDetune),
      ParameterType('Vel',          parammap.OpVel),
      ParameterType('RateScale',    parammap.OpRateScale),
      ParameterType('R1',           parammap.OpTime),
      ParameterType('L1',           parammap.OpLevel),
      ParameterType('R2',           parammap.OpTime),
      ParameterType('L2',           parammap.OpLevel),
      ParameterType('R3',           parammap.OpTime),
      ParameterType('L3',           parammap.OpLevel),
      ParameterType('R4',           parammap.OpTime),
      ParameterType('L4',           parammap.OpLevel),
      ParameterType('AMod',         parammap.OpAmod),
      ParameterType('BrPoint',      parammap.OpBrPpoint),
      ParameterType('LDepthMode',   parammap.OpDepthMode),
      ParameterType('LDepth',       parammap.OpDepth),
      ParameterType('RDepthMode',   parammap.OpDepthMode),
      ParameterType('RDepth',       parammap.OpDepth),
      ParameterType('OutLevel',     parammap.OpLevel),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('EnvKB',        parammap.OffOn),
    ],
    modes=[],
  ),
  ModuleType(
    type=181,
    height=3,
    longnm='Delay 8 Tap',
    shortnm='DlyEight',
    page=PageType('Delay', 4),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out1',         g2conncolors.red,          horiz=7,vert=2),
      OutputType('Out2',         g2conncolors.red,          horiz=9,vert=2),
      OutputType('Out3',         g2conncolors.red,          horiz=10,vert=2),
      OutputType('Out4',         g2conncolors.red,          horiz=12,vert=2),
      OutputType('Out5',         g2conncolors.red,          horiz=14,vert=2),
      OutputType('Out6',         g2conncolors.red,          horiz=16,vert=2),
      OutputType('Out7',         g2conncolors.red,          horiz=17,vert=2),
      OutputType('Out8',         g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('Time',         parammap.DelayTime_3),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_3),
    ],
  ),
  ModuleType(
    type=182,
    height=5,
    longnm='Delay Stereo',
    shortnm='DlyStereo',
    page=PageType('Delay', 9),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=19,vert=0),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.red,          horiz=17,vert=4),
      OutputType('OutR',         g2conncolors.red,          horiz=19,vert=4),
    ],
    params=[
      ParameterType('TimeLeft',     parammap.DelayTime_1),
      ParameterType('TimeRight',    parammap.DelayTime_1),
      ParameterType('FBLeft',       parammap.Level_100),
      ParameterType('FBRight',      parammap.Level_100),
      ParameterType('XFBLeft',      parammap.Level_100),
      ParameterType('XFBRight',     parammap.Level_100),
      ParameterType('TimeClk',      parammap.TimeClk),
      ParameterType('LP',           parammap.Level_100),
      ParameterType('DryWet',       parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('HP',           parammap.Level_100),
    ],
    modes=[
      ModeType('DelayRange',   parammap.DelayRange_1),
    ],
  ),
  ModuleType(
    type=183,
    height=3,
    longnm='Osc Phase Mod',
    shortnm='OscPM',
    page=PageType('Osc', 4),
    inputs=[
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('Sync',         g2conncolors.red,          horiz=12,vert=2),
      InputType('PhaseMod',     g2conncolors.red,          horiz=14,vert=2),
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=2),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('PhaseMod',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('PitchVar',     parammap.Level_100),
    ],
    modes=[
      ModeType('Waveform',     parammap.OscWaveform_1),
    ],
  ),
  ModuleType(
    type=184,
    height=2,
    longnm='Mixer 1-1 A',
    shortnm='Mix1-1A',
    page=PageType('Mixer', 0),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev',          parammap.MixLevel),
      ParameterType('On',           parammap.OffOn,
        labels=['Ch 1']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=185,
    height=2,
    longnm='Mixer 1-1 Stereo',
    shortnm='Mix1-1S',
    page=PageType('Mixer', 1),
    inputs=[
      InputType('InL',          g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('InR',          g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('LChain',       g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('RChain',       g2conncolors.blue_red,     horiz=1,vert=1),
    ],
    outputs=[
      OutputType('OutL',         g2conncolors.blue_red,     horiz=17,vert=1),
      OutputType('OutR',         g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev',          parammap.MixLevel),
      ParameterType('On',           parammap.OffOn,
        labels=['Ch 2']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=186,
    height=2,
    longnm='Switch 1-2 Momentary',
    shortnm='Sw1-2M',
    page=PageType('Switch', 6),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=14,vert=1),
    ],
    outputs=[
      OutputType('OutOn',        g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('OutOff',       g2conncolors.blue_red,     horiz=16,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('Sel',          parammap.OffOn,
        labels=['Switch']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=187,
    height=2,
    longnm='Switch 2-1 Momentary',
    shortnm='Sw2-1M',
    page=PageType('Switch', 2),
    inputs=[
      InputType('InOff',        g2conncolors.blue_red,     horiz=14,vert=1),
      InputType('InOn',         g2conncolors.blue_red,     horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
      OutputType('Ctrl',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    params=[
      ParameterType('Sel',          parammap.OffOn,
        labels=['Switch']
      ),
    ],
    modes=[],
  ),
  ModuleType(
    type=188,
    height=2,
    longnm='Constant Switch Momentary',
    shortnm='ConstSwM',
    page=PageType('Level', 1),
    inputs=[],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev',          parammap.LevBipUni),
      ParameterType('On',           parammap.OffOn),
      ParameterType('BipUni',       parammap.BipUni),
    ],
    modes=[],
  ),
  ModuleType(
    type=189,
    height=3,
    longnm='Noise Gate',
    shortnm='NoiseGate',
    page=PageType('Level', 9),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=19,vert=0),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
      OutputType('Env',          g2conncolors.blue,         horiz=17,vert=2),
    ],
    params=[
      ParameterType('Treshold',     parammap.Treshold_127),
      ParameterType('Attack',       parammap.NoiseGateAttack),
      ParameterType('Release',      parammap.NoiseGateRelease),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=190,
    height=4,
    longnm='LFO B',
    shortnm='LfoB',
    page=PageType('LFO', 1),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=1,vert=3),
      InputType('RateVar',      g2conncolors.blue,         horiz=3,vert=3),
      InputType('Rst',          g2conncolors.blue,         horiz=0,vert=1),
      InputType('Phase',        g2conncolors.blue,         horiz=10,vert=3),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=3),
      OutputType('Sync',         g2conncolors.blue,         horiz=0,vert=3),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_4),
      ParameterType('RateMod',      parammap.Level_100),
      ParameterType('Range',        parammap.LfoRange_4),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('Waveform',     parammap.LfoB_Waveform),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('Phase',        parammap.Phase),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('OutputType',   parammap.OutTypeLfo),
      ParameterType('PhaseMod',     parammap.Level_100),
    ],
    modes=[],
  ),
  ModuleType(
    type=192,
    height=2,
    longnm='Phaser',
    shortnm='Phaser',
    page=PageType('FX', 1),
    inputs=[
      InputType('In',           g2conncolors.red,          horiz=16,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=1),
    ],
    params=[
      ParameterType('Type',         parammap.PhaserType),
      ParameterType('Freq',         parammap.PhaserFreq),
      ParameterType('FeedBack',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=193,
    height=2,
    longnm='Mixer 4-1 A',
    shortnm='Mix4-1A',
    page=PageType('Mixer', 4),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=5,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=8,vert=1),
      InputType('In3',          g2conncolors.blue_red,     horiz=11,vert=1),
      InputType('In4',          g2conncolors.blue_red,     horiz=15,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=194,
    height=2,
    longnm='Mixer 2-1 A',
    shortnm='Mix2-1A',
    page=PageType('Mixer', 2),
    inputs=[
      InputType('In1',          g2conncolors.blue_red,     horiz=9,vert=1),
      InputType('In2',          g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Chain',        g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('Lev1',         parammap.MixLevel),
      ParameterType('On1',          parammap.OffOn,
        labels=['Ch 1']
      ),
      ParameterType('Lev2',         parammap.MixLevel),
      ParameterType('On2',          parammap.OffOn,
        labels=['Ch 2']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_2),
    ],
    modes=[],
  ),
  ModuleType(
    type=195,
    height=2,
    longnm='Modulation Amount',
    shortnm='ModAmt',
    page=PageType('Level', 13),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=16,vert=1),
      InputType('Mod',          g2conncolors.blue_red,     horiz=15,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('ModDepth',     parammap.Level_100),
      ParameterType('On',           parammap.OffOn,
        labels=['On']
      ),
      ParameterType('ExpLin',       parammap.ExpLin_1),
      ParameterType('InvertMode',   parammap.ModAmtInvert),
    ],
    modes=[],
  ),
  ModuleType(
    type=196,
    height=3,
    longnm='Osc Percussion',
    shortnm='OscPerc',
    page=PageType('Osc', 11),
    inputs=[
      InputType('Pitch',        g2conncolors.blue_red,     horiz=0,vert=1),
      InputType('PitchVar',     g2conncolors.blue_red,     horiz=0,vert=2),
      InputType('Trig',         g2conncolors.red,          horiz=3,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.red,          horiz=19,vert=3),
    ],
    params=[
      ParameterType('FreqCoarse',   parammap.FreqCoarse),
      ParameterType('FreqFine',     parammap.FreqFine),
      ParameterType('FreqMode',     parammap.FreqMode_3),
      ParameterType('Kbt',          parammap.Kbt_1),
      ParameterType('PitchMod',     parammap.Level_100),
      ParameterType('Decay',        parammap.Level_100),
      ParameterType('Click',        parammap.Level_100),
      ParameterType('Punch',        parammap.OffOn),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=197,
    height=2,
    longnm='Status',
    shortnm='Status',
    page=PageType('In/Out', 8),
    inputs=[],
    outputs=[
      OutputType('PatchActive',  g2conncolors.yellow,       horiz=8,vert=1),
      OutputType('VarActive',    g2conncolors.yellow,       horiz=13,vert=1),
      OutputType('VoiceNo',      g2conncolors.blue,         horiz=18,vert=1),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    type=198,
    height=2,
    longnm='Pitch Tracker',
    shortnm='PitchTrack',
    page=PageType('Note', 5),
    inputs=[
      InputType('In',           g2conncolors.blue_red,     horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Period',       g2conncolors.yellow_orange,horiz=13,vert=1),
      OutputType('Gate',         g2conncolors.yellow_orange,horiz=15,vert=1),
      OutputType('Pitch',        g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Treshold',     parammap.Treshold_127),
    ],
    modes=[],
  ),
  ModuleType(
    type=199,
    height=2,
    longnm='Monophonic Keyboard',
    shortnm='MonoKey',
    page=PageType('In/Out', 6),
    inputs=[],
    outputs=[
      OutputType('Pitch',        g2conncolors.blue,         horiz=14,vert=1),
      OutputType('Gate',         g2conncolors.yellow,       horiz=16,vert=1),
      OutputType('Vel',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Mode',         parammap.MonoKeyMode),
    ],
    modes=[],
  ),
  ModuleType(
    type=200,
    height=2,
    longnm='Random A',
    shortnm='RandomA',
    page=PageType('Rnd', 0),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=0,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=1),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_3),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('OutputType',   parammap.BipPosNeg),
      ParameterType('Range',        parammap.LfoRange_3),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('Edge',         parammap.RndEdge),
      ParameterType('StepProb',     parammap.RandomAStepProb),
    ],
    modes=[],
  ),
  ModuleType(
    type=202,
    height=3,
    longnm='Random B',
    shortnm='RandomB',
    page=PageType('Rnd', 1),
    inputs=[
      InputType('Rate',         g2conncolors.blue,         horiz=0,vert=1),
      InputType('RateVar',      g2conncolors.blue,         horiz=0,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue,         horiz=19,vert=2),
    ],
    params=[
      ParameterType('Rate',         parammap.LfoRate_3),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('Kbt',          parammap.Kbt_4),
      ParameterType('RateMod',      parammap.Level_100),
      ParameterType('StepProb',     parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('OutputType',   parammap.BipPosNeg),
      ParameterType('Range',        parammap.LfoRange_3),
      ParameterType('Edge',         parammap.RndEdge),
    ],
    modes=[],
  ),
  ModuleType(
    type=204,
    height=2,
    longnm='Random Clock A',
    shortnm='RndClkA',
    page=PageType('Rnd', 2),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=4,vert=1),
      InputType('Seed',         g2conncolors.blue_red,     horiz=7,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=1),
    ],
    params=[
      ParameterType('StepProb',     parammap.Level_100),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('Dice',         parammap.OffOn),
      ParameterType('OutputType',   parammap.BipPosNeg),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[],
  ),
  ModuleType(
    type=205,
    height=2,
    longnm='Random Trig',
    shortnm='RndTrig',
    page=PageType('Rnd', 4),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=4,vert=1),
      InputType('Seed',         g2conncolors.blue_red,     horiz=7,vert=1),
      InputType('Prob',         g2conncolors.blue_red,     horiz=8,vert=1),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.yellow_orange,horiz=19,vert=1),
    ],
    params=[
      ParameterType('StepProb',     parammap.Level_100),
      ParameterType('StepProbMod',  parammap.Level_100),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('PolyMono',     parammap.PolyMono),
    ],
    modes=[],
  ),
  ModuleType(
    type=206,
    height=3,
    longnm='Random Clock B',
    shortnm='RndClkB',
    page=PageType('Rnd', 3),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=0,vert=2),
      InputType('Seed',         g2conncolors.blue_red,     horiz=3,vert=2),
      InputType('Step',         g2conncolors.blue,         horiz=11,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('StepProb',     parammap.Level_100),
      ParameterType('OutputType',   parammap.BipPosNeg),
      ParameterType('Active',       parammap.ActiveMonitor),
      ParameterType('PolyMono',     parammap.PolyMono),
      ParameterType('StepProbMod',  parammap.Level_100),
    ],
    modes=[
      ModeType('Character',    parammap.Rnd_1),
    ],
  ),
  ModuleType(
    type=208,
    height=3,
    longnm='Random Pattern',
    shortnm='RndPattern',
    page=PageType('Rnd', 5),
    inputs=[
      InputType('Clk',          g2conncolors.yellow_orange,horiz=0,vert=1),
      InputType('Rst',          g2conncolors.yellow_orange,horiz=0,vert=2),
      InputType('A',            g2conncolors.blue,         horiz=3,vert=1),
      InputType('B',            g2conncolors.blue,         horiz=3,vert=2),
      InputType('StepProb',     g2conncolors.blue,         horiz=9,vert=2),
    ],
    outputs=[
      OutputType('Out',          g2conncolors.blue_red,     horiz=19,vert=2),
    ],
    params=[
      ParameterType('PatternA',     parammap.RangeBip_128),
      ParameterType('PatternB',     parammap.Level_100),
      ParameterType('StepProb',     parammap.RangeBip_128),
      ParameterType('LoopCount',    parammap.Range_128),
      ParameterType('StepProbMod',  parammap.Level_100),
      ParameterType('OutputType',   parammap.BipPosNeg),
      ParameterType('Active',       parammap.ActiveMonitor),
    ],
    modes=[
      ModeType('Waveform',     parammap.RndStepPulse),
    ],
  ),
]

fromtype = {}
fromname = {}
modulemap = ModuleMap()
for module in modules:
  fromname[module.shortnm] = module
  fromtype[module.type] = module
  name = module.shortnm.replace('-','_').replace('&','n')
  setattr(modulemap, name, module)

if __name__ == '__main__':
  for module in modules:
    print '%s.type: %d(0x%02x)' % (module.shortnm, module.type, module.type)
    for i in range(len(module.inputs)):
      input = module.inputs[i]
      print ' .inputs[%d] .%s' % (i, input.name)
    for i in range(len(module.outputs)):
      output = module.outputs[i]
      print ' .outputs[%d] .%s' % (i, output.name)
    for i in range(len(module.params)):
      param = module.params[i]
      print ' .params[%d] .%s' % (i, param.name)
    for i in range(len(module.modes)):
      mode = module.modes[i]
      print ' .modes[%d] .%s' % (i, mode.name)
