#!/usr/bin/env python

from nord.types import *
from nord.nm1.colors import nm1conncolors

class ParameterDef(Struct): pass

class ModuleMap(Struct): pass

audio,control,logic,slave = range(4)

modules = [
  ModuleType(
    shortnm='Keyboard',
    type=1,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Note',         nm1conncolors.control),
      OutputType('Gate',         nm1conncolors.logic),
      OutputType('VelocityOn',   nm1conncolors.control),
      OutputType('VelocityOff',  nm1conncolors.control),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='AudioIn',
    type=2,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Left',         nm1conncolors.audio),
      OutputType('Right',        nm1conncolors.audio),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='4Output',
    type=3,
    height=3,
    inputs=[
      InputType('Out1',         nm1conncolors.audio),
      InputType('Out2',         nm1conncolors.audio),
      InputType('Out3',         nm1conncolors.audio),
      InputType('Out4',         nm1conncolors.audio),
    ],
    outputs=[],
    params=[
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='2Output',
    type=4,
    height=3,
    inputs=[
      InputType('OutLeft',      nm1conncolors.audio),
      InputType('OutRight',     nm1conncolors.audio),
    ],
    outputs=[],
    params=[
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Destination',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='2destination'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='1Output',
    type=5,
    height=3,
    inputs=[
      InputType('Out',          nm1conncolors.audio),
    ],
    outputs=[],
    params=[
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Destination',
        ParameterDef(  
          default=0,
          low=0,
          high=5,
          comment='1destination'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='OscA',
    type=7,
    height=6,
    inputs=[
      InputType('Sync',         nm1conncolors.audio),
      InputType('FmMod',        nm1conncolors.audio),
      InputType('PitchMod1',    nm1conncolors.audio),
      InputType('PitchMod2',    nm1conncolors.audio),
      InputType('PwMod',        nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('PulseWidth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='pulsewidth'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment='waveform1'
        ),
      ),
      ParameterType('PitchMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PwMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscB',
    type=8,
    height=6,
    inputs=[
      InputType('FmMod',        nm1conncolors.audio),
      InputType('PitchMod1',    nm1conncolors.control),
      InputType('PitchMod2',    nm1conncolors.control),
      InputType('PwMod',        nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment='waveform1'
        ),
      ),
      ParameterType('PitchMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PwMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='pulsewidth'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscC',
    type=9,
    height=4,
    inputs=[
      InputType('FmMod',        nm1conncolors.audio),
      InputType('Pitch',        nm1conncolors.audio),
      InputType('Am',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('FreqMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscSlvB',
    type=10,
    height=3,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('PwMod',        nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('PulseWidth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='pulsewidth'
        ),
      ),
      ParameterType('PwMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=2,
          default=2,
          high=0,
          comment='freqdisplunits3'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscSlvC',
    type=11,
    height=3,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('FmMod',        nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=2,
          default=2,
          high=0,
          comment='freqdisplunits3'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscSlvD',
    type=12,
    height=3,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('FmMod',        nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=2,
          default=2,
          high=0,
          comment='freqdisplunits3'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscSlvE',
    type=13,
    height=3,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('FmMod',        nm1conncolors.audio),
      InputType('Am',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=2,
          default=2,
          high=0,
          comment='freqdisplunits3'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='OscSlvA',
    type=14,
    height=4,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('FmMod',        nm1conncolors.audio),
      InputType('Am',           nm1conncolors.audio),
      InputType('Sync',         nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment=''
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=2,
          default=2,
          high=0,
          comment='freqdisplunits3'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='NoteSeqA',
    type=15,
    height=7,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Reset',        nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
      OutputType('Snc',          nm1conncolors.logic),
      OutputType('Link',         nm1conncolors.logic),
      OutputType('Gclk',         nm1conncolors.logic),
    ],
    params=[
      ParameterType('Note1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note5',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note6',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note7',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note8',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note9',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note10',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note11',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note12',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note13',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note14',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note15',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Note16',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Length',
        ParameterDef(  
          default=0,
          low=0,
          high=15,
          comment=''
        ),
      ),
      ParameterType('EditPosition',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='editpos'
        ),
      ),
      ParameterType('Record',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Pause',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Loop',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PortamentoB',
    type=16,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
      InputType('Jmp',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='EventSeq',
    type=17,
    height=5,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Rst',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out1',         nm1conncolors.logic),
      OutputType('Out2',         nm1conncolors.logic),
      OutputType('Snc',          nm1conncolors.logic),
      OutputType('Link',         nm1conncolors.logic),
    ],
    params=[
      ParameterType('Length',
        ParameterDef(  
          default=0,
          low=0,
          high=15,
          comment=''
        ),
      ),
      ParameterType('Loop',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Gate1',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Gate2',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step1',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step2',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step3',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step4',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step5',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step6',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step7',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step8',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step9',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step10',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step11',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step12',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step13',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step14',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step15',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq1Step16',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step1',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step2',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step3',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step4',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step5',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step6',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step7',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step8',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step9',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step10',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step11',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step12',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step13',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step14',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step15',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Seq2Step16',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='X-Fade',
    type=18,
    height=3,
    inputs=[
      InputType('In1',          nm1conncolors.audio),
      InputType('In2',          nm1conncolors.audio),
      InputType('MixMod',       nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('MixMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mix',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='3Mixer',
    type=19,
    height=2,
    inputs=[
      InputType('In1',          nm1conncolors.audio),
      InputType('In2',          nm1conncolors.audio),
      InputType('In3',          nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Lev1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='ADSR-Env',
    type=20,
    height=5,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('Gate',         nm1conncolors.logic),
      InputType('Retrig',       nm1conncolors.logic),
      InputType('Amp',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Env',          nm1conncolors.control),
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('AttackShape',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='adsrshape'
        ),
      ),
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Decay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Sustain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Release',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Invert',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Compressor',
    type=21,
    height=7,
    inputs=[
      InputType('Left',         nm1conncolors.audio),
      InputType('Right',        nm1conncolors.audio),
      InputType('Side',         nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Left',         nm1conncolors.audio),
      OutputType('Right',        nm1conncolors.audio),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='companderattack'
        ),
      ),
      ParameterType('Release',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='companderrelease'
        ),
      ),
      ParameterType('Threshold',
        ParameterDef(  
          default=0,
          low=0,
          high=42,
          comment='compandertreshold'
        ),
      ),
      ParameterType('Ratio',
        ParameterDef(  
          default=0,
          low=0,
          high=66,
          comment='companderratio'
        ),
      ),
      ParameterType('RefLevel',
        ParameterDef(  
          default=0,
          low=0,
          high=42,
          comment='companderref'
        ),
      ),
      ParameterType('Limiter',
        ParameterDef(  
          default=0,
          low=0,
          high=24,
          comment='companderlimit'
        ),
      ),
      ParameterType('Act',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mon',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PartialGen',
    type=22,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Mod-Env',
    type=23,
    height=6,
    inputs=[
      InputType('Gate',         nm1conncolors.logic),
      InputType('Retrig',       nm1conncolors.logic),
      InputType('AttackMod',    nm1conncolors.control),
      InputType('DecayMod',     nm1conncolors.control),
      InputType('SustainMod',   nm1conncolors.control),
      InputType('ReleaseMod',   nm1conncolors.control),
      InputType('In',           nm1conncolors.audio),
      InputType('Amp',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Env',          nm1conncolors.control),
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Decay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Sustain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Release',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('AttackMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('DecayMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('SustainMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('ReleaseMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Invert',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LFOA',
    type=24,
    height=5,
    inputs=[
      InputType('Rate',         nm1conncolors.control),
      InputType('Reset',        nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Slv',          nm1conncolors.slave),
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lforate'
        ),
      ),
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='lforange'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=4,
          comment='lfoshape'
        ),
      ),
      ParameterType('RateMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('Phase',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='phase'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LFOB',
    type=25,
    height=5,
    inputs=[
      InputType('Rate',         nm1conncolors.control),
      InputType('Rst',          nm1conncolors.logic),
      InputType('Pwmod',        nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lforate'
        ),
      ),
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='lforange'
        ),
      ),
      ParameterType('Phase',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='phase'
        ),
      ),
      ParameterType('RateMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('PwMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Pw',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='pulsewidth'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LFOC',
    type=26,
    height=4,
    inputs=[
      InputType('Rate',         nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lforate'
        ),
      ),
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='lforange'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=4,
          comment='lfoshape'
        ),
      ),
      ParameterType('RateMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LFOSlvB',
    type=27,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunitslfo'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='LFOSlvC',
    type=28,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunitslfo'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='LFOSlvD',
    type=29,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunitslfo'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='LFOSlvE',
    type=30,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunitslfo'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='Noise',
    type=31,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Color',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='noisecolor'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='FilterBank',
    type=32,
    height=7,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('50',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('75',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('110',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('170',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('250',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('380',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('570',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('850',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('1.3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('1.9',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('2.9',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('4.2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('6.4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('8.3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='ClkRndGen',
    type=33,
    height=2,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Color',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='RndStepGen',
    type=34,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='RndPulsGen',
    type=35,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Density',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PosEdgeDelay',
    type=36,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='logictime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LogicDelay',
    type=37,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='logictime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Pulse',
    type=38,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='logictime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Smooth',
    type=39,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='smoothtime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='8Mixer',
    type=40,
    height=4,
    inputs=[
      InputType('In1',          nm1conncolors.audio),
      InputType('In2',          nm1conncolors.audio),
      InputType('In3',          nm1conncolors.audio),
      InputType('In4',          nm1conncolors.audio),
      InputType('In5',          nm1conncolors.audio),
      InputType('In6',          nm1conncolors.audio),
      InputType('In7',          nm1conncolors.audio),
      InputType('In8',          nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Lev1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev5',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev6',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev7',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Lev8',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('-6Db',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Constant',
    type=43,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Value',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Unipolar',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='GainControl',
    type=44,
    height=2,
    inputs=[
      InputType('Control',      nm1conncolors.audio),
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Shift',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='VocalFilter',
    type=45,
    height=5,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('VowelMod',     nm1conncolors.control),
      InputType('FrequencyMod', nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Vowel1',
        ParameterDef(  
          default=0,
          low=0,
          high=8,
          comment='vowel'
        ),
      ),
      ParameterType('Vowel2',
        ParameterDef(  
          default=0,
          low=0,
          high=8,
          comment='vowel'
        ),
      ),
      ParameterType('Vowel3',
        ParameterDef(  
          default=0,
          low=0,
          high=8,
          comment='vowel'
        ),
      ),
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Vowel',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symeteric'
        ),
      ),
      ParameterType('VowelMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('FreqMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Res',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='AHD-Env',
    type=46,
    height=5,
    inputs=[
      InputType('Trig',         nm1conncolors.logic),
      InputType('AttackMod',    nm1conncolors.control),
      InputType('HoldMod',      nm1conncolors.control),
      InputType('DecayMod',     nm1conncolors.control),
      InputType('In',           nm1conncolors.audio),
      InputType('Amp',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Env',          nm1conncolors.control),
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Hold',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Decay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('AttackMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('HoldMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('DecayMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Pan',
    type=47,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('Panmod',       nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Outl',         nm1conncolors.audio),
      OutputType('Outr',         nm1conncolors.audio),
    ],
    params=[
      ParameterType('PanMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Pan',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PortamentoA',
    type=48,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
      InputType('On',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='FilterD',
    type=49,
    height=5,
    inputs=[
      InputType('FreqMod',      nm1conncolors.control),
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Hp',           nm1conncolors.audio),
      OutputType('Bp',           nm1conncolors.audio),
      OutputType('Lp',           nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreq'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('Res',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FreqMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='FilterC',
    type=50,
    height=4,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Lp',           nm1conncolors.audio),
      OutputType('Bp',           nm1conncolors.audio),
      OutputType('Hp',           nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreq'
        ),
      ),
      ParameterType('Res',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('GainControl',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='FilterE',
    type=51,
    height=6,
    inputs=[
      InputType('FreqMod1',     nm1conncolors.audio),
      InputType('ResMod',       nm1conncolors.audio),
      InputType('In',           nm1conncolors.audio),
      InputType('FreqMod2',     nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('FilterType',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment='filtertype'
        ),
      ),
      ParameterType('GainControl',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('FreqMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreq'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('ResMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Res',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Slope',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='filterslope2'
        ),
      ),
      ParameterType('FreqMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='Multi-Env',
    type=52,
    height=7,
    inputs=[
      InputType('Gate',         nm1conncolors.logic),
      InputType('In',           nm1conncolors.audio),
      InputType('Amp',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Env',          nm1conncolors.control),
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Level1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Time1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Time2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Time3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Time4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Time5',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Sustain',
        ParameterDef(  
          default=0,
          low=0,
          high=4,
          comment='0 ~ off, 4 ~ level 4'
        ),
      ),
      ParameterType('Curve',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='0 ~ bipolar, 1 ~ uni/exp, 2 ~ uni/lin'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Sample&Hold',
    type=53,
    height=2,
    inputs=[
      InputType('Trig',         nm1conncolors.logic),
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='Quantizer',
    type=54,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Bits',
        ParameterDef(  
          default=0,
          low=0,
          high=12,
          comment='quantbits'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='InvLevShift',
    type=57,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='0 ~ bipolar, 1 ~ uni/neg, 2 ~ uni/pos'
        ),
      ),
      ParameterType('Inv',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='DrumSynth',
    type=58,
    height=9,
    inputs=[
      InputType('Trig',         nm1conncolors.logic),
      InputType('Vel',          nm1conncolors.control),
      InputType('Pitch',        nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Masterfreq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('SlaveRatio',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('MasterDecay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('SlaveDecay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('MasterLevel',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('SlaveLevel',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('NoiseFltFreq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('NoiseFltRes',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('NoiseFltSweep',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('NoiseFltDecay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('NoiseFltMode',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='filtertype1'
        ),
      ),
      ParameterType('BendAmount',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('BendDecay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Click',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Noise',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='CompareLev',
    type=59,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Clip',
    type=61,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('Clip',         nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('ClipMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Clip',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Sym',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Overdrive',
    type=62,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('OverdriveMod', nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('OverdriveMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Overdrive',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='KeyboardPatch',
    type=63,
    height=3,
    inputs=[],
    outputs=[
      OutputType('LatestNote',   nm1conncolors.control),
      OutputType('PatchGate',    nm1conncolors.logic),
      OutputType('LatestVelOn',  nm1conncolors.control),
      OutputType('LatestRelVel', nm1conncolors.control),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='NegEdgeDelay',
    type=64,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='logictime'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='MIDIGlobal',
    type=65,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Clk',          nm1conncolors.logic),
      OutputType('Sync',         nm1conncolors.logic),
      OutputType('Active',       nm1conncolors.logic),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='ControlMixer',
    type=66,
    height=2,
    inputs=[
      InputType('In1',          nm1conncolors.control),
      InputType('In2',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Inv1',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Level1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Inv2',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Level2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='0 ~ lin, 1 ~ exp'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='NoteDetect',
    type=67,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Gate',         nm1conncolors.logic),
      OutputType('Velocity',     nm1conncolors.control),
      OutputType('Releasevelocity',nm1conncolors.control),
    ],
    params=[
      ParameterType('Note',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='ClkGen',
    type=68,
    height=3,
    inputs=[
      InputType('Rst',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('24Pulses/Beat',nm1conncolors.logic),
      OutputType('4Pulses/Beat', nm1conncolors.logic),
      OutputType('Slv',          nm1conncolors.slave),
      OutputType('Sync',         nm1conncolors.logic),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('On/Off',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='ClkDiv',
    type=69,
    height=2,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Rst',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Divider',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='logicdiv'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LogicInv',
    type=70,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='EnvFollower',
    type=71,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Release',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='NoteScaler',
    type=72,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Transpose',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LogicProc',
    type=73,
    height=2,
    inputs=[
      InputType('In1',          nm1conncolors.logic),
      InputType('In2',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.logic),
    ],
    params=[
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='0 ~ and, 1 ~ or, 2 ~ xor'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='WaveWrap',
    type=74,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('WrapMod',      nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('WrapMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Wrap',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='NoteQuant',
    type=75,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Notes',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ off'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='OnOff',
    type=76,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('On',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='ClkDivFix',
    type=77,
    height=2,
    inputs=[
      InputType('Reset',        nm1conncolors.logic),
      InputType('MidiClock',    nm1conncolors.logic),
    ],
    outputs=[
      OutputType('16',           nm1conncolors.logic),
      OutputType('T8',           nm1conncolors.logic),
      OutputType('8',            nm1conncolors.logic),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='Delay',
    type=78,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('Modulation',   nm1conncolors.control),
    ],
    outputs=[
      OutputType('2.65MsFixedDelay',nm1conncolors.audio),
      OutputType('VariableDelayOut',nm1conncolors.audio),
    ],
    params=[
      ParameterType('Modulation',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Time',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 0 ms, 127 ~ 2.65 ms'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='4-1Switch',
    type=79,
    height=3,
    inputs=[
      InputType('In1',          nm1conncolors.audio),
      InputType('In2',          nm1conncolors.audio),
      InputType('In3',          nm1conncolors.audio),
      InputType('In4',          nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Sel',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment=''
        ),
      ),
      ParameterType('Level1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LFOSlvA',
    type=80,
    height=4,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('Reset',        nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
      ParameterType('Phase',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='phase'
        ),
      ),
      ParameterType('Waveform',
        ParameterDef(  
          default=0,
          low=0,
          high=4,
          comment='lfoshape'
        ),
      ),
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunitslfo'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='Amplifier',
    type=81,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Gain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='ampgain'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Diode',
    type=82,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='0 ~ off, 1 ~ half wave, 2 ~ full wave'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Shaper',
    type=83,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=4,
          comment='0 ~ log2, 1 ~ log1, 2 ~ lin, 3 ~ exp1, 4 ~ exp2'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='AD-Env',
    type=84,
    height=3,
    inputs=[
      InputType('Trigger',      nm1conncolors.logic),
      InputType('In',           nm1conncolors.audio),
      InputType('Amp',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Envelope',     nm1conncolors.control),
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Decay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='adsrtime'
        ),
      ),
      ParameterType('Gate',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='OscSlvFM',
    type=85,
    height=3,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('FmMod',        nm1conncolors.audio),
      InputType('Sync',         nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('DetuneCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('DetuneFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('-3Oct',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='FilterA',
    type=86,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreqAB'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='FilterB',
    type=87,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreqAB'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='1-4Switch',
    type=88,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out1',         nm1conncolors.audio),
      OutputType('Out2',         nm1conncolors.audio),
      OutputType('Out3',         nm1conncolors.audio),
      OutputType('Out4',         nm1conncolors.audio),
    ],
    params=[
      ParameterType('Sel',
        ParameterDef(  
          default=0,
          low=0,
          high=3,
          comment='0 ~ out1, 3 ~ out4'
        ),
      ),
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='CompareAB',
    type=89,
    height=2,
    inputs=[
      InputType('A',            nm1conncolors.control),
      InputType('B',            nm1conncolors.control),
    ],
    outputs=[
      OutputType('A>=B',         nm1conncolors.logic),
    ],
    params=[],
    modes=[],
  ),
  ModuleType(
    shortnm='NoteSeqB',
    type=90,
    height=9,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Rst',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
      OutputType('Snc',          nm1conncolors.logic),
      OutputType('Link',         nm1conncolors.logic),
      OutputType('Gclk',         nm1conncolors.logic),
    ],
    params=[
      ParameterType('Note1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note5',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note6',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note7',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note8',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note9',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note10',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note11',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note12',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note13',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note14',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note15',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Note16',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Length',
        ParameterDef(  
          default=0,
          low=0,
          high=15,
          comment=''
        ),
      ),
      ParameterType('Currentstep',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='editpos'
        ),
      ),
      ParameterType('Record',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Play',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Loop',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('Zoomfactor',
        ParameterDef(  
          low=6,
          default=6,
          high=1,
          comment=''
        ),
      ),
      ModeType('Sliderposition',
        ParameterDef(  
          low=117,
          default=117,
          high=6,
          comment=''
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='CtrlSeq',
    type=91,
    height=7,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Rst',          nm1conncolors.logic),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
      OutputType('Snc',          nm1conncolors.logic),
      OutputType('Link',         nm1conncolors.logic),
    ],
    params=[
      ParameterType('Ctrl1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl3',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl4',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl5',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl6',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl7',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl8',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl9',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl10',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl11',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl12',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl13',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl14',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl15',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Ctrl16',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Length',
        ParameterDef(  
          default=0,
          low=0,
          high=15,
          comment=''
        ),
      ),
      ParameterType('Uni',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Loop',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='FilterF',
    type=92,
    height=6,
    inputs=[
      InputType('FreqMod1',     nm1conncolors.control),
      InputType('FreqMod2',     nm1conncolors.control),
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='filterfreq'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqkbt'
        ),
      ),
      ParameterType('Res',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FreqMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FreqMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Slope',
        ParameterDef(  
          default=0,
          low=0,
          high=2,
          comment='filtertype1'
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='StereoChorus',
    type=94,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Outleft',      nm1conncolors.audio),
      OutputType('Outright',     nm1conncolors.audio),
    ],
    params=[
      ParameterType('Detune',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Amount',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PercOsc',
    type=95,
    height=4,
    inputs=[
      InputType('Trig',         nm1conncolors.audio),
      InputType('Am',           nm1conncolors.audio),
      InputType('PitchMod',     nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 8.18 Hz, 127 ~ 12.54 kHz'
        ),
      ),
      ParameterType('Click',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Decay',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Punch',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('PitchMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='FormantOsc',
    type=96,
    height=4,
    inputs=[
      InputType('PitchMod1',    nm1conncolors.control),
      InputType('PitchMod2',    nm1conncolors.control),
      InputType('Timbre',       nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Timbre',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='MasterOsc',
    type=97,
    height=3,
    inputs=[
      InputType('PitchMod1',    nm1conncolors.control),
      InputType('PitchMod2',    nm1conncolors.control),
    ],
    outputs=[
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('PitchMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='KeyQuant',
    type=98,
    height=4,
    inputs=[
      InputType('In',           nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Range',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Cont',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('E',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('F',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('F#',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('G',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('G#',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('A',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('A#',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('B',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('C',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('C#',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('D',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('D#',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PatternGen',
    type=99,
    height=4,
    inputs=[
      InputType('Clk',          nm1conncolors.logic),
      InputType('Rst',          nm1conncolors.logic),
      InputType('Pattern&Bank', nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Pattern',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Bank',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('LowDelta',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Step',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Mono',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='KeyboardSplit',
    type=100,
    height=3,
    inputs=[
      InputType('Note',         nm1conncolors.control),
      InputType('Gate',         nm1conncolors.logic),
      InputType('Vel',          nm1conncolors.control),
    ],
    outputs=[
      OutputType('Note',         nm1conncolors.control),
      OutputType('Gate',         nm1conncolors.logic),
      OutputType('Vel',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Upper',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('Lower',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Phaser',
    type=102,
    height=7,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('FreqMod',      nm1conncolors.control),
      InputType('SpreadMod',    nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 62.9 s, 127 ~ 24.4 hHz'
        ),
      ),
      ParameterType('Lfo',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('FreqMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 100 Hz, 127 ~ 16 kHz'
        ),
      ),
      ParameterType('SpreadMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Feedback',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Peaks',
        ParameterDef(  
          default=0,
          low=0,
          high=5,
          comment='0 ~ 1 peak, 5 ~ 6 peaks'
        ),
      ),
      ParameterType('Spread',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Depth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='EqMid',
    type=103,
    height=4,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='eqfreq'
        ),
      ),
      ParameterType('Gain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='eqgain'
        ),
      ),
      ParameterType('Bandwidth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 2 oct, 64 ~ 1 oct, 127 ~ 0.02 oct'
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='EqShelving',
    type=104,
    height=4,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Freq',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='eqfreq'
        ),
      ),
      ParameterType('Gain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='eqgain'
        ),
      ),
      ParameterType('Mode',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='0 ~ low, 1 ~ high'
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Expander',
    type=105,
    height=7,
    inputs=[
      InputType('InLeft',       nm1conncolors.audio),
      InputType('InRight',      nm1conncolors.audio),
      InputType('Sidechain',    nm1conncolors.audio),
    ],
    outputs=[
      OutputType('OutLeft',      nm1conncolors.audio),
      OutputType('OutRight',     nm1conncolors.audio),
    ],
    params=[
      ParameterType('Attack',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='companderattack'
        ),
      ),
      ParameterType('Release',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='companderrelease'
        ),
      ),
      ParameterType('Treshold',
        ParameterDef(  
          default=0,
          low=0,
          high=84,
          comment='compandertreshold'
        ),
      ),
      ParameterType('Ratio',
        ParameterDef(  
          default=0,
          low=0,
          high=66,
          comment='companderratio'
        ),
      ),
      ParameterType('Gate',
        ParameterDef(  
          default=0,
          low=0,
          high=72,
          comment='compandergate'
        ),
      ),
      ParameterType('Hold',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='companderhold'
        ),
      ),
      ParameterType('Act',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mon',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Bypass',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='OscSineBank',
    type=106,
    height=10,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
      InputType('Mixin',        nm1conncolors.audio),
      InputType('Sync',         nm1conncolors.audio),
      InputType('Osc1Am',       nm1conncolors.audio),
      InputType('Osc2Am',       nm1conncolors.audio),
      InputType('Osc3Am',       nm1conncolors.audio),
      InputType('Osc4Am',       nm1conncolors.audio),
      InputType('Osc5Am',       nm1conncolors.audio),
      InputType('Osc6Am',       nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Osc1Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc1Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc1Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc2Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc2Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc2Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc3Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc3Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc3Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc4Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc4Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc4Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc5Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc5Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc5Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc6Coarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc6Fine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
      ParameterType('Osc6Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Osc1Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Osc2Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Osc3Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Osc4Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Osc5Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Osc6Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='SpectralOsc',
    type=107,
    height=5,
    inputs=[
      InputType('FmMod',        nm1conncolors.audio),
      InputType('PitchMod1',    nm1conncolors.control),
      InputType('PitchMod2',    nm1conncolors.control),
      InputType('ShapeMod',     nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
      OutputType('Slv',          nm1conncolors.slave),
    ],
    params=[
      ParameterType('FreqCoarse',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('FreqFine',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqfine'
        ),
      ),
      ParameterType('Shape',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Partials',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='0 ~ odd, 1 ~ all'
        ),
      ),
      ParameterType('PitchMod1',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('PitchMod2',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('FmMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('ShapeMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Kbt',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('Mute',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[
      ModeType('FreqDisplayUnits',
        ParameterDef(  
          low=1,
          default=1,
          high=0,
          comment='freqdisplunits'
        ),
      ),
    ],
  ),
  ModuleType(
    shortnm='Vocoder',
    type=108,
    height=8,
    inputs=[
      InputType('Control',      nm1conncolors.audio),
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Band1',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band2',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band3',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band4',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band5',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band6',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band7',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band8',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band9',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band10',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band11',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band12',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band13',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band14',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band15',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Band16',
        ParameterDef(  
          default=0,
          low=0,
          high=16,
          comment='vocoband'
        ),
      ),
      ParameterType('Outgain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('Emphasis',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
      ParameterType('Monitor',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='RandomGen',
    type=110,
    height=2,
    inputs=[
      InputType('Mst',          nm1conncolors.slave),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='lfoslvrate'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LevMult',
    type=111,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Gain',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Unipolar',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='LevAdd',
    type=112,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Level',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='unibi'
        ),
      ),
      ParameterType('Unipolar',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment=''
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='1to2Fade',
    type=113,
    height=2,
    inputs=[
      InputType('In',           nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out1',         nm1conncolors.audio),
      OutputType('Out2',         nm1conncolors.audio),
    ],
    params=[
      ParameterType('Mix',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='2to1Fade',
    type=114,
    height=2,
    inputs=[
      InputType('In1',          nm1conncolors.audio),
      InputType('In2',          nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Mix',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='symetric'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='NoteVelScal',
    type=115,
    height=4,
    inputs=[
      InputType('Velocity',     nm1conncolors.control),
      InputType('Note',         nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.control),
    ],
    params=[
      ParameterType('VelocitySensitivity',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('LeftGain',
        ParameterDef(  
          default=0,
          low=0,
          high=48,
          comment='velscalgain'
        ),
      ),
      ParameterType('Breakpoint',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='freqcoarse'
        ),
      ),
      ParameterType('RightGain',
        ParameterDef(  
          default=0,
          low=0,
          high=48,
          comment='velscalgain'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='RingMod',
    type=117,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('Mod',          nm1conncolors.audio),
      InputType('ModDepth',     nm1conncolors.audio),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('ModDepth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('RingmodDepth',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 0, 64 ~ AM, 127 ~ RM'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='Digitizer',
    type=118,
    height=3,
    inputs=[
      InputType('In',           nm1conncolors.audio),
      InputType('RateMod',      nm1conncolors.control),
    ],
    outputs=[
      OutputType('Out',          nm1conncolors.audio),
    ],
    params=[
      ParameterType('Bits',
        ParameterDef(  
          default=0,
          low=0,
          high=11,
          comment='quantbits'
        ),
      ),
      ParameterType('Rate',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment='0 ~ 34.65 Hz, 127 ~ 50.18 kHz'
        ),
      ),
      ParameterType('RateMod',
        ParameterDef(  
          default=0,
          low=0,
          high=127,
          comment=''
        ),
      ),
      ParameterType('QuantOff',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
      ParameterType('SamplingOff',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
  ModuleType(
    shortnm='PolyAreaIn',
    type=127,
    height=2,
    inputs=[],
    outputs=[
      OutputType('Left',         nm1conncolors.audio),
      OutputType('Right',        nm1conncolors.audio),
    ],
    params=[
      ParameterType('+6Db',
        ParameterDef(  
          default=0,
          low=0,
          high=1,
          comment='onoff'
        ),
      ),
    ],
    modes=[],
  ),
]

fromtype = {}
fromname = {}
modulemap = Struct()
for module in modules:
  fromname[module.shortnm] = module
  fromtype[module.type] = module
  shortnm = module.shortnm.replace('-','_').replace('&','n').replace(' ','_')
  setattr(modulemap, shortnm, module)

if __name__ == '__main__':
  for module in modules:
    print '%s.type: %d(0x%02x)' % (module.shortnm, module.type, module.type)
    for i in range(len(module.inputs)):
      input = module.inputs[i]
      print ' .inputs[%d] .%s' % (i, input.name)
    for i in range(len(module.outputs)):
      output = module.outputs[i]
      print ' .outputs[%d] .%s' % (i, output.name)
    for i in range(len(module.params)):
      param = module.params[i]
      print ' .params[%d] .%s' % (i, param.name)
    for i in range(len(module.modes)):
      mode = module.modes[i]
      print ' .modes[%d] .%s' % (i, mode.name)
